/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.base.service.impl;

import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.CycleBuyDeliveryTypeEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.constants.RateByMonthEnum;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.request.ItemCycleBuyReqDto;
import com.dtyunxi.yundt.cube.center.item.api.base.dto.response.ItemCycleBuyRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.base.service.IItemCycleBuyService;
import com.dtyunxi.yundt.cube.center.item.dao.cyclebuy.das.ItemCycleBuyDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.cyclebuy.ItemCycleBuyEo;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service(value="cycleBuyServiceImpl")
public class ItemCycleBuyServiceImpl
implements IItemCycleBuyService {
    @Resource
    private ItemCycleBuyDas itemCycleBuyDas;

    @Override
    public void addItemCycleBuy(ItemCycleBuyReqDto itemCycleBuyReqDto) {
        ItemCycleBuyEo itemCycleBuyEo = new ItemCycleBuyEo();
        CubeBeanUtils.copyProperties((Object)itemCycleBuyEo, (Object)itemCycleBuyReqDto, (String[])new String[]{"deliveryRate"});
        if (CycleBuyDeliveryTypeEnum.BY_MONTH.getCode() == itemCycleBuyReqDto.getDeliveryType().intValue() && ArrayUtils.isEmpty((Object[])itemCycleBuyReqDto.getDeliveryRate())) {
            String deliveryRate = Stream.of(RateByMonthEnum.values()).map(e -> String.valueOf(e.getCode())).collect(Collectors.joining(","));
            itemCycleBuyEo.setDeliveryRate(deliveryRate);
        } else {
            itemCycleBuyEo.setDeliveryRate(StringUtils.join((Object[])itemCycleBuyReqDto.getDeliveryRate(), (String)","));
        }
        this.itemCycleBuyDas.insert((BaseEo)itemCycleBuyEo);
    }

    @Override
    public List<ItemCycleBuyRespDto> getCycleBuyByShopItem(Long shopId, Long itemId, Integer deliveryType) {
        ItemCycleBuyEo itemCycleBuyEoParam = ItemCycleBuyEo.newInstance();
        itemCycleBuyEoParam.setShopId(shopId);
        itemCycleBuyEoParam.setItemId(itemId);
        itemCycleBuyEoParam.setDeliveryType(deliveryType);
        List eoList = this.itemCycleBuyDas.select((BaseEo)itemCycleBuyEoParam);
        LinkedList list = Lists.newLinkedList();
        if (CollectionUtils.isNotEmpty((Collection)eoList)) {
            eoList.forEach(itemCycleBuy -> {
                ItemCycleBuyRespDto dto = new ItemCycleBuyRespDto();
                CubeBeanUtils.copyProperties((Object)dto, (Object)itemCycleBuy, (String[])new String[]{"deliveryRate"});
                if (StringUtils.isNotBlank((CharSequence)itemCycleBuy.getDeliveryRate())) {
                    dto.setDeliveryRate((Integer[])Stream.of(StringUtils.split((String)itemCycleBuy.getDeliveryRate(), (String)",")).map(Integer::valueOf).toArray(Integer[]::new));
                }
                list.add(dto);
            });
        }
        return list;
    }

    @Override
    public List<ItemCycleBuyRespDto> getCycleBuyByShopItem(long shopId, long itemId) {
        return this.getCycleBuyByShopItem(shopId, itemId, null);
    }

    @Override
    public void removeCycleBuyByShopItem(Long shopId, Long itemId) {
        ItemCycleBuyEo itemCycleBuyEoParam = ItemCycleBuyEo.newInstance();
        itemCycleBuyEoParam.setShopId(shopId);
        itemCycleBuyEoParam.setItemId(itemId);
        this.itemCycleBuyDas.delete((BaseEo)itemCycleBuyEoParam);
    }
}

