/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.item.biz.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.biz.commons.utils.Assert;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.ItemStatusReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemQueryDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.request.PcpItemReqDto;
import com.dtyunxi.yundt.cube.center.item.api.dto.response.PcpItemRespDto;
import com.dtyunxi.yundt.cube.center.item.biz.service.IItemExtendService;
import com.dtyunxi.yundt.cube.center.item.biz.service.IPcpItemService;
import com.dtyunxi.yundt.cube.center.item.biz.util.SqlFilterBuilder;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.ItemDas;
import com.dtyunxi.yundt.cube.center.item.dao.base.das.UnitDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtDas;
import com.dtyunxi.yundt.cube.center.item.dao.das.ItemExtendDas;
import com.dtyunxi.yundt.cube.center.item.dao.eo.ItemExtendEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.PcpItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.ItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdItemSkuEo;
import com.dtyunxi.yundt.cube.center.item.dao.eo.base.StdUnitEo;
import com.github.pagehelper.PageInfo;
import icu.mhb.mybatisplus.plugln.core.JoinLambdaWrapper;
import icu.mhb.mybatisplus.plugln.core.JoinWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.transaction.annotation.Transactional;

public abstract class AbstractPcpItemAdaptorServiceImpl
implements IPcpItemService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractPcpItemAdaptorServiceImpl.class);
    @Resource
    private ItemExtendDas itemExtendDas;
    @Resource(name="${yunxi.dg.base.project:tcbj}ItemExtendService")
    private IItemExtendService iItemExtendService;
    @Resource
    private UnitDas unitDas;
    @Resource
    private ItemDas itemDas;
    @Resource
    private ItemExtDas itemExtDas;

    @Override
    public Long addPcpItem(PcpItemReqDto addReqDto) {
        Assert.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)addReqDto.getCode()), (String)"1", (String)"\u5546\u54c1\u7f16\u7801\u5f02\u5e38");
        PcpItemEo pcpItemEo = new PcpItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)pcpItemEo);
        ItemExtendEo extendEo = (ItemExtendEo)this.itemExtendDas.selectByLogicKey((Object)addReqDto.getCode());
        if (extendEo != null && extendEo.getId() != null) {
            BeanUtils.copyProperties((Object)addReqDto, (Object)extendEo);
            this.itemExtendDas.updateSelective((BaseEo)extendEo);
            return extendEo.getId();
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setItemCode(addReqDto.getCode());
        BeanUtils.copyProperties((Object)addReqDto, (Object)itemExtendEo);
        this.itemExtendDas.insert((BaseEo)itemExtendEo);
        this.publishItemSyncEvent(itemExtendEo);
        return pcpItemEo.getId();
    }

    @Override
    public void modifyPcpItem(PcpItemReqDto pcpItemReqDto) {
        if (StringUtils.isEmpty((CharSequence)pcpItemReqDto.getLongCode())) {
            return;
        }
        ItemExtendEo itemExtendEo = new ItemExtendEo();
        itemExtendEo.setItemCode(pcpItemReqDto.getLongCode());
        itemExtendEo = (ItemExtendEo)this.itemExtendDas.selectOne((BaseEo)itemExtendEo);
        if (Objects.isNull(itemExtendEo)) {
            return;
        }
        itemExtendEo.setExpirationDate(pcpItemReqDto.getExpirationDate());
        itemExtendEo.setExpirationUnit(pcpItemReqDto.getExpirationUnit());
        itemExtendEo.setCfproducers(pcpItemReqDto.getCfproducers());
        this.itemExtendDas.updateSelective((BaseEo)itemExtendEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removePcpItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.itemExtendDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public PcpItemRespDto queryById(Long id) {
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).eq(BaseEo::getId, (Object)id)).selectAll()).orderByDesc(BaseEo::getCreateTime)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(BaseEo::getId, "itemId").add(StdItemEo::getCode, "code"))).end().leftJoin(ItemSkuEo.class, StdItemSkuEo::getCode, ItemExtendEo::getItemCode).selectAs(a -> a.add(StdItemSkuEo::getBarCode, "barCode"))).end();
        return Optional.ofNullable(this.iItemExtendService.joinGetOne((Wrapper)wrapper, PcpItemRespDto.class)).map(it -> {
            it.setUnit(it.getUnitId());
            it.setLongCode(it.getItemCode());
            return it;
        }).orElse(null);
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        return null;
    }

    @Override
    public PcpItemEo selectByPrimaryKey(Long id) {
        logger.info("\u6839\u636eid\u67e5\u8be2\u4fe1\u606f\u53c2\u6570\uff1a[id:{}]", (Object)id);
        if (Objects.isNull(id)) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return null;
    }

    protected PageInfo<PcpItemRespDto> getPcpItemRespDtoPageInfo(PcpItemQueryDto queryDto, IPage<PcpItemRespDto> page) {
        List dtoList = Optional.ofNullable(page.getRecords()).orElse(Lists.newArrayList());
        PageInfo pageInfo = new PageInfo(dtoList.stream().peek(d -> {
            d.setLongCode(d.getItemCode());
            d.setUnit(d.getUnitId());
        }).collect(Collectors.toList()));
        pageInfo.setPageNum(queryDto.getPageNum().intValue());
        pageInfo.setPageSize(queryDto.getPageSize().intValue());
        pageInfo.setPages((int)page.getPages());
        pageInfo.setTotal(page.getTotal());
        return pageInfo;
    }

    private String getUnit(Long id) {
        return Optional.ofNullable(id).map(arg_0 -> ((UnitDas)this.unitDas).selectByPrimaryKey(arg_0)).map(StdUnitEo::getCode).orElse("");
    }

    @Override
    public PageInfo<PcpItemRespDto> queryByPageByCondition(PcpItemQueryDto queryDto) {
        return this.queryByPage(queryDto);
    }

    @Override
    public List<PcpItemEo> queryByParam(PcpItemQueryDto queryDto) {
        return null;
    }

    @Override
    public List<PcpItemRespDto> queryByItemCodes(List<String> itemCodes) {
        if (CollectionUtils.isEmpty(itemCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List items = this.itemDas.select((BaseEo)SqlFilterBuilder.create(ItemEo.class).in("code", itemCodes).eo());
        return this.getPcpItemRespDtos(items);
    }

    @Override
    public List<PcpItemRespDto> queryByItemLongCodes(List<String> itemLongCodes) {
        if (CollectionUtils.isEmpty(itemLongCodes)) {
            throw new BizException("\u5546\u54c1\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        JoinLambdaWrapper wrapper = ((JoinWrapper)((JoinWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)((JoinLambdaWrapper)new JoinLambdaWrapper(ItemExtendEo.class).in(ItemExtendEo::getItemCode, itemLongCodes)).selectAll()).orderByDesc(BaseEo::getCreateTime)).leftJoin(ItemEo.class, StdItemEo::getLongCode, ItemExtendEo::getItemCode).eq(BaseEo::getDr, (Object)0)).selectAs(a -> a.add(StdItemEo::getSubType, "itemType").add(StdItemEo::getStatus, "itemStatus").add(StdItemEo::getName, "name").add(StdItemEo::getLongCode, "barCode").add(BaseEo::getId, "itemId"))).end();
        return this.iItemExtendService.joinList((Wrapper)wrapper, PcpItemRespDto.class).stream().peek(r -> r.setLongCode(r.getItemCode())).collect(Collectors.toList());
    }

    @Override
    public void pushWms(List<String> itemLongCodes) {
        ((ExtQueryChainWrapper)this.itemExtendDas.filter().in((Object)"item_code", itemLongCodes)).list().forEach(this::publishItemSyncEvent);
    }

    @Override
    public void revampItemStatus(ItemStatusReqDto itemStatusReqDto) {
        if (CollectionUtils.isEmpty((Collection)itemStatusReqDto.getIds())) {
            throw new BizException("id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        for (Long id : itemStatusReqDto.getIds()) {
            ExtQueryChainWrapper filter = this.itemExtendDas.filter();
            filter.eq((Object)"id", (Object)id);
            String itemCode = (String)filter.list().stream().map(ItemExtendEo::getItemCode).collect(Collectors.toList()).get(0);
            if (itemCode == null) continue;
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.eq(StdItemEo::getLongCode, (Object)itemCode)).eq(BaseEo::getDr, (Object)0);
            ItemEo itemEo = new ItemEo();
            itemEo.setLongCode(itemCode);
            itemEo.setStatus(itemStatusReqDto.getAuditResult());
            this.itemDas.getMapper().update((Object)itemEo, (Wrapper)queryWrapper);
        }
    }

    @Override
    public PageInfo<PcpItemRespDto> queryPageParams(PcpItemQueryDto pcpItemQueryDto) {
        logger.info("\u5546\u54c1\u4e3b\u6570\u636e\u5206\u9875\u5217\u8868\u67e5\u8be2\uff1a{}", (Object)JSON.toJSONString((Object)pcpItemQueryDto));
        if (ObjectUtil.isEmpty((Object)pcpItemQueryDto.getPageNum())) {
            pcpItemQueryDto.setPageNum(Integer.valueOf(1));
        }
        if (ObjectUtil.isEmpty((Object)pcpItemQueryDto.getPageSize())) {
            pcpItemQueryDto.setPageSize(Integer.valueOf(10));
        }
        return this.itemExtDas.queryPageParams(pcpItemQueryDto);
    }

    private List<PcpItemRespDto> getPcpItemRespDtos(List<ItemEo> items) {
        if (CollectionUtils.isEmpty(items)) {
            return Lists.newArrayList();
        }
        Map extendMap = this.itemExtendDas.select((BaseEo)Objects.requireNonNull(SqlFilterBuilder.create(ItemExtendEo.class)).in("item_code", items.stream().map(StdItemEo::getLongCode).collect(Collectors.toSet())).eo()).stream().collect(Collectors.toMap(ItemExtendEo::getItemCode, Function.identity()));
        return items.stream().map(item -> this.buildPcpItemResp(extendMap, (ItemEo)item)).collect(Collectors.toList());
    }

    private PcpItemRespDto buildPcpItemResp(Map<String, ItemExtendEo> extendMap, ItemEo item) {
        PcpItemRespDto pcpItemRespDto = new PcpItemRespDto();
        BeanUtils.copyProperties((Object)item, (Object)pcpItemRespDto);
        pcpItemRespDto.setItemType(Long.valueOf(item.getType().longValue()));
        pcpItemRespDto.setItemStatus(Long.valueOf(item.getStatus().longValue()));
        ItemExtendEo itemExtendEo = extendMap.get(item.getLongCode());
        if (!Objects.isNull(itemExtendEo)) {
            BeanUtils.copyProperties((Object)itemExtendEo, (Object)pcpItemRespDto);
        }
        pcpItemRespDto.setId(item.getId());
        return pcpItemRespDto;
    }
}

