/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.rest;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.api.IDgCustomerApi;
import com.yunxi.dg.base.center.customer.api.query.IDgCustomerQueryApi;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerStatusDomain;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerInfoReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchBaseReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchPageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerSearchReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgExportRecordReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgVerifyCertificationDto;
import com.yunxi.dg.base.center.customer.dto.request.DgVerifyCertificationResultDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerNameSimpleRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerStatusEo;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dg/customer"})
public class DgCustomerRest
implements IDgCustomerApi,
IDgCustomerQueryApi {
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;
    @Resource
    private IDgCustomerStatusDomain iDgCustomerStatusDomain;
    @Resource
    private IDgCustomerApi iDgCustomerApi;
    @Resource
    private IDgCustomerQueryApi iDgCustomerQueryApi;

    public RestResponse<Long> add(@RequestBody DgCustomerReqDto reqDto) {
        return this.iDgCustomerApi.add(reqDto);
    }

    public RestResponse<Void> update(@RequestBody DgCustomerReqDto reqDto) {
        return this.iDgCustomerApi.update(reqDto);
    }

    public RestResponse<Void> updateAccountStatus(@Valid DgCustomerReqDto reqDto) {
        return this.iDgCustomerApi.updateAccountStatus(reqDto);
    }

    public RestResponse<Void> moveCustomerToRegion(@RequestParam(value="sourceRegionCode") String sourceRegionCode, @RequestParam(value="targetRegionCode") String targetRegionCode) {
        return this.iDgCustomerApi.moveCustomerToRegion(sourceRegionCode, targetRegionCode);
    }

    public RestResponse<Void> saveCustomerExportRecord(@Valid @RequestBody DgExportRecordReqDto reqDto) {
        return this.iDgCustomerApi.saveCustomerExportRecord(reqDto);
    }

    public RestResponse<DgCustomerRespDto> queryByCode(String code) {
        return this.iDgCustomerQueryApi.queryByCode(code);
    }

    public RestResponse<DgCustomerRespDto> queryById(@PathVariable(value="id") Long id) {
        return this.iDgCustomerQueryApi.queryById(id);
    }

    public RestResponse<List<DgCustomerNameSimpleRespDto>> queryListByIds(@RequestParam(name="ids", required=true) List<Long> ids) {
        return this.iDgCustomerQueryApi.queryListByIds(ids);
    }

    public RestResponse<PageInfo<DgCustomerRespDto>> queryByPage(@RequestParam(name="filter", required=false) String filter, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        return this.iDgCustomerQueryApi.queryByPage(filter, pageNum, pageSize);
    }

    public RestResponse<PageInfo<DgCustomerRespDto>> queryByPageOnPost(DgCustomerSearchReqDto searchReqDto, Integer pageNum, Integer pageSize) {
        return this.iDgCustomerQueryApi.queryByPageOnPost(searchReqDto, pageNum, pageSize);
    }

    public RestResponse<List<DgCustomerRespDto>> queryByList(@RequestParam(name="filter", required=false) String filter) {
        return this.iDgCustomerQueryApi.queryByList(filter);
    }

    public RestResponse<List<DgCustomerRespDto>> queryPostByList(@RequestBody DgCustomerSearchReqDto searchReqDto) {
        return this.iDgCustomerQueryApi.queryPostByList(searchReqDto);
    }

    public RestResponse<List<Long>> queryIdsBySingleFilter(DgCustomerSearchBaseReqDto customerSearchReqDto) {
        return this.iDgCustomerQueryApi.queryIdsBySingleFilter(customerSearchReqDto);
    }

    public RestResponse<List<Long>> getCurrentUserOrOrgCustomer(Long userId, Long orgId) {
        return this.iDgCustomerQueryApi.getCurrentUserOrOrgCustomer(userId, orgId);
    }

    public RestResponse<List<DgCustomerNameSimpleRespDto>> queryByListParent(Long customerId) {
        return this.iDgCustomerQueryApi.queryByListParent(customerId);
    }

    public RestResponse<String> queryExcelDownloadUrl() {
        return this.iDgCustomerQueryApi.queryExcelDownloadUrl();
    }

    @GetMapping(value={"/test"}, produces={"application/json"})
    RestResponse<Void> test() {
        DgCustomerEo customerEo = (DgCustomerEo)this.iDgCustomerDomain.selectByPrimaryKey(Long.valueOf(1255149301021517831L));
        DgCustomerRespDto customerRespDto = new DgCustomerRespDto();
        DtoHelper.eo2Dto((BaseEo)customerEo, (BaseVo)customerRespDto);
        DgCustomerStatusEo customerStatusEo = (DgCustomerStatusEo)this.iDgCustomerStatusDomain.selectByPrimaryKey(customerEo.getStatusId());
        customerRespDto.setId(customerEo.getId());
        customerRespDto.setCode(customerEo.getCode());
        customerRespDto.setName(customerEo.getName());
        customerRespDto.setCustomerTypeName("setCustomerTypeName");
        customerRespDto.setCustomerTypeId(customerEo.getCustomerTypeId());
        customerRespDto.setRegionId(customerEo.getRegionId());
        customerRespDto.setRegionCode(customerEo.getRegionCode());
        customerRespDto.setRegion("797979");
        customerRespDto.setStatusId(customerEo.getStatusId());
        customerRespDto.setStatusName(customerStatusEo.getName());
        customerRespDto.setCustomerId(customerEo.getId());
        customerRespDto.setId(customerEo.getId());
        this.commonsMqService.sendSingleMessage("CUSTOMER_UPDATE", (Object)customerRespDto);
        return new RestResponse();
    }

    public RestResponse<List<DgCustomerRespDto>> queryCustomerRespDto(@RequestParam(name="shopIds", required=false) List<Long> shopIds) {
        return this.iDgCustomerQueryApi.queryCustomerRespDto(shopIds);
    }

    public RestResponse<DgVerifyCertificationResultDto> verifyCertification(@Validated @RequestBody DgVerifyCertificationDto verifyCertificationDto) {
        return this.iDgCustomerQueryApi.verifyCertification(verifyCertificationDto);
    }

    public RestResponse<PageInfo<DgCustomerRespDto>> queryDataByPage(@Validated @RequestBody DgCustomerSearchPageReqDto searchReqDto) {
        return this.iDgCustomerQueryApi.queryDataByPage(searchReqDto);
    }

    public RestResponse<Void> modifyCustomerUserIdByThirdPartyId(@Validated @RequestBody List<DgCustomerReqDto> reqDtos) {
        return this.iDgCustomerApi.modifyCustomerUserIdByThirdPartyId(reqDtos);
    }

    public RestResponse<Void> batchAdd(@Validated @RequestBody List<DgCustomerReqDto> reqDtoList) {
        return this.iDgCustomerApi.batchAdd(reqDtoList);
    }

    public RestResponse<Void> batchUpdateStatus(@Valid @RequestBody DgCustomerInfoReqDto customerInfoReqDto) {
        return this.iDgCustomerApi.batchUpdateStatus(customerInfoReqDto);
    }
}

