/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCsShipmentEnterpriseDomain;
import com.yunxi.dg.base.center.customer.dto.enums.CsGenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterprisePageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsShipmentEnterpriseReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgSupplierReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsShipmentEnterpriseRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCsShipmentEnterpriseEo;
import com.yunxi.dg.base.center.customer.service.IDgCsShipmentEnterpriseService;
import com.yunxi.dg.base.center.customer.utils.GenerateCodeUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DgCsShipmentEnterpriseServiceImpl
implements IDgCsShipmentEnterpriseService {
    @Resource
    private IDgCsShipmentEnterpriseDomain dgCsShipmentEnterpriseDomain;

    @Override
    public Long insert(DgCsShipmentEnterpriseReqDto dto) {
        this.validData(dto);
        if (StringUtils.isEmpty((String)dto.getCode())) {
            dto.setCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.LOGISTICS.getCode()).getCode());
        }
        DgCsShipmentEnterpriseEo enterpriseEo = new DgCsShipmentEnterpriseEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)enterpriseEo);
        this.dgCsShipmentEnterpriseDomain.insert((BaseEo)enterpriseEo);
        return enterpriseEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDataById(DgCsShipmentEnterpriseReqDto dto) {
        if (null == dto.getId()) {
            return null;
        }
        this.validData(dto);
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setId(dto.getId());
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseEo csShipmentEnterpriseEo = new DgCsShipmentEnterpriseEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)csShipmentEnterpriseEo);
            csShipmentEnterpriseEo.setId(enterpriseEo.getId());
            this.dgCsShipmentEnterpriseDomain.updateSelective((BaseEo)csShipmentEnterpriseEo);
            return enterpriseEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusById(DgCsShipmentEnterpriseReqDto dto) {
        if (null == dto.getId()) {
            return null;
        }
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setId(dto.getId());
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseEo csShipmentEnterpriseEo = new DgCsShipmentEnterpriseEo();
            csShipmentEnterpriseEo.setId(enterpriseEo.getId());
            csShipmentEnterpriseEo.setShipmentEnterpriseStatus(dto.getShipmentEnterpriseStatus());
            this.dgCsShipmentEnterpriseDomain.updateSelective((BaseEo)csShipmentEnterpriseEo);
            return enterpriseEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateDataByCode(DgCsShipmentEnterpriseReqDto dto) {
        Assert.hasText((String)dto.getCode(), (String)DgCustomerExceptionCode.LOGISTICS_CODE_NULL.getMsg());
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setCode(dto.getCode());
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseEo csShipmentEnterpriseEo = new DgCsShipmentEnterpriseEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)csShipmentEnterpriseEo);
            csShipmentEnterpriseEo.setId(enterpriseEo.getId());
            if (CollectionUtils.isNotEmpty((Collection)dto.getLogisticsTypeList())) {
                enterpriseEo.setLogisticsType(StringUtils.join((Object[])dto.getLogisticsTypeList().toArray(), (String)","));
            }
            this.dgCsShipmentEnterpriseDomain.updateSelective((BaseEo)csShipmentEnterpriseEo);
            return enterpriseEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusByCode(DgCsShipmentEnterpriseReqDto dto) {
        Assert.hasText((String)dto.getCode(), (String)DgCustomerExceptionCode.LOGISTICS_CODE_NULL.getMsg());
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setCode(dto.getCode());
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseEo csShipmentEnterpriseEo = new DgCsShipmentEnterpriseEo();
            csShipmentEnterpriseEo.setShipmentEnterpriseStatus(dto.getShipmentEnterpriseStatus());
            csShipmentEnterpriseEo.setId(enterpriseEo.getId());
            this.dgCsShipmentEnterpriseDomain.updateSelective((BaseEo)csShipmentEnterpriseEo);
            return enterpriseEo.getId();
        }
        return null;
    }

    @Override
    public void batchInsert(List<DgCsShipmentEnterpriseReqDto> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList<DgCsShipmentEnterpriseEo> enterpriseEoList = new ArrayList<DgCsShipmentEnterpriseEo>();
            for (DgCsShipmentEnterpriseReqDto reqDto : dtoList) {
                DgCsShipmentEnterpriseEo csShipmentEnterpriseEo = new DgCsShipmentEnterpriseEo();
                DtoHelper.dto2Eo((BaseVo)reqDto, (BaseEo)csShipmentEnterpriseEo);
                if (StringUtils.isEmpty((String)reqDto.getCode())) {
                    csShipmentEnterpriseEo.setCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.LOGISTICS.getCode()).getCode());
                }
                enterpriseEoList.add(csShipmentEnterpriseEo);
            }
            if (CollectionUtils.isNotEmpty(enterpriseEoList)) {
                this.dgCsShipmentEnterpriseDomain.insertBatch(enterpriseEoList);
            }
        }
    }

    @Override
    public void updateStatusByCodeList(DgSupplierReqDto dto) {
        AssertUtils.notEmpty((Collection)dto.getCodeList(), (String)"\u7269\u6d41\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DgCsShipmentEnterprisePageReqDto reqDto = new DgCsShipmentEnterprisePageReqDto();
        reqDto.setCodeList(dto.getCodeList());
        List enterpriseEoList = this.dgCsShipmentEnterpriseDomain.queryListBySearchCon(reqDto);
        if (CollectionUtils.isNotEmpty((Collection)enterpriseEoList)) {
            for (DgCsShipmentEnterpriseEo enterpriseEo : enterpriseEoList) {
                enterpriseEo.setShipmentEnterpriseStatus(dto.getStatus());
                this.dgCsShipmentEnterpriseDomain.updateSelective((BaseEo)enterpriseEo);
            }
        }
    }

    @Override
    public PageInfo<DgCsShipmentEnterpriseRespDto> page(DgCsShipmentEnterprisePageReqDto dto) {
        PageInfo enterpriseEoPageInfo = this.dgCsShipmentEnterpriseDomain.queryPageBySearchCon(dto);
        if (CollectionUtils.isNotEmpty((Collection)enterpriseEoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)enterpriseEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList recordRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)enterpriseEoPageInfo.getList(), (Collection)recordRespDtos, DgCsShipmentEnterpriseRespDto.class);
            if (CollectionUtils.isNotEmpty((Collection)recordRespDtos)) {
                for (DgCsShipmentEnterpriseRespDto respDto : recordRespDtos) {
                    if (!StringUtils.isNotEmpty((String)respDto.getLogisticsType())) continue;
                    respDto.setLogisticsTypeList(Arrays.asList(respDto.getLogisticsType().split(",")));
                }
            }
            pageInfo.setList((List)recordRespDtos);
            return pageInfo;
        }
        return new PageInfo();
    }

    @Override
    public DgCsShipmentEnterpriseRespDto getDataById(Long id) {
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setId(id);
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseRespDto enterpriseRespDto = new DgCsShipmentEnterpriseRespDto();
            BeanUtils.copyProperties((Object)enterpriseEo, (Object)enterpriseRespDto);
            if (StringUtils.isNotEmpty((String)enterpriseEo.getLogisticsType())) {
                enterpriseRespDto.setLogisticsTypeList(Arrays.asList(enterpriseEo.getLogisticsType().split(",")));
            }
            return enterpriseRespDto;
        }
        return null;
    }

    @Override
    public DgCsShipmentEnterpriseRespDto getDataByCode(String code) {
        DgCsShipmentEnterpriseEo query = new DgCsShipmentEnterpriseEo();
        query.setCode(code);
        DgCsShipmentEnterpriseEo enterpriseEo = (DgCsShipmentEnterpriseEo)this.dgCsShipmentEnterpriseDomain.selectOne((BaseEo)query);
        if (null != enterpriseEo && null != enterpriseEo.getId()) {
            DgCsShipmentEnterpriseRespDto enterpriseRespDto = new DgCsShipmentEnterpriseRespDto();
            BeanUtils.copyProperties((Object)enterpriseEo, (Object)enterpriseRespDto);
            if (StringUtils.isNotEmpty((String)enterpriseEo.getLogisticsType())) {
                enterpriseRespDto.setLogisticsTypeList(Arrays.asList(enterpriseEo.getLogisticsType().split(",")));
            }
            return enterpriseRespDto;
        }
        return null;
    }

    private void validData(DgCsShipmentEnterpriseReqDto dto) {
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)dto.getContactPhone())) {
            String regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[6|7|8])|(18[0-9])|166|198|199)\\d{8}$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(dto.getContactPhone());
            boolean isMatch = m.matches();
            AssertUtils.isTrue((boolean)isMatch, (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }
}

