/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCsSupplierDomain;
import com.yunxi.dg.base.center.customer.dto.enums.CsGenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCsSupplierPageReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCsSupplierReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgSupplierReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCsSupplierRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCsSupplierEo;
import com.yunxi.dg.base.center.customer.service.IDgCsSupplierService;
import com.yunxi.dg.base.center.customer.utils.GenerateCodeUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class DgCsSupplierServiceImpl
implements IDgCsSupplierService {
    @Resource
    private IDgCsSupplierDomain dgCsSupplierDomain;

    @Override
    public Long insert(DgCsSupplierReqDto dto) {
        if (StringUtils.isEmpty((CharSequence)dto.getCode())) {
            dto.setCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.SUPPLIER.getCode()).getCode());
        }
        this.validSupplierData(dto);
        DgCsSupplierEo supplierEo = new DgCsSupplierEo();
        DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)supplierEo);
        this.dgCsSupplierDomain.insert((BaseEo)supplierEo);
        return supplierEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateById(DgCsSupplierReqDto dto) {
        if (null == dto.getId()) {
            return null;
        }
        this.validSupplierData(dto);
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setId(dto.getId());
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierEo supplierEo = new DgCsSupplierEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)supplierEo);
            supplierEo.setId(dgCsSupplierEo.getId());
            this.dgCsSupplierDomain.updateSelective((BaseEo)supplierEo);
            return dgCsSupplierEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateByCode(DgCsSupplierReqDto dto) {
        this.validSupplierData(dto);
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setCode(dto.getCode());
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierEo supplierEo = new DgCsSupplierEo();
            DtoHelper.dto2Eo((BaseVo)dto, (BaseEo)supplierEo);
            supplierEo.setId(dgCsSupplierEo.getId());
            this.dgCsSupplierDomain.updateSelective((BaseEo)supplierEo);
            return dgCsSupplierEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusById(DgCsSupplierReqDto dto) {
        if (null == dto.getId()) {
            return null;
        }
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setId(dto.getId());
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierEo supplierEo = new DgCsSupplierEo();
            supplierEo.setId(dgCsSupplierEo.getId());
            supplierEo.setStatus(dto.getStatus());
            this.dgCsSupplierDomain.updateSelective((BaseEo)supplierEo);
            return dgCsSupplierEo.getId();
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long updateStatusByCode(DgCsSupplierReqDto dto) {
        this.validSupplierData(dto);
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setCode(dto.getCode());
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierEo supplierEo = new DgCsSupplierEo();
            supplierEo.setStatus(dto.getStatus());
            supplierEo.setId(dgCsSupplierEo.getId());
            this.dgCsSupplierDomain.updateSelective((BaseEo)supplierEo);
            return dgCsSupplierEo.getId();
        }
        return null;
    }

    @Override
    public void batchInsert(List<DgCsSupplierReqDto> dtoList) {
        if (CollectionUtils.isNotEmpty(dtoList)) {
            ArrayList<DgCsSupplierEo> supplierEoList = new ArrayList<DgCsSupplierEo>();
            for (DgCsSupplierReqDto csSupplierReqDto : dtoList) {
                DgCsSupplierEo supplierEo = new DgCsSupplierEo();
                DtoHelper.dto2Eo((BaseVo)csSupplierReqDto, (BaseEo)supplierEo);
                if (StringUtils.isEmpty((CharSequence)csSupplierReqDto.getCode())) {
                    supplierEo.setCode(GenerateCodeUtils.getStrategy(CsGenerateCodeStrategyEnum.SUPPLIER.getCode()).getCode());
                }
                supplierEoList.add(supplierEo);
            }
            if (CollectionUtils.isNotEmpty(supplierEoList)) {
                this.dgCsSupplierDomain.insertBatch(supplierEoList);
            }
        }
    }

    @Override
    public PageInfo<DgCsSupplierRespDto> page(DgCsSupplierPageReqDto dto) {
        PageInfo supplierEoPageInfo = this.dgCsSupplierDomain.queryPageBySearchCon(dto);
        if (CollectionUtils.isNotEmpty((Collection)supplierEoPageInfo.getList())) {
            PageInfo pageInfo = new PageInfo();
            CubeBeanUtils.copyProperties((Object)pageInfo, (Object)supplierEoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
            ArrayList recordRespDtos = Lists.newArrayList();
            DtoHelper.eoList2DtoList((Collection)supplierEoPageInfo.getList(), (Collection)recordRespDtos, DgCsSupplierRespDto.class);
            pageInfo.setList((List)recordRespDtos);
            return pageInfo;
        }
        return null;
    }

    @Override
    public DgCsSupplierRespDto getSupplierDataById(Long id) {
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setId(id);
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierRespDto supplierRespDto = new DgCsSupplierRespDto();
            BeanUtils.copyProperties((Object)dgCsSupplierEo, (Object)supplierRespDto);
            return supplierRespDto;
        }
        return null;
    }

    @Override
    public DgCsSupplierRespDto getSupplierDataByCode(String code) {
        DgCsSupplierEo query = new DgCsSupplierEo();
        query.setCode(code);
        DgCsSupplierEo dgCsSupplierEo = (DgCsSupplierEo)this.dgCsSupplierDomain.selectOne((BaseEo)query);
        if (null != dgCsSupplierEo && null != dgCsSupplierEo.getId()) {
            DgCsSupplierRespDto supplierRespDto = new DgCsSupplierRespDto();
            BeanUtils.copyProperties((Object)dgCsSupplierEo, (Object)supplierRespDto);
            return supplierRespDto;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateStatusByCodeList(DgSupplierReqDto dto) {
        AssertUtils.notEmpty((Collection)dto.getCodeList(), (String)"\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DgCsSupplierPageReqDto pageReqDto = new DgCsSupplierPageReqDto();
        pageReqDto.setCodeList(dto.getCodeList());
        List supplierEoList = this.dgCsSupplierDomain.queryListBySearchCon(pageReqDto);
        if (CollectionUtils.isNotEmpty((Collection)supplierEoList)) {
            for (DgCsSupplierEo supplierEo : supplierEoList) {
                supplierEo.setStatus(dto.getStatus());
                this.dgCsSupplierDomain.updateSelective((BaseEo)supplierEo);
            }
        }
    }

    private void validSupplierData(DgCsSupplierReqDto dto) {
        Assert.hasText((String)dto.getCode(), (String)DgCustomerExceptionCode.SUPPLIER_CODE_NULL.getMsg());
        if (StringUtils.isNotEmpty((CharSequence)dto.getContactMobile())) {
            String regex = "^((13[0-9])|(14[5|7])|(15([0-3]|[5-9]))|(17[6|7|8])|(18[0-9])|166|198|199)\\d{8}$";
            Pattern p = Pattern.compile(regex);
            Matcher m = p.matcher(dto.getContactMobile());
            boolean isMatch = m.matches();
            AssertUtils.isTrue((boolean)isMatch, (String)"\u624b\u673a\u53f7\u7801\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
    }
}

