/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.domain.IDgRCustomerSalesmanDomain;
import com.yunxi.dg.base.center.customer.dto.request.DgRCustomerSalesmanReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgRCustomerSalesmanRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.eo.DgRCustomerSalesmanEo;
import com.yunxi.dg.base.center.customer.service.IDgRCustomerSalesmanService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class DgRCustomerSalesmanServiceImpl
implements IDgRCustomerSalesmanService {
    @Autowired
    private IDgRCustomerSalesmanDomain iDgRCustomerSalesmanDomain;
    @Resource
    private IDgCustomerSalesmanDomain iDgCustomerSalesmanDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncBatchAdd(List<DgRCustomerSalesmanEo> customerSalesmanEos) {
        if (CollectionUtil.isEmpty(customerSalesmanEos)) {
            return;
        }
        Map<Long, List<DgRCustomerSalesmanEo>> collect = customerSalesmanEos.stream().collect(Collectors.groupingBy(DgRCustomerSalesmanEo::getSalesmanId));
        ArrayList disCustomerSalesmanEos = Lists.newArrayList();
        for (Long salesmanId : collect.keySet()) {
            ArrayList customerIds = Lists.newArrayList();
            ArrayList orgIds = Lists.newArrayList();
            for (DgRCustomerSalesmanEo rCustomerSalesmanEo : collect.get(salesmanId)) {
                customerIds.add(rCustomerSalesmanEo.getCustomerId());
                orgIds.add(rCustomerSalesmanEo.getOrgId());
            }
            DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
            eo.setSalesmanId(salesmanId);
            ArrayList sqlFilters = Lists.newArrayList();
            sqlFilters.add(SqlFilter.in((String)"customer_id", (Object)customerIds));
            sqlFilters.add(SqlFilter.in((String)"org_id", (Object)orgIds));
            eo.setSqlFilters((List)sqlFilters);
            eo.setDr(CommonConstants.Dr.NO);
            List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
            Map<String, DgRCustomerSalesmanEo> oldRelationMap = eos.stream().collect(Collectors.toMap(e -> e.getSalesmanId() + "#" + e.getCustomerId() + "#" + e.getOrgId(), e -> e, (e1, e2) -> e1));
            List collect1 = collect.get(salesmanId).stream().filter(e -> !oldRelationMap.containsKey(e.getSalesmanId() + "#" + e.getCustomerId() + "#" + e.getOrgId())).collect(Collectors.toList());
            disCustomerSalesmanEos.addAll(collect1);
        }
        if (CollectionUtil.isNotEmpty((Collection)disCustomerSalesmanEos)) {
            this.iDgRCustomerSalesmanDomain.insertBatch((List)disCustomerSalesmanEos);
        }
    }

    @Override
    public List<DgRCustomerSalesmanRespDto> queryByUserId(Long userId) {
        if (userId == null) {
            return Lists.newArrayList();
        }
        DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
        eo.setSalesmanId(userId);
        eo.setDr(CommonConstants.Dr.NO);
        List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eos, DgRCustomerSalesmanRespDto.class);
        return list;
    }

    @Override
    public List<DgRCustomerSalesmanRespDto> queryList(DgRCustomerSalesmanReqDto rCustomerSalesmanReqDto) {
        if (rCustomerSalesmanReqDto.getCustomerId() == null && rCustomerSalesmanReqDto.getSalesmanId() == null) {
            return Lists.newArrayList();
        }
        DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)rCustomerSalesmanReqDto, (String[])new String[0]);
        eo.setDr(CommonConstants.Dr.NO);
        List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
        ArrayList respDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)respDtos, (Collection)eos, DgRCustomerSalesmanRespDto.class);
        return respDtos;
    }

    @Override
    public PageInfo<DgRCustomerSalesmanRespDto> queryPage(DgRCustomerSalesmanReqDto rCustomerSalesmanReqDto) {
        DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
        CubeBeanUtils.copyProperties((Object)eo, (Object)rCustomerSalesmanReqDto, (String[])new String[0]);
        eo.setDr(CommonConstants.Dr.NO);
        PageInfo eoPageInfo = this.iDgRCustomerSalesmanDomain.selectPage((BaseEo)eo, rCustomerSalesmanReqDto.getPageNum(), rCustomerSalesmanReqDto.getPageSize());
        PageInfo respDtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)respDtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list"});
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eoPageInfo.getList(), DgRCustomerSalesmanRespDto.class);
        respDtoPageInfo.setList((List)list);
        return respDtoPageInfo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(DgRCustomerSalesmanReqDto salesmanReqDto) {
        Long customerId = salesmanReqDto.getCustomerId();
        Long orgId = salesmanReqDto.getOrgId();
        if (customerId == null || orgId == null || CollectionUtils.isEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            return;
        }
        DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
        eo.setCustomerId(customerId);
        eo.setOrgId(orgId);
        this.iDgRCustomerSalesmanDomain.delete((BaseEo)eo);
        Map<Long, Long> salesmanMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iDgCustomerSalesmanDomain.filter().in((Object)"user_id", (Collection)salesmanReqDto.getSalesmanIds())).eq((Object)"org_info_id", (Object)orgId)).list().stream().collect(Collectors.toMap(DgCustomerSalesmanEo::getUserId, BaseEo::getId, (o, o1) -> o));
        if (CollectionUtil.isNotEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            ArrayList list = Lists.newArrayList();
            for (Long salesmanId : salesmanReqDto.getSalesmanIds()) {
                DgRCustomerSalesmanEo rCustomerSalesmanEo = new DgRCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(salesmanId);
                rCustomerSalesmanEo.setCustomerId(customerId);
                rCustomerSalesmanEo.setOrgId(orgId);
                rCustomerSalesmanEo.setRealSalesmanId(salesmanMap.get(salesmanId));
                list.add(rCustomerSalesmanEo);
            }
            this.iDgRCustomerSalesmanDomain.insertBatch((List)list);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(DgRCustomerSalesmanReqDto salesmanReqDto) {
        Long customerId = salesmanReqDto.getCustomerId();
        Long orgId = salesmanReqDto.getOrgId();
        if (customerId == null || orgId == null) {
            return;
        }
        if (CollectionUtil.isNotEmpty((Collection)salesmanReqDto.getSalesmanIds())) {
            ArrayList list = Lists.newArrayList();
            for (Long salesmanId : salesmanReqDto.getSalesmanIds()) {
                DgRCustomerSalesmanEo rCustomerSalesmanEo = new DgRCustomerSalesmanEo();
                rCustomerSalesmanEo.setSalesmanId(salesmanId);
                rCustomerSalesmanEo.setCustomerId(customerId);
                rCustomerSalesmanEo.setOrgId(orgId);
                list.add(rCustomerSalesmanEo);
            }
            this.iDgRCustomerSalesmanDomain.insertBatch((List)list);
        }
    }

    @Override
    public List<DgRCustomerSalesmanRespDto> queryByUserIds(List<Long> userIds) {
        if (CollectionUtils.isEmpty(userIds)) {
            return Lists.newArrayList();
        }
        DgRCustomerSalesmanEo eo = new DgRCustomerSalesmanEo();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        sqlFilters.add(SqlFilter.in((String)"salesman_id", userIds));
        eo.setSqlFilters(sqlFilters);
        eo.setDr(CommonConstants.Dr.NO);
        List eos = this.iDgRCustomerSalesmanDomain.selectList((BaseEo)eo);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)eos, DgRCustomerSalesmanRespDto.class);
        return list;
    }
}

