/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.customer.service.impl;

import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerDomain;
import com.yunxi.dg.base.center.customer.domain.IDgCustomerGroupDomain;
import com.yunxi.dg.base.center.customer.dto.exception.DgCustomerExceptionCode;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerGroupAddReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerGroupModifyReqDto;
import com.yunxi.dg.base.center.customer.dto.request.DgCustomerGroupQueryReqDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerGroupRespDto;
import com.yunxi.dg.base.center.customer.dto.response.DgCustomerGroupTreeRespDto;
import com.yunxi.dg.base.center.customer.eo.DgCustomerEo;
import com.yunxi.dg.base.center.customer.eo.DgCustomerGroupEo;
import com.yunxi.dg.base.center.customer.service.IDgCustomerGroupService;
import com.yunxi.dg.base.commons.constants.CommonConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DgCustomerGroupServiceImpl
implements IDgCustomerGroupService {
    @Resource
    private IDgCustomerGroupDomain iDgCustomerGroupDomain;
    @Resource
    private IDgCustomerDomain iDgCustomerDomain;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long add(DgCustomerGroupAddReqDto addReqDto) {
        DgCustomerGroupEo queryEo = new DgCustomerGroupEo();
        queryEo.setGroupName(addReqDto.getGroupName());
        queryEo.setDr(CommonConstants.Dr.NO);
        List customerGroupEos = this.iDgCustomerGroupDomain.selectList((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerGroupEos)) {
            throw new BizException(DgCustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getMsg());
        }
        DgCustomerGroupEo customerGroupEo = new DgCustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)customerGroupEo);
        this.iDgCustomerGroupDomain.insert((BaseEo)customerGroupEo);
        return customerGroupEo.getId();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modify(DgCustomerGroupModifyReqDto modifyReqDto) {
        List filterCustomerGroupEos;
        DgCustomerGroupEo queryEo = new DgCustomerGroupEo();
        queryEo.setGroupName(modifyReqDto.getGroupName());
        queryEo.setDr(CommonConstants.Dr.NO);
        List customerGroupEos = this.iDgCustomerGroupDomain.selectList((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerGroupEos) && CollectionUtils.isNotEmpty(filterCustomerGroupEos = customerGroupEos.stream().filter(bean -> bean.getId() != modifyReqDto.getId()).collect(Collectors.toList()))) {
            throw new BizException(DgCustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getCode(), DgCustomerExceptionCode.CUSTOMER_GROUP_NAME_EXISTS.getMsg());
        }
        DgCustomerGroupEo customerGroupEo = new DgCustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)customerGroupEo);
        this.iDgCustomerGroupDomain.updateSelective((BaseEo)customerGroupEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(Long id) {
        Map<Long, List<DgCustomerGroupEo>> customerGroupEoMap;
        ArrayList<Long> groupIds = new ArrayList<Long>();
        ArrayList<SqlFilter> sqlFilters = new ArrayList<SqlFilter>();
        groupIds.add(id);
        DgCustomerGroupEo customerGroupEo = new DgCustomerGroupEo();
        customerGroupEo.setDr(CommonConstants.Dr.NO);
        List select = this.iDgCustomerGroupDomain.selectList((BaseEo)customerGroupEo);
        if (CollectionUtils.isNotEmpty((Collection)select) && null != (customerGroupEoMap = select.stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId())))) {
            this.getChildrenGroupId(customerGroupEoMap, id, groupIds);
        }
        DgCustomerEo queryEo = new DgCustomerEo();
        sqlFilters.add(SqlFilter.in((String)"customer_group_id", (Object)StringUtils.join(groupIds, (String)",")));
        queryEo.setSqlFilters(sqlFilters);
        queryEo.setDr(CommonConstants.Dr.NO);
        List customerEos = this.iDgCustomerDomain.selectList((BaseEo)queryEo);
        if (CollectionUtils.isNotEmpty((Collection)customerEos)) {
            throw new BizException(DgCustomerExceptionCode.CUSTOMER_GROUP_EXIST_CUSTOMER.getCode(), DgCustomerExceptionCode.CUSTOMER_GROUP_EXIST_CUSTOMER.getMsg());
        }
        groupIds.stream().forEach(bean -> this.iDgCustomerGroupDomain.logicDeleteById(bean));
    }

    private void getChildrenGroupId(Map<Long, List<DgCustomerGroupEo>> customerGroupEoMap, Long parentGroupId, List<Long> groupIds) {
        List<DgCustomerGroupEo> customerGroupEos = customerGroupEoMap.get(parentGroupId);
        if (CollectionUtils.isNotEmpty(customerGroupEos)) {
            customerGroupEos.stream().forEach(bean -> {
                groupIds.add(bean.getId());
                this.getChildrenGroupId(customerGroupEoMap, bean.getId(), groupIds);
            });
        }
    }

    @Override
    public DgCustomerGroupRespDto queryById(Long id) {
        DgCustomerGroupEo customerGroupEo = (DgCustomerGroupEo)this.iDgCustomerGroupDomain.selectByPrimaryKey(id);
        DgCustomerGroupRespDto customerGroupRespDto = new DgCustomerGroupRespDto();
        DtoHelper.eo2Dto((BaseEo)customerGroupEo, (BaseVo)customerGroupRespDto);
        return customerGroupRespDto;
    }

    @Override
    public PageInfo<DgCustomerGroupRespDto> queryByPage(DgCustomerGroupQueryReqDto queryReqDto, Integer pageNum, Integer pageSize) {
        DgCustomerGroupEo customerGroupEo = new DgCustomerGroupEo();
        DtoHelper.dto2Eo((BaseVo)queryReqDto, (BaseEo)customerGroupEo);
        PageInfo eoPageInfo = this.iDgCustomerGroupDomain.selectPage((BaseEo)customerGroupEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, DgCustomerGroupRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public List<DgCustomerGroupTreeRespDto> queryForTree() {
        ArrayList<DgCustomerGroupTreeRespDto> customerGroupTreeRespDtos = new ArrayList<DgCustomerGroupTreeRespDto>();
        DgCustomerGroupEo customerGroupEo = new DgCustomerGroupEo();
        List select = this.iDgCustomerGroupDomain.selectList((BaseEo)customerGroupEo);
        if (CollectionUtils.isNotEmpty((Collection)select)) {
            Map<Long, List<DgCustomerGroupEo>> customerGroupEoMap = select.stream().collect(Collectors.groupingBy(bean -> null == bean.getParentGroupId() ? 0L : bean.getParentGroupId()));
            List root = select.stream().filter(bean -> null == bean.getParentGroupId() || bean.getParentGroupId().intValue() == 0).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(root)) {
                root.stream().forEach(bean -> {
                    DgCustomerGroupTreeRespDto customerGroupTreeRespDto = new DgCustomerGroupTreeRespDto();
                    CubeBeanUtils.copyProperties((Object)customerGroupTreeRespDto, (Object)bean, (String[])new String[0]);
                    customerGroupTreeRespDtos.add(customerGroupTreeRespDto);
                    this.getChildCustomerGroup(customerGroupTreeRespDto, customerGroupEoMap);
                });
            }
        }
        return customerGroupTreeRespDtos;
    }

    private void getChildCustomerGroup(DgCustomerGroupTreeRespDto customerGroupTreeRespDto, Map<Long, List<DgCustomerGroupEo>> customerGroupEoMap) {
        List<DgCustomerGroupEo> customerGroupEos = customerGroupEoMap.get(customerGroupTreeRespDto.getId());
        if (CollectionUtils.isNotEmpty(customerGroupEos)) {
            ArrayList children = new ArrayList();
            DtoHelper.eoList2DtoList(customerGroupEos, children, DgCustomerGroupTreeRespDto.class);
            customerGroupTreeRespDto.setChildren(children);
            customerGroupEoMap.remove(customerGroupTreeRespDto.getId());
            children.stream().forEach(bean -> this.getChildCustomerGroup((DgCustomerGroupTreeRespDto)bean, customerGroupEoMap));
        }
    }
}

