/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dao.das.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.mapper.PushKeepAccountsMapper;
import com.yunxi.dg.base.center.finance.dao.vo.AllKeepOrderVo;
import com.yunxi.dg.base.center.finance.dao.vo.BillKeepAccountReqVo;
import com.yunxi.dg.base.center.finance.dao.vo.BillKeepAccountVo;
import com.yunxi.dg.base.center.finance.dao.vo.HckKeepAccountVo;
import com.yunxi.dg.base.center.finance.dao.vo.KeepQueryConditionVo;
import com.yunxi.dg.base.center.finance.dto.entity.PushKeepAccountsDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PushKeepAccountsDasImpl
extends AbstractDas<PushKeepAccountsEo, Long>
implements IPushKeepAccountsDas {
    private static final Logger logger = LoggerFactory.getLogger(PushKeepAccountsDasImpl.class);
    @Resource
    private PushKeepAccountsMapper pushKeepAccountsMapper;

    public PushKeepAccountsMapper getMapper() {
        return this.pushKeepAccountsMapper;
    }

    @Override
    public PageInfo<PushKeepAccountsEo> page(KeepQueryConditionVo keepQueryConditionVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<PushKeepAccountsEo> pushKeepAccountsEos = this.pushKeepAccountsMapper.page(keepQueryConditionVo, pageNum, pageSize);
        return new PageInfo(pushKeepAccountsEos);
    }

    @Override
    public PageInfo<BillKeepAccountVo> billKeepReportByPage(BillKeepAccountReqVo reqVo, Integer pageNum, Integer pageSize) {
        if (pageNum != null && pageSize != null) {
            PageHelper.startPage((int)pageNum, (int)pageSize);
        }
        List<BillKeepAccountVo> billKeepAccountVos = this.pushKeepAccountsMapper.billKeepReportByPage(reqVo, pageNum, pageSize);
        return new PageInfo(billKeepAccountVos);
    }

    @Override
    public void batchUpdateChargeDate(List<PushKeepAccountsEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.batchUpdateChargeDate(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.batchUpdateChargeDate(list.subList(i, i + length));
        }
    }

    @Override
    public void batchUpdateDetailChargeDate(List<KeepAccountsDetailEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.batchUpdateDetailChargeDate(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.batchUpdateDetailChargeDate(list.subList(i, i + length));
        }
    }

    @Override
    public void batchUpdateTimeoutKeep(List<PushKeepAccountsEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.batchUpdateTimeoutKeep(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.batchUpdateTimeoutKeep(list.subList(i, i + length));
        }
    }

    @Override
    public void batchUpdateTimeoutKeepDetail(List<KeepAccountsDetailEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.batchUpdateTimeoutKeepDetail(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.batchUpdateTimeoutKeepDetail(list.subList(i, i + length));
        }
    }

    @Override
    public void abnormalBookkeepingCorrection(List<PushKeepAccountsEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.abnormalBookkeepingCorrection(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.abnormalBookkeepingCorrection(list.subList(i, i + length));
        }
    }

    @Override
    public void abnormalBookkeepingCorrectionDetail(List<KeepAccountsDetailEo> list) {
        int length;
        int i = 0;
        for (length = list.size(); length > 500; length -= 500) {
            this.pushKeepAccountsMapper.abnormalBookkeepingCorrectionDetail(list.subList(i, i + 500));
            i += 500;
        }
        if (length > 0) {
            this.pushKeepAccountsMapper.abnormalBookkeepingCorrectionDetail(list.subList(i, i + length));
        }
    }

    @Override
    public List<AllKeepOrderVo> statisticsOrderItemByPlatformOrderNo(List<String> platformOrderNos) {
        return this.pushKeepAccountsMapper.statisticsOrderItemByPlatformOrderNo(platformOrderNos);
    }

    @Override
    public List<AllKeepOrderVo> statisticsKeepDetailOrderItemByPlatformOrderNo(List<String> platformOrderNos) {
        return this.pushKeepAccountsMapper.statisticsKeepDetailOrderItemByPlatformOrderNo(platformOrderNos);
    }

    @Override
    public List<AllKeepOrderVo> statisticsAfterSaleOrderItemByPlatformOrderNo(List<String> afterSaleOrderNos) {
        return this.pushKeepAccountsMapper.statisticsAfterSaleOrderItemByPlatformOrderNo(afterSaleOrderNos);
    }

    @Override
    public List<AllKeepOrderVo> statisticsAfterSaleKeepDetailOrderItemByPlatformOrderNo(List<String> afterSaleOrderNos) {
        return this.pushKeepAccountsMapper.statisticsAfterSaleKeepDetailOrderItemByPlatformOrderNo(afterSaleOrderNos);
    }

    @Override
    public void batchRemoveKeepDetail(List<String> chargeCodes, String updatePerson) {
        this.pushKeepAccountsMapper.batchRemoveKeepDetail(chargeCodes, updatePerson);
    }

    @Override
    public void batchRemovePushKeepDetail(List<String> chargeCodes, String updatePerson) {
        this.pushKeepAccountsMapper.batchRemovePushKeepDetail(chargeCodes, updatePerson);
    }

    @Override
    public void batchRemoveKeepDetailMapping(List<String> chargeCodes, String updatePerson) {
        this.pushKeepAccountsMapper.batchRemoveKeepDetailMapping(chargeCodes, updatePerson);
    }

    @Override
    public void modifyKeepCustomer(KeepAccountsDetailEo keepAccountsDetailEo) {
        this.pushKeepAccountsMapper.modifyKeepCustomer(keepAccountsDetailEo);
    }

    @Override
    public void modifyPushKeepDetailCustomer(KeepAccountsDetailEo keepAccountsDetailEo) {
        this.pushKeepAccountsMapper.modifyPushKeepDetailCustomer(keepAccountsDetailEo);
    }

    @Override
    public void bookKeepingRemark(String bookKeeping, String extension, String updatePerson, Date chargeDate, String chargeCode) {
        this.pushKeepAccountsMapper.bookKeepingRemark(bookKeeping, extension, updatePerson, chargeDate, chargeCode);
    }

    @Override
    public void repairKeepByChargeCodes(String bookKeeping, Date chargeDate, String chargeCode) {
        this.pushKeepAccountsMapper.repairKeepByChargeCodes(bookKeeping, chargeDate, chargeCode);
    }

    @Override
    public List<HckKeepAccountVo> retryKeepByIds(List<Long> ids) {
        return this.pushKeepAccountsMapper.retryKeepByIds(ids);
    }

    @Override
    public void setSaleNoByIds(List<Long> ids, String outSaleOrderNo) {
        this.pushKeepAccountsMapper.setSaleNoByIds(ids, outSaleOrderNo);
    }

    @Override
    public void updateAccountStatusByChargeCodes(Set<String> chargeCodeList, String keepingResult, String accountingResult) {
        this.pushKeepAccountsMapper.updateAccountStatusByChargeCodes(chargeCodeList, keepingResult, accountingResult);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateAccountOutSideNumber(List<PushKeepAccountsEo> pushKeepAccountsEos, PushKeepAccountsDto pushKeepAccountsDto) {
        logger.info("\u66f4\u65b0\u8bb0\u8d26\u5355\u8bb0\u8d26\u72b6\u6001\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)pushKeepAccountsDto), (Object)JSON.toJSONString((Object)pushKeepAccountsDto));
        if (StringUtils.isBlank((CharSequence)pushKeepAccountsDto.getAccountingResult())) {
            logger.info("\u65e0\u9700\u66f4\u65b0\u8bb0\u8d26\u5355\u8bb0\u8d26\u72b6\u6001");
            return;
        }
        for (PushKeepAccountsEo pushKeepAccountsEo : pushKeepAccountsEos) {
            UpdateWrapper updateWrapper = new UpdateWrapper();
            updateWrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
            updateWrapper.eq((Object)"id", (Object)pushKeepAccountsEo.getId());
            if (StringUtils.isBlank((CharSequence)pushKeepAccountsDto.getReason())) {
                updateWrapper.set((Object)"reason", null);
            }
            PushKeepAccountsEo updateEo = new PushKeepAccountsEo();
            CubeBeanUtils.copyProperties((Object)updateEo, (Object)pushKeepAccountsDto, (String[])new String[0]);
            this.getMapper().update(updateEo, (Wrapper)updateWrapper);
            pushKeepAccountsEo.setAccountingResult(pushKeepAccountsDto.getAccountingResult());
        }
    }

    @Override
    public List<PushKeepAccountsEo> getByChargeCodes(Collection<String> chargeCodes) {
        if (chargeCodes == null || chargeCodes.isEmpty()) {
            return Collections.emptyList();
        }
        return Lists.partition(new ArrayList<String>(chargeCodes), (int)1000).stream().flatMap(once -> {
            List list = this.pushKeepAccountsMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(PushKeepAccountsEo.class).in(PushKeepAccountsEo::getChargeCode, (Collection)once)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
    }

    @Override
    public Map<String, PushKeepAccountsEo> getMapByChargeCodes(Collection<String> chargeCodes) {
        List<PushKeepAccountsEo> list = this.getByChargeCodes(chargeCodes);
        return list.stream().collect(Collectors.toMap(PushKeepAccountsEo::getChargeCode, v -> v, (a, b) -> {
            logger.warn("\u91cd\u590d\u7684\u8bb0\u8d26\u5355\u53f7\uff1a{}, a.id={}, b.id={}", new Object[]{a.getChargeCode(), a.getId(), b.getId()});
            return b;
        }));
    }

    @Override
    public Set<String> queryCanBillPlatformOrderNoByTimeRange(LocalDateTime startTime, LocalDateTime endTime) {
        return this.pushKeepAccountsMapper.queryCanBillPlatformOrderNoByTimeRange(startTime, endTime);
    }
}

