/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderInfoDomainImpl
extends BaseDomainImpl<DgPerformOrderInfoEo>
implements IDgPerformOrderInfoDomain {
    @Resource
    private IDgPerformOrderInfoDas das;

    public ICommonDas<DgPerformOrderInfoEo> commonDas() {
        return this.das;
    }

    @Override
    public DgPerformOrderInfoEo queryByEo(DgPerformOrderInfoEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return performOrderInfoEo;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByDto(DgPerformOrderInfoEo performOrderInfoEo) {
        return null;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u67e5\u8be2\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return null;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEffectiveListByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u67e5\u8be2\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> orderStatus = Arrays.asList(OmsSaleOrderStatus.COMPLETE.getCode(), OmsSaleOrderStatus.DELIVERED.getCode());
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).in((Object)"order_status", orderStatus)).list();
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoListBySaleOrderNos(List<String> saleOrderNos) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(saleOrderNos), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNos\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)this.das.filter().in((Object)"sale_order_no", saleOrderNos)).list();
    }

    @Override
    public DgPerformOrderInfoEo queryEoBySaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).one();
    }
}

