/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.util.ArrayList;
import java.util.List;

public enum InternalOrderTypeEnum {
    XF_SALES_ORDER("XF_SALES_ORDER", "\u9500\u5206\u9500\u552e\u5355"),
    XF_PURCHASE_ORDER("XF_PURCHASE_ORDER", "\u9500\u5206\u91c7\u8d2d\u5355"),
    GROUP_PURCHASE_ORDER("GROUP_PURCHASE_ORDER", "\u96c6\u56e2\u9500\u552e\u5355"),
    USE_DELIVERY_ORDER("USE_DELIVERY_ORDER", "\u9886\u7528\u51fa\u5e93\u5355"),
    XF_SALES_RETURN_ORDER("XF_SALES_RETURN_ORDER", "\u9500\u5206\u9500\u552e\u9000\u8d27\u5355"),
    XF_STOCK_RETURN_ORDER("XF_STOCK_RETURN_ORDER", "\u9500\u5206\u91c7\u8d2d\u9000\u8d27\u5355"),
    GROUP_SALES_RETURN_ORDER("GROUP_SALES_RETURN_ORDER", "\u96c6\u56e2\u9500\u552e\u9000\u8d27\u5355"),
    USE_INBOUND_ORDER("USE_INBOUND_ORDER", "\u9886\u7528\u5165\u5e93\u5355"),
    XF_RECEIVE_ORDER("XF_RECEIVE_ORDER", "\u9500\u5206\u5e94\u6536\u5355"),
    GROUP_RECEIVE_ORDER("GROUP_RECEIVE_ORDER", "\u96c6\u56e2\u5e94\u6536\u5355");

    private String code;
    private String name;
    public static List<String> needPurchasePriceTypeList;

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    private InternalOrderTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static String getNameByCode(String code) {
        for (InternalOrderTypeEnum orderTypeEnum : InternalOrderTypeEnum.values()) {
            if (!orderTypeEnum.getCode().equals(code)) continue;
            return orderTypeEnum.getName();
        }
        return null;
    }

    public static InternalOrderTypeEnum getByCode(String code) {
        for (InternalOrderTypeEnum optionTypeEnum : InternalOrderTypeEnum.values()) {
            if (!optionTypeEnum.getCode().equals(code)) continue;
            return optionTypeEnum;
        }
        return null;
    }

    public static boolean isNeedPurchasePrice(String type) {
        return needPurchasePriceTypeList.contains(type);
    }

    static {
        needPurchasePriceTypeList = new ArrayList<String>();
        needPurchasePriceTypeList.add(GROUP_RECEIVE_ORDER.getCode());
        needPurchasePriceTypeList.add(XF_PURCHASE_ORDER.getCode());
        needPurchasePriceTypeList.add(GROUP_PURCHASE_ORDER.getCode());
        needPurchasePriceTypeList.add(XF_STOCK_RETURN_ORDER.getCode());
        needPurchasePriceTypeList.add(GROUP_SALES_RETURN_ORDER.getCode());
    }
}

