/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum KeepAccountInterfaceEnum {
    ZH26("ZH26", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZR01("ZR01", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZH80("ZH80", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZR80("ZR80", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZH70("ZH70", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZH71("ZH71", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZR70("ZR70", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZR71("ZR71", "ZRFC_WMS_CREATE_ORDER", "ZRFC_WMS_CREATE_DELIVERY"),
    ZCR1("ZCR1", "ZRFC_WMS_CREATE_DC_ORDER", null),
    ZDR1("ZDR1", "ZRFC_WMS_CREATE_DC_ORDER", null),
    ZDR2("ZDR2", "ZRFC_WMS_CREATE_DC_ORDER", null),
    ZCR("ZCR", "ZRFC_WMS_CREATE_DC_ORDER", null),
    ZDR("ZDR", "ZRFC_WMS_CREATE_DC_ORDER", null),
    ZH01("ZH01", null, "ZRFC_LTC_CREATE_BILL"),
    RE("RE", null, "ZRFC_LTC_CREATE_BILL"),
    G2("G2", null, "ZRFC_LTC_CREATE_BILL"),
    L2("L2", null, "ZRFC_LTC_CREATE_BILL"),
    ZR02("ZR02", null, "ZRFC_LTC_CREATE_BILL"),
    ZR01_1("ZR01", null, "ZRFC_LTC_CREATE_BILL"),
    RR02("RR02", null, "ZRFC_LTC_CREATE_BILL");

    private String code;
    private String name;
    private String desc;
    private static final Map<String, String> ORDER_INTERFACE_ENUM;
    private static final Map<String, String> DELIVERY_TYPE_ENUM;
    private static final Map<String, String> BILL_INTERFACE_ENUM;

    private KeepAccountInterfaceEnum(String code, String name, String desc) {
        this.code = code;
        this.name = name;
        this.desc = desc;
    }

    public static List<String> getOrderInterFaceEnumList() {
        return Arrays.asList(ZH80.getCode(), ZR80.getCode(), ZH70.getCode());
    }

    public static String getOrderInterfaceName(String code) {
        return ORDER_INTERFACE_ENUM.get(code);
    }

    public static String getDeliveryInterfaceName(String code) {
        return DELIVERY_TYPE_ENUM.get(code);
    }

    public static String getBillInterfaceName(String code) {
        return BILL_INTERFACE_ENUM.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    static {
        ORDER_INTERFACE_ENUM = Maps.newHashMap();
        DELIVERY_TYPE_ENUM = Maps.newHashMap();
        BILL_INTERFACE_ENUM = Maps.newHashMap();
        for (KeepAccountInterfaceEnum key : KeepAccountInterfaceEnum.values()) {
            if (StringUtils.isNotBlank((CharSequence)key.getName())) {
                ORDER_INTERFACE_ENUM.put(key.getCode(), key.getName());
                DELIVERY_TYPE_ENUM.put(key.getCode(), key.getDesc());
                continue;
            }
            if (!StringUtils.isNotBlank((CharSequence)key.getDesc())) continue;
            BILL_INTERFACE_ENUM.put(key.getCode(), key.getDesc());
        }
    }
}

