/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum OperatorTypeEnum {
    AUDIT("audit", "\u5ba1\u6838"),
    PUBLISH("publish", "\u53d1\u5e03"),
    DELETE("delete", "\u5220\u9664"),
    CONFIRM("confirm", "\u786e\u8ba4"),
    INVALIDATE("invalidate", "\u4f5c\u5e9f"),
    CANCEL("cancel", "\u53d6\u6d88\u53d1\u5e03");

    private String code;
    private String name;
    public static final Map<String, OperatorTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private OperatorTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static OperatorTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(OperatorTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(OperatorTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.name));
    }
}

