/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.rest.entity;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.api.entity.IBillStrategyApi;
import com.yunxi.dg.base.center.finance.dto.entity.BillStrategyDto;
import com.yunxi.dg.base.center.finance.dto.entity.BillStrategyPageReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditModifyStatusReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import io.swagger.annotations.Api;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u57fa\u7ebf-\u6837\u672c\u4e2d\u5fc3:\u5f00\u7968\u7b56\u7565\u8868\u63a5\u53e3\u670d\u52a1"})
@RequestMapping(value={"/v1/bill/strategy"})
public class BillStrategyController
implements IBillStrategyApi {
    @Resource
    private IBillStrategyService service;

    public RestResponse<Long> insert(@RequestBody BillStrategyDto dto) {
        return this.service.insert((BaseDto)dto);
    }

    public RestResponse update(@RequestBody BillStrategyDto dto) {
        return this.service.update((BaseDto)dto);
    }

    public RestResponse<BillStrategyDto> get(Long id) {
        return this.service.get(id);
    }

    public RestResponse logicDelete(@PathVariable(name="id", required=true) Long id) {
        return this.service.logicDelete(id);
    }

    public RestResponse<PageInfo<BillStrategyDto>> page(@RequestBody BillStrategyPageReqDto dto) {
        return this.service.page((BaseDto)BeanCopyUtil.copy((Object)dto, BillStrategyDto.class), dto.getPageNum(), dto.getPageSize());
    }

    public RestResponse<Long> addBillStrategy(@RequestBody BillStrategyReqDto strategyReqDto) {
        return new RestResponse((Object)this.service.addBillStrategy(strategyReqDto));
    }

    public RestResponse<Void> modifyBillStrategy(@RequestBody BillStrategyReqDto modifyReqDto) {
        this.service.modifyBillStrategy(modifyReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> updateApplyAudit(BillApplyAuditReqDto billApplyAuditReqDto) {
        this.service.updateApplyAudit(billApplyAuditReqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> removeBillStrategy(@RequestParam(value="ids") List<Long> ids) {
        this.service.removeBillStrategy(ids);
        return RestResponse.VOID;
    }

    public RestResponse<Void> modifyStatus(@RequestBody BillApplyAuditModifyStatusReqDto reqDto) {
        this.service.modifyStatus(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<BillStrategyRespDto> queryById(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.service.queryById(id));
    }

    public RestResponse<PageInfo<BillStrategyRespDto>> queryByPage(@RequestBody BillStrategyQueryReqDto queryReqDto) {
        return new RestResponse((Object)this.service.queryByPage(queryReqDto));
    }

    public RestResponse<BillStrategyRespDto> queryByShopCode(@PathVariable(value="shopCode") String shopCode) {
        return new RestResponse((Object)this.service.queryByShopCode(shopCode));
    }
}

