/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.scheduler.task;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.yundt.cube.center.scheduler.client.event.ISingleTupleScheduleEvent;
import com.dtyunxi.yundt.cube.center.scheduler.common.msg.TaskMsg;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dto.enums.AllRedFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class BillAutoAuditTask
implements ISingleTupleScheduleEvent {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillInfoService billInfoService;

    public void before(TaskMsg taskMsg) {
        this.logger.info("1\u3001=========\u5f00\u59cb\u6267\u884c\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1==========");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(TaskMsg taskMsg) {
        this.logger.info("2\u3001========>\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u4e2d");
        try {
            List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"invoice_state", (Object)InvoiceStateEnum.WAIT_AUDIT.getCode())).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                List billFlowNoList = billInfoEoList.stream().map(BillInfoEo::getBillFlowNo).distinct().collect(Collectors.toList());
                List partition = Lists.partition(billFlowNoList, (int)1000);
                partition.forEach(list -> this.billInfoService.auditBillInfo(list));
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            this.logger.info("\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u5931\u8d25\uff1a{}", (Object)e.getMessage());
            boolean bl = true;
            return bl;
        }
        finally {
            this.logger.info("\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1\u6267\u884c\u5b8c\u6210");
            return true;
        }
    }

    public void after(TaskMsg taskMsg) {
        this.logger.info("3\u3001=========\u7ed3\u675f\u81ea\u52a8\u5ba1\u6838\u53d1\u7968\u4efb\u52a1==========");
    }
}

