/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.huieryun.oss.api.IObjectStorageService;
import com.dtyunxi.huieryun.oss.vo.OssRegistryVo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.vo.BaseVo;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceDetailReqDto;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceInfoReqDto;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceInfoRespDto;
import com.dtyunxi.yundt.cube.center.openapi.proxy.invoice.IInvoiceApiProxy;
import com.dtyunxi.yundt.cube.center.trade.dto.entity.SaleOrderBillRecordReqProxyDto;
import com.dtyunxi.yundt.cube.center.trade.proxy.entity.ISaleOrderBillRecordApiProxy;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.finance.convert.entity.BillInfoConverter;
import com.yunxi.dg.base.center.finance.convert.entity.BillItemConverter;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.IAfterSaleOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillAllElectricShopDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyNoInvoiceItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IItemRateDgDas;
import com.yunxi.dg.base.center.finance.dao.das.INoKeepBillDas;
import com.yunxi.dg.base.center.finance.dao.das.ISaleOrderBillRecordDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillApplyMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.BillInfoMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.NoKeepBillMapper;
import com.yunxi.dg.base.center.finance.dao.vo.BillInfoReportQueryVo;
import com.yunxi.dg.base.center.finance.dao.vo.BillItemReportRespVo;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPushKeepAccountsDomain;
import com.yunxi.dg.base.center.finance.dto.OrderLineClassificationDto;
import com.yunxi.dg.base.center.finance.dto.SaleOrderItemVo;
import com.yunxi.dg.base.center.finance.dto.entity.BillInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRateDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.MatchRelatedTradeShopKeepDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.entity.QueryUnInvoiceOrderListDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AllRedFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillCreateTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyOrderPointEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyRemarkType;
import com.yunxi.dg.base.center.finance.dto.enums.BillTitleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.NoKeepBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleItemStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SiteChannelEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SubsidiesTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.UseBlackListEnum;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.AgainInvoiceQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BatchReissueDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoListQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReportQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillItemReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillModifyReqDto;
import com.yunxi.dg.base.center.finance.dto.request.CallBackInvoiceInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.InvoiceVerificationQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.KeepAccountsDetailReqDto;
import com.yunxi.dg.base.center.finance.dto.request.ReissueBillDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoReportRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillInfoRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemExportDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemReportRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillPreviewDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.GenerateBillResultRespDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.InvoiceVerificationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.KeepAccountsDetailRespDto;
import com.yunxi.dg.base.center.finance.dto.response.RedOrderInvoiceAgainBillRespDto;
import com.yunxi.dg.base.center.finance.dto.response.SaleOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.response.UserSystemBillApplyRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyNoInvoiceItemEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.NoKeepBillEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillApplyService;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoValidateService;
import com.yunxi.dg.base.center.finance.service.entity.IBillItemService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.ICallBackPassPlatformInvoiceService;
import com.yunxi.dg.base.center.finance.service.entity.IItemDgService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepAccountsDetailService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.IRelatedTradeShopKeepingService;
import com.yunxi.dg.base.center.finance.service.entity.ISaleOrderBillRecordService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.generate.BillInvoiceTypeConvert;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.GenerateCodeDataUtils;
import com.yunxi.dg.base.center.finance.service.utils.LockUtils;
import com.yunxi.dg.base.center.finance.service.utils.LogUtils;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillInfoServiceImpl
extends BaseServiceImpl<BillInfoDto, BillInfoEo, IBillInfoDomain>
implements IBillInfoService {
    private static final String deliver = "deliver";
    private static final String complete = "complete";
    private static Logger logger = LoggerFactory.getLogger(BillInfoServiceImpl.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IItemRateDgDas itemRateDgDas;
    @Resource
    private OssRegistryVo ossRegistryVo;
    @Resource
    private IContext context;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private GenerateCodeDataUtils generateCodeDataUtils;
    @Resource
    private IBillEntityDas billEntityDas;
    @Value(value="${huieryun.ossregistryvo.bucketName: oms-sit}")
    private String bucketName;
    @Value(value="${huieryun.ossregistryvo.invoiceDirPath:invoice}")
    private String invoiceDirPath;
    private static final int EXPORT_FAIL_EXPIRES_IN = 1200;
    @Resource
    private IObjectStorageService objectStorageService;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IBillApplyDas billApplyDas;
    @Resource
    private BillApplyMapper billApplyMapper;
    @Resource
    private ISaleOrderBillRecordDas saleOrderBillRecordDas;
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillBusinessRelPlatformService billBusinessRelPlatformService;
    @Resource
    private IBillStrategyNoInvoiceItemDas billStrategyNoInvoiceItemDas;
    @Resource
    private IBillStrategyDas billStrategyDas;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private INoKeepBillDas noKeepBillDas;
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    @Value(value="${bill.mode:HCK-KINGDEE}")
    private String billMode;
    @Resource
    private ICacheService cacheService;
    private final String BILL_APPLY_PREFIX = "BA";
    @Resource
    private ILockService lockService;
    @Resource
    private IBillAllElectricShopDas billAllElectricShopDas;
    @Resource
    private IShopService shopService;
    @Resource
    private BillInfoMapper billInfoMapper;
    @Resource
    private IAfterSaleOrderDas afterSaleOrderDas;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private NoKeepBillMapper noKeepBillMapper;
    @Resource
    private IBillItemService billItemService;
    @Resource
    private ISaleOrderBillRecordService saleOrderBillRecordService;
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private ISaleOrderBillRecordApiProxy saleOrderBillRecordApiProxy;
    @Resource
    private IPushKeepAccountsDomain pushKeepAccountsDomain;
    @Resource
    private IKeepAccountsDetailDomain iKeepAccountsDetailDomain;
    @Resource
    private IInvoiceApiProxy invoiceApiProxy;
    @Resource
    private ICallBackPassPlatformInvoiceService iCallBackPassPlatformInvoiceService;
    @Resource
    private IPerformOrderInfoService iPerformOrderInfoService;
    @Resource
    private IPerformOrderInfoDomain iPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Value(value="#{'${special.rate.companyNames:\u4f5b\u5c71\u4e07\u548c\u667a\u6167\u5bb6\u5c45\u8d38\u6613\u6709\u9650\u516c\u53f8,\u6d4b\u8bd5\u516c\u53f8}'.split(',')}")
    private List<String> specialRateCompanyNames;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IBillApplyService billApplyService;
    @Resource
    private IAfterSaleOrderItemDas afterSaleOrderItemDas;
    @Resource
    private IKeepAccountsDetailService keepAccountsDetailService;
    @Resource
    private IBillInfoValidateService billInfoValidateService;
    @Resource
    private IBillInfoService self;
    @Resource
    private BillInvoiceTypeConvert invoiceTypeConvert;
    @Resource
    private IRelatedTradeShopKeepingService relatedTradeShopKeepingService;
    public static final BigDecimal SPECIAL_RATE = new BigDecimal("0.13");

    public BillInfoServiceImpl(IBillInfoDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillInfoDto, BillInfoEo> converter() {
        return BillInfoConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillInfo(BillInfoReqDto addReqDto) {
        logger.info("addBillInfo \u65b0\u589e\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)addReqDto));
        if (addReqDto.getRelOrder().booleanValue()) {
            String platformOrderNo = addReqDto.getPlatformOrderNo();
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5173\u8054\u7684\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            String[] split = platformOrderNo.split(",");
            List<String> platformOrderNoList = Arrays.asList(split);
            HashSet platformOrderNoSet = new HashSet();
            HashSet repeatPlatformOrderNoSet = new HashSet();
            platformOrderNoList.forEach(orderNo -> {
                if (platformOrderNoSet.contains(orderNo)) {
                    repeatPlatformOrderNoSet.add(orderNo);
                } else {
                    platformOrderNoSet.add(orderNo);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(repeatPlatformOrderNoSet)) {
                String join = String.join((CharSequence)",", repeatPlatformOrderNoSet);
                throw new BizException("\u5e73\u53f0\u8ba2\u5355\u53f7\u91cd\u590d:" + join);
            }
            AtomicReference<Long> id = new AtomicReference<Long>(0L);
            List relPlatformList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformList)) {
                List billFlowNoList = relPlatformList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                List billFlowNoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", (Collection)billFlowNoList)).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billFlowNoEoList)) {
                    List mergeEoList = billFlowNoEoList.stream().filter(x -> WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(x.getWhetherMergeBill())).collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mergeEoList)) {
                        String platformOrderNoStr = mergeEoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
                        throw new BizException(String.format("%s:\u5e73\u53f0\u5355\u53f7\u5df2\u7ecf\u5b58\u5728\u5408\u5e76\u5f00\u7968\u5355\u636e", platformOrderNoStr));
                    }
                    List billInfoEoList = billFlowNoEoList.stream().filter(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState())).collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billInfoEoList)) {
                        String platformOrderNoStr = billInfoEoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
                        throw new BizException(String.format("%s:\u5e73\u53f0\u5355\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u80fd\u65b0\u589e\u624b\u5de5\u5355", platformOrderNoStr));
                    }
                }
            }
            for (String platformOrder : platformOrderNoList) {
                SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                saleOrderBillRecordQueryReqDto.setPlatformOrderNo(platformOrder);
                List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                if (CollUtil.isNotEmpty(saleOrderBillRecordDtos)) {
                    for (SaleOrderBillRecordDto saleOrderBillRecordDto : saleOrderBillRecordDtos) {
                        logger.info("\u66f4\u65b0\u8ba2\u5355\u5f00\u7968\u8bb0\u5f55\u4fe1\u606f\uff1a{} {}", (Object)saleOrderBillRecordDto.getPlatformOrderNo(), (Object)saleOrderBillRecordDto.getSaleOrderNo());
                        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                        CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)addReqDto, (String[])new String[0]);
                        saleOrderBillRecordReqDto.setId(saleOrderBillRecordDto.getId());
                        saleOrderBillRecordReqDto.setPlatformOrderNo(saleOrderBillRecordDto.getPlatformOrderNo());
                        saleOrderBillRecordReqDto.setSaleOrderNo(saleOrderBillRecordDto.getSaleOrderNo());
                        this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                    }
                }
                String code = this.generateCodeDataUtils.generateNo("KP");
                addReqDto.setBillFlowNo(code);
                addReqDto.setPlatformOrderNo(platformOrder);
                this.checkParameter(addReqDto);
                AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)addReqDto.getBillItemReqDtoList()), "\u5f00\u7968\u4fe1\u606f\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
                addReqDto.getBillItemReqDtoList().forEach(item -> item.setBillFlowNo(code));
                PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
                performOrderInfoPageReqDto.setPlatformOrderNoList((List)Lists.newArrayList((Object[])new String[]{platformOrder}));
                performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
                List<PerformOrderInfoDto> saleOrderRespDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
                AssertUtil.assertNotEmpty(saleOrderRespDtoList, String.format("\u5355\u53f7[%s],\u6ca1\u6709\u5b58\u5728\u7b26\u5408\u5f00\u7968\u5355\u636e", platformOrder));
                PerformOrderInfoDto performOrderInfoDto = saleOrderRespDtoList.get(0);
                LockUtils.lock(() -> (Integer)LockUtils.executorNewTransaction(s -> {
                    try {
                        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                        billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
                        billInfoGenerateReqDto.setOrderStatus(performOrderInfoDto.getOrderStatus());
                        billInfoGenerateReqDto.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
                        billInfoGenerateReqDto.setOrderType(performOrderInfoDto.getOrderType());
                        billInfoGenerateReqDto.setInvoiceRemarks(addReqDto.getInvoiceRemarks());
                        billInfoGenerateReqDto.setInvoiceType(addReqDto.getInvoiceType());
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new String[]{"wait_bill", "invoicing", "billed"}))).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"bill_type", (Object)"blue_ticket")).list();
                        List redList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new String[]{"wait_bill", "invoicing", "billed"}))).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"bill_type", (Object)"red_ticket")).list();
                        this.getInvoicePolicy(performOrderInfoDto, billInfoGenerateReqDto);
                    }
                    catch (Exception e) {
                        logger.error("generateBillInfo==>\u5f00\u7968\u5f02\u5e38:", (Throwable)e);
                    }
                    return 1;
                }), performOrderInfoDto.getPlatformOrderNo(), "bill_info_key", 30);
            }
            return id.get();
        }
        BillEntityEo billEntityEo = new BillEntityEo();
        HashSet<String> exItemCodes = new HashSet();
        BillStrategyEo billStrategyEo = new BillStrategyEo();
        if (Objects.nonNull(addReqDto.getEntityId())) {
            billEntityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)addReqDto.getEntityId())).one();
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billStrategyDas.filter().eq((Object)"bill_entity_code", (Object)billEntityEo.getId())).eq((Object)"strategy_status", (Object)"enable")).orderByDesc((Object)"id")).list();
            if (CollectionUtil.isNotEmpty((Collection)list)) {
                billStrategyEo = (BillStrategyEo)list.get(0);
                List itemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyEo.getId())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)itemEoList)) {
                    exItemCodes = itemEoList.stream().map(BillStrategyNoInvoiceItemEo::getItemCode).collect(Collectors.toSet());
                }
            }
        }
        String code = this.generateCodeDataUtils.generateNo("KP");
        addReqDto.setBillFlowNo(code);
        this.checkParameter(addReqDto);
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)addReqDto.getBillItemReqDtoList()), "\u5f00\u7968\u4fe1\u606f\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
        addReqDto.getBillItemReqDtoList().forEach(item -> item.setBillFlowNo(code));
        BillInfoEo billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billInfoEo);
        billInfoEo.setCreateType(BillCreateTypeEnum.HAND.getCode());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        this.getShopAllElectricInfo(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        List billItemReqDtoList = addReqDto.getBillItemReqDtoList();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        ArrayList<String> itemCodes = new ArrayList<String>();
        for (BillItemReqDto billItemReqDto : billItemReqDtoList) {
            itemCodes.add(billItemReqDto.getItemCode());
            BillItemEo billItemEo = new BillItemEo();
            BeanUtil.copyProperties((Object)billItemReqDto, (Object)billItemEo, (String[])new String[0]);
            billItemEo.setPlatformOrderNo(addReqDto.getPlatformOrderNo());
            billItemEo.setTaxAmount(this.calculateTaxAmount(billItemEo.getAmount(), billItemEo.getTaxRate()));
            billItemEoList.add(billItemEo);
        }
        this.getTaxCode(itemCodes, billItemEoList, billStrategyEo, exItemCodes);
        billItemEoList.forEach(a -> this.setSpecialRate(billInfoEo, (BillItemEo)a));
        this.billItemDas.insertBatch(billItemEoList);
        return billInfoEo.getId();
    }

    private void getTaxCode(List<String> itemCodes, List<BillItemEo> billItemEoList, BillStrategyEo billStrategyEo, Set<String> exItemCodes) {
        if (CollectionUtil.isEmpty(itemCodes) || CollectionUtil.isEmpty(billItemEoList)) {
            for (BillItemEo billItemEo : billItemEoList) {
                if (!Objects.isNull(billItemEo.getTaxClassificationCode())) continue;
                billItemEo.setTaxClassificationCode(billStrategyEo.getTaxCode());
            }
            return;
        }
        List<ItemSkuDgDto> itemSkuDgDtos = this.itemDgService.queryItemInfoBySkuCode(itemCodes);
        if (CollectionUtil.isEmpty(itemSkuDgDtos)) {
            return;
        }
        Map skuMap = itemSkuDgDtos.stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (k1, k2) -> k2));
        for (BillItemEo billItemEo : billItemEoList) {
            ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuMap.get(billItemEo.getItemCode());
            if (Objects.nonNull(itemSkuDgDto) && Objects.nonNull(itemSkuDgDto.getItemRateDgDto())) {
                ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
                if (Objects.isNull(billItemEo.getTaxClassificationCode())) {
                    String taxCode = Objects.isNull(itemRateDgDto) ? billStrategyEo.getTaxCode() : StrUtil.blankToDefault((CharSequence)itemRateDgDto.getCode(), (String)billStrategyEo.getTaxCode());
                    billItemEo.setTaxClassificationCode(taxCode);
                }
                if (!Objects.isNull(billItemEo.getTaxRate())) continue;
                billItemEo.setTaxRate(StrUtil.equals((CharSequence)itemRateDgDto.getCode(), (CharSequence)billStrategyEo.getTaxCode()) ? itemRateDgDto.getRate() : billStrategyEo.getTaxRate());
                continue;
            }
            if (exItemCodes.contains(billItemEo.getItemCode())) continue;
            if (Objects.isNull(billItemEo.getTaxClassificationCode()) && Objects.nonNull(billStrategyEo)) {
                billItemEo.setTaxClassificationCode(billStrategyEo.getTaxCode());
            }
            if (!Objects.isNull(billItemEo.getTaxRate()) || !Objects.nonNull(billStrategyEo)) continue;
            billItemEo.setTaxRate(billStrategyEo.getTaxRate());
        }
    }

    public Long relOrderAddReqDto(BillInfoReqDto addReqDto) {
        String platformOrderNo = addReqDto.getPlatformOrderNo();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5173\u8054\u7684\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        String[] split = platformOrderNo.split(",");
        List<String> platformOrderNoList = Arrays.asList(split);
        HashSet platformOrderNoSet = new HashSet();
        HashSet repeatPlatformOrderNoSet = new HashSet();
        platformOrderNoList.forEach(orderNo -> {
            if (platformOrderNoSet.contains(orderNo)) {
                repeatPlatformOrderNoSet.add(orderNo);
            } else {
                platformOrderNoSet.add(orderNo);
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(repeatPlatformOrderNoSet)) {
            String join = String.join((CharSequence)",", repeatPlatformOrderNoSet);
            throw new BizException("\u5e73\u53f0\u8ba2\u5355\u53f7\u91cd\u590d:" + join);
        }
        AtomicReference<Long> id = new AtomicReference<Long>(0L);
        List relPlatformList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformList)) {
            List billFlowNoList = relPlatformList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            List billFlowNoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billFlowNoEoList)) {
                List mergeEoList = billFlowNoEoList.stream().filter(x -> WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(x.getWhetherMergeBill())).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mergeEoList)) {
                    String platformOrderNoStr = mergeEoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
                    throw new BizException(String.format("%s:\u5e73\u53f0\u5355\u53f7\u5df2\u7ecf\u5b58\u5728\u5408\u5e76\u5f00\u7968\u5355\u636e", platformOrderNoStr));
                }
                List billInfoEoList = billFlowNoEoList.stream().filter(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState())).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billInfoEoList)) {
                    String platformOrderNoStr = billInfoEoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.joining(","));
                    throw new BizException(String.format("%s:\u5e73\u53f0\u5355\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u80fd\u65b0\u589e\u624b\u5de5\u5355", platformOrderNoStr));
                }
            }
        }
        platformOrderNoList.forEach(platformOrder -> {
            String code = this.generateCodeDataUtils.generateNo("KP");
            addReqDto.setBillFlowNo(code);
            addReqDto.setPlatformOrderNo(platformOrder);
            this.checkParameter(addReqDto);
            AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)addReqDto.getBillItemReqDtoList()), "\u5f00\u7968\u4fe1\u606f\u5546\u54c1\u4e0d\u80fd\u4e3a\u7a7a");
            addReqDto.getBillItemReqDtoList().forEach(item -> item.setBillFlowNo(code));
            BillInfoEo billInfoEo = new BillInfoEo();
            DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billInfoEo);
            billInfoEo.setCreateType(BillCreateTypeEnum.HAND.getCode());
            billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            this.getShopAllElectricInfo(billInfoEo);
            this.billInfoDas.insert((BaseEo)billInfoEo);
            ArrayList<String> platformOrderNos = new ArrayList<String>();
            platformOrderNos.add((String)platformOrder);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNos, code, RelBusinessTypeEnum.INVOICE.getCode());
            id.set(billInfoEo.getId());
            List billItemReqDtoList = addReqDto.getBillItemReqDtoList();
            ArrayList billItemEoList = new ArrayList();
            CubeBeanUtils.copyCollection(billItemEoList, (Collection)billItemReqDtoList, BillItemEo.class);
            billItemEoList.forEach(a -> this.setSpecialRate(billInfoEo, (BillItemEo)a));
            this.billItemDas.insertBatch(billItemEoList);
            this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode());
        });
        return id.get();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillInfo(BillInfoReqDto modifyReqDto) {
        BillInfoEo billInfoEo;
        BillStrategyRespDto billStrategyRespDto;
        String invoiceRemarks = modifyReqDto.getInvoiceRemarks();
        if (StrUtil.isNotBlank((CharSequence)invoiceRemarks) && (billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType((billInfoEo = (BillInfoEo)this.billInfoDas.selectByPrimaryKey(modifyReqDto.getId())).getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode())) != null && billStrategyRespDto.getRemarkLength() != null && invoiceRemarks.length() > billStrategyRespDto.getRemarkLength()) {
            throw new BizException(String.format("\u5f00\u7968\u5907\u6ce8\u8d85\u957f\uff0c\u9650\u5236\u957f\u5ea6 %s \u5b57\u7b26", billStrategyRespDto.getRemarkLength()));
        }
        billInfoEo = new BillInfoEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billInfoEo);
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillInfo(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billInfoDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto auditBillInfo(List<String> billFlowNoList) {
        List collect;
        logger.info("\u6839\u636e\u5f00\u7968\u6d41\u6c34\u53f7\u5ba1\u6838\u5f00\u7968\u4fe1\u606f-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        List platformOrderNoList = billInfoList.stream().map(BillInfoEo::getPlatformOrderNo).distinct().collect(Collectors.toList());
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billType.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        List billInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNoList)).in((Object)"bill_type", billType)).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
        logger.info("auditBillInfo:{}", (Object)JSONObject.toJSONString((Object)billInfoEos));
        Map<Object, Object> failMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(collect = billInfoEos.stream().filter(x -> x.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.INVOICING.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.FAILED.getCode())).collect(Collectors.toList()))) {
            failMap = collect.stream().collect(Collectors.toMap(BillInfoEo::getPlatformOrderNo, BaseEo::getId, (v1, v2) -> v1));
        }
        logger.info("billInfoEos-failMap:{}", (Object)JSONObject.toJSONString(failMap));
        List entityIdList = billInfoList.stream().map(BillInfoEo::getEntityId).distinct().collect(Collectors.toList());
        List billEntityEoList = ((ExtQueryChainWrapper)this.billEntityDas.filter().in((Object)"id", entityIdList)).list();
        Map billEntityMap = ((List)Optional.ofNullable(billEntityEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (v1, v2) -> v1));
        Map billMap = billInfoList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
        logger.info("billMap\u6839\u636e\u5f00\u7968\u6d41\u6c34\u53f7\u8f6c\u4e3amap:{}", (Object)JSONObject.toJSONString(billMap));
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        Map<String, List<BillItemEo>> billItemMap = billItemList.stream().collect(Collectors.groupingBy(BillItemEo::getBillFlowNo));
        ArrayList errorAllList = new ArrayList();
        ArrayList<String> successAuditList = new ArrayList<String>();
        Map<Object, Object> finalFailMap = failMap;
        billMap.forEach((k, billInfo) -> {
            ArrayList<String> errorList = new ArrayList<String>();
            this.auditCheck((String)k, (BillInfoEo)billInfo, billItemMap, (Map<String, Long>)finalFailMap, billEntityMap, (List<String>)errorList, (List<String>)successAuditList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
                errorAllList.addAll(errorList);
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setAuditTime(new Date());
                billInfoEo.setAuditPerson(this.context.userName());
                billInfoEo.setAuditFailReason(String.join((CharSequence)";", errorList));
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            }
        });
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successAuditList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billFlowNoList.size() - successAuditList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorAllList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorAllList));
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(successAuditList)) {
            successAuditList.forEach(billNo -> {
                BillInfoEo billInfo = (BillInfoEo)billMap.get(billNo);
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
                billInfoEo.setAuditTime(new Date());
                billInfoEo.setAuditPerson(this.context.userName());
                billInfoEo.setAuditFailReason("");
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            });
            this.successAuditSyncInvoice(successAuditList);
        }
        return batchOperationRespDto;
    }

    public void successAuditSyncInvoice(List<String> successAuditList) {
        logger.info("\u5ba1\u6838\u901a\u8fc7\u5f02\u6b65\u8c03\u7528\u5f00\u7968\u63a5\u53e3\uff1a{}", (Object)JSONObject.toJSONString(successAuditList));
        this.commonsMqService.sendSingleMessage("SINGLE_TOPIC", "INVOICE_SYNC_TAG", successAuditList);
        logger.info("\u5ba1\u6838\u901a\u8fc7\u5f02\u6b65\u8c03\u7528\u5f00\u7968\u63a5\u53e3\u5b8c\u6210");
    }

    public void auditCheck(String k, BillInfoEo billInfo, Map<String, List<BillItemEo>> billItemMap, Map<String, Long> finalFailMap, Map<Long, BillEntityEo> billEntityMap, List<String> errorList, List<String> successAuditList) {
        if (InvoiceStateEnum.WAIT_AUDIT.getCode().equals(billInfo.getInvoiceState())) {
            List<BillItemEo> billItem;
            AtomicBoolean flag = new AtomicBoolean(true);
            BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(billInfo.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
            if (billStrategyRespDto != null && billStrategyRespDto.getRemarkLength() != null && StrUtil.isNotBlank((CharSequence)billInfo.getInvoiceRemarks()) && billInfo.getInvoiceRemarks().length() > billStrategyRespDto.getRemarkLength()) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u5907\u6ce8\u8d85\u8fc7\u5907\u6ce8\u957f\u5ea6\uff0c\u4e0d\u80fd\u5f00\u7968", k));
                flag.set(false);
            }
            logger.info("finalFailMap:{}", (Object)JSONObject.toJSONString(finalFailMap));
            boolean isBlueTicket = BillInfoColourTypeEnum.BLUE_TICKET.equalsCode(billInfo.getBillType());
            if (finalFailMap.containsKey(billInfo.getPlatformOrderNo()) && isBlueTicket) {
                errorList.add(String.format("%s\u5b58\u5728\u7ea2\u7968\u672a\u5f00\u7968\u6210\u529f,\u84dd\u7968\u65e0\u6cd5\u5ba1\u6838\u901a\u8fc7", k));
                flag.set(false);
            }
            if (!StrUtil.isNotBlank((CharSequence)billInfo.getDistributorTaxesCode()) || !Pattern.matches("^[a-zA-Z0-9]{0,18}$", billInfo.getDistributorTaxesCode())) {
                errorList.add("\u9500\u65b9\u4f01\u4e1a\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5f02\u5e38\uff0c\u957f\u5ea6\u9700\u4e3a\u4e0d\u8d85\u8fc718\u4f4d\uff0c\u4e14\u4ec5\u4e3a\u6570\u5b57\u6216\u5927\u5199\u5b57\u6bcd");
                flag.set(false);
            }
            if (StrUtil.isNotBlank((CharSequence)billInfo.getTaxesCode()) && !Pattern.matches("^[a-zA-Z0-9]{0,18}$", billInfo.getTaxesCode())) {
                errorList.add("\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u5f02\u5e38\uff0c\u957f\u5ea6\u9700\u4e3a\u4e0d\u8d85\u8fc718\u4f4d\uff0c\u4e14\u4ec5\u4e3a\u6570\u5b57\u6216\u5927\u5199\u5b57\u6bcd");
                flag.set(false);
            }
            if (StrUtil.isNotBlank((CharSequence)billInfo.getRegisteredPhone()) && !Pattern.matches("\\d{3}-?\\d{7}|\\d{4}-?\\d{0,10}|\\d{3}-?\\d{8}|\\d{3,14}", billInfo.getRegisteredPhone())) {
                errorList.add("\u6ce8\u518c\u7535\u8bdd\u7684\u683c\u5f0f\u4e0d\u5bf9");
                flag.set(false);
            }
            if (StrUtil.isNotBlank((CharSequence)billInfo.getDistributorRegisteredPhone()) && !Pattern.matches("\\d{3}-?\\d{7}|\\d{4}-?\\d{0,10}|\\d{3}-?\\d{8}|\\d{3,14}", billInfo.getDistributorRegisteredPhone())) {
                errorList.add("\u9500\u65b9\u6ce8\u518c\u7535\u8bdd\u7684\u683c\u5f0f\u4e0d\u5bf9");
                flag.set(false);
            }
            if (StrUtil.isNotBlank((CharSequence)billInfo.getDistributorBankAccount()) && !billInfo.getDistributorBankAccount().matches("^\\d*$")) {
                errorList.add("\u94f6\u884c\u8d26\u53f7\u5f02\u5e38\uff0c\u9700\u4e3a\u7eaf\u6570\u5b57");
                flag.set(false);
            }
            if (StrUtil.isNotBlank((CharSequence)billInfo.getBankAccount()) && !billInfo.getBankAccount().matches("^\\d*$")) {
                errorList.add("\u94f6\u884c\u8d26\u53f7\u5f02\u5e38\uff0c\u9700\u4e3a\u7eaf\u6570\u5b57");
                flag.set(false);
            }
            if (billEntityMap.containsKey(billInfo.getEntityId())) {
                BillEntityEo billEntityEo = billEntityMap.get(billInfo.getEntityId());
                if (BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfo.getInvoiceType()) && null != billEntityEo.getEleComInvoiceLimit() && billInfo.getInvoiceAmount().compareTo(billEntityEo.getEleComInvoiceLimit()) > 0) {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d", k));
                    flag.set(false);
                }
                if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfo.getInvoiceType()) && null != billEntityEo.getPapComInvoiceLimit() && billInfo.getInvoiceAmount().compareTo(billEntityEo.getPapComInvoiceLimit()) > 0) {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d", k));
                    flag.set(false);
                }
                if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfo.getInvoiceType()) && null != billEntityEo.getPapSpeInvoiceLimit() && billInfo.getInvoiceAmount().compareTo(billEntityEo.getPapSpeInvoiceLimit()) > 0) {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d", k));
                    flag.set(false);
                }
                if (BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfo.getInvoiceType()) && null != billEntityEo.getAllEleComInvoiceLimit() && billInfo.getInvoiceAmount().compareTo(billEntityEo.getAllEleComInvoiceLimit()) > 0) {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d", k));
                    flag.set(false);
                }
                if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfo.getInvoiceType()) && null != billEntityEo.getAllEleSpeInvoiceLimit() && billInfo.getInvoiceAmount().compareTo(billEntityEo.getAllEleSpeInvoiceLimit()) > 0) {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d", k));
                    flag.set(false);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)billInfo.getBillPersonPhone()) && !billInfo.getBillPersonPhone().matches("1[0-9]\\d{9}")) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5f00\u7968\u4eba\u7535\u8bdd\u586b\u5199\u683c\u5f0f\u9519\u8bef", k));
                flag.set(false);
            }
            if (BigDecimal.ZERO.compareTo(billInfo.getInvoiceAmount()) >= 0) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u53d1\u7968\u603b\u91d1\u989d\u4e3a\u96f6", k));
                flag.set(false);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItem = billItemMap.get(k))) {
                billItem.forEach(item -> {
                    if (StringUtils.isEmpty((CharSequence)item.getTaxClassificationCode())) {
                        errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5546\u54c1%s\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", k, item.getItemCode()));
                        flag.set(false);
                    }
                    if (null == item.getTaxRate() || BigDecimal.ZERO.compareTo(item.getTaxRate()) == 0) {
                        errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5546\u54c1%s\u7a0e\u7387\u4e3a\u7a7a", k, item.getItemCode()));
                        flag.set(false);
                    }
                    if (StringUtils.isBlank((CharSequence)item.getBillLineItemName())) {
                        errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5546\u54c1%s\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a", k, item.getItemCode()));
                        flag.set(false);
                    }
                });
            } else {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u7684\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a", k));
                flag.set(false);
            }
            if (SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode().equals(billInfo.getSubsidiesType())) {
                logger.info("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cnational_supplement:{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
                logger.info("\u62ac\u5934billTitle,blackListContent:{},{}", (Object)billInfo.getBillTitle(), (Object)billStrategyRespDto.getBlackListContent());
                if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfo.getBillType()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getUseBlackList()) && UseBlackListEnum.YES.getCode().equals(billStrategyRespDto.getUseBlackList()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBlackListContent()) && (billInfo.getBillTitle().contains(billStrategyRespDto.getBlackListContent()) || billStrategyRespDto.getBlackListContent().contains(billInfo.getBillTitle()))) {
                    errorList.add("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355");
                    flag.set(false);
                }
            }
            if (BillInfoColourTypeEnum.BLUE_TICKET.equalsCode(billInfo.getBillType())) {
                List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.RED_TICKET.getCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                    List collect = billInfoEoList.stream().filter(x -> "invoicing".equals(x.getInvoiceState())).collect(Collectors.toList());
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect)) {
                        errorList.add("\u5b58\u5728\u5f00\u7968\u4e2d\u7684\u7ea2\u7968");
                        flag.set(false);
                    } else {
                        List blueBillInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).in((Object)"invoice_state", Arrays.asList("billed", "invoicing", "wait_bill", "failed"))).list();
                        logger.info("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968blueBillInfoEoList:{},{}", (Object)billInfo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)blueBillInfoEoList)) {
                            errorList.add("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968");
                            flag.set(false);
                        }
                    }
                } else {
                    List blueBillInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).in((Object)"invoice_state", Arrays.asList("billed", "invoicing", "wait_bill", "failed"))).list();
                    logger.info("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968blueBillInfoEoList:{},{}", (Object)billInfo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)blueBillInfoEoList)) {
                        errorList.add("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968");
                        flag.set(false);
                    }
                }
            }
            if (flag.get()) {
                successAuditList.add(k);
            }
        } else {
            errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s\u4e0d\u662f\u5f85\u5ba1\u6838\u72b6\u6001", k));
        }
    }

    @Override
    public BillInfoRespDto queryById(Long id) {
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"id", (Object)id)).one();
        BillInfoRespDto billInfoRespDto = new BillInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoRespDto);
        return billInfoRespDto;
    }

    @Override
    public BillInfoRespDto queryByBillFlowNo(String billFlowNo) {
        logger.info("\u6839\u636e\u5f00\u7968\u6d41\u6c34\u53f7\u67e5\u8be2\u5f00\u7968\u4fe1\u606f-\u8f93\u5165:{}", (Object)billFlowNo);
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billFlowNo)).one();
        BillInfoRespDto billInfoRespDto = new BillInfoRespDto();
        DtoHelper.eo2Dto((BaseEo)billInfoEo, (BaseVo)billInfoRespDto);
        return billInfoRespDto;
    }

    @Override
    public List<BillInfoRespDto> queryByBillFlowNoList(BillInfoListQueryDto billInfoListQueryDto) {
        logger.info("\u6839\u636e\u96c6\u5408\u6761\u4ef6\u67e5\u8be2\u5f00\u7968\u4fe1\u606f-\u8f93\u5165:{}", (Object)JSONObject.toJSONString((Object)billInfoListQueryDto));
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoListQueryDto.getBillFlowNoList()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoListQueryDto.getPlatformOrderNoList()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoListQueryDto.getApplyNoList()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoListQueryDto.getSaleOrderNoList()) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoListQueryDto.getNotInvoiceStateList()) && StringUtils.isEmpty((CharSequence)billInfoListQueryDto.getBillType())) {
            return new ArrayList<BillInfoRespDto>();
        }
        ExtQueryChainWrapper filter = this.billInfoDas.filter();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoListQueryDto.getBillFlowNoList())) {
            filter.in((Object)"bill_flow_no", (Collection)billInfoListQueryDto.getBillFlowNoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoListQueryDto.getPlatformOrderNoList())) {
            filter.in((Object)"platform_order_no", (Collection)billInfoListQueryDto.getPlatformOrderNoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoListQueryDto.getApplyNoList())) {
            filter.in((Object)"apply_no", (Collection)billInfoListQueryDto.getApplyNoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoListQueryDto.getSaleOrderNoList())) {
            filter.in((Object)"sale_order_no", (Collection)billInfoListQueryDto.getSaleOrderNoList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoListQueryDto.getNotInvoiceStateList())) {
            filter.notIn((Object)"invoice_state", (Collection)billInfoListQueryDto.getNotInvoiceStateList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoListQueryDto.getBillType())) {
            filter.eq((Object)"bill_type", (Object)billInfoListQueryDto.getBillType());
        }
        List list = filter.list();
        ArrayList<BillInfoRespDto> billInfoRespDtoList = new ArrayList<BillInfoRespDto>();
        DtoHelper.eoList2DtoList((Collection)list, billInfoRespDtoList, BillInfoRespDto.class);
        return billInfoRespDtoList;
    }

    @Override
    public PageInfo<BillInfoRespDto> queryByPage(BillInfoQueryDto billInfoQueryDto) {
        logger.info("\u5f00\u7968\u4fe1\u606f\u5217\u8868\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)billInfoQueryDto));
        Integer pageNum = billInfoQueryDto.getPageNum();
        Integer pageSize = billInfoQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<BillInfoEo> param = this.assembleCondition(billInfoQueryDto);
        PageInfo eoPageInfo = param.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillInfoRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public Map<String, BigDecimal> queryTotal(BillInfoQueryDto billInfoQueryDto) {
        HashMap resultMap = Maps.newHashMap();
        BigDecimal sumAmount = BigDecimal.ZERO;
        logger.info("\u5f00\u7968\u91d1\u989d\u6c47\u603b-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)billInfoQueryDto));
        ExtQueryChainWrapper sqlFilters = this.billInfoDas.filter().select(new String[]{"id,bill_flow_no,bill_type,invoice_amount"});
        this.assemblequeryTotalCondition((ExtQueryChainWrapper<BillInfoEo>)sqlFilters, billInfoQueryDto);
        List billInfoEoList = sqlFilters.list();
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billInfoEoList)) {
            resultMap.put("sumAmount", sumAmount);
            return resultMap;
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
            logger.info("\u5f00\u7968\u6c47\u603b:{}", (Object)billInfoEoList.size());
            BigDecimal blueDecimal = BigDecimal.ZERO;
            List blueCollect = billInfoEoList.stream().filter(x -> null != x.getInvoiceAmount() && BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(x.getBillType())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(blueCollect)) {
                blueDecimal = blueCollect.stream().filter(x -> null != x.getInvoiceAmount()).map(BillInfoEo::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(6, 4);
            }
            logger.info("\u84dd\u7968\u5408\u8ba1\u6c47\u603bdecimal:", (Object)blueDecimal);
            BigDecimal redDecimal = BigDecimal.ZERO;
            List redCollect = billInfoEoList.stream().filter(x -> null != x.getInvoiceAmount() && BillInfoColourTypeEnum.RED_TICKET.getCode().equals(x.getBillType())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(redCollect)) {
                redDecimal = redCollect.stream().filter(x -> null != x.getInvoiceAmount()).map(BillInfoEo::getInvoiceAmount).reduce(BigDecimal.ZERO, BigDecimal::add).setScale(6, 4);
            }
            logger.info("\u7ea2\u7968\u5408\u8ba1\u6c47\u603bdecimal:", (Object)blueDecimal);
            sumAmount = sumAmount.add(blueDecimal).add(redDecimal.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : redDecimal.negate());
            logger.info("\u5f00\u7968\u91d1\u989d\u6c47\u603bsumAmount:{}", (Object)sumAmount);
            resultMap.put("sumAmount", sumAmount);
        }
        return resultMap;
    }

    public ExtQueryChainWrapper<BillInfoEo> assemblequeryTotalCondition(ExtQueryChainWrapper<BillInfoEo> filter, BillInfoQueryDto billInfoQueryDto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getNotInId())) {
            filter.notIn((Object)"id", (Collection)billInfoQueryDto.getNotInId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceChannel())) {
            filter.eq((Object)"bill_channel", (Object)billInfoQueryDto.getInvoiceChannel());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceHeaderType())) {
            filter.eq((Object)"title_type", (Object)billInfoQueryDto.getInvoiceHeaderType());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getBillFlowNo())) {
            filter.eq((Object)"bill_flow_no", (Object)billInfoQueryDto.getBillFlowNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getBillFlowNoList())) {
            if (billInfoQueryDto.getBillFlowNoList().size() > 1) {
                filter.in((Object)"bill_flow_no", (Collection)billInfoQueryDto.getBillFlowNoList());
            } else {
                filter.like((Object)"bill_flow_no", billInfoQueryDto.getBillFlowNoList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getApplyNo())) {
            filter.eq((Object)"apply_no", (Object)billInfoQueryDto.getApplyNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getEntityCode())) {
            filter.eq((Object)"entity_code", (Object)billInfoQueryDto.getEntityCode());
        }
        if (Objects.nonNull(billInfoQueryDto.getEntityId())) {
            filter.eq((Object)"entity_id", (Object)billInfoQueryDto.getEntityId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getPlatformOrderNo())) {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)billInfoQueryDto.getPlatformOrderNo())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                filter.eq((Object)"platform_order_no", (Object)billInfoQueryDto.getPlatformOrderNo());
            } else {
                List billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                filter.in((Object)"bill_flow_no", billFlowNoList);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getPlatformOrderNoList())) {
            ArrayList orderNoList = Lists.newArrayList();
            List orderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"distribution_order_no", (Collection)billInfoQueryDto.getPlatformOrderNoList())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderInfoEos)) {
                List collect = orderInfoEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().collect(Collectors.toList());
                orderNoList.addAll(collect);
            }
            List list = Lists.newArrayList();
            list = billInfoQueryDto.getPlatformOrderNoList().size() > 1 ? ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().in((Object)"platform_order_no", (Collection)billInfoQueryDto.getPlatformOrderNoList())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list() : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().like((Object)"platform_order_no", billInfoQueryDto.getPlatformOrderNoList().get(0))).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                orderNoList.addAll(billInfoQueryDto.getPlatformOrderNoList());
                if (orderNoList.size() > 1) {
                    filter.in((Object)"platform_order_no", (Collection)orderNoList);
                } else {
                    filter.like((Object)"platform_order_no", orderNoList.get(0));
                }
            } else {
                List<String> billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderNoList)) {
                    orderNoList.addAll(orderNoList);
                    StringBuilder sql = new StringBuilder();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
                        sql.append(" ( bill_flow_no in ( ");
                        billFlowNoList.forEach(v -> {
                            sql.append("'" + v + "'");
                            sql.append(",");
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
                        sql.deleteCharAt(sql.length() - 1);
                    }
                    sql.append(" ) OR platform_order_no IN (");
                    orderNoList.forEach(v -> {
                        sql.append("'" + v + "'");
                        sql.append(",");
                    });
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" ) ");
                    sql.append(" ) ");
                    filter.apply(sql.toString(), new Object[0]);
                } else {
                    StringBuilder sql = new StringBuilder();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
                        sql.append(" ( bill_flow_no in ( ");
                        billFlowNoList.forEach(v -> {
                            sql.append("'" + v + "'");
                            sql.append(",");
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
                        sql.deleteCharAt(sql.length() - 1);
                    }
                    sql.append(" ) OR platform_order_no IN (");
                    billInfoQueryDto.getPlatformOrderNoList().forEach(v -> {
                        sql.append("'" + v + "'");
                        sql.append(",");
                    });
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" ) ");
                    sql.append(" ) ");
                    filter.apply(sql.toString(), new Object[0]);
                }
            }
        }
        if (Objects.nonNull(billInfoQueryDto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)billInfoQueryDto.getShopId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getShopCode())) {
            filter.eq((Object)"shop_code", (Object)billInfoQueryDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSaleOrderNo())) {
            filter.eq((Object)"sale_order_no", (Object)billInfoQueryDto.getSaleOrderNo());
        }
        if (Objects.nonNull(billInfoQueryDto.getBillType())) {
            filter.eq((Object)"bill_type", (Object)billInfoQueryDto.getBillType());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getBillTypeList())) {
            filter.in((Object)"bill_type", (Collection)billInfoQueryDto.getBillTypeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceType())) {
            filter.eq((Object)"invoice_type", (Object)billInfoQueryDto.getInvoiceType());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getBlueTicketInvoiceNo())) {
            filter.eq((Object)"blue_ticket_invoice_no", (Object)billInfoQueryDto.getBlueTicketInvoiceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateBeginTime())) {
            filter.ge((Object)"create_time", (Object)(billInfoQueryDto.getCreateBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateEndTime())) {
            filter.le((Object)"create_time", (Object)(billInfoQueryDto.getCreateEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceState())) {
            filter.eq((Object)"invoice_state", (Object)billInfoQueryDto.getInvoiceState());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getInvoiceStateList())) {
            filter.in((Object)"invoice_state", (Collection)billInfoQueryDto.getInvoiceStateList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceBeginTime())) {
            filter.ge((Object)"external_invoice_time", (Object)(billInfoQueryDto.getExternalInvoiceBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceEndTime())) {
            filter.le((Object)"external_invoice_time", (Object)(billInfoQueryDto.getExternalInvoiceEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceNo())) {
            filter.eq((Object)"external_invoice_no", (Object)billInfoQueryDto.getExternalInvoiceNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getExternalInvoiceNoList())) {
            filter.in((Object)"external_invoice_no", (Collection)billInfoQueryDto.getExternalInvoiceNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceCode())) {
            filter.eq((Object)"external_invoice_code", (Object)billInfoQueryDto.getExternalInvoiceCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getExternalInvoiceCodeList())) {
            filter.in((Object)"external_invoice_code", (Collection)billInfoQueryDto.getExternalInvoiceCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSite())) {
            filter.eq((Object)"site", (Object)billInfoQueryDto.getSite());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSiteCode())) {
            filter.eq((Object)"site_code", (Object)billInfoQueryDto.getSiteCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getFilterSite())) {
            filter.in((Object)"site", (Collection)SiteChannelEnum.getNameByFilterName((String)billInfoQueryDto.getFilterSite()));
        }
        if (null != billInfoQueryDto.getWhetherMergeBill()) {
            filter.eq((Object)"whether_merge_bill", (Object)billInfoQueryDto.getWhetherMergeBill());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCustomerCode())) {
            filter.eq((Object)"customer_code", (Object)billInfoQueryDto.getCustomerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditBeginTime())) {
            filter.ge((Object)"audit_time", (Object)(billInfoQueryDto.getAuditBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditEndTime())) {
            filter.le((Object)"audit_time", (Object)(billInfoQueryDto.getAuditEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getPushPlatformState())) {
            filter.eq((Object)"push_platform_state", (Object)billInfoQueryDto.getPushPlatformState());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getFinanceReceivableNo())) {
            filter.eq((Object)"finance_receivable_no", (Object)billInfoQueryDto.getFinanceReceivableNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getSiteCodeList())) {
            filter.in((Object)"site_code", (Collection)billInfoQueryDto.getSiteCodeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getShopCodeList())) {
            filter.in((Object)"shop_code", (Collection)billInfoQueryDto.getShopCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceRemarks())) {
            filter.like((Object)"invoice_remarks", (Object)billInfoQueryDto.getInvoiceRemarks());
        }
        filter.eq(billInfoQueryDto.getSubsidiesType() != null, (Object)"subsidies_type", (Object)billInfoQueryDto.getSubsidiesType());
        return filter;
    }

    @Override
    public PageInfo<BillItemExportDto> queryBillItemList(BillInfoQueryDto billInfoQueryDto) {
        logger.info("\u53d1\u7968\u660e\u7ec6\u5bfc\u51fa\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)billInfoQueryDto));
        Integer pageNum = billInfoQueryDto.getPageNum();
        Integer pageSize = billInfoQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditBeginTime())) {
            billInfoQueryDto.setAuditBeginTime(billInfoQueryDto.getAuditBeginTime() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditEndTime())) {
            billInfoQueryDto.setAuditEndTime(billInfoQueryDto.getAuditEndTime() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceBeginTime())) {
            billInfoQueryDto.setExternalInvoiceBeginTime(billInfoQueryDto.getExternalInvoiceBeginTime() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceEndTime())) {
            billInfoQueryDto.setExternalInvoiceEndTime(billInfoQueryDto.getExternalInvoiceEndTime() + " 23:59:59");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateBeginTime())) {
            billInfoQueryDto.setCreateBeginTime(billInfoQueryDto.getCreateBeginTime() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateEndTime())) {
            billInfoQueryDto.setCreateEndTime(billInfoQueryDto.getCreateEndTime() + " 23:59:59");
        }
        PageInfo pageInfo = this.billInfoDas.queryBillItemList(billInfoQueryDto, pageNum, pageSize);
        return pageInfo;
    }

    @Override
    public PageInfo<InvoiceItemRespDto> queryItemByPage(InvoiceItemQueryDto invoiceItemDto) {
        logger.info("\u53d1\u7968\u8be6\u60c5\u5217\u8868\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)invoiceItemDto));
        if (invoiceItemDto.getPageNum() != null && invoiceItemDto.getPageSize() != null) {
            PageHelper.startPage((int)invoiceItemDto.getPageNum(), (int)invoiceItemDto.getPageSize());
        }
        List invoiceItemDtos = this.billInfoMapper.queryItemByPage(invoiceItemDto);
        logger.info("\u53d1\u7968\u8be6\u60c5\u5217\u8868\u67e5\u8be2-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)invoiceItemDtos));
        return new PageInfo(invoiceItemDtos);
    }

    @Override
    public PageInfo<InvoiceVerificationRespDto> queryVerificationByPage(InvoiceVerificationQueryDto invoiceVerificationQueryDto) {
        logger.info("\u53d1\u7968\u6838\u5bf9\u5217\u8868\u67e5\u8be2-\u8f93\u5165:{}", (Object)JSON.toJSONString((Object)invoiceVerificationQueryDto));
        if (invoiceVerificationQueryDto.getPageNum() != null && invoiceVerificationQueryDto.getPageSize() != null) {
            PageHelper.startPage((int)invoiceVerificationQueryDto.getPageNum(), (int)invoiceVerificationQueryDto.getPageSize());
        }
        List list = this.billInfoMapper.queryVerificationByPage(invoiceVerificationQueryDto);
        logger.info("\u53d1\u7968\u6838\u5bf9\u5217\u8868\u67e5\u8be2-\u8f93\u51fa:{}", (Object)JSON.toJSONString((Object)list));
        return new PageInfo(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String getInvoicePdf(String billFlowNo) {
        logger.info("\u83b7\u53d6\u5f00\u7968pdf\u5730\u5740-\u8f93\u5165:{}", (Object)billFlowNo);
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billFlowNo)).one();
        if (Objects.nonNull(billInfoEo)) {
            String pdfUrl = this.uploadPdfUrl(billFlowNo, billInfoEo.getInvoiceConnectUrl());
            if (StringUtils.isEmpty((CharSequence)pdfUrl)) {
                throw new BizException("\u53d1\u7968\u4e0a\u4f20\u4e2d\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            BillInfoEo infoEo = new BillInfoEo();
            infoEo.setId(billInfoEo.getId());
            infoEo.setUploadPdfUrl(pdfUrl);
            this.billInfoDas.updateSelective((BaseEo)infoEo);
            return pdfUrl;
        }
        throw new BizException(String.format("\u672a\u67e5\u8be2\u5230\u8be5\u5f00\u7968\u4fe1\u606f\uff1a%s", billFlowNo));
    }

    @Override
    public BillInfoRespDto queryBillDetailByApplyNo(String applyNo) {
        BillInfoRespDto billInfoRespDto = new BillInfoRespDto();
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)applyNo), "\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u6839\u636e\u7533\u8bf7\u5355\u53f7\u67e5\u8be2\u5f00\u7968\u8be6\u7ec6\u4fe1\u606f-\u8f93\u5165:{}", (Object)applyNo);
        List relPlatformEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).eq((Object)"business_order_no", (Object)applyNo)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformEoList)) {
            List platformOrderNoList = relPlatformEoList.stream().map(BillBusinessRelPlatformEo::getPlatformOrderNo).distinct().collect(Collectors.toList());
            List billInfoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoList)) {
                List billFlowNoList = billInfoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).list();
                ArrayList<String> invoiceStatus = new ArrayList<String>();
                invoiceStatus.add(InvoiceStateEnum.WAIT_AUDIT.getCode());
                invoiceStatus.add(InvoiceStateEnum.WAIT_BILL.getCode());
                invoiceStatus.add(InvoiceStateEnum.BILLED.getCode());
                List infoEoList = billInfoEoList.stream().filter(x -> invoiceStatus.contains(x.getInvoiceState())).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(infoEoList)) {
                    BillInfoEo billInfoEo = (BillInfoEo)infoEoList.get(0);
                    CubeBeanUtils.copyProperties((Object)billInfoRespDto, (Object)billInfoEo, (String[])new String[0]);
                    List billItemEoList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).list();
                    ArrayList itemRespDtoList = new ArrayList();
                    CubeBeanUtils.copyCollection(itemRespDtoList, (Collection)billItemEoList, BillItemRespDto.class);
                    billInfoRespDto.setItemRespDtoList(itemRespDtoList);
                }
            }
        }
        return billInfoRespDto;
    }

    @Override
    public PageInfo<BillInfoReportRespDto> queryBillInfoReportPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        logger.info("\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u62a5\u8868\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)billInfoReportQueryDto));
        Integer pageNum = billInfoReportQueryDto.getPageNum();
        Integer pageSize = billInfoReportQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        BillInfoReportQueryVo billInfoReportQueryVo = new BillInfoReportQueryVo();
        CubeBeanUtils.copyProperties((Object)billInfoReportQueryVo, (Object)billInfoReportQueryDto, (String[])new String[0]);
        PageInfo billInfoReportRespVoPageInfo = this.billInfoDas.queryBillInfoReportPage(billInfoReportQueryVo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billInfoReportRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList billInfoReportRespDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportRespVoPageInfo.getList())) {
            CubeBeanUtils.copyCollection(billInfoReportRespDtoList, (Collection)billInfoReportRespVoPageInfo.getList(), BillInfoReportRespDto.class);
        }
        pageInfo.setList(billInfoReportRespDtoList);
        return pageInfo;
    }

    @Override
    public PageInfo<BillItemReportRespDto> queryBillItemReportPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        logger.info("\u67e5\u8be2\u53d1\u7968\u5546\u54c1\u660e\u7ec6\u62a5\u8868\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)billInfoReportQueryDto));
        Integer pageNum = billInfoReportQueryDto.getPageNum();
        Integer pageSize = billInfoReportQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        BillInfoReportQueryVo billInfoReportQueryVo = new BillInfoReportQueryVo();
        CubeBeanUtils.copyProperties((Object)billInfoReportQueryVo, (Object)billInfoReportQueryDto, (String[])new String[0]);
        PageInfo billItemReportRespVoPageInfo = this.billInfoDas.queryBillItemReportPage(billInfoReportQueryVo, pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)billItemReportRespVoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList billItemReportRespDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billItemReportRespVoPageInfo.getList())) {
            CubeBeanUtils.copyCollection(billItemReportRespDtoList, (Collection)billItemReportRespVoPageInfo.getList(), BillItemReportRespVo.class);
        }
        pageInfo.setList(billItemReportRespDtoList);
        return pageInfo;
    }

    @Override
    public BillInfoRespDto queryBillInfoByPlatformOrderNo(String platformOrderNo) {
        logger.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u67e5\u8be2\u5df2\u5f00\u53d1\u7968\u4fe1\u606f:{}", (Object)platformOrderNo);
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)platformOrderNo), "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        BillInfoRespDto billInfoRespDto = new BillInfoRespDto();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            CubeBeanUtils.copyProperties((Object)billInfoRespDto, list.get(0), (String[])new String[0]);
        }
        return billInfoRespDto;
    }

    @Override
    public PageInfo<BillInfoRespDto> queryBillAndItemByPage(BillInfoQueryDto billInfoQueryDto) {
        List<String> billFlowNos;
        List<BillItemRespDto> itemRespDtos;
        logger.info("\u53d1\u7968\u4fe1\u606f\u8868\u5206\u9875\u6570\u636e\uff0c\u5e76\u67e5\u8be2\u76f8\u5173\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)billInfoQueryDto));
        BillInfoQueryDto billInfoQueryOne = new BillInfoQueryDto();
        CubeBeanUtils.copyProperties((Object)billInfoQueryOne, (Object)billInfoQueryDto, (String[])new String[0]);
        ArrayList<String> invoiceStateList = new ArrayList<String>();
        invoiceStateList.add(InvoiceStateEnum.WAIT_BILL.getCode());
        invoiceStateList.add(InvoiceStateEnum.INVOICING.getCode());
        billInfoQueryOne.setInvoiceStateList(invoiceStateList);
        ArrayList<String> billTypeList = new ArrayList<String>();
        billTypeList.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billTypeList.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        billInfoQueryOne.setBillTypeList(billTypeList);
        PageInfo<BillInfoRespDto> pageInfo = this.queryByPage(billInfoQueryOne);
        if (pageInfo.getList().size() < billInfoQueryDto.getPageSize()) {
            PageInfo<BillInfoRespDto> pageInfoTwo;
            BillInfoQueryDto billInfoQueryTwo = new BillInfoQueryDto();
            CubeBeanUtils.copyProperties((Object)billInfoQueryTwo, (Object)billInfoQueryDto, (String[])new String[0]);
            billInfoQueryTwo.setPageNum(Integer.valueOf(1));
            billInfoQueryTwo.setPageSize(Integer.valueOf(billInfoQueryDto.getPageSize() - pageInfo.getList().size()));
            billInfoQueryTwo.setInvoiceStateList(invoiceStateList);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                billInfoQueryTwo.setNotInId(pageInfo.getList().stream().map(BillInfoRespDto::getId).collect(Collectors.toList()));
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(pageInfoTwo = this.queryByPage(billInfoQueryTwo)).getList())) {
                pageInfo.getList().addAll(pageInfoTwo.getList());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)pageInfo.getList()) && org.apache.commons.collections.CollectionUtils.isNotEmpty(itemRespDtos = this.billItemService.queryItemByBillFlowNos(billFlowNos = pageInfo.getList().stream().map(BillInfoRespDto::getBillFlowNo).collect(Collectors.toList())))) {
            Map<String, List<BillItemRespDto>> itemMap = itemRespDtos.stream().collect(Collectors.groupingBy(BillItemRespDto::getBillFlowNo));
            pageInfo.getList().forEach(e -> {
                List itemRespDtoList = (List)itemMap.get(e.getBillFlowNo());
                e.setItemRespDtoList(itemRespDtoList);
            });
        }
        return pageInfo;
    }

    @Override
    public PageInfo<BillItemReportRespDto> queryBillItemReportNewPage(BillInfoReportQueryDto billInfoReportQueryDto) {
        logger.info("\u67e5\u8be2\u53d1\u7968\u5546\u54c1\u660e\u7ec6\u62a5\u8868\u4fe1\u606f:{}", (Object)JSONObject.toJSONString((Object)billInfoReportQueryDto));
        Integer pageNum = billInfoReportQueryDto.getPageNum();
        Integer pageSize = billInfoReportQueryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<BillInfoEo> filter = this.assembleReportCondition(billInfoReportQueryDto);
        PageInfo page = filter.page(pageNum, pageSize);
        PageInfo pageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)pageInfo, (Object)page, (String[])new String[]{"list", "navigatepageNums"});
        List list = page.getList();
        ArrayList billItemReportRespDtoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            Map billMap = list.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
            Set<String> billFlowNoList = billMap.keySet();
            List orderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
            Map<String, List<BillOrderItemEo>> map = orderItemList.stream().collect(Collectors.groupingBy(BillOrderItemEo::getBillFlowNo));
            List billItemEoList = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
            Map<String, List<BillItemEo>> billItemMap = billItemEoList.stream().collect(Collectors.groupingBy(BillItemEo::getBillFlowNo));
            map.forEach((k, v) -> this.getBillItemReportRespDto(billMap, billItemMap, (String)k, (List<BillOrderItemEo>)v, billItemReportRespDtoList));
        }
        pageInfo.setList(billItemReportRespDtoList);
        return pageInfo;
    }

    public void getBillItemReportRespDto(Map<String, BillInfoEo> billMap, Map<String, List<BillItemEo>> billItemMap, String k, List<BillOrderItemEo> v, List<BillItemReportRespDto> billItemReportRespDtoList) {
        BigDecimal taxAmount;
        BillItemReportRespDto reportRespDto;
        int i;
        BillInfoEo billInfoEo = billMap.get(k);
        List<BillItemEo> itemList = billItemMap.get(k);
        BigDecimal taxAmountTotal = itemList.stream().map(item -> item.getAmount().abs().divide(item.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(item.getTaxRate()).setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
        AtomicBoolean flag = new AtomicBoolean(false);
        if (!BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType())) {
            flag.set(true);
            taxAmountTotal = taxAmountTotal.negate();
        }
        Map itemMap = itemList.stream().collect(Collectors.toMap(BillItemEo::getItemCode, Function.identity(), (v1, v2) -> v1));
        ArrayList normalItem = new ArrayList();
        ArrayList combinationItem = new ArrayList();
        v.forEach(info -> {
            BillItemReportRespDto billItemReport = this.getBillItemReport(billInfoEo, (BillOrderItemEo)info);
            if (itemMap.containsKey(info.getItemCode())) {
                if (StringUtils.isNotBlank((CharSequence)info.getGroupSkuCode())) {
                    combinationItem.add(billItemReport);
                } else {
                    normalItem.add(billItemReport);
                }
            } else {
                combinationItem.add(billItemReport);
            }
        });
        BigDecimal addTaxAmount = BigDecimal.ZERO;
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(normalItem)) {
            for (i = 0; i < normalItem.size(); ++i) {
                if (i == normalItem.size() - 1 && org.apache.commons.collections.CollectionUtils.isEmpty(combinationItem)) {
                    reportRespDto = (BillItemReportRespDto)normalItem.get(i);
                    reportRespDto.setTaxAmount(taxAmountTotal.subtract(addTaxAmount));
                    reportRespDto.setExclusiveTaxAmount(reportRespDto.getAmount().subtract(reportRespDto.getTaxAmount()));
                    continue;
                }
                reportRespDto = (BillItemReportRespDto)normalItem.get(i);
                taxAmount = reportRespDto.getAmount().abs().divide(reportRespDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(reportRespDto.getTaxRate()).setScale(2, 4);
                reportRespDto.setTaxAmount(taxAmount);
                if (flag.get()) {
                    reportRespDto.setTaxAmount(taxAmount.negate());
                }
                reportRespDto.setExclusiveTaxAmount(reportRespDto.getAmount().subtract(reportRespDto.getTaxAmount()));
                addTaxAmount = addTaxAmount.add(reportRespDto.getTaxAmount());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(combinationItem)) {
            for (i = 0; i < combinationItem.size(); ++i) {
                if (i == combinationItem.size() - 1) {
                    reportRespDto = (BillItemReportRespDto)combinationItem.get(i);
                    reportRespDto.setTaxAmount(taxAmountTotal.subtract(addTaxAmount));
                    reportRespDto.setExclusiveTaxAmount(reportRespDto.getAmount().subtract(reportRespDto.getTaxAmount()));
                    continue;
                }
                reportRespDto = (BillItemReportRespDto)combinationItem.get(i);
                taxAmount = reportRespDto.getAmount().abs().divide(reportRespDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(reportRespDto.getTaxRate()).setScale(2, 4);
                reportRespDto.setTaxAmount(taxAmount);
                if (flag.get()) {
                    reportRespDto.setTaxAmount(taxAmount.negate());
                }
                reportRespDto.setExclusiveTaxAmount(reportRespDto.getAmount().subtract(reportRespDto.getTaxAmount()));
                addTaxAmount = addTaxAmount.add(reportRespDto.getTaxAmount());
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(normalItem)) {
            billItemReportRespDtoList.addAll(normalItem);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(combinationItem)) {
            billItemReportRespDtoList.addAll(combinationItem);
        }
    }

    public BillItemReportRespDto getBillItemReport(BillInfoEo billInfoEo, BillOrderItemEo orderItemEo) {
        BillItemReportRespDto reportRespDto = new BillItemReportRespDto();
        reportRespDto.setExternalInvoiceTime(billInfoEo.getExternalInvoiceTime());
        reportRespDto.setBillFlowNo(billInfoEo.getBillFlowNo());
        reportRespDto.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
        reportRespDto.setSite(billInfoEo.getSite());
        reportRespDto.setShopName(billInfoEo.getShopName());
        reportRespDto.setShopCode(billInfoEo.getShopCode());
        reportRespDto.setCustomerCode(billInfoEo.getCustomerCode());
        reportRespDto.setEnterprise(billInfoEo.getEnterprise());
        switch (billInfoEo.getBillChannel()) {
            case "1": {
                reportRespDto.setBillChannel("\u822a\u4fe1");
                break;
            }
            case "2": {
                reportRespDto.setBillChannel("\u963f\u91cc");
                break;
            }
        }
        switch (billInfoEo.getBillType()) {
            case "blue_ticket": {
                reportRespDto.setBillType("\u84dd\u7968");
                break;
            }
            case "red_ticket": {
                reportRespDto.setBillType("\u7ea2\u7968");
                break;
            }
            case "cancel_ticket": {
                reportRespDto.setBillType("\u4f5c\u5e9f\u7968");
                break;
            }
        }
        switch (billInfoEo.getInvoiceType()) {
            case "electronic_general_invoice": {
                reportRespDto.setInvoiceType("\u7535\u5b50\u666e\u901a\u53d1\u7968");
                break;
            }
            case "electronic_special_invoice": {
                reportRespDto.setInvoiceType("\u7535\u5b50\u4e13\u7528\u53d1\u7968");
                break;
            }
            case "paper_general_invoice": {
                reportRespDto.setInvoiceType("\u7eb8\u8d28\u666e\u901a\u53d1\u7968");
                break;
            }
            case "special_paper_invoice": {
                reportRespDto.setInvoiceType("\u7eb8\u8d28\u4e13\u7528\u53d1\u7968");
                break;
            }
            case "all_electronic_general_invoice": {
                reportRespDto.setInvoiceType("\u5168\u7535\u666e\u901a\u53d1\u7968");
                break;
            }
            case "all_electronic_special_invoice": {
                reportRespDto.setInvoiceType("\u5168\u7535\u4e13\u7528\u53d1\u7968");
                break;
            }
            case "num_electronic_special_paper_invoice": {
                reportRespDto.setInvoiceType("\u6570\u7535\u7eb8\u8d28\u4e13\u7528");
                break;
            }
            case "num_electronic_paper_general_invoice": {
                reportRespDto.setInvoiceType("\u6570\u7535\u7eb8\u8d28\u666e\u901a\u53d1\u7968");
                break;
            }
        }
        reportRespDto.setExternalInvoiceCode(billInfoEo.getExternalInvoiceCode());
        reportRespDto.setExternalInvoiceNo(billInfoEo.getExternalInvoiceNo());
        reportRespDto.setBillTitle(billInfoEo.getBillTitle());
        reportRespDto.setTaxesCode(billInfoEo.getTaxesCode());
        reportRespDto.setItemCode(orderItemEo.getItemCode());
        reportRespDto.setItemType(orderItemEo.getSpecification());
        reportRespDto.setQuantity(BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType()) ? orderItemEo.getQuantity() : orderItemEo.getQuantity().negate());
        reportRespDto.setAmount(BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType()) ? orderItemEo.getAmount() : orderItemEo.getAmount().negate());
        reportRespDto.setTaxRate(orderItemEo.getTaxRate());
        return reportRespDto;
    }

    public ExtQueryChainWrapper<BillInfoEo> assembleReportCondition(BillInfoReportQueryDto billInfoReportQueryDto) {
        ExtQueryChainWrapper filter = this.billInfoDas.filter();
        if (null != billInfoReportQueryDto.getExternalInvoiceBeginTime()) {
            filter.ge((Object)"external_invoice_time", (Object)billInfoReportQueryDto.getExternalInvoiceBeginTime());
        }
        if (null != billInfoReportQueryDto.getExternalInvoiceEndTime()) {
            filter.le((Object)"external_invoice_time", (Object)billInfoReportQueryDto.getExternalInvoiceEndTime());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportQueryDto.getEnterpriseList())) {
            filter.in((Object)"enterprise", (Collection)billInfoReportQueryDto.getEnterpriseList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportQueryDto.getBillChannelList())) {
            filter.in((Object)"bill_channel", (Collection)billInfoReportQueryDto.getBillChannelList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportQueryDto.getShopCodeList())) {
            filter.in((Object)"shop_code", (Collection)billInfoReportQueryDto.getShopCodeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportQueryDto.getBillTypeList())) {
            filter.in((Object)"bill_type", (Collection)billInfoReportQueryDto.getBillTypeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReportQueryDto.getInvoiceType())) {
            filter.in((Object)"invoice_type", (Collection)billInfoReportQueryDto.getInvoiceType());
        }
        filter.orderByDesc((Object)"id");
        return filter;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean generateBillInfo(BillInfoGenerateReqDto billInfoGenerateReqDto) {
        return this.generateBillInfoReturnMsg(billInfoGenerateReqDto).getSuccess();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public GenerateBillResultRespDto generateBillInfoReturnMsg(BillInfoGenerateReqDto billInfoGenerateReqDto) {
        logger.info("generateBillInfo==>\u5f00\u7968,billInfoGenerateReqDto:{}", (Object)LogUtils.buildLogContent(billInfoGenerateReqDto));
        AssertUtil.isTrue(null != billInfoGenerateReqDto, "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        String orderStatus = billInfoGenerateReqDto.getOrderStatus();
        try {
            if (OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) || OmsSaleOrderStatus.FINISH.getCode().equals(orderStatus) || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus)) {
                return this.generateInvoiceInfo(billInfoGenerateReqDto);
            }
        }
        catch (Exception e) {
            logger.info(String.format("generateBillInfo==>\u5f00\u7968\u5f02\u5e38:\u3010%s\u3011", e.getLocalizedMessage()), (Throwable)e);
            return GenerateBillResultRespDto.fail((String)e.getMessage());
        }
        return GenerateBillResultRespDto.success();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto modifyOrderInvoice(List<BillModifyReqDto> billModifyReqDtos) {
        Map<String, BillInfoEo> billMap;
        logger.info("\u5f00\u7968\u7cfb\u7edf\uff08\u822a\u4fe1\uff09\u5f00\u84dd\u7968\u540e\u66f4\u65b0\u53d1\u7968\u72b6\u6001-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billModifyReqDtos));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billModifyReqDtos), "\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        Map<String, BillModifyReqDto> billModifyReqDtoMap = billModifyReqDtos.stream().collect(Collectors.toMap(BillModifyReqDto::getBillFlowNo, Function.identity(), (k1, k2) -> k1));
        ArrayList billFlowNoList = Lists.newArrayList(billModifyReqDtoMap.keySet());
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", (Collection)billFlowNoList)).list();
        List blueTicketFlowNoList = billInfoList.stream().filter(x -> BillInfoColourTypeEnum.RED_TICKET.getCode().equals(x.getBillType()) || BillInfoColourTypeEnum.CANCEL_TICKET.getCode().equals(x.getBillType())).map(BillInfoEo::getBlueTicketFlowNo).distinct().collect(Collectors.toList());
        HashMap<String, BillInfoEo> blueTicketFlowMap = new HashMap(16);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(blueTicketFlowNoList)) {
            List blueTicketFlowList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", blueTicketFlowNoList)).list();
            blueTicketFlowMap = blueTicketFlowList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v2));
        }
        ArrayList redOrCancelBillList = new ArrayList();
        ArrayList blueBillList = new ArrayList();
        billInfoList.forEach(info -> {
            if (BillInfoColourTypeEnum.RED_TICKET.getCode().equals(info.getBillType()) || BillInfoColourTypeEnum.CANCEL_TICKET.getCode().equals(info.getBillType())) {
                redOrCancelBillList.add(info);
            } else if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(info.getBillType())) {
                blueBillList.add(info);
            }
        });
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> successList = new ArrayList<String>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(redOrCancelBillList)) {
            billMap = redOrCancelBillList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
            this.updateSyncRedOrCancelBill(billMap, billModifyReqDtoMap, errorList, successList, blueTicketFlowMap);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(blueBillList)) {
            billMap = blueBillList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
            this.updateSyncBlueBill(billMap, billModifyReqDtoMap, errorList, successList);
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        logger.info("\u5f00\u7968\u7cfb\u7edf\uff08\u822a\u4fe1\uff09\u5f00\u84dd\u7968\u540e\u66f4\u65b0\u53d1\u7968\u72b6\u6001-\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)batchOperationRespDto));
        return batchOperationRespDto;
    }

    public void updateSyncRedOrCancelBill(Map<String, BillInfoEo> billMap, Map<String, BillModifyReqDto> billModifyReqDtoMap, List<String> errorList, List<String> successList, Map<String, BillInfoEo> blueTicketFlowMap) {
        billMap.forEach((billNo, billInfo) -> {
            BillModifyReqDto billModifyReqDto = (BillModifyReqDto)billModifyReqDtoMap.get(billNo);
            logger.info("\u5f00\u7968\u6d41\u6c34\u53f7:{} \u5bf9\u5e94\u66f4\u65b0\u4fe1\u606f:{}", billNo, (Object)JSON.toJSONString((Object)billModifyReqDto));
            boolean flag = true;
            if (!(InvoiceStateEnum.WAIT_BILL.getCode().equals(billInfo.getInvoiceState()) || InvoiceStateEnum.INVOICING.getCode().equals(billInfo.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(billInfo.getInvoiceState()))) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7:%s\u72b6\u6001[%s]\u4e0d\u80fd\u66f4\u65b0\u5f00\u7968\u4fe1\u606f", billNo, InvoiceStateEnum.getNameByCode((String)billInfo.getInvoiceState())));
                flag = false;
            } else if (Objects.isNull(billModifyReqDto)) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7:%s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u66f4\u65b0\u4fe1\u606f", billNo));
                flag = false;
            } else if ("1".equals(billModifyReqDto.getFlag())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
                billInfoEo.setExternalInvoiceCode(billModifyReqDto.getExternalInvoiceCode());
                billInfoEo.setExternalInvoiceNo(billModifyReqDto.getExternalInvoiceNo());
                billInfoEo.setBillCheckCode(billModifyReqDto.getBillCheckCode());
                String dateStr = billModifyReqDto.getInvoiceDate();
                if (StringUtils.isNotBlank((CharSequence)dateStr)) {
                    billInfoEo.setExternalInvoiceTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)new Date(Long.parseLong(dateStr)), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss"));
                } else {
                    billInfoEo.setExternalInvoiceTime(new Date());
                }
                if (BillInfoColourTypeEnum.RED_TICKET.getCode().equals(billInfo.getBillType())) {
                    billInfoEo.setExtension(billModifyReqDto.getRemark());
                    billInfoEo.setInvoiceUrl(billModifyReqDto.getInvoiceUrl());
                    billInfoEo.setInvoiceConnectUrl(billModifyReqDto.getInvoiceConnectUrl());
                    billInfoEo.setRedInfoOrderNo(billModifyReqDto.getRedInfoOrderNo());
                }
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                if (blueTicketFlowMap.containsKey(billInfo.getBlueTicketFlowNo())) {
                    BillInfoEo infoEo = (BillInfoEo)blueTicketFlowMap.get(billInfo.getBlueTicketFlowNo());
                    BillInfoEo oldBillInfoEo = new BillInfoEo();
                    oldBillInfoEo.setId(infoEo.getId());
                    if (BillInfoColourTypeEnum.RED_TICKET.getCode().equals(billInfo.getBillType())) {
                        oldBillInfoEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
                    } else {
                        oldBillInfoEo.setInvoiceState(InvoiceStateEnum.CANCEL.getCode());
                    }
                    this.billInfoDas.updateSelective((BaseEo)oldBillInfoEo);
                    this.redOrderBillInfo(infoEo, false);
                }
            } else if ("0".equals(billModifyReqDto.getFlag())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
                billInfoEo.setExtension(billModifyReqDto.getRemark());
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            } else {
                logger.info("\u5f00\u7968\u6210\u529f\u6807\u8bc6\u4f20\u5165\u9519\u8bef,\u5f00\u7968\u5931\u8d25\uff1a{}", billNo);
                flag = false;
            }
            if (flag) {
                successList.add((String)billNo);
            }
        });
    }

    public void updateSyncBlueBill(Map<String, BillInfoEo> billMap, Map<String, BillModifyReqDto> billModifyReqDtoMap, List<String> errorList, List<String> successList) {
        billMap.forEach((billNo, billInfo) -> {
            BillModifyReqDto billModifyReqDto = (BillModifyReqDto)billModifyReqDtoMap.get(billNo);
            logger.info("\u5f00\u7968\u6d41\u6c34\u53f7:{} \u5bf9\u5e94\u66f4\u65b0\u4fe1\u606f:{}", billNo, (Object)JSON.toJSONString((Object)billModifyReqDto));
            boolean flag = true;
            if (!(InvoiceStateEnum.WAIT_BILL.getCode().equals(billInfo.getInvoiceState()) || InvoiceStateEnum.INVOICING.getCode().equals(billInfo.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(billInfo.getInvoiceState()))) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7:%s\u72b6\u6001[%s]\u4e0d\u80fd\u66f4\u65b0\u5f00\u7968\u4fe1\u606f", billNo, InvoiceStateEnum.getNameByCode((String)billInfo.getInvoiceState())));
                flag = false;
            } else if (Objects.isNull(billModifyReqDto)) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7:%s\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u66f4\u65b0\u4fe1\u606f", billNo));
                flag = false;
            } else if ("1".equals(billModifyReqDto.getFlag())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
                billInfoEo.setExtension(billModifyReqDto.getRemark());
                billInfoEo.setInvoiceUrl(billModifyReqDto.getInvoiceUrl());
                String dateStr = billModifyReqDto.getInvoiceDate();
                billInfoEo.setExternalInvoiceTime((Date)DateUtil.parse((CharSequence)DateUtil.format((Date)new Date(Long.parseLong(dateStr)), (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss"));
                billInfoEo.setExternalInvoiceCode(billModifyReqDto.getExternalInvoiceCode());
                billInfoEo.setExternalInvoiceNo(billModifyReqDto.getExternalInvoiceNo());
                billInfoEo.setInvoiceConnectUrl(billModifyReqDto.getInvoiceConnectUrl());
                billInfoEo.setBillCheckCode(billModifyReqDto.getBillCheckCode());
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                this.updateOrderBillInfo((BillInfoEo)billInfo, SaleOrderInvoiceStateEnum.INVOICED.getCode());
            } else if ("0".equals(billModifyReqDto.getFlag())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(billInfo.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
                billInfoEo.setExtension(billModifyReqDto.getRemark());
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            } else {
                logger.info("\u5f00\u7968\u6210\u529f\u6807\u8bc6\u4f20\u5165\u9519\u8bef,\u5f00\u7968\u5931\u8d25\uff1a{}", billNo);
                flag = false;
            }
            if (flag) {
                successList.add((String)billNo);
            }
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto updateStatusQueryInvoiceList(List<BillModifyReqDto> billModifyReqDtos) {
        logger.info("\u5f00\u7968\u7cfb\u7edf\uff08\u822a\u4fe1\uff09\u83b7\u53d6\u5f85\u5f00\u7968\u5217\u8868\u540e\u66f4\u65b0\u7968\u636e\u4e3a\u5f00\u7968\u4e2d-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billModifyReqDtos));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billModifyReqDtos), "\u66f4\u65b0\u53d1\u7968\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        List billFlowNoList = billModifyReqDtos.stream().map(BillModifyReqDto::getBillFlowNo).distinct().collect(Collectors.toList());
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        ArrayList<String> successList = new ArrayList<String>();
        ArrayList<BillInfoEo> redOrCancelBillList = new ArrayList<BillInfoEo>();
        ArrayList<BillInfoEo> blueBillList = new ArrayList<BillInfoEo>();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoList)) {
            billInfoList.forEach(info -> {
                if (InvoiceStateEnum.BILLED.getCode().equals(info.getInvoiceState())) {
                    return;
                }
                if (BillInfoColourTypeEnum.RED_TICKET.getCode().equals(info.getBillType()) || BillInfoColourTypeEnum.CANCEL_TICKET.getCode().equals(info.getBillType())) {
                    redOrCancelBillList.add((BillInfoEo)info);
                } else if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(info.getBillType())) {
                    blueBillList.add((BillInfoEo)info);
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(blueBillList)) {
            this.updateStatusQueryBlue(successList, blueBillList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(redOrCancelBillList)) {
            this.updateStatusQueryRedOrCancel(successList, redOrCancelBillList);
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billModifyReqDtos.size() - successList.size()));
        logger.info("\u5f00\u7968\u7cfb\u7edf\uff08\u822a\u4fe1\uff09\u83b7\u53d6\u5f85\u5f00\u7968\u5217\u8868\u540e\u66f4\u65b0\u7968\u636e\u4e3a\u5f00\u7968\u4e2d-\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)batchOperationRespDto));
        return batchOperationRespDto;
    }

    public void updateStatusQueryRedOrCancel(List<String> successList, List<BillInfoEo> billInfoList) {
        billInfoList.forEach(info -> {
            BillInfoEo billInfoEo = new BillInfoEo();
            billInfoEo.setId(info.getId());
            billInfoEo.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateInvoiceStatus(billInfoEo);
            successList.add(info.getBillFlowNo());
            this.updateOrderBillInfo((BillInfoEo)info, SaleOrderInvoiceStateEnum.REDDING.getCode());
        });
    }

    public void updateStatusQueryBlue(List<String> successList, List<BillInfoEo> billInfoList) {
        billInfoList.forEach(info -> {
            BillInfoEo billInfoEo = new BillInfoEo();
            billInfoEo.setId(info.getId());
            billInfoEo.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateInvoiceStatus(billInfoEo);
            successList.add(info.getBillFlowNo());
            this.updateOrderBillInfo((BillInfoEo)info, SaleOrderInvoiceStateEnum.INVOICING.getCode());
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto cancelChangeRedInvoice(List<String> billFlowNoList) {
        logger.info("\u4f5c\u5e9f\u8f6c\u7ea2\u51b2-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoList)) {
            billInfoList.forEach(info -> {
                if (InvoiceStateEnum.FAILED.getCode().equals(info.getInvoiceState())) {
                    if (BillInfoColourTypeEnum.CANCEL_TICKET.getCode().equals(info.getBillType())) {
                        BillInfoEo billInfoEo = new BillInfoEo();
                        billInfoEo.setId(info.getId());
                        billInfoEo.setBillType(BillInfoColourTypeEnum.RED_TICKET.getCode());
                        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                        successList.add(info.getBillFlowNo());
                    } else {
                        errorList.add(String.format("%s:\u5355\u636e\u4e0d\u662f\u4f5c\u5e9f\u7968\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\u8f6c\u7ea2\u51b2\u64cd\u4f5c", info.getBillFlowNo()));
                    }
                } else {
                    errorList.add(String.format("%s:\u975e\u5f00\u7968\u5931\u8d25\u72b6\u6001\u65e0\u6cd5\u8fdb\u884c\u4f5c\u5e9f\u8f6c\u7ea2\u51b2\u64cd\u4f5c", info.getBillFlowNo()));
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        return batchOperationRespDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto failedReInvoicing(List<String> billFlowNoList) {
        logger.info("\u5f00\u7968\u5931\u8d25\u91cd\u65b0\u5f00\u7968-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        ArrayList successList = new ArrayList();
        ArrayList errorList = new ArrayList();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoList)) {
            billInfoList.forEach(info -> {
                if (InvoiceStateEnum.FAILED.getCode().equals(info.getInvoiceState())) {
                    BillInfoEo billInfoEo = new BillInfoEo();
                    billInfoEo.setId(info.getId());
                    billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
                    this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                    successList.add(info.getBillFlowNo());
                } else {
                    errorList.add(String.format("%s:\u975e\u5f00\u7968\u5931\u8d25\u72b6\u6001\u65e0\u6cd5\u91cd\u65b0\u5f00\u7968\u8fdb\u884c\u64cd\u4f5c", info.getBillFlowNo()));
                }
            });
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        return batchOperationRespDto;
    }

    @Override
    public void userSystemRedOrCancel(List<String> platformOrderNoList) {
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(platformOrderNoList), "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u7ea2\u51b2\u53d6\u6d88\u84dd\u7968-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(platformOrderNoList));
        List relPlatformEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformEoList)) {
            List billFlowNoList = relPlatformEoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                this.redInvoice(billInfoEoList);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchAuditBillByPlatform(List<String> platformOrderNoList) {
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(platformOrderNoList), "\u5e73\u53f0\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        logger.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7\u6279\u91cf\u5ba1\u6838\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(platformOrderNoList));
        List relPlatformList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).in((Object)"platform_order_no", platformOrderNoList)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformList)) {
            List billFlowNoList = relPlatformList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            List billFlowNoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new InvoiceStateEnum[]{InvoiceStateEnum.WAIT_AUDIT, InvoiceStateEnum.WAIT_BILL}))).list();
            logger.info("batchAuditBillByPlatform:{}", (Object)JSONObject.toJSONString((Object)billFlowNoEoList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billFlowNoEoList)) {
                List<String> list = billFlowNoEoList.stream().map(BillInfoEo::getBillFlowNo).distinct().collect(Collectors.toList());
                this.auditBillInfo(list);
            }
        }
    }

    @Override
    public void againInvoice(AgainInvoiceQueryDto againInvoiceQueryDto) {
        PageInfo<SaleOrderRespDto> applyUnInvoicePageInfo;
        PageInfo<SaleOrderRespDto> saleOrderRespDtoPageInfo;
        logger.info("\u83b7\u53d6\u5f53\u6708\u672a\u5f00\u7968\u7684\u53d1\u8d27\u6216\u8005\u5b8c\u6210\u8ba2\u5355\u91cd\u65b0\u5f00\u7968:{}", (Object)JSONObject.toJSONString((Object)againInvoiceQueryDto));
        QueryUnInvoiceOrderListDto queryDto = new QueryUnInvoiceOrderListDto();
        if (Objects.nonNull(againInvoiceQueryDto)) {
            queryDto.setStartTime(againInvoiceQueryDto.getStartTime());
            queryDto.setEndTime(againInvoiceQueryDto.getEndTime());
            if (CollectionUtil.isNotEmpty((Collection)againInvoiceQueryDto.getPlatformOrderNos())) {
                queryDto.setPlatformOrderNos(againInvoiceQueryDto.getPlatformOrderNos());
            }
        }
        queryDto.setPageSize(Integer.valueOf(1000));
        Integer pageNumUnInvoice = 1;
        do {
            queryDto.setPageNum(pageNumUnInvoice);
            logger.info("\u83b7\u53d6\u5f53\u6708\u672a\u5f00\u7968\u7684\u53d1\u8d27\u6216\u8005\u5b8c\u6210\u8ba2\u5355\u91cd\u65b0\u5f00\u7968\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)queryDto));
            saleOrderRespDtoPageInfo = this.saleOrderBillRecordService.queryUnInvoiceOrderList(queryDto);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)saleOrderRespDtoPageInfo.getList())) {
                saleOrderRespDtoPageInfo.getList().forEach(order -> {
                    BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                    billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
                    billInfoGenerateReqDto.setOrderStatus(order.getOrderStatus());
                    billInfoGenerateReqDto.setSaleOrderNo(order.getSaleOrderNo());
                    billInfoGenerateReqDto.setOrderType(order.getOrderType());
                    this.generateBillInfo(billInfoGenerateReqDto);
                });
            } else {
                logger.info("\u5f53\u524d\u67e5\u8be2\u6761\u4ef6\u4e0d\u5b58\u5728\u672a\u5f00\u7968\u53d1\u8d27\u6216\u8005\u5b8c\u6210\u8ba2\u5355");
            }
            Integer n = pageNumUnInvoice;
            Integer n2 = pageNumUnInvoice = Integer.valueOf(pageNumUnInvoice + 1);
        } while (pageNumUnInvoice <= (int)Math.ceil(Double.valueOf(saleOrderRespDtoPageInfo.getTotal()) / Double.valueOf(1000.0)));
        Integer pageNum = 1;
        do {
            QueryUnInvoiceOrderListDto query = new QueryUnInvoiceOrderListDto();
            query.setPageNum(pageNum);
            query.setPageSize(Integer.valueOf(1000));
            if (Objects.nonNull(againInvoiceQueryDto) && CollectionUtil.isNotEmpty((Collection)againInvoiceQueryDto.getPlatformOrderNos())) {
                query.setPlatformOrderNos(againInvoiceQueryDto.getPlatformOrderNos());
            }
            logger.info("\u7533\u8bf7\u5355\u72b6\u6001\u4e3a\u672a\u5f00\u7968\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)query));
            applyUnInvoicePageInfo = this.saleOrderBillRecordService.queryApplyUnInvoice(query);
            ArrayList applyUnInvoiceList = new ArrayList(applyUnInvoicePageInfo.getList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(applyUnInvoiceList)) {
                List platformOrderNoList = applyUnInvoiceList.stream().map(SaleOrderRespDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
                List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNoList)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).list();
                Map map = ((List)Optional.ofNullable(billInfoEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillInfoEo::getPlatformOrderNo, Function.identity(), (v1, v2) -> v1));
                applyUnInvoiceList.forEach(info -> {
                    if (!map.containsKey(info.getPlatformOrderNo())) {
                        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                        billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
                        billInfoGenerateReqDto.setOrderStatus(info.getOrderStatus());
                        billInfoGenerateReqDto.setSaleOrderNo(info.getSaleOrderNo());
                        billInfoGenerateReqDto.setOrderType(info.getOrderType());
                        this.generateBillInfo(billInfoGenerateReqDto);
                    }
                });
            }
            Integer n = pageNum;
            Integer n3 = pageNum = Integer.valueOf(pageNum + 1);
        } while (pageNum <= (int)Math.ceil(Double.valueOf(applyUnInvoicePageInfo.getTotal()) / Double.valueOf(1000.0)));
    }

    @Override
    public void redisDataUpdateDatabase(String type) {
        if (NoKeepBillTypeEnum.ORDER.getCode().equals(type)) {
            List platformList = (List)this.cacheService.getCache("book_keep_for_bill", (TypeReference)new TypeReference<List<String>>(){});
            List<String> list = platformList.stream().distinct().collect(Collectors.toList());
            ArrayList noKeepBillEoList = new ArrayList();
            list.forEach(platformNo -> {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(platformNo);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.ORDER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                noKeepBillEo.setExtension("redis\u6570\u636e\u8fc1\u79fb\u5230\u6570\u636e\u5e93");
                noKeepBillEoList.add(noKeepBillEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noKeepBillEoList)) {
                this.noKeepBillDas.insertBatch(noKeepBillEoList);
            }
        } else if (NoKeepBillTypeEnum.AFTER.getCode().equals(type)) {
            List afterSaleOrderNoList = (List)this.cacheService.getCache("book_keep_for_bill_after", (TypeReference)new TypeReference<List<String>>(){});
            List<String> list = afterSaleOrderNoList.stream().distinct().collect(Collectors.toList());
            ArrayList noKeepBillEoList = new ArrayList();
            list.forEach(after -> {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(after);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.AFTER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                noKeepBillEo.setExtension("redis\u6570\u636e\u8fc1\u79fb\u5230\u6570\u636e\u5e93");
                noKeepBillEoList.add(noKeepBillEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noKeepBillEoList)) {
                this.noKeepBillDas.insertBatch(noKeepBillEoList);
            }
        } else {
            List platformList = (List)this.cacheService.getCache("book_keep_for_bill", (TypeReference)new TypeReference<List<String>>(){});
            List afterSaleOrderNoList = (List)this.cacheService.getCache("book_keep_for_bill_after", (TypeReference)new TypeReference<List<String>>(){});
            List<String> orderList = platformList.stream().distinct().collect(Collectors.toList());
            List<String> afterList = afterSaleOrderNoList.stream().distinct().collect(Collectors.toList());
            ArrayList noKeepBillEoList = new ArrayList();
            orderList.forEach(platformNo -> {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(platformNo);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.ORDER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                noKeepBillEo.setExtension("redis\u6570\u636e\u8fc1\u79fb\u5230\u6570\u636e\u5e93");
                noKeepBillEoList.add(noKeepBillEo);
            });
            afterList.forEach(after -> {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(after);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.AFTER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                noKeepBillEo.setExtension("redis\u6570\u636e\u8fc1\u79fb\u5230\u6570\u636e\u5e93");
                noKeepBillEoList.add(noKeepBillEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noKeepBillEoList)) {
                this.noKeepBillDas.insertBatch(noKeepBillEoList);
            }
        }
    }

    public GenerateBillResultRespDto generateInvoiceInfo(BillInfoGenerateReqDto billInfoGenerateReqDto) {
        String saleOrderNo = billInfoGenerateReqDto.getSaleOrderNo();
        PerformOrderInfoDto performOrderInfoDto = this.performOrderInfoService.queryByOrderNo(saleOrderNo);
        logger.info("generateInvoiceInfo==>performOrderInfoDto:{}", (Object)LogUtils.buildLogContent(performOrderInfoDto));
        GenerateBillResultRespDto result = GenerateBillResultRespDto.success();
        if (this.exchangeOrderFilter(performOrderInfoDto.getPlatformOrderNo()).booleanValue()) {
            LockUtils.lock(() -> (Integer)LockUtils.executorNewTransaction(s -> {
                try {
                    List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new String[]{"wait_bill", "invoicing", "billed"}))).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"bill_type", (Object)"blue_ticket")).list();
                    List redList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new String[]{"wait_bill", "invoicing", "billed"}))).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"bill_type", (Object)"red_ticket")).list();
                    this.getInvoicePolicy(performOrderInfoDto, billInfoGenerateReqDto);
                }
                catch (Exception e) {
                    logger.error("generateBillInfo==>\u5f00\u7968\u5f02\u5e38:", (Throwable)e);
                    result.setSuccess(Boolean.valueOf(false));
                    result.setErrorMessage(e.getMessage());
                }
                return 1;
            }), "bill_info_key", performOrderInfoDto.getPlatformOrderNo(), 30);
        }
        logger.info("GenerateBillResultRespDto is {}", (Object)JacksonUtil.toJson((Object)result));
        return result;
    }

    @Override
    public Boolean exchangeOrderFilter(String platformOrderNo) {
        if (StringUtils.isNotBlank((CharSequence)platformOrderNo)) {
            PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
            performOrderInfoPageReqDto.setPlatformOrderNo(platformOrderNo);
            performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
            List<PerformOrderInfoDto> performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
            this.getExcludingPerformOrderInfoDtoList(performOrderInfoDtoList);
            List list = performOrderInfoDtoList.stream().filter(x -> SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(x.getOrderType())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                List afterSaleOrderNoList;
                if (list.stream().anyMatch(x -> !OmsSaleOrderStatus.COMPLETE.getCode().equals(x.getOrderStatus()) && !OmsSaleOrderStatus.OBSOLETE.getCode().equals(x.getOrderStatus()) && !OmsSaleOrderStatus.CANCEL.getCode().equals(x.getOrderStatus()))) {
                    logger.info("\u6362\u8d27\u5355\u672a\u5168\u90e8\u5b8c\u6210");
                    return Boolean.FALSE;
                }
                List exchangeOrderNoList = list.stream().map(PerformOrderInfoDto::getExchangeOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(exchangeOrderNoList) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(afterSaleOrderNoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().eq((Object)"relate_to_platform_order", (Object)0)).in((Object)"after_sale_order_no", exchangeOrderNoList)).list())) && afterSaleOrderNoList.stream().anyMatch(x -> !AfterSaleOrderStatusEnum.FINISH.getCode().equals(x.getStatus()) && !AfterSaleOrderStatusEnum.CANCEL.getCode().equals(x.getStatus()) && !AfterSaleOrderStatusEnum.ABOLISH.getCode().equals(x.getStatus()))) {
                    logger.info("\u6b63\u5411\u6362\u8d27\u5355\u53d1\u8d27\u5b8c\u6210\u9006\u5411\u6362\u8d27\u552e\u540e\u5355\u672a\u5168\u90e8\u5b8c\u6210");
                    return Boolean.FALSE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public void getInvoicePolicy(PerformOrderInfoDto performOrderInfoDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        String shopCode = ((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        logger.info("getInvoicePolicy==>\u6839\u636e\u7b56\u7565\u9009\u62e9\u54ea\u4e9b\u8ba2\u5355\u5f00\u7968,shopCode:{}", (Object)shopCode);
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        Boolean applyFlag = billInfoGenerateReqDto.getApplyFlag();
        logger.info("getInvoicePolicy==>billStrategyRespDto:{},applyFlag:{}", (Object)LogUtils.buildLogContent(billStrategyRespDto), (Object)applyFlag);
        if (Boolean.TRUE.equals(applyFlag)) {
            billStrategyRespDto.setBillObject("apply");
        }
        if (Objects.nonNull(billStrategyRespDto) && null != billStrategyRespDto.getId()) {
            if ("all".equals(billStrategyRespDto.getBillObject())) {
                logger.info("\u8ba2\u5355\u6839\u636e\u7b56\u7565\u9009\u62e9\u6240\u6709\u8ba2\u5355\u5f00\u7968");
                this.shipmentNode(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
            } else if ("platform_apply".equals(billStrategyRespDto.getBillObject())) {
                List billRecordEoList = ((ExtQueryChainWrapper)this.saleOrderBillRecordDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)billRecordEoList)) {
                    logger.info("\u8ba2\u5355\u6839\u636e\u7b56\u7565\u9009\u62e9\u5e73\u53f0\u7533\u8bf7\u5355\u5f00\u7968-----\u4e0d\u5b58\u5728\u7533\u8bf7\u5355\u4e0d\u5f00\u7968");
                } else {
                    this.shipmentNode(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
                }
            } else {
                List relEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)relEoList)) {
                    logger.info("\u8ba2\u5355\u6839\u636e\u7b56\u7565\u9009\u62e9\u7533\u8bf7\u5355\u5f00\u7968-----\u4e0d\u5b58\u5728\u7533\u8bf7\u5355\u4e0d\u5f00\u7968");
                } else {
                    List applyNoList = relEoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                    List applyEoList = ((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", applyNoList)).list();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)applyEoList)) {
                        List list = applyEoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
                        logger.info("\u83b7\u53d6\u6700\u65b0\u7684\u7533\u8bf7\u5355\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString(list.get(0)));
                        billInfoGenerateReqDto.setWhetherMergeBill(((BillApplyEo)list.get(0)).getWhetherMergeBill());
                        billInfoGenerateReqDto.setPlatformOrderNoList(Arrays.asList(((BillApplyEo)list.get(0)).getPlatformOrderNo().split(",")));
                    }
                    this.shipmentNode(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
                }
            }
        } else {
            logger.info("\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u5f00\u7968\u7b56\u7565:{}", (Object)shopCode);
            throw new BizException("\u672a\u83b7\u53d6\u5230\u5e97\u94fa\u5f00\u7968\u7b56\u7565:" + shopCode);
        }
    }

    public void shipmentNode(BillStrategyRespDto billStrategyRespDto, PerformOrderInfoDto performOrderInfoDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        logger.info("shipmentNode==>\u6839\u636e\u7b56\u7565\u9009\u62e9\u751f\u6210\u5f00\u7968\u8282\u70b9,billStrategyRespDto:{},performOrderInfoDto:{},billInfoGenerateReqDto:{}", new Object[]{LogUtils.buildLogContent(billStrategyRespDto), LogUtils.buildLogContent(performOrderInfoDto), LogUtils.buildLogContent(billInfoGenerateReqDto)});
        ArrayList platformOrderNos = Lists.newArrayList((Object[])new String[]{performOrderInfoDto.getPlatformOrderNo()});
        if (null != billInfoGenerateReqDto.getManmual() && billInfoGenerateReqDto.getManmual().booleanValue()) {
            this.billInfoOrderCompleteStrategy(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
        } else {
            String billOrderPoint = billStrategyRespDto.getBillOrderPoint();
            if (BillStrategyOrderPointEnum.DELIVER.getCode().equals(billOrderPoint)) {
                logger.info("handleBatchOrder==>\u5df2\u53d1\u8d27\u7b56\u7565");
                if (OmsSaleOrderStatus.DELIVERED.getCode().equals(billInfoGenerateReqDto.getOrderStatus()) || OmsSaleOrderStatus.COMPLETE.getCode().equals(billInfoGenerateReqDto.getOrderStatus()) || OmsSaleOrderStatus.CANCEL.getCode().equals(billInfoGenerateReqDto.getOrderStatus()) && WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill())) {
                    this.billInfoOrderDeliverStrategy(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
                }
            } else if (BillStrategyOrderPointEnum.COMPLETE.getCode().equals(billOrderPoint)) {
                logger.info("handleBatchOrder==>\u5df2\u5b8c\u6210\u7b56\u7565");
                if (OmsSaleOrderStatus.COMPLETE.getCode().equals(billInfoGenerateReqDto.getOrderStatus()) || OmsSaleOrderStatus.CANCEL.getCode().equals(billInfoGenerateReqDto.getOrderStatus())) {
                    this.billInfoOrderCompleteStrategy(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
                }
            } else if (BillStrategyOrderPointEnum.KEEP_COMPLETE.getCode().equals(billOrderPoint)) {
                logger.info("handleBatchOrder==>\u8fdb\u5165\u5df2\u8bb0\u8d26\u7b56\u7565");
                List invoiceVoucherSuccess = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iKeepAccountsDetailDomain.filter().select(new String[]{"id"}).eq((Object)"order_no", (Object)performOrderInfoDto.getSaleOrderNo())).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)AccountRuleEnum.ACCOUNT_SUCCESS.getCode())).list();
                if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)invoiceVoucherSuccess)) {
                    logger.error("\u5f00\u7968\u8bb0\u8d26\u8fd8\u6ca1\u6210\u529f\uff0c\u4e0d\u5f00\u7968 orderNo\uff1a{}", (Object)performOrderInfoDto.getSaleOrderNo());
                    return;
                }
                this.billInfoOrderCompleteStrategy(billStrategyRespDto, performOrderInfoDto, billInfoGenerateReqDto);
            }
        }
    }

    private void redInvoiceByPlatformOrderNo(List<String> platformOrderNos) {
        if (CollUtil.isEmpty(platformOrderNos)) {
            return;
        }
        List billInfoEos = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNos)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos)) {
            this.redInvoice(billInfoEos);
        }
    }

    public void billInfoOrderDeliverStrategy(BillStrategyRespDto billStrategyRespDto, PerformOrderInfoDto performOrderInfoDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        if (WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill()) || null == billInfoGenerateReqDto.getWhetherMergeBill()) {
            BatchOperationRespDto batchOperationRespDto;
            List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"sale_order_no", (Object)performOrderInfoDto.getSaleOrderNo())).eq((Object)"bill_type", (Object)"blue_ticket")).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList) && billInfoEoList.stream().anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()))) {
                logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u7ee7\u7eed\u64cd\u4f5c");
                this.addBillApplyOrderInfo(billInfoEoList, performOrderInfoDto);
                return;
            }
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"create_type", (Object)BillCreateTypeEnum.HAND.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                logger.info("\u5b58\u5728\u624b\u5de5\u5355:{}", (Object)JSONObject.toJSONString((Object)list));
                billInfoEoList.addAll(list);
            }
            PerformOrderInfoEo eo = new PerformOrderInfoEo();
            eo.setOrderStatus(BillStrategyOrderPointEnum.DELIVER.getCode().equals(billStrategyRespDto.getBillOrderPoint()) ? OmsSaleOrderStatus.DELIVERED.getCode() : OmsSaleOrderStatus.COMPLETE.getCode());
            eo.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
            List orderInfoEos = this.iPerformOrderInfoDomain.selectList((BaseEo)eo);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderInfoEos)) {
                List<String> orderNos = orderInfoEos.stream().map(PerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
                orderNos.add(performOrderInfoDto.getSaleOrderNo());
                performOrderInfoDto = this.iPerformOrderInfoService.queryByOrderNo(orderNos);
                logger.info("performOrderInfoDto=>{}", (Object)JSON.toJSONString((Object)performOrderInfoDto));
            }
            if (Objects.nonNull(batchOperationRespDto = this.redInvoice(billInfoEoList)) && StringUtils.isNotBlank((CharSequence)batchOperationRespDto.getErrorMsg())) {
                logger.info("\u7ea2\u7968\u5904\u7406\u5931\u8d25\uff0c\u4e0d\u5f80\u4e0b\u8d70");
                return;
            }
            SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
            saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
            List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
            logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
            this.deliveryGen(performOrderInfoDto, saleOrderBillRecordDtos, billStrategyRespDto, billInfoGenerateReqDto);
        } else if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoGenerateReqDto.getPlatformOrderNoList())) {
            logger.info("\u5408\u5e76\u5f00\u7968\u6839\u636e\u5e73\u53f0\u5355\u53f7\u83b7\u53d6\u914d\u8d27\u5355\u7684\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)billInfoGenerateReqDto.getPlatformOrderNoList()));
            PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
            performOrderInfoPageReqDto.setPlatformOrderNoList(billInfoGenerateReqDto.getPlatformOrderNoList());
            performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
            List<PerformOrderInfoDto> saleOrderRespDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
            AtomicBoolean flag = new AtomicBoolean(true);
            saleOrderRespDtoList.forEach(order -> {
                String orderStatus = order.getOrderStatus();
                if (!(!this.orderTypeFilter(order.getOrderType()).booleanValue() || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus) || OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus))) {
                    flag.set(false);
                }
            });
            if (flag.get()) {
                logger.info("\u5408\u5e76\u5f00\u7968\u7684\u8ba2\u5355\u5df2\u7ecf\u5168\u90e8\u53d1\u8d27\u751f\u6210\u53d1\u7968\u4fe1\u606f");
                SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
                List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
                this.deliveryGenMerge(saleOrderRespDtoList, saleOrderBillRecordDtos, billStrategyRespDto, billInfoGenerateReqDto);
            }
        }
    }

    public void billInfoOrderCompleteStrategy(BillStrategyRespDto billStrategyRespDto, PerformOrderInfoDto performOrderInfoDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> orderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        AtomicBoolean flag = new AtomicBoolean(true);
        orderInfoDtoList.forEach(order -> {
            String orderStatus = order.getOrderStatus();
            if (!this.orderTypeFilter(order.getOrderType()).booleanValue() || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus) || !OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus)) {
                // empty if block
            }
        });
        if (flag.get()) {
            List<PerformOrderInfoDto> list = orderInfoDtoList.stream().filter(order -> OmsSaleOrderStatus.COMPLETE.getCode().equals(order.getOrderStatus())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                List billInfoEoList;
                if ((WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill()) || null == billInfoGenerateReqDto.getWhetherMergeBill()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).eq((Object)"bill_type", (Object)"blue_ticket")).list())) && billInfoEoList.stream().anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()))) {
                    logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u7ee7\u7eed\u64cd\u4f5c");
                    this.addBillApplyOrderInfo(billInfoEoList, performOrderInfoDto);
                    return;
                }
                SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
                List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
                this.deliveryGenMerge(list, saleOrderBillRecordDtos, billStrategyRespDto, billInfoGenerateReqDto);
            } else {
                logger.info("\u5e73\u53f0\u8ba2\u5355\u7684\u914d\u8d27\u8ba2\u5355\u672a\u5b8c\u6210:{}", (Object)performOrderInfoDto.getPlatformOrderNo());
            }
        } else {
            logger.info("\u5e73\u53f0\u8ba2\u5355\u7684\u914d\u8d27\u8ba2\u5355\u672a\u5168\u90e8\u5b8c\u6210:{}", (Object)performOrderInfoDto.getPlatformOrderNo());
        }
    }

    private void addBillApplyOrderInfo(List<BillInfoEo> billInfoEoList, PerformOrderInfoDto performOrderInfoDto) {
        Boolean hasWaitHandleApply = this.isHasWaitHandleApply(performOrderInfoDto.getPlatformOrderNo());
        if (hasWaitHandleApply.booleanValue()) {
            logger.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u7684\u5355\u751f\u6210\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u8bb0\u5f55\uff1a{}", (Object)performOrderInfoDto.getPlatformOrderNo());
            List billInfoEos = billInfoEoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
            BillInfoEo billInfoEo = (BillInfoEo)billInfoEos.get(0);
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_APPLY.getCode());
            String applyNo = generateCodeService.getCode("BA");
            BillApplyEo billApplyEo = new BillApplyEo();
            billApplyEo.setApplyNo(applyNo);
            billApplyEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
            billApplyEo.setSite(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
            billApplyEo.setShopId(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
            billApplyEo.setShopCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
            billApplyEo.setShopName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
            billApplyEo.setPlatformOrderStatus(performOrderInfoDto.getPlatformOrderStatus());
            billApplyEo.setApplyChannel(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
            billApplyEo.setApplyType("apply_bill");
            billApplyEo.setBillType(billInfoEo.getInvoiceType());
            billApplyEo.setBillTitle(billInfoEo.getBillTitle());
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            billApplyEo.setApplyTime(new Date());
            billApplyEo.setEnterprise(billInfoEo.getBillTitle());
            billApplyEo.setTaxesCode(billInfoEo.getTaxesCode());
            billApplyEo.setRegisteredAddress(billInfoEo.getRegisteredAddress());
            billApplyEo.setRegisteredPhone(billInfoEo.getRegisteredPhone());
            billApplyEo.setBankAccount(billInfoEo.getBankAccount());
            billApplyEo.setBank(billInfoEo.getBank());
            billApplyEo.setMailbox(billInfoEo.getMailbox());
            billApplyEo.setPhone(billInfoEo.getPhone());
            billApplyEo.setTitleType(billInfoEo.getTitleType());
            billApplyEo.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
            billApplyEo.setBillAddress(billInfoEo.getBillAddress());
            billApplyEo.setBillPersonPhone(billInfoEo.getBillPersonPhone());
            billApplyEo.setBillPersonName(billInfoEo.getBillPersonName());
            this.billApplyDas.insert((BaseEo)billApplyEo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        }
    }

    public Boolean isHasWaitHandleApply(String platformOrderNo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            List applyList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            ArrayList<String> changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            List billApplyEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().in((Object)"apply_no", applyList)).in((Object)"change_type", changeTypeList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billApplyEoList)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void noKeepOrderUpdate(List<String> platformOrderNo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.noKeepBillDas.filter().eq((Object)"business_type", (Object)NoKeepBillTypeEnum.ORDER.getCode())).in((Object)"business_order_no", platformOrderNo)).list();
        Map noKeepBillEoMap = ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().collect(Collectors.toMap(NoKeepBillEo::getBusinessOrderNo, Function.identity(), (v1, v2) -> v1));
        ArrayList addList = new ArrayList();
        platformOrderNo.forEach(order -> {
            if (!noKeepBillEoMap.containsKey(order)) {
                NoKeepBillEo noKeepBillEo = new NoKeepBillEo();
                noKeepBillEo.setBusinessOrderNo(order);
                noKeepBillEo.setBusinessType(NoKeepBillTypeEnum.ORDER.getCode());
                noKeepBillEo.setStatus(Integer.valueOf(0));
                addList.add(noKeepBillEo);
            }
        });
        if (CollectionUtils.isNotEmpty(addList)) {
            this.noKeepBillDas.insertBatch(addList);
        }
    }

    @Override
    public BatchOperationRespDto redInvoice(List<BillInfoEo> billInfoEoList) {
        logger.info("\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u6d41\u7a0b---\u53d1\u7968\u7ea2\u51b2\uff1a{}", (Object)JSONObject.toJSONString(billInfoEoList));
        ArrayList<String> billFlowNoList = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(billInfoEoList)) {
            billInfoEoList.stream().filter(e -> BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(e.getBillType()) && WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(e.getWhetherMergeBill())).forEach(info -> {
                switch (info.getInvoiceState()) {
                    case "billed": {
                        billFlowNoList.add(info.getBillFlowNo());
                        break;
                    }
                    case "wait_audit": 
                    case "wait_bill": {
                        this.cancelBillInfo((BillInfoEo)info);
                        break;
                    }
                }
            });
        }
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        logger.info("\u7ea2\u51b2\u5df2\u7ecf\u5f00\u7968\u7684\u5f00\u7968\u6d41\u6c34\u53f7:{}", (Object)JSON.toJSONString(billFlowNoList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
            batchOperationRespDto = this.redOrderInvoice(billFlowNoList);
        }
        logger.info("\u7ea2\u51b2\u5df2\u7ecf\u5f00\u7968\u7684\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)batchOperationRespDto));
        return batchOperationRespDto;
    }

    @Override
    public RedOrderInvoiceAgainBillRespDto redInvoiceIsReopen(BillInfoEo billInfoEo) {
        logger.info("\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u6d41\u7a0b---\u5224\u65ad\u662f\u5426\u9700\u8981\u7ea2\u51b2\u84dd\u7968\uff1a{}", (Object)billInfoEo.getPlatformOrderNo());
        List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).list();
        logger.info("\u8ba2\u5355\u72b6\u6001\u540c\u6b65\u6d41\u7a0b---\u5224\u65ad\u662f\u5426\u9700\u8981\u7ea2\u51b2\u84dd\u7968:{}", (Object)JSONObject.toJSONString((Object)billInfoEoList));
        ArrayList billFlowNoList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
            ArrayList notIn = Lists.newArrayList((Object[])new String[]{InvoiceStateEnum.CANCELLED.getCode(), InvoiceStateEnum.CANCEL.getCode()});
            Map<String, String> blueRedMap = billInfoEoList.stream().filter(e -> BillInfoColourTypeEnum.RED_TICKET.getCode().equals(e.getBillType())).filter(s -> !notIn.contains(s.getInvoiceState())).filter(s -> StrUtil.isNotBlank((CharSequence)s.getBlueTicketFlowNo())).collect(Collectors.toMap(BillInfoEo::getBlueTicketFlowNo, BillInfoEo::getBillFlowNo, (a, b) -> {
                logger.info("\u5f02\u5e38\u6570\u636e\uff0c\u84dd\u7968\u88ab\u7ea2\u51b2\u591a\u6b21, \u7ea2\u7968\u6d41\u6c34\u53f7\uff1a{}, {}", a, b);
                return b;
            }));
            billInfoEoList.stream().filter(e -> BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(e.getBillType()) && WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(e.getWhetherMergeBill())).forEach(info -> {
                switch (info.getInvoiceState()) {
                    case "billed": {
                        if (!blueRedMap.containsKey(info.getBillFlowNo())) {
                            billFlowNoList.add(info);
                            break;
                        }
                        logger.info("\u5df2\u7ecf\u7ea2\u51b2\u8fc7\u84dd\u7968\uff0c\u65e0\u9700\u591a\u6b21\u7ea2\u51b2: \u5e73\u53f0\u5355\u53f7={}, \u84dd\u7968\u6d41\u6c34\u53f7={}, \u7ea2\u7968\u6d41\u6c34\u53f7={}", new Object[]{info.getPlatformOrderNo(), info.getBillFlowNo(), blueRedMap.get(info.getBillFlowNo())});
                        break;
                    }
                    case "wait_audit": 
                    case "wait_bill": {
                        this.cancelBillInfo((BillInfoEo)info);
                        break;
                    }
                }
            });
        }
        RedOrderInvoiceAgainBillRespDto respDto = new RedOrderInvoiceAgainBillRespDto();
        logger.info("\u7ea2\u51b2\u5df2\u7ecf\u5f00\u7968\u7684\u84dd\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(billFlowNoList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
            respDto = this.redOrderInvoiceAgainBill((BillInfoEo)billFlowNoList.get(0), billInfoEo);
            respDto.setReopenIsBill(Boolean.valueOf(true));
        } else {
            logger.info("\u6ca1\u6709\u9700\u8981\u7ea2\u51b2\u7684\u84dd\u7968\u4fe1\u606f");
            respDto.setReopenIsBill(Boolean.valueOf(false));
        }
        logger.info("\u5224\u65ad\u662f\u5426\u9700\u8981\u7ea2\u51b2\u84dd\u7968\u8fd4\u56de\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)respDto));
        return respDto;
    }

    private void deliveryGen(PerformOrderInfoDto performOrderInfoDto, List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList, BillStrategyRespDto billStrategyRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        SaleOrderBillRecordDto saleOrderBillRecordRespDto = new SaleOrderBillRecordDto();
        if (CollectionUtils.isNotEmpty(saleOrderBillRecordRespDtoList)) {
            saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordRespDtoList.stream().sorted(Comparator.comparing(BaseDto::getId).reversed()).collect(Collectors.toList()).get(0);
        } else {
            this.defaultBillRecord(saleOrderBillRecordRespDto, billStrategyRespDto, billInfoGenerateReqDto, performOrderInfoDto.getPlatformOrderNo());
        }
        String orderStatus = performOrderInfoDto.getOrderStatus();
        if (!OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) && !OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus)) {
            logger.info("\u975e\u5df2\u53d1\u8d27\u548c\u975e\u5df2\u5b8c\u6210\u4e0d\u7528\u65b0\u589e\u53d1\u7968");
            return;
        }
        this.resetAmountAndNumForBill(billStrategyRespDto, performOrderInfoDto);
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setInvoiceSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        this.getBillInfo(performOrderInfoDto, billInfoEo, billStrategyRespDto, saleOrderBillRecordRespDto, billInfoGenerateReqDto);
        billInfoEo.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        billInfoEo.setWhetherMergeBill(Integer.valueOf(0));
        List<BillItemEo> billItemEoList = this.saveBillDetailInfo(performOrderInfoDto, billInfoEo, billStrategyRespDto);
        billInfoEo.setInvoiceRemarks(StrUtil.blankToDefault((CharSequence)billInfoGenerateReqDto.getInvoiceRemarks(), (String)billInfoEo.getInvoiceRemarks()));
        logger.info("\u751f\u6210\u5f00\u7968\u4fe1\u606fdeliveryGen\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(billItemEoList)) {
            logger.info("\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list();
            this.redInvoice(billInfoEoList);
        } else {
            this.getShopAllElectricInfo(billInfoEo);
            if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType())) {
                boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
                List applyColourType = billStrategyRespDto.getApplyColourType();
                boolean containsBillType = BillInfoColourTypeEnum.containsBillType((List)applyColourType, (String)billInfoEo.getBillType());
                logger.info("\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {} {} {} ", new Object[]{billInfoEo.getBillFlowNo(), billInfoEo.getBillType(), containsBillType});
                logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
                if (null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()) && containsBillType) {
                    String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCodeTwo();
                    if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto) {
                        if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                            this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                        } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                            this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                        }
                    }
                }
            }
            boolean isConsistency = this.billInfoValidateService.validateBillInfo(billInfoEo.getPlatformOrderNo(), billInfoEo);
            logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)isConsistency, (Object)billInfoEo.getPlatformOrderNo());
            if (isConsistency) {
                logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)isConsistency);
                throw new BizException("\u5e73\u53f0\u5355\uff1a" + billInfoEo.getPlatformOrderNo() + "\u53d1\u7968\u4fe1\u606f\uff1a\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u5f00\u7968\u6570\u636e");
            }
            RedOrderInvoiceAgainBillRespDto respDto = this.redInvoiceIsReopen(billInfoEo);
            billInfoEo.setAgainBillRedBillFlowNo(respDto.getRedBillFlowNo());
            logger.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4deliveryGen==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
            this.billInfoDas.insert((BaseEo)billInfoEo);
            ArrayList<String> platformOrderNoList = new ArrayList<String>();
            platformOrderNoList.add(billInfoEo.getPlatformOrderNo());
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
            this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode());
            this.syncAddKingdeeInvoice(billInfoEo, billItemEoList, respDto.getReopenIsBill());
        }
    }

    @Override
    public void resetAmountAndNumForBill(PerformOrderInfoDto order) {
        if (order == null) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1aorder\u4e3a\u7a7a - 1");
            return;
        }
        List snapshots = Optional.ofNullable(order.getPerformOrderSnapshotDtoList()).orElse(Collections.emptyList());
        if (snapshots.isEmpty()) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1asnapshots\u4e3a\u7a7a - 1");
            return;
        }
        String shopCode = ((PerformOrderSnapshotDto)snapshots.get(0)).getShopCode();
        BillStrategyRespDto strategy = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        this.resetAmountAndNumForBill(strategy, order);
    }

    @Override
    public void resetAmountAndNumForBill(BillStrategyRespDto strategy, PerformOrderInfoDto order) {
        if (order == null) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1aorder\u4e3a\u7a7a - 2");
            return;
        }
        this.resetAmountAndNumForBill(strategy, Lists.newArrayList((Object[])new PerformOrderInfoDto[]{order}));
    }

    @Override
    public void resetAmountAndNumForBill(List<PerformOrderInfoDto> orders) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orders)) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1aorders\u5217\u8868\u4e3a\u7a7a - 3");
            return;
        }
        Map<String, List<PerformOrderInfoDto>> groupByShop = orders.stream().filter(s -> !org.apache.commons.collections.CollectionUtils.isEmpty((Collection)s.getPerformOrderSnapshotDtoList())).filter(s -> StrUtil.isNotBlank((CharSequence)((PerformOrderSnapshotDto)s.getPerformOrderSnapshotDtoList().get(0)).getShopCode())).collect(Collectors.groupingBy(s -> ((PerformOrderSnapshotDto)s.getPerformOrderSnapshotDtoList().get(0)).getShopCode()));
        groupByShop.forEach((shopCode, values) -> {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5206\u7ec4\u67e5\u8be2\u5f00\u7968\u7b56\u7565\uff0c\u5e97\u94fa\u7f16\u7801\uff1a{}", shopCode);
            BillStrategyRespDto strategy = this.billStrategyService.queryByShopCodeAndType((String)shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
            this.resetAmountAndNumForBill(strategy, orders);
        });
    }

    @Override
    public void resetAmountAndNumForBill(BillStrategyRespDto strategy, List<PerformOrderInfoDto> orders) {
        if (strategy == null) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1astrategy\u4e3a\u7a7a - 4");
            return;
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orders)) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1aorders\u5217\u8868\u4e3a\u7a7a - 4");
            return;
        }
        boolean isKeepComplete = BillStrategyOrderPointEnum.KEEP_COMPLETE.equalsCode(strategy.getBillOrderPoint());
        if (isKeepComplete) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u6839\u636e\u5f00\u7968\u8bb0\u8d26\u91cd\u7b97");
            this.resetAmountAndNumForBillByKeep(strategy, orders);
            return;
        }
        logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u6839\u636e\u552e\u540e\u8ba2\u5355\u91cd\u7b97");
        this.resetRefundedPayAmountAndNum(orders);
    }

    private void resetAmountAndNumForBillByKeep(BillStrategyRespDto strategy, List<PerformOrderInfoDto> orders) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orders)) {
            return;
        }
        ArrayList saleOrderNos = new ArrayList();
        ArrayList platformOrderNos = new ArrayList();
        ArrayList orderItems = new ArrayList();
        HashSet hhOrderIds = new HashSet();
        HashMap orderItemMap = new HashMap();
        orders.forEach(o -> {
            saleOrderNos.add(o.getSaleOrderNo());
            boolean isHH = SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(o.getOrderType());
            if (isHH) {
                hhOrderIds.add(o.getId());
            }
            if (StrUtil.isNotBlank((CharSequence)o.getPlatformOrderNo()) && !platformOrderNos.contains(o.getPlatformOrderNo())) {
                platformOrderNos.add(o.getPlatformOrderNo());
            }
            List lines = Optional.ofNullable(o.getItemDtoList()).orElse(new ArrayList(0));
            o.setItemDtoList(lines);
            orderItems.addAll(lines);
            lines.forEach(line -> {
                line.setPlatformOrderNo(o.getPlatformOrderNo());
                orderItemMap.put(line.getId(), line);
            });
        });
        List afterSaleOrders = this.afterSaleOrderDas.queryByPlatformOrders(platformOrderNos);
        List noRelateAfterSaleOrderIds = afterSaleOrders.stream().filter(s -> "HH".equals(s.getAfterSaleOrderType())).filter(s -> Objects.equals(s.getRelateToPlatformOrder(), 1)).map(AfterSaleOrderEo::getExchangeSaleOrderId).filter(Objects::nonNull).collect(Collectors.toList());
        logger.info("\u6362\u8d27\u65e0\u539f\u5355: {}", noRelateAfterSaleOrderIds);
        afterSaleOrders.removeIf(o -> !Objects.equals(o.getIfInvoice(), 1));
        List afterSaleOrderNos = afterSaleOrders.stream().map(AfterSaleOrderEo::getAfterSaleOrderNo).collect(Collectors.toList());
        logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5f00\u7968\u7b56\u7565\uff1a{}\uff0c\u6d89\u53ca\u7684\u9500\u552e\u5355\u53f7\uff1a{}\uff0c\u6d89\u53ca\u7684\u552e\u540e\u5355\u53f7\uff1a{}", new Object[]{JSON.toJSONString((Object)strategy), JSON.toJSONString(saleOrderNos), JSON.toJSONString(afterSaleOrderNos)});
        HashMap afterSaleOrderMap = new HashMap();
        HashMap hhFcToShIdMap = new HashMap();
        afterSaleOrders.forEach(o -> {
            afterSaleOrderMap.put(o.getId(), o);
            if (AfterSaleOrderTypeEnum.HH.getCode().equals(o.getAfterSaleOrderType()) && o.getExchangeSaleOrderId() != null) {
                hhFcToShIdMap.put(o.getExchangeSaleOrderId(), o.getId());
            }
        });
        HashMap map = new HashMap();
        List afterSaleOrderItems = this.afterSaleOrderItemDas.queryByAfterSaleOrderIds(afterSaleOrderMap.keySet());
        HashSet fhhJtkAfterItemIds = new HashSet();
        HashMap afterSaleItemMap = new HashMap();
        afterSaleOrderItems.forEach(item -> {
            boolean isHHItem;
            List items = afterSaleItemMap.computeIfAbsent(item.getAfterSaleOrderId(), k -> new ArrayList());
            items.add(item);
            AfterSaleOrderEo afterSaleOrder = (AfterSaleOrderEo)afterSaleOrderMap.get(item.getAfterSaleOrderId());
            if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrder.getAfterSaleOrderType())) {
                fhhJtkAfterItemIds.add(item.getId());
            }
            boolean bl = isHHItem = AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrder.getAfterSaleOrderType()) && afterSaleOrder.getExchangeSaleOrderId() != null;
            if (!isHHItem) {
                if (item.getSaleOrderItemId() != null) {
                    List list = map.computeIfAbsent(item.getSaleOrderItemId(), k -> new ArrayList());
                    list.add(item.getId());
                }
                return;
            }
            PerformOrderItemDto orgItem = (PerformOrderItemDto)orderItemMap.get(item.getSaleOrderItemId());
            if (orgItem != null) {
                logger.info("\u6362\u8d27\u5355\u552e\u540e\u5355\u884c {} \u5339\u914d\u5230\u9500\u552e\u5355\u884c {}", (Object)item.getId(), (Object)orgItem.getId());
                List list = map.computeIfAbsent(orgItem.getId(), k -> new ArrayList());
                list.add(item.getId());
            }
        });
        logger.info("\u9500\u552e\u5355\u884c\u548c\u552e\u540e\u5355\u884c\u7684\u6620\u5c04\uff1a{}", (Object)JacksonUtil.toJson(map));
        logger.info("\u53d1\u8d27\u540e\u4ec5\u9000\u6b3e\u552e\u540e\u5355\u5546\u54c1\u884c\uff1a{}", fhhJtkAfterItemIds);
        ArrayList keepOrderNos = new ArrayList(saleOrderNos);
        keepOrderNos.addAll(afterSaleOrderNos);
        KeepAccountsDetailReqDto keepReq = new KeepAccountsDetailReqDto();
        keepReq.setOrderNos(keepOrderNos);
        keepReq.setAccountingResult("ACCOUNT_SUCCESS");
        keepReq.setVoucherType("1");
        List<KeepAccountsDetailRespDto> keepDetails = this.keepAccountsDetailService.queryAccountsDetailByOrderNos(keepReq);
        Map<Long, KeepAccountsDetailRespDto> keepMap = keepDetails.stream().collect(Collectors.toMap(k -> k.getOrderItemId(), v -> v, (a, b) -> {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u91cd\u590d\u7684\u8bb0\u8d26\u660e\u7ec6\uff1a{}-{}", (Object)b.getOrderNo(), (Object)b.getOrderItemId());
            return b;
        }));
        logger.info("keepMap: {}", (Object)JacksonUtil.toJson(keepMap));
        orderItems.forEach(item -> {
            List afterItemIds = map.getOrDefault(item.getId(), Collections.emptyList());
            List afterKeepList = afterItemIds.stream().map(keepMap::get).filter(Objects::nonNull).collect(Collectors.toList());
            BigDecimal newRefundedPayAmount = afterKeepList.stream().map(KeepAccountsDetailRespDto::getItemPrice).reduce(BigDecimal.ZERO, BigDecimal::add).abs().negate();
            BigDecimal newRefundedItemNum = afterKeepList.stream().map(k -> {
                if (fhhJtkAfterItemIds.contains(k.getOrderItemId())) {
                    return BigDecimal.ZERO;
                }
                return new BigDecimal(k.getItemNum());
            }).reduce(BigDecimal.ZERO, BigDecimal::add).abs().negate();
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u552e\u540e\u5355\u884c {}\uff0c\u552e\u540e\u5355\u884c\u5bf9\u5e94\u7684\u8bb0\u8d26\u660e\u7ec6\u6570\u91cf\uff1a{}", new Object[]{item.getId(), afterItemIds, afterKeepList.size()});
            if (noRelateAfterSaleOrderIds.contains(item.getOrderId())) {
                logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u5c5e\u4e8e\u5df2\u5b8c\u6210\u7684\u65e0\u539f\u5355\u6362\u8d27\u53d1\u51fa\u5355\u7684\u8ba2\u5355\u884c\uff0c\u8c03\u6574\u5df2\u9000\u91d1\u989d\u548c\u6570\u91cf\uff1arealPayAmount[{}], itemNum[{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), item.getItemNum(), item.getRefundedPayAmount(), newRefundedPayAmount, item.getRefundedItemNum(), newRefundedItemNum});
                item.setRefundedPayAmount(newRefundedPayAmount);
                item.setRefundedItemNum(newRefundedItemNum);
                return;
            }
            KeepAccountsDetailRespDto keep = (KeepAccountsDetailRespDto)keepMap.get(item.getId());
            if (keep == null) {
                logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u6ca1\u6709\u8bb0\u8d26\uff0c\u76f8\u5173\u53d8\u52a8\u5982\u4e0b\uff1arealPayAmount[{}->{}], itemNum[{}->{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), BigDecimal.ZERO, item.getItemNum(), BigDecimal.ZERO, item.getRefundedPayAmount(), BigDecimal.ZERO, item.getRefundedItemNum(), BigDecimal.ZERO});
                item.setRealPayAmount(BigDecimal.ZERO);
                item.setItemNum(BigDecimal.ZERO);
                item.setRefundedPayAmount(BigDecimal.ZERO);
                item.setRefundedItemNum(BigDecimal.ZERO);
                return;
            }
            boolean isHHfc = hhFcToShIdMap.containsValue(item.getOrderId());
            if (isHHfc) {
                Long afterSaleOrderId = (Long)hhFcToShIdMap.get(item.getOrderId());
                List hhAfterItemIds = ((List)afterSaleItemMap.getOrDefault(afterSaleOrderId, new ArrayList())).stream().map(BaseEo::getId).collect(Collectors.toList());
                logger.info("\u6362\u8d27\u53d1\u51fa\u5355 {} \u5bf9\u5e94\u7684\u552e\u540e\u5355\u5546\u54c1\u884c {} - {}", new Object[]{item.getOrderId(), afterSaleOrderId, hhAfterItemIds});
                List hhKeepList = hhAfterItemIds.stream().map(keepMap::get).filter(Objects::nonNull).collect(Collectors.toList());
                if (hhAfterItemIds.size() != hhKeepList.size()) {
                    logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u4e3a\u6362\u8d27\u8ba2\u5355\u884c\uff0c\u5e76\u4e14\u6ca1\u6709\u5bf9\u5e94\u7684\u552e\u540e\u8bb0\u8d26\u4fe1\u606f\uff0c\u76f8\u5173\u53d8\u52a8\u5982\u4e0b\uff1arealPayAmount[{}->{}], itemNum[{}->{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), BigDecimal.ZERO, item.getItemNum(), BigDecimal.ZERO, item.getRefundedPayAmount(), BigDecimal.ZERO, item.getRefundedItemNum(), BigDecimal.ZERO});
                    item.setRealPayAmount(BigDecimal.ZERO);
                    item.setItemNum(BigDecimal.ZERO);
                    item.setRefundedPayAmount(BigDecimal.ZERO);
                    item.setRefundedItemNum(BigDecimal.ZERO);
                    return;
                }
            }
            BigDecimal newRealPayAmount = keep.getItemPrice();
            BigDecimal newItemNum = new BigDecimal(keep.getItemNum());
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u83b7\u53d6\u5230\u9500\u552e\u5355/\u552e\u540e\u5355\u7684\u8bb0\u8d26\u4fe1\u606f\uff0c\u76f8\u5173\u53d8\u52a8\u5982\u4e0b\uff1arealPayAmount[{}->{}], itemNum[{}->{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), newRealPayAmount, item.getItemNum(), newItemNum, item.getRefundedPayAmount(), newRefundedPayAmount, item.getRefundedItemNum(), newRefundedItemNum});
            item.setRealPayAmount(newRealPayAmount);
            item.setItemNum(newItemNum);
            item.setRefundedPayAmount(newRefundedPayAmount);
            item.setRefundedItemNum(newRefundedItemNum);
        });
    }

    private void resetRefundedPayAmountAndNum(List<PerformOrderInfoDto> orders) {
        ArrayList platformOrderNos = new ArrayList();
        ArrayList<PerformOrderItemDto> orderItems = new ArrayList<PerformOrderItemDto>();
        HashMap lineIdMap = new HashMap();
        HashSet hhOrderIds = new HashSet();
        orders.forEach(o -> {
            boolean isHH = SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(o.getOrderType());
            if (isHH) {
                hhOrderIds.add(o.getId());
            }
            if (StrUtil.isNotBlank((CharSequence)o.getPlatformOrderNo()) && !platformOrderNos.contains(o.getPlatformOrderNo())) {
                platformOrderNos.add(o.getPlatformOrderNo());
            }
            List lines = Optional.ofNullable(o.getItemDtoList()).orElse(new ArrayList(0));
            o.setItemDtoList(lines);
            orderItems.addAll(lines);
            lines.forEach(line -> {
                line.setPlatformOrderNo(o.getPlatformOrderNo());
                lineIdMap.put(line.getId(), line);
            });
        });
        List<AfterSaleOrderEo> afterSaleOrders = this.afterSaleOrderDas.queryByPlatformOrders(platformOrderNos);
        List noRelateAfterSaleOrderIds = afterSaleOrders.stream().filter(s -> "HH".equals(s.getAfterSaleOrderType())).filter(s -> Objects.equals(s.getRelateToPlatformOrder(), 1)).map(AfterSaleOrderEo::getExchangeSaleOrderId).filter(Objects::nonNull).collect(Collectors.toList());
        logger.info("\u6362\u8d27\u65e0\u539f\u5355: {}", noRelateAfterSaleOrderIds);
        List hasHhOrderIds = afterSaleOrders.stream().filter(s -> "HH".equals(s.getAfterSaleOrderType())).map(AfterSaleOrderEo::getExchangeSaleOrderId).filter(Objects::nonNull).collect(Collectors.toList());
        ArrayList afterTypes = Lists.newArrayList((Object[])new String[]{"THTK", "HH", "FHHTK"});
        afterSaleOrders = afterSaleOrders.stream().filter(s -> AfterSaleOrderStatusEnum.FINISH.getCode().equals(s.getStatus())).filter(s -> afterTypes.contains(s.getAfterSaleOrderType())).filter(s -> Objects.equals(s.getRelateToPlatformOrder(), 0)).filter(s -> Objects.equals(s.getIfInvoice(), 1)).collect(Collectors.toList());
        if (afterSaleOrders.isEmpty()) {
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u6ca1\u6709 \u3010\u6709\u539f\u5355\u3011\u4e14\u3010\u662f\u5426\u5f00\u7968=\u662f\u3011\u7684\u552e\u540e\u5355\uff0c\u8bbe\u7f6e\u76f8\u5173\u9500\u552e\u5355\u7684\u5df2\u9000\u91d1\u989d\u4e3a0");
            for (PerformOrderInfoDto order : orders) {
                Optional.ofNullable(order.getItemDtoList()).ifPresent(items -> items.forEach(item -> {
                    if (hhOrderIds.contains(order.getId())) {
                        if (noRelateAfterSaleOrderIds.contains(item.getOrderId())) {
                            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u5c5e\u4e8e\u5df2\u5b8c\u6210\u7684\u65e0\u539f\u5355\u6362\u8d27\u53d1\u51fa\u5355\u7684\u8ba2\u5355\u884c\uff0c\u8c03\u6574\u5df2\u9000\u91d1\u989d\u548c\u6570\u91cf\uff1arealPayAmount[{}], itemNum[{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), item.getItemNum(), item.getRefundedPayAmount(), BigDecimal.ZERO, item.getRefundedItemNum(), BigDecimal.ZERO});
                            item.setRefundedPayAmount(BigDecimal.ZERO);
                            item.setRefundedItemNum(BigDecimal.ZERO);
                            return;
                        }
                        logger.info("\u91cd\u8bbe\u5df2\u9000\u91d1\u989d\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\uff1a\u5bf9\u5e94\u7684\u6362\u8d27\u5355\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u5f00\u7968\uff0c\u56e0\u6b64\u8bbe\u7f6e realPayAmount: {} -> 0, itemNum: {} -> 0", new Object[]{order.getPlatformOrderNo(), order.getSaleOrderNo(), item.getId(), item.getRealPayAmount(), item.getItemNum()});
                        item.setRealPayAmount(BigDecimal.ZERO);
                        item.setItemNum(BigDecimal.ZERO);
                    }
                    BigDecimal refundedPayAmount = Optional.ofNullable(item.getRefundedPayAmount()).orElse(BigDecimal.ZERO);
                    BigDecimal refundedItemNum = Optional.ofNullable(item.getRefundedItemNum()).orElse(BigDecimal.ZERO);
                    if (BigDecimal.ZERO.compareTo(refundedPayAmount) != 0) {
                        logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\u6ca1\u6709\u3010\u6709\u539f\u5355\u3011\u4e14\u3010\u662f\u5426\u5f00\u7968=\u662f\u3011\u7684\u552e\u540e\u5355\uff0c\u5df2\u9000\u91d1\u989d\u4ece {} \u8bbe\u7f6e\u4e3a 0 .", new Object[]{order.getPlatformOrderNo(), order.getSaleOrderNo(), item.getId(), refundedPayAmount});
                        item.setRefundedPayAmount(BigDecimal.ZERO);
                    }
                    if (BigDecimal.ZERO.compareTo(refundedItemNum) != 0) {
                        logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\u6ca1\u6709\u3010\u6709\u539f\u5355\u3011\u4e14\u3010\u662f\u5426\u5f00\u7968=\u662f\u3011\u7684\u552e\u540e\u5355\uff0c\u5df2\u9000\u6570\u91cf\u4ece {} \u8bbe\u7f6e\u4e3a 0 .", new Object[]{order.getPlatformOrderNo(), order.getSaleOrderNo(), item.getId(), refundedItemNum});
                        item.setRefundedItemNum(BigDecimal.ZERO);
                    }
                }));
            }
            return;
        }
        List afterSaleOrderIds = afterSaleOrders.stream().map(BaseEo::getId).collect(Collectors.toList());
        List finishedExchangeOrderIds = afterSaleOrders.stream().filter(s -> AfterSaleOrderTypeEnum.HH.getCode().equals(s.getAfterSaleOrderType())).map(AfterSaleOrderEo::getExchangeSaleOrderId).filter(Objects::nonNull).collect(Collectors.toList());
        List afterSaleOrderItems = this.afterSaleOrderItemDas.queryByAfterSaleOrderIds(afterSaleOrderIds);
        OrderLineClassificationDto classification = OrderLineClassificationDto.convert(orderItems, afterSaleOrders, afterSaleOrderItems);
        classification.share(afterSaleOrderItems);
        logger.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson((Object)classification));
        orderItems.forEach(item -> {
            OrderLineClassificationDto.OrderLine line;
            boolean isHH = hhOrderIds.contains(item.getOrderId());
            if (isHH && noRelateAfterSaleOrderIds.contains(item.getOrderId())) {
                logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u9500\u552e\u8ba2\u5355\u884c {} \u5c5e\u4e8e\u5df2\u5b8c\u6210\u7684\u65e0\u539f\u5355\u6362\u8d27\u53d1\u51fa\u5355\u7684\u8ba2\u5355\u884c\uff0c\u8c03\u6574\u5df2\u9000\u91d1\u989d\u548c\u6570\u91cf\uff1arealPayAmount[{}], itemNum[{}], refundedPayAmount[{}->{}], refundedItemNum[{}->{}]", new Object[]{item.getId(), item.getRealPayAmount(), item.getItemNum(), item.getRefundedPayAmount(), BigDecimal.ZERO, item.getRefundedItemNum(), BigDecimal.ZERO});
                item.setRefundedPayAmount(BigDecimal.ZERO);
                item.setRefundedItemNum(BigDecimal.ZERO);
                return;
            }
            if (isHH && !hasHhOrderIds.contains(item.getOrderId())) {
                logger.info("\u91cd\u8bbe\u5df2\u9000\u91d1\u989d\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\uff1a\u8be5\u8ba2\u5355\u884c\u5c5e\u4e8e\u6362\u8d27\u53d1\u51fa\u5355\u4f46\u6ca1\u6709\u6362\u8d27\u5355, \u4e0d\u9700\u8981\u5904\u7406 - 2", new Object[]{item.getPlatformOrderNo(), item.getOrderNo(), item.getId()});
                return;
            }
            boolean isFinish = finishedExchangeOrderIds.contains(item.getOrderId());
            if (isHH && !isFinish) {
                logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\uff1a\u5bf9\u5e94\u7684\u6362\u8d27\u5355\u672a\u5b8c\u6210\uff0c\u4e0d\u80fd\u5f00\u7968\uff0c\u56e0\u6b64\u8bbe\u7f6e realPayAmount: {} -> 0, itemNum: {} -> 0", new Object[]{item.getPlatformOrderNo(), item.getOrderNo(), item.getId(), item.getRealPayAmount(), item.getItemNum()});
                item.setRealPayAmount(BigDecimal.ZERO);
                item.setItemNum(BigDecimal.ZERO);
            }
            if ((line = classification.getLine(item.getId())) == null) {
                logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\uff1a\u627e\u4e0d\u5230\u5f52\u7c7b\u540e\u7684\u8ba2\u5355\u884c\uff0c\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u4fdd\u6301\u4e3a {}/{} \u4e0d\u53d8 .", new Object[]{item.getPlatformOrderNo(), item.getOrderNo(), item.getId(), item.getRefundedItemNum(), item.getRefundedPayAmount()});
                return;
            }
            BigDecimal refundedItemNum = line.getRefundedItemNum().negate();
            BigDecimal refundedPayAmount = line.getRefundedPayAmount().negate();
            logger.info("\u91cd\u7b97\u5b9e\u4ed8\u91d1\u989d&\u6570\u91cf&\u5df2\u9000\u91d1\u989d&\u5df2\u9000\u6570\u91cf\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]\uff1a\u5df2\u9000\u6570\u91cf\uff1a{} -> {}\uff0c\u5df2\u9000\u91d1\u989d\uff1a{} -> {}", new Object[]{item.getPlatformOrderNo(), item.getOrderNo(), item.getId(), item.getRefundedItemNum(), refundedItemNum, item.getRefundedPayAmount(), refundedPayAmount});
            item.setRefundedItemNum(refundedItemNum);
            item.setRefundedPayAmount(refundedPayAmount);
        });
    }

    @Override
    public List<AfterSaleOrderEo> getCanBillAfterSaleOrders(List<String> platformOrderNos) {
        List<AfterSaleOrderEo> afterSaleOrders = this.afterSaleOrderDas.queryByPlatformOrders(platformOrderNos);
        ArrayList afterTypes = Lists.newArrayList((Object[])new String[]{"THTK", "HH", "FHHTK"});
        afterSaleOrders = afterSaleOrders.stream().filter(s -> AfterSaleOrderStatusEnum.FINISH.getCode().equals(s.getStatus())).filter(s -> afterTypes.contains(s.getAfterSaleOrderType())).filter(s -> Objects.equals(s.getRelateToPlatformOrder(), 0)).filter(s -> Objects.equals(s.getIfInvoice(), 1)).collect(Collectors.toList());
        return afterSaleOrders;
    }

    private void deliveryGenMerge(List<PerformOrderInfoDto> saleOrderRespDtoList, List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList, BillStrategyRespDto billStrategyRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        this.resetAmountAndNumForBill(billStrategyRespDto, saleOrderRespDtoList);
        PerformOrderInfoDto saleOrderRespDto = new PerformOrderInfoDto();
        List<PerformOrderInfoDto> respDtos = saleOrderRespDtoList.stream().filter(x -> Objects.nonNull(x.getFreightCost()) && BigDecimal.ZERO.compareTo(x.getFreightCost()) < 0).collect(Collectors.toList());
        saleOrderRespDto = org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtos) ? (PerformOrderInfoDto)respDtos.get(0) : saleOrderRespDtoList.get(0);
        SaleOrderBillRecordDto saleOrderBillRecordRespDto = new SaleOrderBillRecordDto();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordRespDtoList)) {
            saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordRespDtoList.stream().sorted(Comparator.comparing(BaseDto::getUpdateTime).reversed()).collect(Collectors.toList()).get(0);
        } else {
            this.defaultBillRecord(saleOrderBillRecordRespDto, billStrategyRespDto, billInfoGenerateReqDto, saleOrderRespDto.getPlatformOrderNo());
        }
        BillInfoEo billInfoEo = new BillInfoEo();
        String invoiceSaleOrderNo = saleOrderRespDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.joining(","));
        billInfoEo.setInvoiceSaleOrderNo(invoiceSaleOrderNo);
        this.getBillInfo(saleOrderRespDto, billInfoEo, billStrategyRespDto, saleOrderBillRecordRespDto, billInfoGenerateReqDto);
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        this.freightInvoice(itemList, billStrategyRespDto, respDtos);
        List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
        Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
        saleOrderRespDtoList.forEach(performOrderInfoDto -> {
            logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderInfoDto.getItemDtoList()));
            if (this.orderTypeFilter(performOrderInfoDto.getOrderType()).booleanValue()) {
                if (OmsSaleOrderStatus.COMPLETE.getCode().equals(performOrderInfoDto.getOrderStatus())) {
                    performOrderInfoDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, itemList, zeroNumItemList));
                }
            } else {
                logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zeroNumItemList)) {
            if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
            } else {
                logger.info("\u8fd0\u8d39\u5bf9\u5e94\u5546\u54c1\u7f16\u7801\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5f00\u9000\u8d27\u670d\u52a1");
            }
        }
        logger.info("itemList====billInfoEo\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        logger.info("itemList====>{}", (Object)JSONUtil.toJsonStr(itemList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
            this.getDeliveryGenMergeItemList(billStrategyRespDto, itemList, billInfoEo, billItemEoList);
            logger.info("itemList====billInfoEo\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
            if (BigDecimalUtils.leZero((BigDecimal)billInfoEo.getInvoiceAmount()).booleanValue() || org.apache.commons.collections.CollectionUtils.isEmpty(billItemEoList)) {
                logger.info("\u5f00\u7968\u5546\u54c1\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5728\u91cd\u65b0\u5f00\u7968\u4e86");
                List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)saleOrderRespDto.getPlatformOrderNo())).list();
                ArrayList billInfoEos = Lists.newArrayList();
                PerformOrderInfoDto finalSaleOrderRespDto = saleOrderRespDto;
                billInfoEoList.forEach(v -> {
                    boolean isConsistency = this.billInfoValidateService.validateBillInfo(finalSaleOrderRespDto.getPlatformOrderNo(), (BillInfoEo)v);
                    logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)isConsistency, (Object)finalSaleOrderRespDto.getPlatformOrderNo());
                    if (isConsistency) {
                        logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e\uff1a{},{}", (Object)finalSaleOrderRespDto.getPlatformOrderNo(), (Object)isConsistency);
                        return;
                    }
                    billInfoEos.add(v);
                });
                this.redInvoice(billInfoEos);
                return;
            }
            if (Boolean.TRUE.equals(billInfoGenerateReqDto.getApplyFlag())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"apply_no", (Object)billInfoGenerateReqDto.getApplyNo());
                List billApplyEoList = this.billApplyMapper.selectList((Wrapper)queryWrapper);
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billApplyEoList)) {
                    BillApplyEo billApplyEo = (BillApplyEo)billApplyEoList.get(0);
                    billInfoEo.setTitleType(billApplyEo.getTitleType());
                    billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                    billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                    billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                    billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                    billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                    billInfoEo.setBank(billApplyEo.getBank());
                    billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                    billInfoEo.setMailbox(billApplyEo.getMailbox());
                    billInfoEo.setPhone(billApplyEo.getPhone());
                    billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                    billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
                }
            }
            this.getBillRemark(billStrategyRespDto, billInfoEo, saleOrderRespDto, billItemEoList);
            billInfoEo.setInvoiceRemarks(StrUtil.blankToDefault((CharSequence)billInfoGenerateReqDto.getInvoiceRemarks(), (String)billInfoEo.getInvoiceRemarks()));
            this.getShopAllElectricInfo(billInfoEo);
            logger.info("billStrategyRespDto.getBillAudit\uff1a{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
            if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType()) && null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
                boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
                String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCodeTwo();
                List applyColourType = billStrategyRespDto.getApplyColourType();
                boolean containsBillType = BillInfoColourTypeEnum.containsBillType((List)applyColourType, (String)billInfoEo.getBillType());
                logger.info("\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {} {} {} ", new Object[]{billInfoEo.getBillFlowNo(), billInfoEo.getBillType(), containsBillType});
                logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
                if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto && containsBillType) {
                    if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                    } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                        this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                    }
                }
            }
            boolean isConsistency = this.billInfoValidateService.validateBillInfo(billInfoEo.getPlatformOrderNo(), billInfoEo);
            logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)isConsistency, (Object)billInfoEo.getPlatformOrderNo());
            if (isConsistency) {
                logger.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)isConsistency);
                throw new BizException("\u5e73\u53f0\u5355\uff1a" + billInfoEo.getPlatformOrderNo() + "\u53d1\u7968\u4fe1\u606f\uff1a\u5f00\u7968\u91d1\u989d\u3001\u53d1\u7968\u7c7b\u578b\u3001\u62ac\u5934\u3001\u7a0e\u53f7\u3001\u53d1\u7968\u5907\u6ce8\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u5f00\u7968\u6570\u636e");
            }
            RedOrderInvoiceAgainBillRespDto respDto = this.redInvoiceIsReopen(billInfoEo);
            billInfoEo.setAgainBillRedBillFlowNo(respDto.getRedBillFlowNo());
            logger.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4deliveryGenMerge==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
            this.billInfoDas.insert((BaseEo)billInfoEo);
            ArrayList<String> platformOrderNoList = new ArrayList<String>();
            if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill())) {
                platformOrderNoList = billInfoGenerateReqDto.getPlatformOrderNoList();
            } else {
                platformOrderNoList.add(billInfoEo.getPlatformOrderNo());
            }
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
            if (CollectionUtils.isNotEmpty(billItemEoList)) {
                billItemEoList.forEach(a -> this.setSpecialRate(billInfoEo, (BillItemEo)a));
                logger.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4deliveryGenMerge==>billItemEoList:{}", (Object)LogUtils.buildLogContent(billItemEoList));
                this.billItemDas.insertBatch(billItemEoList);
                this.billInfoDas.insert((BaseEo)billInfoEo);
            }
            try {
                this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode());
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("\u66f4\u65b0\u5bf9\u5e94\u8ba2\u5355\u5f00\u7968\u4fe1\u606f\u4e3a\u5f85\u5f00\u7968:{},{}", new Object[]{billInfoEo.getPlatformOrderNo(), e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)});
            }
            logger.info("\u63a8\u9001\u4e07\u9e3f\u5f00\u7968\u660e\u7ec6\u884c\uff1a{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString(billItemEoList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItemEoList)) {
                this.syncAddKingdeeInvoice(billInfoEo, billItemEoList, respDto.getReopenIsBill());
            }
        } else {
            logger.info("\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e\u76f4\u63a5\u8c03\u7528\u53d1\u7968\u4f5c\u5e9f\u63a5\u53e3");
            List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)saleOrderRespDto.getPlatformOrderNo())).list();
            this.redInvoice(billInfoEoList);
        }
    }

    public void assembleFreightCostItem(BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, List<PerformOrderItemDto> zeroNumItemList) {
        ArrayList<String> skuCode = new ArrayList<String>();
        skuCode.add(billStrategyRespDto.getFreightCostItemCode());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
            ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
            PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
            performOrderItemDto.setGift(Integer.valueOf(0));
            performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
            performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
            performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
            performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
            performOrderItemDto.setSkuId(itemSkuDgDto.getId());
            performOrderItemDto.setSkuName(itemSkuDgDto.getName());
            performOrderItemDto.setItemNum(BigDecimal.ONE);
            BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
            performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
            performOrderItemDto.setSurplusCanRefundPayAmount(amount);
            performOrderItemDto.setSalePrice(amount);
            performOrderItemDto.setRealPayAmount(amount);
            performOrderItemDto.setPayAmount(amount);
            itemList.add(performOrderItemDto);
            logger.info("\u8ba2\u5355\u6570\u91cf\u9000\u8d27\u5b8c\u6210\u91d1\u989d\u4e0d\u4e3a\u96f6\u5f00\u7968\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
        }
    }

    public void filterItem(PerformOrderItemDto item, Map<String, BillStrategyNoInvoiceItemEo> itemEoMap, BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, List<PerformOrderItemDto> zeroNumItemList) {
        if (SaleItemStatusEnum.CANCEL.getCode().equals(item.getStatus())) {
            return;
        }
        if (itemEoMap.containsKey(item.getSkuCode())) {
            logger.info("\u6839\u636e\u7b56\u7565\u8be5\u5546\u54c1\u662f\u4e0d\u5f00\u7968\u5546\u54c1:{}", (Object)item.getSkuCode());
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) == 0) {
            logger.info("\u9500\u552e\u5355\u4ef7\u4e3a\u96f6\u8fc7\u6ee4\u4e0d\u5f00\u7968");
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) < 0) {
            item.setGift(Integer.valueOf(1));
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) < 0) {
            item.setGift(Integer.valueOf(0));
        }
        if (Objects.isNull(item.getRefundedItemNum()) || BigDecimal.ZERO.compareTo(item.getRefundedItemNum()) == 0) {
            if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                    if ("1".equals(billStrategyRespDto.getBillGift())) {
                        itemList.add(item);
                    } else if (0 == item.getGift()) {
                        itemList.add(item);
                    }
                }
            } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                itemList.add(item);
            } else if (0 == item.getGift()) {
                itemList.add(item);
            }
        } else {
            BigDecimal num = item.getItemNum().subtract(item.getRefundedItemNum().abs());
            if (num.compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                        if ("1".equals(billStrategyRespDto.getBillGift())) {
                            item.setItemNum(num);
                            itemList.add(item);
                        } else if (0 == item.getGift()) {
                            item.setItemNum(num);
                            itemList.add(item);
                        }
                    }
                } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                    item.setItemNum(num);
                    itemList.add(item);
                } else if (0 == item.getGift()) {
                    item.setItemNum(num);
                    itemList.add(item);
                }
            } else if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                zeroNumItemList.add(item);
            }
        }
    }

    public void getDeliveryGenMergeItemList(BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, BillInfoEo billInfoEo, List<BillItemEo> billItemEoList) {
        this.getDeliveryGenMergeItemList(billStrategyRespDto, itemList, billInfoEo, billItemEoList, true);
    }

    public void getDeliveryGenMergeItemList(BillStrategyRespDto billStrategyRespDto, List<PerformOrderItemDto> itemList, BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, boolean isAddOrUpddate) {
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList<PerformOrderItemDto> noWhetherMergeItem = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> whetherMergeItem = new ArrayList<PerformOrderItemDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            logger.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((PerformOrderItemDto)item);
                } else {
                    noWhetherMergeItem.add((PerformOrderItemDto)item);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoEo, billItemEoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, PerformOrderItemDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noWhetherMergeItem)) {
            logger.info("\u65e0\u9700\u7ec4\u5408\u5546\u54c1\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(noWhetherMergeItem));
            Map<String, List<PerformOrderItemDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(item -> item.getSkuCode() + item.getGift()));
            List<String> skuCodeList = noWhetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
            Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
            orderItemMap.forEach((k, v) -> {
                BillItemEo billItemEo = new BillItemEo();
                PerformOrderItemDto performOrderItemDto = (PerformOrderItemDto)v.get(0);
                billItemEo.setGift(performOrderItemDto.getGift());
                if (3 == performOrderItemDto.getGift()) {
                    billItemEo.setGift(Integer.valueOf(0));
                    billItemEo.setFreightCost(Integer.valueOf(1));
                }
                billItemEo.setItemId(performOrderItemDto.getSkuId());
                billItemEo.setItemCode(performOrderItemDto.getSkuCode());
                billItemEo.setItemName(performOrderItemDto.getSkuName());
                billItemEo.setFreightCost(performOrderItemDto.getIsFreightCost());
                billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billItemEo.setAmount(amount);
                billItemEo.setClinchDealAmount(amount);
                number.set(((BigDecimal)number.get()).add(amount));
                billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                billItemEo.setUnitPrice(performOrderItemDto.getSalePrice());
                billItemEo.setUnit(performOrderItemDto.getCalcUnitDesc());
                if (skuCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(performOrderItemDto.getSkuCode());
                    billItemEo.setItemName(itemSkuDgDto.getName());
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billItemEo.setThirdCode(itemSkuDgDto.getThirdCode());
                    billItemEo.setEnergyEfficiencyRating(itemSkuDgDto.getEnergyEfficiencyRating());
                    billItemEo.setSpecialInvoiceRemark(itemSkuDgDto.getSpecialInvoiceRemark());
                    billItemEo.setItemShortName(itemSkuDgDto.getDisplayName());
                    billItemEo.setPatentName(itemSkuDgDto.getPatentCode());
                    billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    billItemEo.setUnit(itemSkuDgDto.getPriceUnit());
                    this.assembleBillItemInfo(performOrderItemDto, itemSkuDgDto, billStrategyRespDto, billItemEo);
                }
                if (BigDecimalUtils.gtZero((BigDecimal)billItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)billItemEo.getQuantity()).booleanValue()) {
                    billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                }
                this.setSpecialRate(billInfoEo, billItemEo);
                billItemEoList.add(billItemEo);
            });
            this.addBillOrderItem(noWhetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto, isAddOrUpddate);
        }
        billInfoEo.setInvoiceAmount(number.get().add(mergeItemAmount));
        logger.info("getDeliveryGenMergeItemList:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString(billItemEoList));
    }

    public void assembleBillItemInfo(PerformOrderItemDto performOrderItemDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillItemEo billItemEo) {
        if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
            ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
            billItemEo.setTaxRate(itemRateDgDto.getRate());
            billItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            }
            billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public void assembleReqBillItemInfo(PerformOrderItemDto performOrderItemDto, ItemRateDgDto itemRateDgDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillItemReqDto billItemReqDto) {
        if (null != itemRateDgDto && null != itemRateDgDto.getId()) {
            billItemReqDto.setTaxRate(itemRateDgDto.getRate());
            billItemReqDto.setTaxClassificationCode(StrUtil.isEmpty((CharSequence)itemRateDgDto.getCode()) ? billStrategyRespDto.getTaxCode() : itemRateDgDto.getCode());
            billItemReqDto.setTaxAmount(billItemReqDto.getAmount().divide(billItemReqDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemReqDto.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemReqDto.getItemName()) ? "" : billItemReqDto.getItemName();
                billItemReqDto.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemReqDto.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billItemReqDto.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billItemReqDto.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billItemReqDto.setTaxAmount(billItemReqDto.getAmount().divide(billItemReqDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemReqDto.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billItemReqDto.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemReqDto.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemReqDto.getItemName()) ? "" : billItemReqDto.getItemName();
                billItemReqDto.setBillLineItemName(itemDisplayName);
            }
            billItemReqDto.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public void assembleBillOrderItemInfo(PerformOrderItemDto performOrderItemDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillOrderItemEo billOrderItemEo) {
        if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
            ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
            if (Objects.nonNull(itemRateDgDto)) {
                billOrderItemEo.setTaxRate(itemRateDgDto.getRate());
                billOrderItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            }
            billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            }
            billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    @Override
    public void syncAddKingdeeInvoice(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, Boolean reopenIsBill) {
        if (InvoiceStateEnum.WAIT_BILL.getCode().equals(billInfoEo.getInvoiceState())) {
            if (BillInfoColourTypeEnum.BLUE_TICKET.equalsCode(billInfoEo.getBillType())) {
                String platformOrderNo = billInfoEo.getPlatformOrderNo();
                List redList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"invoice_state", (Collection)Lists.newArrayList((Object[])new String[]{InvoiceStateEnum.WAIT_BILL.getCode(), InvoiceStateEnum.INVOICING.getCode()}))).eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"bill_type", (Object)"red_ticket")).list(Integer.valueOf(1));
                if (CollUtil.isNotEmpty((Collection)redList)) {
                    logger.info("\u5b58\u5728\u5f00\u7968\u4e2d\u7684\u7ea2\u7968\uff0c\u4e0d\u63a8\u9001\u5f00\u7968 {}", (Object)platformOrderNo);
                    return;
                }
            }
            this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.INVOICING.getCode());
            CompletableFuture.runAsync(() -> {
                logger.info("\u5f02\u6b65\u8c03\u7528\u65b0\u589e\u53d1\u7968");
                RestResponse response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto(billInfoEo, billItemEoList, 1));
                logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, billInfoEo.getId()));
            });
        }
    }

    public BigDecimal whetherMergeItem(List<PerformOrderItemDto> whetherMergeItem, BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto) {
        logger.info("\u7ec4\u5408\u5546\u54c1\u5408\u5e76:{}", (Object)JSON.toJSONString(whetherMergeItem));
        Map<String, List<PerformOrderItemDto>> listMap = whetherMergeItem.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getGroupSkuCode));
        List<String> skuCodeList = whetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        listMap.forEach((k, v) -> {
            BillItemEo billItemEo = new BillItemEo();
            PerformOrderItemDto saleOrderItemExtRespDto = (PerformOrderItemDto)v.get(0);
            billItemEo.setGift(saleOrderItemExtRespDto.getGift());
            billItemEo.setItemId(saleOrderItemExtRespDto.getGroupItemId());
            billItemEo.setItemCode(saleOrderItemExtRespDto.getGroupSkuCode());
            billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
            BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = payAmount.subtract(refundedPayAmount);
            billItemEo.setAmount(amount);
            billItemEo.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemEo.setSpecification(saleOrderItemExtRespDto.getSpecOne());
            billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
            ArrayList patentNameList = new ArrayList();
            ArrayList itemNameList = new ArrayList();
            AtomicReference<ItemRateDgDto> itemRateDgDto = new AtomicReference<ItemRateDgDto>(new ItemRateDgDto());
            v.forEach(item -> {
                if (skuCodeMap.containsKey(item.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(item.getSkuCode());
                    patentNameList.add(itemSkuDgDto.getPatentCode());
                    itemNameList.add(itemSkuDgDto.getName());
                    if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
                        itemRateDgDto.set(itemSkuDgDto.getItemRateDgDto());
                    }
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                }
            });
            String patentName = patentNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(";"));
            String itemName = itemNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining("+"));
            billItemEo.setItemName(itemName);
            billItemEo.setItemShortName(saleOrderItemExtRespDto.getGroupItemName());
            billItemEo.setBillLineItemName(saleOrderItemExtRespDto.getSkuName());
            billItemEo.setUnit(saleOrderItemExtRespDto.getCalcUnit());
            billItemEo.setPatentName(patentName);
            if (null != itemRateDgDto.get() && null != itemRateDgDto.get().getId()) {
                ItemRateDgDto itemRateDgEo = itemRateDgDto.get();
                billItemEo.setTaxRate(itemRateDgEo.getRate());
                billItemEo.setTaxClassificationCode(itemRateDgEo.getCode());
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                    billItemEo.setBillLineItemName(itemDisplayName);
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    } else {
                        billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                    }
                }
            } else {
                if (null != billStrategyRespDto.getTaxRate()) {
                    billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                }
                if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                    billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    }
                } else {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                    billItemEo.setBillLineItemName(itemDisplayName);
                }
                billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
            }
            billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
            billItemEo.setUnit(saleOrderItemExtRespDto.getCalcUnitDesc());
            this.setSpecialRate(billInfoEo, billItemEo);
            billItemEoList.add(billItemEo);
        });
        this.addBillOrderItem(whetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto);
        return number.get();
    }

    public BigDecimal whetherMergeItem(List<PerformOrderItemDto> whetherMergeItem, BillInfoReqDto billInfoReqDto, List<BillItemReqDto> billItemReqDtoList, BillStrategyRespDto billStrategyRespDto) {
        logger.info("\u7ec4\u5408\u5546\u54c1\u5408\u5e76:{}", (Object)JSON.toJSONString(whetherMergeItem));
        Map<String, List<PerformOrderItemDto>> listMap = whetherMergeItem.stream().collect(Collectors.groupingBy(PerformOrderItemDto::getGroupSkuCode));
        List<String> skuCodeList = whetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        listMap.forEach((k, v) -> {
            BillItemReqDto billItemReqDto = new BillItemReqDto();
            PerformOrderItemDto saleOrderItemExtRespDto = (PerformOrderItemDto)v.get(0);
            billItemReqDto.setGift(saleOrderItemExtRespDto.getGift());
            billItemReqDto.setItemId(saleOrderItemExtRespDto.getGroupItemId());
            billItemReqDto.setItemCode(saleOrderItemExtRespDto.getGroupSkuCode());
            billItemReqDto.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemReqDto.setBillFlowNo(billInfoReqDto.getBillFlowNo());
            BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = payAmount.subtract(refundedPayAmount);
            billItemReqDto.setAmount(amount);
            billItemReqDto.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemReqDto.setPlatformOrderNo(billInfoReqDto.getPlatformOrderNo());
            ArrayList patentNameList = new ArrayList();
            ArrayList itemNameList = new ArrayList();
            AtomicReference<ItemRateDgDto> itemRateDgDto = new AtomicReference<ItemRateDgDto>(new ItemRateDgDto());
            v.forEach(item -> {
                if (skuCodeMap.containsKey(item.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(item.getSkuCode());
                    patentNameList.add(itemSkuDgDto.getPatentCode());
                    itemNameList.add(itemSkuDgDto.getName());
                    if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
                        itemRateDgDto.set(itemSkuDgDto.getItemRateDgDto());
                    }
                }
            });
            String patentName = patentNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(";"));
            String itemName = itemNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining("+"));
            billItemReqDto.setItemName(itemName);
            billItemReqDto.setItemShortName(saleOrderItemExtRespDto.getGroupItemName());
            billItemReqDto.setPatentName(patentName);
            if (null != itemRateDgDto.get() && null != itemRateDgDto.get().getId()) {
                ItemRateDgDto itemRateDgEo = itemRateDgDto.get();
                billItemReqDto.setTaxRate(itemRateDgEo.getRate());
                billItemReqDto.setTaxClassificationCode(itemRateDgEo.getCode());
                billItemReqDto.setTaxAmount(billItemReqDto.getAmount().divide(itemRateDgEo.getRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(itemRateDgEo.getRate()).setScale(2, 4));
                if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemReqDto.getItemName()) ? "" : billItemReqDto.getItemName();
                    billItemReqDto.setBillLineItemName(itemDisplayName);
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemReqDto.setBillLineItemName(itemSkuDgDto.getName());
                    }
                } else {
                    billItemReqDto.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                }
            } else {
                if (null != billStrategyRespDto.getTaxRate()) {
                    billItemReqDto.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    billItemReqDto.setTaxAmount(billItemReqDto.getAmount().divide(billItemReqDto.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemReqDto.getTaxRate()).setScale(2, 4));
                }
                if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                    billItemReqDto.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemReqDto.setBillLineItemName(itemSkuDgDto.getName());
                    }
                } else {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemReqDto.getItemName()) ? "" : billItemReqDto.getItemName();
                    billItemReqDto.setBillLineItemName(itemDisplayName);
                }
                billItemReqDto.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
            }
            billItemReqDto.setUnitPrice(billItemReqDto.getAmount().divide(billItemReqDto.getQuantity(), 2, RoundingMode.HALF_UP));
            billItemReqDto.setUnit(saleOrderItemExtRespDto.getCalcUnitDesc());
            billItemReqDtoList.add(billItemReqDto);
        });
        BillInfoEo billInfoEo = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)billInfoEo, (Object)billInfoReqDto, (String[])new String[0]);
        this.addBillOrderItem(whetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto);
        return number.get();
    }

    public void getBillInfo(PerformOrderInfoDto performOrderInfoDto, BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto, SaleOrderBillRecordDto saleOrderBillRecordRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        billInfoEo.setBillFlowNo(billFlowNo);
        if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill())) {
            billInfoEo.setPlatformOrderNo(String.join((CharSequence)",", billInfoGenerateReqDto.getPlatformOrderNoList()));
        } else {
            billInfoEo.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
        }
        billInfoEo.setWhetherMergeBill(billInfoGenerateReqDto.getWhetherMergeBill());
        billInfoEo.setApplyNo(saleOrderBillRecordRespDto.getApplyNo());
        PerformOrderSnapshotDto performOrderSnapshotDto = (PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0);
        billInfoEo.setShopId(performOrderSnapshotDto.getShopId());
        billInfoEo.setShopCode(performOrderSnapshotDto.getShopCode());
        ShopEo shopEo = this.shopService.selectShopByCode(performOrderSnapshotDto.getShopCode());
        billInfoEo.setOrganizationCode(shopEo.getOrganizationCode());
        billInfoEo.setShopName(shopEo.getName());
        billInfoEo.setSite(performOrderSnapshotDto.getSiteName());
        billInfoEo.setSiteCode(performOrderSnapshotDto.getSiteCode());
        billInfoEo.setCustomerCode(performOrderSnapshotDto.getHsCustomerCode());
        billInfoEo.setCustomerName(performOrderSnapshotDto.getHsCustomerName());
        billInfoEo.setTitleType(saleOrderBillRecordRespDto.getTitleType());
        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getTaxesCode()) ? saleOrderBillRecordRespDto.getTaxesCode().replace(" ", "") : null);
        billInfoEo.setRegisteredAddress(saleOrderBillRecordRespDto.getRegisteredAddress());
        billInfoEo.setRegisteredPhone(saleOrderBillRecordRespDto.getRegisteredPhone());
        billInfoEo.setBankAccount(saleOrderBillRecordRespDto.getBankAccount());
        billInfoEo.setBank(saleOrderBillRecordRespDto.getBank());
        BillEntityEo entityEo = new BillEntityEo();
        if (null != billStrategyRespDto.getBillEntityCode()) {
            entityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
        }
        billInfoEo.setDistributorRegisteredAddress(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorRegisteredAddress()) ? saleOrderBillRecordRespDto.getDistributorRegisteredAddress() : entityEo.getRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorRegisteredPhone()) ? saleOrderBillRecordRespDto.getDistributorRegisteredPhone() : entityEo.getRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorTaxesCode()) ? saleOrderBillRecordRespDto.getDistributorTaxesCode() : entityEo.getTaxesCode());
        billInfoEo.setDistributorBank(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorBank()) ? saleOrderBillRecordRespDto.getDistributorBank() : entityEo.getBank());
        billInfoEo.setDistributorBankAccount(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorBankAccount()) ? saleOrderBillRecordRespDto.getDistributorBankAccount() : entityEo.getBankAccount());
        billInfoEo.setCollectPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getCollectPerson()) ? saleOrderBillRecordRespDto.getCollectPerson() : entityEo.getCollectPerson());
        billInfoEo.setBillPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getBillPerson()) ? saleOrderBillRecordRespDto.getBillPerson() : entityEo.getBillPerson());
        billInfoEo.setReviewPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getReviewPerson()) ? saleOrderBillRecordRespDto.getReviewPerson() : entityEo.getReviewPerson());
        billInfoEo.setCreateType(BillCreateTypeEnum.SYSTEM.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        billInfoEo.setMailbox(saleOrderBillRecordRespDto.getMailbox());
        billInfoEo.setPhone(saleOrderBillRecordRespDto.getPhone());
        if (null != saleOrderBillRecordRespDto.getEntityId()) {
            BillEntityEo entity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)saleOrderBillRecordRespDto.getEntityId())).one();
            if (Objects.nonNull(entity)) {
                billInfoEo.setEntityId(entity.getId());
                billInfoEo.setEntityCode(entity.getEntityCode());
                billInfoEo.setEntityName(entity.getEntityName());
                billInfoEo.setEnterprise(entity.getEnterprise());
            }
        } else {
            billInfoEo.setEntityId(entityEo.getId());
            billInfoEo.setEntityCode(entityEo.getEntityCode());
            billInfoEo.setEntityName(entityEo.getEntityName());
            billInfoEo.setEnterprise(entityEo.getEnterprise());
        }
        billInfoEo.setBillChannel(billStrategyRespDto.getBillChannel());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        billInfoEo.setInvoiceAmount(saleOrderBillRecordRespDto.getInvoiceAmount());
        billInfoEo.setBillTitle(saleOrderBillRecordRespDto.getBillTitle());
        billInfoEo.setTitleType(saleOrderBillRecordRespDto.getTitleType());
        logger.info("\u6784\u5efa\u5f00\u7968billInfoEo\u4e4b\u524d==\u300b{}", (Object)JSONUtil.toJsonStr((Object)billInfoEo));
        if (Boolean.TRUE.equals(billInfoGenerateReqDto.getApplyFlag())) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"apply_no", (Object)billInfoGenerateReqDto.getApplyNo());
            List billApplyEoList = this.billApplyMapper.selectList((Wrapper)queryWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billApplyEoList)) {
                BillApplyEo billApplyEo = (BillApplyEo)billApplyEoList.get(0);
                billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                billInfoEo.setTitleType(billApplyEo.getTitleType());
                billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                billInfoEo.setBank(billApplyEo.getBank());
                billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                billInfoEo.setMailbox(billApplyEo.getMailbox());
                billInfoEo.setPhone(billApplyEo.getPhone());
                billInfoEo.setBillPersonPhone(billApplyEo.getBillPersonPhone());
                billInfoEo.setBillPersonName(billApplyEo.getBillPersonName());
            }
        }
        if (!BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType())) {
            billInfoEo.setBillPersonPhone(saleOrderBillRecordRespDto.getBillPersonPhone());
            billInfoEo.setBillPersonName(saleOrderBillRecordRespDto.getBillPersonName());
            billInfoEo.setBillAddress(saleOrderBillRecordRespDto.getBillAddress());
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType())) {
            billInfoEo.setBillChannel(billStrategyRespDto.getBillChannel());
        }
        if (StringUtils.isBlank((CharSequence)billInfoEo.getBillTitle())) {
            billInfoEo.setBillTitle("\u4e2a\u4eba");
        }
        billInfoEo.setInvoiceType(this.invoiceTypeConvert.invoiceTypeConvert(performOrderInfoDto.getPlatformOrderNo(), billStrategyRespDto, saleOrderBillRecordRespDto, billInfoEo, billInfoGenerateReqDto));
        billInfoEo.setSubsidiesType(Integer.valueOf(null != performOrderInfoDto.getSubsidiesType() ? performOrderInfoDto.getSubsidiesType() : 0));
        if (StringUtils.isNotBlank((CharSequence)performOrderInfoDto.getPlatformOrderNo())) {
            Integer subsidiesType = this.getSubsidiesType(performOrderInfoDto.getPlatformOrderNo());
            billInfoEo.setSubsidiesType(subsidiesType);
        }
        this.validateAndResetCustomerInfoForMultiArea(billInfoEo, billStrategyRespDto, performOrderInfoDto);
        logger.info("\u6784\u5efa\u5f00\u7968billInfoEo==\u300b{}", (Object)JSONUtil.toJsonStr((Object)billInfoEo));
    }

    @Override
    public void autoAuditCheck(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto) {
        List collect;
        logger.info("\u81ea\u52a8\u5ba1\u6838\u5f00\u59cbautoAuditCheck:{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        BillEntityEo billEntityEo = new BillEntityEo();
        if (null != billInfoEo.getEntityId()) {
            billEntityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billInfoEo.getEntityId())).one();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billType.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        List billInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"bill_type", billType)).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(collect = billInfoEos.stream().filter(x -> x.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.INVOICING.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.FAILED.getCode())).collect(Collectors.toList()))) {
            errorList.add("\u5b58\u5728\u7ea2\u7968\u672a\u5f00\u7968\u6210\u529f\uff0c\u84dd\u7968\u65e0\u6cd5\u5ba1\u6838\u901a\u8fc7");
            flag.set(false);
        }
        if (SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode().equals(billInfoEo.getSubsidiesType())) {
            logger.info("\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cgetUseBlackList,getBlackListContent:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
            logger.info("\u62ac\u5934billTitle,blackListContent:{},{}", (Object)billInfoEo.getBillTitle(), (Object)billStrategyRespDto.getBlackListContent());
            if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getUseBlackList()) && UseBlackListEnum.YES.getCode().equals(billStrategyRespDto.getUseBlackList()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBlackListContent()) && (billInfoEo.getBillTitle().contains(billStrategyRespDto.getBlackListContent()) || billStrategyRespDto.getBlackListContent().contains(billInfoEo.getBillTitle()))) {
                errorList.add("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355");
                flag.set(false);
            }
        }
        if (BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getBillPersonPhone()) && !billInfoEo.getBillPersonPhone().matches("1[0-9]\\d{9}")) {
            errorList.add("\u6536\u7968\u4eba\u7535\u8bdd\u53f7\u586b\u5199\u9519\u8bef");
            flag.set(false);
        }
        if (BigDecimal.ZERO.compareTo(billInfoEo.getInvoiceAmount()) >= 0) {
            errorList.add("\u53d1\u7968\u603b\u91d1\u989d\u4e3a\u96f6");
            flag.set(false);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItemEoList)) {
            billItemEoList.forEach(item -> {
                if (StringUtils.isEmpty((CharSequence)item.getTaxClassificationCode())) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (null == item.getTaxRate() || BigDecimal.ZERO.compareTo(item.getTaxRate()) == 0) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u7387\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (StringUtils.isBlank((CharSequence)item.getBillLineItemName())) {
                    errorList.add(String.format("\u5546\u54c1%s\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
            });
        } else {
            errorList.add("\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
            flag.set(false);
        }
        if (BillInfoColourTypeEnum.BLUE_TICKET.equalsCode(billInfoEo.getBillType())) {
            List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.RED_TICKET.getCode())).list();
            logger.info("\u84dd\u7968\u5ba1\u6838\u65f6\u5019\u6821\u9a8c\u7ea2\u7968:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                List collect2 = billInfoEoList.stream().filter(x -> "invoicing".equals(x.getInvoiceState())).collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty(collect2)) {
                    errorList.add("\u5b58\u5728\u5f00\u7968\u4e2d\u7684\u7ea2\u7968");
                    flag.set(false);
                } else {
                    List blueBillInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).in((Object)"invoice_state", Arrays.asList("billed", "invoicing", "wait_bill", "failed"))).list();
                    logger.info("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)blueBillInfoEoList)) {
                        errorList.add("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968");
                        flag.set(false);
                    }
                }
            } else {
                List blueBillInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).in((Object)"invoice_state", Arrays.asList("billed", "invoicing", "wait_bill", "failed"))).list();
                logger.info("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)blueBillInfoEoList)) {
                    errorList.add("\u5b58\u5728\u6709\u6548\u7684\u84dd\u7968");
                    flag.set(false);
                }
            }
        }
        if (flag.get()) {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
        } else {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
            billInfoEo.setAuditFailReason(String.join((CharSequence)";", errorList));
        }
    }

    public void getShopAllElectricInfo(BillInfoEo billInfoEo) {
        logger.info("\u67e5\u8be2\u662f\u5426\u4e3a\u5168\u7535\u5e97\u94fa:{}", (Object)billInfoEo.getShopCode());
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getShopCode())) {
            List list = ((ExtQueryChainWrapper)this.billAllElectricShopDas.filter().eq((Object)"shop_code", (Object)billInfoEo.getShopCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                logger.info("\u5168\u7535\u5e97\u94fa\u66f4\u65b0\u53d1\u7968\u7c7b\u578b");
                switch (billInfoEo.getInvoiceType()) {
                    case "electronic_general_invoice": 
                    case "paper_general_invoice": 
                    case "all_electronic_general_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode());
                        break;
                    }
                    case "special_paper_invoice": 
                    case "all_electronic_special_invoice": 
                    case "electronic_special_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode());
                        break;
                    }
                }
            }
        } else {
            logger.info("\u53d1\u7968\u5e97\u94fa\u4e3a\u7a7a");
        }
    }

    public void defaultBillRecord(SaleOrderBillRecordDto saleOrderBillRecordRespDto, BillStrategyRespDto billStrategyRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto, String platformOrderNo) {
        saleOrderBillRecordRespDto.setBillTitle("\u4e2a\u4eba");
        saleOrderBillRecordRespDto.setTitleType(BillTitleTypeEnum.PERSON.getCode());
        saleOrderBillRecordRespDto.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode());
        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBillEntityCode())) {
            BillEntityEo billEntity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
            saleOrderBillRecordRespDto.setDistributorRegisteredAddress(billEntity.getRegisteredAddress());
            saleOrderBillRecordRespDto.setDistributorRegisteredPhone(billEntity.getRegisteredPhone());
            saleOrderBillRecordRespDto.setDistributorBank(billEntity.getBank());
            saleOrderBillRecordRespDto.setDistributorBankAccount(billEntity.getBankAccount());
            saleOrderBillRecordRespDto.setDistributorTaxesCode(billEntity.getTaxesCode());
            saleOrderBillRecordRespDto.setCollectPerson(billEntity.getCollectPerson());
            saleOrderBillRecordRespDto.setBillPerson(billEntity.getBillPerson());
            saleOrderBillRecordRespDto.setReviewPerson(billEntity.getReviewPerson());
        }
        saleOrderBillRecordRespDto.setBillPersonName(billInfoGenerateReqDto.getBillPersonName());
        saleOrderBillRecordRespDto.setBillPersonPhone(billInfoGenerateReqDto.getBillPersonPhone());
        saleOrderBillRecordRespDto.setBillAddress(billInfoGenerateReqDto.getBillAddress());
        List applyEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).orderByDesc((Object)"id")).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)applyEoList)) {
            BillApplyEo billApplyEo = (BillApplyEo)applyEoList.get(0);
            logger.info("\u91cd\u8bbe\u9500\u552e\u8ba2\u5355\u5f00\u7968\u8bb0\u5f55\u6570\u636e\uff1a{}", (Object)JSON.toJSONString((Object)billApplyEo));
            saleOrderBillRecordRespDto.setBillTitle(billApplyEo.getBillTitle());
            saleOrderBillRecordRespDto.setTitleType(billApplyEo.getTitleType());
            saleOrderBillRecordRespDto.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
            saleOrderBillRecordRespDto.setRegisteredAddress(billApplyEo.getRegisteredAddress());
            saleOrderBillRecordRespDto.setRegisteredPhone(billApplyEo.getRegisteredPhone());
            saleOrderBillRecordRespDto.setBankAccount(billApplyEo.getBankAccount());
            saleOrderBillRecordRespDto.setBank(billApplyEo.getBank());
            saleOrderBillRecordRespDto.setApplyNo(billApplyEo.getApplyNo());
            saleOrderBillRecordRespDto.setMailbox(billApplyEo.getMailbox());
            saleOrderBillRecordRespDto.setPhone(billApplyEo.getPhone());
            saleOrderBillRecordRespDto.setBillPersonPhone(billApplyEo.getBillPersonPhone());
            saleOrderBillRecordRespDto.setBillPersonName(billApplyEo.getBillPersonName());
        }
    }

    private List<BillItemEo> saveBillDetailInfo(PerformOrderInfoDto performOrderInfoDto, BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto) {
        List<BillItemEo> billItemEoList = this.getBillDetailInfo(performOrderInfoDto, billInfoEo, billStrategyRespDto);
        this.billItemDas.insertBatch(billItemEoList);
        return billItemEoList;
    }

    private List<BillItemEo> getBillDetailInfo(PerformOrderInfoDto performOrderInfoDto, BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto) {
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderInfoDto.getItemDtoList()));
        if (this.orderTypeFilter(performOrderInfoDto.getOrderType()).booleanValue()) {
            if (!OmsSaleOrderStatus.CANCEL.getCode().equals(performOrderInfoDto.getOrderStatus())) {
                ArrayList<PerformOrderInfoDto> performOrderInfoDtoList = new ArrayList<PerformOrderInfoDto>();
                performOrderInfoDtoList.add(performOrderInfoDto);
                this.freightInvoice(itemList, billStrategyRespDto, performOrderInfoDtoList);
                List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
                Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
                performOrderInfoDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, (List<PerformOrderItemDto>)itemList, (List<PerformOrderItemDto>)zeroNumItemList));
            }
        } else {
            logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zeroNumItemList)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
                BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
                BigDecimal payAmount = ((PerformOrderItemDto)itemList.get(0)).getRealPayAmount();
                ((PerformOrderItemDto)itemList.get(0)).setRealPayAmount(payAmount.add(amount));
                logger.info("\u5b58\u5728\u5546\u54c1\u9000\u6570\u91cf\u5b8c\u6210\u91d1\u989d\u5927\u4e8e\u96f6\uff1a{}", (Object)amount);
            } else if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            logger.info("\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e");
            return new ArrayList<BillItemEo>();
        }
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList noWhetherMergeItem = new ArrayList();
        ArrayList<PerformOrderItemDto> whetherMergeItem = new ArrayList<PerformOrderItemDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            logger.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((PerformOrderItemDto)item);
                } else {
                    noWhetherMergeItem.add(item);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoEo, billItemEoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, PerformOrderItemDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noWhetherMergeItem)) {
            Map<String, List<PerformOrderItemDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(item -> item.getSkuCode() + item.getGift()));
            List<String> skuCodeList = noWhetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
            Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
            orderItemMap.forEach((k, v) -> {
                BillItemEo billItemEo = new BillItemEo();
                PerformOrderItemDto performOrderItemDto = (PerformOrderItemDto)v.get(0);
                billItemEo.setGift(performOrderItemDto.getGift());
                if (3 == performOrderItemDto.getGift()) {
                    billItemEo.setGift(Integer.valueOf(0));
                    billItemEo.setFreightCost(Integer.valueOf(1));
                }
                billItemEo.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
                billItemEo.setSpecification(performOrderItemDto.getSpecOne());
                billItemEo.setUnit(performOrderItemDto.getBasicUnitName());
                billItemEo.setFreightCost(performOrderItemDto.getIsFreightCost());
                billItemEo.setItemId(performOrderItemDto.getSkuId());
                billItemEo.setItemCode(performOrderItemDto.getSkuCode());
                billItemEo.setItemName(performOrderItemDto.getSkuName());
                billItemEo.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billItemEo.setAmount(amount);
                billItemEo.setClinchDealAmount(amount);
                number.set(((BigDecimal)number.get()).add(amount));
                billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                billItemEo.setUnit(performOrderItemDto.getCalcUnitDesc());
                if (skuCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(performOrderItemDto.getSkuCode());
                    billItemEo.setItemName(itemSkuDgDto.getName());
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billItemEo.setThirdCode(itemSkuDgDto.getThirdCode());
                    billItemEo.setEnergyEfficiencyRating(itemSkuDgDto.getEnergyEfficiencyRating());
                    billItemEo.setSpecialInvoiceRemark(itemSkuDgDto.getSpecialInvoiceRemark());
                    billItemEo.setItemShortName(itemSkuDgDto.getDisplayName());
                    billItemEo.setPatentName(itemSkuDgDto.getPatentCode());
                    billItemEo.setUnit(itemSkuDgDto.getSaleUnitName());
                    this.assembleBillItemInfo(performOrderItemDto, itemSkuDgDto, billStrategyRespDto, billItemEo);
                }
                this.setSpecialRate(billInfoEo, billItemEo);
                billItemEoList.add(billItemEo);
            });
            this.addBillOrderItem(itemList, billInfoEo, skuCodeMap, billStrategyRespDto);
        }
        billInfoEo.setInvoiceAmount(number.get().add(mergeItemAmount));
        this.getBillRemark(billStrategyRespDto, billInfoEo, performOrderInfoDto, billItemEoList);
        this.itemGiftGenerateEo(billItemEoList);
        logger.info("saveBillDetailInfo==>billItemEoList:{}", (Object)LogUtils.buildLogContent(billItemEoList));
        if (BigDecimalUtils.leZero((BigDecimal)billInfoEo.getInvoiceAmount()).booleanValue() || org.apache.commons.collections.CollectionUtils.isEmpty(billItemEoList)) {
            logger.info("\u5f00\u7968\u91d1\u989d\u4e3a0\u4e0d\u5f00\u7968");
            return Collections.EMPTY_LIST;
        }
        return billItemEoList;
    }

    public void getBillRemark(BillStrategyRespDto billStrategyRespDto, BillInfoEo billInfoEo, PerformOrderInfoDto performOrderInfoDto, List<BillItemEo> billItemEoList) {
        List list;
        ArrayList remarks = Lists.newArrayList();
        if (BillStrategyRemarkType.PLATFORM.containsCode(billStrategyRespDto.getRemark())) {
            billInfoEo.setInvoiceRemarks(performOrderInfoDto.getPlatformOrderNo());
            remarks.add(performOrderInfoDto.getPlatformOrderNo());
        }
        if (BillStrategyRemarkType.PATENT.containsCode(billStrategyRespDto.getRemark())) {
            list = billItemEoList.stream().map(BillItemEo::getPatentName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(list)) {
                remarks.addAll(list);
            }
            billInfoEo.setInvoiceRemarks(String.join((CharSequence)";", remarks));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).orderByDesc((Object)"create_time")).list(Integer.valueOf(2))))) {
            String joinRemarks;
            String str = StrUtil.isNotBlank((CharSequence)billInfoEo.getInvoiceRemarks()) ? billInfoEo.getInvoiceRemarks() + "," : billInfoEo.getInvoiceRemarks();
            String string = joinRemarks = list.size() > 1 && StrUtil.isBlank((CharSequence)((BillApplyEo)list.get(0)).getRemark()) ? ((BillApplyEo)list.get(1)).getRemark() : ((BillApplyEo)list.get(0)).getRemark();
            if (StrUtil.isNotBlank((CharSequence)joinRemarks)) {
                billInfoEo.setInvoiceRemarks(String.format("%s%s", str, joinRemarks));
            }
            billInfoEo.setFileUrl(((BillApplyEo)list.get(0)).getFileUrl());
        }
    }

    public void addBillOrderItem(List<PerformOrderItemDto> saleOrderItemExtRespDtoList, BillInfoEo billInfoEo, Map<String, ItemSkuDgDto> skuCodeMap, BillStrategyRespDto billStrategyRespDto) {
        this.addBillOrderItem(saleOrderItemExtRespDtoList, billInfoEo, skuCodeMap, billStrategyRespDto, true);
    }

    public void addBillOrderItem(List<PerformOrderItemDto> saleOrderItemExtRespDtoList, BillInfoEo billInfoEo, Map<String, ItemSkuDgDto> skuCodeMap, BillStrategyRespDto billStrategyRespDto, boolean addOrUpdate) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderItemExtRespDtoList)) {
            List platformOrderInfos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).list();
            ArrayList billOrderItemEoList = new ArrayList();
            saleOrderItemExtRespDtoList.forEach(itemDto -> {
                BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
                billOrderItemEo.setGift(itemDto.getGift());
                if (3 == itemDto.getGift()) {
                    billOrderItemEo.setGift(Integer.valueOf(0));
                    billOrderItemEo.setFreightCost(Integer.valueOf(1));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformOrderInfos)) {
                    PerformOrderInfoEo platformOrderInfo = (PerformOrderInfoEo)platformOrderInfos.get(0);
                    billOrderItemEo.setOrderType(platformOrderInfo.getOrderType());
                }
                billOrderItemEo.setItemId(itemDto.getSkuId());
                billOrderItemEo.setItemCode(itemDto.getSkuCode());
                billOrderItemEo.setItemName(itemDto.getSkuName());
                billOrderItemEo.setQuantity(itemDto.getItemNum());
                billOrderItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = itemDto.getRealPayAmount();
                BigDecimal refundedPayAmount = itemDto.getRefundedPayAmount();
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billOrderItemEo.setAmount(amount);
                billOrderItemEo.setClinchDealAmount(amount);
                billOrderItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                if (skuCodeMap.containsKey(itemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(itemDto.getSkuCode());
                    billOrderItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billOrderItemEo.setThirdCode(itemSkuDgDto.getThirdCode());
                    billOrderItemEo.setEnergyEfficiencyRating(itemSkuDgDto.getEnergyEfficiencyRating());
                    billOrderItemEo.setSpecialInvoiceRemark(itemSkuDgDto.getSpecialInvoiceRemark());
                    this.assembleBillOrderItemInfo((PerformOrderItemDto)itemDto, itemSkuDgDto, billStrategyRespDto, billOrderItemEo);
                }
                billOrderItemEo.setUnitPrice(itemDto.getSalePrice());
                billOrderItemEo.setUnit(itemDto.getBasicUnit());
                billOrderItemEo.setOrderItemId(itemDto.getId());
                billOrderItemEo.setGroupItemName(itemDto.getGroupItemName());
                billOrderItemEo.setGroupSkuCode(itemDto.getGroupSkuCode());
                billOrderItemEo.setPlatformItemCode(itemDto.getPlatformItemCode());
                billOrderItemEo.setPlatformItemName(itemDto.getPlatformItemName());
                billOrderItemEo.setRefundedItemNum(itemDto.getRefundedItemNum());
                billOrderItemEo.setRefundedPayAmount(itemDto.getRefundedPayAmount());
                billOrderItemEo.setSurplusCanRefundPayAmount(itemDto.getSurplusCanRefundPayAmount());
                if (Objects.isNull(billOrderItemEo.getTaxClassificationCode())) {
                    billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
                }
                if (Objects.isNull(billOrderItemEo.getTaxRate())) {
                    billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate());
                }
                this.setSpecialRateBillOrderItem(billInfoEo, billOrderItemEo);
                billOrderItemEoList.add(billOrderItemEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billOrderItemEoList) && addOrUpdate) {
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
        }
    }

    private void itemGiftGenerate(List<BillItemReqDto> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        ArrayList itemGiftList = Lists.newArrayList();
        for (BillItemReqDto orderItem : itemList) {
            BigDecimal salePrice;
            if (!Objects.equals(1, orderItem.getGift()) || BigDecimalUtils.gtZero((BigDecimal)orderItem.getAmount()).booleanValue() || BigDecimalUtils.leZero((BigDecimal)(salePrice = orderItem.getUnitPrice())).booleanValue()) continue;
            orderItem.setAmount(salePrice);
            BillItemReqDto itemGiftSalePrice = (BillItemReqDto)BeanUtil.copyProperties((Object)orderItem, BillItemReqDto.class, (String[])new String[0]);
            itemGiftSalePrice.setAmount(salePrice.negate());
            itemGiftList.add(itemGiftSalePrice);
        }
        if (CollUtil.isNotEmpty((Collection)itemGiftList)) {
            logger.info("\u751f\u6210\u8d60\u54c1\u8d1f\u6570\u884c\uff1a{}", (Object)JSON.toJSONString((Object)itemGiftList));
            itemList.addAll(itemGiftList);
        }
    }

    private void itemGiftGenerateEo(List<BillItemEo> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        ArrayList itemGiftList = Lists.newArrayList();
        for (BillItemEo orderItem : itemList) {
            BigDecimal salePrice;
            if (!Objects.equals(1, orderItem.getGift()) || BigDecimalUtils.gtZero((BigDecimal)orderItem.getAmount()).booleanValue() || BigDecimalUtils.leZero((BigDecimal)(salePrice = orderItem.getUnitPrice())).booleanValue()) continue;
            orderItem.setAmount(salePrice.multiply(orderItem.getQuantity()));
            BillItemEo itemGiftSalePrice = (BillItemEo)BeanUtil.copyProperties((Object)orderItem, BillItemEo.class, (String[])new String[0]);
            itemGiftSalePrice.setAmount(orderItem.getAmount().negate());
            itemGiftList.add(itemGiftSalePrice);
        }
        if (CollUtil.isNotEmpty((Collection)itemGiftList)) {
            logger.info("\u751f\u6210\u8d60\u54c1\u8d1f\u6570\u884c\uff1a{}", (Object)JSON.toJSONString((Object)itemGiftList));
            itemList.addAll(itemGiftList);
        }
    }

    public void freightInvoice(List<PerformOrderItemDto> itemList, BillStrategyRespDto billStrategyRespDto, List<PerformOrderInfoDto> performOrderInfoDtoList) {
        if ("1".equals(billStrategyRespDto.getBillFreight())) {
            performOrderInfoDtoList.forEach(infoDto -> {
                if (Objects.nonNull(infoDto.getFreightCost()) && BigDecimal.ZERO.compareTo(infoDto.getFreightCost()) < 0) {
                    if (BillStrategyOrderPointEnum.DELIVER.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
                        logger.info("\u53d1\u8d27\u8282\u70b9\u8fd0\u8d39\u5927\u4e8e\u96f6\u65b0\u589e\u8fd0\u8d39\u5f00\u7968");
                        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                            ArrayList<String> skuCode = new ArrayList<String>();
                            skuCode.add(billStrategyRespDto.getFreightCostItemCode());
                            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
                                ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
                                PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
                                performOrderItemDto.setGift(Integer.valueOf(0));
                                performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
                                performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
                                performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
                                performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
                                performOrderItemDto.setSkuId(itemSkuDgDto.getId());
                                performOrderItemDto.setSkuName(itemSkuDgDto.getName());
                                performOrderItemDto.setItemNum(BigDecimal.ONE);
                                performOrderItemDto.setIsFreightCost(Integer.valueOf(1));
                                performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
                                performOrderItemDto.setSurplusCanRefundPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setSalePrice(infoDto.getFreightCost());
                                performOrderItemDto.setRealPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setCalcUnit(itemSkuDgDto.getPriceUnit());
                                performOrderItemDto.setSaleUnitName(itemSkuDgDto.getSaleUnitName());
                                itemList.add(performOrderItemDto);
                                logger.info("\u53d1\u8d27\u8282\u70b9\u8fd0\u8d39\u751f\u6210\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
                            }
                        } else {
                            logger.info("\u8fd0\u8d39\u9009\u62e9\u7684\u5f00\u7968\u5546\u54c1\u4e3a\u7a7a");
                        }
                    } else if (BillStrategyOrderPointEnum.COMPLETE.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
                        logger.info("\u5b8c\u6210\u8282\u70b9\u8fd0\u8d39\u5927\u4e8e\u96f6\u65b0\u589e\u8fd0\u8d39\u5f00\u7968");
                        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                            ArrayList<String> skuCode = new ArrayList<String>();
                            skuCode.add(billStrategyRespDto.getFreightCostItemCode());
                            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
                                ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
                                PerformOrderItemDto performOrderItemDto = new PerformOrderItemDto();
                                performOrderItemDto.setGift(Integer.valueOf(0));
                                performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
                                performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
                                performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
                                performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
                                performOrderItemDto.setSkuId(itemSkuDgDto.getId());
                                performOrderItemDto.setSkuName(itemSkuDgDto.getName());
                                performOrderItemDto.setItemNum(BigDecimal.ONE);
                                performOrderItemDto.setIsFreightCost(Integer.valueOf(1));
                                performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
                                performOrderItemDto.setSurplusCanRefundPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setSalePrice(infoDto.getFreightCost());
                                performOrderItemDto.setRealPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setPayAmount(infoDto.getFreightCost());
                                itemList.add(performOrderItemDto);
                                logger.info("\u5b8c\u6210\u8282\u70b9\u8fd0\u8d39\u751f\u6210\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
                            }
                        } else {
                            logger.info("\u8fd0\u8d39\u9009\u62e9\u7684\u5f00\u7968\u5546\u54c1\u4e3a\u7a7a");
                        }
                    }
                } else {
                    logger.info("\u8ba2\u5355\u884c\u8fd0\u8d39\u4e3a\u7a7a\u6216\u8005\u4e0d\u5927\u4e8e0\u8fd0\u8d39\u4e0d\u9700\u8981\u5f00\u7968\uff1a{}", (Object)infoDto.getFreightCost());
                }
            });
        } else {
            logger.info("\u6839\u636e\u7b56\u7565\u8fd0\u8d39\u4e0d\u9700\u8981\u5f00\u7968\uff1a{}", (Object)billStrategyRespDto.getBillFreight());
        }
    }

    public void cancelBillInfo(BillInfoEo info) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setId(info.getId());
        billInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        logger.info("\u66f4\u65b0\u7ed1\u5b9a\u7684\u7ea2\u7968:{}", (Object)info.getAgainBillRedBillFlowNo());
        if (StringUtils.isNotBlank((CharSequence)info.getAgainBillRedBillFlowNo())) {
            BillInfoEo one;
            BillInfoEo infoEo = (BillInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)info.getAgainBillRedBillFlowNo())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.WAIT_AUDIT.getCode())).one();
            logger.info("\u66f4\u65b0\u7ed1\u5b9a\u7684\u7ea2\u7968:{},{}", (Object)info.getAgainBillRedBillFlowNo(), (Object)JSONObject.toJSONString((Object)infoEo));
            if (Objects.nonNull(infoEo) && (one = (BillInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)infoEo.getBlueTicketFlowNo())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.RED_FLUSH.getCode())).one()) != null) {
                logger.info("\u7ea2\u7968 {} \u5bf9\u5e94\u84dd\u7968 {} \u5df2\u7ea2\u51b2\uff0c\u53d6\u6d88\u5f53\u524d\u7ea2\u7968", (Object)infoEo.getBillFlowNo(), (Object)one.getBillFlowNo());
                BillInfoEo redBillInfoEo = new BillInfoEo();
                redBillInfoEo.setId(infoEo.getId());
                redBillInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
                this.billInfoDas.updateSelective((BaseEo)redBillInfoEo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto addOrderInvoice(List<String> billFlowNoList) {
        this.kingdeeInvoiceHandle(billFlowNoList);
        return new BatchOperationRespDto();
    }

    public BatchOperationRespDto kingdeeInvoiceHandle(List<String> billFlowNoList) {
        logger.info("\u5f00\u7968\u4fe1\u606f\u5f00\u7968-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        ArrayList errorList = new ArrayList();
        ArrayList successList = new ArrayList();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        Map billMap = billInfoList.stream().collect(Collectors.toMap(BillInfoEo::getBillFlowNo, Function.identity(), (v1, v2) -> v1));
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        Map<String, List<BillItemEo>> billItemMap = billItemList.stream().collect(Collectors.groupingBy(BillItemEo::getBillFlowNo));
        logger.info("billMap:{}", (Object)JSONObject.toJSONString(billMap));
        logger.info("billItemMap:{}", (Object)JSONObject.toJSONString(billItemMap));
        billMap.forEach((billNo, billInfo) -> {
            boolean flag = true;
            if (!InvoiceStateEnum.WAIT_BILL.getCode().equals(billInfo.getInvoiceState()) && !InvoiceStateEnum.FAILED.getCode().equals(billInfo.getInvoiceState())) {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7:%s\u72b6\u6001[%s]\u4e0d\u80fd\u5f00\u7968", billNo, InvoiceStateEnum.getNameByCode((String)billInfo.getInvoiceState())));
                flag = false;
            } else if (StringUtils.isNotBlank((CharSequence)billInfo.getBillType()) && BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfo.getBillType())) {
                RestResponse response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto((BillInfoEo)billInfo, (List)billItemMap.get(billNo), 1));
                logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, billInfo.getId()));
                if (!response.isSuccess() || !"0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode())) {
                    errorList.add(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
                    flag = false;
                }
            } else if (StringUtils.isNotBlank((CharSequence)billInfo.getBillType()) && BillInfoColourTypeEnum.RED_TICKET.getCode().equals(billInfo.getBillType())) {
                RestResponse response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto((BillInfoEo)billInfo, (List)billItemMap.get(billNo), 2));
                logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, billInfo.getId()));
                if (!response.isSuccess() || !"0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode())) {
                    errorList.add(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
                    flag = false;
                }
            }
            if (flag) {
                successList.add(billNo);
            }
        });
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        return batchOperationRespDto;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public void redInvoiceUpdate(BillInfoEo billInfo) {
        List billInfoEoList;
        BillInfoEo cancelBillInfoEo = new BillInfoEo();
        cancelBillInfoEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
        cancelBillInfoEo.setId(billInfo.getId());
        this.billInfoDas.updateSelective((BaseEo)cancelBillInfoEo);
        if (StringUtils.isNotBlank((CharSequence)billInfo.getBlueTicketFlowNo()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billInfo.getBlueTicketFlowNo())).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).list()))) {
            BillInfoEo billInfoEo = (BillInfoEo)billInfoEoList.get(0);
            BillInfoEo updateEo = new BillInfoEo();
            updateEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
            UpdateWrapper eoUpdateWrapper = new UpdateWrapper();
            eoUpdateWrapper.eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo());
            this.billInfoMapper.update((Object)updateEo, (Wrapper)eoUpdateWrapper);
        }
        this.redOrderBillInfo(billInfo, false);
    }

    @Transactional(rollbackFor={Exception.class})
    public void againRedInvoiceUpdate(BillInfoEo billInfo) {
        logger.info("againRedInvoiceUpdate:{}", (Object)JSONObject.toJSONString((Object)billInfo));
        this.redInvoiceUpdate(billInfo);
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(billInfo.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        List applyColourType = billStrategyRespDto.getApplyColourType();
        boolean containsBillType = BillInfoColourTypeEnum.containsBillType((List)applyColourType, (String)BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        logger.info("\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {} {} ", (Object)billInfo.getPlatformOrderNo(), (Object)containsBillType);
        logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfo));
        HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
        logger.info("objs======\uff1a{}", (Object)JSON.toJSONString(objs));
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        if (1 == (null != billInfo.getSubsidiesType() ? billInfo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
            if (containsBillType) {
                CompletableFuture.runAsync(() -> {
                    BillInfoServiceImpl.setAttachmentAsync(objs);
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    this.batchAuditBillByPlatform(Lists.newArrayList((Object[])new String[]{billInfo.getPlatformOrderNo()}));
                });
            }
        } else if (0 == (null != billInfo.getSubsidiesType() ? billInfo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement") && containsBillType) {
            CompletableFuture.runAsync(() -> {
                BillInfoServiceImpl.setAttachmentAsync(objs);
                MDC.put((String)"yes.req.requestId", (String)reqId);
                this.batchAuditBillByPlatform(Lists.newArrayList((Object[])new String[]{billInfo.getPlatformOrderNo()}));
            });
        }
        this.autoReissueWhenNoBlueTicket(billInfo.getPlatformOrderNo());
    }

    private void autoReissueWhenNoBlueTicket(String platformOrderNo) {
        boolean exists = this.billInfoDas.existsNotRedFlushBlueTicket(platformOrderNo);
        if (exists) {
            return;
        }
        String reqId = StrUtil.isNotBlank((CharSequence)ServiceContext.getContext().getRequestId()) ? ServiceContext.getContext().getRequestId() : RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        logger.info("\u5e73\u53f0\u5355\u53f7\uff1a{} \u7ea2\u51b2\u5b8c\u6210\u5e76\u4e14\u65e0\u672a\u7ea2\u51b2\u7684\u84dd\u7968\uff0c\u81ea\u52a8\u89e6\u53d1\u8865\u5f00", (Object)platformOrderNo);
        ReissueBillDto dto = new ReissueBillDto();
        dto.setPlatformOrderNo(platformOrderNo);
        dto.setReqId(reqId);
        dto.setApplyPerson("\u7cfb\u7edf");
        this.sendReissueMQ(dto);
    }

    private static void setAttachmentAsync(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ServiceContext.getContext().setAttachment(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void updateOrderBillInfo(BillInfoEo billInfoEo, String status) {
        logger.info("\u5f00\u7968\u6210\u529f\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        if (StringUtils.isBlank((CharSequence)billInfoEo.getPlatformOrderNo())) {
            logger.info("\u672a\u5173\u8054\u8ba2\u5355\u4e0d\u9700\u8981\u540c\u6b65\u8ba2\u5355\u5f00\u7968\u72b6\u6001\uff1a{}", (Object)billInfoEo.getBillFlowNo());
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)billInfoEo.getSaleOrderNo()) || billInfoEo.getPlatformOrderNo().equals(billInfoEo.getSaleOrderNo())) {
                    List list;
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    List<String> platformOrderNoList = Arrays.asList(billInfoEo.getPlatformOrderNo().split(","));
                    if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoEo.getWhetherMergeBill()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).eq((Object)"type", (Object)"order")).list()))) {
                        platformOrderNoList = list.stream().map(BillOrderItemEo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                    }
                    saleOrderBillRecordQueryReqDto.setPlatformOrderNoList(platformOrderNoList);
                    List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    Map map = ((List)Optional.ofNullable(saleOrderBillRecordRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(SaleOrderBillRecordDto::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
                    PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
                    performOrderInfoPageReqDto.setPlatformOrderNoList(platformOrderNoList);
                    performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
                    List<PerformOrderInfoDto> performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
                    performOrderInfoDtoList.forEach(order -> {
                        if (map.containsKey(order.getSaleOrderNo())) {
                            SaleOrderBillRecordDto saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)map.get(order.getSaleOrderNo());
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(saleOrderBillRecordRespDto.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(status);
                            saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
                            saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                            saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
                            saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        } else {
                            this.addOrderBillInfo(billInfoEo, status, (PerformOrderInfoDto)order);
                        }
                    });
                } else {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordRespDtoList)) {
                        saleOrderBillRecordRespDtoList.forEach(order -> {
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(order.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(status);
                            saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
                            saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
                            saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                            saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        });
                    } else {
                        PerformOrderInfoDto saleOrderRespDto = new PerformOrderInfoDto();
                        saleOrderRespDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                        saleOrderRespDto.setParentOrderNo(billInfoEo.getPlatformOrderNo());
                        this.addOrderBillInfo(billInfoEo, status, saleOrderRespDto);
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u5f00\u7968\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    public void addOrderBillInfo(BillInfoEo billInfoEo, String status, PerformOrderInfoDto order) {
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
        saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
        saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
        saleOrderBillRecordReqDto.setInvoiceType(billInfoEo.getInvoiceType());
        saleOrderBillRecordReqDto.setTitleType(billInfoEo.getTitleType());
        saleOrderBillRecordReqDto.setBillTitle(billInfoEo.getBillTitle());
        saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
        saleOrderBillRecordReqDto.setEntityId(billInfoEo.getEntityId());
        saleOrderBillRecordReqDto.setWhetherInvoice(status);
        saleOrderBillRecordReqDto.setTaxesCode(billInfoEo.getTaxesCode());
        saleOrderBillRecordReqDto.setRegisteredAddress(billInfoEo.getRegisteredAddress());
        saleOrderBillRecordReqDto.setRegisteredPhone(billInfoEo.getRegisteredPhone());
        saleOrderBillRecordReqDto.setBankAccount(billInfoEo.getBankAccount());
        saleOrderBillRecordReqDto.setBank(billInfoEo.getBank());
        saleOrderBillRecordReqDto.setBillPersonName(billInfoEo.getBillPersonName());
        saleOrderBillRecordReqDto.setBillPersonPhone(billInfoEo.getBillPersonPhone());
        saleOrderBillRecordReqDto.setBillAddress(billInfoEo.getBillAddress());
        saleOrderBillRecordReqDto.setDistributorBank(billInfoEo.getDistributorBank());
        saleOrderBillRecordReqDto.setDistributorBankAccount(billInfoEo.getDistributorBankAccount());
        saleOrderBillRecordReqDto.setDistributorRegisteredAddress(billInfoEo.getDistributorRegisteredAddress());
        saleOrderBillRecordReqDto.setDistributorRegisteredPhone(billInfoEo.getDistributorRegisteredPhone());
        saleOrderBillRecordReqDto.setDistributorTaxesCode(billInfoEo.getDistributorTaxesCode());
        saleOrderBillRecordReqDto.setCollectPerson(billInfoEo.getCollectPerson());
        saleOrderBillRecordReqDto.setReviewPerson(billInfoEo.getReviewPerson());
        saleOrderBillRecordReqDto.setBillPerson(billInfoEo.getBillPerson());
        saleOrderBillRecordReqDto.setBillChannel(billInfoEo.getBillChannel());
        saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        saleOrderBillRecordReqDto.setMailbox(billInfoEo.getMailbox());
        saleOrderBillRecordReqDto.setPhone(billInfoEo.getPhone());
        this.saleOrderBillRecordApiProxy.addSaleOrderBillRecord(saleOrderBillRecordReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto redOrderInvoice(List<String> billFlowNoList) {
        logger.info("\u5f00\u7968\u4fe1\u606f\u7ea2\u51b2-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        List billOrderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        Map<String, List<BillOrderItemEo>> billOrderItemMap = ((List)Optional.ofNullable(billOrderItemList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BillOrderItemEo::getBillFlowNo));
        Map<String, List<BillItemEo>> billItemMap = ((List)Optional.ofNullable(billItemList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BillItemEo::getBillFlowNo));
        List redBillInfoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"blue_ticket_flow_no", billFlowNoList)).ne((Object)"invoice_state", (Object)InvoiceStateEnum.CANCELLED.getCode())).list();
        Map<String, List<BillInfoEo>> listMap = ((List)Optional.ofNullable(redBillInfoList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BillInfoEo::getBlueTicketFlowNo));
        ArrayList errorList = new ArrayList();
        ArrayList successList = new ArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoList)) {
            billInfoList.forEach(info -> {
                boolean flag = true;
                if (InvoiceStateEnum.BILLED.getCode().equals(info.getInvoiceState()) && BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(info.getBillType())) {
                    if (!listMap.containsKey(info.getBillFlowNo())) {
                        flag = this.redKingdeeInvoice((BillInfoEo)info, billItemMap, billOrderItemMap, errorList);
                    } else {
                        logger.info("\u8be5\u84dd\u7968\u5b58\u5728\u7ea2\u7968\u4e0d\u9700\u8981\u518d\u6b21\u751f\u6210\u7ea2\u7968:{}", (Object)info.getBillFlowNo());
                    }
                } else {
                    errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s:\u5df2\u5f00\u7968\u72b6\u6001\u7684\u84dd\u7968\u624d\u5141\u8bb8\u7ea2\u51b2", info.getBillFlowNo()));
                    flag = false;
                }
                logger.info("\u53d1\u7968\u662f\u5426\u7ea2\u51b2flag:{}\uff0c{},{}", new Object[]{info.getBillFlowNo(), info.getPlatformOrderNo(), flag});
                if (flag) {
                    logger.info("info.getBillFlowNo:{}", (Object)info.getBillFlowNo());
                    successList.add(info.getBillFlowNo());
                    if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(info.getBillType())) {
                        List billInfoEos1 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", new Object[]{info.getPlatformOrderNo()})).in((Object)"invoice_state", Arrays.asList(InvoiceStateEnum.INVOICING.getCode(), InvoiceStateEnum.WAIT_AUDIT.getCode()))).eq((Object)"bill_type", (Object)"red_ticket")).list();
                        logger.info("\u6821\u9a8c\u5982\u679c\u5b58\u5728\u7ea2\u7968\u72b6\u6001\u4e3a\u672a\u5f00\u7968\u65f6:{}", (Object)JSONObject.toJSONString((Object)billInfoEos1));
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos1)) {
                            logger.info("\u5b58\u5728\u5f00\u7968\u4e2d\u7684\u7ea2\u7968\uff0c\u4e0d\u8fdb\u884c\u7ea2\u51b2\u84dd\u7968:{},{},{}", new Object[]{info.getPlatformOrderNo(), info.getBillFlowNo(), info.getBillType()});
                        } else {
                            BillInfoEo updateEo = new BillInfoEo();
                            updateEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
                            UpdateWrapper eoUpdateWrapper = new UpdateWrapper();
                            eoUpdateWrapper.eq((Object)"id", (Object)info.getId());
                            logger.info("\u7ea2\u51b2\u53d1\u7968billFlowNo:{},{},{}", new Object[]{info.getBillFlowNo(), info.getPlatformOrderNo(), JSONObject.toJSONString((Object)updateEo)});
                            this.billInfoMapper.update((Object)updateEo, (Wrapper)eoUpdateWrapper);
                        }
                    } else {
                        BillInfoEo updateEo = new BillInfoEo();
                        updateEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
                        UpdateWrapper eoUpdateWrapper = new UpdateWrapper();
                        eoUpdateWrapper.eq((Object)"id", (Object)info.getId());
                        logger.info("updateEo:{},{},{}", new Object[]{info.getBillFlowNo(), info.getPlatformOrderNo(), JSONObject.toJSONString((Object)updateEo)});
                        this.billInfoMapper.update((Object)updateEo, (Wrapper)eoUpdateWrapper);
                    }
                }
            });
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        return batchOperationRespDto;
    }

    public RedOrderInvoiceAgainBillRespDto redOrderInvoiceAgainBill(BillInfoEo redBillInfoEo, BillInfoEo newBillInfoEo) {
        RedOrderInvoiceAgainBillRespDto respDto = new RedOrderInvoiceAgainBillRespDto();
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().eq((Object)"bill_flow_no", (Object)redBillInfoEo.getBillFlowNo())).list();
        List billOrderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)redBillInfoEo.getBillFlowNo())).list();
        String code = this.copyGenerateRedBill(redBillInfoEo, billItemList, billOrderItemList, newBillInfoEo);
        respDto.setReopenIsBill(Boolean.valueOf(false));
        respDto.setRedBillFlowNo(code);
        return respDto;
    }

    public String copyGenerateRedBill(BillInfoEo info, List<BillItemEo> billItemList, List<BillOrderItemEo> billOrderItemList, BillInfoEo newBillInfoEo) {
        List billInfoEoList;
        String code = this.generateCodeDataUtils.generateNo("KP");
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(info.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        List applyColourType = billStrategyRespDto.getApplyColourType();
        boolean containsBillType = BillInfoColourTypeEnum.containsBillType((List)applyColourType, (String)BillInfoColourTypeEnum.RED_TICKET.getCode());
        logger.info("\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {}{} ", (Object)code, (Object)containsBillType);
        logger.info("\u9002\u7528\u56fd\u8865\u914d\u7f6e:{},{} ", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)info));
        BillInfoEo addRedBill = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)addRedBill, (Object)info, (String[])new String[]{"id,extension,createTime,uploadPdfUrl"});
        addRedBill.setId(null);
        addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        if (containsBillType) {
            if (1 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            } else if (0 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            }
        }
        addRedBill.setBillFlowNo(code);
        addRedBill.setBlueTicketFlowNo(info.getBillFlowNo());
        addRedBill.setBlueTicketInvoiceCode(info.getExternalInvoiceCode());
        addRedBill.setBlueTicketInvoiceNo(info.getExternalInvoiceNo());
        addRedBill.setBillType(BillInfoColourTypeEnum.RED_TICKET.getCode());
        addRedBill.setUploadPdfUrl(null);
        addRedBill.setExtension(null);
        addRedBill.setCreateTime(new Date());
        addRedBill.setUpdateTime(new Date());
        addRedBill.setInvoiceUrl(null);
        addRedBill.setExternalInvoiceTime(null);
        addRedBill.setExternalInvoiceCode(null);
        addRedBill.setExternalInvoiceNo(null);
        addRedBill.setInvoiceConnectUrl(null);
        addRedBill.setAuditTime(null);
        addRedBill.setAuditPerson(null);
        addRedBill.setInvoiceState(newBillInfoEo.getInvoiceState());
        addRedBill.setAllRedFlag(AllRedFlagEnum.YES_ALL_RED_FLAG.getCode());
        addRedBill.setPushPlatformState("");
        addRedBill.setPushPlatformError("");
        if ((BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(addRedBill.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(addRedBill.getInvoiceType())) && this.isInCurrentMonth(addRedBill.getExternalInvoiceTime())) {
            addRedBill.setBillType(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        }
        logger.info("copyGenerateRedBilladdRedBill==>{}", (Object)JSON.toJSONString((Object)addRedBill));
        if (BillInfoColourTypeEnum.RED_TICKET.getCode().equals(addRedBill.getBillType()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)addRedBill.getPlatformOrderNo())).eq((Object)"blue_ticket_invoice_no", (Object)addRedBill.getBlueTicketInvoiceNo())).in((Object)"invoice_state", Arrays.asList(InvoiceStateEnum.WAIT_AUDIT.getCode(), InvoiceStateEnum.BILLED.getCode(), InvoiceStateEnum.INVOICING.getCode(), InvoiceStateEnum.WAIT_BILL.getCode(), InvoiceStateEnum.FAILED.getCode()))).list()))) {
            logger.info("\u5b58\u5728\u5f85\u5ba1\u6838\uff0c\u5df2\u5f00\u7968\uff0c\u5f00\u7968\u4e2d\uff0c\u5f85\u5f00\u7968\uff0c\u5f00\u7968\u5931\u8d25\u7684\u7ea2\u7968\uff0c\u4e0d\u751f\u6210\u7ea2\u7968\uff1a{},{}", (Object)addRedBill.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
            return ((BillInfoEo)billInfoEoList.get(0)).getBillFlowNo();
        }
        this.billInfoDas.insert((BaseEo)addRedBill);
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(addRedBill.getPlatformOrderNo().split(",")), code, RelBusinessTypeEnum.INVOICE.getCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItemList)) {
            billItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billItemDas.insertBatch(billItemList);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billOrderItemList)) {
            billOrderItemList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billOrderItemDas.insertBatch(billOrderItemList);
        }
        Boolean isSucceed = false;
        if (containsBillType) {
            if (1 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                isSucceed = this.sendInvoiceIsReopen(addRedBill, billItemList, 2);
            } else if (0 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                isSucceed = this.sendInvoiceIsReopen(addRedBill, billItemList, 2);
            }
        }
        if (!isSucceed.booleanValue()) {
            this.updateOrderBillInfo(info, SaleOrderInvoiceStateEnum.WAIT_RED.getCode());
        } else {
            BillInfoEo billInfoEo = new BillInfoEo();
            billInfoEo.setId(info.getId());
            billInfoEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
        }
        return code;
    }

    public Boolean redKingdeeInvoice(BillInfoEo info, Map<String, List<BillItemEo>> billItemMap, Map<String, List<BillOrderItemEo>> billOrderItemMap, List<String> errorList) {
        Boolean flag = true;
        BillInfoEo addRedBill = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)addRedBill, (Object)info, (String[])new String[]{"id,extension,createTime,uploadPdfUrl"});
        addRedBill.setId(null);
        String code = this.generateCodeDataUtils.generateNo("KP");
        addRedBill.setBillFlowNo(code);
        addRedBill.setBlueTicketFlowNo(info.getBillFlowNo());
        addRedBill.setBlueTicketInvoiceCode(info.getExternalInvoiceCode());
        addRedBill.setBlueTicketInvoiceNo(info.getExternalInvoiceNo());
        addRedBill.setUploadPdfUrl(null);
        addRedBill.setExtension(null);
        addRedBill.setCreateTime(new Date());
        addRedBill.setUpdateTime(new Date());
        addRedBill.setInvoiceUrl(null);
        addRedBill.setExternalInvoiceTime(null);
        addRedBill.setExternalInvoiceCode(null);
        addRedBill.setExternalInvoiceNo(null);
        addRedBill.setInvoiceConnectUrl(null);
        addRedBill.setAuditTime(null);
        addRedBill.setAuditPerson(null);
        addRedBill.setAgainBillRedBillFlowNo(null);
        addRedBill.setAllRedFlag(AllRedFlagEnum.YES_ALL_RED_FLAG.getCode());
        addRedBill.setPlatformOrderNo(info.getPlatformOrderNo());
        addRedBill.setBillType(BillInfoColourTypeEnum.RED_TICKET.getCode());
        addRedBill.setPushPlatformState("");
        addRedBill.setPushPlatformError("");
        addRedBill.setSubsidiesType(info.getSubsidiesType());
        if ((BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(info.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(info.getInvoiceType())) && this.isInCurrentMonth(info.getExternalInvoiceTime())) {
            addRedBill.setBillType(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        }
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(info.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        List applyColourType = billStrategyRespDto.getApplyColourType();
        logger.info("applyColourType:{}", (Object)applyColourType);
        boolean containsBillType = BillInfoColourTypeEnum.containsBillType((List)applyColourType, (String)addRedBill.getBillType());
        logger.info("\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {} {} {} ", new Object[]{addRedBill.getBillFlowNo(), addRedBill.getBillType(), containsBillType});
        addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        if (containsBillType) {
            addRedBill.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
        }
        logger.info("\u6dfb\u52a0\u7ea2\u7968addRedBill:{}", (Object)JSONObject.toJSONString((Object)addRedBill));
        if (containsBillType) {
            RestResponse response;
            List<String> platformOrderNoList = new ArrayList<String>();
            if (Objects.nonNull(addRedBill.getPlatformOrderNo())) {
                platformOrderNoList = Arrays.asList(addRedBill.getPlatformOrderNo().split(","));
            }
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, code, RelBusinessTypeEnum.INVOICE.getCode());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billItemMap.get(info.getBillFlowNo()))) {
                billItemMap.get(info.getBillFlowNo()).forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(code);
                });
                this.billItemDas.insertBatch(billItemMap.get(info.getBillFlowNo()));
            }
            if (billOrderItemMap.containsKey(info.getBillFlowNo())) {
                List<BillOrderItemEo> billOrderItemEoList = billOrderItemMap.get(info.getBillFlowNo());
                billOrderItemEoList.forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(code);
                });
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
            logger.info("\u7ea2\u7968\u81ea\u52a8\u5ba1\u6838\u7b56\u7565\u4fe1\u606f {} {} {} ", new Object[]{addRedBill.getBillFlowNo(), addRedBill.getBillType(), containsBillType});
            logger.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{},{}", new Object[]{addRedBill.getBillFlowNo(), JSONObject.toJSONString((Object)billStrategyRespDto), JSONObject.toJSONString((Object)addRedBill)});
            if (1 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                addRedBill.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
                logger.info("\u56fd\u8865\u8ba2\u5355\u65b0\u589e\u7ea2\u7968\u4fe1\u606f\uff1a{},{}", (Object)addRedBill.getBillFlowNo(), (Object)JSONObject.toJSONString((Object)addRedBill));
                this.billInfoDas.insert((BaseEo)addRedBill);
                response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto(addRedBill, billItemMap.get(info.getBillFlowNo()), 2));
                logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                flag = response.isSuccess() && "0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode());
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, addRedBill.getId()));
            } else if (0 == (null != addRedBill.getSubsidiesType() ? addRedBill.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                addRedBill.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
                logger.info("\u975e\u56fd\u8865\u8ba2\u5355\u65b0\u589e\u7ea2\u7968\u4fe1\u606f\uff1a{},{}", (Object)addRedBill.getBillFlowNo(), (Object)JSONObject.toJSONString((Object)addRedBill));
                this.billInfoDas.insert((BaseEo)addRedBill);
                response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto(addRedBill, billItemMap.get(info.getBillFlowNo()), 2));
                logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                flag = response.isSuccess() && "0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode());
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, addRedBill.getId()));
            } else {
                addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
                this.billInfoDas.insert((BaseEo)addRedBill);
            }
        } else {
            List<String> platformOrderNoList = new ArrayList<String>();
            if (Objects.nonNull(addRedBill.getPlatformOrderNo())) {
                platformOrderNoList = Arrays.asList(addRedBill.getPlatformOrderNo().split(","));
            }
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, code, RelBusinessTypeEnum.INVOICE.getCode());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billItemMap.get(info.getBillFlowNo()))) {
                billItemMap.get(info.getBillFlowNo()).forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(code);
                });
                this.billItemDas.insertBatch(billItemMap.get(info.getBillFlowNo()));
            }
            if (billOrderItemMap.containsKey(info.getBillFlowNo())) {
                List<BillOrderItemEo> billOrderItemEoList = billOrderItemMap.get(info.getBillFlowNo());
                billOrderItemEoList.forEach(item -> {
                    item.setId(null);
                    item.setBillFlowNo(code);
                });
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
            addRedBill.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            this.billInfoDas.insert((BaseEo)addRedBill);
        }
        return flag;
    }

    private boolean isInCurrentMonth(Date date) {
        int year = DateUtil.year((Date)date);
        int month = DateUtil.month((Date)date);
        int currentYear = DateUtil.year((Date)new Date());
        int currentMonth = DateUtil.month((Date)new Date());
        return currentYear == year && month == currentMonth;
    }

    public boolean compareDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        Calendar calendarNewDate = Calendar.getInstance();
        calendarNewDate.setTime(new Date());
        return calendar.get(2) == calendarNewDate.get(2);
    }

    public Boolean selfLoopRed(BillInfoEo info, Map<String, List<BillItemEo>> billItemMap, List<String> errorList, Map<String, List<BillOrderItemEo>> billOrderItemMap) {
        return true;
    }

    public Boolean selfLoopCancel(BillInfoEo info, Map<String, List<BillItemEo>> billItemMap, List<String> errorList, Map<String, List<BillOrderItemEo>> billOrderItemMap) {
        return true;
    }

    public void redOrderBillInfo(BillInfoEo billInfoEo, boolean flag) {
        logger.info("\u7ea2\u51b2\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\uff1a{},\u5f00\u5173:{}", (Object)JSONObject.toJSONString((Object)billInfoEo), (Object)flag);
        if (StringUtils.isBlank((CharSequence)billInfoEo.getPlatformOrderNo())) {
            logger.info("\u672a\u5173\u8054\u8ba2\u5355\u4e0d\u9700\u8981\u540c\u6b65\u7ea2\u51b2\u72b6\u6001\uff1a{}", (Object)billInfoEo.getBillFlowNo());
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)billInfoEo.getSaleOrderNo()) || billInfoEo.getPlatformOrderNo().equals(billInfoEo.getSaleOrderNo())) {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordDtoList)) {
                        ArrayList<String> queryBillStatus = new ArrayList<String>();
                        queryBillStatus.add(InvoiceStateEnum.WAIT_AUDIT.getCode());
                        queryBillStatus.add(InvoiceStateEnum.WAIT_BILL.getCode());
                        queryBillStatus.add(InvoiceStateEnum.INVOICING.getCode());
                        queryBillStatus.add(InvoiceStateEnum.BILLED.getCode());
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"invoice_state", queryBillStatus)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).list();
                        BigDecimal invoiceAmount = billInfoEo.getInvoiceAmount();
                        String orderInvoiceStatus = SaleOrderInvoiceStateEnum.RED_FLUSH.getCode();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                            BillInfoEo info = (BillInfoEo)list.get(0);
                            invoiceAmount = info.getInvoiceAmount();
                            switch (info.getInvoiceState()) {
                                case "wait_audit": 
                                case "wait_bill": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.WAIT_BILL.getCode();
                                    break;
                                }
                                case "invoicing": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICING.getCode();
                                    break;
                                }
                                case "billed": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICED.getCode();
                                    break;
                                }
                            }
                        }
                        String finalOrderInvoiceStatus = flag ? SaleOrderInvoiceStateEnum.WAIT_CANCEL.getCode() : orderInvoiceStatus;
                        BigDecimal finalInvoiceAmount = invoiceAmount;
                        saleOrderBillRecordDtoList.forEach(order -> {
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(order.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(finalOrderInvoiceStatus);
                            saleOrderBillRecordReqDto.setInvoiceAmount(finalInvoiceAmount);
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        });
                    }
                } else {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordDtoList)) {
                        ArrayList<String> queryBillStatus = new ArrayList<String>();
                        queryBillStatus.add(InvoiceStateEnum.WAIT_AUDIT.getCode());
                        queryBillStatus.add(InvoiceStateEnum.WAIT_BILL.getCode());
                        queryBillStatus.add(InvoiceStateEnum.INVOICING.getCode());
                        queryBillStatus.add(InvoiceStateEnum.BILLED.getCode());
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"sale_order_no", (Object)billInfoEo.getSaleOrderNo())).in((Object)"invoice_state", queryBillStatus)).list();
                        String orderInvoiceStatus = SaleOrderInvoiceStateEnum.RED_FLUSH.getCode();
                        BigDecimal invoiceAmount = billInfoEo.getInvoiceAmount();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                            BillInfoEo info = (BillInfoEo)list.get(0);
                            invoiceAmount = info.getInvoiceAmount();
                            switch (info.getInvoiceState()) {
                                case "wait_audit": 
                                case "wait_bill": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.WAIT_BILL.getCode();
                                    break;
                                }
                                case "invoicing": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICING.getCode();
                                    break;
                                }
                                case "billed": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICED.getCode();
                                    break;
                                }
                            }
                        }
                        String finalOrderInvoiceStatus = flag ? SaleOrderInvoiceStateEnum.WAIT_CANCEL.getCode() : orderInvoiceStatus;
                        Object finalInvoiceAmount = invoiceAmount;
                        saleOrderBillRecordDtoList.forEach(arg_0 -> this.lambda$redOrderBillInfo$169(billInfoEo, finalOrderInvoiceStatus, (BigDecimal)finalInvoiceAmount, arg_0));
                    }
                }
            }
            catch (Exception e) {
                logger.error("\u7ea2\u51b2\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f:{}", (Object)e.getMessage());
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BatchOperationRespDto cancelBillInfo(List<String> billFlowNoList) {
        logger.info("\u5f00\u7968\u4fe1\u606f\u53d6\u6d88-\u8f93\u5165:{}", (Object)JSONObject.toJSONString(billFlowNoList));
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList), "\u5f00\u7968\u6d41\u6c34\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billInfoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        ArrayList errorList = new ArrayList();
        ArrayList successList = new ArrayList();
        billInfoList.forEach(info -> {
            if (InvoiceStateEnum.WAIT_AUDIT.getCode().equals(info.getInvoiceState())) {
                BillInfoEo billInfoEo = new BillInfoEo();
                billInfoEo.setId(info.getId());
                billInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
                this.billInfoDas.updateSelective((BaseEo)billInfoEo);
                successList.add(info.getBillFlowNo());
            } else {
                errorList.add(String.format("\u5f00\u7968\u6d41\u6c34\u53f7%s:\u975e\u5f85\u5ba1\u6838\u7684\u72b6\u6001\u65e0\u6cd5\u53d6\u6d88", info.getBillFlowNo()));
            }
        });
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        return batchOperationRespDto;
    }

    @Override
    public BatchOperationRespDto paperInvoicePrint(List<String> billFlowNoList) {
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        return batchOperationRespDto;
    }

    public ExtQueryChainWrapper<BillInfoEo> assembleCondition(BillInfoQueryDto billInfoQueryDto) {
        ExtQueryChainWrapper filter = this.billInfoDas.filter();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getNotInId())) {
            filter.notIn((Object)"id", (Collection)billInfoQueryDto.getNotInId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceChannel())) {
            filter.eq((Object)"bill_channel", (Object)billInfoQueryDto.getInvoiceChannel());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceHeaderType())) {
            filter.eq((Object)"title_type", (Object)billInfoQueryDto.getInvoiceHeaderType());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getBillFlowNo())) {
            filter.eq((Object)"bill_flow_no", (Object)billInfoQueryDto.getBillFlowNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getBillFlowNoList())) {
            if (billInfoQueryDto.getBillFlowNoList().size() > 1) {
                filter.in((Object)"bill_flow_no", (Collection)billInfoQueryDto.getBillFlowNoList());
            } else {
                filter.like((Object)"bill_flow_no", billInfoQueryDto.getBillFlowNoList().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getApplyNo())) {
            filter.eq((Object)"apply_no", (Object)billInfoQueryDto.getApplyNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getEntityCode())) {
            filter.eq((Object)"entity_code", (Object)billInfoQueryDto.getEntityCode());
        }
        if (Objects.nonNull(billInfoQueryDto.getEntityId())) {
            filter.eq((Object)"entity_id", (Object)billInfoQueryDto.getEntityId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getPlatformOrderNo())) {
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"platform_order_no", (Object)billInfoQueryDto.getPlatformOrderNo())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                filter.eq((Object)"platform_order_no", (Object)billInfoQueryDto.getPlatformOrderNo());
            } else {
                List billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                filter.in((Object)"bill_flow_no", billFlowNoList);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getPlatformOrderNoList())) {
            ArrayList orderNoList = Lists.newArrayList();
            List orderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"distribution_order_no", (Collection)billInfoQueryDto.getPlatformOrderNoList())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderInfoEos)) {
                List collect = orderInfoEos.stream().map(DgPerformOrderInfoEo::getPlatformOrderNo).distinct().collect(Collectors.toList());
                orderNoList.addAll(collect);
            }
            List list = Lists.newArrayList();
            list = billInfoQueryDto.getPlatformOrderNoList().size() > 1 ? ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().in((Object)"platform_order_no", (Collection)billInfoQueryDto.getPlatformOrderNoList())).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list() : ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().like((Object)"platform_order_no", billInfoQueryDto.getPlatformOrderNoList().get(0))).eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list)) {
                orderNoList.addAll(billInfoQueryDto.getPlatformOrderNoList());
                if (orderNoList.size() > 1) {
                    filter.in((Object)"platform_order_no", (Collection)orderNoList);
                } else {
                    filter.like((Object)"platform_order_no", orderNoList.get(0));
                }
            } else {
                List<String> billFlowNoList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderNoList)) {
                    orderNoList.addAll(orderNoList);
                    StringBuilder sql = new StringBuilder();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
                        sql.append(" ( bill_flow_no in ( ");
                        billFlowNoList.forEach(v -> {
                            sql.append("'" + v + "'");
                            sql.append(",");
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
                        sql.deleteCharAt(sql.length() - 1);
                    }
                    sql.append(" ) OR platform_order_no IN (");
                    orderNoList.forEach(v -> {
                        sql.append("'" + v + "'");
                        sql.append(",");
                    });
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" ) ");
                    sql.append(" ) ");
                    filter.apply(sql.toString(), new Object[0]);
                } else {
                    StringBuilder sql = new StringBuilder();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billFlowNoList)) {
                        sql.append(" ( bill_flow_no in ( ");
                        billFlowNoList.forEach(v -> {
                            sql.append("'" + v + "'");
                            sql.append(",");
                        });
                    }
                    if (StringUtils.isNotBlank((CharSequence)sql.toString())) {
                        sql.deleteCharAt(sql.length() - 1);
                    }
                    sql.append(" ) OR platform_order_no IN (");
                    billInfoQueryDto.getPlatformOrderNoList().forEach(v -> {
                        sql.append("'" + v + "'");
                        sql.append(",");
                    });
                    sql.deleteCharAt(sql.length() - 1);
                    sql.append(" ) ");
                    sql.append(" ) ");
                    filter.apply(sql.toString(), new Object[0]);
                }
            }
        }
        if (Objects.nonNull(billInfoQueryDto.getShopId())) {
            filter.eq((Object)"shop_id", (Object)billInfoQueryDto.getShopId());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getShopCode())) {
            filter.eq((Object)"shop_code", (Object)billInfoQueryDto.getShopCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSaleOrderNo())) {
            filter.eq((Object)"sale_order_no", (Object)billInfoQueryDto.getSaleOrderNo());
        }
        if (Objects.nonNull(billInfoQueryDto.getBillType())) {
            filter.eq((Object)"bill_type", (Object)billInfoQueryDto.getBillType());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getBillTypeList())) {
            filter.in((Object)"bill_type", (Collection)billInfoQueryDto.getBillTypeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceType())) {
            filter.eq((Object)"invoice_type", (Object)billInfoQueryDto.getInvoiceType());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getBlueTicketInvoiceNo())) {
            filter.eq((Object)"blue_ticket_invoice_no", (Object)billInfoQueryDto.getBlueTicketInvoiceNo());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateBeginTime())) {
            filter.ge((Object)"create_time", (Object)(billInfoQueryDto.getCreateBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCreateEndTime())) {
            filter.le((Object)"create_time", (Object)(billInfoQueryDto.getCreateEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceState())) {
            filter.eq((Object)"invoice_state", (Object)billInfoQueryDto.getInvoiceState());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getInvoiceStateList())) {
            filter.in((Object)"invoice_state", (Collection)billInfoQueryDto.getInvoiceStateList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceBeginTime())) {
            filter.ge((Object)"external_invoice_time", (Object)(billInfoQueryDto.getExternalInvoiceBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceEndTime())) {
            filter.le((Object)"external_invoice_time", (Object)(billInfoQueryDto.getExternalInvoiceEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceNo())) {
            filter.eq((Object)"external_invoice_no", (Object)billInfoQueryDto.getExternalInvoiceNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getExternalInvoiceNoList())) {
            filter.in((Object)"external_invoice_no", (Collection)billInfoQueryDto.getExternalInvoiceNoList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getExternalInvoiceCode())) {
            filter.eq((Object)"external_invoice_code", (Object)billInfoQueryDto.getExternalInvoiceCode());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getExternalInvoiceCodeList())) {
            filter.in((Object)"external_invoice_code", (Collection)billInfoQueryDto.getExternalInvoiceCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSite())) {
            filter.eq((Object)"site", (Object)billInfoQueryDto.getSite());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getSiteCode())) {
            filter.eq((Object)"site_code", (Object)billInfoQueryDto.getSiteCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getFilterSite())) {
            filter.in((Object)"site", (Collection)SiteChannelEnum.getNameByFilterName((String)billInfoQueryDto.getFilterSite()));
        }
        if (null != billInfoQueryDto.getWhetherMergeBill()) {
            filter.eq((Object)"whether_merge_bill", (Object)billInfoQueryDto.getWhetherMergeBill());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getCustomerCode())) {
            filter.eq((Object)"customer_code", (Object)billInfoQueryDto.getCustomerCode());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditBeginTime())) {
            filter.ge((Object)"audit_time", (Object)(billInfoQueryDto.getAuditBeginTime() + " 00:00:00"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getAuditEndTime())) {
            filter.le((Object)"audit_time", (Object)(billInfoQueryDto.getAuditEndTime() + " 23:59:59"));
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getPushPlatformState())) {
            filter.eq((Object)"push_platform_state", (Object)billInfoQueryDto.getPushPlatformState());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getFinanceReceivableNo())) {
            filter.eq((Object)"finance_receivable_no", (Object)billInfoQueryDto.getFinanceReceivableNo());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getSiteCodeList())) {
            filter.in((Object)"site_code", (Collection)billInfoQueryDto.getSiteCodeList());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoQueryDto.getShopCodeList())) {
            filter.in((Object)"shop_code", (Collection)billInfoQueryDto.getShopCodeList());
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoQueryDto.getInvoiceRemarks())) {
            filter.like((Object)"invoice_remarks", (Object)billInfoQueryDto.getInvoiceRemarks());
        }
        filter.eq(billInfoQueryDto.getSubsidiesType() != null, (Object)"subsidies_type", (Object)billInfoQueryDto.getSubsidiesType());
        filter.orderByDesc((Object)"id");
        return filter;
    }

    public List<BillItemReqDto> getOrderItemInfo(List<BillItemEo> billItemEos) {
        ArrayList<BillItemReqDto> manualOrderDetails = new ArrayList<BillItemReqDto>();
        return manualOrderDetails;
    }

    public void getDiscountLine(BillItemEo item, List<BillItemReqDto> manualOrderDetails, Integer dataMark) {
        BillItemReqDto billItemReqDto = new BillItemReqDto();
        manualOrderDetails.add(billItemReqDto);
    }

    public void getBackDiscountLine(BillItemEo item, List<BillItemReqDto> manualOrderDetails, Integer dataMark) {
        BillItemReqDto billItemReqDto = new BillItemReqDto();
        manualOrderDetails.add(billItemReqDto);
    }

    public void checkParameter(BillInfoReqDto billInfoReqDto) {
        if (StringUtils.isNotBlank((CharSequence)billInfoReqDto.getPhone()) && !billInfoReqDto.getPhone().matches("1[3-9]\\d{9}")) {
            throw new BizException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7");
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getInvoiceType()) && null != BillInfoTypeEnum.getEnumByCode((String)billInfoReqDto.getInvoiceType()), "\u53d1\u7968\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getTitleType()) && null != BillTitleTypeEnum.getEnumByCode((String)billInfoReqDto.getTitleType()), "\u53d1\u7968\u62ac\u5934\u7c7b\u578b\u53c2\u6570\u6709\u8bef");
        if (BillTitleTypeEnum.PERSON.getCode().equals(billInfoReqDto.getTitleType())) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getBillTitle()), "\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        } else if (BillTitleTypeEnum.COMPANY.getCode().equals(billInfoReqDto.getTitleType())) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getBillTitle()), "\u5355\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getTaxesCode()), "\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoReqDto.getInvoiceType()) || BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoReqDto.getInvoiceType()) || BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoReqDto.getInvoiceType())) {
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getRegisteredAddress()), "\u6ce8\u518c\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getRegisteredPhone()), "\u6ce8\u518c\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getBank()), "\u5f00\u6237\u94f6\u884c\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getBankAccount()), "\u94f6\u884c\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (billInfoReqDto.getRelOrder().booleanValue()) {
            this.getBillItem(billInfoReqDto);
        } else {
            this.getBillEntity(billInfoReqDto);
        }
    }

    public void getBillItem(BillInfoReqDto billInfoReqDto) {
        List list;
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)billInfoReqDto.getPlatformOrderNo()), "\u5173\u8054\u7684\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNo(billInfoReqDto.getPlatformOrderNo());
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(performOrderInfoDtoList), String.format("\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728:%s", billInfoReqDto.getPlatformOrderNo()));
        PerformOrderInfoDto performOrderInfoDto = new PerformOrderInfoDto();
        List respDtos = performOrderInfoDtoList.stream().filter(x -> Objects.nonNull(x.getFreightCost()) && BigDecimal.ZERO.compareTo(x.getFreightCost()) < 0).collect(Collectors.toList());
        performOrderInfoDto = org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtos) ? (PerformOrderInfoDto)respDtos.get(0) : performOrderInfoDtoList.get(0);
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        if (Objects.isNull(billStrategyRespDto) || null == billStrategyRespDto.getId()) {
            throw new BizException("\u672a\u83b7\u53d6\u5230\u5f00\u7968\u7b56\u7565,\u65b0\u589e\u5931\u8d25\uff01");
        }
        String billOrderPoint = billStrategyRespDto.getBillOrderPoint();
        HashSet<String> orderStatus = new HashSet<String>();
        if (Objects.equals(deliver, billStrategyRespDto.getBillOrderPoint())) {
            orderStatus.add("DELIVERED");
            orderStatus.add("FINISH");
            orderStatus.add("COMPLETE");
            orderStatus.add("RECEIVED");
        } else if (Objects.equals(complete, billStrategyRespDto.getBillOrderPoint())) {
            orderStatus.add("COMPLETE");
            orderStatus.add("FINISH");
        }
        if (BillStrategyOrderPointEnum.KEEP_COMPLETE.equalsCode(billOrderPoint)) {
            logger.info("handleBatchOrder==>\u8fdb\u5165\u5df2\u8bb0\u8d26\u7b56\u7565");
            List list2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.iKeepAccountsDetailDomain.filter().eq((Object)"order_no", (Object)performOrderInfoDto.getSaleOrderNo())).groupBy((Object)"accounting_result")).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list2) || list2.size() > 1) {
                logger.info("\u8bb0\u8d26\u5355\u5b58\u5728\u591a\u4e2a\u72b6\u6001\uff0c\u8fd8\u6ca1\u5b8c\u6210\u8bb0\u8d26");
                AssertUtil.isTrue(false, "\u8bb0\u8d26\u5355\u5b58\u5728\u591a\u4e2a\u72b6\u6001\uff0c\u8fd8\u6ca1\u5b8c\u6210\u8bb0\u8d26");
            }
            if (!((KeepAccountsDetailEo)list2.get(0)).getAccountingResult().equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode())) {
                AssertUtil.isTrue(false, "\u8bb0\u8d26\u5355\u8fd8\u6ca1\u5b8c\u6210\u8bb0\u8d26");
            }
            orderStatus.add("DELIVERED");
            orderStatus.add("FINISH");
            orderStatus.add("COMPLETE");
            orderStatus.add("RECEIVED");
        }
        for (int i = performOrderInfoDtoList.size() - 1; i >= 0; --i) {
            String status = performOrderInfoDtoList.get(i).getOrderStatus();
            if (orderStatus.contains(status)) continue;
            performOrderInfoDtoList.remove(i);
        }
        if (Objects.equals("apply", billStrategyRespDto.getBillObject())) {
            List platformOrderNo = ((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)billInfoReqDto.getPlatformOrderNo())).list();
            AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformOrderNo), "\u5e73\u53f0\u8ba2\u5355\u53f7\u672a\u6709\u5f00\u7968\u7533\u8bf7,\u901a\u8fc7\u5f00\u7968\u7b56\u7565\u7b5b\u9009\u65e0\u53ef\u5f00\u7968\u8ba2\u5355");
        }
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(performOrderInfoDtoList), "\u5e73\u53f0\u8ba2\u5355\u53f7\u901a\u8fc7\u5f00\u7968\u7b56\u7565\u7b5b\u9009\u65e0\u53ef\u5f00\u7968\u8ba2\u5355");
        BillEntityEo entity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
        if (Objects.nonNull(entity)) {
            billInfoReqDto.setEntityId(entity.getId());
            billInfoReqDto.setEnterprise(entity.getEnterprise());
            billInfoReqDto.setEntityCode(entity.getEntityCode());
            billInfoReqDto.setEntityName(entity.getEntityName());
            billInfoReqDto.setDistributorTaxesCode(entity.getTaxesCode());
            billInfoReqDto.setDistributorRegisteredAddress(entity.getRegisteredAddress());
            billInfoReqDto.setDistributorRegisteredPhone(entity.getRegisteredPhone());
            billInfoReqDto.setDistributorBankAccount(entity.getBankAccount());
            billInfoReqDto.setDistributorBank(entity.getBank());
            billInfoReqDto.setCollectPerson(entity.getCollectPerson());
            billInfoReqDto.setBillPerson(entity.getBillPerson());
            billInfoReqDto.setReviewPerson(entity.getReviewPerson());
        }
        billInfoReqDto.setShopId(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
        billInfoReqDto.setShopCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        ShopEo shopOrganizationCode = this.shopService.selectShopByCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
        billInfoReqDto.setOrganizationCode(shopOrganizationCode.getOrganizationCode());
        billInfoReqDto.setShopName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
        billInfoReqDto.setSite(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getSiteName());
        billInfoReqDto.setCustomerCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getHsCustomerCode());
        billInfoReqDto.setCustomerName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getHsCustomerName());
        billInfoReqDto.setBillChannel(billStrategyRespDto.getBillChannel());
        boolean isAudit = BillAuditTypeEnum.AUTO_AUDIT.equalsCode(billStrategyRespDto.getBillAudit());
        billInfoReqDto.setInvoiceState(isAudit ? InvoiceStateEnum.WAIT_BILL.getCode() : InvoiceStateEnum.WAIT_AUDIT.getCode());
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemReqDto> billItemReqDtoList = new ArrayList<BillItemReqDto>();
        ArrayList<PerformOrderInfoDto> performOrderInfoDtos = new ArrayList<PerformOrderInfoDto>();
        performOrderInfoDtos.add(performOrderInfoDto);
        this.freightInvoice(itemList, billStrategyRespDto, performOrderInfoDtos);
        List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
        Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
        performOrderInfoDtoList.forEach(orderInfoDto -> {
            logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)orderInfoDto.getItemDtoList()));
            if (this.orderTypeFilter(orderInfoDto.getOrderType()).booleanValue()) {
                orderInfoDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, itemList, zeroNumItemList));
            } else {
                logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zeroNumItemList)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
                BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
                BigDecimal payAmount = ((PerformOrderItemDto)itemList.get(0)).getRealPayAmount();
                ((PerformOrderItemDto)itemList.get(0)).setRealPayAmount(payAmount.add(amount));
                logger.info("\u5b58\u5728\u5546\u54c1\u9000\u6570\u91cf\u5b8c\u6210\u91d1\u989d\u5927\u4e8e\u96f6\uff1a{}", (Object)amount);
            } else if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
            }
        }
        AssertUtil.isTrue(org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList), "\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e");
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList noWhetherMergeItem = new ArrayList();
        ArrayList<PerformOrderItemDto> whetherMergeItem = new ArrayList<PerformOrderItemDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            logger.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((PerformOrderItemDto)item);
                } else {
                    noWhetherMergeItem.add(item);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoReqDto, billItemReqDtoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, PerformOrderItemDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        Map<String, List<PerformOrderItemDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(item -> item.getSkuCode() + item.getGift()));
        List<String> skuCodeList = noWhetherMergeItem.stream().map(PerformOrderItemDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        orderItemMap.forEach((k, v) -> {
            BillItemReqDto billItemReqDto = new BillItemReqDto();
            PerformOrderItemDto performOrderItemDto = (PerformOrderItemDto)v.get(0);
            billItemReqDto.setGift(performOrderItemDto.getGift());
            if (3 == performOrderItemDto.getGift()) {
                billItemReqDto.setGift(Integer.valueOf(0));
                billItemReqDto.setFreightCost(Integer.valueOf(1));
            }
            billItemReqDto.setItemId(performOrderItemDto.getSkuId());
            billItemReqDto.setItemCode(performOrderItemDto.getSkuCode());
            billItemReqDto.setItemName(performOrderItemDto.getSkuName());
            billItemReqDto.setQuantity(v.stream().map(PerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemReqDto.setBillFlowNo(billInfoReqDto.getBillFlowNo());
            BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal amount = payAmount.subtract(refundedPayAmount);
            billItemReqDto.setAmount(amount);
            billItemReqDto.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemReqDto.setUnitPrice(performOrderItemDto.getSalePrice());
            billItemReqDto.setPlatformOrderNo(billInfoReqDto.getPlatformOrderNo());
            if (skuCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(performOrderItemDto.getSkuCode());
                billItemReqDto.setItemName(itemSkuDgDto.getName());
                billItemReqDto.setSpecification(itemSkuDgDto.getSpecModel());
                billItemReqDto.setItemShortName(itemSkuDgDto.getDisplayName());
                billItemReqDto.setPatentName(itemSkuDgDto.getPatentCode());
                billItemReqDto.setUnit(itemSkuDgDto.getSaleUnitName());
                this.assembleReqBillItemInfo(performOrderItemDto, itemSkuDgDto.getItemRateDgDto(), itemSkuDgDto, billStrategyRespDto, billItemReqDto);
            }
            billItemReqDtoList.add(billItemReqDto);
        });
        BillInfoEo billInfoEo = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)billInfoEo, (Object)billInfoReqDto, (String[])new String[0]);
        this.addBillOrderItem(itemList, billInfoEo, skuCodeMap, billStrategyRespDto);
        billInfoReqDto.setInvoiceAmount(number.get().add(mergeItemAmount));
        this.itemGiftGenerate(billItemReqDtoList);
        billInfoReqDto.setBillItemReqDtoList(billItemReqDtoList);
        String invoiceRemarks = billInfoReqDto.getInvoiceRemarks();
        ArrayList remarks = Lists.newArrayList();
        if (BillStrategyRemarkType.PLATFORM.containsCode(billStrategyRespDto.getRemark())) {
            billInfoReqDto.setInvoiceRemarks(performOrderInfoDto.getPlatformOrderNo());
            remarks.add(performOrderInfoDto.getPlatformOrderNo());
        }
        if (BillStrategyRemarkType.PATENT.containsCode(billStrategyRespDto.getRemark())) {
            list = billItemReqDtoList.stream().map(BillItemReqDto::getPatentName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(list)) {
                remarks.addAll(list);
            }
            billInfoReqDto.setInvoiceRemarks(String.join((CharSequence)";", remarks));
        }
        billInfoReqDto.setInvoiceRemarks(StrUtil.blankToDefault((CharSequence)invoiceRemarks, (String)billInfoReqDto.getInvoiceRemarks()));
        list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).orderByDesc((Object)"create_time")).list(Integer.valueOf(2));
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            String joinRemarks;
            String str = StrUtil.isNotBlank((CharSequence)billInfoEo.getInvoiceRemarks()) ? billInfoEo.getInvoiceRemarks() + "," : billInfoEo.getInvoiceRemarks();
            String string = joinRemarks = list.size() > 1 && StrUtil.isBlank((CharSequence)((BillApplyEo)list.get(0)).getRemark()) ? ((BillApplyEo)list.get(1)).getRemark() : ((BillApplyEo)list.get(0)).getRemark();
            if (StrUtil.isNotBlank((CharSequence)joinRemarks)) {
                billInfoEo.setInvoiceRemarks(String.format("%s%s", str, joinRemarks));
            }
            billInfoEo.setFileUrl(((BillApplyEo)list.get(0)).getFileUrl());
        }
    }

    public void getBillEntity(BillInfoReqDto billInfoReqDto) {
        AssertUtil.isTrue(Objects.nonNull(billInfoReqDto.getEntityId()), "\u5f00\u7968\u4e3b\u9898\u4e0d\u80fd\u4e3a\u7a7a");
        BillEntityEo entity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billInfoReqDto.getEntityId())).one();
        if (Objects.nonNull(entity)) {
            billInfoReqDto.setEntityId(entity.getId());
            billInfoReqDto.setEnterprise(entity.getEnterprise());
            billInfoReqDto.setEntityCode(entity.getEntityCode());
            billInfoReqDto.setEntityName(entity.getEntityName());
            billInfoReqDto.setDistributorTaxesCode(entity.getTaxesCode());
            billInfoReqDto.setDistributorRegisteredAddress(entity.getRegisteredAddress());
            billInfoReqDto.setDistributorRegisteredPhone(entity.getRegisteredPhone());
            billInfoReqDto.setDistributorBankAccount(entity.getBankAccount());
            billInfoReqDto.setDistributorBank(entity.getBank());
            billInfoReqDto.setCollectPerson(entity.getCollectPerson());
            billInfoReqDto.setBillPerson(entity.getBillPerson());
            billInfoReqDto.setReviewPerson(entity.getReviewPerson());
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoReqDto.getBillItemReqDtoList())) {
            BigDecimal amount = billInfoReqDto.getBillItemReqDtoList().stream().map(BillItemReqDto::getClinchDealAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            billInfoReqDto.setInvoiceAmount(amount);
        }
    }

    public String uploadPdfUrl(String billFlowNo, String pdfUrl) {
        if (StrUtil.isBlank((CharSequence)pdfUrl)) {
            return null;
        }
        String fileName = String.format("billInfo-billFlowNo-%s.pdf", billFlowNo);
        String dateForm = DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd");
        String path = MessageFormat.format(String.format("{0}/{1}/%s", fileName), this.invoiceDirPath, dateForm);
        String url = null;
        try {
            logger.info("\u51c6\u5907\u4e0a\u4f20\u6587\u4ef6\u5230oss");
            url = this.getPdfOssPath(pdfUrl, path);
            logger.info("url===\u300b{}", (Object)url);
            return url;
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private String getPdfOssPath(String pdfUrl, String path) {
        if (pdfUrl.indexOf(".pdf") >= 0) {
            HttpResponse response = HttpUtil.createGet((String)pdfUrl).execute();
            return this.objectStorageService.put(this.bucketName, path, response.bodyStream());
        }
        byte[] bytes = HttpUtil.downloadBytes((String)pdfUrl);
        return this.objectStorageService.put(this.bucketName, path, bytes);
    }

    public Boolean orderTypeFilter(String orderType) {
        if (SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.PROXY_SALE.getType().equals(orderType) || SaleOrderTypeEnum.GIFT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.SHIPMENT_CLAIM_ORDER.getType().equals(orderType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    @Override
    public void backPassPlatformInvoice(String billFlowNo) {
        this.iCallBackPassPlatformInvoiceService.callBackChannelInvoiceInfo(billFlowNo);
    }

    @Override
    public List<String> batchBackPassPlatformInvoice(List<String> billFlowNoList) {
        logger.info("\u6279\u91cf\u56de\u4f20\u5f00\u7968\u5b8c\u6210\u63a8\u9001\u5e73\u53f0:{}", (Object)JSON.toJSONString(billFlowNoList));
        ArrayList<String> errorList = new ArrayList<String>();
        billFlowNoList.forEach(info -> {
            try {
                this.backPassPlatformInvoice((String)info);
            }
            catch (Exception e) {
                errorList.add(info + ":" + e.getMessage());
            }
        });
        return errorList;
    }

    private InvoiceInfoReqDto buildInvoiceInfoReqDto(BillInfoEo info, List<BillItemEo> billItemEos, Integer invoiceBillType) {
        InvoiceInfoReqDto invoiceInfoReqDto = new InvoiceInfoReqDto();
        invoiceInfoReqDto.setInvoiceSerialNumber(info.getBillFlowNo());
        invoiceInfoReqDto.setOrderNumber(info.getPlatformOrderNo());
        invoiceInfoReqDto.setTaxpayerIdentificationNumber(info.getDistributorTaxesCode());
        invoiceInfoReqDto.setRemark(info.getInvoiceRemarks());
        invoiceInfoReqDto.setInvoiceIssuerName(info.getEntityName());
        invoiceInfoReqDto.setInvoiceType(info.getInvoiceType());
        invoiceInfoReqDto.setInvoiceTileType(info.getTitleType());
        invoiceInfoReqDto.setMainInvoiceProject(info.getEntityName());
        invoiceInfoReqDto.setSalesTaxpayerIdentificationNumber(info.getDistributorTaxesCode());
        invoiceInfoReqDto.setSalesTaxpayerName(info.getEntityName());
        invoiceInfoReqDto.setSalesTaxpayerAddress(info.getDistributorRegisteredAddress());
        invoiceInfoReqDto.setSalesTaxpayerPhone(info.getDistributorRegisteredPhone());
        invoiceInfoReqDto.setSalesTaxpayerBankAccount(info.getDistributorBankAccount());
        invoiceInfoReqDto.setSalesTaxpayerBankName(info.getDistributorBank());
        invoiceInfoReqDto.setPurchaserName(info.getBillTitle());
        invoiceInfoReqDto.setPurchaserEmail(info.getMailbox());
        invoiceInfoReqDto.setPurchaserFixedPhone(info.getRegisteredPhone());
        invoiceInfoReqDto.setPurchaserMobilePhone(info.getPhone());
        invoiceInfoReqDto.setReceiptPhoneNum(info.getBillPersonPhone());
        invoiceInfoReqDto.setPurchaserIdentificationNumber(info.getTaxesCode());
        invoiceInfoReqDto.setPurchaserBankAccount(info.getBankAccount());
        invoiceInfoReqDto.setPurchaserBankName(info.getBank());
        invoiceInfoReqDto.setPayee(info.getCollectPerson());
        invoiceInfoReqDto.setReviewer(info.getReviewPerson());
        invoiceInfoReqDto.setInvoiceBillType(invoiceBillType);
        invoiceInfoReqDto.setOriginalInvoiceNumber(info.getBlueTicketInvoiceNo());
        invoiceInfoReqDto.setOriginalInvoiceCode(info.getBlueTicketInvoiceCode());
        invoiceInfoReqDto.setTotalAmountOfPriceAndTax(info.getInvoiceAmount());
        invoiceInfoReqDto.setPurchaserAddress(info.getRegisteredAddress());
        invoiceInfoReqDto.setReceiptAddress(info.getBillAddress());
        invoiceInfoReqDto.setReceiptName(info.getBillPersonName());
        invoiceInfoReqDto.setChannel(info.getBillChannel());
        invoiceInfoReqDto.setId(info.getId());
        invoiceInfoReqDto.setShopCode(info.getShopCode());
        invoiceInfoReqDto.setSiteCode(info.getSiteCode());
        invoiceInfoReqDto.setOrgCode(info.getEntityCode());
        invoiceInfoReqDto.setCustomerCode(info.getCustomerCode());
        invoiceInfoReqDto.setCustomerName(info.getCustomerName());
        invoiceInfoReqDto.setInvoiceRemarks(info.getInvoiceRemarks());
        invoiceInfoReqDto.setRedInfoOrderNo(info.getRedInfoOrderNo());
        ArrayList details = new ArrayList();
        billItemEos.forEach(item -> {
            InvoiceDetailReqDto dto = new InvoiceDetailReqDto();
            dto.setProjectName(item.getItemName());
            dto.setBillLineItemName(item.getBillLineItemName());
            dto.setProjectCode(item.getItemCode());
            dto.setProjectQuantity(item.getQuantity());
            dto.setProjectUnit(item.getUnit());
            dto.setUnitPrice(item.getUnitPrice());
            dto.setProjectAmount(item.getAmount());
            dto.setTaxClassificationCode(item.getTaxClassificationCode());
            dto.setTaxRate(item.getTaxRate());
            dto.setTaxAmount(item.getTaxAmount());
            dto.setId(item.getId());
            dto.setSpecificationModel(item.getSpecification());
            details.add(dto);
        });
        invoiceInfoReqDto.setDetails(details);
        List platformOrderInfos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)info.getPlatformOrderNo())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformOrderInfos)) {
            PerformOrderInfoEo platformOrderInfo = (PerformOrderInfoEo)platformOrderInfos.get(0);
            invoiceInfoReqDto.setOrderType(platformOrderInfo.getOrderType());
            invoiceInfoReqDto.setOrderDate(DateUtil.formatDate((Date)(Objects.isNull(platformOrderInfo.getPlatformCreateTime()) ? platformOrderInfo.getCreateTime() : platformOrderInfo.getPlatformCreateTime())));
        }
        logger.info("\u6784\u5efa\u5f00\u7968\u4fe1\u606f===>{}", (Object)JSON.toJSONString((Object)invoiceInfoReqDto));
        return invoiceInfoReqDto;
    }

    private Boolean sendInvoiceIsReopen(BillInfoEo addRedBill, List<BillItemEo> billItemList, Integer invoiceBillType) {
        InvoiceInfoReqDto invoiceInfoReqDto = this.buildInvoiceInfoReqDto(addRedBill, billItemList, invoiceBillType);
        RestResponse response = this.invoiceApiProxy.createEliInvoice(invoiceInfoReqDto);
        logger.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
        if (response.isSuccess() && "0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode())) {
            InvoiceInfoRespDto data = (InvoiceInfoRespDto)response.getData();
            addRedBill.setInvoiceUrl(data.getDownloadUrl());
            addRedBill.setInvoiceConnectUrl(data.getDownloadUrl());
            addRedBill.setExternalInvoiceNo(data.getInvoiceNumber());
            addRedBill.setExternalInvoiceCode(data.getInvoiceCode());
            addRedBill.setExternalInvoiceTime(data.getInvoiceDate());
            addRedBill.setInvoiceState(data.getIsSync() != false ? InvoiceStateEnum.BILLED.getCode() : InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateSelective((BaseEo)addRedBill);
            return true;
        }
        addRedBill.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
        addRedBill.setExtension(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
        this.billInfoDas.updateSelective((BaseEo)addRedBill);
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncInvoiceResult(CallBackInvoiceInfoReqDto invoiceInfoRespDto) {
        logger.info("CallBackInvoiceInfoReqDto:{}", (Object)JSONObject.toJSONString((Object)invoiceInfoRespDto));
        BillInfoEo billInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"id", (Object)invoiceInfoRespDto.getBillInfoId())).one();
        logger.info("\u5904\u7406\u56de\u4f20\u5e73\u53f0\u5355\u636e\uff1a{},{},{}", new Object[]{billInfoEo.getPlatformOrderNo(), JSONObject.toJSONString((Object)billInfoEo), JSONObject.toJSONString((Object)invoiceInfoRespDto)});
        if ("0".equals(invoiceInfoRespDto.getExtResultCode())) {
            String ossUrl = this.uploadPdfUrl(billInfoEo.getBillFlowNo(), invoiceInfoRespDto.getDownloadUrl());
            billInfoEo.setInvoiceConnectUrl(invoiceInfoRespDto.getDownloadUrl());
            billInfoEo.setExternalInvoiceTime(invoiceInfoRespDto.getInvoiceDate());
            billInfoEo.setExternalInvoiceCode(invoiceInfoRespDto.getInvoiceCode());
            billInfoEo.setExternalInvoiceNo(invoiceInfoRespDto.getInvoiceNumber());
            billInfoEo.setUploadPdfUrl(ossUrl);
            billInfoEo.setPushPlatformState("");
            billInfoEo.setPushPlatformError("");
            billInfoEo.setInvoiceState(invoiceInfoRespDto.getIsSync() != false ? InvoiceStateEnum.BILLED.getCode() : InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            if (invoiceInfoRespDto.getIsSync().booleanValue()) {
                if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType())) {
                    this.updateOrderBillInfo((BillInfoEo)this.billInfoDas.selectByPrimaryKey(invoiceInfoRespDto.getBillInfoId()), SaleOrderInvoiceStateEnum.INVOICED.getCode());
                } else {
                    this.againRedInvoiceUpdate(billInfoEo);
                }
            }
            if (invoiceInfoRespDto.getIsSync().booleanValue() && BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType())) {
                logger.info("\u5f02\u6b65\u5904\u7406\u56de\u4f20\u5e73\u53f0\u5355\u636e\uff1a{}", (Object)billInfoEo.getPlatformOrderNo());
                CompletableFuture.runAsync(() -> {
                    try {
                        Thread.sleep(1000L);
                        logger.info("\u6267\u884c\u4e2d={}", (Object)billInfoEo.getBillFlowNo());
                        this.iCallBackPassPlatformInvoiceService.callBackChannelInvoiceInfo(billInfoEo.getBillFlowNo());
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                });
            }
            return;
        }
        billInfoEo.setExtension(invoiceInfoRespDto.getExtResultMsg());
        billInfoEo.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_RED.getCode());
    }

    @Override
    public void createInvoice(PerformOrderInfoDto performOrderInfoDto, List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList, BillStrategyRespDto billStrategyRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        this.deliveryGen(performOrderInfoDto, saleOrderBillRecordRespDtoList, billStrategyRespDto, billInfoGenerateReqDto);
    }

    @Override
    public void setSpecialRate(BillInfoEo billInfoEo, BillItemEo billItemEo) {
        logger.info("\u7279\u6b8a\u7a0e\u7387\u5224\u65ad\uff1a{}, {}", this.specialRateCompanyNames, (Object)billInfoEo.getEntityName());
        if (this.specialRateCompanyNames.contains(billInfoEo.getEntityName())) {
            billItemEo.setTaxRate(SPECIAL_RATE);
            billItemEo.setTaxAmount(this.calculateTaxAmount(billItemEo.getAmount(), billItemEo.getTaxRate()));
        }
    }

    @Override
    public void setSpecialRateBillOrderItem(BillInfoEo billInfoEo, BillOrderItemEo billOrderItemEo) {
        logger.info("billOrderItemEo\u7279\u6b8a\u7a0e\u7387\u5224\u65ad\uff1a{}, {}", this.specialRateCompanyNames, (Object)billInfoEo.getEntityName());
        if (this.specialRateCompanyNames.contains(billInfoEo.getEntityName())) {
            billOrderItemEo.setTaxRate(SPECIAL_RATE);
            billOrderItemEo.setTaxAmount(this.calculateTaxAmount(billOrderItemEo.getAmount(), billOrderItemEo.getTaxRate()));
        }
    }

    private BigDecimal calculateTaxAmount(BigDecimal amount, BigDecimal taxRate) {
        return amount.divide(taxRate.add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(taxRate).setScale(2, 4);
    }

    private CallBackInvoiceInfoReqDto extractInvoiceInfoReqDto(RestResponse<InvoiceInfoRespDto> response, Long billInfoId) {
        CallBackInvoiceInfoReqDto infoReqDto = (CallBackInvoiceInfoReqDto)BeanUtil.toBean((Object)response.getData(), CallBackInvoiceInfoReqDto.class);
        infoReqDto.setBillInfoId(billInfoId);
        infoReqDto.setExtResultMsg(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
        return infoReqDto;
    }

    private Map<String, String> getDistributionOrderNo(List<String> platformOrderNos) {
        List performOrderInfoEos;
        int length;
        HashMap resultMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(platformOrderNos)) {
            return resultMap;
        }
        int i = 0;
        for (length = platformOrderNos.size(); length > 1000; length -= 1000) {
            performOrderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"platform_order_no", platformOrderNos.subList(i, i + 1000))).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderInfoEos)) {
                performOrderInfoEos.forEach(v -> resultMap.put(v.getPlatformOrderNo(), v.getDistributionOrderNo()));
            }
            i += 1000;
        }
        if (length > 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(performOrderInfoEos = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"platform_order_no", platformOrderNos.subList(i, i + length))).list()))) {
            performOrderInfoEos.forEach(v -> resultMap.put(v.getPlatformOrderNo(), v.getDistributionOrderNo()));
        }
        return resultMap;
    }

    public void getExcludingPerformOrderInfoDtoList(List<PerformOrderInfoDto> performOrderInfoDtoList) {
        logger.info("getExcludingPerformOrderInfoDtoList:{}", (Object)JSONObject.toJSONString(performOrderInfoDtoList));
        List performOrderInfoDtos = performOrderInfoDtoList.stream().filter(x -> SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(x.getOrderType())).collect(Collectors.toList());
        logger.info("performOrderInfoDtos:{}", (Object)JSONObject.toJSONString(performOrderInfoDtos));
        if (CollectionUtils.isNotEmpty(performOrderInfoDtos)) {
            List collect = performOrderInfoDtos.stream().map(PerformOrderInfoDto::getSaleOrderNo).collect(Collectors.toList());
            List afterSaleOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.afterSaleOrderDomain.filter().eq((Object)"relate_to_platform_order", (Object)0)).in((Object)"exchange_sale_order_no", collect)).list();
            Map afterSaleOrderEoMap = afterSaleOrderEos.stream().collect(Collectors.toMap(x -> x.getExchangeSaleOrderNo(), Function.identity(), (k1, k2) -> k1));
            logger.info("afterSaleOrderEoMap:{}", (Object)JSONObject.toJSONString(afterSaleOrderEoMap));
            Iterator<PerformOrderInfoDto> iterator = performOrderInfoDtoList.iterator();
            while (iterator.hasNext()) {
                PerformOrderInfoDto next = iterator.next();
                if (org.springframework.util.CollectionUtils.isEmpty(afterSaleOrderEoMap) || !afterSaleOrderEoMap.containsKey(next.getSaleOrderNo())) continue;
                AfterSaleOrderEo afterSaleOrderEo = (AfterSaleOrderEo)afterSaleOrderEoMap.get(next.getSaleOrderNo());
                if (Objects.equals(AfterSaleOrderStatusEnum.FINISH.getCode(), afterSaleOrderEo.getStatus()) || !SaleOrderTypeEnum.EXCHANGE_ORDER.getType().equals(next.getOrderType())) continue;
                iterator.remove();
            }
        }
    }

    @Override
    public void reGenerateBillInfo(List<String> platformOrderNos) {
        Map<String, List<BillInfoEo>> billinfoEoListMap;
        List billInfoEoList;
        int length;
        logger.info("\u91cd\u65b0\u751f\u6210\u53d1\u7968\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(platformOrderNos));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(platformOrderNos)) {
            throw new BizException("\u751f\u6210\u53d1\u7968\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List platformOrderNosList = platformOrderNos.stream().distinct().collect(Collectors.toList());
        int i = 0;
        for (length = platformOrderNosList.size(); length > 500; length -= 500) {
            billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNosList.subList(i, i + 500))).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).eq((Object)"bill_type", (Object)"blue_ticket")).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
                billinfoEoListMap = billInfoEoList.stream().collect(Collectors.groupingBy(BillInfoEo::getPlatformOrderNo));
                billinfoEoListMap.forEach((k, v) -> {
                    BillInfoEo billInfoEo = (BillInfoEo)v.stream().sorted(Comparator.comparing(BaseEo::getCreateTime).reversed()).collect(Collectors.toList()).get(0);
                    BillInfoReqDto addReqDto = new BillInfoReqDto();
                    CubeBeanUtils.copyProperties((Object)addReqDto, (Object)billInfoEo, (String[])new String[0]);
                    addReqDto.setBillFlowNo(null);
                    addReqDto.setRelOrder(Boolean.valueOf(true));
                    logger.info("\u91cd\u65b0\u751f\u6210\u53d1\u7968\u5165\u53c2:{},{}", k, (Object)JSONObject.toJSONString((Object)addReqDto));
                    this.generateBillApply(addReqDto);
                });
            }
            i += 500;
        }
        if (length > 0 && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"platform_order_no", platformOrderNosList.subList(i, i + length))).eq((Object)"invoice_state", (Object)InvoiceStateEnum.BILLED.getCode())).eq((Object)"bill_type", (Object)"blue_ticket")).list()))) {
            billinfoEoListMap = billInfoEoList.stream().collect(Collectors.groupingBy(BillInfoEo::getPlatformOrderNo));
            billinfoEoListMap.forEach((k, v) -> {
                BillInfoEo billInfoEo = (BillInfoEo)v.stream().sorted(Comparator.comparing(BaseEo::getCreateTime).reversed()).collect(Collectors.toList()).get(0);
                BillInfoReqDto addReqDto = new BillInfoReqDto();
                CubeBeanUtils.copyProperties((Object)addReqDto, (Object)billInfoEo, (String[])new String[0]);
                addReqDto.setBillFlowNo(null);
                addReqDto.setRelOrder(Boolean.valueOf(true));
                logger.info("\u91cd\u65b0\u751f\u6210\u53d1\u7968\u5165\u53c2:{},{}", k, (Object)JSONObject.toJSONString((Object)addReqDto));
                this.generateBillApply(addReqDto);
            });
        }
    }

    private UserSystemBillApplyRespDto generateBillApply(BillInfoReqDto addReqDto) {
        BillApplyGenerateReqDto reqDto = new BillApplyGenerateReqDto();
        reqDto.setPlatformOrderNoList(Arrays.asList(addReqDto.getPlatformOrderNo()));
        reqDto.setBillType(addReqDto.getBillType());
        reqDto.setTitleType(addReqDto.getTitleType());
        reqDto.setBillApplyType("apply_bill");
        reqDto.setTitleType(addReqDto.getTitleType());
        reqDto.setBillTitle(addReqDto.getBillTitle());
        reqDto.setEnterprise(addReqDto.getEnterprise());
        reqDto.setTaxesCode(addReqDto.getTaxesCode());
        reqDto.setRegisteredAddress(addReqDto.getRegisteredAddress());
        reqDto.setRegisteredPhone(addReqDto.getRegisteredPhone());
        reqDto.setBankAccount(addReqDto.getBankAccount());
        reqDto.setBank(addReqDto.getBank());
        reqDto.setBillPersonName(addReqDto.getBillPersonName());
        reqDto.setBillPersonPhone(addReqDto.getBillPersonPhone());
        reqDto.setBillAddress(addReqDto.getBillAddress());
        reqDto.setMailbox(addReqDto.getMailbox());
        reqDto.setPhone(addReqDto.getPhone());
        reqDto.setWhetherMergeBill(addReqDto.getWhetherMergeBill());
        reqDto.setFileUrl(addReqDto.getFileUrl());
        reqDto.setRemark(addReqDto.getInvoiceRemarks());
        reqDto.setWhetherMergeBill(WhetherMergeBillTypeEnum.NO_MERGE.getCode());
        logger.info("\u7533\u8bf7\u5f00\u7968\u5165\u53c2reqDto:{}", (Object)JSON.toJSONString((Object)reqDto));
        UserSystemBillApplyRespDto userSystemBillApplyRespDto = this.billApplyService.generateBillApply(reqDto);
        logger.info("\u7533\u8bf7\u5f00\u7968\u8fd4\u56de\u7ed3\u679c:{}", (Object)JSONObject.toJSONString((Object)userSystemBillApplyRespDto));
        return userSystemBillApplyRespDto;
    }

    @Override
    public void batchReissue(BatchReissueDto req) {
        String reqId = StrUtil.isNotBlank((CharSequence)ServiceContext.getContext().getRequestId()) ? ServiceContext.getContext().getRequestId() : RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)reqId);
        logger.info("\u6279\u91cf\u8865\u5f00\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)req));
        Set shopCodes = Optional.ofNullable(req.getShopCodes()).orElse(new HashSet());
        req.setShopCodes(shopCodes);
        Set subsidiesTypes = Optional.ofNullable(req.getSubsidiesTypes()).orElse(new HashSet());
        if (subsidiesTypes.contains(-1)) {
            subsidiesTypes.clear();
        }
        req.setSubsidiesTypes(subsidiesTypes);
        logger.info("\u6279\u91cf\u8865\u5f00\u53d1\u7968\uff0c\u5904\u7406\u540e\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)req));
        if ((req.getStartTime() == null || req.getEndTime() == null) && org.apache.commons.collections.CollectionUtils.isEmpty((Collection)req.getPlatformOrderNos())) {
            throw new BizException("\u65f6\u95f4\u6bb5\u548c\u5e73\u53f0\u5355\u53f7\u81f3\u5c11\u586b\u4e00\u4e2a");
        }
        boolean hasTimeRange = req.getStartTime() != null && req.getEndTime() != null;
        Set timeRangePlatformOrderNos = new HashSet();
        Set reqPlatformOrderNos = Optional.ofNullable(req.getPlatformOrderNos()).orElse(Collections.emptySet());
        Set<Object> platformOrderNos = new HashSet(reqPlatformOrderNos);
        if (hasTimeRange) {
            timeRangePlatformOrderNos = this.pushKeepAccountsDomain.queryCanBillPlatformOrderNoByTimeRange(req.getStartTime(), req.getEndTime());
            logger.info("timeRangePlatformOrderNos: {}", timeRangePlatformOrderNos);
            platformOrderNos.addAll(timeRangePlatformOrderNos);
        }
        if (hasTimeRange && !reqPlatformOrderNos.isEmpty()) {
            Sets.SetView intersection = Sets.intersection(timeRangePlatformOrderNos, reqPlatformOrderNos);
            platformOrderNos = new HashSet(intersection);
        }
        if (!shopCodes.isEmpty() || !subsidiesTypes.isEmpty()) {
            platformOrderNos = Lists.partition(new ArrayList(platformOrderNos), (int)1000).stream().flatMap(once -> {
                List<String> orderNos = this.performOrderInfoService.queryPlatformOrderNoByShopCodeAndSubsidesTypes((List<String>)once, shopCodes, subsidiesTypes);
                return orderNos.stream();
            }).collect(Collectors.toSet());
        }
        logger.info("\u8fc7\u6ee4\u540e\u7684\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)JacksonUtil.toJson(platformOrderNos));
        platformOrderNos.forEach(platformOrderNo -> {
            ReissueBillDto dto = new ReissueBillDto();
            dto.setPlatformOrderNo(platformOrderNo);
            dto.setReqId(reqId);
            this.sendReissueMQ(dto);
        });
    }

    private void sendReissueMQ(ReissueBillDto dto) {
        MessageVo message = new MessageVo();
        message.setCenterType("\u8d22\u52a1\u4e2d\u5fc3");
        message.setSingleOr("\u5355\u53d1");
        message.setData((Object)JSON.toJSONString((Object)dto));
        logger.info("\u53d1\u9001\u8865\u5f00\u53d1\u7968MQ\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)message));
        MessageResponse messageResponse = this.commonsMqService.sendSingleMessage("REISSUE_BILL", (Object)message);
        logger.info("\u53d1\u9001\u8865\u5f00\u53d1\u7968MQ\u6d88\u606f\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)messageResponse));
    }

    @Override
    public void reissue(String platformOrderNo) {
        String lockKey = this.getBatchReissueLockKey(platformOrderNo);
        Boolean setSuccess = this.cacheService.setIfAbsent(lockKey, "true", 300);
        if (!Objects.equals(setSuccess, true)) {
            logger.info("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u83b7\u53d6\u4e0d\u5230\u9501 {}\uff0c\u4e0d\u53ef\u4ee5\u8865\u5f00\u53d1\u7968\uff0c\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)lockKey, (Object)platformOrderNo);
            return;
        }
        logger.info("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u53d6\u5230\u9501: {}\uff0c\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)lockKey, (Object)platformOrderNo);
        try {
            this.previewAndReissueBill(platformOrderNo);
        }
        catch (Exception e) {
            logger.error("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u5f02\u5e38\uff0c\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)platformOrderNo, (Object)e);
            throw new RuntimeException(e);
        }
        finally {
            logger.info("\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff1a\u91ca\u653e\u9501: {}\uff0c\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)lockKey, (Object)platformOrderNo);
            this.cacheService.delCache(lockKey);
        }
    }

    private String getBatchReissueLockKey(String platformOrderNo) {
        return "BatchReissueLock:" + platformOrderNo;
    }

    private void previewAndReissueBill(String platformOrderNo) {
        logger.info("\u5f00\u59cb\u9884\u89c8\u5e76\u91cd\u5f00\u53d1\u7968\uff0c\u5e73\u53f0\u5355\u53f7\uff1a{}", (Object)platformOrderNo);
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNoList((List)Lists.newArrayList((Object[])new String[]{platformOrderNo}));
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> saleOrderRespDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        HashSet allowStatus = Sets.newHashSet((Object[])new String[]{OmsSaleOrderStatus.DELIVERED.getCode(), OmsSaleOrderStatus.FINISH.getCode(), OmsSaleOrderStatus.COMPLETE.getCode()});
        saleOrderRespDtoList.removeIf(s -> !allowStatus.contains(s.getOrderStatus()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(saleOrderRespDtoList)) {
            logger.info("\u6839\u636e\u5e73\u53f0\u5355\u53f7 {} \u6ca1\u6709\u83b7\u53d6\u5230\u914d\u8d27\u5355", (Object)platformOrderNo);
            return;
        }
        PerformOrderInfoDto performOrderInfoDto = saleOrderRespDtoList.get(0);
        List collect = saleOrderRespDtoList.stream().filter(x -> null != x.getSubsidiesType() && 1 == x.getSubsidiesType()).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(collect)) {
            performOrderInfoDto.setSubsidiesType(Integer.valueOf(1));
        }
        BillPreviewDto preview = this.previewByPlatformOrderNo(saleOrderRespDtoList);
        logger.info("\u5e73\u53f0\u5355 {} \u7684\u53d1\u7968\u9884\u89c8\u7ed3\u679c\uff1a{}", (Object)platformOrderNo, (Object)JacksonUtil.toJson((Object)preview));
        if (preview == null) {
            logger.info("\u5e73\u53f0\u5355 {} \u6ca1\u6709\u9884\u89c8\u7ed3\u679c, \u65e0\u9700\u7ee7\u7eed\u5904\u7406", (Object)platformOrderNo);
            return;
        }
        BillInfoEo billInfo = (BillInfoEo)BillInfoConverter.INSTANCE.toEo((BaseDto)preview.getBillInfo());
        boolean isSameBill = this.billInfoValidateService.validateBillInfo(platformOrderNo, billInfo);
        logger.info("\u5224\u65ad\u5e73\u53f0\u5355 {} \u662f\u5426\u9700\u8981\u8865\u5f00\u53d1\u7968\uff1a{}", (Object)platformOrderNo, (Object)(!isSameBill ? 1 : 0));
        if (isSameBill) {
            return;
        }
        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
        billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
        billInfoGenerateReqDto.setOrderStatus(performOrderInfoDto.getOrderStatus());
        billInfoGenerateReqDto.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        billInfoGenerateReqDto.setOrderType(performOrderInfoDto.getOrderType());
        this.self.generateBillInfo(billInfoGenerateReqDto);
    }

    private BillPreviewDto previewByPlatformOrderNo(List<PerformOrderInfoDto> saleOrderRespDtoList) {
        PerformOrderInfoDto performOrderInfoDto = saleOrderRespDtoList.get(0);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)performOrderInfoDto.getPerformOrderSnapshotDtoList())) {
            logger.info("\u627e\u4e0d\u5230\u5e73\u53f0\u5355 {} \u5bf9\u5e94\u7684\u5feb\u7167\u4fe1\u606f", (Object)performOrderInfoDto.getPlatformOrderNo());
            return null;
        }
        String shopCode = ((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        logger.info("\u83b7\u53d6\u5f00\u7968\u7b56\u7565\uff1ashopCode:{}, strategy: {}", (Object)shopCode, (Object)billStrategyRespDto);
        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
        billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
        billInfoGenerateReqDto.setOrderStatus(performOrderInfoDto.getOrderStatus());
        billInfoGenerateReqDto.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        billInfoGenerateReqDto.setOrderType(performOrderInfoDto.getOrderType());
        return this.previewMergeByPlatformOrderNo(billInfoGenerateReqDto, saleOrderRespDtoList, billStrategyRespDto);
    }

    private BillPreviewDto previewMergeByPlatformOrderNo(BillInfoGenerateReqDto billInfoGenerateReqDto, List<PerformOrderInfoDto> saleOrderRespDtoList, BillStrategyRespDto billStrategyRespDto) {
        this.resetAmountAndNumForBill(billStrategyRespDto, saleOrderRespDtoList);
        List<PerformOrderInfoDto> respDtos = saleOrderRespDtoList.stream().filter(x -> Objects.nonNull(x.getFreightCost()) && BigDecimal.ZERO.compareTo(x.getFreightCost()) < 0).collect(Collectors.toList());
        PerformOrderInfoDto saleOrderRespDto = org.apache.commons.collections.CollectionUtils.isNotEmpty(respDtos) ? (PerformOrderInfoDto)respDtos.get(0) : saleOrderRespDtoList.get(0);
        SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
        saleOrderBillRecordQueryReqDto.setPlatformOrderNo(saleOrderRespDtoList.get(0).getPlatformOrderNo());
        List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
        SaleOrderBillRecordDto saleOrderBillRecordRespDto = new SaleOrderBillRecordDto();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordDtos)) {
            saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordDtos.stream().sorted(Comparator.comparing(BaseDto::getUpdateTime).reversed()).collect(Collectors.toList()).get(0);
        } else {
            this.defaultBillRecord(saleOrderBillRecordRespDto, billStrategyRespDto, billInfoGenerateReqDto, saleOrderRespDto.getPlatformOrderNo());
        }
        BillInfoEo billInfoEo = new BillInfoEo();
        String invoiceSaleOrderNo = saleOrderRespDtoList.stream().map(PerformOrderInfoDto::getSaleOrderNo).distinct().collect(Collectors.joining(","));
        billInfoEo.setInvoiceSaleOrderNo(invoiceSaleOrderNo);
        this.getBillInfo(saleOrderRespDto, billInfoEo, billStrategyRespDto, saleOrderBillRecordRespDto, billInfoGenerateReqDto);
        ArrayList<PerformOrderItemDto> itemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<PerformOrderItemDto> zeroNumItemList = new ArrayList<PerformOrderItemDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        this.freightInvoice(itemList, billStrategyRespDto, respDtos);
        List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
        Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
        saleOrderRespDtoList.forEach(performOrderInfoDto -> {
            logger.info("\u5546\u54c1\u884c\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderInfoDto.getItemDtoList()));
            if (this.orderTypeFilter(performOrderInfoDto.getOrderType()).booleanValue()) {
                if (OmsSaleOrderStatus.COMPLETE.getCode().equals(performOrderInfoDto.getOrderStatus())) {
                    performOrderInfoDto.getItemDtoList().forEach(item -> this.filterItem((PerformOrderItemDto)item, itemEoMap, billStrategyRespDto, itemList, zeroNumItemList));
                }
            } else {
                logger.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
            }
        });
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zeroNumItemList)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
                BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, RoundingMode.HALF_UP) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, RoundingMode.HALF_UP)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
                BigDecimal payAmount = ((PerformOrderItemDto)itemList.get(0)).getRealPayAmount();
                ((PerformOrderItemDto)itemList.get(0)).setRealPayAmount(payAmount.add(amount));
                logger.info("\u5b58\u5728\u5546\u54c1\u9000\u6570\u91cf\u5b8c\u6210\u91d1\u989d\u5927\u4e8e\u96f6\uff1a{}", (Object)amount);
            } else if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
            }
        }
        logger.info("itemList====>{}", (Object)JSONUtil.toJsonStr(itemList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
            this.getDeliveryGenMergeItemList(billStrategyRespDto, itemList, billInfoEo, billItemEoList, false);
        } else {
            billInfoEo.setInvoiceAmount(BigDecimal.ZERO);
        }
        this.getBillRemark(billStrategyRespDto, billInfoEo, saleOrderRespDto, billItemEoList);
        billInfoEo.setInvoiceRemarks(StrUtil.blankToDefault((CharSequence)billInfoGenerateReqDto.getInvoiceRemarks(), (String)billInfoEo.getInvoiceRemarks()));
        this.getShopAllElectricInfo(billInfoEo);
        BillPreviewDto preview = new BillPreviewDto();
        preview.setBillInfo((BillInfoDto)BillInfoConverter.INSTANCE.toDto((BaseEo)billInfoEo));
        preview.setBillItems(BillItemConverter.INSTANCE.toDtoList(billItemEoList));
        return preview;
    }

    private BillPreviewDto previewNoMergeByPlatformOrderNo(BillInfoGenerateReqDto billInfoGenerateReqDto, PerformOrderInfoDto performOrderInfoDto, BillStrategyRespDto billStrategyRespDto) {
        this.resetAmountAndNumForBill(billStrategyRespDto, performOrderInfoDto);
        SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
        saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
        List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
        logger.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
        SaleOrderBillRecordDto saleOrderBillRecordRespDto = new SaleOrderBillRecordDto();
        if (CollectionUtils.isNotEmpty(saleOrderBillRecordDtos)) {
            saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordDtos.stream().sorted(Comparator.comparing(BaseDto::getId).reversed()).collect(Collectors.toList()).get(0);
        } else {
            this.defaultBillRecord(saleOrderBillRecordRespDto, billStrategyRespDto, billInfoGenerateReqDto, performOrderInfoDto.getPlatformOrderNo());
        }
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setInvoiceSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        this.getBillInfo(performOrderInfoDto, billInfoEo, billStrategyRespDto, saleOrderBillRecordRespDto, billInfoGenerateReqDto);
        billInfoEo.setSaleOrderNo(performOrderInfoDto.getSaleOrderNo());
        billInfoEo.setWhetherMergeBill(Integer.valueOf(0));
        List<BillItemEo> billItemEoList = this.getBillDetailInfo(performOrderInfoDto, billInfoEo, billStrategyRespDto);
        billInfoEo.setInvoiceRemarks(StrUtil.blankToDefault((CharSequence)billInfoGenerateReqDto.getInvoiceRemarks(), (String)billInfoEo.getInvoiceRemarks()));
        if (org.apache.commons.collections.CollectionUtils.isEmpty(billItemEoList)) {
            logger.info("\u6ca1\u6709\u53ef\u4ee5\u5f00\u7968\u7684\u660e\u7ec6\u6570\u636e");
            return null;
        }
        this.getShopAllElectricInfo(billInfoEo);
        BillPreviewDto preview = new BillPreviewDto();
        preview.setBillInfo((BillInfoDto)BillInfoConverter.INSTANCE.toDto((BaseEo)billInfoEo));
        preview.setBillItems(BillItemConverter.INSTANCE.toDtoList(billItemEoList));
        return preview;
    }

    private Integer getSubsidiesType(String platformOrderNo) {
        List collect;
        Integer subsidiesType = 0;
        List performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).notIn((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.SPLIT.getCode(), OmsSaleOrderStatus.WAIT_CUSTOMER_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_BUSINESS_AUDIT.getCode(), OmsSaleOrderStatus.WAIT_PICK.getCode(), OmsSaleOrderStatus.PICKED.getCode(), OmsSaleOrderStatus.WAIT_DELIVERY.getCode(), OmsSaleOrderStatus.WAIT_ASSIGN.getCode(), OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode(), OmsSaleOrderStatus.LACK.getCode()))).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)performOrderInfoEos) && CollectionUtils.isNotEmpty(collect = performOrderInfoEos.stream().filter(x -> null != x.getSubsidiesType() && 1 == x.getSubsidiesType()).collect(Collectors.toList()))) {
            subsidiesType = 1;
        }
        return subsidiesType;
    }

    @Override
    public void validateAndResetCustomerInfoForMultiArea(BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto, PerformOrderInfoDto performOrderInfoDto) {
        logger.info("\u5224\u65ad\u56fd\u8865\u4e00\u54c1\u591a\u5730\u7684\u8ba2\u5355\u80fd\u5426\u5f00\u7968\uff1aplatformOrderNo={}", (Object)performOrderInfoDto.getPlatformOrderNo());
        boolean isKeepComplete = BillStrategyOrderPointEnum.KEEP_COMPLETE.equalsCode(billStrategyRespDto.getBillOrderPoint());
        if (!isKeepComplete) {
            logger.info("\u5f00\u7968\u8282\u70b9\u4e0d\u662f\u8bb0\u8d26\u5f00\u7968\uff0c\u4e0d\u9700\u8981\u6821\u9a8c\u56fd\u8865\u4e00\u54c1\u591a\u5730");
            return;
        }
        if (!Objects.equals(performOrderInfoDto.getIsMultiArea(), 1)) {
            logger.info("\u8ba2\u5355\u4e0d\u662f\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\uff0c\u4e0d\u9700\u8981\u6821\u9a8c\u662f\u5426\u53ef\u4ee5\u5f00\u7968");
            return;
        }
        PerformOrderSnapshotDto snapshot = (PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0);
        SaleOrderItemVo vo = new SaleOrderItemVo();
        vo.setOrderNo(performOrderInfoDto.getSaleOrderNo());
        vo.setShopCode(snapshot.getShopCode());
        vo.setSiteCode(snapshot.getSiteCode());
        vo.setSubsidiesType(performOrderInfoDto.getSubsidiesType());
        vo.setIsMultiArea(performOrderInfoDto.getIsMultiArea());
        vo.setPlatformNo(performOrderInfoDto.getPlatformOrderNo());
        vo.setPlatformSellerEntityNumber(performOrderInfoDto.getPlatformSellerEntityNumber());
        MatchRelatedTradeShopKeepDto dto = this.relatedTradeShopKeepingService.matchRelatedTradeShop(vo);
        if (!Objects.equals(dto.getRelatedTradeMatchResult(), true)) {
            throw new BizException("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\u627e\u4e0d\u5230\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u914d\u7f6e\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u7968");
        }
        if ("no".equals(dto.getOwnEntity())) {
            throw new BizException("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\u975e\u81ea\u6709\u4e3b\u4f53\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u7968");
        }
        if (StrUtil.isBlank((CharSequence)dto.getRelatedEntityName())) {
            throw new BizException("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\u5173\u8054\u7684\u4e3b\u4f53\u540d\u79f0\u4e3a\u7a7a");
        }
        BillEntityEo entityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"entity_name", (Object)dto.getRelatedEntityName())).one();
        logger.info("\u6839\u636e {} \u53bb\u5f00\u7968\u4e3b\u4f53\u4e2d\u67e5\u8be2\u7ed3\u679c\uff1a{} - {}", new Object[]{dto.getRelatedEntityName(), entityEo == null ? "\u672a\u627e\u5230" : "\u627e\u5230", entityEo == null ? "" : entityEo.getId()});
        if (entityEo == null) {
            throw new BizException("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\u627e\u4e0d\u5230[" + dto.getRelatedEntityName() + "]\u5bf9\u5e94\u7684\u5f00\u7968\u4e3b\u4f53\uff0c\u4e0d\u80fd\u8fdb\u884c\u5f00\u7968");
        }
        logger.info("\u56fd\u8865\u4e00\u54c1\u591a\u5730\u8ba2\u5355\u91cd\u65b0\u8bbe\u7f6e\u5f00\u7968\u4e3b\u4f53\u7b49\u4fe1\u606f");
        billInfoEo.setEntityId(entityEo.getId());
        billInfoEo.setEntityCode(entityEo.getEntityCode());
        billInfoEo.setEntityName(entityEo.getEntityName());
        billInfoEo.setEnterprise(entityEo.getEnterprise());
        billInfoEo.setDistributorRegisteredAddress(entityEo.getRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(entityEo.getRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(entityEo.getTaxesCode());
        billInfoEo.setDistributorBank(entityEo.getBank());
        billInfoEo.setDistributorBankAccount(entityEo.getBankAccount());
        billInfoEo.setCollectPerson(entityEo.getCollectPerson());
        billInfoEo.setBillPerson(entityEo.getBillPerson());
        billInfoEo.setReviewPerson(entityEo.getReviewPerson());
    }

    private /* synthetic */ void lambda$redOrderBillInfo$169(BillInfoEo billInfoEo, String finalOrderInvoiceStatus, BigDecimal finalInvoiceAmount, SaleOrderBillRecordDto order) {
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        saleOrderBillRecordReqDto.setId(order.getId());
        CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
        saleOrderBillRecordReqDto.setWhetherInvoice(finalOrderInvoiceStatus);
        saleOrderBillRecordReqDto.setInvoiceAmount(finalInvoiceAmount);
        saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
    }
}

