/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.SpringBeanUtil;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.dao.das.IItemRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepDetailMappingDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepItemRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepTimeOutDas;
import com.yunxi.dg.base.center.finance.dao.das.IOrderRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.dao.das.IShopRuleDas;
import com.yunxi.dg.base.center.finance.dao.das.inventory.IOutResultOrderDas;
import com.yunxi.dg.base.center.finance.dao.das.inventory.IOutResultOrderDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderInfoOutNoticeSyncRecordDas;
import com.yunxi.dg.base.center.finance.dao.das.trade.IDgPerformOrderItemLineDas;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BookKeepingType;
import com.yunxi.dg.base.center.finance.dto.enums.ConditionTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.FinanceExceptionCode;
import com.yunxi.dg.base.center.finance.dto.enums.KeepResultEnum;
import com.yunxi.dg.base.center.finance.dto.enums.KeepTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.mq.DeliveryItemDto;
import com.yunxi.dg.base.center.finance.dto.request.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.finance.dto.request.MamualKeepAccountReqDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.KeepDetailMappingEo;
import com.yunxi.dg.base.center.finance.eo.KeepTimeOutEo;
import com.yunxi.dg.base.center.finance.eo.OrderRuleEo;
import com.yunxi.dg.base.center.finance.eo.PushKeepAccountsEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IKeepTimeOutService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IPushKeepAccountsService;
import com.yunxi.dg.base.center.finance.service.entity.ISyncKeepAccountingService;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepAccountRuleFactory;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRule;
import com.yunxi.dg.base.center.finance.service.entity.impl.rule.KeepNodeRuleParam;
import com.yunxi.dg.base.center.finance.service.utils.DateUtil;
import com.yunxi.dg.base.center.finance.service.utils.LockUtils;
import com.yunxi.dg.base.center.inventory.eo.OutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.OutResultOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoOutNoticeSyncRecordEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ISyncKeepAccountingServiceImpl
implements ISyncKeepAccountingService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IOrderRuleDas orderRuleDas;
    @Value(value="${keep.account.day:20}")
    private Integer day;
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    @Value(value="${receive.keep.warehouseCode:1097}")
    private String receiveWarehouseCode;
    @Resource
    private ICacheService cacheService;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;
    @Resource
    private IItemRuleDas itemRuleDas;
    @Resource
    private IShopRuleDas shopRuleDas;
    @Resource
    private IKeepItemRuleDas keepItemRuleDas;
    @Resource
    private IKeepDetailMappingDas keepDetailMappingDas;
    @Resource
    private ISyncKeepAccountingService syncKeepAccountingService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Resource
    private IOrderRuleService orderRuleService;
    @Resource
    private IKeepTimeOutDas keepTimeOutDas;
    @Resource
    private IPushKeepAccountsService pushKeepAccountsService;
    @Resource
    private IKeepTimeOutService keepTimeOutService;
    @Resource
    private ILockService lockService;
    private static final String MANUAL_BOOK_KEEPING_LOCK_KEY = "manual_book_keeping_lock_key:";

    @Override
    public void synchronousSaleBookAccount(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        this.logger.info("=================\u5f00\u59cb\u5904\u7406\u9500\u552e\u5355\u8bb0\u8d26\u5355\u5165\u5e93\u6570\u636e===================,{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto));
        try {
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.SALE_LIST.getCode());
            List<KeepNodeRule> keepNodeRules = KeepAccountRuleFactory.getSaleKeepNodeRuleList(mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.SALE_LIST.getCode(), this.keepSystem);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
        }
        catch (Exception e) {
            this.logger.error("\u9500\u552e\u5355\u8bb0\u8d26\u5931\u8d25,{}", (Object)e.getMessage(), (Object)e);
            throw new BizException("\u9500\u552e\u5355\u8bb0\u8d26\u5931\u8d25:" + e.getMessage());
        }
    }

    private Map<String, List<DeliveryItemDto>> getYesterdaySaleOrder(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        String voucherType = mamualKeepAccountReqDto.getVoucherType();
        IDgPerformOrderInfoDas dgPerformOrderInfoDas = (IDgPerformOrderInfoDas)SpringBeanUtil.getBean(IDgPerformOrderInfoDas.class);
        List<DgPerformOrderInfoEo> performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)dgPerformOrderInfoDas.filter().in((Object)"biz_model", Arrays.asList("INSIDE_SALES_ORDER", "INVOICE_ORDER"))).in((Object)"order_status", Arrays.asList(OmsSaleOrderStatus.DELIVERED.getCode(), OmsSaleOrderStatus.COMPLETE.getCode(), OmsSaleOrderStatus.DELIVERY_PART.getCode(), OmsSaleOrderStatus.DELIVERY_ALL.getCode()))).in(StringUtils.isNotBlank((CharSequence)mamualKeepAccountReqDto.getInnerOrderNo()), (Object)"sale_order_no", new Object[]{mamualKeepAccountReqDto.getInnerOrderNo()})).list();
        List innerOrderNos = performOrderInfoEos.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
        List saleOrderNos = performOrderInfoEos.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
        IKeepAccountsDetailDas keepAccountsDetailDas = (IKeepAccountsDetailDas)SpringBeanUtil.getBean(IKeepAccountsDetailDas.class);
        List keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)keepAccountsDetailDas.filter().in((Object)"order_no", saleOrderNos)).eq((Object)"voucher_type", (Object)mamualKeepAccountReqDto.getVoucherType())).list();
        List orderNos = keepAccountsDetailEos.stream().map(KeepAccountsDetailEo::getOrderNo).collect(Collectors.toList());
        this.logger.info("\u603b\u8ba2\u5355\u6570\uff1a{}", (Object)performOrderInfoEos.size());
        performOrderInfoEos = performOrderInfoEos.stream().filter(order -> !orderNos.contains(order.getSaleOrderNo())).collect(Collectors.toList());
        this.logger.info("\u8fc7\u6ee4\u540e\u8ba2\u5355\u6570\uff1a{}", (Object)performOrderInfoEos.size());
        List performOrderIds = performOrderInfoEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        IDgPerformOrderItemLineDas dgPerformOrderItemLineDas = (IDgPerformOrderItemLineDas)SpringBeanUtil.getBean(IDgPerformOrderItemLineDas.class);
        List performOrderItemLineEos = ((ExtQueryChainWrapper)dgPerformOrderItemLineDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map<Long, List<DgPerformOrderItemLineEo>> dgPerformOrderItemLineEoMap = performOrderItemLineEos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineEo::getOrderId));
        IDgPerformOrderInfoOutNoticeSyncRecordDas dgPerformOrderInfoOutNoticeSyncRecordDas = (IDgPerformOrderInfoOutNoticeSyncRecordDas)SpringBeanUtil.getBean(IDgPerformOrderInfoOutNoticeSyncRecordDas.class);
        List dgPerformOrderInfoOutNoticeSyncRecordEos = ((ExtQueryChainWrapper)dgPerformOrderInfoOutNoticeSyncRecordDas.filter().in((Object)"order_id", performOrderIds)).list();
        Map dgPerformOrderInfoOutNoticeSyncRecordEoMap = dgPerformOrderInfoOutNoticeSyncRecordEos.stream().collect(Collectors.toMap(DgPerformOrderInfoOutNoticeSyncRecordEo::getOrderId, Function.identity(), (k1, k2) -> k1));
        IOutResultOrderDas outResultOrderDas = (IOutResultOrderDas)SpringBeanUtil.getBean(IOutResultOrderDas.class);
        List outResultOrderEos = ((ExtQueryChainWrapper)outResultOrderDas.filter().in((Object)"relevance_no", innerOrderNos)).list();
        Map outResultOrderEoMap = outResultOrderEos.stream().collect(Collectors.toMap(OutResultOrderEo::getRelevanceNo, Function.identity(), (k1, k2) -> k1));
        IOutResultOrderDetailDas outResultOrderDetailDas = (IOutResultOrderDetailDas)SpringBeanUtil.getBean(IOutResultOrderDetailDas.class);
        List outResultOrderDetailEos = ((ExtQueryChainWrapper)outResultOrderDetailDas.filter().in((Object)"relevance_no", innerOrderNos)).list();
        Map<String, List<OutResultOrderDetailEo>> outResultOrderEoDetails = outResultOrderDetailEos.stream().collect(Collectors.groupingBy(OutResultOrderDetailEo::getDocumentNo));
        HashMap<String, List<DeliveryItemDto>> orderItemMap = new HashMap<String, List<DeliveryItemDto>>();
        performOrderInfoEos.forEach(order -> {
            List orderItemLineEos;
            DgPerformOrderInfoOutNoticeSyncRecordEo syncRecordEo = (DgPerformOrderInfoOutNoticeSyncRecordEo)dgPerformOrderInfoOutNoticeSyncRecordEoMap.get(order.getId());
            if (syncRecordEo == null || StringUtils.isBlank((CharSequence)syncRecordEo.getOutNoticeResultJson())) {
                this.logger.info("\u8ba2\u5355\u3010{}\u3011\u6ca1\u6709\u51fa\u5e93\u4fe1\u606f,\u4e0d\u505a\u8bb0\u8d26\u5904\u7406", (Object)order.getSaleOrderNo());
                return;
            }
            DgOutDeliveryResultReqDto outDeliveryResultReqDto = (DgOutDeliveryResultReqDto)JSON.parseObject((String)syncRecordEo.getOutNoticeResultJson(), DgOutDeliveryResultReqDto.class);
            if (StringUtils.isNotBlank((CharSequence)order.getMainOrderNo())) {
                order = this.getMainOrder((DgPerformOrderInfoEo)order);
            }
            if (CollectionUtils.isEmpty((Collection)(orderItemLineEos = (List)dgPerformOrderItemLineEoMap.get(order.getId())))) {
                this.logger.info("\u8ba2\u5355\u3010{}\u3011\u6ca1\u6709\u5546\u54c1\u884c\u4fe1\u606f,\u4e0d\u505a\u8bb0\u8d26\u5904\u7406", (Object)order.getSaleOrderNo());
                return;
            }
            String saleOrderNo = order.getSaleOrderNo();
            OutResultOrderEo outResultOrderEo = (OutResultOrderEo)outResultOrderEoMap.get(saleOrderNo);
            String documentNo = outResultOrderEo.getDocumentNo();
            List orderDetailEos = (List)outResultOrderEoDetails.get(documentNo);
            ArrayList deliveryItemDtos = new ArrayList();
            String orderNo = order.getSaleOrderNo();
            ((List)Optional.ofNullable(orderDetailEos).orElse(new ArrayList())).forEach(item -> orderItemLineEos.stream().filter(itemLine -> itemLine.getSkuCode().equals(item.getSkuCode())).collect(Collectors.toList()).forEach(itemLine -> {
                DeliveryItemDto dto = new DeliveryItemDto();
                dto.setSaleOrderNo(orderNo);
                dto.setSkuCode(itemLine.getSkuCode());
                dto.setItemNum(item.getQuantity());
                dto.setBatchNo(item.getBatch());
                dto.setItemLineId(itemLine.getId());
                dto.setGift(itemLine.getGiftFlag());
                deliveryItemDtos.add(dto);
            }));
            orderItemMap.put(order.getSaleOrderNo(), deliveryItemDtos);
        });
        return orderItemMap;
    }

    private DgPerformOrderInfoEo getMainOrder(DgPerformOrderInfoEo order) {
        IDgPerformOrderInfoDas dgPerformOrderInfoDas = (IDgPerformOrderInfoDas)SpringBeanUtil.getBean(IDgPerformOrderInfoDas.class);
        Boolean sgin = true;
        String orderNo = order.getMainOrderNo();
        DgPerformOrderInfoEo mainOrder = new DgPerformOrderInfoEo();
        DgPerformOrderInfoEo subOrder = order;
        int i = 0;
        while (sgin.booleanValue()) {
            if (StringUtils.isNotBlank((CharSequence)orderNo)) {
                List performOrderInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)dgPerformOrderInfoDas.filter().eq((Object)"sale_order_no", (Object)orderNo)).eq((Object)"biz_model", (Object)"INSIDE_SALES_ORDER")).list();
                if (CollectionUtils.isNotEmpty((Collection)performOrderInfoEos)) {
                    subOrder = (DgPerformOrderInfoEo)performOrderInfoEos.get(0);
                    if (StringUtils.isNotBlank((CharSequence)((DgPerformOrderInfoEo)performOrderInfoEos.get(0)).getMainOrderNo())) {
                        orderNo = ((DgPerformOrderInfoEo)performOrderInfoEos.get(0)).getMainOrderNo();
                    } else {
                        mainOrder = (DgPerformOrderInfoEo)performOrderInfoEos.get(0);
                        sgin = false;
                    }
                } else {
                    mainOrder = subOrder;
                    sgin = false;
                }
            }
            if (++i <= 1000) continue;
            sgin = false;
        }
        return mainOrder;
    }

    public static void main(String[] args) {
        DateUtil.getBeforeDay();
    }

    @Override
    public void syncRefundsBaseKeepAccount(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        this.logger.info("=================\u5f00\u59cb\u5904\u7406\u9000\u8d27\u9000\u6b3e/\u6362\u8d27\u5355\u8bb0\u8d26\u5355\u5165\u5e93\u6570\u636e===================,{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto));
        try {
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), mamualKeepAccountReqDto.getOrderType());
            List<KeepNodeRule> keepNodeRules = KeepAccountRuleFactory.getRefundsBaseNodeList(mamualKeepAccountReqDto.getVoucherType(), mamualKeepAccountReqDto.getOrderType(), this.keepSystem);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
        }
        catch (Exception e) {
            this.logger.error("\u9000\u8d27\u9000\u6b3e/\u6362\u8d27\u5355:\u8bb0\u8d26\u5931\u8d25,{}", (Object)e.getMessage(), (Object)e);
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public void syncExchageIssuedKeepAccount(MamualKeepAccountReqDto mamualKeepAccountReqDto) {
        this.logger.info("=================\u5f00\u59cb\u5904\u7406\u6362\u8d27\u5355\u8bb0\u8d26\u5355\u5165\u5e93\u6570\u636e===================,{}", (Object)JSON.toJSONString((Object)mamualKeepAccountReqDto));
        try {
            KeepNodeRuleParam keepNodeRuleParam = this.orderRuleService.init(mamualKeepAccountReqDto, mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.EXCHANGE.getCode());
            List<KeepNodeRule> keepNodeRules = KeepAccountRuleFactory.getExchangeIssuedNodeList(mamualKeepAccountReqDto.getVoucherType(), BillTypeEnum.EXCHANGE.getCode(), Objects.equals("HCK", this.keepSystem) ? this.keepSystem : null);
            keepNodeRules.forEach(rule -> rule.execute(keepNodeRuleParam));
        }
        catch (Exception e) {
            this.logger.error("\u9000\u8d27\u9000\u6b3e\u8bb0\u8d26\u5355\u5165\u5e93\u5931\u8d25,{}", (Throwable)e);
            e.printStackTrace();
            if (Objects.equals(KeepTypeEnum.MAMUAL.getCode(), mamualKeepAccountReqDto.getType()) && Objects.equals(VoucherTypeEnum.DELIVERY.getCode(), mamualKeepAccountReqDto.getVoucherType())) {
                this.cacheService.setCache("EXCHANGE_" + VoucherTypeEnum.DELIVERY.getCode(), (Object)"0");
            }
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public void manualGenerateBookAccount(MamualKeepAccountReqDto keepAccountReqDto) {
        String key;
        String string = key = CollectionUtil.isNotEmpty((Collection)keepAccountReqDto.getInnerOrderNos()) ? (String)keepAccountReqDto.getInnerOrderNos().get(0) : keepAccountReqDto.getInnerOrderNo();
        if (StringUtils.isBlank((CharSequence)key)) {
            key = "manualGenerateBookAccount";
        }
        if (ObjectUtils.isNotEmpty((Object)keepAccountReqDto.getVoucherType())) {
            key = key + "_" + keepAccountReqDto.getVoucherType();
        }
        this.logger.info("key\uff1a{}", (Object)key);
        OrderRuleEo orderRuleEo = (OrderRuleEo)this.orderRuleDas.filter().one();
        this.logger.info("\u8bb0\u8d26\u57fa\u7840\u8bbe\u7f6e\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)orderRuleEo));
        LockUtils.lock(() -> {
            this.logger.info("=================\u624b\u5de5\u751f\u6210\u8bb0\u8d26\u51ed\u8bc1\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c{}", (Object)JSON.toJSONString((Object)keepAccountReqDto), (Object)keepAccountReqDto);
            if (orderRuleEo != null && orderRuleEo.getMonthCycle() != null && StringUtils.isBlank((CharSequence)keepAccountReqDto.getChargeDate())) {
                this.logger.info("\u8bb0\u8d26\u65e5\u671f1\u662f{}", (Object)JSON.toJSONString((Object)keepAccountReqDto.getChargeDate()));
                keepAccountReqDto.setChargeDate(this.calculateAccountingDate(orderRuleEo.getMonthCycle()));
            }
            this.logger.info("\u8bb0\u8d26\u65e5\u671f2\u662f{}", (Object)JSON.toJSONString((Object)keepAccountReqDto.getChargeDate()));
            keepAccountReqDto.setType(StrUtil.isBlank((CharSequence)keepAccountReqDto.getType()) ? KeepTypeEnum.MAMUAL.getCode() : keepAccountReqDto.getType());
            keepAccountReqDto.setAccountType(StrUtil.isBlank((CharSequence)keepAccountReqDto.getAccountType()) ? KeepTypeEnum.MAMUAL.getCode() : keepAccountReqDto.getAccountType());
            if (StringUtils.isBlank((CharSequence)keepAccountReqDto.getVoucherType())) {
                throw new BizException(FinanceExceptionCode.DELIVERY_BILLING_NOT_NULL.getCode(), FinanceExceptionCode.DELIVERY_BILLING_NOT_NULL.getMsg());
            }
            BillTypeEnum billTypeEnum = BillTypeEnum.getEnum((String)keepAccountReqDto.getOrderType());
            switch (billTypeEnum) {
                case SALE_LIST: {
                    this.processOrder(keepAccountReqDto, dto -> this.synchronousSaleBookAccount((MamualKeepAccountReqDto)dto));
                    break;
                }
                case RETURN_BASE: 
                case EXCHANGE: 
                case DELIVERY_REFUND_ONLY: 
                case SMALL_REFUND: {
                    this.processOrder(keepAccountReqDto, dto -> this.syncRefundsBaseKeepAccount((MamualKeepAccountReqDto)dto));
                    break;
                }
                default: {
                    throw new BizException("\u672a\u77e5\u7684\u8ba2\u5355\u7c7b\u578b");
                }
            }
            return 1;
        }, "manualGenerateBookAccount", key, 30);
    }

    private String calculateAccountingDate(int N) {
        Calendar today = Calendar.getInstance();
        if (N == 0) {
            return new SimpleDateFormat("yyyy-MM-dd").format(today.getTime());
        }
        int year = today.get(1);
        int month = today.get(2);
        int day = today.get(5);
        Calendar lastDayOfMonth = Calendar.getInstance();
        lastDayOfMonth.set(year, month + 1, 1);
        lastDayOfMonth.add(5, -1);
        Calendar startOfLastNDays = (Calendar)lastDayOfMonth.clone();
        startOfLastNDays.add(5, -N);
        if (today.after(startOfLastNDays) && today.before(lastDayOfMonth) || today.equals(lastDayOfMonth)) {
            Calendar firstDayOfNextMonth = (Calendar)lastDayOfMonth.clone();
            firstDayOfNextMonth.add(2, 1);
            firstDayOfNextMonth.set(5, 1);
            return new SimpleDateFormat("yyyy-MM-dd").format(firstDayOfNextMonth.getTime());
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(today.getTime());
    }

    private void processOrder(MamualKeepAccountReqDto dto, Consumer<MamualKeepAccountReqDto> fun) {
        HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
        this.logger.info("objs======\uff1a{}", (Object)JSON.toJSONString(objs));
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        boolean needLock = StrUtil.isBlank((CharSequence)dto.getInnerOrderNo()) && CollectionUtil.isEmpty((Collection)dto.getInnerOrderNos()) && Objects.equals(KeepTypeEnum.MAMUAL.getCode(), dto.getType());
        CompletableFuture.runAsync(() -> {
            block8: {
                block9: {
                    ISyncKeepAccountingServiceImpl.setAttachmentAsync(objs);
                    MDC.put((String)"yes.req.requestId", (String)reqId);
                    if (!needLock) break block9;
                    Mutex lock = null;
                    try {
                        lock = this.lockService.lock(MANUAL_BOOK_KEEPING_LOCK_KEY, dto.getOrderType(), 0, 1800, TimeUnit.SECONDS);
                        fun.accept(dto);
                    }
                    catch (Exception e) {
                        try {
                            if (!e.getMessage().contains("\u83b7\u53d6\u5206\u5e03\u5f0f\u9501\u5931\u8d25")) {
                                throw e;
                            }
                            this.logger.info("\u6570\u636e\u5904\u7406\u4e2d");
                        }
                        catch (Throwable throwable) {
                            if (Objects.nonNull(lock)) {
                                this.lockService.unlock(lock);
                            }
                            throw throwable;
                        }
                        if (Objects.nonNull(lock)) {
                            this.lockService.unlock(lock);
                        }
                        break block8;
                    }
                    if (Objects.nonNull(lock)) {
                        this.lockService.unlock(lock);
                    }
                    break block8;
                }
                fun.accept(dto);
            }
        });
    }

    private static void setAttachmentAsync(Map<String, String> map) {
        for (Map.Entry<String, String> entry : map.entrySet()) {
            ServiceContext.getContext().setAttachment(entry.getKey(), entry.getValue());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealTimeoutKeepData() {
        ExtQueryChainWrapper sqlFilters = this.pushKeepAccountsDas.filter();
        sqlFilters.like((Object)"reason", (Object)"Read timed out executing");
        sqlFilters.eq((Object)"keeping_result", (Object)KeepResultEnum.FAIL.getCode());
        sqlFilters.ne((Object)"condition_type", (Object)ConditionTypeEnum.TRANSFERS.getCode());
        List<Object> chargeCodes = Lists.newArrayList();
        List<Object> vocherTypes = Lists.newArrayList();
        List<Object> yxIds = Lists.newArrayList();
        List pushKeepAccountsEos = sqlFilters.list();
        if (CollectionUtils.isNotEmpty((Collection)pushKeepAccountsEos)) {
            chargeCodes = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getChargeCode).collect(Collectors.toList());
            vocherTypes = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getVoucherType).distinct().collect(Collectors.toList());
            yxIds = pushKeepAccountsEos.stream().map(PushKeepAccountsEo::getYxId).distinct().collect(Collectors.toList());
        }
    }

    @Override
    public Map<String, PushKeepAccountsEo> getPushKeepAccountByChargeCodes(List<String> chargeCodes) {
        HashMap pushKeepAccountsEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(chargeCodes)) {
            List pushKeepAccountsEos;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > 200; length -= 200) {
                pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 200))).eq((Object)"keeping_result", (Object)KeepResultEnum.FAIL.getCode())).list();
                pushKeepAccountsEoMap.putAll(pushKeepAccountsEos.stream().collect(Collectors.toMap(PushKeepAccountsEo::getChargeCode, Function.identity(), (k1, k2) -> k1)));
                i += 200;
            }
            if (length > 0) {
                pushKeepAccountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).eq((Object)"keeping_result", (Object)KeepResultEnum.FAIL.getCode())).list();
                pushKeepAccountsEoMap.putAll(pushKeepAccountsEos.stream().collect(Collectors.toMap(PushKeepAccountsEo::getChargeCode, Function.identity(), (k1, k2) -> k1)));
            }
        }
        return pushKeepAccountsEoMap;
    }

    @Override
    public Map<String, List<KeepAccountsDetailEo>> getKeepAccountDetailByChargeCodes(List<String> chargeCodes) {
        HashMap keepAccountsDetailEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(chargeCodes)) {
            List keepAccountsDetailEos;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > 200; length -= 200) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 200))).eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode())).list();
                keepAccountsDetailEoMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode)));
                i += 200;
            }
            if (length > 0) {
                keepAccountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).eq((Object)"book_keeping", (Object)BookKeepingType.NOT_DEAL.getCode())).list();
                keepAccountsDetailEoMap.putAll(keepAccountsDetailEos.stream().collect(Collectors.groupingBy(KeepAccountsDetailEo::getChargeCode)));
            }
        }
        return keepAccountsDetailEoMap;
    }

    @Override
    public Map<String, List<KeepDetailMappingEo>> getKeepDetailMappingByChargeCodes(List<String> chargeCodes) {
        HashMap keepDetailMappingEoListMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(chargeCodes)) {
            List keepDetailMappingEos;
            int length;
            int i = 0;
            for (length = chargeCodes.size(); length > 200; length -= 200) {
                keepDetailMappingEos = ((ExtQueryChainWrapper)this.keepDetailMappingDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + 200))).list();
                keepDetailMappingEoListMap.putAll(keepDetailMappingEos.stream().collect(Collectors.groupingBy(KeepDetailMappingEo::getChargeCode)));
                i += 200;
            }
            if (length > 0) {
                keepDetailMappingEos = ((ExtQueryChainWrapper)this.keepDetailMappingDas.filter().in((Object)"charge_code", chargeCodes.subList(i, i + length))).list();
                keepDetailMappingEoListMap.putAll(keepDetailMappingEos.stream().collect(Collectors.groupingBy(KeepDetailMappingEo::getChargeCode)));
            }
        }
        return keepDetailMappingEoListMap;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void dealHdKeepTimeoutData() {
    }

    @Override
    public void dealHckTimeOutKeep(List<String> chargeCodes) {
        PageInfo pageInfo;
        this.logger.info("\u67e5\u8be2\u8d85\u65f6\u8bb0\u8d26\u5355");
        ExtQueryChainWrapper sqlFilters = this.keepTimeOutDas.filter();
        Integer pageNum = 1;
        sqlFilters.eq((Object)"status", (Object)1);
        if (CollectionUtils.isNotEmpty(chargeCodes)) {
            sqlFilters.in((Object)"charge_code", chargeCodes);
        }
        this.logger.info("\u67e5\u8be2\u8d85\u65f6\u8bb0\u8d26\u5355pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(pageInfo = sqlFilters.page(pageNum, Integer.valueOf(1000))) ? Integer.valueOf(pageInfo.getPages()) : null);
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            List<String> codes = pageInfo.getList().stream().map(KeepTimeOutEo::getChargeCode).distinct().collect(Collectors.toList());
            this.dealTimeOutAccounting(codes);
        }
        for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), Integer.valueOf(1000));
            this.logger.info("\u67e5\u8be2\u8ba2\u5355pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(eoPageInfo) ? Integer.valueOf(eoPageInfo.getPages()) : null);
            if (!Objects.nonNull(eoPageInfo) || !CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) continue;
            List<String> codes = eoPageInfo.getList().stream().map(KeepTimeOutEo::getChargeCode).distinct().collect(Collectors.toList());
            this.dealTimeOutAccounting(codes);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void dealTimeOutAccounting(List<String> chargeCodes) {
    }

    private static Map<String, String> getXSCKNumber(JSONObject jsonObject) {
        String xsckNumber = null;
        StringBuffer buffer = new StringBuffer();
        String message = null;
        List datas = com.dtyunxi.huieryun.core.util.JSON.parseList((String)jsonObject.getString("data"), JSONObject.class);
        if (CollectionUtils.isNotEmpty((Collection)datas)) {
            for (JSONObject data : datas) {
                String number = data.getString("Number");
                if (StrUtil.isNotBlank((CharSequence)number) && number.startsWith("XS")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u9500\u552e\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (StrUtil.isNotBlank((CharSequence)number) && !number.startsWith("XS")) {
                    buffer.append(number);
                    buffer.append(";");
                    message = "\u91d1\u8776\u9500\u552e\u8ba2\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!StrUtil.isNotBlank((CharSequence)number) || !StrUtil.isBlank((CharSequence)xsckNumber)) continue;
                if (number.startsWith("QTCK")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5176\u4ed6\u51fa\u5e93\u5355\u521b\u5efa\u6210\u529f";
                }
                if (number.startsWith("FBDC")) {
                    xsckNumber = number;
                    message = "\u91d1\u8776\u5206\u6b65\u5f0f\u8c03\u51fa\u5355\u521b\u5efa\u6210\u529f";
                }
                if (!number.startsWith("ZJDB")) continue;
                xsckNumber = number;
                message = "\u91d1\u8776\u76f4\u63a5\u8c03\u62e8\u5355\u521b\u5efa\u6210\u529f";
            }
        }
        message = StrUtil.isNotBlank(message) ? message : "\u91d1\u8776\u7cfb\u7edf\u5355\u53f7\u83b7\u53d6\u5931\u8d25";
        HashMap<String, String> xsckResult = new HashMap<String, String>();
        xsckResult.put("xsckNumber", xsckNumber);
        xsckResult.put("saleNo", StringUtils.isNotBlank((CharSequence)buffer) ? buffer.deleteCharAt(buffer.toString().length() - 1).toString() : null);
        xsckResult.put("message", message);
        return xsckResult;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteTimeOutAccounting(List<String> chargeCodes) {
        this.keepTimeOutService.removeKeepByChargeCodes(chargeCodes);
    }
}

