/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.ItemDgConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IItemDgDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IItemSkuDgDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IUnitDgDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ItemDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRateDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.eo.ItemDgEo;
import com.yunxi.dg.base.center.finance.eo.ItemSkuDgEo;
import com.yunxi.dg.base.center.finance.eo.UnitDgEo;
import com.yunxi.dg.base.center.finance.service.entity.IItemDgService;
import com.yunxi.dg.base.center.item.domain.entity.IItemInvoiceDomain;
import com.yunxi.dg.base.center.item.eo.ItemInvoiceEo;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ItemDgServiceImpl
extends BaseServiceImpl<ItemDgDto, ItemDgEo, IItemDgDomain>
implements IItemDgService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IItemSkuDgDomain itemSkuDgDomain;
    @Resource
    private IItemInvoiceDomain iItemInvoiceDomain;
    @Resource
    private IUnitDgDomain unitDgDomain;

    public ItemDgServiceImpl(IItemDgDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ItemDgDto, ItemDgEo> converter() {
        return ItemDgConverter.INSTANCE;
    }

    @Override
    public List<ItemSkuDgDto> queryItemInfoBySkuCode(List<String> skuCodeList) {
        List unitDgEoList;
        if (CollUtil.isEmpty(skuCodeList)) {
            this.logger.info("\u67e5\u8be2sku\u7f16\u7801\u5165\u53c2\u4e3a\u7a7a");
            return Lists.newArrayList();
        }
        List skuDgEoList = ((ExtQueryChainWrapper)this.itemSkuDgDomain.filter().in((Object)"code", skuCodeList)).list();
        if (CollectionUtils.isEmpty((Collection)skuDgEoList)) {
            return new ArrayList<ItemSkuDgDto>();
        }
        List itemIdList = skuDgEoList.stream().map(ItemSkuDgEo::getItemId).distinct().collect(Collectors.toList());
        Set unitCodeList = skuDgEoList.stream().filter(sku -> StrUtil.isNotEmpty((CharSequence)sku.getSaleUnit())).map(ItemSkuDgEo::getSaleUnit).collect(Collectors.toSet());
        List itemList = ((ExtQueryChainWrapper)((IItemDgDomain)this.domain).filter().in((Object)"id", itemIdList)).list();
        Map itemMap = ((List)Optional.ofNullable(itemList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
        Map<Object, Object> unitDgEoMap = Maps.newHashMap();
        if (CollUtil.isNotEmpty(unitCodeList) && CollUtil.isNotEmpty((Collection)(unitDgEoList = ((ExtQueryChainWrapper)this.unitDgDomain.filter().in((Object)"code", unitCodeList)).list()))) {
            unitDgEoMap = unitDgEoList.stream().collect(Collectors.toMap(UnitDgEo::getCode, Function.identity(), (v1, v2) -> v1));
        }
        List itemRateDgEoList = ((ExtQueryChainWrapper)this.iItemInvoiceDomain.filter().in((Object)"item_code", skuCodeList)).list();
        Map itemRateMap = ((List)Optional.ofNullable(itemRateDgEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemInvoiceEo::getItemCode, Function.identity(), (v1, v2) -> v2));
        ArrayList<ItemSkuDgDto> itemSkuDgDtoList = new ArrayList<ItemSkuDgDto>();
        Map finalItemRateMap = itemRateMap;
        Map<Object, Object> finalUnitDgEoMap = unitDgEoMap;
        skuDgEoList.forEach(sku -> {
            ItemSkuDgDto itemSkuDgDto = new ItemSkuDgDto();
            CubeBeanUtils.copyProperties((Object)itemSkuDgDto, (Object)sku, (String[])new String[0]);
            ItemInvoiceEo itemRateDgEo = finalItemRateMap.getOrDefault(sku.getCode(), new ItemInvoiceEo());
            ItemRateDgDto rateDgDto = new ItemRateDgDto();
            rateDgDto.setRate(itemRateDgEo.getTaxRate());
            rateDgDto.setCode(itemRateDgEo.getTaxCategoryCode());
            rateDgDto.setName(itemRateDgEo.getItemName());
            rateDgDto.setId(itemRateDgEo.getId());
            itemSkuDgDto.setItemRateDgDto(rateDgDto);
            itemSkuDgDto.setThirdCode(itemRateDgEo.getThirdCode());
            itemSkuDgDto.setEnergyEfficiencyRating(itemRateDgEo.getEnergyEfficiencyRating());
            itemSkuDgDto.setSpecialInvoiceRemark(itemRateDgEo.getSpecialInvoiceRemark());
            if (finalUnitDgEoMap.containsKey(sku.getSaleUnit())) {
                itemSkuDgDto.setSaleUnitName(((UnitDgEo)finalUnitDgEoMap.get(sku.getSaleUnit())).getName());
            }
            if (itemMap.containsKey(sku.getItemId())) {
                ItemDgEo itemDgEo = (ItemDgEo)itemMap.get(sku.getItemId());
                ItemDgDto itemDgDto = new ItemDgDto();
                CubeBeanUtils.copyProperties((Object)itemDgDto, (Object)itemDgEo, (String[])new String[0]);
                itemSkuDgDto.setItemDgDto(itemDgDto);
            }
            itemSkuDgDtoList.add(itemSkuDgDto);
        });
        return itemSkuDgDtoList;
    }
}

