/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.dto.entity.DgCustomerAreaSubTreeReqDto;
import com.yunxi.dg.base.center.customer.dto.entity.DgCustomerAreaTreeRespDto;
import com.yunxi.dg.base.center.finance.convert.entity.ReconciliationRuleConverter;
import com.yunxi.dg.base.center.finance.dao.das.ICsCustomerAreaDas;
import com.yunxi.dg.base.center.finance.dao.das.ICustomerDas;
import com.yunxi.dg.base.center.finance.dao.das.IReconciliationDataRangeDas;
import com.yunxi.dg.base.center.finance.dao.das.IReconciliationRejectCustomerDas;
import com.yunxi.dg.base.center.finance.dao.das.IReconciliationShopCustomerDas;
import com.yunxi.dg.base.center.finance.domain.entity.ICustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationCustomerConditionDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationRuleDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.CustomerConditionAddReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationDataRangeDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationRuleDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationRulePageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationRuleReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationShopCustomerDto;
import com.yunxi.dg.base.center.finance.dto.entity.RelationCustomerInfoVo;
import com.yunxi.dg.base.center.finance.dto.enums.CustomerShopEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.response.CustomerConditionRespDto;
import com.yunxi.dg.base.center.finance.dto.response.CustomerInfoDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationRejectCustomerRespDto;
import com.yunxi.dg.base.center.finance.dto.response.ReconciliationRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.CsCustomerAreaEo;
import com.yunxi.dg.base.center.finance.eo.CustomerEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationCustomerConditionEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationDataRangeEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRejectCustomerEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationRuleEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationShopCustomerEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationRuleService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ReconciliationRuleServiceImpl
extends BaseServiceImpl<ReconciliationRuleDto, ReconciliationRuleEo, IReconciliationRuleDomain>
implements IReconciliationRuleService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationRuleServiceImpl.class);
    @Resource
    private IReconciliationDataRangeDas dataRangeDas;
    @Resource
    private IReconciliationShopCustomerDas shopCustomerDas;
    @Resource
    private IReconciliationCustomerConditionDomain customerConditionDomain;
    @Resource
    private ICsCustomerAreaDas customerAreaDas;
    @Resource
    private ICustomerDas customerDas;
    @Resource
    private IReconciliationRejectCustomerDas rejectCustomerDas;
    @Resource
    private IShopDomain shopDomain;
    @Resource
    private ICustomerDomain customerDomain;

    public ReconciliationRuleServiceImpl(IReconciliationRuleDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReconciliationRuleDto, ReconciliationRuleEo> converter() {
        return ReconciliationRuleConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Long> saveOrUpdate(ReconciliationRuleReqDto dto) {
        List shopCustomerEoList;
        IGenerateCodeService generateCodeService;
        List ruleEoList;
        log.info("\u65b0\u589e\u5bf9\u8d26\u89c4\u5219\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        AssertUtils.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
        this.validateRule(dto);
        String ruleCode = null;
        ReconciliationRuleEo ruleEo = new ReconciliationRuleEo();
        boolean updateFlag = Objects.nonNull(dto.getReconciliationRuleDto().getId());
        if (updateFlag) {
            ruleEo = (ReconciliationRuleEo)((ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().eq((Object)"id", (Object)dto.getReconciliationRuleDto().getId())).one();
            if (Objects.nonNull(ruleEo)) {
                ruleCode = ruleEo.getRuleCode();
            } else {
                ruleEoList = ((ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().eq((Object)"rule_name", (Object)dto.getReconciliationRuleDto().getRuleName())).list();
                AssertUtils.isFalse((boolean)CollUtil.isNotEmpty((Collection)ruleEoList), (String)"\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728");
                generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_RECONCILIATION.getCode());
                ruleCode = generateCodeService.getCode("RC");
                updateFlag = false;
                ruleEo = new ReconciliationRuleEo();
            }
        } else {
            ruleEoList = ((ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().eq((Object)"rule_name", (Object)dto.getReconciliationRuleDto().getRuleName())).list();
            AssertUtils.isFalse((boolean)CollUtil.isNotEmpty((Collection)ruleEoList), (String)"\u89c4\u5219\u540d\u79f0\u5df2\u5b58\u5728");
            generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_RECONCILIATION.getCode());
            ruleCode = generateCodeService.getCode("RC");
        }
        String finalRuleCode = ruleCode;
        dto.getDataRangeDtos().forEach(v -> {
            v.setRuleCode(finalRuleCode);
            v.setRuleName(dto.getReconciliationRuleDto().getRuleName());
        });
        CubeBeanUtils.copyProperties((Object)ruleEo, (Object)dto.getReconciliationRuleDto(), (String[])new String[0]);
        ruleEo.setRuleCode(ruleCode);
        if (updateFlag) {
            ((IReconciliationRuleDomain)this.domain).updateSelective((BaseEo)ruleEo);
        } else {
            ((IReconciliationRuleDomain)this.domain).insert((BaseEo)ruleEo);
        }
        List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDas.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
        if (CollectionUtils.isNotEmpty((Collection)dataRangeEoList)) {
            List dataRangeIds = dataRangeEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.dataRangeDas.logicDeleteByIds(dataRangeIds);
        }
        ArrayList reconciliationDataRangeEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)reconciliationDataRangeEos, (Collection)dto.getDataRangeDtos(), ReconciliationDataRangeEo.class);
        this.dataRangeDas.insertBatch((List)reconciliationDataRangeEos);
        if (null != dto.getReconciliationRuleDto().getApplicableShopRange() && 1 == dto.getReconciliationRuleDto().getApplicableShopRange()) {
            if (CollectionUtils.isEmpty((Collection)dto.getShopCustomerDtos())) {
                throw new BizException("\u6307\u5b9a\u5e97\u94fa\u8303\u56f4\u4e3a\u7a7a!");
            }
            List<ReconciliationShopCustomerDto> collect = dto.getShopCustomerDtos().stream().filter(x -> 0 == x.getApplicableRange()).collect(Collectors.toList());
            collect.forEach(v -> {
                v.setRuleCode(finalRuleCode);
                v.setRuleName(dto.getReconciliationRuleDto().getRuleName());
                v.setApplicableRange(Integer.valueOf(0));
            });
            List shopCustomerEoList2 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDas.filter().eq((Object)"rule_code", (Object)ruleCode)).eq((Object)"applicable_range", (Object)0)).list();
            if (CollectionUtils.isNotEmpty((Collection)shopCustomerEoList2)) {
                List shopCustomerIds = shopCustomerEoList2.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.shopCustomerDas.logicDeleteByIds(shopCustomerIds);
            }
            ArrayList reconciliationShopCustomerEos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)reconciliationShopCustomerEos, collect, ReconciliationShopCustomerEo.class);
            this.shopCustomerDas.insertBatch((List)reconciliationShopCustomerEos);
        } else if (null != dto.getReconciliationRuleDto().getApplicableShopRange() && 0 == dto.getReconciliationRuleDto().getApplicableShopRange() && CollectionUtils.isNotEmpty((Collection)(shopCustomerEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDas.filter().eq((Object)"rule_code", (Object)ruleCode)).eq((Object)"applicable_range", (Object)0)).list()))) {
            List shopCustomerIds = shopCustomerEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
            this.shopCustomerDas.logicDeleteByIds(shopCustomerIds);
        }
        ReconciliationCustomerConditionEo customerConditionEo = this.getCustomerConditionEo(ruleCode, dto.getReconciliationRuleDto().getId());
        List<Object> reconciliationRejectCustomerEos = ListUtil.toList((Object[])new ReconciliationRejectCustomerEo[0]);
        if (null != dto.getReconciliationRuleDto().getApplicableCustomerRange()) {
            List shopCustomerEoList3;
            if (Convert.toInt((Object)CustomerShopEnum.CUSTOMER_SPECIFIED_ENUM.getType()).equals(dto.getReconciliationRuleDto().getApplicableCustomerRange())) {
                List customerConditionEos;
                if (CollectionUtils.isEmpty((Collection)dto.getShopCustomerDtos())) {
                    throw new BizException("\u6307\u5b9a\u5ba2\u6237\u8303\u56f4\u4e3a\u7a7a!");
                }
                List<ReconciliationShopCustomerDto> collect = dto.getShopCustomerDtos().stream().filter(x -> 1 == x.getApplicableRange()).collect(Collectors.toList());
                collect.forEach(v -> {
                    v.setRuleCode(finalRuleCode);
                    v.setRuleName(dto.getReconciliationRuleDto().getRuleName());
                    v.setApplicableRange(Integer.valueOf(1));
                });
                List shopCustomerEoList4 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDas.filter().eq((Object)"rule_code", (Object)ruleCode)).eq((Object)"applicable_range", (Object)1)).list();
                if (CollectionUtils.isNotEmpty((Collection)shopCustomerEoList4)) {
                    List shopCustomerIds = shopCustomerEoList4.stream().map(BaseEo::getId).collect(Collectors.toList());
                    this.shopCustomerDas.logicDeleteByIds(shopCustomerIds);
                }
                ArrayList reconciliationShopCustomerEos = Lists.newArrayList();
                CubeBeanUtils.copyCollection((Collection)reconciliationShopCustomerEos, collect, ReconciliationShopCustomerEo.class);
                this.shopCustomerDas.insertBatch((List)reconciliationShopCustomerEos);
                if (updateFlag && CollectionUtils.isNotEmpty((Collection)(customerConditionEos = ((ExtQueryChainWrapper)this.customerConditionDomain.filter().eq((Object)"rule_code", (Object)ruleCode)).list()))) {
                    customerConditionEos.forEach(del -> this.customerConditionDomain.logicDeleteById(del.getId()));
                }
            }
            if (Convert.toInt((Object)CustomerShopEnum.CUSTOMER_RANGE_ENUM.getType()).equals(dto.getReconciliationRuleDto().getApplicableCustomerRange())) {
                CustomerConditionAddReqDto customerConditionReqDto = dto.getCustomerConditionReqDto();
                AssertUtils.notNull((Object)customerConditionReqDto, (String)"\u5ba2\u6237\u8303\u56f4\u4e3a\u7a7a");
                List customerTypeIds = customerConditionReqDto.getCustomerTypeIds();
                List customerAreaCodes = customerConditionReqDto.getCustomerAreaCodes();
                List customerLevelIds = customerConditionReqDto.getCustomerLevelIds();
                List customerGroupIds = customerConditionReqDto.getCustomerGroupIds();
                List rejectCustomerIdList = dto.getRejectCustomerIdList();
                AssertUtils.isFalse((CollUtil.isEmpty((Collection)customerTypeIds) && CollUtil.isEmpty((Collection)customerGroupIds) && CollUtil.isEmpty((Collection)customerAreaCodes) && CollUtil.isEmpty((Collection)customerLevelIds) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u8303\u56f4\u4e3a\u7a7a");
                RelationCustomerInfoVo relationCustomerInfo = new RelationCustomerInfoVo();
                customerConditionEo = this.getCustomerConditionEo(customerConditionEo);
                this.buildCustomerAreaLimit(customerConditionEo, relationCustomerInfo, customerAreaCodes);
                this.buildCustomerTypeLimit(customerConditionEo, relationCustomerInfo, customerTypeIds);
                this.buildCustomerLevelLimit(customerConditionEo, relationCustomerInfo, customerLevelIds);
                this.buildCustomerGroupLimit(customerConditionEo, relationCustomerInfo, customerGroupIds);
                reconciliationRejectCustomerEos = this.getPriceRejectCustomerEos(ruleCode, dto.getReconciliationRuleDto().getRuleName(), reconciliationRejectCustomerEos, relationCustomerInfo, rejectCustomerIdList);
                this.savePriceCustomerCondition(dto.getReconciliationRuleDto().getId(), ruleCode, dto.getReconciliationRuleDto().getRuleName(), customerConditionEo);
                this.savePriceRejectCustomer(dto.getReconciliationRuleDto().getId(), ruleCode, dto.getReconciliationRuleDto().getRuleName(), reconciliationRejectCustomerEos);
            }
            if (Convert.toInt((Object)CustomerShopEnum.CUSTOMER_ALL_ENUM.getType()).equals(dto.getReconciliationRuleDto().getApplicableCustomerRange()) && CollectionUtils.isNotEmpty((Collection)(shopCustomerEoList3 = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.shopCustomerDas.filter().eq((Object)"rule_code", (Object)ruleCode)).eq((Object)"applicable_range", (Object)1)).list()))) {
                List shopCustomerIds = shopCustomerEoList3.stream().map(BaseEo::getId).collect(Collectors.toList());
                this.shopCustomerDas.logicDeleteByIds(shopCustomerIds);
            }
        }
        return new RestResponse((Object)ruleEo.getId());
    }

    private void savePriceCustomerCondition(Long id, String ruleCode, String ruleName, ReconciliationCustomerConditionEo customerConditionEo) {
        if (Objects.nonNull(customerConditionEo)) {
            customerConditionEo.setRuleCode(ruleCode);
            customerConditionEo.setRuleName(ruleName);
            customerConditionEo.setDr(0);
            if (Objects.isNull(customerConditionEo.getId())) {
                this.customerConditionDomain.insert((BaseEo)customerConditionEo);
            } else {
                this.customerConditionDomain.update((BaseEo)customerConditionEo);
            }
        }
    }

    private void savePriceRejectCustomer(Long id, String ruleCode, String ruleName, List<ReconciliationRejectCustomerEo> reconciliationRejectCustomerEos) {
        if (Objects.nonNull(id)) {
            ReconciliationRejectCustomerEo rejectCustomerEo = new ReconciliationRejectCustomerEo();
            rejectCustomerEo.setRuleCode(ruleCode);
            List delList = this.rejectCustomerDas.selectList((BaseEo)rejectCustomerEo);
            if (CollUtil.isNotEmpty((Collection)delList)) {
                delList.forEach(del -> this.rejectCustomerDas.logicDeleteById(del.getId()));
            }
        }
        if (CollUtil.isNotEmpty(reconciliationRejectCustomerEos)) {
            reconciliationRejectCustomerEos.forEach(info -> {
                info.setRuleCode(ruleCode);
                info.setRuleName(ruleName);
            });
            this.rejectCustomerDas.insertBatch(reconciliationRejectCustomerEos);
        }
    }

    private ReconciliationCustomerConditionEo getCustomerConditionEo(ReconciliationCustomerConditionEo customerConditionEo) {
        if (Objects.isNull(customerConditionEo)) {
            customerConditionEo = new ReconciliationCustomerConditionEo();
        }
        return customerConditionEo;
    }

    private ReconciliationCustomerConditionEo getCustomerConditionEo(String ruleCode, Long id) {
        ReconciliationCustomerConditionEo customerConditionEo = null;
        if (Objects.nonNull(id)) {
            customerConditionEo = new ReconciliationCustomerConditionEo();
            customerConditionEo.setRuleCode(ruleCode);
            customerConditionEo = (ReconciliationCustomerConditionEo)this.customerConditionDomain.selectOne((BaseEo)customerConditionEo);
        } else {
            customerConditionEo = new ReconciliationCustomerConditionEo();
        }
        return customerConditionEo;
    }

    private void buildCustomerAreaLimit(ReconciliationCustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerAreaCodes) {
        if (CollUtil.isNotEmpty(customerAreaCodes)) {
            customerConditionEo.setCustomerAreaCodes(customerAreaCodes.stream().distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerAreaCodeNum(Integer.valueOf(customerConditionEo.getCustomerAreaCodes().split(",").length));
            List<String> subAreaCodes = this.getSubCustAreaIds(customerAreaCodes);
            customerConditionEo.setCustomerAreaCodeExt(CollUtil.isNotEmpty(subAreaCodes) ? String.join((CharSequence)",", subAreaCodes) : null);
        } else {
            customerConditionEo.setCustomerAreaCodes(null);
            customerConditionEo.setCustomerAreaCodeExt(null);
        }
    }

    public List<String> getSubCustAreaIds(List<String> parentAreaIds) {
        if (CollUtil.isEmpty(parentAreaIds)) {
            return ListUtil.empty();
        }
        ArrayList<String> result = new ArrayList<String>();
        DgCustomerAreaSubTreeReqDto reqDto = new DgCustomerAreaSubTreeReqDto();
        parentAreaIds.forEach(topId -> {
            reqDto.setId(Long.valueOf(Long.parseLong(topId)));
            DgCustomerAreaTreeRespDto dgCustomerAreaTreeRespDto = this.queryForSubTreePost(reqDto);
            if (Objects.nonNull(dgCustomerAreaTreeRespDto)) {
                result.add(String.valueOf(dgCustomerAreaTreeRespDto.getId()));
                if (CollUtil.isNotEmpty((Collection)dgCustomerAreaTreeRespDto.getChildren())) {
                    dgCustomerAreaTreeRespDto.getChildren().stream().map(a -> String.valueOf(a.getId())).forEach(result::add);
                }
            }
        });
        return result;
    }

    private DgCustomerAreaTreeRespDto queryForSubTreePost(DgCustomerAreaSubTreeReqDto customerAreaSubTreeReqDto) {
        CsCustomerAreaEo customerAreaEo = new CsCustomerAreaEo();
        CubeBeanUtils.copyProperties((Object)customerAreaEo, (Object)customerAreaSubTreeReqDto, (String[])new String[0]);
        customerAreaEo = (CsCustomerAreaEo)this.customerAreaDas.selectOne((BaseEo)customerAreaEo);
        if (Objects.isNull(customerAreaEo)) {
            return null;
        }
        DgCustomerAreaTreeRespDto customerAreaTreeRespDto = (DgCustomerAreaTreeRespDto)customerAreaEo.toDto(DgCustomerAreaTreeRespDto.class);
        List<CsCustomerAreaEo> list = this.getCustomerArea(customerAreaEo.getTopId(), customerAreaEo.getLevel());
        customerAreaTreeRespDto.setChildren(this.getTreeList(list, customerAreaTreeRespDto.getCode()));
        return customerAreaTreeRespDto;
    }

    private List<CsCustomerAreaEo> getCustomerArea(Long topId, Integer level) {
        CsCustomerAreaEo subCustomerAreaEo = new CsCustomerAreaEo();
        subCustomerAreaEo.setDr(0);
        subCustomerAreaEo.setTopId(topId);
        QueryWrapper queryWrapper = new QueryWrapper((Object)subCustomerAreaEo);
        queryWrapper.gt((Object)"level", (Object)level);
        queryWrapper.orderByAsc((Object)"sort");
        List list = this.customerAreaDas.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    private List<DgCustomerAreaTreeRespDto> getTreeList(List<CsCustomerAreaEo> areaList, String parentCode) {
        ArrayList<DgCustomerAreaTreeRespDto> areaTreeRespDtoList = new ArrayList<DgCustomerAreaTreeRespDto>();
        Map<String, List<CsCustomerAreaEo>> areaMap = areaList.stream().sorted(Comparator.comparing(CsCustomerAreaEo::getSort)).collect(Collectors.groupingBy(CsCustomerAreaEo::getParentCode));
        DtoHelper.eoList2DtoList((Collection)areaMap.get(parentCode), areaTreeRespDtoList, DgCustomerAreaTreeRespDto.class);
        areaMap.remove(parentCode);
        this.getChildArea(areaTreeRespDtoList, areaMap);
        return areaTreeRespDtoList;
    }

    private void getChildArea(List<DgCustomerAreaTreeRespDto> areaGroupTreeRespDtoList, Map<String, List<CsCustomerAreaEo>> areaGroupMap) {
        areaGroupTreeRespDtoList.forEach(areaGroupTreeDto -> {
            List areaGroupEoList = (List)areaGroupMap.get(areaGroupTreeDto.getCode());
            if (CollectionUtils.isNotEmpty((Collection)areaGroupEoList)) {
                List<DgCustomerAreaTreeRespDto> areaGroupChildrenDtoList = areaGroupEoList.stream().sorted(Comparator.comparing(CsCustomerAreaEo::getSort)).map(item -> (DgCustomerAreaTreeRespDto)item.toDto(DgCustomerAreaTreeRespDto.class)).collect(Collectors.toList());
                areaGroupTreeDto.setChildren(areaGroupChildrenDtoList);
                areaGroupMap.remove(areaGroupTreeDto.getCode());
                this.getChildArea(areaGroupChildrenDtoList, areaGroupMap);
            }
        });
    }

    private void buildCustomerTypeLimit(ReconciliationCustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerTypeIds) {
        if (CollUtil.isNotEmpty(customerTypeIds)) {
            customerConditionEo.setCustomerTypeIds(customerTypeIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerTypeIdNum(Integer.valueOf(customerConditionEo.getCustomerTypeIds().split(",").length));
        } else {
            customerConditionEo.setCustomerTypeIds(null);
        }
    }

    private void buildCustomerLevelLimit(ReconciliationCustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerLevelIds) {
        if (CollUtil.isNotEmpty(customerLevelIds)) {
            customerConditionEo.setCustomerLevelIds(customerLevelIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerLevelIdNum(Integer.valueOf(customerConditionEo.getCustomerLevelIds().split(",").length));
        } else {
            customerConditionEo.setCustomerLevelIds(null);
        }
    }

    private void buildCustomerGroupLimit(ReconciliationCustomerConditionEo customerConditionEo, RelationCustomerInfoVo relationCustomerInfo, List<String> customerGroupIds) {
        if (CollUtil.isNotEmpty(customerGroupIds)) {
            customerConditionEo.setCustomerGroupIds(customerGroupIds.stream().filter(Objects::nonNull).distinct().collect(Collectors.joining(",")));
            relationCustomerInfo.setCustomerGroupIdNum(Integer.valueOf(customerConditionEo.getCustomerGroupIds().split(",").length));
        } else {
            customerConditionEo.setCustomerGroupIds(null);
        }
    }

    private List<ReconciliationRejectCustomerEo> getPriceRejectCustomerEos(String ruleCode, String ruleName, List<ReconciliationRejectCustomerEo> priceRejectCustomerlist, RelationCustomerInfoVo relationCustomerInfo, List<Long> rejectCustomerIdList) {
        if (CollUtil.isNotEmpty(rejectCustomerIdList)) {
            Map<Long, CustomerEo> customerMap = this.getCustomerMap(rejectCustomerIdList);
            priceRejectCustomerlist = rejectCustomerIdList.stream().map(customerId -> {
                ReconciliationRejectCustomerEo rejectCustomerEo = new ReconciliationRejectCustomerEo();
                rejectCustomerEo.setCustomerId(customerId);
                rejectCustomerEo.setDr(0);
                rejectCustomerEo.setRuleCode(ruleCode);
                rejectCustomerEo.setRuleName(ruleName);
                if (customerMap.containsKey(customerId)) {
                    CustomerEo customerRespDto = (CustomerEo)customerMap.get(customerId);
                    rejectCustomerEo.setCustomerCode(customerRespDto.getCode());
                    rejectCustomerEo.setCustomerName(customerRespDto.getName());
                }
                return rejectCustomerEo;
            }).collect(Collectors.toList());
            relationCustomerInfo.setRejectCustomerCount(Integer.valueOf(rejectCustomerIdList.size()));
        }
        return priceRejectCustomerlist;
    }

    private Map<Long, CustomerEo> getCustomerMap(List<Long> rejectCustomerIdList) {
        List dgCustomerInfoRespDtos = ((ExtQueryChainWrapper)this.customerDas.filter().in((Object)"id", rejectCustomerIdList)).list();
        if (CollUtil.isEmpty((Collection)dgCustomerInfoRespDtos)) {
            return MapUtil.empty();
        }
        return dgCustomerInfoRespDtos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o1, o2) -> o2));
    }

    private void validateRule(ReconciliationRuleReqDto dto) {
        ReconciliationRuleDto ruleDto = dto.getReconciliationRuleDto();
        AssertUtils.notNull((Object)ruleDto.getRuleName(), (String)"\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u4e3a\u7a7a");
        AssertUtils.notNull((Object)ruleDto.getEffectBeginTime(), (String)"\u751f\u6548\u5f00\u59cb\u65f6\u95f4");
        if (null == ruleDto.getEffect()) {
            ruleDto.setEffect(Integer.valueOf(0));
        }
        if (null != ruleDto.getEffect() && 0 == ruleDto.getEffect()) {
            AssertUtils.notNull((Object)ruleDto.getEffectEndTime(), (String)"\u751f\u6548\u7ed3\u675f\u65f6\u95f4");
        }
        AssertUtils.notNull((Object)ruleDto.getBillCycle(), (String)"\u8d26\u5355\u5468\u671f\u4e3a\u7a7a");
        AssertUtils.notNull((Object)ruleDto.getBillDay(), (String)"\u8d26\u5355\u65e5");
        AssertUtils.notNull((Object)ruleDto.getConfirmBillDay(), (String)"\u786e\u8ba4\u8d26\u5355\u65e5");
        AssertUtils.isFalse((boolean)CollUtil.isEmpty((Collection)dto.getDataRangeDtos()), (String)"\u5bf9\u8d26\u6570\u636e\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a");
        if (ruleDto.getRuleName().length() > 100) {
            throw new BizException("\u5bf9\u8d26\u89c4\u5219\u540d\u79f0\u957f\u5ea6\u4e0d\u80fd\u5927\u4e8e50");
        }
    }

    @Override
    public RestResponse<PageInfo<ReconciliationRuleDto>> queryPage(ReconciliationRulePageReqDto dto) {
        log.info("\u5bf9\u8d26\u89c4\u5219\u914d\u7f6e-\u5217\u8868\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtils.isTrue((Objects.nonNull(pageNum) && pageNum > 0 ? 1 : 0) != 0, (String)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtils.isTrue((Objects.nonNull(pageSize) && pageSize > 0 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper sqlFilters = (ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().orderByDesc((Object)"id");
        if (StringUtils.isNotBlank((CharSequence)dto.getRuleCode())) {
            sqlFilters.like((Object)"rule_code", (Object)dto.getRuleCode());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRuleName())) {
            sqlFilters.like((Object)"rule_name", (Object)dto.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEffectBeginTime())) {
            sqlFilters.ge((Object)"effect_begin_time", (Object)dto.getEffectBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEffectEndTime())) {
            sqlFilters.le((Object)"effect_end_time", (Object)dto.getEffectEndTime());
        }
        PageInfo eoPageInfo = sqlFilters.page(dto.getPageNum(), dto.getPageSize());
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, ReconciliationRuleDto.class);
        if (CollectionUtils.isNotEmpty(dtoList)) {
            dtoList.forEach(v -> {
                if (null != v.getEffect() && 1 == v.getEffect()) {
                    v.setEffectEndTime(null);
                }
            });
        }
        dtoPageInfo.setList(dtoList);
        return new RestResponse((Object)dtoPageInfo);
    }

    @Override
    public RestResponse<ReconciliationRuleRespDto> detail(Long id) {
        ReconciliationRuleRespDto ruleRespDto = new ReconciliationRuleRespDto();
        ReconciliationRuleEo ruleEo = (ReconciliationRuleEo)((ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AssertUtils.notNull((Object)ruleEo, (String)"\u5bf9\u8d26\u89c4\u5219\u4e0d\u5b58\u5728");
        ReconciliationRuleDto reconciliationRuleDto = new ReconciliationRuleDto();
        CubeBeanUtils.copyProperties((Object)reconciliationRuleDto, (Object)ruleEo, (String[])new String[0]);
        ruleRespDto.setReconciliationRuleDto(reconciliationRuleDto);
        List dataRangeEoList = ((ExtQueryChainWrapper)this.dataRangeDas.filter().eq((Object)"rule_code", (Object)ruleEo.getRuleCode())).list();
        ArrayList dataRangeDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)dataRangeDtos, (Collection)dataRangeEoList, ReconciliationDataRangeDto.class);
        ruleRespDto.setDataRangeDtos((List)dataRangeDtos);
        ArrayList shopCustomerDtos = Lists.newArrayList();
        List shopCustomerEos = ((ExtQueryChainWrapper)this.shopCustomerDas.filter().eq((Object)"rule_code", (Object)ruleEo.getRuleCode())).list();
        CubeBeanUtils.copyCollection((Collection)shopCustomerDtos, (Collection)shopCustomerEos, ReconciliationShopCustomerDto.class);
        List<String> shopCodes = shopCustomerDtos.stream().map(ReconciliationShopCustomerDto::getShopCode).distinct().collect(Collectors.toList());
        List<String> customerCodes = shopCustomerDtos.stream().map(ReconciliationShopCustomerDto::getCustomerCode).distinct().collect(Collectors.toList());
        Map<String, ShopEo> shopEoMap = this.getShop(shopCodes);
        Map<String, CustomerEo> customerEoMap = this.getCustomer(customerCodes);
        shopCustomerDtos.forEach(v -> {
            v.setRuleId(ruleEo.getId());
            if (shopEoMap.containsKey(v.getShopCode())) {
                ShopEo shopEo = (ShopEo)shopEoMap.get(v.getShopCode());
                v.setShopId(Objects.nonNull(shopEo) ? shopEo.getId() : null);
            }
            if (customerEoMap.containsKey(v.getCustomerCode())) {
                CustomerEo customerEo = (CustomerEo)customerEoMap.get(v.getCustomerCode());
                v.setCustomerId(Objects.nonNull(customerEo) ? customerEo.getId() : null);
            }
        });
        ruleRespDto.setShopCustomerDtos((List)shopCustomerDtos);
        String relationCustomerType = String.valueOf(ruleEo.getApplicableCustomerRange());
        if (!Objects.equals(relationCustomerType, CustomerShopEnum.CUSTOMER_ALL_ENUM.getType())) {
            this.buildCustomerCondition(id, ruleRespDto, ruleEo.getRuleCode(), ruleEo.getRuleName());
        }
        if (Objects.equals(relationCustomerType, CustomerShopEnum.CUSTOMER_RANGE_ENUM.getType())) {
            ruleRespDto.setReconciliationRejectCustomerRespDtoList(this.buildRejectCustomerCondition(ruleEo.getRuleCode(), ruleEo.getId()));
        }
        return new RestResponse((Object)ruleRespDto);
    }

    private void buildCustomerCondition(Long id, ReconciliationRuleRespDto ruleRespDto, String ruleCode, String ruleName) {
        ReconciliationCustomerConditionEo customerConditionEo = new ReconciliationCustomerConditionEo();
        customerConditionEo.setRuleCode(ruleCode);
        customerConditionEo.setRuleName(ruleName);
        customerConditionEo = (ReconciliationCustomerConditionEo)this.customerConditionDomain.selectOne((BaseEo)customerConditionEo);
        if (Objects.nonNull(customerConditionEo)) {
            String customerIds;
            String customerLevelIds;
            String customerAreaCodes;
            String customerGroupIds;
            CustomerConditionRespDto customerConditionRespDto = new CustomerConditionRespDto();
            String customerTypeIds = customerConditionEo.getCustomerTypeIds();
            if (StrUtil.isNotBlank((CharSequence)customerTypeIds)) {
                customerConditionRespDto.setCustomerTypeIds(Arrays.asList(customerTypeIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerGroupIds = customerConditionEo.getCustomerGroupIds()))) {
                customerConditionRespDto.setCustomerGroupIds(Arrays.asList(customerGroupIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerAreaCodes = customerConditionEo.getCustomerAreaCodes()))) {
                customerConditionRespDto.setCustomerAreaCodes(Arrays.asList(customerAreaCodes.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerLevelIds = customerConditionEo.getCustomerLevelIds()))) {
                customerConditionRespDto.setCustomerLevelIds(Arrays.asList(customerLevelIds.split(",")));
            }
            if (StrUtil.isNotBlank((CharSequence)(customerIds = customerConditionEo.getCustomerIds()))) {
                customerConditionRespDto.setRuleId(id);
                customerConditionRespDto.setCustomerIds(Arrays.asList(customerIds.split(",")));
                List<Long> ids = customerConditionRespDto.getCustomerIds().stream().map(Long::valueOf).collect(Collectors.toList());
                Map<Long, CustomerEo> customerMap = this.getCustomerMap(ids);
                List customerInfoDtos = customerMap.values().stream().map(customerInfo -> {
                    CustomerInfoDto customerInfoDto = new CustomerInfoDto();
                    customerInfoDto.setCustomerId(customerInfo.getId());
                    customerInfoDto.setCustomerName(customerInfo.getName());
                    customerInfoDto.setCustomerCode(customerInfo.getCode());
                    customerInfoDto.setCustomerTypeId(customerInfo.getCustomerTypeId());
                    customerInfoDto.setCustomerGroupId(customerInfo.getCustomerGroupId());
                    customerInfoDto.setCustomerCompanyId(customerInfo.getCompanyId());
                    return customerInfoDto;
                }).collect(Collectors.toList());
                customerConditionRespDto.setCustomerInfoDtos(customerInfoDtos);
            }
            ruleRespDto.setCustomerConditionRespDto(customerConditionRespDto);
        }
    }

    private List<ReconciliationRejectCustomerRespDto> buildRejectCustomerCondition(String ruleCode, Long id) {
        List<ReconciliationRejectCustomerRespDto> rejectCustomerRespDtos = this.queryByRelateIdAndType(ruleCode);
        if (CollectionUtil.isNotEmpty(rejectCustomerRespDtos)) {
            List<Long> customerIds = rejectCustomerRespDtos.stream().map(ReconciliationRejectCustomerRespDto::getCustomerId).collect(Collectors.toList());
            Map<Long, CustomerEo> customerMap = this.getCustomerMap(customerIds);
            for (ReconciliationRejectCustomerRespDto priceRejectCustomerRespDto : rejectCustomerRespDtos) {
                CustomerEo customerRespDto = customerMap.get(priceRejectCustomerRespDto.getCustomerId());
                if (customerRespDto == null) continue;
                priceRejectCustomerRespDto.setRuleId(id);
                priceRejectCustomerRespDto.setCustomerName(customerRespDto.getName());
                priceRejectCustomerRespDto.setCustomerCode(customerRespDto.getCode());
                priceRejectCustomerRespDto.setCustomerGroupId(customerRespDto.getCustomerGroupId());
                priceRejectCustomerRespDto.setCustomerTypeId(customerRespDto.getCustomerTypeId());
                priceRejectCustomerRespDto.setCustomerCompanyId(customerRespDto.getCompanyId());
            }
        }
        return rejectCustomerRespDtos;
    }

    public List<ReconciliationRejectCustomerRespDto> queryByRelateIdAndType(String ruleCode) {
        if (ruleCode == null) {
            return null;
        }
        ReconciliationRejectCustomerEo priceRejectCustomerEo = new ReconciliationRejectCustomerEo();
        priceRejectCustomerEo.setDr(0);
        priceRejectCustomerEo.setRuleCode(ruleCode);
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery((Object)priceRejectCustomerEo);
        List priceRejectCustomerEoList = this.rejectCustomerDas.getMapper().selectList((Wrapper)queryWrapper);
        return priceRejectCustomerEoList.stream().map(item -> (ReconciliationRejectCustomerRespDto)item.toDto(ReconciliationRejectCustomerRespDto.class)).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, isolation=Isolation.READ_COMMITTED)
    public RestResponse<Void> deleteReconciliation(Long id) {
        ReconciliationRuleEo ruleEo = (ReconciliationRuleEo)((ExtQueryChainWrapper)((IReconciliationRuleDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AssertUtils.notNull((Object)ruleEo, (String)"\u5bf9\u8d26\u89c4\u5219\u4e0d\u5b58\u5728");
        ((IReconciliationRuleDomain)this.domain).logicDeleteById(ruleEo.getId());
        ReconciliationDataRangeEo dataRangeEo = new ReconciliationDataRangeEo();
        dataRangeEo.setRuleCode(ruleEo.getRuleCode());
        this.dataRangeDas.logicDelete((BaseEo)dataRangeEo);
        ReconciliationShopCustomerEo shopCustomerEo = new ReconciliationShopCustomerEo();
        shopCustomerEo.setRuleCode(ruleEo.getRuleCode());
        this.shopCustomerDas.logicDelete((BaseEo)shopCustomerEo);
        ReconciliationRejectCustomerEo rejectCustomerEo = new ReconciliationRejectCustomerEo();
        rejectCustomerEo.setRuleCode(ruleEo.getRuleCode());
        this.rejectCustomerDas.logicDelete((BaseEo)rejectCustomerEo);
        ReconciliationCustomerConditionEo customerConditionEo = new ReconciliationCustomerConditionEo();
        customerConditionEo.setRuleCode(ruleEo.getRuleCode());
        this.customerConditionDomain.logicDelete((BaseEo)customerConditionEo);
        return RestResponse.VOID;
    }

    private Map<String, ShopEo> getShop(List<String> shopCodes) {
        HashMap shopEoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(shopCodes)) {
            return shopEoMap;
        }
        List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", shopCodes)).list();
        return shopEos.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (k1, k2) -> k1));
    }

    private Map<String, CustomerEo> getCustomer(List<String> customerCodes) {
        HashMap customerEoMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerCodes)) {
            return customerEoMap;
        }
        List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
        return customerEos.stream().collect(Collectors.toMap(CustomerEo::getCode, Function.identity(), (k1, k2) -> k1));
    }

    @Override
    public List<ReconciliationRuleDto> getRuleDtoList(String ruleStrategy) {
        return ((IReconciliationRuleDomain)this.domain).getRuleDtoList(ruleStrategy);
    }
}

