/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.utils;

import cn.hutool.core.date.DatePattern;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.RandomUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TradeUtil {
    private static int maxPerMSECSize = 999;
    @Autowired
    ICacheService cacheService;
    private static TradeUtil tradeUtil;
    private static final String TRADE_NO = "TRADENO";
    private static final Integer STR_FORMAT_10;
    private static final Integer STR_FORMAT_100;
    private static final Integer STR_FORMAT_1000;

    @PostConstruct
    public void init() {
        tradeUtil = this;
        TradeUtil.tradeUtil.cacheService = this.cacheService;
    }

    public static String generateTradeNo(String rootTradeNo) {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 14);
        String timeMsecStr = timeStr.substring(14, 17);
        Long result = TradeUtil.tradeUtil.cacheService.incr(TRADE_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        rootTradeNo = rootTradeNo.substring(rootTradeNo.length() - 4);
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + rootTradeNo;
        System.out.println(tradeNo);
        return tradeNo;
    }

    public static String generateTradeNo() {
        long nowLong = Long.parseLong(new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date()));
        String timeStr = String.valueOf(nowLong);
        String timeSecondStr = timeStr.substring(0, 14);
        String timeMsecStr = timeStr.substring(14, 17);
        Long result = TradeUtil.tradeUtil.cacheService.incr(TRADE_NO);
        Long mod = result % (long)maxPerMSECSize;
        String resultNo = "" + mod;
        String romNo = "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            resultNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            resultNo = "0" + mod;
        }
        int romNum = RandomUtils.nextInt((int)1, (int)9999);
        romNo = romNum + "";
        if (mod < (long)STR_FORMAT_10.intValue()) {
            romNo = "000" + mod;
        } else if (mod >= (long)STR_FORMAT_10.intValue() && mod < (long)STR_FORMAT_100.intValue()) {
            romNo = "00" + mod;
        } else if (mod >= (long)STR_FORMAT_100.intValue() && mod < (long)STR_FORMAT_1000.intValue()) {
            romNo = "0" + mod;
        }
        String tradeNo = timeSecondStr + "0" + timeMsecStr + resultNo + romNo;
        return tradeNo;
    }

    public static String genCode(String codePrefix, int digitNum) {
        Long result = TradeUtil.tradeUtil.cacheService.incr(String.format("GENERATE-CODE-%s", codePrefix));
        return TradeUtil.doGenCode(result, codePrefix, digitNum, new Date());
    }

    private static String doGenCode(Long generateCode, String codePrefix, int digitNum, Date date) {
        String prefix = codePrefix + DatePattern.PURE_DATE_FORMAT.format(date);
        return prefix + String.format("%" + digitNum + "d", generateCode).replace(" ", "0");
    }

    static {
        STR_FORMAT_10 = 10;
        STR_FORMAT_100 = 100;
        STR_FORMAT_1000 = 1000;
    }
}

