/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.dto;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.JacksonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderItemEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderLineClassificationDto {
    private static final Logger log = LoggerFactory.getLogger(OrderLineClassificationDto.class);
    private Map<Long, Category> categoryMap = new HashMap<Long, Category>();
    @JsonIgnore
    private Map<Long, OrderLine> lineMap = new HashMap<Long, OrderLine>();

    public static OrderLineClassificationDto convert(List<PerformOrderItemDto> orderItems, List<AfterSaleOrderEo> afterSaleOrders, List<AfterSaleOrderItemEo> afterSaleOrderItems) {
        Map<Long, PerformOrderItemDto> lineIdMap = orderItems.stream().collect(Collectors.toMap(BaseDto::getId, v -> v));
        Map<Long, AfterSaleOrderEo> afterSaleOrderMap = afterSaleOrders.stream().collect(Collectors.toMap(BaseEo::getId, v -> v));
        Map<String, List<AfterSaleOrderItemEo>> itemGroupByType = afterSaleOrderItems.stream().collect(Collectors.groupingBy(AfterSaleOrderItemEo::getAfterSaleOrderType));
        HashMap exchangeOrderIdToOldOrderIdMap = new HashMap();
        afterSaleOrders.forEach(o -> {
            if (AfterSaleOrderTypeEnum.HH.getCode().equals(o.getAfterSaleOrderType()) && o.getExchangeSaleOrderId() == null) {
                log.info("\u6362\u8d27 {} \u6ca1\u6709\u53d1\u51fa\uff0c\u552e\u540e\u7c7b\u578b\u8bbe\u7f6e\u4e3a\u9000\u8d27\u9000\u6b3e", (Object)o.getAfterSaleOrderNo());
                o.setAfterSaleOrderType(AfterSaleOrderTypeEnum.THTK.getCode());
            }
            if (AfterSaleOrderTypeEnum.HH.getCode().equals(o.getAfterSaleOrderType())) {
                exchangeOrderIdToOldOrderIdMap.put(o.getExchangeSaleOrderId(), o.getSaleOrderId());
            }
        });
        log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u6362\u8d27\u8ba2\u5355 -> \u539f\u5355 \u6620\u5c04\uff1a{}", (Object)JacksonUtil.toJson(exchangeOrderIdToOldOrderIdMap));
        HashMap exchangeSkuToOldLineIdMap = new HashMap();
        ((List)itemGroupByType.getOrDefault(AfterSaleOrderTypeEnum.HH.getCode(), new ArrayList(0))).forEach(item -> {
            AfterSaleOrderEo afterSaleOrder = (AfterSaleOrderEo)afterSaleOrderMap.get(item.getAfterSaleOrderId());
            if (Objects.equals(item.getAfterSaleOrderItemType(), 0)) {
                exchangeSkuToOldLineIdMap.put(afterSaleOrder.getExchangeSaleOrderId() + "_" + item.getSkuCode(), item.getSaleOrderItemId());
            }
        });
        log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u6362\u8d27\u8ba2\u5355+SKU -> \u539f\u5355\u8ba2\u5355\u884c \u6620\u5c04\uff1a{}", (Object)JacksonUtil.toJson(exchangeSkuToOldLineIdMap));
        OrderLineClassificationDto classification = new OrderLineClassificationDto();
        orderItems.stream().sorted(Comparator.comparing(BaseDto::getCreateTime)).forEach(line -> {
            boolean isHH = exchangeOrderIdToOldOrderIdMap.containsKey(line.getOrderId());
            if (!isHH) {
                log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]: \u975e\u6362\u8d27\u8ba2\u5355\uff0csku[{}]\u5f52\u4e3a\u4e3bSKU", new Object[]{line.getPlatformOrderNo(), line.getOrderNo(), line.getId(), line.getSkuCode()});
                classification.newCategoryIfAbsent((PerformOrderItemDto)line);
                return;
            }
            String key = line.getOrderId() + "_" + line.getSkuCode();
            if (!exchangeSkuToOldLineIdMap.containsKey(key)) {
                log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]: \u6362\u8d27\u5355 {} \u627e\u4e0d\u5230\u6620\u5c04\u7684\u65e7\u8ba2\u5355\u884cID\uff0csku[{}]\u5f52\u4e3a\u4e3bSKU", new Object[]{line.getPlatformOrderNo(), line.getOrderNo(), line.getId(), key, line.getSkuCode()});
                classification.newCategoryIfAbsent((PerformOrderItemDto)line);
                return;
            }
            Long oldLineId = (Long)exchangeSkuToOldLineIdMap.get(key);
            PerformOrderItemDto oldLine = (PerformOrderItemDto)lineIdMap.get(oldLineId);
            if (oldLine == null) {
                log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]: \u6362\u8d27\u5355 {} \u5bf9\u5e94\u7684\u65e7\u8ba2\u5355\u884c {} \u627e\u4e0d\u5230\u884c\u4fe1\u606f\uff0csku[{}]\u5f52\u4e3a\u4e3bSKU", new Object[]{line.getPlatformOrderNo(), line.getOrderNo(), line.getId(), key, oldLineId, line.getSkuCode()});
                classification.newCategoryIfAbsent((PerformOrderItemDto)line);
                return;
            }
            Category category = classification.newCategoryIfAbsent(oldLine);
            category.addLine(classification, (PerformOrderItemDto)line);
        });
        log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5f52\u7c7b\u7ed3\u679c\uff1a{}", (Object)JacksonUtil.toJson((Object)classification));
        return classification;
    }

    public void share(List<AfterSaleOrderItemEo> afterSaleOrderItems) {
        if (CollectionUtils.isEmpty(afterSaleOrderItems)) {
            return;
        }
        Map<Long, List<AfterSaleOrderItemEo>> group = afterSaleOrderItems.stream().collect(Collectors.groupingBy(k -> Optional.ofNullable(this.getCategory(k.getSaleOrderItemId())).map(Category::getId).orElse(-1L)));
        group.forEach((id, values) -> {
            log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u5f00\u59cb\u5206\u644acategory.id={}\u7684\u5df2\u9000\u91d1\u989d", id);
            Category category = this.getCategory((Long)id);
            if (category == null) {
                List orderItemIds = values.stream().map(BaseEo::getId).collect(Collectors.toList());
                log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u4e0d\u5b58\u5728\u4e3bSKU[{}]\u5bf9\u5e94\u7684\u5206\u7c7b\u7ed3\u679c\uff0c\u65e0\u6cd5\u5206\u644a\uff0c\u6d89\u53ca\u8ba2\u5355\u884c\uff1a{}", id, orderItemIds);
                return;
            }
            category.share((List<AfterSaleOrderItemEo>)values);
        });
    }

    public OrderLine getLine(Long lineId) {
        return this.lineMap.get(lineId);
    }

    private Category newCategoryIfAbsent(PerformOrderItemDto orderItem) {
        String skuCode = Optional.ofNullable(orderItem.getSkuCode()).orElse("");
        Category category = this.getCategory(orderItem.getId());
        if (category != null) {
            category.addLine(this, orderItem);
            return category;
        }
        category = new Category();
        category.id = orderItem.getId();
        category.skuCode = skuCode;
        category.skuName = orderItem.getSkuName();
        category.orderLines = new ArrayList();
        category.addLine(this, orderItem);
        this.categoryMap.put(category.id, category);
        return category;
    }

    private Category getCategory(Long id) {
        Category category = this.categoryMap.get(id);
        if (category != null) {
            return category;
        }
        return this.categoryMap.values().stream().filter(c -> ((Category)c).id.equals(id) || ((Category)c).orderLineIds.contains(id)).findFirst().orElse(null);
    }

    private void add(OrderLine line) {
        if (this.lineMap.containsKey(line.getId())) {
            log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u8ba2\u5355\u884c\u5728\u7f13\u5b58\u4e2d\u5df2\u5b58\u5728\uff1a{}", (Object)line.getId());
            return;
        }
        this.lineMap.put(line.getId(), line);
    }

    public Map<Long, Category> getCategoryMap() {
        return this.categoryMap;
    }

    public Map<Long, OrderLine> getLineMap() {
        return this.lineMap;
    }

    public void setCategoryMap(Map<Long, Category> categoryMap) {
        this.categoryMap = categoryMap;
    }

    @JsonIgnore
    public void setLineMap(Map<Long, OrderLine> lineMap) {
        this.lineMap = lineMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OrderLineClassificationDto)) {
            return false;
        }
        OrderLineClassificationDto other = (OrderLineClassificationDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<Long, Category> this$categoryMap = this.getCategoryMap();
        Map<Long, Category> other$categoryMap = other.getCategoryMap();
        if (this$categoryMap == null ? other$categoryMap != null : !((Object)this$categoryMap).equals(other$categoryMap)) {
            return false;
        }
        Map<Long, OrderLine> this$lineMap = this.getLineMap();
        Map<Long, OrderLine> other$lineMap = other.getLineMap();
        return !(this$lineMap == null ? other$lineMap != null : !((Object)this$lineMap).equals(other$lineMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OrderLineClassificationDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<Long, Category> $categoryMap = this.getCategoryMap();
        result = result * 59 + ($categoryMap == null ? 43 : ((Object)$categoryMap).hashCode());
        Map<Long, OrderLine> $lineMap = this.getLineMap();
        result = result * 59 + ($lineMap == null ? 43 : ((Object)$lineMap).hashCode());
        return result;
    }

    public String toString() {
        return "OrderLineClassificationDto(categoryMap=" + this.getCategoryMap() + ", lineMap=" + this.getLineMap() + ")";
    }

    public static class OrderLine {
        private Long id;
        private Long priority;
        private String skuCode;
        private String skuName;
        private BigDecimal itemNum;
        private BigDecimal refundedItemNum;
        private BigDecimal realPayAmount;
        private BigDecimal refundedPayAmount;

        public OrderLine(PerformOrderItemDto line, long priority) {
            this.id = line.getId();
            this.priority = priority;
            this.skuCode = line.getSkuCode();
            this.skuName = line.getSkuName();
            this.itemNum = Optional.ofNullable(line.getItemNum()).map(k -> new BigDecimal(k.stripTrailingZeros().toPlainString())).orElse(BigDecimal.ZERO);
            this.refundedItemNum = BigDecimal.ZERO;
            this.realPayAmount = Optional.ofNullable(line.getRealPayAmount()).map(k -> new BigDecimal(k.stripTrailingZeros().toPlainString())).orElse(BigDecimal.ZERO);
            this.refundedPayAmount = BigDecimal.ZERO;
        }

        public Long getId() {
            return this.id;
        }

        public Long getPriority() {
            return this.priority;
        }

        public String getSkuCode() {
            return this.skuCode;
        }

        public String getSkuName() {
            return this.skuName;
        }

        public BigDecimal getItemNum() {
            return this.itemNum;
        }

        public BigDecimal getRefundedItemNum() {
            return this.refundedItemNum;
        }

        public BigDecimal getRealPayAmount() {
            return this.realPayAmount;
        }

        public BigDecimal getRefundedPayAmount() {
            return this.refundedPayAmount;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setPriority(Long priority) {
            this.priority = priority;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public void setSkuName(String skuName) {
            this.skuName = skuName;
        }

        public void setItemNum(BigDecimal itemNum) {
            this.itemNum = itemNum;
        }

        public void setRefundedItemNum(BigDecimal refundedItemNum) {
            this.refundedItemNum = refundedItemNum;
        }

        public void setRealPayAmount(BigDecimal realPayAmount) {
            this.realPayAmount = realPayAmount;
        }

        public void setRefundedPayAmount(BigDecimal refundedPayAmount) {
            this.refundedPayAmount = refundedPayAmount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OrderLine)) {
                return false;
            }
            OrderLine other = (OrderLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            Long this$priority = this.getPriority();
            Long other$priority = other.getPriority();
            if (this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority)) {
                return false;
            }
            String this$skuCode = this.getSkuCode();
            String other$skuCode = other.getSkuCode();
            if (this$skuCode == null ? other$skuCode != null : !this$skuCode.equals(other$skuCode)) {
                return false;
            }
            String this$skuName = this.getSkuName();
            String other$skuName = other.getSkuName();
            if (this$skuName == null ? other$skuName != null : !this$skuName.equals(other$skuName)) {
                return false;
            }
            BigDecimal this$itemNum = this.getItemNum();
            BigDecimal other$itemNum = other.getItemNum();
            if (this$itemNum == null ? other$itemNum != null : !((Object)this$itemNum).equals(other$itemNum)) {
                return false;
            }
            BigDecimal this$refundedItemNum = this.getRefundedItemNum();
            BigDecimal other$refundedItemNum = other.getRefundedItemNum();
            if (this$refundedItemNum == null ? other$refundedItemNum != null : !((Object)this$refundedItemNum).equals(other$refundedItemNum)) {
                return false;
            }
            BigDecimal this$realPayAmount = this.getRealPayAmount();
            BigDecimal other$realPayAmount = other.getRealPayAmount();
            if (this$realPayAmount == null ? other$realPayAmount != null : !((Object)this$realPayAmount).equals(other$realPayAmount)) {
                return false;
            }
            BigDecimal this$refundedPayAmount = this.getRefundedPayAmount();
            BigDecimal other$refundedPayAmount = other.getRefundedPayAmount();
            return !(this$refundedPayAmount == null ? other$refundedPayAmount != null : !((Object)this$refundedPayAmount).equals(other$refundedPayAmount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OrderLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            Long $priority = this.getPriority();
            result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
            String $skuCode = this.getSkuCode();
            result = result * 59 + ($skuCode == null ? 43 : $skuCode.hashCode());
            String $skuName = this.getSkuName();
            result = result * 59 + ($skuName == null ? 43 : $skuName.hashCode());
            BigDecimal $itemNum = this.getItemNum();
            result = result * 59 + ($itemNum == null ? 43 : ((Object)$itemNum).hashCode());
            BigDecimal $refundedItemNum = this.getRefundedItemNum();
            result = result * 59 + ($refundedItemNum == null ? 43 : ((Object)$refundedItemNum).hashCode());
            BigDecimal $realPayAmount = this.getRealPayAmount();
            result = result * 59 + ($realPayAmount == null ? 43 : ((Object)$realPayAmount).hashCode());
            BigDecimal $refundedPayAmount = this.getRefundedPayAmount();
            result = result * 59 + ($refundedPayAmount == null ? 43 : ((Object)$refundedPayAmount).hashCode());
            return result;
        }

        public String toString() {
            return "OrderLineClassificationDto.OrderLine(id=" + this.getId() + ", priority=" + this.getPriority() + ", skuCode=" + this.getSkuCode() + ", skuName=" + this.getSkuName() + ", itemNum=" + this.getItemNum() + ", refundedItemNum=" + this.getRefundedItemNum() + ", realPayAmount=" + this.getRealPayAmount() + ", refundedPayAmount=" + this.getRefundedPayAmount() + ")";
        }

        public OrderLine() {
        }

        public OrderLine(Long id, Long priority, String skuCode, String skuName, BigDecimal itemNum, BigDecimal refundedItemNum, BigDecimal realPayAmount, BigDecimal refundedPayAmount) {
            this.id = id;
            this.priority = priority;
            this.skuCode = skuCode;
            this.skuName = skuName;
            this.itemNum = itemNum;
            this.refundedItemNum = refundedItemNum;
            this.realPayAmount = realPayAmount;
            this.refundedPayAmount = refundedPayAmount;
        }
    }

    public static class Category {
        private Long id;
        private String skuCode;
        private String skuName;
        private Set<Long> orderLineIds = new HashSet<Long>();
        private List<OrderLine> orderLines = new ArrayList<OrderLine>();

        public void addLine(OrderLineClassificationDto classification, PerformOrderItemDto orderItem) {
            if (this.orderLineIds.contains(orderItem.getId())) {
                log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]: \u8be5\u8ba2\u5355\u884c\u5df2\u548c\u4e3bSKU[{}]\u5f52\u4e3a\u4e00\u7c7b\uff0c\u65e0\u9700\u91cd\u590d\u6dfb\u52a0", new Object[]{orderItem.getPlatformOrderNo(), orderItem.getOrderNo(), orderItem.getId(), this.skuCode});
                return;
            }
            log.info("\u8ba2\u5355\u884c\u5f52\u7c7b\uff1a\u5e73\u53f0\u8ba2\u5355[{}]-\u9500\u552e\u8ba2\u5355[{}]-\u5546\u54c1\u884c[{}]: \u8be5\u8ba2\u5355\u884c\u548c\u4e3bSKU[{}]\u5f52\u4e3a\u4e00\u7c7b", new Object[]{orderItem.getPlatformOrderNo(), orderItem.getOrderNo(), orderItem.getId(), this.skuCode});
            this.orderLineIds.add(orderItem.getId());
            long priority = this.id.equals(orderItem.getId()) ? 0L : orderItem.getCreateTime().getTime();
            OrderLine line = new OrderLine(orderItem, priority);
            this.orderLines.add(line);
            classification.add(line);
        }

        public void share(List<AfterSaleOrderItemEo> afterSaleOrderItems) {
            this.orderLines.sort(Comparator.comparing(OrderLine::getPriority));
            afterSaleOrderItems = afterSaleOrderItems.stream().filter(s -> Objects.equals(s.getAfterSaleOrderItemType(), 0)).sorted(Comparator.comparing(eo -> {
                if (AfterSaleOrderTypeEnum.HH.getCode().equals(eo.getAfterSaleOrderType())) {
                    return 0;
                }
                if (AfterSaleOrderTypeEnum.THTK.getCode().equals(eo.getAfterSaleOrderType())) {
                    return 1;
                }
                if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(eo.getAfterSaleOrderType())) {
                    return 2;
                }
                log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u5f02\u5e38\u7684\u552e\u540e\u5355\u7c7b\u578b\uff0c\u4e3bSKU[{}]\uff0c\u552e\u540e\u5355\u884c[{}]", (Object)this.skuCode, (Object)eo.getId());
                return 3;
            })).collect(Collectors.toList());
            for (AfterSaleOrderItemEo afterSaleOrderItemEo : afterSaleOrderItems) {
                this.share(afterSaleOrderItemEo);
            }
        }

        private void share(AfterSaleOrderItemEo item) {
            if (item.getRefundAmount() == null) {
                item.setRefundAmount(BigDecimal.ZERO);
            }
            if (item.getItemNum() == null) {
                item.setItemNum(Integer.valueOf(0));
            }
            item.setRefundAmount(new BigDecimal(item.getRefundAmount().stripTrailingZeros().toPlainString()));
            BigDecimal itemNum = new BigDecimal(item.getItemNum());
            boolean isReduceByQuantity = AfterSaleOrderTypeEnum.HH.getCode().equals(item.getAfterSaleOrderType()) || AfterSaleOrderTypeEnum.THTK.getCode().equals(item.getAfterSaleOrderType());
            List usableLines = isReduceByQuantity ? this.orderLines.stream().filter(s -> s.getItemNum().compareTo(s.getRefundedItemNum()) > 0).collect(Collectors.toList()) : this.orderLines.stream().filter(s -> s.getRealPayAmount().compareTo(s.getRefundedPayAmount()) > 0).collect(Collectors.toList());
            BigDecimal surplusAmount = Optional.ofNullable(item.getRefundAmount()).map(k -> new BigDecimal(k.stripTrailingZeros().toPlainString())).orElse(BigDecimal.ZERO);
            BigDecimal surplusItemNum = !AfterSaleOrderTypeEnum.FHHTK.getCode().equals(item.getAfterSaleOrderType()) ? Optional.ofNullable(item.getItemNum()).map(BigDecimal::new).map(k -> new BigDecimal(k.stripTrailingZeros().toPlainString())).orElse(BigDecimal.ZERO) : BigDecimal.ZERO;
            Iterator iterator = usableLines.iterator();
            if (iterator.hasNext()) {
                OrderLine line = (OrderLine)iterator.next();
                if (surplusAmount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal shareableAmount = line.getRealPayAmount().subtract(line.getRefundedPayAmount());
                    BigDecimal shareAmount = shareableAmount.compareTo(surplusAmount) >= 0 ? surplusAmount : shareableAmount;
                    BigDecimal newRefundedPayAmount = line.getRefundedPayAmount().add(shareAmount);
                    BigDecimal newSurplusAmount = surplusAmount.subtract(shareAmount);
                    log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u4e3bSKU[{}]\uff0c\u9500\u552e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0c\u5df2\u9000\u91d1\u989d(\u65e7)\uff1a{}\uff0c\u53ef\u5206\u644a\u91d1\u989d\uff1a{}\uff0c\u5df2\u9000\u91d1\u989d(\u65b0)\uff1a{}\uff0c\u552e\u540e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5df2\u9000\u91d1\u989d\uff1a{}\uff0c\u672a\u5206\u644a\u91d1\u989d(\u65e7)\uff1a{}\uff0c\u5df2\u5206\u644a\u91d1\u989d(\u65e7)\uff1a{}\uff0c\u672c\u6b21\u5206\u644a\u91d1\u989d\uff1a{}\uff0c\u672a\u5206\u644a\u91d1\u989d(\u65b0)\uff1a{}\uff0c\u5df2\u5206\u644a\u91d1\u989d(\u65b0)\uff1a{}", new Object[]{this.skuCode, line.getId(), line.getSkuCode(), line.getRealPayAmount(), line.getRefundedPayAmount(), shareableAmount, newRefundedPayAmount, item.getId(), item.getSkuCode(), item.getRefundAmount(), surplusAmount, item.getRefundAmount().subtract(surplusAmount), shareAmount, newSurplusAmount, item.getRefundAmount().subtract(newSurplusAmount)});
                    line.setRefundedPayAmount(newRefundedPayAmount);
                    surplusAmount = newSurplusAmount;
                }
                if (surplusItemNum.compareTo(BigDecimal.ZERO) > 0 && line.getItemNum().compareTo(line.getRefundedItemNum()) > 0) {
                    BigDecimal shareableItemNum = line.getItemNum().subtract(line.getRefundedItemNum());
                    BigDecimal shareItemNum = shareableItemNum.compareTo(surplusItemNum) >= 0 ? surplusItemNum : shareableItemNum;
                    BigDecimal newRefundedItemNum = line.getRefundedItemNum().add(shareItemNum);
                    BigDecimal newSurplusNum = surplusItemNum.subtract(shareItemNum);
                    log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u4e3bSKU[{}]\uff0c\u9500\u552e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5b9e\u9645\u6570\u91cf\uff1a{}\uff0c\u5df2\u9000\u6570\u91cf(\u65e7)\uff1a{}\uff0c\u53ef\u5206\u644a\u6570\u91cf\uff1a{}\uff0c\u5df2\u9000\u6570\u91cf(\u65b0)\uff1a{}\uff0c\u552e\u540e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5df2\u9000\u6570\u91cf\uff1a{}\uff0c\u672a\u5206\u644a\u6570\u91cf(\u65e7)\uff1a{}\uff0c\u5df2\u5206\u644a\u6570\u91cf(\u65e7)\uff1a{}\uff0c\u672c\u6b21\u5206\u644a\u6570\u91cf\uff1a{}\uff0c\u672a\u5206\u644a\u6570\u91cf(\u65b0)\uff1a{}\uff0c\u5df2\u5206\u644a\u6570\u91cf(\u65b0)\uff1a{}", new Object[]{this.skuCode, line.getId(), line.getSkuCode(), line.getItemNum(), line.getRefundedItemNum(), shareableItemNum, newRefundedItemNum, item.getId(), item.getSkuCode(), item.getItemNum(), surplusItemNum, new BigDecimal(item.getItemNum()).subtract(surplusItemNum), shareItemNum, newSurplusNum, new BigDecimal(item.getItemNum()).subtract(newSurplusNum)});
                    line.setRefundedItemNum(newRefundedItemNum);
                    surplusItemNum = newSurplusNum;
                }
            }
            if (surplusAmount.compareTo(BigDecimal.ZERO) > 0) {
                log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u4e3bSKU[{}]\uff0c\u552e\u540e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5269\u4f59\u672a\u5206\u644a\u91d1\u989d\uff1a{}\uff0c\u5df2\u65e0\u53ef\u5206\u644a\u7684\u6b63\u5411\u5355", new Object[]{this.skuCode, item.getId(), item.getSkuCode(), surplusAmount});
            }
            if (surplusItemNum.compareTo(BigDecimal.ZERO) > 0) {
                log.info("\u5df2\u9000\u6570\u91cf&\u91d1\u989d\u5206\u644a: \u4e3bSKU[{}]\uff0c\u552e\u540e\u5355\u884c[{}]\uff1aSKU\uff1a{}\uff0c\u5269\u4f59\u672a\u5206\u644a\u6570\u91cf\uff1a{}\uff0c\u5df2\u65e0\u53ef\u5206\u644a\u7684\u6b63\u5411\u5355", new Object[]{this.skuCode, item.getId(), item.getSkuCode(), surplusItemNum});
            }
        }

        public Long getId() {
            return this.id;
        }

        public String getSkuCode() {
            return this.skuCode;
        }

        public String getSkuName() {
            return this.skuName;
        }

        public Set<Long> getOrderLineIds() {
            return this.orderLineIds;
        }

        public List<OrderLine> getOrderLines() {
            return this.orderLines;
        }

        public void setId(Long id) {
            this.id = id;
        }

        public void setSkuCode(String skuCode) {
            this.skuCode = skuCode;
        }

        public void setSkuName(String skuName) {
            this.skuName = skuName;
        }

        public void setOrderLineIds(Set<Long> orderLineIds) {
            this.orderLineIds = orderLineIds;
        }

        public void setOrderLines(List<OrderLine> orderLines) {
            this.orderLines = orderLines;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Category)) {
                return false;
            }
            Category other = (Category)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Long this$id = this.getId();
            Long other$id = other.getId();
            if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
                return false;
            }
            String this$skuCode = this.getSkuCode();
            String other$skuCode = other.getSkuCode();
            if (this$skuCode == null ? other$skuCode != null : !this$skuCode.equals(other$skuCode)) {
                return false;
            }
            String this$skuName = this.getSkuName();
            String other$skuName = other.getSkuName();
            if (this$skuName == null ? other$skuName != null : !this$skuName.equals(other$skuName)) {
                return false;
            }
            Set<Long> this$orderLineIds = this.getOrderLineIds();
            Set<Long> other$orderLineIds = other.getOrderLineIds();
            if (this$orderLineIds == null ? other$orderLineIds != null : !((Object)this$orderLineIds).equals(other$orderLineIds)) {
                return false;
            }
            List<OrderLine> this$orderLines = this.getOrderLines();
            List<OrderLine> other$orderLines = other.getOrderLines();
            return !(this$orderLines == null ? other$orderLines != null : !((Object)this$orderLines).equals(other$orderLines));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Category;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Long $id = this.getId();
            result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
            String $skuCode = this.getSkuCode();
            result = result * 59 + ($skuCode == null ? 43 : $skuCode.hashCode());
            String $skuName = this.getSkuName();
            result = result * 59 + ($skuName == null ? 43 : $skuName.hashCode());
            Set<Long> $orderLineIds = this.getOrderLineIds();
            result = result * 59 + ($orderLineIds == null ? 43 : ((Object)$orderLineIds).hashCode());
            List<OrderLine> $orderLines = this.getOrderLines();
            result = result * 59 + ($orderLines == null ? 43 : ((Object)$orderLines).hashCode());
            return result;
        }

        public String toString() {
            return "OrderLineClassificationDto.Category(id=" + this.getId() + ", skuCode=" + this.getSkuCode() + ", skuName=" + this.getSkuName() + ", orderLineIds=" + this.getOrderLineIds() + ", orderLines=" + this.getOrderLines() + ")";
        }
    }
}

