/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.vo.BaseVo;
import com.fasterxml.jackson.core.type.TypeReference;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.convert.entity.BillStrategyConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyNoInvoiceItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyShopDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillStrategyMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.BillStrategyShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillStrategyDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillStrategyDto;
import com.yunxi.dg.base.center.finance.dto.enums.BillAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.UseBlackListEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditModifyStatusReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillApplyAuditReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyReqDto;
import com.yunxi.dg.base.center.finance.dto.request.BillStrategyShopReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyNoInvoiceItemRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyShopRespDto;
import com.yunxi.dg.base.center.finance.eo.BillStrategyEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyNoInvoiceItemEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyShopService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillStrategyServiceImpl
extends BaseServiceImpl<BillStrategyDto, BillStrategyEo, IBillStrategyDomain>
implements IBillStrategyService {
    @Resource
    private IBillStrategyDas billStrategyDas;
    @Resource
    private IBillStrategyShopService billStrategyShopService;
    @Resource
    private BillStrategyMapper billStrategyMapper;
    @Resource
    private IBillStrategyShopDas billStrategyShopDas;
    @Resource
    private BillStrategyShopMapper billStrategyShopMapper;
    @Resource
    private IBillStrategyNoInvoiceItemDas billStrategyNoInvoiceItemDas;
    private static final String REGEX = ",";
    private static final String BILL_STRATEGY_CACHE_KEY = "billStrategyKey";
    @Resource
    private ICacheService cacheService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public BillStrategyServiceImpl(IBillStrategyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillStrategyDto, BillStrategyEo> converter() {
        return BillStrategyConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long addBillStrategy(BillStrategyReqDto strategyReqDto) {
        List applyColourType;
        this.cacheService.delCacheByPattern("billStrategyKey*");
        this.logger.info("\u65b0\u589e\u5f00\u7968\u7b56\u7565\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)strategyReqDto));
        this.checkParam(strategyReqDto);
        String strategyCode = StringUtils.isNotBlank((CharSequence)strategyReqDto.getStrategyCode()) ? strategyReqDto.getStrategyCode() : GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_STRATEGY.getCode()).getCode();
        this.logger.info("\u5f00\u7968\u7b56\u7565\u7f16\u7801\uff1a{}", (Object)strategyCode);
        List shopReqDtos = strategyReqDto.getShopReqDtos();
        BillStrategyEo billStrategyEo = new BillStrategyEo();
        DtoHelper.dto2Eo((BaseVo)strategyReqDto, (BaseEo)billStrategyEo, (String[])new String[]{"id"});
        billStrategyEo.setStrategyCode(strategyCode);
        List billApplyType = strategyReqDto.getBillApplyType();
        if (CollectionUtils.isNotEmpty((Collection)billApplyType)) {
            String billApplyTypeStr = String.join((CharSequence)REGEX, billApplyType);
            billStrategyEo.setBillApplyType(billApplyTypeStr);
        }
        if (CollectionUtils.isNotEmpty((Collection)(applyColourType = strategyReqDto.getApplyColourType()))) {
            String applyColourTypeStr = String.join((CharSequence)REGEX, applyColourType);
            billStrategyEo.setApplyColourType(applyColourTypeStr);
        }
        billStrategyEo.setStrategyStatus(BillStrategyStatusEnum.DISABLE.getCode());
        billStrategyEo.setBillRuleType(strategyReqDto.getRuleType());
        billStrategyEo.setUseBlackList(strategyReqDto.getUseBlackList());
        billStrategyEo.setBlackListContent(strategyReqDto.getBlackListContent());
        billStrategyEo.setCreateType(StrUtil.join((CharSequence)REGEX, (Iterable)strategyReqDto.getCreateTypeList()));
        List nationalSupplementOrder = strategyReqDto.getNationalSupplementOrder();
        if (CollectionUtils.isNotEmpty((Collection)nationalSupplementOrder)) {
            billStrategyEo.setNationalSupplementOrder(StrUtil.join((CharSequence)REGEX, (Iterable)strategyReqDto.getNationalSupplementOrder()));
        }
        this.billStrategyDas.insert((BaseEo)billStrategyEo);
        ArrayList shopEos = new ArrayList();
        shopReqDtos.forEach(reqDto -> {
            BillStrategyShopEo eo = new BillStrategyShopEo();
            eo.setShopCode(reqDto.getShopCode());
            eo.setShopName(reqDto.getShopName());
            eo.setBillStrategyId(billStrategyEo.getId());
            shopEos.add(eo);
        });
        this.billStrategyShopDas.insertBatch(shopEos);
        List billStrategyNoInvoiceItemReqDtoList = strategyReqDto.getBillStrategyNoInvoiceItemReqDtoList();
        if (CollectionUtils.isNotEmpty((Collection)billStrategyNoInvoiceItemReqDtoList)) {
            ArrayList billStrategyNoInvoiceItemEoList = new ArrayList();
            strategyReqDto.getBillStrategyNoInvoiceItemReqDtoList().forEach(item -> {
                BillStrategyNoInvoiceItemEo billStrategyNoInvoiceItemEo = new BillStrategyNoInvoiceItemEo();
                billStrategyNoInvoiceItemEo.setStrategyId(billStrategyEo.getId());
                billStrategyNoInvoiceItemEo.setItemCode(item.getItemCode());
                billStrategyNoInvoiceItemEo.setItemName(item.getItemName());
                billStrategyNoInvoiceItemEoList.add(billStrategyNoInvoiceItemEo);
            });
            if (CollectionUtils.isNotEmpty(billStrategyNoInvoiceItemEoList)) {
                this.billStrategyNoInvoiceItemDas.insertBatch(billStrategyNoInvoiceItemEoList);
            }
        }
        return billStrategyEo.getId();
    }

    private void checkParam(BillStrategyReqDto strategyReqDto) {
        this.logger.info("\u6821\u9a8c\u5f00\u7968\u7b56\u7565\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)strategyReqDto));
        AssertUtil.isTrue(Objects.nonNull(strategyReqDto), "\u5f00\u7968\u7b56\u7565\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getStrategyName()), "\u5f00\u7968\u7b56\u7565\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillChannel()), "\u5f00\u7968\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillEntityName()), "\u5f00\u7968\u4e3b\u4f53\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillEntityCode()), "\u5f00\u7968\u4e3b\u4f53\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillObject()), "\u5f00\u7968\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillOrderPoint()), "\u8ba2\u5355\u5f00\u7968\u8282\u70b9\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillRowName()), "\u53d1\u7968\u884c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillGift()), "\u8d60\u54c1\u662f\u5426\u5f00\u7968\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillFreight()), "\u8fd0\u8d39\u662f\u5426\u5f00\u7968\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBillAudit()), "\u662f\u5426\u5f00\u542f\u81ea\u52a8\u5ba1\u6838\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        if ("1".equals(strategyReqDto.getBillAudit())) {
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)strategyReqDto.getBillApplyType()), "\u9002\u7528\u53d1\u7968\u79cd\u7c7b\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)strategyReqDto.getApplyColourType()), "\u9002\u7528\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getApplyShop()), "\u9002\u7528\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)strategyReqDto.getShopReqDtos()), "\u5f00\u7968\u7b56\u7565\u5e97\u94fa\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        if (StrUtil.isBlank((CharSequence)strategyReqDto.getInvoiceType())) {
            strategyReqDto.setInvoiceType("E-NOT_ALL");
        }
        if (StringUtils.isNotBlank((CharSequence)strategyReqDto.getUseBlackList()) && UseBlackListEnum.YES.getCode().equals(strategyReqDto.getUseBlackList())) {
            AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)strategyReqDto.getBlackListContent()), "\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355\u914d\u7f6e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkParamShop(strategyReqDto);
    }

    public void checkParamShop(BillStrategyReqDto strategyReqDto) {
        List list;
        if (StrategyTypeEnum.ORDINARY_BILL.getCode().equals(strategyReqDto.getStrategyType())) {
            List list2 = ((ExtQueryChainWrapper)this.billStrategyDas.filter().eq((Object)"strategy_type", (Object)StrategyTypeEnum.MERGE_BILL.getCode())).list();
            if (CollectionUtils.isNotEmpty((Collection)list2)) {
                List strategyIdList = list2.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
                List shopCodeList = strategyReqDto.getShopReqDtos().stream().map(BillStrategyShopReqDto::getShopCode).distinct().collect(Collectors.toList());
                List shopEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billStrategyShopDas.filter().in((Object)"bill_strategy_id", strategyIdList)).in((Object)"shop_code", shopCodeList)).list();
                if (CollectionUtils.isNotEmpty((Collection)shopEos)) {
                    String shopEoCode = shopEos.stream().map(BillStrategyShopEo::getShopCode).distinct().collect(Collectors.joining(REGEX));
                    throw new BizException(shopEoCode + ":\u5e97\u94fa\u5df2\u5b58\u5728\u5408\u5e76\u5f00\u7968\u7b56\u7565");
                }
            }
        } else if (StrategyTypeEnum.MERGE_BILL.getCode().equals(strategyReqDto.getStrategyType()) && CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)this.billStrategyDas.filter().eq((Object)"strategy_type", (Object)StrategyTypeEnum.ORDINARY_BILL.getCode())).list()))) {
            List strategyIdList = list.stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            List shopCodeList = strategyReqDto.getShopReqDtos().stream().map(BillStrategyShopReqDto::getShopCode).distinct().collect(Collectors.toList());
            List shopEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billStrategyShopDas.filter().in((Object)"bill_strategy_id", strategyIdList)).in((Object)"shop_code", shopCodeList)).list();
            if (CollectionUtils.isNotEmpty((Collection)shopEos)) {
                String shopEoCode = shopEos.stream().map(BillStrategyShopEo::getShopCode).distinct().collect(Collectors.joining(REGEX));
                throw new BizException(shopEoCode + ":\u5e97\u94fa\u5df2\u5b58\u5728C\u7aef\u5f00\u7968\u7b56\u7565");
            }
        }
    }

    public void updateBillStrategy(BillStrategyReqDto modifyReqDto) {
        this.cacheService.delCacheByPattern("billStrategyKey*");
        BillStrategyEo billStrategyEo = (BillStrategyEo)((ExtQueryChainWrapper)this.billStrategyDas.filter().eq((Object)"id", (Object)modifyReqDto.getId())).one();
        if (null != billStrategyEo && null != billStrategyEo.getId()) {
            List applyColourType;
            List shopReqDtoList = modifyReqDto.getShopReqDtos();
            BillStrategyEo billStrategyUpdateEo = new BillStrategyEo();
            DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billStrategyUpdateEo, (String[])new String[]{"id"});
            billStrategyUpdateEo.setStrategyCode(billStrategyEo.getStrategyCode());
            List billApplyType = modifyReqDto.getBillApplyType();
            if (CollectionUtils.isNotEmpty((Collection)billApplyType)) {
                String billApplyTypeStr = String.join((CharSequence)REGEX, billApplyType);
                billStrategyUpdateEo.setBillApplyType(billApplyTypeStr);
            }
            if (CollectionUtils.isNotEmpty((Collection)(applyColourType = modifyReqDto.getApplyColourType()))) {
                String applyColourTypeStr = String.join((CharSequence)REGEX, applyColourType);
                billStrategyUpdateEo.setApplyColourType(applyColourTypeStr);
            }
            billStrategyUpdateEo.setId(billStrategyEo.getId());
            this.billStrategyDas.updateSelective((BaseEo)billStrategyUpdateEo);
            ArrayList shopEoList = new ArrayList();
            shopReqDtoList.forEach(reqDto -> {
                BillStrategyShopEo eo = new BillStrategyShopEo();
                eo.setShopCode(reqDto.getShopCode());
                eo.setShopName(reqDto.getShopName());
                eo.setBillStrategyId(billStrategyEo.getId());
                shopEoList.add(eo);
            });
            billStrategyEo.setCreateType(StrUtil.join((CharSequence)REGEX, (Iterable)modifyReqDto.getCreateTypeList()));
            if (CollectionUtils.isNotEmpty((Collection)modifyReqDto.getNationalSupplementOrder())) {
                billStrategyEo.setNationalSupplementOrder(StrUtil.join((CharSequence)REGEX, (Iterable)modifyReqDto.getNationalSupplementOrder()));
            }
            this.billStrategyShopDas.insertBatch(shopEoList);
            List billStrategyNoInvoiceItemReqDtoList = modifyReqDto.getBillStrategyNoInvoiceItemReqDtoList();
            if (CollectionUtils.isNotEmpty((Collection)billStrategyNoInvoiceItemReqDtoList)) {
                ArrayList billStrategyNoInvoiceItemEoList = new ArrayList();
                modifyReqDto.getBillStrategyNoInvoiceItemReqDtoList().forEach(item -> {
                    BillStrategyNoInvoiceItemEo billStrategyNoInvoiceItemEo = new BillStrategyNoInvoiceItemEo();
                    billStrategyNoInvoiceItemEo.setStrategyId(billStrategyEo.getId());
                    billStrategyNoInvoiceItemEo.setItemCode(item.getItemCode());
                    billStrategyNoInvoiceItemEo.setItemName(item.getItemName());
                    billStrategyNoInvoiceItemEoList.add(billStrategyNoInvoiceItemEo);
                });
                if (CollectionUtils.isNotEmpty(billStrategyNoInvoiceItemEoList)) {
                    this.billStrategyNoInvoiceItemDas.insertBatch(billStrategyNoInvoiceItemEoList);
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void modifyBillStrategy(BillStrategyReqDto modifyReqDto) {
        this.cacheService.delCacheByPattern("billStrategyKey*");
        this.checkParam(modifyReqDto);
        AssertUtil.isTrue(Objects.nonNull(modifyReqDto.getId()), "\u5f00\u7968\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(StringUtils.isNotBlank((CharSequence)modifyReqDto.getStrategyCode()), "\u5f00\u7968\u7b56\u7565\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        BillStrategyEo billStrategyEo = (BillStrategyEo)this.billStrategyMapper.selectById((Serializable)modifyReqDto.getId());
        AssertUtil.isTrue(Objects.nonNull(billStrategyEo), "\u975e\u6cd5\u6570\u636e\uff0c\u8bf7\u9000\u51fa\u5f53\u524d\u9875\uff0c\u5237\u65b0\u6570\u636e\u540e\u91cd\u8bd5");
        this.removeBillStrategy(Lists.newArrayList((Object[])new Long[]{modifyReqDto.getId()}));
        modifyReqDto.setCreatePerson(billStrategyEo.getCreatePerson());
        modifyReqDto.setCreateTime(billStrategyEo.getCreateTime());
        this.logger.info("\u7f16\u8f91\u5f00\u7968\u7b56\u7565\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)modifyReqDto));
        this.addBillStrategy(modifyReqDto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void updateApplyAudit(BillApplyAuditReqDto billApplyAuditReqDto) {
        this.cacheService.delCacheByPattern("billStrategyKey*");
        this.logger.info("\u5f00\u7968\u7b56\u7565\u6279\u91cf\u66f4\u65b0\u5ba1\u6838\u8bbe\u7f6e\uff1a{}", (Object)JSON.toJSONString((Object)billApplyAuditReqDto));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)billApplyAuditReqDto.getIds()), "\u5f00\u7968\u7b56\u7565id\u4e0d\u80fd\u4e3a\u7a7a");
        billApplyAuditReqDto.getIds().forEach(id -> {
            BillStrategyEo billStrategyEo = new BillStrategyEo();
            billStrategyEo.setId(id);
            billStrategyEo.setBillAudit(billApplyAuditReqDto.getBillAudit());
            if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billApplyAuditReqDto.getBillAudit())) {
                if (CollectionUtils.isNotEmpty((Collection)billApplyAuditReqDto.getBillApplyType())) {
                    String billApplyTypeStr = String.join((CharSequence)REGEX, billApplyAuditReqDto.getBillApplyType());
                    billStrategyEo.setBillApplyType(billApplyTypeStr);
                }
                if (CollectionUtils.isNotEmpty((Collection)billApplyAuditReqDto.getApplyColourType())) {
                    String applyColourTypeStr = String.join((CharSequence)REGEX, billApplyAuditReqDto.getApplyColourType());
                    billStrategyEo.setApplyColourType(applyColourTypeStr);
                }
                billStrategyEo.setCreateType(StrUtil.join((CharSequence)REGEX, (Iterable)billApplyAuditReqDto.getCreateTypeList()));
                if (CollectionUtils.isNotEmpty((Collection)billApplyAuditReqDto.getNationalSupplementOrder())) {
                    billStrategyEo.setNationalSupplementOrder(StrUtil.join((CharSequence)REGEX, (Iterable)billApplyAuditReqDto.getNationalSupplementOrder()));
                }
            } else {
                billStrategyEo.setBillApplyType("");
                billStrategyEo.setApplyColourType("");
            }
            this.billStrategyDas.updateSelective((BaseEo)billStrategyEo);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillStrategy(List<Long> ids) {
        List itemEoList;
        this.cacheService.delCacheByPattern("billStrategyKey*");
        this.logger.info("\u5220\u9664\u5f00\u7968\u7b56\u7565id\uff1a{}", (Object)JSON.toJSONString(ids));
        AssertUtil.isTrue(CollectionUtils.isNotEmpty(ids), "\u5f00\u7968\u7b56\u7565id\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.in((Object)"id", ids);
        queryWrapper.eq((Object)"dr", (Object)0);
        List eoList = this.billStrategyMapper.selectList((Wrapper)queryWrapper);
        AssertUtil.isTrue(CollectionUtils.isNotEmpty((Collection)eoList), "\u67e5\u8be2\u4e0d\u5230\u5f00\u7968\u7b56\u7565\u4fe1\u606f");
        List list = eoList.stream().filter(x -> BillStrategyStatusEnum.DISABLE.getCode().equals(x.getStrategyStatus())).map(BaseEo::getId).collect(Collectors.toList());
        QueryWrapper shopEoQueryWrapper = new QueryWrapper();
        shopEoQueryWrapper.in((Object)"bill_strategy_id", list);
        shopEoQueryWrapper.eq((Object)"dr", (Object)0);
        List strategyShopEos = this.billStrategyShopMapper.selectList((Wrapper)shopEoQueryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)strategyShopEos)) {
            List strategyShopIds = strategyShopEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            shopEoQueryWrapper.clear();
            shopEoQueryWrapper.in((Object)"id", strategyShopIds);
            this.billStrategyShopMapper.delete((Wrapper)shopEoQueryWrapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(itemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().in((Object)"strategy_id", list)).list()))) {
            itemEoList.forEach(item -> this.billStrategyNoInvoiceItemDas.deleteById(item.getId()));
        }
        this.billStrategyMapper.deleteBatchIds(list);
    }

    @Override
    public BillStrategyRespDto queryById(Long id) {
        BillStrategyEo billStrategyEo = (BillStrategyEo)this.billStrategyMapper.selectById((Serializable)id);
        this.logger.info("\u6839\u636eid\u67e5\u8be2\u7b56\u7565\u7ed3\u679cbillStrategyEo:{}", (Object)JSON.toJSONString((Object)billStrategyEo));
        List shopEos = this.billStrategyShopMapper.queryByStrategyId(id);
        this.logger.info("\u6839\u636e\u7b56\u7565id\u67e5\u8be2\u5173\u8054\u5e97\u94fa\u7ed3\u679cshopEos:{}", (Object)JSON.toJSONString((Object)shopEos));
        ArrayList shopRespDtos = Lists.newArrayList();
        shopEos.forEach(shopEo -> {
            BillStrategyShopRespDto shopRespDto = new BillStrategyShopRespDto();
            CubeBeanUtils.copyProperties((Object)shopRespDto, (Object)shopEo, (String[])new String[0]);
            shopRespDtos.add(shopRespDto);
        });
        BillStrategyRespDto billStrategyRespDto = new BillStrategyRespDto();
        DtoHelper.eo2Dto((BaseEo)billStrategyEo, (BaseVo)billStrategyRespDto);
        billStrategyRespDto.setRuleType(billStrategyEo.getBillRuleType());
        if (StringUtils.isNotBlank((CharSequence)billStrategyEo.getBillApplyType())) {
            ArrayList billApplyType = Lists.newArrayList((Object[])billStrategyEo.getBillApplyType().split(REGEX));
            billStrategyRespDto.setBillApplyType((List)billApplyType);
        }
        if (StringUtils.isNotBlank((CharSequence)billStrategyEo.getApplyColourType())) {
            ArrayList applyColourType = Lists.newArrayList((Object[])billStrategyEo.getApplyColourType().split(REGEX));
            billStrategyRespDto.setApplyColourType((List)applyColourType);
        }
        billStrategyRespDto.setCreateTypeList(StrUtil.split((CharSequence)billStrategyEo.getCreateType(), (CharSequence)REGEX));
        if (StringUtils.isNotBlank((CharSequence)billStrategyEo.getNationalSupplementOrder())) {
            ArrayList nationalSupplementOrder = Lists.newArrayList((Object[])billStrategyEo.getNationalSupplementOrder().split(REGEX));
            billStrategyRespDto.setNationalSupplementOrder((List)nationalSupplementOrder);
        }
        billStrategyRespDto.setShopRespDto((List)shopRespDtos);
        List itemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)id)).list();
        if (CollectionUtils.isNotEmpty((Collection)itemEoList)) {
            ArrayList itemRespDtoList = new ArrayList();
            CubeBeanUtils.copyCollection(itemRespDtoList, (Collection)itemEoList, BillStrategyNoInvoiceItemRespDto.class);
            billStrategyRespDto.setBillStrategyNoInvoiceItemRespDtoList(itemRespDtoList);
        }
        return billStrategyRespDto;
    }

    @Override
    public PageInfo<BillStrategyRespDto> queryByPage(BillStrategyQueryReqDto queryReqDto) {
        this.logger.info("\u5206\u9875\u67e5\u8be2\u5165\u53c2queryReqDto:{}", (Object)JSON.toJSONString((Object)queryReqDto));
        Integer pageNum = Objects.isNull(queryReqDto.getPageNum()) ? 1 : queryReqDto.getPageNum();
        Integer pageSize = Objects.isNull(queryReqDto.getPageSize()) ? 10 : queryReqDto.getPageSize();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStrategyName())) {
            queryWrapper.like((Object)"strategy_name", (Object)queryReqDto.getStrategyName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStrategyCode())) {
            queryWrapper.like((Object)"strategy_code", (Object)queryReqDto.getStrategyCode());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getBillEntityName())) {
            queryWrapper.like((Object)"bill_entity_name", (Object)queryReqDto.getBillEntityName());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStrategyStatus())) {
            queryWrapper.eq((Object)"strategy_status", (Object)queryReqDto.getStrategyStatus());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStrategyType())) {
            queryWrapper.eq((Object)"strategy_type", (Object)queryReqDto.getStrategyType());
        }
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getInvoiceType())) {
            queryWrapper.eq((Object)"invoice_type", (Object)queryReqDto.getInvoiceType());
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List eos = this.billStrategyMapper.selectList((Wrapper)queryWrapper);
        this.logger.info("\u5206\u9875\u67e5\u8be2\u51fa\u53c2eos:{}", (Object)JSON.toJSONString((Object)eos));
        PageInfo eoPageInfo = new PageInfo(eos);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillStrategyRespDto.class);
        this.logger.info("\u8fd4\u56de\u5217\u8868dtoList:{}", (Object)JSON.toJSONString(dtoList));
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public void modifyStatus(BillApplyAuditModifyStatusReqDto reqDto) {
        this.cacheService.delCacheByPattern("billStrategyKey*");
        this.logger.info("\u4fee\u6539\u5f00\u7968\u7b56\u7565\u72b6\u6001\u5165\u53c2id\uff1a{}\uff0c\u72b6\u6001\uff1a{}", (Object)JSON.toJSONString((Object)reqDto.getId()), (Object)reqDto.getStrategyStatus());
        BillStrategyStatusEnum statusEnum = BillStrategyStatusEnum.getByCode((String)reqDto.getStrategyStatus());
        AssertUtil.isTrue(Objects.nonNull(statusEnum), "\u6ca1\u6709\u8be5\u72b6\u6001\uff0c\u8bf7\u68c0\u67e5");
        BillStrategyEo billStrategyEo = (BillStrategyEo)this.billStrategyMapper.selectById((Serializable)reqDto.getId());
        this.logger.info("\u6570\u636e\u5e93\u67e5\u8be2\u5230\u7b56\u7565\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)billStrategyEo));
        AssertUtil.isTrue(Objects.nonNull(billStrategyEo), "\u67e5\u8be2\u4e0d\u5230\u5f00\u7968\u7b56\u7565\u4fe1\u606f");
        AssertUtil.isTrue(!reqDto.getStrategyStatus().equals(billStrategyEo.getStrategyStatus()), String.format("\u5df2\u662f\uff1a%s\u72b6\u6001\uff0c\u8bf7\u5237\u65b0\u67e5\u770b", statusEnum.getDesc()));
        billStrategyEo.setStrategyStatus(reqDto.getStrategyStatus());
        this.billStrategyDas.update((BaseEo)billStrategyEo);
        this.cacheService.delCacheByPattern(BILL_STRATEGY_CACHE_KEY);
    }

    @Override
    public BillStrategyRespDto queryByShopCode(String shopCode) {
        if (StringUtils.isBlank((CharSequence)shopCode)) {
            return null;
        }
        BillStrategyEo eo = this.billStrategyMapper.queryByShopCode(shopCode);
        BillStrategyRespDto respDto = new BillStrategyRespDto();
        if (Objects.nonNull(eo)) {
            CubeBeanUtils.copyProperties((Object)respDto, (Object)eo, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)eo.getBillApplyType())) {
                ArrayList billApplyType = Lists.newArrayList((Object[])eo.getBillApplyType().split(REGEX));
                respDto.setBillApplyType((List)billApplyType);
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getApplyColourType())) {
                ArrayList applyColourType = Lists.newArrayList((Object[])eo.getApplyColourType().split(REGEX));
                respDto.setApplyColourType((List)applyColourType);
            }
            respDto.setCreateTypeList(StrUtil.split((CharSequence)eo.getCreateType(), (CharSequence)REGEX));
        }
        return respDto;
    }

    @Override
    public BillStrategyRespDto queryByShopCodeAndType(String shopCode, String type) {
        if (StringUtils.isBlank((CharSequence)shopCode) || StringUtils.isBlank((CharSequence)type)) {
            return null;
        }
        BillStrategyRespDto cacheVal = (BillStrategyRespDto)this.cacheService.getCache(this.getKey(shopCode, type), (TypeReference)new TypeReference<BillStrategyRespDto>(){});
        if (cacheVal != null) {
            return cacheVal;
        }
        BillStrategyEo eo = this.billStrategyMapper.queryByShopCodeAndType(shopCode, type);
        BillStrategyRespDto respDto = new BillStrategyRespDto();
        if (Objects.nonNull(eo)) {
            CubeBeanUtils.copyProperties((Object)respDto, (Object)eo, (String[])new String[0]);
            if (StringUtils.isNotBlank((CharSequence)eo.getBillApplyType())) {
                ArrayList billApplyType = Lists.newArrayList((Object[])eo.getBillApplyType().split(REGEX));
                respDto.setBillApplyType((List)billApplyType);
            }
            if (StringUtils.isNotBlank((CharSequence)eo.getApplyColourType())) {
                ArrayList applyColoutType = Lists.newArrayList((Object[])eo.getApplyColourType().split(REGEX));
                respDto.setApplyColourType((List)applyColoutType);
            }
            respDto.setCreateTypeList(StrUtil.split((CharSequence)eo.getCreateType(), (CharSequence)REGEX));
            respDto.setNationalSupplementOrder(StrUtil.split((CharSequence)eo.getNationalSupplementOrder(), (CharSequence)REGEX));
            respDto.setUseBlackList(eo.getUseBlackList());
            respDto.setBlackListContent(eo.getBlackListContent());
            this.cacheService.setCache(this.getKey(shopCode, type), (Object)respDto, 3600);
        } else {
            this.cacheService.setCache(this.getKey(shopCode, type), (Object)respDto, 120);
        }
        return respDto;
    }

    private String getKey(String shopCode, String type) {
        return "billStrategyKey_" + shopCode + "_" + type;
    }
}

