/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.NumberUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.KeepRelatedTradeConfigConverter;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepRelatedShopMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.KeepRelatedTradeMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.ShopMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepRelatedShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepRelatedTradeConfigDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepRelatedTradeDomain;
import com.yunxi.dg.base.center.finance.dto.entity.ExportRelatedConfigTradeShopMatchDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeConfigPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeDto;
import com.yunxi.dg.base.center.finance.dto.entity.KeepRelatedTradeShopConfigDto;
import com.yunxi.dg.base.center.finance.dto.entity.RelatedTradeShopMatchDto;
import com.yunxi.dg.base.center.finance.dto.entity.RelatedTradeShopMatchQueryDto;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.eo.KeepRelatedShopEo;
import com.yunxi.dg.base.center.finance.eo.KeepRelatedTradeConfigEo;
import com.yunxi.dg.base.center.finance.eo.KeepRelatedTradeEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepRelatedTradeConfigService;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.shop.dto.SiteDto;
import com.yunxi.dg.base.center.shop.proxy.ISiteApiProxy;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepRelatedTradeConfigServiceImpl
extends BaseServiceImpl<KeepRelatedTradeConfigDto, KeepRelatedTradeConfigEo, IKeepRelatedTradeConfigDomain>
implements IKeepRelatedTradeConfigService {
    private static final Logger log = LoggerFactory.getLogger(KeepRelatedTradeConfigServiceImpl.class);
    @Resource
    private IKeepRelatedTradeDomain tradeDomain;
    @Resource
    private IKeepRelatedShopDomain shopDomain;
    @Resource
    private KeepRelatedTradeMapper tradeMapper;
    @Resource
    private KeepRelatedShopMapper relatedShopMapper;
    @Resource
    private ISiteApiProxy siteApiProxy;
    @Resource
    private ShopMapper shopMapper;

    public KeepRelatedTradeConfigServiceImpl(IKeepRelatedTradeConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepRelatedTradeConfigDto, KeepRelatedTradeConfigEo> converter() {
        return KeepRelatedTradeConfigConverter.INSTANCE;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Long saveOrUpdate(KeepRelatedTradeShopConfigDto dto) {
        log.info("\u65b0\u589e\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        this.validate(dto);
        KeepRelatedTradeConfigEo configEo = new KeepRelatedTradeConfigEo();
        if (Objects.isNull(dto.getId())) {
            Date endTime;
            Date startTime;
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.RELATED_TRADE_SHOP.getCode());
            String ruleCode = generateCodeService.getCode("GLGZ");
            List tradeConfigEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IKeepRelatedTradeConfigDomain)this.domain).filter().eq((Object)"rule_name", (Object)dto.getRuleName())).eq((Object)"site_code", (Object)dto.getSiteCode())).list();
            AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)tradeConfigEos), (String)"\u5df2\u5b58\u5728\u540c\u4e00\u89c4\u5219\u540c\u4e00\u6e20\u9053\u6570\u636e!");
            this.validateRule(dto, false);
            Map relatedTradeDtoMap = dto.getRelatedTradeDtos().stream().collect(Collectors.toMap(x -> x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
            Map relatedShopDtoMap = dto.getRelatedShopDtos().stream().collect(Collectors.toMap(x -> x.getShopCode(), Function.identity(), (k1, k2) -> k1));
            RelatedTradeShopMatchQueryDto queryDto = new RelatedTradeShopMatchQueryDto();
            queryDto.setSiteCodes(Arrays.asList(dto.getSiteCode()));
            queryDto.setRelatedEntityNumbers(dto.getRelatedTradeDtos().stream().map(KeepRelatedTradeDto::getRelatedEntityNumber).distinct().collect(Collectors.toList()));
            queryDto.setEnable(Integer.valueOf(0));
            List tradeShopMatchDtos = ((IKeepRelatedTradeConfigDomain)this.domain).queryList(queryDto);
            log.info("tradeShopMatchDtos:{}", (Object)JSONObject.toJSONString((Object)tradeShopMatchDtos));
            if (CollectionUtil.isNotEmpty((Collection)tradeShopMatchDtos)) {
                AtomicReference<Boolean> isTradeShopMatch = new AtomicReference<Boolean>(Boolean.FALSE);
                Map tradeShopMatchDtoMap = tradeShopMatchDtos.stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getShopCode() + ";" + x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
                tradeShopMatchDtoMap.forEach((k, v) -> {
                    RelatedTradeShopMatchDto tradeShopMatchDto = v;
                    if (dto.getSiteCode().equals(tradeShopMatchDto.getSiteCode()) && relatedTradeDtoMap.containsKey(tradeShopMatchDto.getPlatformSellerEntityNumber() + ";" + tradeShopMatchDto.getRelatedEntityNumber()) && relatedShopDtoMap.containsKey(tradeShopMatchDto.getShopCode())) {
                        isTradeShopMatch.set(Boolean.TRUE);
                        return;
                    }
                });
                if (isTradeShopMatch.get().booleanValue()) {
                    throw new BizException("\u5b58\u5728\u5176\u4ed6\u540c\u4e00\u6e20\u9053\u540c\u4e00\u5e97\u94fa\uff0c\u540c\u4e00\u5173\u8054\u4e3b\u4f53\uff0c\u540c\u4e00\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u5b58\u5728\u542f\u7528\u6570\u636e\uff0c\u8bf7\u5148\u7981\u7528!");
                }
            }
            if ((startTime = DateUtil.parseDate((String)(dto.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss")).after(endTime = DateUtil.parseDate((String)(dto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss"))) {
                throw new BizException("\u89c4\u5219\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            }
            configEo = new KeepRelatedTradeConfigEo();
            configEo.setRuleName(dto.getRuleName());
            configEo.setRuleCode(ruleCode);
            configEo.setSiteCode(dto.getSiteCode());
            configEo.setSiteName(dto.getSiteName());
            configEo.setRemark(dto.getRemark());
            configEo.setEnable(Integer.valueOf(0));
            configEo.setEffectBeginTime(dto.getEffectBeginTime());
            configEo.setEffectEndTime(dto.getEffectEndTime());
            List tradeEos = dto.getRelatedTradeDtos().stream().map(v -> {
                KeepRelatedTradeEo tradeEo = new KeepRelatedTradeEo();
                tradeEo.setRuleCode(ruleCode);
                tradeEo.setPlatformSellerEntityNumber(v.getPlatformSellerEntityNumber());
                tradeEo.setRelatedEntityId(v.getRelatedEntityId());
                tradeEo.setRelatedEntityNumber(v.getRelatedEntityNumber());
                tradeEo.setRelatedEntityName(v.getRelatedEntityName());
                tradeEo.setOwnEntity(v.getOwnEntity());
                tradeEo.setCommission(v.getCommission());
                tradeEo.setCustomerId(v.getCustomerId());
                tradeEo.setCustomerCode(v.getCustomerCode());
                tradeEo.setCustomerName(v.getCustomerName());
                tradeEo.setSaleAreaId(v.getSaleAreaId());
                tradeEo.setSaleAreaName(v.getSaleAreaName());
                tradeEo.setSaleAreaCode(v.getSaleAreaCode());
                tradeEo.setSaleDeptId(v.getSaleDeptId());
                tradeEo.setSaleDeptCode(v.getSaleDeptCode());
                tradeEo.setSaleDeptName(v.getSaleDeptName());
                return tradeEo;
            }).collect(Collectors.toList());
            List shopEos = dto.getRelatedShopDtos().stream().map(v -> {
                KeepRelatedShopEo shopEo = new KeepRelatedShopEo();
                shopEo.setShopId(v.getShopId());
                shopEo.setShopName(v.getShopName());
                shopEo.setShopCode(v.getShopCode());
                shopEo.setRuleCode(ruleCode);
                return shopEo;
            }).collect(Collectors.toList());
            if (Objects.nonNull(configEo)) {
                ((IKeepRelatedTradeConfigDomain)this.domain).insert((BaseEo)configEo);
                this.tradeDomain.insertBatch(tradeEos);
                this.shopDomain.insertBatch(shopEos);
            }
        } else {
            configEo = (KeepRelatedTradeConfigEo)((IKeepRelatedTradeConfigDomain)this.domain).selectByPrimaryKey(dto.getId());
            dto.setRuleCode(configEo.getRuleCode());
            this.validateRule(dto, true);
            List relatedTradeEosList = ((ExtQueryChainWrapper)this.tradeDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
            Map relatedTradeEoMap = relatedTradeEosList.stream().collect(Collectors.toMap(x -> x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
            List relatedShopEosList = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
            Map relatedShopEoMap = relatedShopEosList.stream().collect(Collectors.toMap(KeepRelatedShopEo::getShopCode, Function.identity(), (k1, k2) -> k1));
            RelatedTradeShopMatchQueryDto queryDto = new RelatedTradeShopMatchQueryDto();
            queryDto.setRuleCodes(Arrays.asList(configEo.getRuleCode()));
            queryDto.setRelatedEntityNumbers(dto.getRelatedTradeDtos().stream().map(KeepRelatedTradeDto::getRelatedEntityNumber).distinct().collect(Collectors.toList()));
            queryDto.setEnable(Integer.valueOf(0));
            List tradeShopMatchDtos = ((IKeepRelatedTradeConfigDomain)this.domain).queryList(queryDto);
            log.info("tradeShopMatchDtos:{}", (Object)JSONObject.toJSONString((Object)tradeShopMatchDtos));
            if (CollectionUtil.isNotEmpty((Collection)tradeShopMatchDtos)) {
                AtomicReference<Boolean> isTradeShopMatch = new AtomicReference<Boolean>(Boolean.FALSE);
                Map tradeShopMatchDtoMap = tradeShopMatchDtos.stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getShopCode() + ";" + x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
                tradeShopMatchDtoMap.forEach((k, v) -> {
                    RelatedTradeShopMatchDto tradeShopMatchDto = v;
                    if (dto.getSiteCode().equals(tradeShopMatchDto.getSiteCode()) && relatedTradeEoMap.containsKey(tradeShopMatchDto.getPlatformSellerEntityNumber() + ";" + tradeShopMatchDto.getRelatedEntityNumber()) && relatedShopEoMap.containsKey(tradeShopMatchDto.getShopCode())) {
                        isTradeShopMatch.set(Boolean.TRUE);
                        return;
                    }
                });
                if (isTradeShopMatch.get().booleanValue()) {
                    throw new BizException("\u5b58\u5728\u5176\u4ed6\u540c\u4e00\u6e20\u9053\u540c\u4e00\u5e97\u94fa\uff0c\u540c\u4e00\u5173\u8054\u4e3b\u4f53\uff0c\u540c\u4e00\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u5b58\u5728\u542f\u7528\u6570\u636e\uff0c\u8bf7\u5148\u7981\u7528!");
                }
            }
            AssertUtils.notNull((Object)configEo, (String)"\u4fee\u6539\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
            String ruleCode = configEo.getRuleCode();
            configEo.setRuleName(dto.getRuleName());
            configEo.setRuleCode(ruleCode);
            configEo.setSiteCode(dto.getSiteCode());
            configEo.setSiteName(dto.getSiteName());
            configEo.setRemark(dto.getRemark());
            configEo.setEnable(Integer.valueOf(0));
            configEo.setEffectBeginTime(dto.getEffectBeginTime());
            configEo.setEffectEndTime(dto.getEffectEndTime());
            Date startTime = DateUtil.parseDate((String)(dto.getEffectBeginTime() + " 00:00:00"), (String)"yyyy-MM-dd HH:mm:ss");
            Date endTime = DateUtil.parseDate((String)(dto.getEffectEndTime() + " 23:59:59"), (String)"yyyy-MM-dd HH:mm:ss");
            if (startTime.after(endTime)) {
                throw new BizException("\u89c4\u5219\u6709\u6548\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u7ed3\u675f\u65e5\u671f");
            }
            configEo.setEnable(configEo.getEnable());
            List tradeEos = dto.getRelatedTradeDtos().stream().map(v -> {
                KeepRelatedTradeEo tradeEo = new KeepRelatedTradeEo();
                tradeEo.setRuleCode(ruleCode);
                tradeEo.setPlatformSellerEntityNumber(v.getPlatformSellerEntityNumber());
                tradeEo.setRelatedEntityId(v.getRelatedEntityId());
                tradeEo.setRelatedEntityNumber(v.getRelatedEntityNumber());
                tradeEo.setRelatedEntityName(v.getRelatedEntityName());
                tradeEo.setOwnEntity(v.getOwnEntity());
                tradeEo.setCommission(v.getCommission());
                tradeEo.setCustomerId(v.getCustomerId());
                tradeEo.setCustomerCode(v.getCustomerCode());
                tradeEo.setCustomerName(v.getCustomerName());
                tradeEo.setSaleAreaId(v.getSaleAreaId());
                tradeEo.setSaleAreaName(v.getSaleAreaName());
                tradeEo.setSaleAreaCode(v.getSaleAreaCode());
                tradeEo.setSaleDeptId(v.getSaleDeptId());
                tradeEo.setSaleDeptCode(v.getSaleDeptCode());
                tradeEo.setSaleDeptName(v.getSaleDeptName());
                return tradeEo;
            }).collect(Collectors.toList());
            List shopEos = dto.getRelatedShopDtos().stream().map(v -> {
                KeepRelatedShopEo shopEo = new KeepRelatedShopEo();
                shopEo.setShopId(v.getShopId());
                shopEo.setShopName(v.getShopName());
                shopEo.setShopCode(v.getShopCode());
                shopEo.setRuleCode(ruleCode);
                return shopEo;
            }).collect(Collectors.toList());
            if (Objects.nonNull(configEo)) {
                ((IKeepRelatedTradeConfigDomain)this.domain).updateSelective((BaseEo)configEo);
                List relatedTradeEos = ((ExtQueryChainWrapper)this.tradeDomain.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
                if (CollectionUtil.isNotEmpty((Collection)relatedTradeEos)) {
                    KeepRelatedTradeEo relatedTradeEo = new KeepRelatedTradeEo();
                    relatedTradeEo.setRuleCode(ruleCode);
                    this.tradeDomain.logicDelete((BaseEo)relatedTradeEo);
                }
                this.tradeDomain.insertBatch(tradeEos);
                List relatedShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)ruleCode)).list();
                if (CollectionUtil.isNotEmpty((Collection)relatedShopEos)) {
                    KeepRelatedShopEo relatedShopEo = new KeepRelatedShopEo();
                    relatedShopEo.setRuleCode(ruleCode);
                    this.shopDomain.logicDelete((BaseEo)relatedShopEo);
                }
                this.shopDomain.insertBatch(shopEos);
            }
        }
        return configEo.getId();
    }

    private void validate(KeepRelatedTradeShopConfigDto dto) {
        AssertUtils.notNull((Object)dto, (String)"\u65b0\u589e\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getRuleName(), (String)"\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getSiteName(), (String)"\u6e20\u9053\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getSiteCode(), (String)"\u6e20\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getEffectBeginTime(), (String)"\u89c4\u5219\u6709\u6548\u671f\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notNull((Object)dto.getEffectEndTime(), (String)"\u89c4\u5219\u6709\u6548\u671f\u7ed3\u675f\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notEmpty((Collection)dto.getRelatedTradeDtos(), (String)"\u5173\u8054\u4ea4\u6613\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtils.notEmpty((Collection)dto.getRelatedShopDtos(), (String)"\u9002\u7528\u5e97\u94fa\u4e0d\u80fd\u4e3a\u7a7a!");
        if (dto.getRuleName().length() > 128) {
            throw new BizException("\u89c4\u5219\u540d\u79f0\u4e0d\u80fd\u8d85\u8fc7128\u4e2a\u5b57\u7b26!");
        }
        StringBuffer buffer = new StringBuffer();
        Set platformSellerEntityNumberSet = dto.getRelatedTradeDtos().stream().map(KeepRelatedTradeDto::getPlatformSellerEntityNumber).collect(Collectors.toSet());
        List platformSellerEntityNumberList = dto.getRelatedTradeDtos().stream().map(KeepRelatedTradeDto::getPlatformSellerEntityNumber).collect(Collectors.toList());
        if (platformSellerEntityNumberSet.size() != platformSellerEntityNumberList.size()) {
            throw new BizException("\u5b58\u5728\u76f8\u540c\u7684\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7");
        }
        dto.getRelatedTradeDtos().forEach(v -> {
            if (StringUtils.isBlank((CharSequence)v.getCommission())) {
                buffer.append("\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7: " + v.getPlatformSellerEntityNumber()).append("\u7684\u4f63\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a!\n");
            } else if (!NumberUtil.isNumber((CharSequence)v.getCommission())) {
                buffer.append("\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7:" + v.getPlatformSellerEntityNumber()).append("\u7684\u4f63\u91d1\u6bd4\u4f8b\u683c\u5f0f\u4e0d\u6b63\u786e!\n");
            } else if (Convert.toBigDecimal((Object)v.getCommission()).intValue() < 0 || Convert.toBigDecimal((Object)v.getCommission()).compareTo(new BigDecimal("100")) > 0) {
                buffer.append("\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u7f16\u53f7:" + v.getPlatformSellerEntityNumber()).append("\u7684\u4f63\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u5c0f\u4e8e0\u6216\u8005\u4e0d\u80fd\u5927\u4e8e100!\n");
            }
        });
        if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
            AssertUtils.notNull((Object)buffer.toString(), (String)buffer.toString());
        }
        List<String> shopCodes = dto.getRelatedShopDtos().stream().map(KeepRelatedShopDto::getShopCode).distinct().collect(Collectors.toList());
        Set shopCodesSet = dto.getRelatedShopDtos().stream().map(KeepRelatedShopDto::getShopCode).collect(Collectors.toSet());
        if (shopCodes.size() != shopCodesSet.size()) {
            throw new BizException("\u5b58\u5728\u76f8\u540c\u7684\u5e97\u94fa\u914d\u7f6e");
        }
        Map<String, ShopEo> shopEoMap = this.getShop(shopCodes);
        StringBuffer stringBuffer = new StringBuffer();
        dto.getRelatedShopDtos().forEach(v -> {
            if (shopEoMap.containsKey(v.getShopCode())) {
                ShopEo shopEo = (ShopEo)shopEoMap.get(v.getShopCode());
                if (!dto.getSiteCode().equals(shopEo.getChannelCode())) {
                    stringBuffer.append(v.getShopCode()).append("\u7684\u6e20\u9053: " + shopEo.getChannelCode() + "\u4e0e\u89c4\u5219\u6e20\u9053: " + dto.getSiteCode() + "\u4e0d\u5339\u914d!\n");
                }
            }
        });
        if (StringUtils.isNotBlank((CharSequence)stringBuffer.toString())) {
            AssertUtils.notNull((Object)stringBuffer.toString(), (String)stringBuffer.toString());
        }
    }

    private void validateSiteAndRelatedEntity(KeepRelatedTradeShopConfigDto dto, boolean isUpdate) {
        ExtQueryChainWrapper sqlFilters = ((IKeepRelatedTradeConfigDomain)this.domain).filter();
        if (isUpdate) {
            sqlFilters.ne((Object)"rule_code", (Object)dto.getRuleCode());
        } else {
            sqlFilters.eq((Object)"site_code", (Object)dto.getSiteCode());
        }
        List tradeConfigEoList = sqlFilters.list();
        if (CollectionUtil.isEmpty((Collection)tradeConfigEoList)) {
            return;
        }
        Map tradeConfigEoMap = tradeConfigEoList.stream().collect(Collectors.toMap(KeepRelatedTradeConfigEo::getRuleCode, Function.identity(), (k1, k2) -> k1));
        List relatedTradeEos = ((ExtQueryChainWrapper)this.tradeDomain.filter().in((Object)"rule_code", (Collection)tradeConfigEoList.stream().map(KeepRelatedTradeConfigEo::getRuleCode).collect(Collectors.toList()))).list();
        relatedTradeEos.forEach(v -> {
            if (tradeConfigEoMap.containsKey(v.getRuleCode())) {
                v.setSiteCode(((KeepRelatedTradeConfigEo)tradeConfigEoMap.get(v.getRuleCode())).getSiteCode());
            }
        });
        Map<String, List<KeepRelatedTradeEo>> relatedTradeEoListMap = relatedTradeEos.stream().collect(Collectors.groupingBy(KeepRelatedTradeEo::getRuleCode));
        List relatedShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"rule_code", (Collection)tradeConfigEoList.stream().map(KeepRelatedTradeConfigEo::getRuleCode).collect(Collectors.toList()))).list();
        relatedShopEos.forEach(v -> {
            if (tradeConfigEoMap.containsKey(v.getRuleCode())) {
                v.setSiteCode(((KeepRelatedTradeConfigEo)tradeConfigEoMap.get(v.getRuleCode())).getSiteCode());
            }
        });
        Map<String, List<KeepRelatedShopEo>> relatedShopEoListMap = relatedShopEos.stream().collect(Collectors.groupingBy(KeepRelatedShopEo::getRuleCode));
        dto.getRelatedTradeDtos().forEach(v -> v.setSiteCode(dto.getSiteCode()));
        dto.getRelatedShopDtos().forEach(v -> v.setSiteCode(dto.getSiteCode()));
        Map relatedShopDtoMap = dto.getRelatedShopDtos().stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getShopCode(), Function.identity(), (k1, k2) -> k1));
        Map relatedTradeDtoMap = dto.getRelatedTradeDtos().stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
        StringBuffer buffer = new StringBuffer();
        tradeConfigEoMap.forEach((k, v) -> {
            List relatedTradeEoList = (List)relatedTradeEoListMap.get(k);
            boolean tradeAnyMatch = relatedTradeEoList.stream().anyMatch(x -> relatedTradeDtoMap.containsKey(x.getSiteCode() + ";" + x.getRelatedEntityNumber()));
            List relatedShopEoList = (List)relatedShopEoListMap.get(k);
            boolean shopAnyMatch = relatedShopEoList.stream().anyMatch(x -> relatedShopDtoMap.containsKey(x.getSiteCode() + ";" + x.getShopCode()));
            if (tradeAnyMatch && shopAnyMatch) {
                buffer.append("\u6e20\u9053\uff1a" + dto.getSiteName() + "\u5df2\u5b58\u5728\u5bf9\u5e94\u5173\u8054\u4e3b\u4f53\u4e0e\u5e97\u94fa!\n");
            }
        });
        if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
            AssertUtils.notNull((Object)buffer.toString(), (String)buffer.toString());
        }
    }

    private void validateRule(KeepRelatedTradeShopConfigDto dto, boolean isUpdate) {
        List tradeConfigEoList;
        ExtQueryChainWrapper sqlFilters = ((IKeepRelatedTradeConfigDomain)this.domain).filter();
        if (StringUtils.isNotBlank((CharSequence)dto.getSiteCode())) {
            sqlFilters.eq((Object)"site_code", (Object)dto.getSiteCode());
        }
        if (isUpdate) {
            sqlFilters.ne((Object)"rule_code", (Object)dto.getRuleCode());
        }
        if (CollectionUtil.isEmpty((Collection)(tradeConfigEoList = sqlFilters.list()))) {
            return;
        }
        Map tradeConfigEoMap = tradeConfigEoList.stream().collect(Collectors.toMap(KeepRelatedTradeConfigEo::getRuleCode, Function.identity(), (k1, k2) -> k1));
        List ruleCodes = tradeConfigEoList.stream().map(KeepRelatedTradeConfigEo::getRuleCode).collect(Collectors.toList());
        List shopEoList = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"rule_code", ruleCodes)).list();
        if (CollectionUtil.isEmpty((Collection)shopEoList)) {
            return;
        }
        Map<String, List<KeepRelatedShopEo>> relatedShopEoMap = shopEoList.stream().collect(Collectors.groupingBy(KeepRelatedShopEo::getRuleCode));
        Map relatedShopDtoMap = dto.getRelatedShopDtos().stream().collect(Collectors.toMap(KeepRelatedShopDto::getShopCode, Function.identity(), (k1, k2) -> k1));
        StringBuffer buffer = new StringBuffer();
        tradeConfigEoMap.forEach((k, v) -> {
            if (relatedShopEoMap.containsKey(k)) {
                List relatedShopEos = (List)relatedShopEoMap.get(k);
                relatedShopEos.forEach(i -> {
                    if (relatedShopDtoMap.containsKey(i.getShopCode())) {
                        buffer.append("\u5e97\u94fa\uff1a" + i.getShopCode()).append("\u5728\u89c4\u5219: " + v.getRuleName() + "\u4e2d\u5df2\u5b58\u5728!\n");
                    }
                });
            }
        });
        if (StringUtils.isNotBlank((CharSequence)buffer.toString())) {
            AssertUtils.notNull((Object)buffer.toString(), (String)buffer.toString());
        }
    }

    @Override
    public KeepRelatedTradeShopConfigDto detail(Long id) {
        List shopEos;
        KeepRelatedTradeShopConfigDto configDto = new KeepRelatedTradeShopConfigDto();
        KeepRelatedTradeConfigEo configEo = (KeepRelatedTradeConfigEo)((ExtQueryChainWrapper)((IKeepRelatedTradeConfigDomain)this.domain).filter().eq((Object)"id", (Object)id)).one();
        AssertUtils.notNull((Object)configEo, (String)"\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        configDto.setId(configEo.getId());
        configDto.setRuleCode(configEo.getRuleCode());
        configDto.setRuleName(configEo.getRuleName());
        configDto.setSiteCode(configEo.getSiteCode());
        configDto.setSiteName(configEo.getSiteName());
        configDto.setEnable(configEo.getEnable());
        configDto.setRemark(configEo.getRemark());
        configDto.setEffectBeginTime(configEo.getEffectBeginTime());
        configDto.setEffectEndTime(configEo.getEffectEndTime());
        configDto.setUpdateTime(configEo.getUpdateTime());
        configDto.setUpdatePerson(configEo.getUpdatePerson());
        List tradeEos = ((ExtQueryChainWrapper)this.tradeDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)tradeEos)) {
            List tradeDtos = tradeEos.stream().map(v -> {
                KeepRelatedTradeDto tradeDto = new KeepRelatedTradeDto();
                CubeBeanUtils.copyProperties((Object)tradeDto, (Object)v, (String[])new String[0]);
                return tradeDto;
            }).collect(Collectors.toList());
            configDto.setRelatedTradeDtos(tradeDtos);
        }
        if (CollectionUtil.isNotEmpty((Collection)(shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list()))) {
            List shopDtos = shopEos.stream().map(v -> {
                KeepRelatedShopDto shopDto = new KeepRelatedShopDto();
                CubeBeanUtils.copyProperties((Object)shopDto, (Object)v, (String[])new String[0]);
                return shopDto;
            }).collect(Collectors.toList());
            configDto.setRelatedShopDtos(shopDtos);
        }
        return configDto;
    }

    @Override
    public void deleteConfig(Long id) {
        List shopEos;
        KeepRelatedTradeConfigEo configEo = (KeepRelatedTradeConfigEo)((IKeepRelatedTradeConfigDomain)this.domain).selectByPrimaryKey(id);
        AssertUtils.notNull((Object)configEo, (String)"\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        ((IKeepRelatedTradeConfigDomain)this.domain).logicDeleteById(id);
        List tradeEos = ((ExtQueryChainWrapper)this.tradeDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
        if (CollectionUtil.isNotEmpty((Collection)tradeEos)) {
            KeepRelatedTradeEo relatedTradeEo = new KeepRelatedTradeEo();
            relatedTradeEo.setRuleCode(configEo.getRuleCode());
            this.tradeDomain.logicDelete((BaseEo)relatedTradeEo);
        }
        if (CollectionUtil.isNotEmpty((Collection)(shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list()))) {
            KeepRelatedShopEo relatedShopEo = new KeepRelatedShopEo();
            relatedShopEo.setRuleCode(configEo.getRuleCode());
            this.shopDomain.logicDelete((BaseEo)relatedShopEo);
        }
    }

    @Override
    public void enable(KeepRelatedTradeConfigDto dto) {
        KeepRelatedTradeConfigEo configEo = (KeepRelatedTradeConfigEo)((IKeepRelatedTradeConfigDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)configEo, (String)"\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u4e0d\u5b58\u5728!");
        KeepRelatedTradeConfigEo tradeConfigEo = new KeepRelatedTradeConfigEo();
        tradeConfigEo.setId(dto.getId());
        tradeConfigEo.setEnable(dto.getEnable());
        if (null != dto.getEnable() && 0 == dto.getEnable()) {
            List relatedTradeEos = ((ExtQueryChainWrapper)this.tradeDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
            Map relatedTradeEoMap = relatedTradeEos.stream().collect(Collectors.toMap(x -> x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
            List relatedShopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().eq((Object)"rule_code", (Object)configEo.getRuleCode())).list();
            Map relatedShopEoMap = relatedShopEos.stream().collect(Collectors.toMap(KeepRelatedShopEo::getShopCode, Function.identity(), (k1, k2) -> k1));
            RelatedTradeShopMatchQueryDto queryDto = new RelatedTradeShopMatchQueryDto();
            queryDto.setRuleCodes(Arrays.asList(configEo.getRuleCode()));
            queryDto.setRelatedEntityNumbers(relatedTradeEos.stream().map(KeepRelatedTradeEo::getRelatedEntityNumber).distinct().collect(Collectors.toList()));
            queryDto.setEnable(Integer.valueOf(0));
            List tradeShopMatchDtos = ((IKeepRelatedTradeConfigDomain)this.domain).queryList(queryDto);
            log.info("tradeShopMatchDtos:{}", (Object)JSONObject.toJSONString((Object)tradeShopMatchDtos));
            if (CollectionUtil.isNotEmpty((Collection)tradeShopMatchDtos)) {
                AtomicReference<Boolean> isTradeShopMatch = new AtomicReference<Boolean>(Boolean.FALSE);
                Map tradeShopMatchDtoMap = tradeShopMatchDtos.stream().collect(Collectors.toMap(x -> x.getSiteCode() + ";" + x.getShopCode() + ";" + x.getPlatformSellerEntityNumber() + ";" + x.getRelatedEntityNumber(), Function.identity(), (k1, k2) -> k1));
                tradeShopMatchDtoMap.forEach((k, v) -> {
                    RelatedTradeShopMatchDto tradeShopMatchDto = v;
                    if (dto.getSiteCode().equals(tradeShopMatchDto.getSiteCode()) && relatedTradeEoMap.containsKey(tradeShopMatchDto.getPlatformSellerEntityNumber() + ";" + tradeShopMatchDto.getRelatedEntityNumber()) && relatedShopEoMap.containsKey(tradeShopMatchDto.getShopCode())) {
                        isTradeShopMatch.set(Boolean.TRUE);
                        return;
                    }
                });
                if (isTradeShopMatch.get().booleanValue()) {
                    throw new BizException("\u5b58\u5728\u5176\u4ed6\u540c\u4e00\u6e20\u9053\u540c\u4e00\u5e97\u94fa\uff0c\u540c\u4e00\u5173\u8054\u4e3b\u4f53\uff0c\u540c\u4e00\u5e73\u53f0\u9500\u552e\u4e3b\u4f53\u5b58\u5728\u542f\u7528\u6570\u636e\uff0c\u8bf7\u5148\u7981\u7528!");
                }
            }
        }
        ((IKeepRelatedTradeConfigDomain)this.domain).updateSelective((BaseEo)tradeConfigEo);
    }

    @Override
    public PageInfo<KeepRelatedTradeShopConfigDto> queryPage(KeepRelatedTradeConfigPageReqDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<KeepRelatedTradeConfigEo> params = this.assembleCondition(dto);
        PageInfo eoPageInfo = params.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), KeepRelatedTradeShopConfigDto.class);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            List<String> ruleCodes = dtoList.stream().map(KeepRelatedTradeShopConfigDto::getRuleCode).collect(Collectors.toList());
            Map<String, List<KeepRelatedTradeDto>> tradeMap = this.getKeepRelatedTradeDtos(ruleCodes);
            Map<String, List<KeepRelatedShopDto>> shopMap = this.getKeepRelatedShopDtos(ruleCodes);
            dtoList.forEach(v -> {
                v.setUpdatePerson(v.getUpdatePerson());
                v.setUpdateTime(v.getUpdateTime());
                if (tradeMap.containsKey(v.getRuleCode())) {
                    List tradeDtos = (List)tradeMap.get(v.getRuleCode());
                    v.setRelatedTradeDtos(tradeDtos);
                    v.setRelatedTradeCount(Integer.valueOf(CollectionUtil.isNotEmpty((Collection)tradeDtos) ? tradeDtos.size() : 0));
                    ArrayList trades = CollectionUtil.isNotEmpty((Collection)tradeDtos) ? tradeDtos.stream().map(KeepRelatedTradeDto::getPlatformSellerEntityNumber).distinct().collect(Collectors.toList()) : Lists.newArrayList();
                    v.setCombinedRelatedTrade(CollectionUtil.isNotEmpty((Collection)trades) ? trades.stream().collect(Collectors.joining(",")) : null);
                }
                v.setEffectDate(v.getEffectBeginTime() + "~" + v.getEffectEndTime());
                if (shopMap.containsKey(v.getRuleCode())) {
                    List shopDtos = (List)shopMap.get(v.getRuleCode());
                    v.setRelatedShopDtos(shopDtos);
                    v.setRelatedShopCount(Integer.valueOf(CollectionUtil.isNotEmpty((Collection)shopDtos) ? shopDtos.size() : 0));
                    ArrayList shops = CollectionUtil.isNotEmpty((Collection)shopDtos) ? shopDtos.stream().map(KeepRelatedShopDto::getShopCode).distinct().collect(Collectors.toList()) : Lists.newArrayList();
                    v.setCombinedRelatedShop(CollectionUtil.isNotEmpty((Collection)shops) ? shops.stream().collect(Collectors.joining(",")) : null);
                }
            });
        }
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    @Override
    public PageInfo<ExportRelatedConfigTradeShopMatchDto> queryExportPage(KeepRelatedTradeConfigPageReqDto dto) {
        log.info("\u5206\u9875\u67e5\u8be2\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        PageInfo pageInfo = ((IKeepRelatedTradeConfigDomain)this.domain).queryExportPage(dto, pageNum, pageSize);
        return pageInfo;
    }

    @Override
    public List<KeepRelatedTradeShopConfigDto> queryList(KeepRelatedTradeConfigPageReqDto dto) {
        log.info("\u67e5\u8be2\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u7ba1\u7406\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        ExtQueryChainWrapper sqlFilters = ((IKeepRelatedTradeConfigDomain)this.domain).filter();
        if (CollectionUtil.isNotEmpty((Collection)dto.getRuleNames())) {
            sqlFilters.in((Object)"rule_name", (Collection)dto.getRuleNames());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getSiteCodes())) {
            sqlFilters.in((Object)"site_code", (Collection)dto.getSiteCodes());
        }
        if (null != dto.getEnable()) {
            sqlFilters.eq((Object)"enable", (Object)dto.getEnable());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEffectBeginTime())) {
            sqlFilters.ge((Object)"effect_begin_time", (Object)dto.getEffectBeginTime());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEffectEndTime())) {
            sqlFilters.le((Object)"effect_end_time", (Object)dto.getEffectEndTime());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getEffectDate())) {
            StringBuffer sql = new StringBuffer();
            sql.append(" (  ");
            sql.append("'" + dto.getEffectDate() + "' ");
            sql.append(" BETWEEN effect_begin_time AND effect_end_time ");
            sql.append(" ) ");
            sqlFilters.apply(sql.toString(), new Object[0]);
        }
        ArrayList<KeepRelatedTradeShopConfigDto> dtoList = new ArrayList<KeepRelatedTradeShopConfigDto>();
        List eoList = sqlFilters.list();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoList, KeepRelatedTradeShopConfigDto.class);
        if (CollectionUtil.isNotEmpty(dtoList)) {
            List<String> ruleCodes = dtoList.stream().map(KeepRelatedTradeShopConfigDto::getRuleCode).collect(Collectors.toList());
            Map<String, List<KeepRelatedTradeDto>> tradeMap = this.getKeepRelatedTradeDtos(ruleCodes);
            Map<String, List<KeepRelatedShopDto>> shopMap = this.getKeepRelatedShopDtos(ruleCodes);
            dtoList.forEach(v -> {
                if (tradeMap.containsKey(v.getRuleCode())) {
                    List tradeDtos = (List)tradeMap.get(v.getRuleCode());
                    tradeDtos.forEach(i -> {
                        i.setSiteCode(v.getSiteCode());
                        i.setRuleName(v.getRuleName());
                    });
                    v.setRelatedTradeDtos(tradeDtos);
                    v.setRelatedTradeCount(Integer.valueOf(tradeDtos.size()));
                }
                if (shopMap.containsKey(v.getRuleCode())) {
                    List shopDtos = (List)shopMap.get(v.getRuleCode());
                    shopDtos.forEach(i -> {
                        i.setSiteCode(v.getSiteCode());
                        i.setRuleName(v.getRuleName());
                    });
                    v.setRelatedShopDtos(shopDtos);
                    v.setRelatedShopCount(Integer.valueOf(shopDtos.size()));
                }
            });
        }
        return dtoList;
    }

    private ExtQueryChainWrapper<KeepRelatedTradeConfigEo> assembleCondition(KeepRelatedTradeConfigPageReqDto dto) {
        ExtQueryChainWrapper sqlFilters = ((IKeepRelatedTradeConfigDomain)this.domain).filter();
        if (StringUtils.isNotBlank((CharSequence)dto.getRuleCode())) {
            sqlFilters.like((Object)"rule_code", (Object)dto.getRuleCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getRuleCodes())) {
            if (dto.getRuleCodes().size() > 1) {
                sqlFilters.in((Object)"rule_code", (Collection)dto.getRuleCodes());
            } else {
                sqlFilters.like((Object)"rule_code", dto.getRuleCodes().get(0));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getRuleName())) {
            sqlFilters.like((Object)"rule_name", (Object)dto.getRuleName());
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getSiteCode())) {
            sqlFilters.like((Object)"site_code", (Object)dto.getSiteCode());
        }
        if (CollectionUtil.isNotEmpty((Collection)dto.getSiteCodes())) {
            if (dto.getSiteCodes().size() > 1) {
                sqlFilters.in((Object)"site_code", (Collection)dto.getSiteCodes());
            } else {
                sqlFilters.like((Object)"site_code", dto.getSiteCodes().get(0));
            }
        }
        sqlFilters.orderByDesc((Object)"id");
        return sqlFilters;
    }

    private Map<String, List<KeepRelatedTradeDto>> getKeepRelatedTradeDtos(List<String> ruleCodes) {
        if (ruleCodes == null || ruleCodes.isEmpty()) {
            return Maps.newHashMap();
        }
        List collect = Lists.partition(new ArrayList<String>(ruleCodes), (int)500).stream().flatMap(v -> {
            List list = this.tradeMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(KeepRelatedTradeEo.class).in(KeepRelatedTradeEo::getRuleCode, (Collection)v)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            return Maps.newHashMap();
        }
        ArrayList tradeDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)tradeDtos, collect, KeepRelatedTradeDto.class);
        return tradeDtos.stream().collect(Collectors.groupingBy(KeepRelatedTradeDto::getRuleCode));
    }

    private Map<String, List<KeepRelatedShopDto>> getKeepRelatedShopDtos(List<String> ruleCodes) {
        if (ruleCodes == null || ruleCodes.isEmpty()) {
            return Maps.newHashMap();
        }
        List collect = Lists.partition(new ArrayList<String>(ruleCodes), (int)500).stream().flatMap(v -> {
            List list = this.relatedShopMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(KeepRelatedShopEo.class).in(KeepRelatedShopEo::getRuleCode, (Collection)v)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            return Maps.newHashMap();
        }
        ArrayList shopDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)shopDtos, collect, KeepRelatedShopDto.class);
        return shopDtos.stream().collect(Collectors.groupingBy(KeepRelatedShopDto::getRuleCode));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchSave(List<KeepRelatedTradeShopConfigDto> tradeShopConfigDtos) {
        log.info("\u6279\u91cf\u63d2\u5165\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString(tradeShopConfigDtos));
        AssertUtils.notEmpty(tradeShopConfigDtos, (String)"\u6279\u91cf\u63d2\u5165\u5173\u8054\u4ea4\u6613\u4fe1\u606f\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList shopCodes = Lists.newArrayList();
        tradeShopConfigDtos.forEach(i -> {
            List relatedShopDtos = i.getRelatedShopDtos();
            shopCodes.addAll(relatedShopDtos.stream().map(KeepRelatedShopDto::getShopCode).distinct().collect(Collectors.toList()));
        });
        Map<Object, Object> shopEoMap = Maps.newHashMap();
        if (CollectionUtil.isNotEmpty((Collection)shopCodes)) {
            shopEoMap = this.getShop(shopCodes);
        }
        ArrayList tradeConfigEos = Lists.newArrayList();
        ArrayList relatedTradeEoList = Lists.newArrayList();
        ArrayList relatedShopEoList = Lists.newArrayList();
        Map<Object, Object> finalShopEoMap = shopEoMap;
        tradeShopConfigDtos.forEach(v -> {
            KeepRelatedTradeConfigEo tradeConfigEo = new KeepRelatedTradeConfigEo();
            CubeBeanUtils.copyProperties((Object)tradeConfigEo, (Object)v, (String[])new String[0]);
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.RELATED_TRADE_SHOP.getCode());
            String ruleCode = generateCodeService.getCode("GLGZ");
            tradeConfigEo.setRuleCode(ruleCode);
            v.getRelatedTradeDtos().forEach(i -> {
                KeepRelatedTradeEo tradeEo = new KeepRelatedTradeEo();
                CubeBeanUtils.copyProperties((Object)tradeEo, (Object)i, (String[])new String[0]);
                tradeEo.setRuleCode(ruleCode);
                relatedTradeEoList.add(tradeEo);
            });
            v.getRelatedShopDtos().forEach(i -> {
                KeepRelatedShopEo relatedShopEo = new KeepRelatedShopEo();
                CubeBeanUtils.copyProperties((Object)relatedShopEo, (Object)i, (String[])new String[0]);
                if (finalShopEoMap.containsKey(i.getShopCode())) {
                    ShopEo shopEo = (ShopEo)finalShopEoMap.get(i.getShopCode());
                    relatedShopEo.setShopName(shopEo.getName());
                }
                relatedShopEo.setRuleCode(ruleCode);
                relatedShopEoList.add(relatedShopEo);
            });
            tradeConfigEos.add(tradeConfigEo);
        });
        if (CollectionUtil.isNotEmpty((Collection)tradeConfigEos)) {
            ((IKeepRelatedTradeConfigDomain)this.domain).insertBatch((List)tradeConfigEos);
            if (CollectionUtil.isNotEmpty((Collection)relatedTradeEoList)) {
                this.tradeMapper.insertBatch((List)relatedTradeEoList);
            }
            if (CollectionUtil.isNotEmpty((Collection)relatedShopEoList)) {
                this.relatedShopMapper.insertBatch((List)relatedShopEoList);
            }
        }
    }

    private Map<String, SiteDto> getSiteDto(List<String> siteCodes) {
        if (CollectionUtil.isEmpty(siteCodes)) {
            return Maps.newHashMap();
        }
        try {
            List siteDtos = (List)RestResponseHelper.extractData((RestResponse)this.siteApiProxy.queryList(siteCodes));
            return siteDtos.stream().collect(Collectors.toMap(SiteDto::getCode, Function.identity(), (v1, v2) -> v1));
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u6e20\u9053\u4fe1\u606f\u5f02\u5e38\uff1a{},{}", (Object)e, (Object)e.getMessage());
            return Maps.newHashMap();
        }
    }

    private Map<String, ShopEo> getShop(List<String> shopCodes) {
        if (shopCodes == null || shopCodes.isEmpty()) {
            return Maps.newHashMap();
        }
        List collect = Lists.partition(new ArrayList<String>(shopCodes), (int)500).stream().flatMap(v -> {
            List list = this.shopMapper.selectList((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(ShopEo.class).in(ShopEo::getCode, (Collection)v)).eq(BaseEo::getDr, (Object)0));
            return list.stream();
        }).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(collect)) {
            return Maps.newHashMap();
        }
        return collect.stream().collect(Collectors.toMap(ShopEo::getCode, Function.identity(), (v1, v2) -> v1));
    }

    @Override
    public List<RelatedTradeShopMatchDto> queryListBySiteShopSellerRelated(RelatedTradeShopMatchQueryDto queryDto) {
        return ((IKeepRelatedTradeConfigDomain)this.domain).queryList(queryDto);
    }
}

