/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.entity.ISaleOrderBillRecordService;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ModifyInvoiceInfoRedPushConsumer {
    private static final Logger log = LoggerFactory.getLogger(ModifyInvoiceInfoRedPushConsumer.class);
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IBillInfoService iBillInfoService;
    @Resource
    private ISaleOrderBillRecordService saleOrderBillRecordService;

    private BillStrategyRespDto getBillStrategyInfo(PerformOrderInfoDto performOrderInfoDto) {
        String shopCode = ((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        return this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
    }

    private BillInfoGenerateReqDto buildBillInfoGenerateDto() {
        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
        billInfoGenerateReqDto.setWhetherMergeBill(Integer.valueOf(0));
        billInfoGenerateReqDto.setApplyFlag(Boolean.valueOf(false));
        return billInfoGenerateReqDto;
    }

    private List<SaleOrderBillRecordDto> querySaleOrderBillRecordForNew(String platformOrderNo) {
        SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
        saleOrderBillRecordQueryReqDto.setPlatformOrderNo(platformOrderNo);
        List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
        log.info("\u83b7\u53d6\u6700\u65b0\u5f00\u7968\u8bb0\u5f55===\u300b{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
        return saleOrderBillRecordDtos;
    }

    private boolean redInvoice(List<BillInfoEo> billInfoEoList) {
        if (CollectionUtil.isEmpty(billInfoEoList)) {
            log.info("\u6ca1\u6709\u5f00\u7968\u4fe1\u606f");
            return false;
        }
        BatchOperationRespDto batchOperationRespDto = this.iBillInfoService.redInvoice(billInfoEoList);
        if (Objects.nonNull(batchOperationRespDto) && StrUtil.isNotBlank((CharSequence)batchOperationRespDto.getErrorMsg())) {
            log.info("\u7ea2\u51b2\u5931\u8d25\u4e86\uff0c\u9700\u8981\u8fdb\u5165\u6392\u67e5\u4fe1\u606f=\u300bbillInfoEoList={}\uff0cbatchOperationRespDto={}", (Object)JSONUtil.toJsonStr(billInfoEoList), (Object)JSONUtil.toJsonStr((Object)batchOperationRespDto));
            return false;
        }
        return true;
    }

    private List<BillInfoEo> listBillInfoEoList(String platformOrderNo) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"bill_type", (Object)"blue_ticket")).in((Object)"invoice_state", new Object[]{"wait_audit", "wait_bill", "billed"})).list();
    }

    private PerformOrderInfoDto getPerformOrderInfoDto(String platformOrderNo) {
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNo(platformOrderNo);
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> performOrderInfoDtos = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        return CollectionUtil.isNotEmpty(performOrderInfoDtos) ? performOrderInfoDtos.get(0) : null;
    }

    public MessageResponse syncModiyInvoiceInfo(String platformOrderNo) {
        if (CollectionUtil.isEmpty(this.listBillInfoEoList(platformOrderNo))) {
            log.info("\u6ca1\u6709\u5b58\u5728\u9700\u8981\u7ea2\u51b2\u7684\u84dd\u7968 \u6216\u8005 \u7ea2\u51b2\u5931\u8d25\u4e86\uff0c\u9700\u8981\u8fdb\u5165\u6392\u67e5\u4fe1\u606f=");
            return MessageResponse.SUCCESS;
        }
        PerformOrderInfoDto performOrderInfoDto = this.getPerformOrderInfoDto(platformOrderNo);
        if (Objects.isNull(performOrderInfoDto)) {
            log.info("\u6ca1\u6709\u5b58\u5728\u5e73\u53f0\u57fa\u672c\u4fe1\u606f");
            return MessageResponse.SUCCESS;
        }
        this.iBillInfoService.createInvoice(performOrderInfoDto, this.querySaleOrderBillRecordForNew(platformOrderNo), this.getBillStrategyInfo(performOrderInfoDto), this.buildBillInfoGenerateDto());
        return MessageResponse.SUCCESS;
    }
}

