/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceDetailReqDto;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceInfoReqDto;
import com.dtyunxi.yundt.cube.center.openapi.dto.invoice.InvoiceInfoRespDto;
import com.dtyunxi.yundt.cube.center.openapi.proxy.invoice.IInvoiceApiProxy;
import com.dtyunxi.yundt.cube.center.trade.dto.entity.SaleOrderBillRecordReqProxyDto;
import com.dtyunxi.yundt.cube.center.trade.proxy.entity.ISaleOrderBillRecordApiProxy;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.yunxi.dg.base.center.finance.dao.das.IBillAllElectricShopDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillApplyDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBlacklistDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillStrategyNoInvoiceItemDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillApplyMapper;
import com.yunxi.dg.base.center.finance.dao.mapper.BillInfoMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderItemDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillApplyDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPerformOrderInfoDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ISaleOrderBillRecordDomain;
import com.yunxi.dg.base.center.finance.dto.OpenInvoiceNeedInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemRateDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.ItemSkuDgDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordDto;
import com.yunxi.dg.base.center.finance.dto.entity.SaleOrderBillRecordPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AllRedFlagEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillApplyChangeTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillAuditTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillCreateTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoColourTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillInfoTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyOrderPointEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillStrategyRemarkType;
import com.yunxi.dg.base.center.finance.dto.enums.BillTitleTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.dto.enums.InvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.PlatFormOrderSelectTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleItemStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderInvoiceStateEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SubsidiesTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.UseBlackListEnum;
import com.yunxi.dg.base.center.finance.dto.enums.WhetherMergeBillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.request.CallBackInvoiceInfoReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BatchOperationRespDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderEo;
import com.yunxi.dg.base.center.finance.eo.AfterSaleOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillApplyEo;
import com.yunxi.dg.base.center.finance.eo.BillBlacklistEo;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.eo.BillInfoEo;
import com.yunxi.dg.base.center.finance.eo.BillItemEo;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.BillStrategyNoInvoiceItemEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.eo.PerformOrderInfoEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillBusinessRelPlatformService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoValidateService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.ICallBackPassPlatformInvoiceService;
import com.yunxi.dg.base.center.finance.service.entity.IHhOrderGenerateBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IItemDgService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.entity.ISaleOrderBillRecordService;
import com.yunxi.dg.base.center.finance.service.entity.IShopService;
import com.yunxi.dg.base.center.finance.service.generate.BillInvoiceTypeConvert;
import com.yunxi.dg.base.center.finance.service.generate.GenerateCodeUtils;
import com.yunxi.dg.base.center.finance.service.generate.IGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.center.finance.service.utils.GenerateCodeDataUtils;
import com.yunxi.dg.base.center.finance.service.utils.LogUtils;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class HhOrderGenerateBillInfoServiceImpl
implements IHhOrderGenerateBillInfoService {
    private static final Logger log = LoggerFactory.getLogger(HhOrderGenerateBillInfoServiceImpl.class);
    @Resource
    private IItemDgService itemDgService;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IAfterSaleOrderItemDomain afterSaleOrderItemDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;
    @Resource
    private IBillApplyDomain billApplyDomain;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private ISaleOrderBillRecordDomain saleOrderBillRecordDomain;
    @Resource
    private IKeepAccountsDetailDomain keepAccountsDetailDomain;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private ISaleOrderBillRecordService saleOrderBillRecordService;
    @Resource
    private IBillInfoDomain billInfoDomain;
    @Resource
    private IBillItemDas billItemDas;
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    @Resource
    private BillApplyMapper billApplyMapper;
    @Resource
    private IBillAllElectricShopDas billAllElectricShopDas;
    @Resource
    private IBillEntityDas billEntityDas;
    @Resource
    private IPerformOrderInfoDomain iPerformOrderInfoDomain;
    @Resource
    private ISaleOrderBillRecordApiProxy saleOrderBillRecordApiProxy;
    @Resource
    private ICallBackPassPlatformInvoiceService iCallBackPassPlatformInvoiceService;
    @Resource
    private IInvoiceApiProxy invoiceApiProxy;
    @Resource
    private BillInfoMapper billInfoMapper;
    @Resource
    private GenerateCodeDataUtils generateCodeDataUtils;
    @Resource
    private IBillBusinessRelPlatformService billBusinessRelPlatformService;
    @Resource
    private IShopService shopService;
    @Resource
    private IContext context;
    @Resource
    private IBillStrategyNoInvoiceItemDas billStrategyNoInvoiceItemDas;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IBillApplyDas billApplyDas;
    @Resource
    private IBillInfoValidateService billInfoValidateService;
    @Resource
    private IBillBlacklistDas billBlacklistDas;
    @Resource
    private BillInvoiceTypeConvert invoiceTypeConvert;
    private final String BILL_APPLY_PREFIX = "BA";

    @Override
    public void generateBillInfo(String orderStatus, String platformOrderNo, String saleOrderNo, String orderType) {
        boolean flag;
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).one();
        DgPerformOrderSnapshotEo snapshotEo = this.dgPerformOrderSnapshotDomain.selectByOrderId(performOrderInfoEo.getId());
        BillStrategyRespDto billStrategyRespDto = this.billStrategyService.queryByShopCodeAndType(snapshotEo.getShopCode(), StrategyTypeEnum.ORDINARY_BILL.getCode());
        if (!orderType.equals("HH_AFTER_SALE") && !(flag = this.validateOpenInvoice(billStrategyRespDto, performOrderInfoEo))) {
            log.info("\u6ca1\u6709\u7b26\u5408\u5f00\u7968\u7684\u7b56\u7565,\u7ed3\u675f\u5f00\u7968\u6d41\u7a0b");
            return;
        }
        List billInfoEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoEo.getPlatformOrderNo())).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).list();
        log.info("\u67e5\u8be2\u4e4b\u524d\u662f\u5426\u5b58\u5728\u84dd\u7968:{},{}", (Object)performOrderInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billInfoEoList));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEoList)) {
            this.billInfoService.redInvoice(billInfoEoList);
        }
        if (billStrategyRespDto.getBillObject().equals("apply")) {
            log.info("\u901a\u8fc7\u7533\u8bf7\u5355\u5f00\u7968");
            BillApplyEo billApplyEo = this.billApplyDomain.queryLastEoByPlatformOrderNo(platformOrderNo);
            if (billApplyEo == null) {
                log.info("\u672a\u7533\u8bf7\u5f00\u7968,\u7ed3\u675f\u5f00\u7968\u6d41\u7a0b");
                return;
            }
            this.openInvoiceByApply(billApplyEo, performOrderInfoEo, snapshotEo, billStrategyRespDto);
        } else {
            log.info("\u4e0d\u901a\u8fc7\u7533\u8bf7\u5355\u5f00\u7968,\u6839\u636e\u8ba2\u5355\u8282\u70b9\u5f00\u7968");
            this.openInvoiceByPlatform(performOrderInfoEo, snapshotEo, billStrategyRespDto);
        }
    }

    @Override
    public void generateBillInfoByHhAfsOrder(String afterSaleOrderNo) {
        AfterSaleOrderEo afterSaleOrderEo = this.afterSaleOrderDomain.queryEoByAfterSaleOrderNo(afterSaleOrderNo);
        if (!AfterSaleOrderStatusEnum.FINISH.getCode().equals(afterSaleOrderEo.getStatus())) {
            log.info("\u552e\u540e\u5355\u975e\u5df2\u5b8c\u6210\u72b6\u6001\u4e0d\u89e6\u53d1\u51b2\u7ea2\u91cd\u5f00\u5e73\u53f0\u8ba2\u5355\u84dd\u5b57\u53d1\u7968");
            return;
        }
        DgPerformOrderInfoEo exchangeSaleOrderInfoEo = this.dgPerformOrderInfoDomain.queryEoBySaleOrderNo(afterSaleOrderEo.getExchangeSaleOrderNo());
        this.generateBillInfo(afterSaleOrderEo.getStatus(), exchangeSaleOrderInfoEo.getPlatformOrderNo(), exchangeSaleOrderInfoEo.getSaleOrderNo(), "HH_AFTER_SALE");
    }

    private void openInvoiceByApply(BillApplyEo billApplyEo, DgPerformOrderInfoEo performOrderInfoEo, DgPerformOrderSnapshotEo snapshotEo, BillStrategyRespDto billStrategyRespDto) {
        log.info("\u5148\u6362\u540e\u9000\uff0c\u6362\u8d27\u552e\u540e\u5355\u8fd8\u672a\u5b8c\u6210\uff0c\u6362\u51fa\u9500\u552e\u5355\u5df2\u7ecf\u7533\u8bf7\u5f00\u7968\u4e14\u6ee1\u8db3\u5f00\u7968\u7b56\u7565\u7684\u5f00\u7968\u8282\u70b9");
        OpenInvoiceNeedInfoReqDto openInvoiceNeedInfoReqDto = this.getOpenInvoiceNeedInfo(performOrderInfoEo, billStrategyRespDto);
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setInvoiceSaleOrderNo(performOrderInfoEo.getSaleOrderNo());
        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
        billInfoGenerateReqDto.setApplyNo(billApplyEo.getApplyNo());
        billInfoGenerateReqDto.setWhetherMergeBill(WhetherMergeBillTypeEnum.NO_MERGE.getCode());
        this.getBillInfo(performOrderInfoEo, snapshotEo, billInfoEo, billStrategyRespDto, openInvoiceNeedInfoReqDto.getSaleOrderBillRecordRespDto(), billInfoGenerateReqDto);
        billInfoEo.setSaleOrderNo(performOrderInfoEo.getSaleOrderNo());
        List<BillItemEo> billItemEoList = this.saveBillDetailInfo(performOrderInfoEo, openInvoiceNeedInfoReqDto.getOrderLineDtoList(), billInfoEo, billStrategyRespDto, openInvoiceNeedInfoReqDto.getEffectiveOrderEos());
        this.getShopAllElectricInfo(billInfoEo);
        boolean isConsistency = this.billInfoValidateService.validateBillInfo(performOrderInfoEo.getPlatformOrderNo(), billInfoEo);
        log.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4:{},{}", (Object)isConsistency, (Object)performOrderInfoEo.getPlatformOrderNo());
        if (isConsistency) {
            log.info("\u53d1\u7968\u4fe1\u606f\u4e00\u81f4\uff0c\u4e0d\u751f\u6210\u53d1\u7968\u6570\u636e\uff1a{},{}", (Object)performOrderInfoEo.getPlatformOrderNo(), (Object)isConsistency);
            return;
        }
        boolean isBlacklist = this.checkAndSetBlacklist(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType()) && null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
            boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
            String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
            log.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
            if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto) {
                if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                    this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                    this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                }
            }
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4deliveryGen==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        ArrayList<String> platformOrderNoList = new ArrayList<String>();
        platformOrderNoList.add(billInfoEo.getPlatformOrderNo());
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
        this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode());
        if (!isBlacklist) {
            this.syncAddKingdeeInvoice(billInfoEo, billItemEoList, null, performOrderInfoEo);
        } else {
            log.warn("\u5e73\u53f0\u8ba2\u5355\u53f7\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u4e0d\u63a8\u9001\u4e07\u9e3f\u5f00\u7968\uff1a{}", (Object)performOrderInfoEo.getPlatformOrderNo());
        }
    }

    private OpenInvoiceNeedInfoReqDto getOpenInvoiceNeedInfo(DgPerformOrderInfoEo performOrderInfoEo, BillStrategyRespDto billStrategyRespDto) {
        OpenInvoiceNeedInfoReqDto reqDto = new OpenInvoiceNeedInfoReqDto();
        List effectiveOrderEos = this.dgPerformOrderInfoDomain.queryEffectiveListByPlatformOrderNo(performOrderInfoEo.getPlatformOrderNo());
        List orderIds = effectiveOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List orderLineEos = this.dgPerformOrderLineDomain.queryEosOrderIds(orderIds);
        ArrayList orderLineDtoList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderLineDtoList, (Collection)orderLineEos, DgPerformOrderLineDto.class);
        List<String> accountTypes = Arrays.asList(DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode(), DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode());
        List orderLineIds = orderLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List lineAmountEos = this.dgPerformOrderLineAmountDomain.queryEosByAccountTypesAndOrderLineIds(accountTypes, orderLineIds);
        Map<Long, List<DgPerformOrderLineAmountEo>> orderLineAmountMap = lineAmountEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
        for (DgPerformOrderLineDto orderLineDto : orderLineDtoList) {
            List<DgPerformOrderLineAmountEo> orderLineAmountEos = orderLineAmountMap.get(orderLineDto.getId());
            BigDecimal orderLineSaleAmount = BigDecimal.ZERO;
            BigDecimal orderLinePayAmount = BigDecimal.ZERO;
            for (DgPerformOrderLineAmountEo orderLineAmountEo : orderLineAmountEos) {
                if (DgOmsOrderAmountTypeEnum.LINE_ACTUAL_PRICE.getCode().equals(orderLineAmountEo.getAccountType())) {
                    orderLinePayAmount = orderLinePayAmount.add(orderLineAmountEo.getAmount());
                }
                if (!DgOmsOrderAmountTypeEnum.LINE_SALE_TOTAL.getCode().equals(orderLineAmountEo.getAccountType())) continue;
                orderLineSaleAmount = orderLineSaleAmount.add(orderLineAmountEo.getAmount());
            }
            orderLineDto.setSaleAmount(orderLineSaleAmount);
            orderLineDto.setPayAmount(orderLinePayAmount);
            orderLineDto.setRefundAmount(BigDecimal.ZERO);
            orderLineDto.setRefundedItemNum(BigDecimal.ZERO);
            orderLineDto.setSurplusCanRefundPayAmount(orderLinePayAmount);
            orderLineDto.setRefundedPayAmount(BigDecimal.ZERO);
            orderLineDto.setRealPayAmount(orderLinePayAmount);
            orderLineDto.setGift(orderLineDto.getGiftFlag());
        }
        List<AfterSaleOrderEo> afterSaleOrderEos = this.billInfoService.getCanBillAfterSaleOrders(com.google.common.collect.Lists.newArrayList((Object[])new String[]{performOrderInfoEo.getPlatformOrderNo()}));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(afterSaleOrderEos)) {
            List afterSaleOrderIds = afterSaleOrderEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            List afterSaleOrderItemEos = this.afterSaleOrderItemDomain.queryEosByAfsOrderIds(afterSaleOrderIds);
            this.caculateOrderLineRefundAmountAndNum(orderLineDtoList, afterSaleOrderEos, afterSaleOrderItemEos);
            reqDto.setAfterSaleOrderItemEos(afterSaleOrderItemEos);
        }
        for (DgPerformOrderLineDto orderLineDto : orderLineDtoList) {
            log.info("\u8ba2\u5355\u884cID:{},\u5546\u54c1sku\u7f16\u7801:{},\u9500\u552e\u91d1\u989d:{},\u4ed8\u6b3e\u91d1\u989d:{},\u5df2\u9000\u91d1\u989d:{},\u5df2\u9000\u6570\u91cf:{}", new Object[]{orderLineDto.getId(), orderLineDto.getSkuCode(), orderLineDto.getSaleAmount(), orderLineDto.getPayAmount(), orderLineDto.getRefundAmount(), orderLineDto.getRefundedItemNum()});
        }
        SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
        saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoEo.getPlatformOrderNo());
        List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
        log.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
        SaleOrderBillRecordDto saleOrderBillRecordRespDto = new SaleOrderBillRecordDto();
        if (CollectionUtils.isNotEmpty(saleOrderBillRecordDtos)) {
            saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)saleOrderBillRecordDtos.stream().sorted(Comparator.comparing(BaseDto::getId).reversed()).collect(Collectors.toList()).get(0);
        } else {
            this.defaultBillRecord(saleOrderBillRecordRespDto, billStrategyRespDto, null);
        }
        reqDto.setEffectiveOrderEos(effectiveOrderEos);
        reqDto.setOrderLineEos(orderLineEos);
        reqDto.setOrderLineDtoList(orderLineDtoList);
        reqDto.setLineAmountEos(lineAmountEos);
        reqDto.setAfterSaleOrderEos(afterSaleOrderEos);
        reqDto.setSaleOrderBillRecordRespDto(saleOrderBillRecordRespDto);
        return reqDto;
    }

    private void caculateOrderLineRefundAmountAndNum(List<DgPerformOrderLineDto> orderLineDtoList, List<AfterSaleOrderEo> afterSaleOrderEos, List<AfterSaleOrderItemEo> afterSaleOrderItemEos) {
        Map<Long, List<AfterSaleOrderItemEo>> afterSaleOrderItemMap = afterSaleOrderItemEos.stream().collect(Collectors.groupingBy(AfterSaleOrderItemEo::getAfterSaleOrderId));
        for (AfterSaleOrderEo afterSaleOrderEo : afterSaleOrderEos) {
            String afterSaleOrderType = afterSaleOrderEo.getAfterSaleOrderType();
            String afterSaleOrderStatus = afterSaleOrderEo.getStatus();
            List<AfterSaleOrderItemEo> saleOrderItemEos = afterSaleOrderItemMap.get(afterSaleOrderEo.getId());
            for (DgPerformOrderLineDto orderLineDto : orderLineDtoList) {
                BigDecimal refundAmount = Optional.ofNullable(orderLineDto.getRefundAmount()).orElse(BigDecimal.ZERO);
                BigDecimal refundNUm = Optional.ofNullable(orderLineDto.getRefundedItemNum()).orElse(BigDecimal.ZERO);
                for (AfterSaleOrderItemEo afterSaleOrderItemEo : saleOrderItemEos) {
                    if (!orderLineDto.getId().equals(afterSaleOrderItemEo.getSaleOrderItemId()) || !afterSaleOrderItemEo.getAfterSaleOrderItemType().equals(0)) continue;
                    if (AfterSaleOrderTypeEnum.FHHTK.getCode().equals(afterSaleOrderType) || AfterSaleOrderTypeEnum.JTK.getCode().equals(afterSaleOrderType)) {
                        log.info("\u4ec5\u9000\u6b3e\u552e\u540e\u5355\u53ea\u7edf\u8ba1\u9000\u6b3e\u91d1\u989d");
                        refundAmount = refundAmount.add(afterSaleOrderItemEo.getActualRefundAmount() == null ? afterSaleOrderItemEo.getRefundAmount() : afterSaleOrderItemEo.getActualRefundAmount());
                    }
                    if (AfterSaleOrderTypeEnum.THTK.getCode().equals(afterSaleOrderType)) {
                        log.info("\u9000\u8d27\u9000\u6b3e\u552e\u540e\u5355\u7edf\u8ba1\u9000\u6b3e\u91d1\u989d\u548c\u9000\u8d27\u6570\u91cf");
                        refundAmount = refundAmount.add(afterSaleOrderItemEo.getActualRefundAmount() == null ? afterSaleOrderItemEo.getRefundAmount() : afterSaleOrderItemEo.getActualRefundAmount());
                        refundNUm = refundNUm.add(new BigDecimal(afterSaleOrderItemEo.getItemNum()));
                    }
                    if (!AfterSaleOrderTypeEnum.HH.getCode().equals(afterSaleOrderType) || !afterSaleOrderStatus.equals(AfterSaleOrderStatusEnum.FINISH.getCode())) continue;
                    log.info("\u6362\u8d27\u552e\u540e\u5355\u5982\u679c\u5df2\u5b8c\u6210\u88ab\u6362\u51fa\u5546\u54c1\u9700\u8981\u6309\u7167\u6570\u91cf\u548c\u9000\u8d27\u91d1\u989d\u7edf\u8ba1\u5df2\u9000\u6570\u91cf\u548c\u5df2\u9000\u91d1\u989d");
                    refundAmount = refundAmount.add(afterSaleOrderItemEo.getActualRefundAmount() == null ? afterSaleOrderItemEo.getRefundAmount() : afterSaleOrderItemEo.getActualRefundAmount());
                    refundNUm = refundNUm.add(new BigDecimal(afterSaleOrderItemEo.getItemNum()));
                }
                orderLineDto.setRefundAmount(refundAmount);
                orderLineDto.setRefundedItemNum(refundNUm);
                orderLineDto.setSurplusCanRefundPayAmount(orderLineDto.getPayAmount().subtract(refundAmount));
                orderLineDto.setRefundedPayAmount(refundAmount);
                log.info("\u8ba2\u5355\u884cID:{},\u5546\u54c1sku\u7f16\u7801:{},\u9500\u552e\u91d1\u989d:{},\u4ed8\u6b3e\u91d1\u989d:{},\u5df2\u9000\u91d1\u989d:{},\u5df2\u9000\u6570\u91cf:{}", new Object[]{orderLineDto.getId(), orderLineDto.getSkuCode(), orderLineDto.getSaleAmount(), orderLineDto.getPayAmount(), orderLineDto.getRefundAmount(), orderLineDto.getRefundedItemNum()});
            }
        }
    }

    private BatchOperationRespDto cancelOrHongchongBlueTikectList(List<BillInfoEo> needHongChongBlueTikectList, DgPerformOrderInfoEo performOrderInfoEo) {
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(needHongChongBlueTikectList)) {
            List<BillInfoEo> needHongChongTikectList;
            List<BillInfoEo> needCancelBlueTikectList = needHongChongBlueTikectList.stream().filter(e -> e.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || e.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(needCancelBlueTikectList)) {
                log.info("\u9700\u8981\u53d6\u6d88\u7684\u84dd\u5b57\u53d1\u7968:{}", (Object)JSON.toJSONString(needCancelBlueTikectList.stream().map(BillInfoEo::getBillFlowNo).collect(Collectors.toList())));
                this.cancelInvoices(needCancelBlueTikectList);
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(needHongChongTikectList = needHongChongBlueTikectList.stream().filter(e -> e.getInvoiceState().equals(InvoiceStateEnum.BILLED.getCode())).collect(Collectors.toList()))) {
                log.info("\u9700\u8981\u51b2\u7ea2\u7684\u84dd\u5b57\u53d1\u7968:{}", (Object)JSON.toJSONString(needHongChongTikectList.stream().map(BillInfoEo::getBillFlowNo).collect(Collectors.toList())));
                batchOperationRespDto = this.hongchongInvoices(needHongChongTikectList, performOrderInfoEo);
            }
        }
        return batchOperationRespDto;
    }

    private BatchOperationRespDto hongchongInvoices(List<BillInfoEo> billInfoList, DgPerformOrderInfoEo performOrderInfoEo) {
        BatchOperationRespDto batchOperationRespDto = new BatchOperationRespDto();
        List billFlowNoList = billInfoList.stream().map(BillInfoEo::getBillFlowNo).collect(Collectors.toList());
        List billItemList = ((ExtQueryChainWrapper)this.billItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        List billOrderItemList = ((ExtQueryChainWrapper)this.billOrderItemDas.filter().in((Object)"bill_flow_no", billFlowNoList)).list();
        Map<String, List<BillOrderItemEo>> billOrderItemMap = ((List)Optional.ofNullable(billOrderItemList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BillOrderItemEo::getBillFlowNo));
        Map<String, List<BillItemEo>> billItemMap = ((List)Optional.ofNullable(billItemList).orElse(new ArrayList())).stream().collect(Collectors.groupingBy(BillItemEo::getBillFlowNo));
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<String> successList = new ArrayList<String>();
        for (BillInfoEo info : billInfoList) {
            Boolean flag = this.redKingdeeInvoice(info, billItemMap, billOrderItemMap, errorList, performOrderInfoEo);
            if (!flag.booleanValue()) continue;
            successList.add(info.getBillFlowNo());
        }
        batchOperationRespDto.setSuccessNum(Integer.valueOf(successList.size()));
        batchOperationRespDto.setFailNum(Integer.valueOf(billInfoList.size() - successList.size()));
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(errorList)) {
            batchOperationRespDto.setErrorMsg(String.join((CharSequence)",", errorList));
        }
        return batchOperationRespDto;
    }

    private void cancelInvoices(List<BillInfoEo> needCancelBlueTikectList) {
        for (BillInfoEo billInfoEo : needCancelBlueTikectList) {
            this.cancelBillInfo(billInfoEo);
        }
    }

    private void openInvoiceByPlatform(DgPerformOrderInfoEo performOrderInfoEo, DgPerformOrderSnapshotEo snapshotEo, BillStrategyRespDto billStrategyRespDto) {
        log.info("\u5148\u6362\u540e\u9000\uff0c\u6362\u8d27\u552e\u540e\u5355\u8fd8\u672a\u5b8c\u6210\uff0c\u6362\u51fa\u9500\u552e\u5355\u5df2\u7ecf\u7533\u8bf7\u5f00\u7968\u4e14\u6ee1\u8db3\u5f00\u7968\u7b56\u7565\u7684\u5f00\u7968\u8282\u70b9");
        OpenInvoiceNeedInfoReqDto openInvoiceNeedInfoReqDto = this.getOpenInvoiceNeedInfo(performOrderInfoEo, billStrategyRespDto);
        List openInvoiceSaleOrderNos = openInvoiceNeedInfoReqDto.getEffectiveOrderEos().stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
        log.info("\u53c2\u4e0e\u5f00\u7968\u7684\u8ba2\u5355\u53f7\u96c6\u5408:{}", (Object)JSON.toJSONString(openInvoiceSaleOrderNos));
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setInvoiceSaleOrderNo(String.join((CharSequence)",", openInvoiceSaleOrderNos));
        BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
        billInfoGenerateReqDto.setWhetherMergeBill(WhetherMergeBillTypeEnum.NO_MERGE.getCode());
        this.getBillInfo(performOrderInfoEo, snapshotEo, billInfoEo, billStrategyRespDto, openInvoiceNeedInfoReqDto.getSaleOrderBillRecordRespDto(), billInfoGenerateReqDto);
        billInfoEo.setSaleOrderNo(String.join((CharSequence)",", openInvoiceSaleOrderNos));
        List<BillItemEo> billItemEoList = this.saveBillDetailInfo(performOrderInfoEo, openInvoiceNeedInfoReqDto.getOrderLineDtoList(), billInfoEo, billStrategyRespDto, openInvoiceNeedInfoReqDto.getEffectiveOrderEos());
        this.getShopAllElectricInfo(billInfoEo);
        boolean isBlacklist = this.checkAndSetBlacklist(billInfoEo);
        this.billInfoDas.insert((BaseEo)billInfoEo);
        if (BillAuditTypeEnum.AUTO_AUDIT.getCode().equals(billStrategyRespDto.getBillAudit()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getBillApplyType()) && null != BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType())) {
            boolean isAuto = CollectionUtil.isEmpty((Collection)billStrategyRespDto.getCreateTypeList()) || (StrUtil.isNotBlank((CharSequence)billInfoEo.getCreatePerson()) ? billStrategyRespDto.getCreateTypeList().contains("manual") : billStrategyRespDto.getCreateTypeList().contains("sys"));
            log.info("\u9002\u7528\u56fd\u8865\u8ba2\u5355\u914d\u7f6e\uff1a{},{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto), (Object)JSONObject.toJSONString((Object)billInfoEo));
            String code = BillApplyAuditTypeEnum.getByCodeTwo((String)billInfoEo.getInvoiceType()).getCode();
            if (billStrategyRespDto.getBillApplyType().contains(code) && isAuto) {
                if (1 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("national_supplement")) {
                    this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                } else if (0 == (null != billInfoEo.getSubsidiesType() ? billInfoEo.getSubsidiesType() : 0) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billStrategyRespDto.getNationalSupplementOrder()) && billStrategyRespDto.getNationalSupplementOrder().contains("non_national_supplement")) {
                    this.autoAuditCheck(billInfoEo, billItemEoList, billStrategyRespDto);
                }
            }
        }
        log.info("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4deliveryGen==>billInfoEo:{}", (Object)LogUtils.buildLogContent(billInfoEo));
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        ArrayList<String> platformOrderNoList = new ArrayList<String>();
        platformOrderNoList.add(billInfoEo.getPlatformOrderNo());
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, billInfoEo.getBillFlowNo(), RelBusinessTypeEnum.INVOICE.getCode());
        this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_BILL.getCode());
        if (!isBlacklist) {
            this.syncAddKingdeeInvoice(billInfoEo, billItemEoList, null, performOrderInfoEo);
        } else {
            log.warn("\u5e73\u53f0\u8ba2\u5355\u53f7\u5728\u9ed1\u540d\u5355\u4e2d\uff0c\u4e0d\u63a8\u9001\u4e07\u9e3f\u5f00\u7968\uff1a{}", (Object)performOrderInfoEo.getPlatformOrderNo());
        }
    }

    private List<BillInfoEo> queryEffectiveBlueTicketByPlatformOrderNo(String platformOrderNo) {
        List relPlatformEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)relPlatformEoList)) {
            List billFlowNos = relPlatformEoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            return this.billInfoDomain.queryEffectiveBlueTicketEos(billFlowNos);
        }
        return null;
    }

    private boolean validateOpenInvoice(BillStrategyRespDto billStrategyRespDto, DgPerformOrderInfoEo performOrderInfoEo) {
        log.info("\u53d1\u7968\u7b56\u7565:{}", (Object)JSON.toJSONString((Object)billStrategyRespDto));
        String orderStatus = performOrderInfoEo.getOrderStatus();
        String saleOrderNo = performOrderInfoEo.getSaleOrderNo();
        if (billStrategyRespDto == null) {
            log.info("\u5e97\u94fa\u672a\u8bbe\u7f6e\u5f00\u7968\u7b56\u7565,\u4e0d\u5f00\u7968");
            return false;
        }
        if (!"enable".equals(billStrategyRespDto.getStrategyStatus())) {
            log.info("\u5e97\u94fa\u5f00\u7968\u7b56\u7565\u672a\u542f\u7528,\u4e0d\u5f00\u7968");
        }
        if (BillStrategyOrderPointEnum.DELIVER.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
            log.info("handleBatchOrder==>\u5df2\u53d1\u8d27\u7b56\u7565");
            return OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus);
        }
        if (BillStrategyOrderPointEnum.COMPLETE.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
            log.info("handleBatchOrder==>\u5df2\u5b8c\u6210\u7b56\u7565");
            return OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus);
        }
        if (BillStrategyOrderPointEnum.KEEP_COMPLETE.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
            log.info("handleBatchOrder==>\u8fdb\u5165\u5df2\u8bb0\u8d26\u7b56\u7565");
            List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDomain.filter().eq((Object)"order_no", (Object)saleOrderNo)).groupBy((Object)"accounting_result")).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)list) || list.size() > 1) {
                log.info("\u8bb0\u8d26\u5355\u5b58\u5728\u591a\u4e2a\u72b6\u6001\uff0c\u8fd8\u6ca1\u5b8c\u6210\u8bb0\u8d26");
                return false;
            }
            if (((KeepAccountsDetailEo)list.get(0)).getAccountingResult().equals(AccountRuleEnum.ACCOUNT_SUCCESS.getCode())) {
                return true;
            }
        }
        return false;
    }

    public Boolean orderTypeFilter(String orderType) {
        if (SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.PROXY_SALE.getType().equals(orderType) || SaleOrderTypeEnum.GIFT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.SHIPMENT_CLAIM_ORDER.getType().equals(orderType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void cancelBillInfo(BillInfoEo info) {
        BillInfoEo billInfoEo = new BillInfoEo();
        billInfoEo.setId(info.getId());
        billInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        if (StringUtils.isNotBlank((CharSequence)info.getAgainBillRedBillFlowNo())) {
            BillInfoEo infoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)info.getAgainBillRedBillFlowNo())).one();
            BillInfoEo redBillInfoEo = new BillInfoEo();
            redBillInfoEo.setId(infoEo.getId());
            redBillInfoEo.setInvoiceState(InvoiceStateEnum.CANCELLED.getCode());
            this.billInfoDas.updateSelective((BaseEo)redBillInfoEo);
        }
    }

    private boolean isInCurrentMonth(Date date) {
        int year = DateUtil.year((Date)date);
        int month = DateUtil.month((Date)date);
        int currentYear = DateUtil.year((Date)new Date());
        int currentMonth = DateUtil.month((Date)new Date());
        return currentYear == year && month == currentMonth;
    }

    public boolean checkAndSetBlacklist(BillInfoEo billInfoEo) {
        if (billInfoEo == null || StringUtils.isBlank((CharSequence)billInfoEo.getPlatformOrderNo())) {
            return false;
        }
        try {
            String[] platformOrderNos;
            for (String platformOrderNo : platformOrderNos = billInfoEo.getPlatformOrderNo().split(",")) {
                platformOrderNo = platformOrderNo.trim();
                BillBlacklistEo queryEo = new BillBlacklistEo();
                queryEo.setPlatformOrderNo(platformOrderNo);
                queryEo.setDr(0);
                List blacklist = this.billBlacklistDas.selectList((BaseEo)queryEo);
                if (!org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)blacklist)) continue;
                log.warn("\u5e73\u53f0\u8ba2\u5355\u53f7\uff1a{} \u5728\u5f00\u7968\u9ed1\u540d\u5355\u4e2d\uff0c\u8bbe\u7f6e\u5f00\u7968\u72b6\u6001\u4e3a\u9ed1\u540d\u5355", (Object)platformOrderNo);
                billInfoEo.setInvoiceState(InvoiceStateEnum.BLACKLIST.getCode());
                return true;
            }
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u9ed1\u540d\u5355\u5f02\u5e38\uff1a{}", (Object)e.getMessage(), (Object)e);
        }
        return false;
    }

    public void getBillInfo(DgPerformOrderInfoEo performOrderInfoDto, DgPerformOrderSnapshotEo performOrderSnapshotDto, BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto, SaleOrderBillRecordDto saleOrderBillRecordRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        String billFlowNo = this.generateCodeDataUtils.generateNo("KP");
        billInfoEo.setBillFlowNo(billFlowNo);
        if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill())) {
            billInfoEo.setPlatformOrderNo(String.join((CharSequence)",", billInfoGenerateReqDto.getPlatformOrderNoList()));
        } else {
            billInfoEo.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
        }
        billInfoEo.setWhetherMergeBill(billInfoGenerateReqDto.getWhetherMergeBill());
        billInfoEo.setApplyNo(saleOrderBillRecordRespDto.getApplyNo());
        billInfoEo.setShopId(performOrderSnapshotDto.getShopId());
        billInfoEo.setShopCode(performOrderSnapshotDto.getShopCode());
        ShopEo shopEo = this.shopService.selectShopByCode(performOrderSnapshotDto.getShopCode());
        billInfoEo.setOrganizationCode(shopEo.getOrganizationCode());
        billInfoEo.setShopName(shopEo.getName());
        billInfoEo.setSite(performOrderSnapshotDto.getSiteName());
        billInfoEo.setSiteCode(performOrderSnapshotDto.getSiteCode());
        billInfoEo.setCustomerCode(performOrderSnapshotDto.getHsCustomerCode());
        billInfoEo.setCustomerName(performOrderSnapshotDto.getHsCustomerName());
        billInfoEo.setSubsidiesType(Integer.valueOf(null != performOrderInfoDto.getSubsidiesType() ? performOrderInfoDto.getSubsidiesType() : 0));
        billInfoEo.setInvoiceType(this.invoiceTypeConvert.invoiceTypeConvert(performOrderInfoDto.getPlatformOrderNo(), billStrategyRespDto, saleOrderBillRecordRespDto, billInfoEo, billInfoGenerateReqDto));
        PerformOrderInfoDto infoDto = new PerformOrderInfoDto();
        CubeBeanUtils.copyProperties((Object)infoDto, (Object)performOrderInfoDto, (String[])new String[0]);
        ArrayList snapshotEoList = com.google.common.collect.Lists.newArrayList((Object[])new DgPerformOrderSnapshotEo[]{performOrderSnapshotDto});
        ArrayList snapshotDtoList = new ArrayList();
        CubeBeanUtils.copyCollection(snapshotDtoList, (Collection)snapshotEoList, PerformOrderSnapshotDto.class);
        infoDto.setPerformOrderSnapshotDtoList(snapshotDtoList);
        billInfoEo.setTitleType(saleOrderBillRecordRespDto.getTitleType());
        billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getTaxesCode()) ? saleOrderBillRecordRespDto.getTaxesCode().replace(" ", "") : null);
        billInfoEo.setRegisteredAddress(saleOrderBillRecordRespDto.getRegisteredAddress());
        billInfoEo.setRegisteredPhone(saleOrderBillRecordRespDto.getRegisteredPhone());
        billInfoEo.setBankAccount(saleOrderBillRecordRespDto.getBankAccount());
        billInfoEo.setBank(saleOrderBillRecordRespDto.getBank());
        BillEntityEo entityEo = new BillEntityEo();
        if (null != billStrategyRespDto.getBillEntityCode()) {
            entityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
        }
        billInfoEo.setDistributorRegisteredAddress(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorRegisteredAddress()) ? saleOrderBillRecordRespDto.getDistributorRegisteredAddress() : entityEo.getRegisteredAddress());
        billInfoEo.setDistributorRegisteredPhone(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorRegisteredPhone()) ? saleOrderBillRecordRespDto.getDistributorRegisteredPhone() : entityEo.getRegisteredPhone());
        billInfoEo.setDistributorTaxesCode(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorTaxesCode()) ? saleOrderBillRecordRespDto.getDistributorTaxesCode() : entityEo.getTaxesCode());
        billInfoEo.setDistributorBank(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorBank()) ? saleOrderBillRecordRespDto.getDistributorBank() : entityEo.getBank());
        billInfoEo.setDistributorBankAccount(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getDistributorBankAccount()) ? saleOrderBillRecordRespDto.getDistributorBankAccount() : entityEo.getBankAccount());
        billInfoEo.setCollectPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getCollectPerson()) ? saleOrderBillRecordRespDto.getCollectPerson() : entityEo.getCollectPerson());
        billInfoEo.setBillPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getBillPerson()) ? saleOrderBillRecordRespDto.getBillPerson() : entityEo.getBillPerson());
        billInfoEo.setReviewPerson(StringUtils.isNotBlank((CharSequence)saleOrderBillRecordRespDto.getReviewPerson()) ? saleOrderBillRecordRespDto.getReviewPerson() : entityEo.getReviewPerson());
        billInfoEo.setCreateType(BillCreateTypeEnum.SYSTEM.getCode());
        billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
        billInfoEo.setMailbox(saleOrderBillRecordRespDto.getMailbox());
        billInfoEo.setPhone(saleOrderBillRecordRespDto.getPhone());
        if (null != saleOrderBillRecordRespDto.getEntityId()) {
            BillEntityEo entity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)saleOrderBillRecordRespDto.getEntityId())).one();
            if (Objects.nonNull(entity)) {
                billInfoEo.setEntityId(entity.getId());
                billInfoEo.setEntityCode(entity.getEntityCode());
                billInfoEo.setEntityName(entity.getEntityName());
                billInfoEo.setEnterprise(entity.getEnterprise());
            }
        } else {
            billInfoEo.setEntityId(entityEo.getId());
            billInfoEo.setEntityCode(entityEo.getEntityCode());
            billInfoEo.setEntityName(entityEo.getEntityName());
            billInfoEo.setEnterprise(entityEo.getEnterprise());
        }
        billInfoEo.setBillChannel(billStrategyRespDto.getBillChannel());
        billInfoEo.setBillType(BillInfoColourTypeEnum.BLUE_TICKET.getCode());
        billInfoEo.setInvoiceAmount(saleOrderBillRecordRespDto.getInvoiceAmount());
        billInfoEo.setBillTitle(saleOrderBillRecordRespDto.getBillTitle());
        billInfoEo.setTitleType(saleOrderBillRecordRespDto.getTitleType());
        if (billStrategyRespDto.getBillObject().equals("apply")) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"apply_no", (Object)billInfoGenerateReqDto.getApplyNo());
            List billApplyEoList = this.billApplyMapper.selectList((Wrapper)queryWrapper);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billApplyEoList)) {
                BillApplyEo billApplyEo = (BillApplyEo)billApplyEoList.get(0);
                billInfoEo.setInvoiceType(billApplyEo.getBillType());
                billInfoEo.setBillTitle(billApplyEo.getBillTitle());
                billInfoEo.setTitleType(billApplyEo.getTitleType());
                billInfoEo.setTaxesCode(StringUtils.isNotBlank((CharSequence)billApplyEo.getTaxesCode()) ? billApplyEo.getTaxesCode().replace(" ", "") : null);
                billInfoEo.setRegisteredAddress(billApplyEo.getRegisteredAddress());
                billInfoEo.setRegisteredPhone(billApplyEo.getRegisteredPhone());
                billInfoEo.setBankAccount(billApplyEo.getBankAccount());
                billInfoEo.setBank(billApplyEo.getBank());
                billInfoEo.setApplyNo(billApplyEo.getApplyNo());
                billInfoEo.setMailbox(billApplyEo.getMailbox());
                billInfoEo.setPhone(billApplyEo.getPhone());
            }
        }
        if (!BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType())) {
            billInfoEo.setBillPersonPhone(saleOrderBillRecordRespDto.getBillPersonPhone());
            billInfoEo.setBillPersonName(saleOrderBillRecordRespDto.getBillPersonName());
            billInfoEo.setBillAddress(saleOrderBillRecordRespDto.getBillAddress());
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType())) {
            billInfoEo.setBillChannel(billStrategyRespDto.getBillChannel());
        }
        if (StringUtils.isBlank((CharSequence)billInfoEo.getBillTitle())) {
            billInfoEo.setBillTitle("\u4e2a\u4eba");
        }
        this.billInfoService.validateAndResetCustomerInfoForMultiArea(billInfoEo, billStrategyRespDto, infoDto);
        this.billInfoService.resetBillTitleAndTaxesCodeByIdentity(billInfoEo, infoDto);
    }

    public void getShopAllElectricInfo(BillInfoEo billInfoEo) {
        log.info("\u67e5\u8be2\u662f\u5426\u4e3a\u5168\u7535\u5e97\u94fa:{}", (Object)billInfoEo.getShopCode());
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getShopCode())) {
            List list = ((ExtQueryChainWrapper)this.billAllElectricShopDas.filter().eq((Object)"shop_code", (Object)billInfoEo.getShopCode())).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                log.info("\u5168\u7535\u5e97\u94fa\u66f4\u65b0\u53d1\u7968\u7c7b\u578b");
                switch (billInfoEo.getInvoiceType()) {
                    case "electronic_general_invoice": 
                    case "paper_general_invoice": 
                    case "all_electronic_general_invoice": 
                    case "num_electronic_paper_general_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode());
                        break;
                    }
                    case "special_paper_invoice": 
                    case "all_electronic_special_invoice": 
                    case "electronic_special_invoice": 
                    case "num_electronic_special_paper_invoice": {
                        billInfoEo.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode());
                        break;
                    }
                }
            }
        } else {
            log.info("\u53d1\u7968\u5e97\u94fa\u4e3a\u7a7a");
        }
    }

    public Boolean redKingdeeInvoice(BillInfoEo info, Map<String, List<BillItemEo>> billItemMap, Map<String, List<BillOrderItemEo>> billOrderItemMap, List<String> errorList, DgPerformOrderInfoEo performOrderInfoEo) {
        Boolean flag = true;
        BillInfoEo addRedBill = new BillInfoEo();
        CubeBeanUtils.copyProperties((Object)addRedBill, (Object)info, (String[])new String[]{"id,extension,createTime,uploadPdfUrl"});
        addRedBill.setId(null);
        String code = this.generateCodeDataUtils.generateNo("KP");
        addRedBill.setBillFlowNo(code);
        addRedBill.setBlueTicketFlowNo(info.getBillFlowNo());
        addRedBill.setBlueTicketInvoiceCode(info.getExternalInvoiceCode());
        addRedBill.setBlueTicketInvoiceNo(info.getExternalInvoiceNo());
        addRedBill.setUploadPdfUrl(null);
        addRedBill.setExtension(null);
        addRedBill.setCreateTime(new Date());
        addRedBill.setUpdateTime(new Date());
        addRedBill.setInvoiceUrl(null);
        addRedBill.setExternalInvoiceTime(null);
        addRedBill.setExternalInvoiceCode(null);
        addRedBill.setExternalInvoiceNo(null);
        addRedBill.setInvoiceConnectUrl(null);
        addRedBill.setAuditTime(null);
        addRedBill.setAuditPerson(null);
        addRedBill.setAgainBillRedBillFlowNo(null);
        addRedBill.setAllRedFlag(AllRedFlagEnum.YES_ALL_RED_FLAG.getCode());
        addRedBill.setPlatformOrderNo(info.getPlatformOrderNo());
        addRedBill.setBillType(BillInfoColourTypeEnum.RED_TICKET.getCode());
        if ((BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(info.getInvoiceType()) || BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(info.getInvoiceType())) && this.isInCurrentMonth(info.getExternalInvoiceTime())) {
            addRedBill.setBillType(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        }
        addRedBill.setInvoiceState(InvoiceStateEnum.INVOICING.getCode());
        this.billInfoDas.insert((BaseEo)addRedBill);
        RestResponse response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto(addRedBill, billItemMap.get(info.getBillFlowNo()), 2, performOrderInfoEo));
        log.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
        flag = response.isSuccess() && "0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode());
        this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, addRedBill.getId()));
        List<String> platformOrderNoList = new ArrayList<String>();
        if (Objects.nonNull(addRedBill.getPlatformOrderNo())) {
            platformOrderNoList = Arrays.asList(addRedBill.getPlatformOrderNo().split(","));
        }
        this.billBusinessRelPlatformService.addBillBusinessRelPlatform(platformOrderNoList, code, RelBusinessTypeEnum.INVOICE.getCode());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billItemMap.get(info.getBillFlowNo()))) {
            billItemMap.get(info.getBillFlowNo()).forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billItemDas.insertBatch(billItemMap.get(info.getBillFlowNo()));
        }
        if (billOrderItemMap.containsKey(info.getBillFlowNo())) {
            List<BillOrderItemEo> billOrderItemEoList = billOrderItemMap.get(info.getBillFlowNo());
            billOrderItemEoList.forEach(item -> {
                item.setId(null);
                item.setBillFlowNo(code);
            });
            this.billOrderItemDas.insertBatch(billOrderItemEoList);
        }
        return flag;
    }

    private InvoiceInfoReqDto buildInvoiceInfoReqDto(BillInfoEo info, List<BillItemEo> billItemEos, Integer invoiceBillType, DgPerformOrderInfoEo platformOrderInfoEo) {
        InvoiceInfoReqDto invoiceInfoReqDto = new InvoiceInfoReqDto();
        invoiceInfoReqDto.setInvoiceSerialNumber(info.getBillFlowNo());
        invoiceInfoReqDto.setOrderNumber(info.getPlatformOrderNo());
        invoiceInfoReqDto.setTaxpayerIdentificationNumber(info.getDistributorTaxesCode());
        invoiceInfoReqDto.setRemark(info.getInvoiceRemarks());
        invoiceInfoReqDto.setInvoiceIssuerName(info.getEntityName());
        invoiceInfoReqDto.setInvoiceType(info.getInvoiceType());
        invoiceInfoReqDto.setInvoiceTileType(info.getTitleType());
        invoiceInfoReqDto.setMainInvoiceProject(info.getEntityName());
        invoiceInfoReqDto.setSalesTaxpayerIdentificationNumber(info.getDistributorTaxesCode());
        invoiceInfoReqDto.setSalesTaxpayerName(info.getEntityName());
        invoiceInfoReqDto.setSalesTaxpayerAddress(info.getDistributorRegisteredAddress());
        invoiceInfoReqDto.setSalesTaxpayerPhone(info.getDistributorRegisteredPhone());
        invoiceInfoReqDto.setSalesTaxpayerBankAccount(info.getDistributorBankAccount());
        invoiceInfoReqDto.setPurchaserName(info.getBillTitle());
        invoiceInfoReqDto.setPurchaserEmail(info.getMailbox());
        invoiceInfoReqDto.setPurchaserMobilePhone(info.getPhone());
        invoiceInfoReqDto.setDrawer(info.getBillPerson());
        invoiceInfoReqDto.setPayee(info.getCollectPerson());
        invoiceInfoReqDto.setReviewer(info.getReviewPerson());
        invoiceInfoReqDto.setInvoiceBillType(invoiceBillType);
        invoiceInfoReqDto.setOriginalInvoiceNumber(info.getExternalInvoiceNo());
        invoiceInfoReqDto.setOriginalInvoiceCode(info.getExternalInvoiceCode());
        invoiceInfoReqDto.setTotalAmountOfPriceAndTax(info.getInvoiceAmount());
        invoiceInfoReqDto.setChannel(info.getBillChannel());
        invoiceInfoReqDto.setId(info.getId());
        invoiceInfoReqDto.setShopCode(info.getShopCode());
        invoiceInfoReqDto.setSiteCode(info.getSiteCode());
        invoiceInfoReqDto.setOrgCode(info.getEntityCode());
        invoiceInfoReqDto.setCustomerCode(info.getCustomerCode());
        invoiceInfoReqDto.setCustomerName(info.getCustomerName());
        ArrayList details = new ArrayList();
        billItemEos.forEach(item -> {
            InvoiceDetailReqDto dto = new InvoiceDetailReqDto();
            dto.setProjectName(item.getBillLineItemName());
            dto.setProjectCode(item.getItemCode());
            dto.setProjectQuantity(item.getQuantity());
            dto.setProjectUnit(item.getUnit());
            dto.setUnitPrice(item.getUnitPrice());
            dto.setProjectAmount(item.getAmount());
            dto.setTaxClassificationCode(item.getTaxClassificationCode());
            dto.setTaxRate(item.getTaxRate());
            dto.setTaxAmount(item.getTaxAmount());
            dto.setId(item.getId());
            dto.setSpecificationModel(item.getSpecification());
            if (StringUtils.isNotBlank((CharSequence)item.getEnergyEfficiencySpecModel())) {
                dto.setSpecificationModel(item.getEnergyEfficiencySpecModel());
            }
            details.add(dto);
        });
        invoiceInfoReqDto.setDetails(details);
        if (Objects.nonNull(platformOrderInfoEo)) {
            invoiceInfoReqDto.setOrderType(platformOrderInfoEo.getOrderType());
            invoiceInfoReqDto.setOrderDate(DateUtil.formatDate((Date)platformOrderInfoEo.getPlatformCreateTime()));
        }
        log.info("\u6784\u5efa\u5f00\u7968\u4fe1\u606f===>{}", (Object)JSON.toJSONString((Object)invoiceInfoReqDto));
        return invoiceInfoReqDto;
    }

    @Transactional(rollbackFor={Exception.class})
    public void syncInvoiceResult(CallBackInvoiceInfoReqDto invoiceInfoRespDto) {
        final BillInfoEo billInfoEo = (BillInfoEo)this.billInfoDas.selectByPrimaryKey(invoiceInfoRespDto.getBillInfoId());
        AssertUtil.isTrue(billInfoEo.getInvoiceState().equals(SaleOrderInvoiceStateEnum.INVOICING.getCode()), "\u8bf7\u9009\u62e9\u5f00\u7968\u4e2d\u7684\u6570\u636e");
        if ("0".equals(invoiceInfoRespDto.getExtResultCode())) {
            billInfoEo.setInvoiceConnectUrl(invoiceInfoRespDto.getDownloadUrl());
            billInfoEo.setExternalInvoiceTime(invoiceInfoRespDto.getInvoiceDate());
            billInfoEo.setExternalInvoiceCode(invoiceInfoRespDto.getInvoiceCode());
            billInfoEo.setExternalInvoiceNo(invoiceInfoRespDto.getInvoiceNumber());
            billInfoEo.setInvoiceState(invoiceInfoRespDto.getIsSync() != false ? InvoiceStateEnum.BILLED.getCode() : InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateSelective((BaseEo)billInfoEo);
            if (invoiceInfoRespDto.getIsSync().booleanValue()) {
                if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType())) {
                    this.updateOrderBillInfo((BillInfoEo)this.billInfoDas.selectByPrimaryKey(invoiceInfoRespDto.getBillInfoId()), SaleOrderInvoiceStateEnum.INVOICED.getCode());
                } else {
                    if (StrUtil.isNotBlank((CharSequence)billInfoEo.getBlueTicketFlowNo())) {
                        BillInfoEo blueInfoEo = (BillInfoEo)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBlueTicketFlowNo())).one();
                        blueInfoEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
                        this.billInfoDas.updateSelective((BaseEo)blueInfoEo);
                    }
                    this.againRedInvoiceUpdate(billInfoEo);
                }
            }
            if (invoiceInfoRespDto.getIsSync().booleanValue() && TransactionSynchronizationManager.isActualTransactionActive()) {
                TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronization(){

                    public void afterCommit() {
                        HhOrderGenerateBillInfoServiceImpl.this.iCallBackPassPlatformInvoiceService.callBackChannelInvoiceInfo(billInfoEo.getBillFlowNo());
                    }
                });
            }
            return;
        }
        billInfoEo.setExtension(invoiceInfoRespDto.getExtResultMsg());
        billInfoEo.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
        this.billInfoDas.updateSelective((BaseEo)billInfoEo);
        this.updateOrderBillInfo(billInfoEo, SaleOrderInvoiceStateEnum.WAIT_RED.getCode());
    }

    public void updateOrderBillInfo(BillInfoEo billInfoEo, String status) {
        log.info("\u5f00\u7968\u6210\u529f\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
        if (StringUtils.isBlank((CharSequence)billInfoEo.getPlatformOrderNo())) {
            log.info("\u672a\u5173\u8054\u8ba2\u5355\u4e0d\u9700\u8981\u540c\u6b65\u8ba2\u5355\u5f00\u7968\u72b6\u6001\uff1a{}", (Object)billInfoEo.getBillFlowNo());
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)billInfoEo.getSaleOrderNo()) || billInfoEo.getPlatformOrderNo().equals(billInfoEo.getSaleOrderNo())) {
                    List list;
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    List<String> platformOrderNoList = Arrays.asList(billInfoEo.getPlatformOrderNo().split(","));
                    if (WhetherMergeBillTypeEnum.YES_MERGE.getCode().equals(billInfoEo.getWhetherMergeBill()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billOrderItemDas.filter().eq((Object)"bill_flow_no", (Object)billInfoEo.getBillFlowNo())).eq((Object)"type", (Object)"order")).list()))) {
                        platformOrderNoList = list.stream().map(BillOrderItemEo::getPlatformOrderNo).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
                    }
                    saleOrderBillRecordQueryReqDto.setPlatformOrderNoList(platformOrderNoList);
                    List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    Map map = ((List)Optional.ofNullable(saleOrderBillRecordRespDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(SaleOrderBillRecordDto::getSaleOrderNo, Function.identity(), (v1, v2) -> v2));
                    PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
                    performOrderInfoPageReqDto.setPlatformOrderNoList(platformOrderNoList);
                    performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
                    List<PerformOrderInfoDto> performOrderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
                    performOrderInfoDtoList.forEach(order -> {
                        if (map.containsKey(order.getSaleOrderNo())) {
                            SaleOrderBillRecordDto saleOrderBillRecordRespDto = (SaleOrderBillRecordDto)map.get(order.getSaleOrderNo());
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(saleOrderBillRecordRespDto.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(status);
                            saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
                            saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                            saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
                            saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        } else {
                            this.addOrderBillInfo(billInfoEo, status, (PerformOrderInfoDto)order);
                        }
                    });
                } else {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordRespDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordRespDtoList)) {
                        saleOrderBillRecordRespDtoList.forEach(order -> {
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(order.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(status);
                            saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
                            saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
                            saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
                            saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        });
                    } else {
                        PerformOrderInfoDto saleOrderRespDto = new PerformOrderInfoDto();
                        saleOrderRespDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                        saleOrderRespDto.setParentOrderNo(billInfoEo.getPlatformOrderNo());
                        this.addOrderBillInfo(billInfoEo, status, saleOrderRespDto);
                    }
                }
            }
            catch (Exception e) {
                log.error("\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u5f00\u7968\u4fe1\u606f\u5931\u8d25:{}", (Object)e.getMessage());
            }
        }
    }

    private Boolean sendInvoiceIsReopen(BillInfoEo addRedBill, List<BillItemEo> billItemList, Integer invoiceBillType) {
        InvoiceInfoReqDto invoiceInfoReqDto = this.buildInvoiceInfoReqDto(addRedBill, billItemList, invoiceBillType, null);
        RestResponse response = this.invoiceApiProxy.createEliInvoice(invoiceInfoReqDto);
        log.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
        if (response.isSuccess() && "0".equals(((InvoiceInfoRespDto)response.getData()).getExtResultCode())) {
            InvoiceInfoRespDto data = (InvoiceInfoRespDto)response.getData();
            addRedBill.setInvoiceUrl(data.getDownloadUrl());
            addRedBill.setInvoiceConnectUrl(data.getDownloadUrl());
            addRedBill.setExternalInvoiceNo(data.getInvoiceNumber());
            addRedBill.setExternalInvoiceCode(data.getInvoiceCode());
            addRedBill.setExternalInvoiceTime(data.getInvoiceDate());
            addRedBill.setInvoiceState(data.getIsSync() != false ? InvoiceStateEnum.BILLED.getCode() : InvoiceStateEnum.INVOICING.getCode());
            this.billInfoDas.updateSelective((BaseEo)addRedBill);
            return true;
        }
        addRedBill.setInvoiceState(InvoiceStateEnum.FAILED.getCode());
        addRedBill.setExtension(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
        this.billInfoDas.updateSelective((BaseEo)addRedBill);
        return false;
    }

    public void againRedInvoiceUpdate(BillInfoEo billInfo) {
        BillInfoEo cancelBillInfoEo = new BillInfoEo();
        cancelBillInfoEo.setInvoiceState(InvoiceStateEnum.BILLED.getCode());
        cancelBillInfoEo.setId(billInfo.getId());
        this.billInfoDas.updateSelective((BaseEo)cancelBillInfoEo);
        if (StringUtils.isNotBlank((CharSequence)billInfo.getBlueTicketFlowNo())) {
            BillInfoEo updateEo = new BillInfoEo();
            updateEo.setInvoiceState(InvoiceStateEnum.RED_FLUSH.getCode());
            UpdateWrapper eoUpdateWrapper = new UpdateWrapper();
            eoUpdateWrapper.eq((Object)"bill_flow_no", (Object)billInfo.getBlueTicketFlowNo());
            this.billInfoMapper.update((Object)updateEo, (Wrapper)eoUpdateWrapper);
        }
        this.redOrderBillInfo(billInfo, false);
    }

    public void addOrderBillInfo(BillInfoEo billInfoEo, String status, PerformOrderInfoDto order) {
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        saleOrderBillRecordReqDto.setPlatformOrderNo(order.getPlatformOrderNo());
        saleOrderBillRecordReqDto.setSaleOrderNo(order.getSaleOrderNo());
        saleOrderBillRecordReqDto.setBillFlowNo(billInfoEo.getBillFlowNo());
        saleOrderBillRecordReqDto.setInvoiceType(billInfoEo.getInvoiceType());
        saleOrderBillRecordReqDto.setTitleType(billInfoEo.getTitleType());
        saleOrderBillRecordReqDto.setBillTitle(billInfoEo.getBillTitle());
        saleOrderBillRecordReqDto.setInvoiceAmount(billInfoEo.getInvoiceAmount());
        saleOrderBillRecordReqDto.setEntityId(billInfoEo.getEntityId());
        saleOrderBillRecordReqDto.setWhetherInvoice(status);
        saleOrderBillRecordReqDto.setTaxesCode(billInfoEo.getTaxesCode());
        saleOrderBillRecordReqDto.setRegisteredAddress(billInfoEo.getRegisteredAddress());
        saleOrderBillRecordReqDto.setRegisteredPhone(billInfoEo.getRegisteredPhone());
        saleOrderBillRecordReqDto.setBankAccount(billInfoEo.getBankAccount());
        saleOrderBillRecordReqDto.setBank(billInfoEo.getBank());
        saleOrderBillRecordReqDto.setBillPersonName(billInfoEo.getBillPersonName());
        saleOrderBillRecordReqDto.setBillPersonPhone(billInfoEo.getBillPersonPhone());
        saleOrderBillRecordReqDto.setBillAddress(billInfoEo.getBillAddress());
        saleOrderBillRecordReqDto.setDistributorBank(billInfoEo.getDistributorBank());
        saleOrderBillRecordReqDto.setDistributorBankAccount(billInfoEo.getDistributorBankAccount());
        saleOrderBillRecordReqDto.setDistributorRegisteredAddress(billInfoEo.getDistributorRegisteredAddress());
        saleOrderBillRecordReqDto.setDistributorRegisteredPhone(billInfoEo.getDistributorRegisteredPhone());
        saleOrderBillRecordReqDto.setDistributorTaxesCode(billInfoEo.getDistributorTaxesCode());
        saleOrderBillRecordReqDto.setCollectPerson(billInfoEo.getCollectPerson());
        saleOrderBillRecordReqDto.setReviewPerson(billInfoEo.getReviewPerson());
        saleOrderBillRecordReqDto.setBillPerson(billInfoEo.getBillPerson());
        saleOrderBillRecordReqDto.setBillChannel(billInfoEo.getBillChannel());
        saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        saleOrderBillRecordReqDto.setMailbox(billInfoEo.getMailbox());
        saleOrderBillRecordReqDto.setPhone(billInfoEo.getPhone());
        this.saleOrderBillRecordApiProxy.addSaleOrderBillRecord(saleOrderBillRecordReqDto);
    }

    public void redOrderBillInfo(BillInfoEo billInfoEo, boolean flag) {
        log.info("\u7ea2\u51b2\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f\uff1a{},\u5f00\u5173:{}", (Object)JSONObject.toJSONString((Object)billInfoEo), (Object)flag);
        if (StringUtils.isBlank((CharSequence)billInfoEo.getPlatformOrderNo())) {
            log.info("\u672a\u5173\u8054\u8ba2\u5355\u4e0d\u9700\u8981\u540c\u6b65\u7ea2\u51b2\u72b6\u6001\uff1a{}", (Object)billInfoEo.getBillFlowNo());
        } else {
            try {
                if (StringUtils.isBlank((CharSequence)billInfoEo.getSaleOrderNo()) || billInfoEo.getPlatformOrderNo().equals(billInfoEo.getSaleOrderNo())) {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordDtoList)) {
                        ArrayList<String> queryBillStatus = new ArrayList<String>();
                        queryBillStatus.add(InvoiceStateEnum.WAIT_AUDIT.getCode());
                        queryBillStatus.add(InvoiceStateEnum.WAIT_BILL.getCode());
                        queryBillStatus.add(InvoiceStateEnum.INVOICING.getCode());
                        queryBillStatus.add(InvoiceStateEnum.BILLED.getCode());
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"invoice_state", queryBillStatus)).eq((Object)"bill_type", (Object)BillInfoColourTypeEnum.BLUE_TICKET.getCode())).list();
                        BigDecimal invoiceAmount = billInfoEo.getInvoiceAmount();
                        String orderInvoiceStatus = SaleOrderInvoiceStateEnum.RED_FLUSH.getCode();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                            BillInfoEo info = (BillInfoEo)list.get(0);
                            invoiceAmount = info.getInvoiceAmount();
                            switch (info.getInvoiceState()) {
                                case "wait_audit": 
                                case "wait_bill": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.WAIT_BILL.getCode();
                                    break;
                                }
                                case "invoicing": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICING.getCode();
                                    break;
                                }
                                case "billed": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICED.getCode();
                                    break;
                                }
                            }
                        }
                        String finalOrderInvoiceStatus = flag ? SaleOrderInvoiceStateEnum.WAIT_CANCEL.getCode() : orderInvoiceStatus;
                        BigDecimal finalInvoiceAmount = invoiceAmount;
                        saleOrderBillRecordDtoList.forEach(order -> {
                            SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
                            CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
                            saleOrderBillRecordReqDto.setId(order.getId());
                            saleOrderBillRecordReqDto.setWhetherInvoice(finalOrderInvoiceStatus);
                            saleOrderBillRecordReqDto.setInvoiceAmount(finalInvoiceAmount);
                            saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
                            this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
                        });
                    }
                } else {
                    SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                    saleOrderBillRecordQueryReqDto.setSaleOrderNo(billInfoEo.getSaleOrderNo());
                    List<SaleOrderBillRecordDto> saleOrderBillRecordDtoList = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderBillRecordDtoList)) {
                        ArrayList<String> queryBillStatus = new ArrayList<String>();
                        queryBillStatus.add(InvoiceStateEnum.WAIT_AUDIT.getCode());
                        queryBillStatus.add(InvoiceStateEnum.WAIT_BILL.getCode());
                        queryBillStatus.add(InvoiceStateEnum.INVOICING.getCode());
                        queryBillStatus.add(InvoiceStateEnum.BILLED.getCode());
                        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"sale_order_no", (Object)billInfoEo.getSaleOrderNo())).in((Object)"invoice_state", queryBillStatus)).list();
                        String orderInvoiceStatus = SaleOrderInvoiceStateEnum.RED_FLUSH.getCode();
                        BigDecimal invoiceAmount = billInfoEo.getInvoiceAmount();
                        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
                            BillInfoEo info = (BillInfoEo)list.get(0);
                            invoiceAmount = info.getInvoiceAmount();
                            switch (info.getInvoiceState()) {
                                case "wait_audit": 
                                case "wait_bill": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.WAIT_BILL.getCode();
                                    break;
                                }
                                case "invoicing": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICING.getCode();
                                    break;
                                }
                                case "billed": {
                                    orderInvoiceStatus = SaleOrderInvoiceStateEnum.INVOICED.getCode();
                                    break;
                                }
                            }
                        }
                        String finalOrderInvoiceStatus = flag ? SaleOrderInvoiceStateEnum.WAIT_CANCEL.getCode() : orderInvoiceStatus;
                        Object finalInvoiceAmount = invoiceAmount;
                        saleOrderBillRecordDtoList.forEach(arg_0 -> this.lambda$redOrderBillInfo$9(billInfoEo, finalOrderInvoiceStatus, (BigDecimal)finalInvoiceAmount, arg_0));
                    }
                }
            }
            catch (Exception e) {
                log.error("\u7ea2\u51b2\u540c\u6b65\u66f4\u65b0\u8ba2\u5355\u53d1\u7968\u4fe1\u606f:{}", (Object)e.getMessage());
            }
        }
    }

    private CallBackInvoiceInfoReqDto extractInvoiceInfoReqDto(RestResponse<InvoiceInfoRespDto> response, Long billInfoId) {
        CallBackInvoiceInfoReqDto infoReqDto = (CallBackInvoiceInfoReqDto)BeanUtil.toBean((Object)response.getData(), CallBackInvoiceInfoReqDto.class);
        infoReqDto.setBillInfoId(billInfoId);
        infoReqDto.setExtResultMsg(response.isSuccess() ? ((InvoiceInfoRespDto)response.getData()).getExtResultMsg() : response.getResultMsg());
        return infoReqDto;
    }

    public void billInfoOrderCompleteStrategy(BillStrategyRespDto billStrategyRespDto, PerformOrderInfoDto performOrderInfoDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        PerformOrderInfoPageReqDto performOrderInfoPageReqDto = new PerformOrderInfoPageReqDto();
        performOrderInfoPageReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
        performOrderInfoPageReqDto.setPlatFormOrderSelectTypeCode(PlatFormOrderSelectTypeEnum.NOW_USE.getCode());
        List<PerformOrderInfoDto> orderInfoDtoList = this.performOrderInfoService.queryByPlatFormOrderNo(performOrderInfoPageReqDto);
        AtomicBoolean flag = new AtomicBoolean(true);
        orderInfoDtoList.forEach(order -> {
            String orderStatus = order.getOrderStatus();
            if (this.orderTypeFilter(order.getOrderType()).booleanValue() && !OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) && !OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus) && !OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus)) {
                flag.set(false);
            }
        });
        if (flag.get()) {
            List list = orderInfoDtoList.stream().filter(order -> OmsSaleOrderStatus.COMPLETE.getCode().equals(order.getOrderStatus())).collect(Collectors.toList());
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(list)) {
                List billInfoEoList;
                if ((WhetherMergeBillTypeEnum.NO_MERGE.getCode().equals(billInfoGenerateReqDto.getWhetherMergeBill()) || null == billInfoGenerateReqDto.getWhetherMergeBill()) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)performOrderInfoDto.getPlatformOrderNo())).list())) && billInfoEoList.stream().anyMatch(bill -> InvoiceStateEnum.INVOICING.getCode().equals(bill.getInvoiceState()) || InvoiceStateEnum.FAILED.getCode().equals(bill.getInvoiceState()))) {
                    log.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u5355\u636e\u4e0d\u7ee7\u7eed\u64cd\u4f5c");
                    this.addBillApplyOrderInfo(billInfoEoList, performOrderInfoDto);
                    return;
                }
                SaleOrderBillRecordPageReqDto saleOrderBillRecordQueryReqDto = new SaleOrderBillRecordPageReqDto();
                saleOrderBillRecordQueryReqDto.setPlatformOrderNo(performOrderInfoDto.getPlatformOrderNo());
                List<SaleOrderBillRecordDto> saleOrderBillRecordDtos = this.saleOrderBillRecordService.queryByReqDto(saleOrderBillRecordQueryReqDto);
                log.info("\u6839\u636e\u8ba2\u5355\u53f7\u83b7\u53d6\u8ba2\u5355\u5f00\u7968\u7684\u5f00\u7968\u4fe1\u606f:{}", (Object)JSON.toJSONString(saleOrderBillRecordDtos));
            }
        } else {
            log.info("\u5e73\u53f0\u8ba2\u5355\u7684\u914d\u8d27\u8ba2\u5355\u672a\u5168\u90e8\u5b8c\u6210:{}", (Object)performOrderInfoDto.getPlatformOrderNo());
        }
    }

    private void addBillApplyOrderInfo(List<BillInfoEo> billInfoEoList, PerformOrderInfoDto performOrderInfoDto) {
        Boolean hasWaitHandleApply = this.isHasWaitHandleApply(performOrderInfoDto.getPlatformOrderNo());
        if (hasWaitHandleApply.booleanValue()) {
            log.info("\u5b58\u5728\u5f00\u7968\u4e2d/\u5f00\u7968\u5931\u8d25\u7684\u5355\u751f\u6210\u5bf9\u5e94\u7684\u7533\u8bf7\u5355\u8bb0\u5f55\uff1a{}", (Object)performOrderInfoDto.getPlatformOrderNo());
            List billInfoEos = billInfoEoList.stream().sorted(Comparator.comparing(BaseEo::getId).reversed()).collect(Collectors.toList());
            BillInfoEo billInfoEo = (BillInfoEo)billInfoEos.get(0);
            IGenerateCodeService generateCodeService = GenerateCodeUtils.getStrategy(GenerateCodeStrategyEnum.BILL_APPLY.getCode());
            String applyNo = generateCodeService.getCode("BA");
            BillApplyEo billApplyEo = new BillApplyEo();
            billApplyEo.setApplyNo(applyNo);
            billApplyEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
            billApplyEo.setSite(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
            billApplyEo.setShopId(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopId());
            billApplyEo.setShopCode(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopCode());
            billApplyEo.setShopName(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getShopName());
            billApplyEo.setPlatformOrderStatus(performOrderInfoDto.getPlatformOrderStatus());
            billApplyEo.setApplyChannel(((PerformOrderSnapshotDto)performOrderInfoDto.getPerformOrderSnapshotDtoList().get(0)).getChannelCode());
            billApplyEo.setApplyType("apply_bill");
            billApplyEo.setBillType(billInfoEo.getInvoiceType());
            billApplyEo.setBillTitle(billInfoEo.getBillTitle());
            billApplyEo.setChangeType(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            billApplyEo.setApplyTime(new Date());
            billApplyEo.setEnterprise(billInfoEo.getBillTitle());
            billApplyEo.setTaxesCode(billInfoEo.getTaxesCode());
            billApplyEo.setRegisteredAddress(billInfoEo.getRegisteredAddress());
            billApplyEo.setRegisteredPhone(billInfoEo.getRegisteredPhone());
            billApplyEo.setBankAccount(billInfoEo.getBankAccount());
            billApplyEo.setBank(billInfoEo.getBank());
            billApplyEo.setMailbox(billInfoEo.getMailbox());
            billApplyEo.setPhone(billInfoEo.getPhone());
            billApplyEo.setTitleType(billInfoEo.getTitleType());
            billApplyEo.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
            billApplyEo.setBillAddress(billInfoEo.getBillAddress());
            billApplyEo.setBillPersonPhone(billInfoEo.getBillPersonPhone());
            billApplyEo.setBillPersonName(billInfoEo.getBillPersonName());
            this.billApplyDomain.insert((BaseEo)billApplyEo);
            this.billBusinessRelPlatformService.addBillBusinessRelPlatform(Arrays.asList(billApplyEo.getPlatformOrderNo().split(",")), billApplyEo.getApplyNo(), RelBusinessTypeEnum.APPLY.getCode());
        }
    }

    public Boolean isHasWaitHandleApply(String platformOrderNo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.APPLY.getCode())).eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)list)) {
            List applyList = list.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
            ArrayList<String> changeTypeList = new ArrayList<String>();
            changeTypeList.add(BillApplyChangeTypeEnum.WAIT_HANDLE.getCode());
            changeTypeList.add(BillApplyChangeTypeEnum.HANDLE_FAIL.getCode());
            List billApplyEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDomain.filter().in((Object)"apply_no", applyList)).in((Object)"change_type", changeTypeList)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billApplyEoList)) {
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public void syncAddKingdeeInvoice(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, Boolean reopenIsBill, DgPerformOrderInfoEo performOrderInfoEo) {
        if (InvoiceStateEnum.BLACKLIST.getCode().equals(billInfoEo.getInvoiceState()) && BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType())) {
            log.warn("\u5f00\u7968\u4fe1\u606f\u72b6\u6001\u4e3a\u9ed1\u540d\u5355\u4e14\u53d1\u7968\u7c7b\u578b\u4e3a\u84dd\u7968\uff0c\u4e0d\u63a8\u9001\u4e07\u9e3f\uff1a{}", (Object)billInfoEo.getPlatformOrderNo());
            return;
        }
        if (InvoiceStateEnum.WAIT_BILL.getCode().equals(billInfoEo.getInvoiceState())) {
            CompletableFuture.runAsync(() -> {
                log.info("\u5f02\u6b65\u8c03\u7528\u65b0\u589e\u53d1\u7968:{}", (Object)JSONObject.toJSONString((Object)billInfoEo));
                RestResponse response = this.invoiceApiProxy.createEliInvoice(this.buildInvoiceInfoReqDto(billInfoEo, billItemEoList, 1, performOrderInfoEo));
                log.info("\u53d1\u8d77\u5f00\u7968response=\u300b\u300b{}", (Object)JSON.toJSONString((Object)response));
                this.syncInvoiceResult(this.extractInvoiceInfoReqDto((RestResponse<InvoiceInfoRespDto>)response, billInfoEo.getId()));
            });
        }
    }

    private List<BillItemEo> saveBillDetailInfo(DgPerformOrderInfoEo performOrderInfoEo, List<DgPerformOrderLineDto> orderLineDtoList, BillInfoEo billInfoEo, BillStrategyRespDto billStrategyRespDto, List<DgPerformOrderInfoEo> performOrderInfoEos) {
        ArrayList<DgPerformOrderLineDto> itemList = new ArrayList<DgPerformOrderLineDto>();
        ArrayList<DgPerformOrderLineDto> zeroNumItemList = new ArrayList<DgPerformOrderLineDto>();
        ArrayList<BillItemEo> billItemEoList = new ArrayList<BillItemEo>();
        if (this.orderTypeFilter(performOrderInfoEo.getOrderType()).booleanValue()) {
            if (!OmsSaleOrderStatus.CANCEL.getCode().equals(performOrderInfoEo.getOrderStatus())) {
                this.freightInvoice(orderLineDtoList, billStrategyRespDto, performOrderInfoEos);
                List noInvoiceItemEoList = ((ExtQueryChainWrapper)this.billStrategyNoInvoiceItemDas.filter().eq((Object)"strategy_id", (Object)billStrategyRespDto.getId())).list();
                Map itemEoMap = ((List)Optional.ofNullable(noInvoiceItemEoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(BillStrategyNoInvoiceItemEo::getItemCode, Function.identity(), (v1, v2) -> v2));
                orderLineDtoList.forEach(item -> this.filterItem((DgPerformOrderLineDto)item, itemEoMap, billStrategyRespDto, (List<DgPerformOrderLineDto>)itemList, (List<DgPerformOrderLineDto>)zeroNumItemList));
            }
        } else {
            log.info("\u8865\u53d1\u8ba2\u5355\u5546\u54c1\u884c\u4e0d\u8fdb\u884c\u5f00\u7968");
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(zeroNumItemList)) {
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemList)) {
                BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
                BigDecimal payAmount = ((DgPerformOrderLineDto)itemList.get(0)).getRealPayAmount();
                ((DgPerformOrderLineDto)itemList.get(0)).setRealPayAmount(payAmount.add(amount));
                log.info("\u5b58\u5728\u5546\u54c1\u9000\u6570\u91cf\u5b8c\u6210\u91d1\u989d\u5927\u4e8e\u96f6\uff1a{}", (Object)amount);
            } else if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                this.assembleFreightCostItem(billStrategyRespDto, itemList, zeroNumItemList);
            }
        }
        if (org.apache.commons.collections.CollectionUtils.isEmpty(itemList)) {
            log.info("\u5f00\u7968\u5546\u54c1\u660e\u7ec6\u6ca1\u6709\u53ef\u4ee5\u6b63\u5e38\u5f00\u7968\u6570\u636e");
            return new ArrayList<BillItemEo>();
        }
        BigDecimal mergeItemAmount = BigDecimal.ZERO;
        ArrayList noWhetherMergeItem = new ArrayList();
        ArrayList<DgPerformOrderLineDto> whetherMergeItem = new ArrayList<DgPerformOrderLineDto>();
        if (1 == billStrategyRespDto.getWhetherMergeItem()) {
            log.info("\u6839\u636e\u7b56\u7565\u7ec4\u5408\u5546\u54c1\u9700\u8981\u5408\u5e76\u5f00\u7968");
            itemList.forEach(item -> {
                if (StringUtils.isNotBlank((CharSequence)item.getGroupSkuCode())) {
                    whetherMergeItem.add((DgPerformOrderLineDto)item);
                } else {
                    noWhetherMergeItem.add(item);
                }
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(whetherMergeItem)) {
                mergeItemAmount = this.whetherMergeItem(whetherMergeItem, billInfoEo, billItemEoList, billStrategyRespDto);
            }
        } else {
            CubeBeanUtils.copyCollection(noWhetherMergeItem, itemList, DgPerformOrderLineDto.class);
        }
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(noWhetherMergeItem)) {
            Map<String, List<DgPerformOrderLineDto>> orderItemMap = noWhetherMergeItem.stream().collect(Collectors.groupingBy(item -> item.getSkuCode() + item.getGift()));
            List<String> skuCodeList = noWhetherMergeItem.stream().map(DgPerformOrderLineDto::getSkuCode).distinct().collect(Collectors.toList());
            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
            Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
            orderItemMap.forEach((k, v) -> {
                BillItemEo billItemEo = new BillItemEo();
                DgPerformOrderLineDto performOrderItemDto = (DgPerformOrderLineDto)v.get(0);
                billItemEo.setGift(performOrderItemDto.getGift());
                if (3 == performOrderItemDto.getGift()) {
                    billItemEo.setGift(Integer.valueOf(0));
                    billItemEo.setFreightCost(Integer.valueOf(1));
                }
                billItemEo.setSpecification(performOrderItemDto.getSkuDesc());
                billItemEo.setUnit(performOrderItemDto.getBasicUnitName());
                billItemEo.setFreightCost(performOrderItemDto.getIsFreightCost());
                billItemEo.setItemId(performOrderItemDto.getSkuId());
                billItemEo.setItemCode(performOrderItemDto.getSkuCode());
                billItemEo.setItemName(performOrderItemDto.getSkuName());
                billItemEo.setQuantity(v.stream().map(DgPerformOrderLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
                billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
                BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billItemEo.setAmount(amount);
                billItemEo.setClinchDealAmount(amount);
                number.set(((BigDecimal)number.get()).add(amount));
                billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                billItemEo.setUnitPrice(performOrderItemDto.getSalePrice());
                billItemEo.setUnit(performOrderItemDto.getCalcUnitDesc());
                if (skuCodeMap.containsKey(performOrderItemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(performOrderItemDto.getSkuCode());
                    billItemEo.setItemName(itemSkuDgDto.getName());
                    billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    billItemEo.setItemShortName(itemSkuDgDto.getDisplayName());
                    billItemEo.setPatentName(itemSkuDgDto.getPatentCode());
                    billItemEo.setUnit(itemSkuDgDto.getSaleUnitName());
                    this.assembleBillItemInfo(performOrderItemDto, itemSkuDgDto, billStrategyRespDto, billItemEo);
                }
                if (BigDecimalUtils.gtZero((BigDecimal)billItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)billItemEo.getQuantity()).booleanValue()) {
                    billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
                }
                this.billInfoService.setSpecialRate(billInfoEo, billItemEo);
                billItemEoList.add(billItemEo);
            });
            this.addBillOrderItem(itemList, billInfoEo, skuCodeMap, billStrategyRespDto);
        }
        billInfoEo.setInvoiceAmount(number.get().add(mergeItemAmount));
        this.getBillRemark(billStrategyRespDto, billInfoEo, performOrderInfoEo, billItemEoList);
        this.itemGiftGenerateEo(billItemEoList);
        log.info("saveBillDetailInfo==>billItemEoList:{}", (Object)LogUtils.buildLogContent(billItemEoList));
        this.billItemDas.insertBatch(billItemEoList);
        return billItemEoList;
    }

    private void itemGiftGenerateEo(List<BillItemEo> itemList) {
        if (CollUtil.isEmpty(itemList)) {
            return;
        }
        ArrayList itemGiftList = com.google.common.collect.Lists.newArrayList();
        for (BillItemEo orderItem : itemList) {
            BigDecimal salePrice;
            if (!Objects.equals(1, orderItem.getGift()) || BigDecimalUtils.gtZero((BigDecimal)orderItem.getAmount()).booleanValue() || BigDecimalUtils.leZero((BigDecimal)(salePrice = orderItem.getUnitPrice())).booleanValue()) continue;
            orderItem.setAmount(salePrice.multiply(orderItem.getQuantity()));
            BillItemEo itemGiftSalePrice = (BillItemEo)BeanUtil.copyProperties((Object)orderItem, BillItemEo.class, (String[])new String[0]);
            itemGiftSalePrice.setAmount(orderItem.getAmount().negate());
            itemGiftList.add(itemGiftSalePrice);
        }
        if (CollUtil.isNotEmpty((Collection)itemGiftList)) {
            log.info("\u751f\u6210\u8d60\u54c1\u8d1f\u6570\u884c\uff1a{}", (Object)JSON.toJSONString((Object)itemGiftList));
            itemList.addAll(itemGiftList);
        }
    }

    public void assembleBillItemInfo(DgPerformOrderLineDto performOrderItemDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillItemEo billItemEo) {
        if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
            ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
            billItemEo.setTaxRate(itemRateDgDto.getRate());
            billItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                billItemEo.setBillLineItemName(itemDisplayName);
            }
            billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public void getBillRemark(BillStrategyRespDto billStrategyRespDto, BillInfoEo billInfoEo, DgPerformOrderInfoEo performOrderInfoDto, List<BillItemEo> billItemEoList) {
        List list;
        ArrayList remarks = com.google.common.collect.Lists.newArrayList();
        if (BillStrategyRemarkType.PLATFORM.containsCode(billStrategyRespDto.getRemark())) {
            billInfoEo.setInvoiceRemarks(performOrderInfoDto.getPlatformOrderNo());
            remarks.add(performOrderInfoDto.getPlatformOrderNo());
        }
        if (BillStrategyRemarkType.PATENT.containsCode(billStrategyRespDto.getRemark())) {
            list = billItemEoList.stream().map(BillItemEo::getPatentName).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
            if (CollUtil.isNotEmpty(list)) {
                remarks.addAll(list);
            }
            billInfoEo.setInvoiceRemarks(String.join((CharSequence)";", remarks));
        }
        if (CollectionUtils.isNotEmpty((Collection)(list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billApplyDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).orderByDesc((Object)"create_time")).list(Integer.valueOf(2))))) {
            String joinRemarks;
            String str = StrUtil.isNotBlank((CharSequence)billInfoEo.getInvoiceRemarks()) ? billInfoEo.getInvoiceRemarks() + "," : billInfoEo.getInvoiceRemarks();
            String string = joinRemarks = list.size() > 1 && StrUtil.isBlank((CharSequence)((BillApplyEo)list.get(0)).getRemark()) ? ((BillApplyEo)list.get(1)).getRemark() : ((BillApplyEo)list.get(0)).getRemark();
            if (StrUtil.isNotBlank((CharSequence)joinRemarks)) {
                billInfoEo.setInvoiceRemarks(String.format("%s%s", str, joinRemarks));
            }
            billInfoEo.setFileUrl(((BillApplyEo)list.get(0)).getFileUrl());
        }
    }

    public void addBillOrderItem(List<DgPerformOrderLineDto> saleOrderItemExtRespDtoList, BillInfoEo billInfoEo, Map<String, ItemSkuDgDto> skuCodeMap, BillStrategyRespDto billStrategyRespDto) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(saleOrderItemExtRespDtoList)) {
            ArrayList billOrderItemEoList = new ArrayList();
            List platformOrderInfos = ((ExtQueryChainWrapper)this.iPerformOrderInfoDomain.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).list();
            saleOrderItemExtRespDtoList.forEach(itemDto -> {
                BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
                billOrderItemEo.setGift(itemDto.getGift());
                if (3 == itemDto.getGift()) {
                    billOrderItemEo.setGift(Integer.valueOf(0));
                    billOrderItemEo.setFreightCost(Integer.valueOf(1));
                }
                if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)platformOrderInfos)) {
                    PerformOrderInfoEo platformOrderInfo = (PerformOrderInfoEo)platformOrderInfos.get(0);
                    billOrderItemEo.setOrderType(platformOrderInfo.getOrderType());
                }
                billOrderItemEo.setItemId(itemDto.getSkuId());
                billOrderItemEo.setItemCode(itemDto.getSkuCode());
                billOrderItemEo.setItemName(itemDto.getSkuName());
                billOrderItemEo.setQuantity(itemDto.getItemNum());
                billOrderItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
                BigDecimal payAmount = itemDto.getRealPayAmount();
                BigDecimal refundedPayAmount = itemDto.getRefundedPayAmount();
                refundedPayAmount = refundedPayAmount.abs();
                BigDecimal amount = payAmount.subtract(refundedPayAmount);
                billOrderItemEo.setAmount(amount);
                billOrderItemEo.setClinchDealAmount(amount);
                billOrderItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
                if (skuCodeMap.containsKey(itemDto.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(itemDto.getSkuCode());
                    billOrderItemEo.setSpecification(itemSkuDgDto.getSpecModel());
                    this.assembleBillOrderItemInfo((DgPerformOrderLineDto)itemDto, itemSkuDgDto, billStrategyRespDto, billOrderItemEo);
                }
                billOrderItemEo.setUnitPrice(itemDto.getSalePrice());
                billOrderItemEo.setUnit(itemDto.getBasicUnit());
                billOrderItemEo.setOrderItemId(itemDto.getId());
                billOrderItemEo.setGroupItemName(itemDto.getGroupItemName());
                billOrderItemEo.setGroupSkuCode(itemDto.getGroupSkuCode());
                billOrderItemEo.setPlatformItemCode(itemDto.getPlatformItemCode());
                billOrderItemEo.setPlatformItemName(itemDto.getPlatformItemName());
                billOrderItemEo.setRefundedItemNum(itemDto.getRefundedItemNum());
                billOrderItemEo.setRefundedPayAmount(itemDto.getRefundedPayAmount());
                billOrderItemEo.setSurplusCanRefundPayAmount(itemDto.getSurplusCanRefundPayAmount());
                if (Objects.isNull(billOrderItemEo.getTaxClassificationCode())) {
                    billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
                }
                if (Objects.isNull(billOrderItemEo.getTaxRate())) {
                    billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate());
                }
                this.billInfoService.setSpecialRateBillOrderItem(billInfoEo, billOrderItemEo);
                billOrderItemEoList.add(billOrderItemEo);
            });
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billOrderItemEoList)) {
                this.billOrderItemDas.insertBatch(billOrderItemEoList);
            }
        }
    }

    public void assembleBillOrderItemInfo(DgPerformOrderLineDto performOrderItemDto, ItemSkuDgDto itemSkuDgDto, BillStrategyRespDto billStrategyRespDto, BillOrderItemEo billOrderItemEo) {
        if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
            ItemRateDgDto itemRateDgDto = itemSkuDgDto.getItemRateDgDto();
            if (Objects.nonNull(itemRateDgDto)) {
                billOrderItemEo.setTaxRate(itemRateDgDto.getRate());
                billOrderItemEo.setTaxClassificationCode(itemRateDgDto.getCode());
            }
            billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            }
        } else {
            if (null != billStrategyRespDto.getTaxRate()) {
                billOrderItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                billOrderItemEo.setTaxAmount(billOrderItemEo.getAmount().divide(billOrderItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billOrderItemEo.getTaxRate()).setScale(2, 4));
            }
            if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(performOrderItemDto.getSkuName());
            } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                billOrderItemEo.setBillLineItemName(itemSkuDgDto.getName());
            } else {
                String itemDisplayName = StringUtils.isBlank((CharSequence)billOrderItemEo.getItemName()) ? "" : billOrderItemEo.getItemName();
                billOrderItemEo.setBillLineItemName(itemDisplayName);
            }
            billOrderItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
        }
    }

    public void autoAuditCheck(BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto) {
        List collect;
        log.info("\u81ea\u52a8\u5ba1\u6838\u5f00\u59cb");
        BillEntityEo billEntityEo = new BillEntityEo();
        if (null != billInfoEo.getEntityId()) {
            billEntityEo = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billInfoEo.getEntityId())).one();
        }
        ArrayList<String> errorList = new ArrayList<String>();
        AtomicBoolean flag = new AtomicBoolean(true);
        ArrayList<String> billType = new ArrayList<String>();
        billType.add(BillInfoColourTypeEnum.RED_TICKET.getCode());
        billType.add(BillInfoColourTypeEnum.CANCEL_TICKET.getCode());
        List billInfoEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billInfoDas.filter().eq((Object)"platform_order_no", (Object)billInfoEo.getPlatformOrderNo())).in((Object)"bill_type", billType)).eq((Object)"all_red_flag", (Object)AllRedFlagEnum.YES_ALL_RED_FLAG.getCode())).list();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)billInfoEos) && org.apache.commons.collections.CollectionUtils.isNotEmpty(collect = billInfoEos.stream().filter(x -> x.getInvoiceState().equals(InvoiceStateEnum.WAIT_AUDIT.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.WAIT_BILL.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.INVOICING.getCode()) || x.getInvoiceState().equals(InvoiceStateEnum.FAILED.getCode())).collect(Collectors.toList()))) {
            errorList.add("\u5b58\u5728\u7ea2\u7968\u672a\u5f00\u7968\u6210\u529f\uff0c\u84dd\u7968\u65e0\u6cd5\u5ba1\u6838\u901a\u8fc7");
            flag.set(false);
        }
        log.info("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cnational_supplement:{}", (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
        if (SubsidiesTypeEnum.COUNTRY_SUBSIDIES.getCode().equals(billInfoEo.getSubsidiesType())) {
            log.info("\u62ac\u5934\u9ed1\u540d\u5355\u6821\u9a8cgetUseBlackList,getBlackListContent:{},{}", (Object)billInfoEo.getPlatformOrderNo(), (Object)JSONObject.toJSONString((Object)billStrategyRespDto));
            log.info("\u62ac\u5934billTitle,blackListContent:{},{}", (Object)billInfoEo.getBillTitle(), (Object)billStrategyRespDto.getBlackListContent());
            if (BillInfoColourTypeEnum.BLUE_TICKET.getCode().equals(billInfoEo.getBillType()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getUseBlackList()) && UseBlackListEnum.YES.getCode().equals(billStrategyRespDto.getUseBlackList()) && StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBlackListContent()) && (billInfoEo.getBillTitle().contains(billStrategyRespDto.getBlackListContent()) || billStrategyRespDto.getBlackListContent().contains(billInfoEo.getBillTitle()))) {
                errorList.add("\u547d\u4e2d\u56fd\u8865\u62ac\u5934\u9ed1\u540d\u5355");
                flag.set(false);
            }
        }
        if (BillInfoTypeEnum.ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.PAPER_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.SPECIAL_PAPER_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getPapSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getPapSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleComInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleComInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ALL_ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getAllEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getAllEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (BillInfoTypeEnum.ELECTRONIC_SPECIAL_INVOICE.getCode().equals(billInfoEo.getInvoiceType()) && null != billEntityEo.getEleSpeInvoiceLimit() && billInfoEo.getInvoiceAmount().compareTo(billEntityEo.getEleSpeInvoiceLimit()) > 0) {
            errorList.add("\u5f00\u7968\u91d1\u989d\u5927\u4e8e\u53d1\u7968\u9650\u989d");
            flag.set(false);
        }
        if (StringUtils.isNotBlank((CharSequence)billInfoEo.getBillPersonPhone()) && !billInfoEo.getBillPersonPhone().matches("1[0-9]\\d{9}")) {
            errorList.add("\u6536\u7968\u4eba\u7535\u8bdd\u53f7\u586b\u5199\u9519\u8bef");
            flag.set(false);
        }
        if (BigDecimal.ZERO.compareTo(billInfoEo.getInvoiceAmount()) >= 0) {
            errorList.add("\u53d1\u7968\u603b\u91d1\u989d\u4e3a\u96f6");
            flag.set(false);
        }
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(billItemEoList)) {
            billItemEoList.forEach(item -> {
                if (StringUtils.isEmpty((CharSequence)item.getTaxClassificationCode())) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (null == item.getTaxRate() || BigDecimal.ZERO.compareTo(item.getTaxRate()) == 0) {
                    errorList.add(String.format("\u5546\u54c1%s\u7a0e\u7387\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
                if (StringUtils.isBlank((CharSequence)item.getBillLineItemName())) {
                    errorList.add(String.format("\u5546\u54c1%s\u53d1\u7968\u884c\u9879\u76ee\u540d\u79f0\u4e3a\u7a7a", item.getItemCode()));
                    flag.set(false);
                }
            });
        } else {
            errorList.add("\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
            flag.set(false);
        }
        if (flag.get()) {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_BILL.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
        } else {
            billInfoEo.setInvoiceState(InvoiceStateEnum.WAIT_AUDIT.getCode());
            billInfoEo.setAuditTime(new Date());
            billInfoEo.setAuditPerson(this.context.userName());
            billInfoEo.setAuditFailReason(String.join((CharSequence)";", errorList));
        }
    }

    public void defaultBillRecord(SaleOrderBillRecordDto saleOrderBillRecordRespDto, BillStrategyRespDto billStrategyRespDto, BillInfoGenerateReqDto billInfoGenerateReqDto) {
        saleOrderBillRecordRespDto.setBillTitle("\u4e2a\u4eba");
        saleOrderBillRecordRespDto.setTitleType(BillTitleTypeEnum.PERSON.getCode());
        saleOrderBillRecordRespDto.setInvoiceType(BillInfoTypeEnum.ALL_ELECTRONIC_GENERAL_INVOICE.getCode());
        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getBillEntityCode())) {
            BillEntityEo billEntity = (BillEntityEo)((ExtQueryChainWrapper)this.billEntityDas.filter().eq((Object)"id", (Object)billStrategyRespDto.getBillEntityCode())).one();
            saleOrderBillRecordRespDto.setDistributorRegisteredAddress(billEntity.getRegisteredAddress());
            saleOrderBillRecordRespDto.setDistributorRegisteredPhone(billEntity.getRegisteredPhone());
            saleOrderBillRecordRespDto.setDistributorBank(billEntity.getBank());
            saleOrderBillRecordRespDto.setDistributorBankAccount(billEntity.getBankAccount());
            saleOrderBillRecordRespDto.setDistributorTaxesCode(billEntity.getTaxesCode());
            saleOrderBillRecordRespDto.setCollectPerson(billEntity.getCollectPerson());
            saleOrderBillRecordRespDto.setBillPerson(billEntity.getBillPerson());
            saleOrderBillRecordRespDto.setReviewPerson(billEntity.getReviewPerson());
        }
    }

    public void assembleFreightCostItem(BillStrategyRespDto billStrategyRespDto, List<DgPerformOrderLineDto> itemList, List<DgPerformOrderLineDto> zeroNumItemList) {
        ArrayList<String> skuCode = new ArrayList<String>();
        skuCode.add(billStrategyRespDto.getFreightCostItemCode());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
            ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
            DgPerformOrderLineDto performOrderItemDto = new DgPerformOrderLineDto();
            performOrderItemDto.setGift(Integer.valueOf(0));
            performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
            performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
            performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
            performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
            performOrderItemDto.setSkuId(itemSkuDgDto.getId());
            performOrderItemDto.setSkuName(itemSkuDgDto.getName());
            performOrderItemDto.setItemNum(BigDecimal.ONE);
            BigDecimal realPayAmount = zeroNumItemList.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = zeroNumItemList.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = realPayAmount.subtract(refundedPayAmount);
            performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
            performOrderItemDto.setSurplusCanRefundPayAmount(amount);
            performOrderItemDto.setSalePrice(amount);
            performOrderItemDto.setRealPayAmount(amount);
            performOrderItemDto.setPayAmount(amount);
            itemList.add(performOrderItemDto);
            log.info("\u8ba2\u5355\u6570\u91cf\u9000\u8d27\u5b8c\u6210\u91d1\u989d\u4e0d\u4e3a\u96f6\u5f00\u7968\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
        }
    }

    public void freightInvoice(List<DgPerformOrderLineDto> itemList, BillStrategyRespDto billStrategyRespDto, List<DgPerformOrderInfoEo> performOrderInfoDtoList) {
        if ("1".equals(billStrategyRespDto.getBillFreight())) {
            performOrderInfoDtoList.forEach(infoDto -> {
                if (Objects.nonNull(infoDto.getFreightCost()) && BigDecimal.ZERO.compareTo(infoDto.getFreightCost()) < 0) {
                    if (BillStrategyOrderPointEnum.DELIVER.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
                        log.info("\u53d1\u8d27\u8282\u70b9\u8fd0\u8d39\u5927\u4e8e\u96f6\u65b0\u589e\u8fd0\u8d39\u5f00\u7968");
                        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                            ArrayList<String> skuCode = new ArrayList<String>();
                            skuCode.add(billStrategyRespDto.getFreightCostItemCode());
                            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
                                ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
                                DgPerformOrderLineDto performOrderItemDto = new DgPerformOrderLineDto();
                                performOrderItemDto.setGift(Integer.valueOf(0));
                                performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
                                performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
                                performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
                                performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
                                performOrderItemDto.setSkuId(itemSkuDgDto.getId());
                                performOrderItemDto.setSkuName(itemSkuDgDto.getName());
                                performOrderItemDto.setItemNum(BigDecimal.ONE);
                                performOrderItemDto.setIsFreightCost(Integer.valueOf(1));
                                performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
                                performOrderItemDto.setSurplusCanRefundPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setSalePrice(infoDto.getFreightCost());
                                performOrderItemDto.setRealPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setCalcUnit(itemSkuDgDto.getPriceUnit());
                                performOrderItemDto.setSaleUnitName(itemSkuDgDto.getSaleUnitName());
                                itemList.add(performOrderItemDto);
                                log.info("\u53d1\u8d27\u8282\u70b9\u8fd0\u8d39\u751f\u6210\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
                            }
                        } else {
                            log.info("\u8fd0\u8d39\u9009\u62e9\u7684\u5f00\u7968\u5546\u54c1\u4e3a\u7a7a");
                        }
                    } else if (BillStrategyOrderPointEnum.COMPLETE.getCode().equals(billStrategyRespDto.getBillOrderPoint())) {
                        log.info("\u5b8c\u6210\u8282\u70b9\u8fd0\u8d39\u5927\u4e8e\u96f6\u65b0\u589e\u8fd0\u8d39\u5f00\u7968");
                        if (StringUtils.isNotBlank((CharSequence)billStrategyRespDto.getFreightCostItemCode())) {
                            ArrayList<String> skuCode = new ArrayList<String>();
                            skuCode.add(billStrategyRespDto.getFreightCostItemCode());
                            List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCode);
                            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(itemSkuDgDtoList)) {
                                ItemSkuDgDto itemSkuDgDto = itemSkuDgDtoList.get(0);
                                DgPerformOrderLineDto performOrderItemDto = new DgPerformOrderLineDto();
                                performOrderItemDto.setGift(Integer.valueOf(0));
                                performOrderItemDto.setItemId(itemSkuDgDto.getItemDgDto().getId());
                                performOrderItemDto.setItemCode(itemSkuDgDto.getItemDgDto().getCode());
                                performOrderItemDto.setItemName(itemSkuDgDto.getItemDgDto().getName());
                                performOrderItemDto.setSkuCode(itemSkuDgDto.getCode());
                                performOrderItemDto.setSkuId(itemSkuDgDto.getId());
                                performOrderItemDto.setSkuName(itemSkuDgDto.getName());
                                performOrderItemDto.setItemNum(BigDecimal.ONE);
                                performOrderItemDto.setIsFreightCost(Integer.valueOf(1));
                                performOrderItemDto.setRefundedPayAmount(BigDecimal.ZERO);
                                performOrderItemDto.setSurplusCanRefundPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setSalePrice(infoDto.getFreightCost());
                                performOrderItemDto.setRealPayAmount(infoDto.getFreightCost());
                                performOrderItemDto.setPayAmount(infoDto.getFreightCost());
                                itemList.add(performOrderItemDto);
                                log.info("\u5b8c\u6210\u8282\u70b9\u8fd0\u8d39\u751f\u6210\u5f00\u7968\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)performOrderItemDto));
                            }
                        } else {
                            log.info("\u8fd0\u8d39\u9009\u62e9\u7684\u5f00\u7968\u5546\u54c1\u4e3a\u7a7a");
                        }
                    }
                } else {
                    log.info("\u8ba2\u5355\u884c\u8fd0\u8d39\u4e3a\u7a7a\u6216\u8005\u4e0d\u5927\u4e8e0\u8fd0\u8d39\u4e0d\u9700\u8981\u5f00\u7968\uff1a{}", (Object)infoDto.getFreightCost());
                }
            });
        } else {
            log.info("\u6839\u636e\u7b56\u7565\u8fd0\u8d39\u4e0d\u9700\u8981\u5f00\u7968\uff1a{}", (Object)billStrategyRespDto.getBillFreight());
        }
    }

    public void filterItem(DgPerformOrderLineDto item, Map<String, BillStrategyNoInvoiceItemEo> itemEoMap, BillStrategyRespDto billStrategyRespDto, List<DgPerformOrderLineDto> itemList, List<DgPerformOrderLineDto> zeroNumItemList) {
        if (SaleItemStatusEnum.CANCEL.getCode().equals(item.getStatus())) {
            return;
        }
        if (itemEoMap.containsKey(item.getSkuCode())) {
            log.info("\u6839\u636e\u7b56\u7565\u8be5\u5546\u54c1\u662f\u4e0d\u5f00\u7968\u5546\u54c1:{}", (Object)item.getSkuCode());
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) == 0) {
            log.info("\u9500\u552e\u5355\u4ef7\u4e3a\u96f6\u8fc7\u6ee4\u4e0d\u5f00\u7968");
            return;
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) == 0 && BigDecimal.ZERO.compareTo(item.getSalePrice()) < 0) {
            item.setGift(Integer.valueOf(1));
        }
        if (BigDecimal.ZERO.compareTo(item.getRealPayAmount()) < 0) {
            item.setGift(Integer.valueOf(0));
        }
        if (Objects.isNull(item.getRefundedItemNum()) || BigDecimal.ZERO.compareTo(item.getRefundedItemNum()) == 0) {
            if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                    if ("1".equals(billStrategyRespDto.getBillGift())) {
                        itemList.add(item);
                    } else if (0 == item.getGift()) {
                        itemList.add(item);
                    }
                }
            } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                itemList.add(item);
            } else if (0 == item.getGift()) {
                itemList.add(item);
            }
        } else {
            BigDecimal num = item.getItemNum().subtract(item.getRefundedItemNum().abs());
            if (num.compareTo(BigDecimal.ZERO) > 0) {
                if (item.getRealPayAmount().compareTo(BigDecimal.ZERO) > 0) {
                    if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                        if ("1".equals(billStrategyRespDto.getBillGift())) {
                            item.setItemNum(num);
                            itemList.add(item);
                        } else if (0 == item.getGift()) {
                            item.setItemNum(num);
                            itemList.add(item);
                        }
                    }
                } else if ("1".equals(billStrategyRespDto.getBillGift())) {
                    item.setItemNum(num);
                    itemList.add(item);
                } else if (0 == item.getGift()) {
                    item.setItemNum(num);
                    itemList.add(item);
                }
            } else if (item.getRealPayAmount().subtract(item.getRefundedPayAmount().abs()).compareTo(BigDecimal.ZERO) > 0) {
                zeroNumItemList.add(item);
            }
        }
    }

    public BigDecimal whetherMergeItem(List<DgPerformOrderLineDto> whetherMergeItem, BillInfoEo billInfoEo, List<BillItemEo> billItemEoList, BillStrategyRespDto billStrategyRespDto) {
        log.info("\u7ec4\u5408\u5546\u54c1\u5408\u5e76:{}", (Object)JSON.toJSONString(whetherMergeItem));
        Map<String, List<DgPerformOrderLineDto>> listMap = whetherMergeItem.stream().collect(Collectors.groupingBy(DgPerformOrderLineDto::getGroupSkuCode));
        List<String> skuCodeList = whetherMergeItem.stream().map(DgPerformOrderLineDto::getSkuCode).distinct().collect(Collectors.toList());
        List<ItemSkuDgDto> itemSkuDgDtoList = this.itemDgService.queryItemInfoBySkuCode(skuCodeList);
        Map<String, ItemSkuDgDto> skuCodeMap = ((List)Optional.ofNullable(itemSkuDgDtoList).orElse(new ArrayList())).stream().collect(Collectors.toMap(ItemSkuDgDto::getCode, Function.identity(), (v1, v2) -> v2));
        AtomicReference<BigDecimal> number = new AtomicReference<BigDecimal>(BigDecimal.ZERO);
        listMap.forEach((k, v) -> {
            BillItemEo billItemEo = new BillItemEo();
            DgPerformOrderLineDto saleOrderItemExtRespDto = (DgPerformOrderLineDto)v.get(0);
            billItemEo.setGift(saleOrderItemExtRespDto.getGift());
            billItemEo.setItemId(saleOrderItemExtRespDto.getGroupItemId());
            billItemEo.setItemCode(saleOrderItemExtRespDto.getGroupSkuCode());
            billItemEo.setQuantity(v.stream().map(DgPerformOrderLineDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
            billItemEo.setBillFlowNo(billInfoEo.getBillFlowNo());
            BigDecimal payAmount = v.stream().map(info -> Objects.nonNull(info.getRealPayAmount()) ? info.getRealPayAmount().setScale(2, 4) : BigDecimal.ZERO).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal refundedPayAmount = v.stream().map(info -> info.getRefundedPayAmount().setScale(2, 4)).reduce(BigDecimal.ZERO, BigDecimal::add);
            refundedPayAmount = refundedPayAmount.abs();
            BigDecimal amount = payAmount.subtract(refundedPayAmount);
            billItemEo.setAmount(amount);
            billItemEo.setClinchDealAmount(amount);
            number.set(((BigDecimal)number.get()).add(amount));
            billItemEo.setPlatformOrderNo(billInfoEo.getPlatformOrderNo());
            ArrayList patentNameList = new ArrayList();
            ArrayList itemNameList = new ArrayList();
            AtomicReference<ItemRateDgDto> itemRateDgDto = new AtomicReference<ItemRateDgDto>(new ItemRateDgDto());
            v.forEach(item -> {
                if (skuCodeMap.containsKey(item.getSkuCode())) {
                    ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(item.getSkuCode());
                    patentNameList.add(itemSkuDgDto.getName());
                    itemNameList.add(itemSkuDgDto.getName());
                    if (null != itemSkuDgDto.getItemRateDgDto() && null != itemSkuDgDto.getItemRateDgDto().getId()) {
                        itemRateDgDto.set(itemSkuDgDto.getItemRateDgDto());
                    }
                }
            });
            String patentName = patentNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining(";"));
            String itemName = itemNameList.stream().filter(StringUtils::isNotBlank).distinct().collect(Collectors.joining("+"));
            billItemEo.setItemName(itemName);
            billItemEo.setItemShortName(saleOrderItemExtRespDto.getGroupItemName());
            billItemEo.setSpecification(saleOrderItemExtRespDto.getSkuDesc());
            billItemEo.setBillLineItemName(saleOrderItemExtRespDto.getSkuName());
            billItemEo.setUnit(saleOrderItemExtRespDto.getCalcUnit());
            billItemEo.setPatentName(patentName);
            ItemSkuDgDto itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
            billItemEo.setSpecification(itemSkuDgDto.getSpecModel());
            if (null != itemRateDgDto.get() && null != itemRateDgDto.get().getId()) {
                ItemRateDgDto itemRateDgEo = itemRateDgDto.get();
                billItemEo.setTaxRate(itemRateDgEo.getRate());
                billItemEo.setTaxClassificationCode(itemRateDgEo.getCode());
                billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                if ("type_commodity".equals(billStrategyRespDto.getBillRowName())) {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                    billItemEo.setBillLineItemName(itemDisplayName);
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    } else {
                        billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                    }
                }
            } else {
                if (null != billStrategyRespDto.getTaxRate()) {
                    billItemEo.setTaxRate(billStrategyRespDto.getTaxRate().divide(new BigDecimal(100), 2, RoundingMode.HALF_UP));
                    billItemEo.setTaxAmount(billItemEo.getAmount().divide(billItemEo.getTaxRate().add(new BigDecimal(1)), 2, RoundingMode.HALF_UP).multiply(billItemEo.getTaxRate()).setScale(2, 4));
                }
                if ("commodity".equals(billStrategyRespDto.getBillRowName())) {
                    billItemEo.setBillLineItemName(String.join((CharSequence)"+", itemNameList));
                } else if ("electronic_number".equals(billStrategyRespDto.getBillRowName())) {
                    if (skuCodeMap.containsKey(saleOrderItemExtRespDto.getSkuCode())) {
                        itemSkuDgDto = (ItemSkuDgDto)skuCodeMap.get(saleOrderItemExtRespDto.getSkuCode());
                        billItemEo.setBillLineItemName(itemSkuDgDto.getName());
                    }
                } else {
                    String itemDisplayName = StringUtils.isBlank((CharSequence)billItemEo.getItemName()) ? "" : billItemEo.getItemName();
                    billItemEo.setBillLineItemName(itemDisplayName);
                }
                billItemEo.setTaxClassificationCode(billStrategyRespDto.getTaxCode());
            }
            if (BigDecimalUtils.gtZero((BigDecimal)billItemEo.getAmount()).booleanValue() && BigDecimalUtils.gtZero((BigDecimal)billItemEo.getQuantity()).booleanValue()) {
                billItemEo.setUnitPrice(billItemEo.getAmount().divide(billItemEo.getQuantity(), 2, RoundingMode.HALF_UP));
            }
            billItemEo.setUnit(saleOrderItemExtRespDto.getCalcUnitDesc());
            billItemEoList.add(billItemEo);
        });
        this.addBillOrderItem(whetherMergeItem, billInfoEo, skuCodeMap, billStrategyRespDto);
        return number.get();
    }

    private /* synthetic */ void lambda$redOrderBillInfo$9(BillInfoEo billInfoEo, String finalOrderInvoiceStatus, BigDecimal finalInvoiceAmount, SaleOrderBillRecordDto order) {
        SaleOrderBillRecordReqProxyDto saleOrderBillRecordReqDto = new SaleOrderBillRecordReqProxyDto();
        saleOrderBillRecordReqDto.setId(order.getId());
        CubeBeanUtils.copyProperties((Object)saleOrderBillRecordReqDto, (Object)billInfoEo, (String[])new String[0]);
        saleOrderBillRecordReqDto.setWhetherInvoice(finalOrderInvoiceStatus);
        saleOrderBillRecordReqDto.setInvoiceAmount(finalInvoiceAmount);
        saleOrderBillRecordReqDto.setWhetherMergeBill(billInfoEo.getWhetherMergeBill());
        this.saleOrderBillRecordApiProxy.modifySaleOrderBillRecord(saleOrderBillRecordReqDto);
    }
}

