/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.util.JacksonUtil;
import com.yunxi.dg.base.center.finance.convert.entity.PlatformOrderIdentityConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IPlatformOrderIdentityDomain;
import com.yunxi.dg.base.center.finance.dto.entity.PlatformOrderIdentityDto;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.finance.eo.PlatformOrderIdentityEo;
import com.yunxi.dg.base.center.finance.service.entity.IPlatformOrderIdentityService;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PlatformOrderIdentityServiceImpl
extends BaseServiceImpl<PlatformOrderIdentityDto, PlatformOrderIdentityEo, IPlatformOrderIdentityDomain>
implements IPlatformOrderIdentityService {
    private static final Logger log = LoggerFactory.getLogger(PlatformOrderIdentityServiceImpl.class);
    @Resource
    private ILockService lockService;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain dgPerformOrderSnapshotDomain;

    public PlatformOrderIdentityServiceImpl(IPlatformOrderIdentityDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<PlatformOrderIdentityDto, PlatformOrderIdentityEo> converter() {
        return PlatformOrderIdentityConverter.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long insertOrUpdate(PlatformOrderIdentityDto dto) {
        log.info("\u65b0\u589e\u6216\u66f4\u65b0\u5e73\u53f0\u8ba2\u5355\u5b9e\u540d\u4fe1\u606f\uff1a{}", (Object)JacksonUtil.toJson((Object)dto));
        Mutex lock = null;
        try {
            lock = this.lockService.lock("platformOrderIdentity", dto.getPlatformOrderNo());
            PlatformOrderIdentityDto dbDto = this.getByPlatformOrderNo(dto.getPlatformOrderNo());
            List orderList = this.dgPerformOrderInfoDomain.queryListByPlatformOrderNo(dto.getPlatformOrderNo());
            if (dbDto == null) {
                PlatformOrderIdentityEo eo = (PlatformOrderIdentityEo)this.converter().toEo((BaseDto)dto);
                this.fillFromPerformOrderInfo(eo, orderList);
                ((IPlatformOrderIdentityDomain)this.domain).insert((BaseEo)eo);
                Long l = eo.getId();
                return l;
            }
            dto.setId(dbDto.getId());
            PlatformOrderIdentityEo eo = (PlatformOrderIdentityEo)this.converter().toEo((BaseDto)dto);
            this.fillFromPerformOrderInfo(eo, orderList);
            ((IPlatformOrderIdentityDomain)this.domain).updateSelective((BaseEo)eo);
            Long l = dbDto.getId();
            return l;
        }
        finally {
            if (lock != null) {
                this.lockService.unlock(lock);
            }
        }
    }

    private void fillFromPerformOrderInfo(PlatformOrderIdentityEo eo, List<DgPerformOrderInfoEo> orderList) {
        DgPerformOrderSnapshotEo snapshot;
        if (orderList == null || orderList.isEmpty()) {
            return;
        }
        List<String> notAllow = Arrays.asList(OmsSaleOrderStatus.CANCEL.getCode(), OmsSaleOrderStatus.OBSOLETE.getCode());
        DgPerformOrderInfoEo order = orderList.stream().filter(e -> !notAllow.contains(e.getOrderStatus())).max(Comparator.comparing(BaseEo::getCreateTime)).orElseThrow(RuntimeException::new);
        DgPerformOrderAddrEo addr = this.dgPerformOrderAddrDomain.getByOrderId(order.getId());
        if (addr != null && addr.getReceiveAddress().matches(".*[\\u4e00-\\u9fa5].*")) {
            String installationAddress = addr.getProvince() + addr.getCity() + addr.getCounty() + addr.getReceiveAddress().replace("\n", "");
            eo.setInstallationAddress(installationAddress);
            if (StringUtils.isBlank((CharSequence)eo.getAddressInfo())) {
                eo.setAddressInfo(eo.getInstallationAddress());
            }
        }
        if ((snapshot = this.dgPerformOrderSnapshotDomain.selectByOrderId(order.getId())) != null) {
            eo.setChannelCode(snapshot.getChannelCode());
            eo.setChannelName(snapshot.getChannelName());
        }
    }

    @Override
    public PlatformOrderIdentityDto getByPlatformOrderNo(String platformOrderNo) {
        PlatformOrderIdentityEo query = new PlatformOrderIdentityEo();
        query.setPlatformOrderNo(platformOrderNo);
        PlatformOrderIdentityEo eo = (PlatformOrderIdentityEo)((IPlatformOrderIdentityDomain)this.domain).selectOne((BaseEo)query);
        return (PlatformOrderIdentityDto)this.converter().toDto((BaseEo)eo);
    }
}

