/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.generate.impl;

import com.yunxi.dg.base.center.finance.dto.enums.GenerateCodeStrategyEnum;
import com.yunxi.dg.base.center.finance.service.generate.AbstractGenerateCodeService;
import com.yunxi.dg.base.center.finance.service.utils.DateUtils;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="CsCommonServiceImpl")
public class CommonGenerateCodeServiceImpl
extends AbstractGenerateCodeService {
    Logger logger = LoggerFactory.getLogger(CommonGenerateCodeServiceImpl.class);

    @Override
    public String getGenerateCodeStrategy() {
        return GenerateCodeStrategyEnum.COMMON.getCode();
    }

    @Override
    protected String lockKey() {
        String dateStr = DateUtils.formatDate(new Date(), "yyMMdd");
        String lockKey = this.getCodePrefix() + "_" + dateStr;
        this.logger.info("BillApplyGenerateCodeServiceImpl==>lockKey:{}", (Object)lockKey);
        return lockKey;
    }

    @Override
    protected String getCodePrefix() {
        return GenerateCodeStrategyEnum.COMMON.getCode();
    }

    @Override
    protected Long queryMaxCode() {
        return 0L;
    }

    @Override
    public String getCode(String prefixCode, String tableName) {
        return super.generateCode(prefixCode, tableName, this.lockKey());
    }
}

