/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.finance.convert.entity.BillEntityConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillEntityDas;
import com.yunxi.dg.base.center.finance.dao.mapper.BillEntityMapper;
import com.yunxi.dg.base.center.finance.domain.entity.IBillEntityDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillEntityDto;
import com.yunxi.dg.base.center.finance.dto.request.BillEntityReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillEntityRespDto;
import com.yunxi.dg.base.center.finance.eo.BillEntityEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillEntityService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillEntityServiceImpl
extends BaseServiceImpl<BillEntityDto, BillEntityEo, IBillEntityDomain>
implements IBillEntityService {
    @Resource
    private IBillEntityDas billEntityDas;
    @Resource
    private BillEntityMapper billEntityMapper;

    public BillEntityServiceImpl(IBillEntityDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillEntityDto, BillEntityEo> converter() {
        return BillEntityConverter.INSTANCE;
    }

    @Override
    public Long addBillEntity(BillEntityReqDto addReqDto) {
        BillEntityEo billEntityEo = new BillEntityEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billEntityEo);
        this.billEntityDas.insert((BaseEo)billEntityEo);
        return billEntityEo.getId();
    }

    @Override
    public void modifyBillEntity(BillEntityReqDto modifyReqDto) {
        BillEntityEo billEntityEo = new BillEntityEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billEntityEo);
        this.billEntityDas.updateSelective((BaseEo)billEntityEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillEntity(List<String> ids) {
        for (String id : ids) {
            this.billEntityDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillEntityRespDto queryById(Long id) {
        BillEntityEo billEntityEo = (BillEntityEo)this.billEntityDas.selectByPrimaryKey(id);
        BillEntityRespDto billEntityRespDto = new BillEntityRespDto();
        DtoHelper.eo2Dto((BaseEo)billEntityEo, (BaseVo)billEntityRespDto);
        return billEntityRespDto;
    }

    @Override
    public PageInfo<BillEntityRespDto> queryByPage(String filter, Integer pageNum, Integer pageSize) {
        BillEntityReqDto billEntityReqDto = (BillEntityReqDto)JSON.parseObject((String)filter, BillEntityReqDto.class);
        BillEntityEo billEntityEo = new BillEntityEo();
        DtoHelper.dto2Eo((BaseVo)billEntityReqDto, (BaseEo)billEntityEo);
        billEntityEo.setOrderByDesc("create_time");
        AssertUtil.isTrue(null != billEntityReqDto, "\u8bf7\u6c42\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isTrue(null != pageNum && pageNum > 0, "\u5206\u9875\u9875\u7801\u53c2\u6570\u6709\u8bef");
        AssertUtil.isTrue(null != pageSize && pageSize > 0, "\u5206\u9875\u5927\u5c0f\u53c2\u6570\u6709\u8bef");
        QueryWrapper queryWrapper = new QueryWrapper();
        String entityName = billEntityReqDto.getEntityName();
        String entityCode = billEntityReqDto.getEntityCode();
        if (StringUtils.isNotBlank((CharSequence)entityName)) {
            queryWrapper.like((Object)"entity_name", (Object)entityName);
        }
        if (StringUtils.isNotBlank((CharSequence)entityCode)) {
            queryWrapper.eq((Object)"entity_code", (Object)entityCode);
        }
        queryWrapper.eq((Object)"dr", (Object)0);
        queryWrapper.orderByDesc((Object)"create_time");
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List billEntityEos = this.billEntityMapper.selectList((Wrapper)queryWrapper);
        PageInfo eoPageInfo = new PageInfo(billEntityEos);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillEntityRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }
}

