/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.BillOrderItemConverter;
import com.yunxi.dg.base.center.finance.dao.das.IBillOrderItemDas;
import com.yunxi.dg.base.center.finance.dao.das.IKeepAccountsDetailDas;
import com.yunxi.dg.base.center.finance.dao.das.IPushKeepAccountsDas;
import com.yunxi.dg.base.center.finance.domain.entity.IBillOrderItemDomain;
import com.yunxi.dg.base.center.finance.dto.entity.BillOrderItemDto;
import com.yunxi.dg.base.center.finance.dto.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillOrderItemQueryDto;
import com.yunxi.dg.base.center.finance.dto.request.BillOrderItemReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillOrderItemRespDto;
import com.yunxi.dg.base.center.finance.eo.BillOrderItemEo;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillOrderItemService;
import com.yunxi.dg.base.center.finance.service.utils.AssertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BillOrderItemServiceImpl
extends BaseServiceImpl<BillOrderItemDto, BillOrderItemEo, IBillOrderItemDomain>
implements IBillOrderItemService {
    @Resource
    private IBillOrderItemDas billOrderItemDas;
    @Resource
    private IPushKeepAccountsDas pushKeepAccountsDas;
    @Resource
    private IKeepAccountsDetailDas keepAccountsDetailDas;

    public BillOrderItemServiceImpl(IBillOrderItemDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<BillOrderItemDto, BillOrderItemEo> converter() {
        return BillOrderItemConverter.INSTANCE;
    }

    @Override
    public Long addBillOrderItem(BillOrderItemReqDto addReqDto) {
        BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)addReqDto, (BaseEo)billOrderItemEo);
        this.billOrderItemDas.insert((BaseEo)billOrderItemEo);
        return billOrderItemEo.getId();
    }

    @Override
    public void modifyBillOrderItem(BillOrderItemReqDto modifyReqDto) {
        BillOrderItemEo billOrderItemEo = new BillOrderItemEo();
        DtoHelper.dto2Eo((BaseVo)modifyReqDto, (BaseEo)billOrderItemEo);
        this.billOrderItemDas.updateSelective((BaseEo)billOrderItemEo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeBillOrderItem(String ids, Long instanceId) {
        String[] removeIds;
        for (String id : removeIds = ids.split(",")) {
            this.billOrderItemDas.logicDeleteById(Long.valueOf(id));
        }
    }

    @Override
    public BillOrderItemRespDto queryById(Long id) {
        BillOrderItemEo billOrderItemEo = (BillOrderItemEo)this.billOrderItemDas.selectByPrimaryKey(id);
        BillOrderItemRespDto billOrderItemRespDto = new BillOrderItemRespDto();
        DtoHelper.eo2Dto((BaseEo)billOrderItemEo, (BaseVo)billOrderItemRespDto);
        return billOrderItemRespDto;
    }

    @Override
    public PageInfo<BillOrderItemRespDto> queryByPage(BillOrderItemQueryDto queryDto) {
        Integer pageNum = queryDto.getPageNum();
        Integer pageSize = queryDto.getPageSize();
        AssertUtil.isTrue(Objects.nonNull(pageNum) && pageNum > 0, "\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtil.isTrue(Objects.nonNull(pageSize) && pageSize > 0, "\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        ExtQueryChainWrapper<BillOrderItemEo> param = this.assembleCondition(queryDto);
        PageInfo eoPageInfo = param.page(pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        DtoHelper.eoList2DtoList((Collection)eoPageInfo.getList(), dtoList, BillOrderItemRespDto.class);
        List<String> platformOrderNos = dtoList.stream().map(BillOrderItemRespDto::getPlatformOrderNo).distinct().collect(Collectors.toList());
        List<String> itemCodes = dtoList.stream().map(BillOrderItemRespDto::getItemCode).distinct().collect(Collectors.toList());
        List<Long> orderItemIds = dtoList.stream().map(BillOrderItemRespDto::getOrderItemId).distinct().collect(Collectors.toList());
        List<KeepAccountsDetailEo> keepAccountsDetailEos = this.getFinanceReceivableList(platformOrderNos, itemCodes, orderItemIds);
        Map keepAccountsDetailEoMap = keepAccountsDetailEos.stream().collect(Collectors.toMap(x -> x.getPlatformNo() + ";" + x.getItemCode() + ";" + x.getOrderItemId(), Function.identity(), (k1, k2) -> k2));
        dtoList.forEach(v -> {
            String key = v.getPlatformOrderNo() + ";" + v.getItemCode() + ";" + v.getOrderItemId();
            if (keepAccountsDetailEoMap.containsKey(key)) {
                KeepAccountsDetailEo keepAccountsDetailEo = (KeepAccountsDetailEo)keepAccountsDetailEoMap.get(key);
                v.setFinanceReceivableNo(Objects.isNull(keepAccountsDetailEo) ? null : keepAccountsDetailEo.getGroupReceiveOrder());
            }
        });
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    public ExtQueryChainWrapper<BillOrderItemEo> assembleCondition(BillOrderItemQueryDto queryDto) {
        ExtQueryChainWrapper filter = this.billOrderItemDas.filter();
        if (StringUtils.isNotBlank((CharSequence)queryDto.getBillFlowNo())) {
            filter.eq((Object)"bill_flow_no", (Object)queryDto.getBillFlowNo());
        }
        filter.orderByDesc((Object)"id");
        return filter;
    }

    private List<KeepAccountsDetailEo> getFinanceReceivableList(List<String> platformOrderNos, List<String> itemCodes, List<Long> orderItemIds) {
        List accountsDetailEos;
        int length;
        if (CollectionUtil.isEmpty(orderItemIds)) {
            return Lists.newArrayList();
        }
        ArrayList keepAccountsDetailEos = Lists.newArrayList();
        int i = 0;
        for (length = orderItemIds.size(); length > 500; length -= 500) {
            accountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"platform_no", platformOrderNos)).in((Object)"item_code", itemCodes)).in((Object)"order_item_id", orderItemIds.subList(i, i + 500))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)"ACCOUNT_SUCCESS")).list();
            keepAccountsDetailEos.addAll(accountsDetailEos);
            i += 500;
        }
        if (length > 0) {
            accountsDetailEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.keepAccountsDetailDas.filter().in((Object)"platform_no", platformOrderNos)).in((Object)"item_code", itemCodes)).in((Object)"order_item_id", orderItemIds.subList(i, i + length))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)"ACCOUNT_SUCCESS")).list();
            keepAccountsDetailEos.addAll(accountsDetailEos);
        }
        return keepAccountsDetailEos;
    }

    private Map<String, String> getFinanceReceivableNo(List<String> platformOrderNos) {
        List accountsEos;
        int length;
        HashMap resultMap = Maps.newHashMap();
        if (CollectionUtil.isEmpty(platformOrderNos)) {
            return resultMap;
        }
        int i = 0;
        for (length = platformOrderNos.size(); length > 500; length -= 500) {
            accountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"platform_no", platformOrderNos.subList(i, i + 500))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)"ACCOUNT_SUCCESS")).list();
            if (CollectionUtil.isNotEmpty((Collection)accountsEos)) {
                accountsEos.forEach(v -> resultMap.put(v.getPlatformNo(), v.getGroupReceiveOrder()));
            }
            i += 500;
        }
        if (length > 0 && CollectionUtil.isNotEmpty((Collection)(accountsEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.pushKeepAccountsDas.filter().in((Object)"platform_no", platformOrderNos.subList(i, i + length))).eq((Object)"voucher_type", (Object)VoucherTypeEnum.INVOICE.getCode())).eq((Object)"accounting_result", (Object)"ACCOUNT_SUCCESS")).list()))) {
            accountsEos.forEach(v -> resultMap.put(v.getPlatformNo(), v.getGroupReceiveOrder()));
        }
        return resultMap;
    }
}

