/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.customer.domain.entity.IDgCsOrgCustomerRelationDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsCustomerAreaDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsRRelationShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IDgCustomerGroupDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.DgShopQueryReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.finance.dto.enums.DgCustomerBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.response.ShopRespDto;
import com.yunxi.dg.base.center.finance.eo.CsCustomerAreaEo;
import com.yunxi.dg.base.center.finance.eo.CsRRelationShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IDgOrgCustomerRelationService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DgOrgCustomerRelationServiceImpl
implements IDgOrgCustomerRelationService {
    @Resource
    private IDgCsOrgCustomerRelationDomain dgCsOrgCustomerRelationDomain;
    @Resource
    private ICsRRelationShopDomain dgCsRRelationShopDomain;
    @Resource
    private IShopDomain iDgShopDomain;
    @Resource
    private IDgCustomerGroupDomain iDgCustomerGroupDomain;
    @Resource
    private ICsCustomerAreaDomain iDgCustomerAreaDomain;

    @Override
    public List<CsOrgCustomerRelationDto> queryTobCustomerRelationPage(CsOrgCustomerRelationPageReqDto reqDto) {
        List<Integer> businessType = Arrays.asList(DgCustomerBusinessTypeEnum.TYPE_CTJX.getType());
        List relationDtoList = this.dgCsOrgCustomerRelationDomain.queryList(reqDto, businessType);
        if (CollectionUtils.isEmpty((Collection)relationDtoList)) {
            return Lists.newArrayList();
        }
        this.setRRelationDepartmentAndSalesman(relationDtoList);
        return relationDtoList;
    }

    private void setRRelationDepartmentAndSalesman(List<CsOrgCustomerRelationDto> list) {
        List relationIds = list.stream().map(CsOrgCustomerRelationDto::getId).distinct().collect(Collectors.toList());
        List customerIdList = list.stream().map(CsOrgCustomerRelationDto::getCustomerId).distinct().collect(Collectors.toList());
        List groupIdList = list.stream().map(CsOrgCustomerRelationDto::getCustomerGroupId).distinct().collect(Collectors.toList());
        List rRelationShopEos = ((ExtQueryChainWrapper)this.dgCsRRelationShopDomain.filter().in((Object)"relation_id", relationIds)).list();
        Map<Long, List<CsRRelationShopEo>> rRelationShopEoMap = rRelationShopEos.stream().collect(Collectors.groupingBy(CsRRelationShopEo::getRelationId));
        DgShopQueryReqDto queryReqDto = new DgShopQueryReqDto();
        queryReqDto.setIdList(rRelationShopEos.stream().map(CsRRelationShopEo::getShopId).collect(Collectors.toList()));
        List shopEos = ((ExtQueryChainWrapper)this.iDgShopDomain.filter().in((Object)"id", (Collection)queryReqDto.getIdList())).list();
        Map<Object, Object> dgShopRespDtoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)shopEos)) {
            ArrayList shopRespDtos = Lists.newArrayList();
            CubeBeanUtils.copyCollection((Collection)shopRespDtos, (Collection)shopEos, ShopRespDto.class);
            dgShopRespDtoMap = shopRespDtos.stream().collect(Collectors.toMap(ShopRespDto::getId, Function.identity()));
        }
        Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.mapAreaLevel(list.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
        HashMap<Long, String> groupMap = new HashMap<Long, String>();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isNotEmpty(groupIdList)) {
            List customerGroupEos = ((ExtQueryChainWrapper)this.iDgCustomerGroupDomain.filter().in((Object)"id", groupIdList)).list();
            groupMap.putAll(customerGroupEos.stream().collect(Collectors.toMap(BaseEo::getId, o -> o.getGroupName(), (k1, k2) -> k1)));
        }
        Map<Object, Object> finalDgShopRespDtoMap = dgShopRespDtoMap;
        list.forEach(o -> {
            List relationShopEos = Optional.ofNullable(rRelationShopEoMap.get(o.getId())).orElse(new ArrayList());
            o.setShopIdList(relationShopEos.stream().map(CsRRelationShopEo::getShopId).collect(Collectors.toList()));
            o.setShopList(relationShopEos.stream().map(e -> {
                ShopRespDto shopRespDto = (ShopRespDto)finalDgShopRespDtoMap.get(e.getShopId());
                CsRRelationShopDto shopDto = new CsRRelationShopDto();
                if (Objects.isNull(shopRespDto)) {
                    return shopDto;
                }
                shopDto.setShopId(shopRespDto.getId());
                shopDto.setShopCode(shopRespDto.getCode());
                shopDto.setShopName(shopRespDto.getName());
                return shopDto;
            }).collect(Collectors.toList()));
            o.setCustomerTypeId(com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)relationShopEos) ? null : ((CsRRelationShopEo)relationShopEos.get(0)).getCustomerTypeId());
            o.setBusinessAreaLevelList(Objects.isNull(o.getAreaId()) ? null : (List)areaLevelMap.get(o.getAreaId()));
            o.setCustomerGroupName(Objects.isNull(o.getCustomerGroupId()) ? null : (String)groupMap.get(o.getCustomerGroupId()));
        });
    }

    public Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel(List<Long> areaIdList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        List respDtoList = ((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", areaIdList)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = respDtoList.stream().filter(dto -> Objects.nonNull(dto.getIndexPath())).map(dto -> Arrays.stream(dto.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, List> indexPathIdsMap = respDtoList.stream().collect(Collectors.toMap(BaseEo::getId, o -> Arrays.stream(o.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList()), (k1, k2) -> k1));
        List customerAreaEos = ((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", indexPathIdList)).list();
        Map<Object, Object> indexPathEoMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)customerAreaEos)) {
            indexPathEoMap = customerAreaEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        }
        HashMap<Long, List<DgBusinessAreaLevelDto>> resultMap = new HashMap<Long, List<DgBusinessAreaLevelDto>>();
        for (Long areaId : areaIdList) {
            List indexPathIds = indexPathIdsMap.get(areaId);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)indexPathIds)) continue;
            ArrayList<DgBusinessAreaLevelDto> levelDtoList = new ArrayList<DgBusinessAreaLevelDto>();
            for (Long indexPathId : indexPathIds) {
                if (Objects.equals(indexPathId, 0L)) continue;
                CsCustomerAreaEo customerAreaEo = (CsCustomerAreaEo)indexPathEoMap.get(indexPathId);
                DgBusinessAreaLevelDto levelDto = (DgBusinessAreaLevelDto)BeanUtil.toBean((Object)customerAreaEo, DgBusinessAreaLevelDto.class);
                levelDtoList.add(levelDto);
            }
            resultMap.put(areaId, levelDtoList);
        }
        return resultMap;
    }
}

