/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.finance.convert.entity.KeepAccountsNodeConfigConverter;
import com.yunxi.dg.base.center.finance.domain.entity.IKeepAccountsNodeConfigDomain;
import com.yunxi.dg.base.center.finance.dto.entity.KeepAccountsNodeConfigDto;
import com.yunxi.dg.base.center.finance.eo.KeepAccountsNodeConfigEo;
import com.yunxi.dg.base.center.finance.service.entity.IKeepAccountsNodeConfigService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.BeanCopyUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepAccountsNodeConfigServiceImpl
extends BaseServiceImpl<KeepAccountsNodeConfigDto, KeepAccountsNodeConfigEo, IKeepAccountsNodeConfigDomain>
implements IKeepAccountsNodeConfigService {
    private static final Logger logger = LoggerFactory.getLogger(KeepAccountsNodeConfigServiceImpl.class);

    public KeepAccountsNodeConfigServiceImpl(IKeepAccountsNodeConfigDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepAccountsNodeConfigDto, KeepAccountsNodeConfigEo> converter() {
        return KeepAccountsNodeConfigConverter.INSTANCE;
    }

    public RestResponse<Long> insert(KeepAccountsNodeConfigDto dto) {
        logger.info("\u8bb0\u8d26\u65f6\u95f4\u8282\u70b9\u914d\u7f6einsert\uff1a{}", (Object)JSON.toJSONString((Object)dto));
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getOrderType()), (String)"\u5355\u636e\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List configEoList = ((ExtQueryChainWrapper)((IKeepAccountsNodeConfigDomain)this.domain).filter().eq((Object)"order_type", (Object)dto.getOrderType())).list();
        AssertUtils.isFalse((boolean)CollectionUtil.isNotEmpty((Collection)configEoList), (String)"\u5355\u636e\u7c7b\u578b\u5df2\u5b58\u5728");
        return super.insert((BaseDto)dto);
    }

    public RestResponse<Integer> update(KeepAccountsNodeConfigDto dto) {
        AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)dto.getId()), (String)"-1", (String)"\u8bf7\u6c42id\u4e0d\u80fd\u4e3a\u7a7a");
        dto.setOrderType(null);
        return super.update((BaseDto)dto);
    }

    @Override
    public KeepAccountsNodeConfigDto getByOrderType(String orderType) {
        logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578b\u83b7\u53d6\u914d\u7f6e\uff1a{}", (Object)orderType);
        List configEoList = ((ExtQueryChainWrapper)((IKeepAccountsNodeConfigDomain)this.domain).filter().eq((Object)"order_type", (Object)orderType)).list();
        if (CollectionUtil.isNotEmpty((Collection)configEoList)) {
            return (KeepAccountsNodeConfigDto)BeanCopyUtil.copy(configEoList.get(0), KeepAccountsNodeConfigDto.class);
        }
        return null;
    }

    @Override
    public Map<String, KeepAccountsNodeConfigDto> getMapConfig() {
        List configEoList = ((IKeepAccountsNodeConfigDomain)this.domain).filter().list();
        return Optional.ofNullable(configEoList).map(m -> {
            List configDtoList = BeanCopyUtil.copyPropertiesForList((List)m, KeepAccountsNodeConfigDto.class);
            return configDtoList.stream().collect(Collectors.toMap(KeepAccountsNodeConfigDto::getOrderType, Function.identity(), (o1, o2) -> o1));
        }).orElse(new HashMap());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void fullUpdate(List<KeepAccountsNodeConfigDto> dtoList) {
        logger.info("\u5168\u91cf\u66f4\u65b0\uff1a{}", (Object)JSON.toJSONString(dtoList));
        dtoList.forEach(dto -> {
            dto.setId(null);
            AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)dto.getOrderType()), (String)"\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        });
        Map<String, List<KeepAccountsNodeConfigDto>> collect = dtoList.stream().collect(Collectors.groupingBy(KeepAccountsNodeConfigDto::getOrderType));
        collect.forEach((k, v) -> AssertUtils.isFalse((v.size() > 1 ? 1 : 0) != 0, (String)("\u5355\u636e\u7c7b\u578b\u91cd\u590d\uff1a" + k)));
        KeepAccountsNodeConfigEo deleteEo = new KeepAccountsNodeConfigEo();
        deleteEo.setDr(0);
        ((IKeepAccountsNodeConfigDomain)this.domain).logicDelete((BaseEo)deleteEo);
        super.insertBatch(dtoList);
    }
}

