/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.finance.convert.entity.ReconciliationOrderDetailConverter;
import com.yunxi.dg.base.center.finance.domain.entity.ICsCustomerAreaDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICsRRelationShopDomain;
import com.yunxi.dg.base.center.finance.domain.entity.ICustomerDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationAccountRangeDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDetailDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IReconciliationOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IShopDomain;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsOrgCustomerRelationPageReqDto;
import com.yunxi.dg.base.center.finance.dto.entity.CsRRelationShopDto;
import com.yunxi.dg.base.center.finance.dto.entity.DgBusinessAreaLevelDto;
import com.yunxi.dg.base.center.finance.dto.entity.DynamicHeadDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationAccountRangeDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationBillDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationDetailDynamicHeadDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderDetailDto;
import com.yunxi.dg.base.center.finance.dto.entity.ReconciliationOrderDetailPageReqDto;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillStatusEnum;
import com.yunxi.dg.base.center.finance.dto.enums.ReconciliationBillTypeEnum;
import com.yunxi.dg.base.center.finance.eo.CsCustomerAreaEo;
import com.yunxi.dg.base.center.finance.eo.CsRRelationShopEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationBillDetailEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderDetailEo;
import com.yunxi.dg.base.center.finance.eo.ReconciliationOrderEo;
import com.yunxi.dg.base.center.finance.eo.ShopEo;
import com.yunxi.dg.base.center.finance.service.entity.IReconciliationOrderDetailService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ReconciliationOrderDetailServiceImpl
extends BaseServiceImpl<ReconciliationOrderDetailDto, ReconciliationOrderDetailEo, IReconciliationOrderDetailDomain>
implements IReconciliationOrderDetailService {
    private static final Logger log = LoggerFactory.getLogger(ReconciliationOrderDetailServiceImpl.class);
    @Resource
    private IShopDomain shopDomain;
    @Resource
    private ICustomerDomain customerDomain;
    @Resource
    private ICsCustomerAreaDomain iDgCustomerAreaDomain;
    @Resource
    private IReconciliationOrderDomain orderDomain;
    @Resource
    private ICsRRelationShopDomain relationShopDomain;
    @Resource
    private IReconciliationAccountRangeDomain accountRangeDomain;

    public ReconciliationOrderDetailServiceImpl(IReconciliationOrderDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<ReconciliationOrderDetailDto, ReconciliationOrderDetailEo> converter() {
        return ReconciliationOrderDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<Map<String, Integer>> queryCount(ReconciliationOrderDetailPageReqDto dto) {
        List orderDetailEos = ((IReconciliationOrderDetailDomain)this.domain).queryList(dto);
        Map<String, List<ReconciliationBillDetailEo>> collect = orderDetailEos.stream().collect(Collectors.groupingBy(ReconciliationBillDetailEo::getStatus));
        HashMap resultMap = Maps.newHashMap();
        resultMap.put(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_AUDIT.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_PUBLISH.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode(), null != collect.get(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode()) ? collect.get(ReconciliationBillStatusEnum.WAIT_CONFIRM.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.COMPLETE.getCode(), null != collect.get(ReconciliationBillStatusEnum.COMPLETE.getCode()) ? collect.get(ReconciliationBillStatusEnum.COMPLETE.getCode()).size() : 0);
        resultMap.put(ReconciliationBillStatusEnum.CLOSE.getCode(), null != collect.get(ReconciliationBillStatusEnum.CLOSE.getCode()) ? collect.get(ReconciliationBillStatusEnum.CLOSE.getCode()).size() : 0);
        return new RestResponse((Object)resultMap);
    }

    @Override
    public RestResponse<PageInfo<ReconciliationBillDetailDto>> queryPage(ReconciliationOrderDetailPageReqDto dto) {
        log.info("\u5bf9\u8d26\u5355\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)dto));
        Integer pageNum = dto.getPageNum();
        Integer pageSize = dto.getPageSize();
        AssertUtils.isTrue((Objects.nonNull(pageNum) && pageNum > 0 ? 1 : 0) != 0, (String)"\u9875\u7801\u53c2\u6570\u4e0d\u5408\u6cd5");
        AssertUtils.isTrue((Objects.nonNull(pageSize) && pageSize > 0 ? 1 : 0) != 0, (String)"\u6bcf\u9875\u6761\u6570\u4e0d\u5408\u6cd5");
        if (StringUtils.isNotBlank((CharSequence)dto.getCreateStartTime())) {
            dto.setCreateStartTime(dto.getCreateStartTime() + " 00:00:00");
        }
        if (StringUtils.isNotBlank((CharSequence)dto.getCreateEndTime())) {
            dto.setCreateEndTime(dto.getCreateEndTime() + " 23:59:59");
        }
        PageInfo eoPageInfo = ((IReconciliationOrderDetailDomain)this.domain).queryPage(dto);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        if (Objects.nonNull(eoPageInfo) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            ArrayList<ReconciliationBillDetailDto> dtoList = new ArrayList<ReconciliationBillDetailDto>();
            CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), ReconciliationBillDetailDto.class);
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(dtoList)) {
                this.setArea(dtoList);
            }
            dtoPageInfo.setList(dtoList);
            this.handleMergeAccountType(dtoList);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    private void setArea(List<ReconciliationBillDetailDto> list) {
        List orderNos = list.stream().map(ReconciliationBillDetailDto::getOrderNo).distinct().collect(Collectors.toList());
        List orderEoList = ((ExtQueryChainWrapper)this.orderDomain.filter().in((Object)"order_no", orderNos)).list();
        Map orderEoMap = orderEoList.stream().collect(Collectors.toMap(ReconciliationOrderEo::getOrderNo, Function.identity(), (k1, k2) -> k1));
        List accountRangeEos = this.accountRangeDomain.getAccountRange();
        Map<Object, Object> collectRanggeMap = Maps.newHashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountRangeEos)) {
            collectRanggeMap = accountRangeEos.stream().collect(Collectors.toMap(x -> x.getAccountType() + ";" + x.getSaleCompanyCode(), Function.identity(), (k1, k2) -> k1));
        }
        List orderNoList = list.stream().map(ReconciliationBillDetailDto::getOrderNo).distinct().collect(Collectors.toList());
        List customerCodeList = list.stream().map(ReconciliationBillDetailDto::getCustomerCode).distinct().collect(Collectors.toList());
        List shopCodeList = list.stream().map(ReconciliationBillDetailDto::getShopCode).distinct().collect(Collectors.toList());
        List accountTypeList = list.stream().map(e -> Arrays.stream(StrUtil.splitToArray((CharSequence)e.getAccountType(), (CharSequence)",")).collect(Collectors.toList())).flatMap(Collection::stream).collect(Collectors.toList());
        Map<Object, Object> rangeEoMap = Maps.newHashMap();
        ReconciliationAccountRangeDto rangeDto = new ReconciliationAccountRangeDto();
        rangeDto.setOrderNoList(orderNoList);
        rangeDto.setCustomerCodeList(customerCodeList);
        rangeDto.setShopCodeList(shopCodeList);
        rangeDto.setAccountTypeList(accountTypeList);
        List accountRangeEoList = this.accountRangeDomain.getAccountRangeNewList(rangeDto);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)accountRangeEoList)) {
            rangeEoMap = accountRangeEoList.stream().collect(Collectors.toMap(x -> x.getOrderNo() + ";" + x.getAccountType() + ";" + x.getCustomerCode() + ";" + x.getShopCode() + ";" + x.getRelevanceNo() + ";" + x.getSaleCompanyCode(), Function.identity(), (k1, k2) -> {
                k1.setAmount(k1.getAmount().add(k2.getAmount()));
                return k1;
            }));
        }
        Map<Object, Object> finalCollectRanggeMap = collectRanggeMap;
        HashMap finalRangeEoMap = rangeEoMap;
        list.forEach(v -> {
            List shopIdList = null;
            List customerIdList = null;
            List shopCodes = list.stream().map(ReconciliationBillDetailDto::getShopCode).distinct().collect(Collectors.toList());
            List customerCodes = list.stream().map(ReconciliationBillDetailDto::getCustomerCode).distinct().collect(Collectors.toList());
            List shopEos = ((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"code", shopCodes)).list();
            List customerEos = ((ExtQueryChainWrapper)this.customerDomain.filter().in((Object)"code", customerCodes)).list();
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)shopEos)) {
                shopIdList = shopEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)customerEos)) {
                customerIdList = customerEos.stream().map(BaseEo::getId).collect(Collectors.toList());
            }
            CsOrgCustomerRelationPageReqDto pageReqDto = new CsOrgCustomerRelationPageReqDto();
            pageReqDto.setShopIdList(shopIdList);
            pageReqDto.setCustomerIdList(customerIdList);
            List customerRelationDtos = this.orderDomain.queryList(pageReqDto);
            Map<Long, List<DgBusinessAreaLevelDto>> areaLevelMap = this.mapAreaLevel(customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getAreaId).collect(Collectors.toList()));
            List relationIds = customerRelationDtos.stream().map(CsOrgCustomerRelationDto::getId).distinct().collect(Collectors.toList());
            List rRelationShopEos = ((ExtQueryChainWrapper)this.relationShopDomain.filter().in((Object)"relation_id", relationIds)).list();
            List shopIds = rRelationShopEos.stream().map(CsRRelationShopEo::getShopId).distinct().collect(Collectors.toList());
            Map shopEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.shopDomain.filter().in((Object)"id", shopIds)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
            customerRelationDtos.forEach(o -> {
                o.setShopList(rRelationShopEos.stream().map(e -> {
                    ShopEo shopEo = (ShopEo)shopEoMap.get(e.getShopId());
                    CsRRelationShopDto shopDto = new CsRRelationShopDto();
                    if (Objects.isNull(shopEo)) {
                        return shopDto;
                    }
                    shopDto.setShopId(e.getShopId());
                    shopDto.setShopCode(shopEo.getCode());
                    shopDto.setShopName(shopEo.getName());
                    return shopDto;
                }).collect(Collectors.toList()));
                o.setBusinessAreaLevelList(Objects.isNull(o.getAreaId()) ? null : (List)areaLevelMap.get(o.getAreaId()));
            });
            if (orderEoMap.containsKey(v.getOrderNo())) {
                ReconciliationOrderEo reconciliationOrderEo = (ReconciliationOrderEo)orderEoMap.get(v.getOrderNo());
                v.setBillDate(reconciliationOrderEo.getBillDate());
                v.setStatus(reconciliationOrderEo.getStatus());
            }
            v.setOrderTypeName(ReconciliationBillTypeEnum.getName((String)v.getOrderType()));
            v.setBusinessAreaLevelList(((CsOrgCustomerRelationDto)customerRelationDtos.get(0)).getBusinessAreaLevelList());
            ArrayList dynamicHeadDtos = Lists.newArrayList();
            if (!CollectionUtils.isEmpty((Map)finalCollectRanggeMap)) {
                finalCollectRanggeMap.forEach((i, j) -> {
                    List<String> accountType = Arrays.asList(i.split(";"));
                    DynamicHeadDto headDto = new DynamicHeadDto();
                    headDto.setAccountType(accountType.get(0));
                    headDto.setAccountTypeName(j.getAccountTypeName());
                    ReconciliationAccountRangeDto accountRangeDto = new ReconciliationAccountRangeDto();
                    accountRangeDto.setAccountType(accountType.get(0));
                    accountRangeDto.setAccountTypeName(j.getAccountTypeName());
                    accountRangeDto.setOrderNo(v.getOrderNo());
                    accountRangeDto.setShopCode(v.getShopCode());
                    accountRangeDto.setCustomerCode(v.getCustomerCode());
                    accountRangeDto.setRelevanceNo(v.getRelevanceNo());
                    String key = v.getOrderNo() + ";" + accountType.get(0) + ";" + v.getCustomerCode() + ";" + v.getShopCode() + ";" + v.getRelevanceNo() + ";" + accountType.get(1);
                    if (finalRangeEoMap.containsKey(key)) {
                        ReconciliationAccountRangeDto reconciliationAccountRangeDto = (ReconciliationAccountRangeDto)finalRangeEoMap.get(key);
                        accountRangeDto.setAmount(reconciliationAccountRangeDto.getAmount());
                        accountRangeDto.setAmountBusinessType(reconciliationAccountRangeDto.getAmountBusinessType());
                        accountRangeDto.setSaleCompanyCode(reconciliationAccountRangeDto.getSaleCompanyCode());
                        accountRangeDto.setSaleCompanyName(reconciliationAccountRangeDto.getSaleCompanyName());
                        accountRangeDto.setShopCode(reconciliationAccountRangeDto.getShopCode());
                    }
                    headDto.setAccountRangeDto(accountRangeDto);
                    dynamicHeadDtos.add(headDto);
                });
            }
            v.setHeadDtos((List)dynamicHeadDtos);
            Map<String, List<DynamicHeadDto>> dynamicBillDetailMap = dynamicHeadDtos.stream().collect(Collectors.groupingBy(DynamicHeadDto::getAccountType));
            ArrayList detailDynamicHeadDtos = Lists.newArrayList();
            dynamicBillDetailMap.forEach((m, n) -> {
                ReconciliationDetailDynamicHeadDto detailDynamicHeadDto = new ReconciliationDetailDynamicHeadDto();
                detailDynamicHeadDto.setAccountType(m);
                detailDynamicHeadDto.setAccountTypeName(((DynamicHeadDto)n.get(0)).getAccountTypeName());
                BigDecimal totalAmount = null;
                for (DynamicHeadDto k : n) {
                    BigDecimal amount = k.getAccountRangeDto().getAmount();
                    if (null == amount) continue;
                    totalAmount = totalAmount == null ? BigDecimal.ZERO : totalAmount;
                    totalAmount = totalAmount.add(amount);
                }
                detailDynamicHeadDto.setTotalAmount(null != totalAmount ? totalAmount : null);
                detailDynamicHeadDto.setAmount(null != totalAmount ? totalAmount : null);
                detailDynamicHeadDtos.add(detailDynamicHeadDto);
            });
            v.setDetailDynamicHeadDtos((List)detailDynamicHeadDtos);
        });
    }

    public Map<Long, List<DgBusinessAreaLevelDto>> mapAreaLevel(List<Long> areaIdList) {
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty(areaIdList)) {
            return Collections.emptyMap();
        }
        List respDtoList = ((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", areaIdList)).list();
        if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)respDtoList)) {
            return Collections.emptyMap();
        }
        List indexPathIdList = respDtoList.stream().filter(dto -> Objects.nonNull(dto.getIndexPath())).map(dto -> Arrays.stream(dto.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList())).flatMap(Collection::stream).distinct().collect(Collectors.toList());
        Map<Long, List> indexPathIdsMap = respDtoList.stream().collect(Collectors.toMap(BaseEo::getId, o -> Arrays.stream(o.getIndexPath().split(",")).map(Long::valueOf).collect(Collectors.toList()), (k1, k2) -> k1));
        Map indexPathEoMap = ((List)Optional.ofNullable(((ExtQueryChainWrapper)this.iDgCustomerAreaDomain.filter().in((Object)"id", indexPathIdList)).list()).orElse(new ArrayList())).stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (k1, k2) -> k1));
        HashMap<Long, List<DgBusinessAreaLevelDto>> resultMap = new HashMap<Long, List<DgBusinessAreaLevelDto>>();
        for (Long areaId : areaIdList) {
            List indexPathIds = indexPathIdsMap.get(areaId);
            if (com.baomidou.mybatisplus.core.toolkit.CollectionUtils.isEmpty((Collection)indexPathIds)) continue;
            ArrayList<DgBusinessAreaLevelDto> levelDtoList = new ArrayList<DgBusinessAreaLevelDto>();
            for (Long indexPathId : indexPathIds) {
                if (Objects.equals(indexPathId, 0L)) continue;
                CsCustomerAreaEo customerAreaEo = (CsCustomerAreaEo)indexPathEoMap.get(indexPathId);
                DgBusinessAreaLevelDto levelDto = (DgBusinessAreaLevelDto)BeanUtil.toBean((Object)customerAreaEo, DgBusinessAreaLevelDto.class);
                levelDtoList.add(levelDto);
            }
            resultMap.put(areaId, levelDtoList);
        }
        return resultMap;
    }

    private void handleMergeAccountType(List<ReconciliationBillDetailDto> dtoList) {
        for (ReconciliationBillDetailDto detailDto : dtoList) {
            detailDto.setSaleCompanyName(detailDto.getHeadDtos().stream().filter(e -> Objects.nonNull(e.getAccountRangeDto()) && StrUtil.isNotBlank((CharSequence)e.getAccountRangeDto().getSaleCompanyName())).map(e -> e.getAccountRangeDto().getSaleCompanyName()).distinct().collect(Collectors.joining(",")));
            detailDto.setSaleCompanyCode(detailDto.getHeadDtos().stream().filter(e -> Objects.nonNull(e.getAccountRangeDto()) && StrUtil.isNotBlank((CharSequence)e.getAccountRangeDto().getSaleCompanyCode())).map(e -> e.getAccountRangeDto().getSaleCompanyCode()).distinct().collect(Collectors.joining(",")));
            Map headDtoMap = detailDto.getHeadDtos().stream().collect(Collectors.toMap(DynamicHeadDto::getAccountType, Function.identity(), (v1, v2) -> {
                BigDecimal v1Amount = v1.getAccountRangeDto().getAmount();
                BigDecimal v2Amount = v2.getAccountRangeDto().getAmount();
                if (v1Amount == null && v2Amount == null) {
                    return v1;
                }
                v1Amount = v1Amount == null ? BigDecimal.ZERO : v1Amount;
                v2Amount = v2Amount == null ? BigDecimal.ZERO : v2Amount;
                v1.getAccountRangeDto().setAmount(v1Amount.add(v2Amount));
                return v1;
            }));
            List<DynamicHeadDto> headDtos = headDtoMap.values().stream().collect(Collectors.toList());
            this.handleDynamicHeadAmount(headDtos);
            detailDto.setHeadDtos(headDtos);
        }
    }

    private void handleDynamicHeadAmount(List<DynamicHeadDto> headDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(headDtos)) {
            headDtos.forEach(v -> {
                v.setAmount(null != v.getAccountRangeDto() ? v.getAccountRangeDto().getAmount() : null);
                if (null != v.getAccountRangeDto() && "disburse".equals(v.getAccountRangeDto().getAmountBusinessType())) {
                    v.setAmount(v.getAccountRangeDto().getAmount().negate());
                }
            });
        }
    }
}

