/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.huieryun.log.LoggerFactory;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.lang.BusinessRuntimeException;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.util.SpringBeanUtil;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.finance.dao.das.IBillBusinessRelPlatformDas;
import com.yunxi.dg.base.center.finance.dao.das.IBillInfoDas;
import com.yunxi.dg.base.center.finance.domain.entity.IAfterSaleOrderDomain;
import com.yunxi.dg.base.center.finance.domain.entity.IBillApplyDomain;
import com.yunxi.dg.base.center.finance.dto.common.MqConstants;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderInfoDto;
import com.yunxi.dg.base.center.finance.dto.entity.PerformOrderSnapshotDto;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.enums.RelBusinessTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.SaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.StrategyTypeEnum;
import com.yunxi.dg.base.center.finance.dto.request.BillInfoGenerateReqDto;
import com.yunxi.dg.base.center.finance.dto.response.BillStrategyRespDto;
import com.yunxi.dg.base.center.finance.eo.BillBusinessRelPlatformEo;
import com.yunxi.dg.base.center.finance.service.entity.IBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IBillStrategyService;
import com.yunxi.dg.base.center.finance.service.entity.IHhOrderGenerateBillInfoService;
import com.yunxi.dg.base.center.finance.service.entity.IPerformOrderInfoService;
import com.yunxi.dg.base.center.finance.service.mq.BaseGenerateInvoiceInfoOrderConsumer;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import com.yunxi.dg.base.center.finance.service.mq.keep.SaleRealTimeAccountingConsumer;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CIS_SALE_ORDER_STATUS_CHANGE_TAG", msgType="publish")
public class GenerateInvoiceInfoByOrderConsumer
extends BaseGenerateInvoiceInfoOrderConsumer<MessageVo>
implements IWhDgMessageProcessor<MessageVo> {
    private static final Logger log = org.slf4j.LoggerFactory.getLogger(GenerateInvoiceInfoByOrderConsumer.class);
    private static final Logger logger = LoggerFactory.getLogger(GenerateInvoiceInfoByOrderConsumer.class);
    @Resource
    private IHhOrderGenerateBillInfoService hhOrderGenerateBillInfoService;
    @Resource
    private IAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IBillApplyDomain billApplyDomain;
    @Resource
    private IBillInfoService billInfoService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IBillStrategyService billStrategyService;
    @Resource
    private IPerformOrderInfoService performOrderInfoService;
    @Resource
    private IBillInfoDas billInfoDas;
    @Resource
    private IBillBusinessRelPlatformDas billBusinessRelPlatformDas;
    @Resource
    private SaleRealTimeAccountingConsumer saleRealTimeAccountingConsumer;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private ILockService lockService;
    @Resource
    private ICacheService cacheService;
    private static final String TABLENAME = "{mq_sale_order_status_change}#";

    @EventListener(classes={MessageVo.class})
    public MessageResponse processMessageVoListener(MessageVo t) {
        if (this.isKeepComplete(t).booleanValue()) {
            log.info("\u56de\u8c03\u901a\u77e5\u6267\u884c\u5bf9\u8c61\u662f=\u300b{}", t.getExtValue2());
            return ((BaseGenerateInvoiceInfoOrderConsumer)SpringBeanUtil.getBean((Class)((Class)t.getExtValue2()))).processBiz(t);
        }
        return MessageResponse.SUCCESS;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public MessageResponse processBiz(MessageVo message) {
        MessageResponse messageResponse;
        Mutex platformOrderKeyMutex;
        Mutex mutex;
        block23: {
            block24: {
                MessageResponse messageResponse2;
                block21: {
                    block22: {
                        MessageResponse messageResponse3;
                        block19: {
                            block20: {
                                this.resetApplyPerson();
                                ServiceContext.getContext().remove("yx.dg.opt.chain.context");
                                ServiceContext.getContext().remove("yx.dg.opt.chain.header");
                                logger.info("\u63a5\u6536\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5f02\u6b65\u751f\u6210\u5f00\u7968\u4fe1\u606fmessage: {}", (Object)JSONObject.toJSONString((Object)message));
                                mutex = null;
                                platformOrderKeyMutex = null;
                                Object mutexBill = null;
                                try {
                                    block26: {
                                        block25: {
                                            Map dataMap = JacksonUtil.toMap((String)JacksonUtil.toJson((Object)message.getData()));
                                            String saleOrderNo = dataMap.get("saleOrderNo").toString();
                                            String platformOrderNo = dataMap.get("platformOrderNo").toString();
                                            String orderStatus = dataMap.get("afterStatus").toString();
                                            if (!OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) && !OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus)) {
                                                log.info("\u8ba2\u5355\u72b6\u6001\u975e\u5df2\u53d1\u8d27\u5df2\u5b8c\u6210\uff0c\u4e0d\u6267\u884c\u5f00\u7968\u52a8\u4f5c:{},{},{}", new Object[]{saleOrderNo, platformOrderNo, orderStatus});
                                                MessageResponse messageResponse4 = MessageResponse.SUCCESS;
                                                return messageResponse4;
                                            }
                                            String orderType = dataMap.get("orderType").toString();
                                            String primaryKey = platformOrderNo + " " + saleOrderNo + " " + orderStatus;
                                            Thread.sleep(RandomUtil.randomLong((long)100L, (long)200L));
                                            String platformOrderKey = MqConstants.getInvoiceKey((String)platformOrderNo);
                                            Boolean b = this.cacheService.setIfAbsent(platformOrderKey, (Object)1, 60);
                                            mutex = this.lockService.lock(TABLENAME, primaryKey, 60, 120, TimeUnit.SECONDS);
                                            logger.info("\u63a5\u6536\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u8ba2\u5355\u72b6\u6001 generateInvoiceConsumer\uff1a{} {} {}", new Object[]{platformOrderNo, saleOrderNo, orderStatus});
                                            if (!this.canBillForGiftOrder(saleOrderNo)) {
                                                messageResponse3 = MessageResponse.SUCCESS;
                                                if (platformOrderKeyMutex == null) break block19;
                                                break block20;
                                            }
                                            if (!this.orderTypeFilter(orderType).booleanValue()) break block25;
                                            if (OmsSaleOrderStatus.DELIVERED.getCode().equals(orderStatus) || OmsSaleOrderStatus.COMPLETE.getCode().equals(orderStatus) || OmsSaleOrderStatus.CANCEL.getCode().equals(orderStatus) || OmsSaleOrderStatus.OBSOLETE.getCode().equals(orderStatus)) {
                                                List relPlatformEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.billBusinessRelPlatformDas.filter().eq((Object)"business_type", (Object)RelBusinessTypeEnum.INVOICE.getCode())).eq((Object)"platform_order_no", (Object)platformOrderNo)).list();
                                                if (CollectionUtils.isNotEmpty((Collection)relPlatformEoList)) {
                                                    List billFlowNo = relPlatformEoList.stream().map(BillBusinessRelPlatformEo::getBusinessOrderNo).distinct().collect(Collectors.toList());
                                                    List billInfoEoList = ((ExtQueryChainWrapper)this.billInfoDas.filter().in((Object)"bill_flow_no", billFlowNo)).list();
                                                    if (billInfoEoList.stream().anyMatch(info -> saleOrderNo.equals(info.getSaleOrderNo()))) {
                                                        logger.info("\u5df2\u7ecf\u751f\u6210\u4e86\u5f00\u7968\u4fe1\u606f\u907f\u514d\u91cd\u590d\u751f\u6210\u5f00\u7968\u4fe1\u606f");
                                                        messageResponse2 = MessageResponse.SUCCESS;
                                                        if (platformOrderKeyMutex == null) break block21;
                                                        break block22;
                                                    }
                                                }
                                                logger.info("\u63a5\u6536\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f,\u8ba2\u5355\u53f7\uff1a{}", (Object)saleOrderNo);
                                                BillInfoGenerateReqDto billInfoGenerateReqDto = new BillInfoGenerateReqDto();
                                                billInfoGenerateReqDto.setApplyFlag(Boolean.FALSE);
                                                billInfoGenerateReqDto.setOrderStatus(orderStatus);
                                                billInfoGenerateReqDto.setSaleOrderNo(saleOrderNo);
                                                billInfoGenerateReqDto.setOrderType(orderType);
                                                this.billInfoService.generateBillInfo(billInfoGenerateReqDto);
                                            }
                                            break block26;
                                        }
                                        logger.info("\u8865\u53d1\u7c7b\u578b\u8ba2\u5355\u4e0d\u8fdb\u884c\u5f00\u7968");
                                    }
                                    messageResponse = MessageResponse.SUCCESS;
                                    if (platformOrderKeyMutex == null) break block23;
                                    break block24;
                                }
                                catch (BusinessRuntimeException er) {
                                    logger.error("\u53ef\u80fd\u662f\u6216\u8005\u5206\u5e03\u5f0f\u5931\u8d25\u4e86", (Throwable)er);
                                    try {
                                        Thread.sleep(5000L);
                                    }
                                    catch (InterruptedException interruptedException) {
                                        // empty catch block
                                    }
                                    MessageResponse messageResponse5 = MessageResponse.ERROR;
                                    return messageResponse5;
                                }
                                catch (Exception e) {
                                    throw new BizException(String.format("\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5f02\u6b65\u751f\u6210\u5f00\u7968\u4fe1\u606f\u5904\u7406\u5f02\u5e38:\u3010%s\u3011\uff0c\u3010%s\u3011", e.getMessage(), e));
                                }
                            }
                            this.lockService.unlock(platformOrderKeyMutex);
                        }
                        if (mutex == null) return messageResponse3;
                        this.lockService.unlock(mutex);
                        return messageResponse3;
                    }
                    this.lockService.unlock(platformOrderKeyMutex);
                }
                if (mutex == null) return messageResponse2;
                this.lockService.unlock(mutex);
                return messageResponse2;
            }
            this.lockService.unlock(platformOrderKeyMutex);
        }
        if (mutex == null) return messageResponse;
        this.lockService.unlock(mutex);
        return messageResponse;
        finally {
            if (platformOrderKeyMutex != null) {
                this.lockService.unlock(platformOrderKeyMutex);
            }
            if (mutex != null) {
                this.lockService.unlock(mutex);
            }
        }
    }

    private void resetApplyPerson() {
        String newApplyPerson = "\u7cfb\u7edf";
        String oldApplyPerson = ServiceContext.getContext().getRequestUserCode();
        log.info("\u91cd\u8bbe\u53d1\u7968\u7533\u8bf7\u4eba\uff1a{} -> {}", (Object)oldApplyPerson, (Object)newApplyPerson);
        ServiceContext.getContext().setAttachment("yes.req.userCode", newApplyPerson);
    }

    private boolean canBillForGiftOrder(String saleOrderNo) {
        PerformOrderInfoDto order = this.performOrderInfoService.queryByOrderNo(saleOrderNo);
        if (order == null) {
            log.info("\u8ba2\u5355 {} \u4e0d\u5b58\u5728", (Object)saleOrderNo);
            return true;
        }
        List labels = this.orderLabelRecordDomain.queryByOrderIdsAndLabelCodes((List)Lists.newArrayList((Object[])new Long[]{order.getId()}), "GIFT_ORDER");
        if (CollectionUtils.isEmpty((Collection)labels) || CollectionUtils.isEmpty((Collection)order.getPerformOrderSnapshotDtoList())) {
            return true;
        }
        String shopCode = ((PerformOrderSnapshotDto)order.getPerformOrderSnapshotDtoList().get(0)).getShopCode();
        BillStrategyRespDto strategy = this.billStrategyService.queryByShopCodeAndType(shopCode, StrategyTypeEnum.ORDINARY_BILL.getCode());
        if (strategy == null) {
            return true;
        }
        return strategy.getBillGift() == null || "1".equals(strategy.getBillGift());
    }

    public Boolean orderTypeFilter(String orderType) {
        if (SaleOrderTypeEnum.CONSIGNMENT_NOT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.CONSIGNMENT_BACK.getType().equals(orderType) || SaleOrderTypeEnum.PROXY_SALE.getType().equals(orderType) || SaleOrderTypeEnum.GIFT_ORDER.getType().equals(orderType) || SaleOrderTypeEnum.SHIPMENT_CLAIM_ORDER.getType().equals(orderType)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }
}

