/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq.keep;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.AfterSaleOrderTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsOrderStatusEnum;
import com.yunxi.dg.base.center.finance.dto.mq.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IRealTimeAccountingService;
import com.yunxi.dg.base.center.finance.service.mq.GenerateInvoiceInfoByAfterOrderConsumer;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CIS_FINANCE_AFTER_SALE_ORDER_REFUND_STATUS_CHANGE_TAG")
public class RealTimeAccountingConsumer
implements IWhDgMessageProcessor<MessageVo> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IRealTimeAccountingService realTimeAccountingService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Value(value="${real.time.flag:true}")
    private boolean isRealTimeFlag;
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    @Resource
    private IOrderRuleService service;
    @Resource
    private ILockService lockService;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    public static final ThreadPoolExecutor ACCOUNT_REAL_EXECUTOR = new ThreadPoolExecutor(Math.max(2, Runtime.getRuntime().availableProcessors() + 1), Math.max(2, Runtime.getRuntime().availableProcessors() + 1) * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("PushKeepInternalOrder-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(MessageVo message) {
        this.logger.info("\u63a5\u6536\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26message:{}", (Object)JSON.toJSONString((Object)message));
        OrderRuleRespDto orderRuleRespDto = this.service.selectOrderRule();
        if (!Objects.equals(orderRuleRespDto.getAccountType(), AccountRuleEnum.REAL_TIME.getCode())) {
            this.logger.info("\u5f53\u524d\u914d\u7f6e\u4e0d\u662f\u5b9e\u65f6:{}", (Object)orderRuleRespDto.getAccountType());
            return MessageResponse.SUCCESS;
        }
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)JSON.parseObject((String)message.getData().toString(), DgAfterSaleOrderRespDto.class);
        this.logger.info("\u63a5\u6536\u552e\u540e\u5355\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u8ba2\u5355\u72b6\u6001\uff1a{}, {}", (Object)afterSaleOrderRespDto.getAfterSaleOrderNo(), (Object)afterSaleOrderRespDto.getStatus());
        ServiceContext.getContext().setAttachment("yes.req.userCode", afterSaleOrderRespDto.getUpdatePerson());
        String saleOrderNo = afterSaleOrderRespDto.getAfterSaleOrderNo();
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            this.logger.error("\u552e\u540e\u5355\u53f7\u4e3a\u7a7a");
            return MessageResponse.SUCCESS;
        }
        if (!AfterSaleOrderTypeEnum.getFinanceType((String)afterSaleOrderRespDto.getAfterSaleOrderType()).booleanValue() || !Objects.equals(OmsOrderStatusEnum.FINISH.getCode(), afterSaleOrderRespDto.getStatus()) && !Objects.equals(OmsOrderStatusEnum.IN_WAREHOUSE.getCode(), afterSaleOrderRespDto.getStatus()) && !Objects.equals(OmsOrderStatusEnum.COMPLETE.getCode(), afterSaleOrderRespDto.getStatus())) {
            this.logger.error("\u5f53\u524d\u72b6\u6001\u4e0d\u7b26\u5408\uff1a{},\u5355\u636e\u53f7\u4e3a\uff1a{}", (Object)afterSaleOrderRespDto.getStatus(), (Object)afterSaleOrderRespDto.getAfterSaleOrderNo());
            return MessageResponse.SUCCESS;
        }
        HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
        this.logger.info("objs======\uff1a{}", (Object)JSON.toJSONString(objs));
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        CompletableFuture.runAsync(() -> {
            try {
                for (Map.Entry entry : objs.entrySet()) {
                    ServiceContext.getContext().setAttachment((String)entry.getKey(), (String)entry.getValue());
                }
                MDC.put((String)"yes.req.requestId", (String)reqId);
                this.realTimeAccountingService.execute(afterSaleOrderRespDto.getAfterSaleOrderNo(), afterSaleOrderRespDto.getStatus(), this.keepSystem, afterSaleOrderRespDto.getAfterSaleOrderType());
            }
            catch (Exception e) {
                this.logger.error("\u63a5\u6536\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26\uff1a{}", (Object)e.getMessage(), (Object)e);
                ArrayList<KeepExceptionDetailEo> exceptionDetailEos = new ArrayList<KeepExceptionDetailEo>();
                exceptionDetailEos.add(this.setKeepException(saleOrderNo, e.getMessage(), BillTypeEnum.RETURN_BASE.getCode()));
                this.bookKeepAccountService.batchInsertKeepExceptionDetail(exceptionDetailEos);
            }
            finally {
                message.setExtValue2(GenerateInvoiceInfoByAfterOrderConsumer.class);
                this.applicationEventPublisher.publishEvent((Object)message);
            }
        }, ACCOUNT_REAL_EXECUTOR);
        return MessageResponse.SUCCESS;
    }

    private KeepExceptionDetailEo setKeepException(String afterSaleOrderNo, String extension, String orderType) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(afterSaleOrderNo);
        exceptionDetailEo.setExtension(extension);
        exceptionDetailEo.setOrderType(orderType);
        exceptionDetailEo.setStatus(Integer.valueOf(0));
        return exceptionDetailEo;
    }
}

