/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.finance.service.mq.keep;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.util.JacksonUtil;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.yunxi.dg.base.center.finance.dto.enums.AccountRuleEnum;
import com.yunxi.dg.base.center.finance.dto.enums.BillTypeEnum;
import com.yunxi.dg.base.center.finance.dto.enums.OmsSaleOrderStatus;
import com.yunxi.dg.base.center.finance.dto.response.OrderRuleRespDto;
import com.yunxi.dg.base.center.finance.eo.KeepExceptionDetailEo;
import com.yunxi.dg.base.center.finance.service.entity.IBookKeepAccountService;
import com.yunxi.dg.base.center.finance.service.entity.IOrderRuleService;
import com.yunxi.dg.base.center.finance.service.entity.IRealTimeAccountingService;
import com.yunxi.dg.base.center.finance.service.mq.GenerateInvoiceInfoByOrderConsumer;
import com.yunxi.dg.base.center.finance.service.mq.IWhDgMessageProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="CIS_FINANCE_SALE_ORDER_REFUND_STATUS_CHANGE_TAG")
public class SaleRealTimeAccountingConsumer
implements IWhDgMessageProcessor<MessageVo> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IRealTimeAccountingService realTimeAccountingService;
    @Resource
    private IBookKeepAccountService bookKeepAccountService;
    @Value(value="${real.time.flag:true}")
    private boolean isRealTimeFlag;
    @Value(value="${keep.base.mode:AJR}")
    private String keepSystem;
    @Resource
    private IOrderRuleService service;
    @Resource
    private ILockService lockService;
    @Resource
    private ApplicationEventPublisher applicationEventPublisher;
    public static final ThreadPoolExecutor ACCOUNT_SALE_REAL_EXECUTOR = new ThreadPoolExecutor(Math.max(2, Runtime.getRuntime().availableProcessors() + 1), Math.max(2, Runtime.getRuntime().availableProcessors() + 1) * 2, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(1000), new ThreadFactoryBuilder().setNameFormat("PushKeepInternalOrder-pool-%d").build(), new ThreadPoolExecutor.CallerRunsPolicy());

    public MessageResponse process(MessageVo message) {
        this.logger.info("\u63a5\u6536\u9500\u552e\u5355\u8bb0\u8d26message\uff1a{}", (Object)JSON.toJSONString((Object)message));
        OrderRuleRespDto orderRuleRespDto = this.service.selectOrderRule();
        if (!Objects.equals(orderRuleRespDto.getAccountType(), AccountRuleEnum.REAL_TIME.getCode())) {
            this.logger.info("\u5f53\u524d\u914d\u7f6e\u4e0d\u662f\u5b9e\u65f6\uff1a{}", (Object)orderRuleRespDto.getAccountType());
            return MessageResponse.SUCCESS;
        }
        Map dataMap = JacksonUtil.toMap((String)JacksonUtil.toJson((Object)message.getData()));
        String saleOrderNo = Convert.toStr(dataMap.get("saleOrderNo"));
        String status = Convert.toStr(dataMap.get("orderStatus"));
        String platformOrderNo = Convert.toStr(dataMap.get("platformOrderNo"));
        String updatePerson = Convert.toStr(dataMap.get("updatePerson"));
        ServiceContext.getContext().setAttachment("yes.req.userCode", updatePerson);
        if (!(Objects.equals(OmsSaleOrderStatus.DELIVERED.getCode(), status) || Objects.equals(OmsSaleOrderStatus.COMPLETE.getCode(), status) || Objects.equals(OmsSaleOrderStatus.FINISH.getCode(), status) || Objects.equals(OmsSaleOrderStatus.DELIVERY_PART.getCode(), status) || Objects.equals(OmsSaleOrderStatus.DELIVERY_ALL.getCode(), status))) {
            this.logger.error("\u5f53\u524d\u72b6\u6001\u4e0d\u7b26\u5408:{},\u5355\u636e\u53f7\u4e3a:{}", (Object)status, (Object)saleOrderNo);
            return MessageResponse.SUCCESS;
        }
        HashMap objs = new HashMap(ServiceContext.getContext().getAttachments());
        this.logger.info("objs======\uff1a{}", (Object)JSON.toJSONString(objs));
        String reqId = ServiceContext.getContext().getAttachment("yes.req.requestId");
        CompletableFuture.runAsync(() -> {
            try {
                for (Map.Entry entry : objs.entrySet()) {
                    ServiceContext.getContext().setAttachment((String)entry.getKey(), (String)entry.getValue());
                }
                MDC.put((String)"yes.req.requestId", (String)reqId);
                this.realTimeAccountingService.saleExecute(saleOrderNo, status, this.keepSystem, platformOrderNo, null);
            }
            catch (Exception e) {
                this.logger.error("\u63a5\u6536\u552e\u540e\u5355\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u5b9e\u65f6\u9000\u8d27\u9000\u6b3e,\u6362\u8d27\u5355\u8bb0\u8d26\uff1a{}", (Object)e.getMessage(), (Object)e);
                ArrayList<KeepExceptionDetailEo> exceptionDetailEos = new ArrayList<KeepExceptionDetailEo>();
                exceptionDetailEos.add(this.setKeepException(saleOrderNo, e.getMessage(), BillTypeEnum.RETURN_BASE.getCode()));
                this.bookKeepAccountService.batchInsertKeepExceptionDetail(exceptionDetailEos);
            }
            finally {
                message.setExtValue2(GenerateInvoiceInfoByOrderConsumer.class);
                this.applicationEventPublisher.publishEvent((Object)message);
            }
        }, ACCOUNT_SALE_REAL_EXECUTOR);
        return MessageResponse.SUCCESS;
    }

    private KeepExceptionDetailEo setKeepException(String afterSaleOrderNo, String extension, String orderType) {
        KeepExceptionDetailEo exceptionDetailEo = new KeepExceptionDetailEo();
        exceptionDetailEo.setOrderNo(afterSaleOrderNo);
        exceptionDetailEo.setExtension(extension);
        exceptionDetailEo.setOrderType(orderType);
        exceptionDetailEo.setStatus(Integer.valueOf(0));
        return exceptionDetailEo;
    }
}

