/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.dao.das.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dao.das.ILogisticsPlatformShopDas;
import com.yunxi.dg.base.center.inventory.dao.das.impl.LogisticsSiteLinkDasImpl;
import com.yunxi.dg.base.center.inventory.dao.mapper.LogisticsPlatformShopMapper;
import com.yunxi.dg.base.center.inventory.dao.vo.LogisticsSiteLinkMatchDto;
import com.yunxi.dg.base.center.inventory.eo.LogisticsPlatformShopEo;
import com.yunxi.dg.base.center.inventory.eo.LogisticsSiteLinkEo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

@Repository
public class LogisticsPlatformShopDasImpl
extends AbstractDas<LogisticsPlatformShopEo, Long>
implements ILogisticsPlatformShopDas {
    @Resource
    private LogisticsPlatformShopMapper mapper;
    @Resource
    private LogisticsSiteLinkDasImpl logisticsSiteLinkDas;

    public LogisticsPlatformShopMapper getMapper() {
        return this.mapper;
    }

    @Override
    public List<LogisticsPlatformShopEo> match(Set<String> matchSet, int state) {
        List list = ((ExtQueryChainWrapper)this.logisticsSiteLinkDas.filter().select(new String[]{"link_id"}).in((Object)"link_match_key", matchSet)).list();
        List ids = list.stream().map(LogisticsSiteLinkEo::getLinkId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LogisticsPlatformShopEo>();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.filter().in((Object)"id", ids)).eq((Object)"auth_state", (Object)state)).list();
    }

    @Override
    public List<LogisticsPlatformShopEo> matchByList(@Param(value="matchList") List<LogisticsSiteLinkMatchDto> matchList) {
        return this.getMapper().matchByList(matchList);
    }

    @Override
    public List<LogisticsPlatformShopEo> queryByShopAndWarehouse(String shop, String warehouse, int state) {
        return this.queryByShopsAndWarehouses(Lists.newArrayList((Object[])new String[]{shop}), Lists.newArrayList((Object[])new String[]{warehouse}), state);
    }

    @Override
    public List<LogisticsPlatformShopEo> queryByShopsAndWarehouses(List<String> shops, List<String> warehouses, int state) {
        List<LogisticsSiteLinkEo> shopList = this.getLogisticsSiteLinkEos(shops);
        List ids = shopList.stream().map(LogisticsSiteLinkEo::getLinkId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LogisticsPlatformShopEo>();
        }
        List warehouseList = ((ExtQueryChainWrapper)this.logisticsSiteLinkDas.filter().select(new String[]{"link_id"}).in((Object)"link_match_key", warehouses)).list();
        ids = warehouseList.stream().map(LogisticsSiteLinkEo::getLinkId).filter(ids::contains).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LogisticsPlatformShopEo>();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.filter().in((Object)"id", ids)).eq((Object)"auth_state", (Object)state)).list();
    }

    private List<LogisticsSiteLinkEo> getLogisticsSiteLinkEos(List<String> shops) {
        return ((ExtQueryChainWrapper)this.logisticsSiteLinkDas.filter().select(new String[]{"link_id"}).in((Object)"link_match_key", shops)).list();
    }

    @Override
    public List<LogisticsPlatformShopEo> match(Set<String> matchSet) {
        List<LogisticsSiteLinkEo> list = this.getLogisticsSiteLinkEos(Lists.newArrayList(matchSet));
        List ids = list.stream().map(LogisticsSiteLinkEo::getLinkId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ids)) {
            return new ArrayList<LogisticsPlatformShopEo>();
        }
        return ((ExtQueryChainWrapper)this.filter().in((Object)"id", ids)).list();
    }
}

