/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.dao.das.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDetailDas;
import com.yunxi.dg.base.center.inventory.dao.mapper.TransferOrderDetailMapper;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderDetailResponseDto;
import com.yunxi.dg.base.center.inventory.dto.domain.CsTransferOrderQueryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.TranferOrderCountRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderStatisticsDto;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Repository;

@Repository
public class TransferOrderDetailDasImpl
extends AbstractDas<TransferOrderDetailEo, Long>
implements ITransferOrderDetailDas {
    @Resource
    private TransferOrderDetailMapper detailMapper;

    @Override
    public List<TransferOrderItemPageDto> selectPageList(TransferOrderSearchDto dto) {
        return this.detailMapper.selectPageList(dto);
    }

    @Override
    public List<TransferOrderDetailEo> selectListByTransferOrderNo(String transferOrderNo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"transfer_order_no", (Object)transferOrderNo);
        wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        wrapper.orderByDesc((Object)"create_time");
        return this.detailMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<CsTransferOrderDetailResponseDto> queryGroupByTransferOrderNo(String transferOrderNo) {
        return this.detailMapper.queryGroupByTransferOrderNo(transferOrderNo);
    }

    @Override
    public List<TransferOrderDetailEo> queryByTransferOrderNo(String transferOrderNo) {
        return ((ExtQueryChainWrapper)this.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
    }

    @Override
    public List<TranferOrderCountRespDto> tranferOrderCount(CsTransferOrderQueryDto queryDto) {
        return this.detailMapper.tranferOrderCount(queryDto);
    }

    @Override
    public void updateTransferOrderDetailDispatcher(TransferOrderDetailEo eo) {
        this.detailMapper.updateTransferOrderDetailDispatcher(eo);
    }

    @Override
    public void backfillBatch(String transferOrderNo, String skuCode, String batch) {
        this.detailMapper.backfillBatch(transferOrderNo, skuCode, batch);
    }

    @Override
    public TransferOrderStatisticsDto statisticsByTransferOrderNo(String transferOrderNo) {
        return this.detailMapper.statisticsByTransferOrderNo(transferOrderNo);
    }
}

