/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dao.das.IReceiveDeliveryNoticeOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.dto.domain.CsDeliveryNoticeOrderQueryDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryNoticeOrderEo;
import com.yunxi.dg.base.commons.enums.YesNoEnum;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.List;
import javax.annotation.Resource;
import jodd.util.StringUtil;
import org.springframework.stereotype.Service;

@Service
public class ReceiveDeliveryNoticeOrderDomainImpl
extends BaseDomainImpl<ReceiveDeliveryNoticeOrderEo>
implements IReceiveDeliveryNoticeOrderDomain {
    @Resource
    private IReceiveDeliveryNoticeOrderDas das;

    public ICommonDas<ReceiveDeliveryNoticeOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public PageInfo<ReceiveDeliveryNoticeOrderEo> getReceiveDeliveryNoticeOrderEoPageInfo(CsDeliveryNoticeOrderQueryDto queryDto, Integer pageNum, Integer pageSize, Long organizationId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq(null != organizationId, (Object)"organization_id", (Object)organizationId);
        if (StringUtil.isNotBlank((CharSequence)queryDto.getBusinessType())) {
            wrapper.eq((Object)"business_type", (Object)queryDto.getBusinessType());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getOrderStatus())) {
            wrapper.eq((Object)"order_status", (Object)queryDto.getOrderStatus());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getPreOrderNo())) {
            wrapper.eq((Object)"pre_order_no", (Object)queryDto.getPreOrderNo());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getDocumentNo())) {
            wrapper.like((Object)"document_no", (Object)queryDto.getDocumentNo());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getRelevanceNo())) {
            wrapper.like((Object)"relevance_no", (Object)queryDto.getRelevanceNo());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getWarehouseName())) {
            wrapper.like((Object)"warehouse_name", (Object)queryDto.getWarehouseName());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getWarehouseCode())) {
            wrapper.like((Object)"warehouse_code", (Object)queryDto.getWarehouseCode());
        }
        if (StringUtil.isNotBlank((CharSequence)queryDto.getCreateTimeStart()) && StringUtil.isNotBlank((CharSequence)queryDto.getCreateTimeEnd())) {
            wrapper.between((Object)"create_time", (Object)queryDto.getCreateTimeStart(), (Object)queryDto.getCreateTimeEnd());
        }
        wrapper.orderByDesc((Object)queryDto.getOrderByDesc());
        wrapper.eq((Object)"dr", (Object)YesNoEnum.NO.getValue());
        PageHelper.startPage((int)pageNum, (int)pageSize);
        List list = this.commonDas().getMapper().selectList((Wrapper)wrapper);
        return new PageInfo(list);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryDeliveryNotice(String documentNo) {
        QueryWrapper deliveryNoticeQueryWrapper = new QueryWrapper();
        deliveryNoticeQueryWrapper.eq((Object)"document_no", (Object)documentNo);
        deliveryNoticeQueryWrapper.eq((Object)"dr", (Object)0);
        return this.das.getMapper().selectList((Wrapper)deliveryNoticeQueryWrapper);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryByPreOrderNo(String preOrderNo, String type) {
        QueryWrapper deliveryNoticeQueryWrapper = new QueryWrapper();
        deliveryNoticeQueryWrapper.eq((Object)"pre_order_no", (Object)preOrderNo);
        deliveryNoticeQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryNoticeQueryWrapper.eq((Object)"order_type", (Object)type);
        return this.das.getMapper().selectList((Wrapper)deliveryNoticeQueryWrapper);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryByPreOrderNo(String preOrderNo) {
        return this.das.queryByPreOrderNo(preOrderNo);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryByDocumentNo(String documentNo) {
        return this.das.queryByDocumentNo(documentNo);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryByRelevanceNo(String relevanceNo) {
        return this.das.queryByRelevanceNo(relevanceNo);
    }

    @Override
    public ReceiveDeliveryNoticeOrderEo queryByRelevanceNoOrderType(String relevanceNo, String orderType) {
        QueryWrapper deliveryNoticeQueryWrapper = new QueryWrapper();
        deliveryNoticeQueryWrapper.eq((Object)"relevance_no", (Object)relevanceNo);
        deliveryNoticeQueryWrapper.eq((Object)"dr", (Object)0);
        deliveryNoticeQueryWrapper.eq((Object)"order_type", (Object)orderType);
        return (ReceiveDeliveryNoticeOrderEo)this.das.getMapper().selectOne((Wrapper)deliveryNoticeQueryWrapper);
    }

    @Override
    public List<ReceiveDeliveryNoticeOrderEo> queryPageByConditions(CsDeliveryNoticeOrderQueryDto dto) {
        return this.das.queryPageByConditions(dto);
    }

    @Override
    public ReceiveDeliveryNoticeOrderEo getReceiveDeliveryNoticeOrderByResultOrder(String preOrderNo) {
        return this.das.getReceiveDeliveryNoticeOrderByResultOrder(preOrderNo);
    }
}

