/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicWarehouseDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicWarehouseDomain;
import com.yunxi.dg.base.center.inventory.eo.LogicWarehouseEo;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LogicWarehouseDomainImpl
extends BaseDomainImpl<LogicWarehouseEo>
implements ILogicWarehouseDomain {
    @Autowired
    ILogicWarehouseDas das;

    public ICommonDas<LogicWarehouseEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicWarehouseEo> queryByCodes(List<String> warehouseCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).in(LogicWarehouseEo::getWarehouseCode, warehouseCodes)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public LogicWarehouseEo queryByCode(String warehouseCode) {
        if (StrUtil.isBlank((CharSequence)warehouseCode)) {
            return null;
        }
        return (LogicWarehouseEo)this.das.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)warehouseCode)).eq(LogicWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public Integer updateIsReturnWarehouseByOrganizationId(Long organizationId) {
        return this.das.updateIsReturnWarehouseByOrganizationId(organizationId);
    }

    @Override
    public List<LogicWarehouseEo> queryBySubordinateLogicWarehouseId(Long subordinateLogicWarehouseId) {
        return this.das.queryBySubordinateLogicWarehouseId(subordinateLogicWarehouseId);
    }

    @Override
    public LogicWarehouseEo queryByCodeAndInterconnectionFlag(String warehouseCode, Integer interconnectionFlag) {
        if (StrUtil.isBlank((CharSequence)warehouseCode)) {
            return null;
        }
        return (LogicWarehouseEo)this.das.getMapper().selectOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicWarehouseEo.class).eq(LogicWarehouseEo::getWarehouseCode, (Object)warehouseCode)).eq(LogicWarehouseEo::getInterconnectionFlag, (Object)interconnectionFlag)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public int batchUpdateStatusByIds(Long[] ids, Long[] notInIds, String status, String updatePerson, Date updateTime) {
        return this.das.batchUpdateStatusByIds(ids, notInIds, status, updatePerson, updateTime);
    }
}

