/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryDas;
import com.yunxi.dg.base.center.inventory.dao.vo.InventoryWarehouseVo;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.LogicInventoryPageReqDto;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LogicInventoryDomainImpl
extends BaseDomainImpl<LogicInventoryEo>
implements ILogicInventoryDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryDomainImpl.class);
    @Autowired
    ILogicInventoryDas das;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public ICommonDas<LogicInventoryEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryEo> queryByWarehouseCodesAndSkuCodesAndBatches(List<String> warehouseCodes, List<String> skuCodes, List<String> batches) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryEo.class).in(LogicInventoryEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryEo::getSkuCode, skuCodes)).in(CollectionUtil.isNotEmpty(batches), LogicInventoryEo::getBatch, batches)).eq(BaseEo::getDr, (Object)YesNoHelper.NO)).orderByAsc(LogicInventoryEo::getBatch));
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            voList = voList.stream().sorted(Comparator.comparing(CalcUpdateInventoryDto::getInventoryId)).collect(Collectors.toList());
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic updateInventory exception...{}", (Object)e.getMessage(), (Object)e);
            throw new WarehouseAbleException("logic updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public List<LogicInventoryEo> batchIgnoreInsertNew(List<LogicInventoryEo> eoList) {
        log.info("\u8fdb\u5165\u521d\u59cb\u5316\u4fdd\u5b581:{}", (Object)JSONObject.toJSONString(eoList));
        Map inventoryEoMap = eoList.stream().collect(Collectors.toMap(LogicInventoryDomainImpl::getBatchKey, Function.identity(), (o, o1) -> o));
        List<LogicInventoryEo> inventoryEos = inventoryEoMap.entrySet().stream().filter(r -> {
            String key = (String)r.getKey();
            if (this.cacheService.setIfAbsent(LogicInventoryDomainImpl.getFilterCacheKey() + key, (Object)((LogicInventoryEo)r.getValue()).getId()).booleanValue()) {
                this.cacheService.setCache(LogicInventoryDomainImpl.getWaitProcessKey() + key, (Object)JSONObject.toJSONString(r.getValue()), 3600);
                return true;
            }
            return false;
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inventoryEos)) {
            return inventoryEos;
        }
        log.info("\u8fdb\u5165\u521d\u59cb\u5316\u4fdd\u5b582:{}", (Object)JSONObject.toJSONString(inventoryEos));
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        Integer execute = (Integer)transactionTemplate.execute(s -> {
            try {
                this.batchIgnoreInsert(inventoryEos);
            }
            catch (Exception e) {
                return 0;
            }
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getWaitProcessKey() + LogicInventoryDomainImpl.getBatchKey(r)));
            return 1;
        });
        if (Objects.equals(0, execute)) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r)));
        }
        return inventoryEos;
    }

    @NotNull
    private static String getWaitProcessKey() {
        return "waitInit:";
    }

    @NotNull
    private static String getFilterCacheKey() {
        return "batchIgnoreInsertNew:";
    }

    private void doBatchInsert(List<LogicInventoryEo> inventoryEos) {
        try {
            connection.setAutoCommit(false);
            try (Connection connection = this.dataSource.getConnection();){
                StringBuilder sqlBuilder = new StringBuilder();
                sqlBuilder.append("INSERT INTO cs_logic_inventory (").append("`id`, `warehouse_id`, `warehouse_code`, `warehouse_name`, `inventory_property`, ").append("`sku_code`, `sku_name`, `batch`, `batch_type`, ").append("`balance`, `preempt`, `allocate`, `activity_allocate`, `intransit`, `transfer`, `completed`, `future_in`, `future_retreat`, `available`, `lock_inventory`, ").append("`remark`, `expire_time`, `produce_time`, ").append("`tenant_id`, `instance_id`, `extension`, `create_person`, `create_time`, `update_person`, `update_time`, `dr`").append(") VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, -1, -1, null, ?, now(), ?, now(), 0)");
                int i = this.executeInsert(inventoryEos, connection, sqlBuilder);
                log.debug("\u5904\u7406\u6210\u529f\u6570\u91cf" + i);
                connection.commit();
                inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getWaitProcessKey() + LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r)));
            }
        }
        catch (SQLException e) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r)));
            throw new BizException(e.getMessage());
        }
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryEo> eoList) {
        return this.das.insertBatch(eoList);
    }

    @NotNull
    private static String getBatchKey(LogicInventoryEo r) {
        return String.join((CharSequence)"__", r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty(), r.getBatch().toUpperCase());
    }

    private int executeInsert(List<LogicInventoryEo> eoList, Connection connection, StringBuilder sqlBuilder) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sqlBuilder.toString());
        for (LogicInventoryEo eo : eoList) {
            int index = 1;
            preparedStatement.setLong(index++, eo.getId());
            preparedStatement.setLong(index++, eo.getWarehouseId());
            preparedStatement.setString(index++, eo.getWarehouseCode());
            preparedStatement.setString(index++, eo.getWarehouseName());
            preparedStatement.setString(index++, eo.getInventoryProperty());
            preparedStatement.setString(index++, eo.getSkuCode());
            preparedStatement.setString(index++, eo.getSkuName());
            preparedStatement.setString(index++, eo.getBatch().toUpperCase());
            preparedStatement.setString(index++, eo.getBatchType());
            preparedStatement.setBigDecimal(index++, eo.getBalance());
            preparedStatement.setBigDecimal(index++, eo.getPreempt());
            preparedStatement.setBigDecimal(index++, eo.getAllocate());
            preparedStatement.setBigDecimal(index++, eo.getActivityAllocate());
            preparedStatement.setBigDecimal(index++, eo.getIntransit());
            preparedStatement.setBigDecimal(index++, eo.getTransfer());
            preparedStatement.setBigDecimal(index++, eo.getCompleted());
            preparedStatement.setBigDecimal(index++, eo.getFutureIn());
            preparedStatement.setBigDecimal(index++, eo.getFutureRetreat());
            preparedStatement.setBigDecimal(index++, eo.getAvailable());
            preparedStatement.setBigDecimal(index++, eo.getLockInventory());
            preparedStatement.setString(index++, eo.getRemark());
            preparedStatement.setTimestamp(index++, Optional.ofNullable(eo.getExpireTime()).map(r -> new Timestamp(eo.getExpireTime().getTime())).orElse(null));
            preparedStatement.setTimestamp(index++, Optional.ofNullable(eo.getProduceTime()).map(r -> new Timestamp(eo.getProduceTime().getTime())).orElse(null));
            preparedStatement.setString(index++, eo.getCreatePerson());
            preparedStatement.setString(index++, eo.getUpdatePerson());
            preparedStatement.addBatch();
        }
        int[] ints = preparedStatement.executeBatch();
        return Arrays.stream(ints).reduce(0, Integer::sum);
    }

    @Override
    public List<InventoryWarehouseVo> queryQualifiedCargoInventory(InventoryWarehouseVo vo) {
        return this.das.queryQualifiedCargoInventory(vo);
    }

    @Override
    public List<LogicInventoryDto> queryThirdWarehouse(LogicInventoryPageReqDto dto) {
        return this.das.queryThirdWarehouse(dto);
    }

    private /* synthetic */ void lambda$doBatchInsert$6(LogicInventoryEo r) {
        this.cacheService.delCache(LogicInventoryDomainImpl.getFilterCacheKey() + LogicInventoryDomainImpl.getBatchKey(r));
    }
}

