/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.enums.TransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDetailDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.bussiness.CsTransferDispatcherStatusEnum;
import com.yunxi.dg.base.center.inventory.dto.domain.TransferOrderDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderItemPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderStatisticsDto;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutNoticeOrderEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.InOutResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository
public class TransferOrderDetailDomainImpl
extends BaseDomainImpl<TransferOrderDetailEo>
implements ITransferOrderDetailDomain {
    private static final Logger log = LoggerFactory.getLogger(TransferOrderDetailDomainImpl.class);
    @Resource
    private ITransferOrderDetailDas das;
    @Resource
    private ITransferOrderDas transferOrderDas;
    @Resource
    private IInOutNoticeOrderDomain inOutNoticeOrderDomain;
    @Resource
    private IInOutNoticeOrderDetailDomain inOutNoticeOrderDetailDomain;
    @Resource
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Resource
    private IInOutResultOrderDetailDomain inOutResultOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;

    public ICommonDas<TransferOrderDetailEo> commonDas() {
        return this.das;
    }

    @Override
    public List<TransferOrderDetailRespDto> queryListByBizKey(TransferOrderKeyDto keyDto) {
        ArrayList<TransferOrderDetailRespDto> dtoList = new ArrayList<TransferOrderDetailRespDto>();
        List list = new ArrayList();
        if (StringUtils.isNotBlank((CharSequence)keyDto.getTransferOrderNo())) {
            list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"transfer_order_no", (Object)keyDto.getTransferOrderNo())).orderByAsc((Object)"id")).list();
        }
        if (CollectionUtil.isNotEmpty(list)) {
            DtoHelper.eoList2DtoList(list, dtoList, TransferOrderDetailRespDto.class);
        }
        return dtoList;
    }

    @Override
    public void checkSelfParam(List<TransferOrderDetailReqDto> detailList) {
        detailList.forEach(item -> {});
    }

    @Override
    public List<TransferOrderItemPageDto> selectPageList(TransferOrderSearchDto dto) {
        return this.das.selectPageList(dto);
    }

    @Override
    public void deleteByTransferOrderNo(String transferOrderNo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"transfer_order_no", (Object)transferOrderNo);
        this.das.getMapper().delete((Wrapper)queryWrapper);
    }

    @Override
    public void backfillBatch(String transferOrderNo, String skuCode, String batch) {
        this.das.backfillBatch(transferOrderNo, skuCode, batch);
    }

    @Override
    public TransferOrderStatisticsDto statisticsByTransferOrderNo(String transferOrderNo) {
        return this.das.statisticsByTransferOrderNo(transferOrderNo);
    }

    @Override
    public List<TransferOrderDetailEo> queryByTransferOrderNo(String transferOrderNo) {
        return ((ExtQueryChainWrapper)this.das.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).list();
    }

    @Override
    public String statisticsDispatcherByTransferOrderNo(String transferOrderNo, boolean isEnd, boolean dispatchOrderBatch) {
        log.info("------------------------------------------------\u6536\u53d1\u5dee\u5f02\u7edf\u8ba1------------------------------------------------------------------------");
        Map<String, BigDecimal> ratioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderNo)).list().stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, BigDecimal> toRatioMap = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderNo)).list().stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum(), (int)6), (o, o1) -> o));
        log.info("ratioMap: {}", (Object)JSON.toJSONString(ratioMap));
        log.info("toRatioMap: {}", (Object)JSON.toJSONString(toRatioMap));
        List originalDetailList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"transfer_order_no", (Object)transferOrderNo)).orderByAsc((Object)"id")).list();
        log.info("originalDetailList: {}", (Object)JSON.toJSONString((Object)originalDetailList));
        ArrayList notOutInNoticeStatusList = Lists.newArrayList();
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.ONO_CANCEL.getCode());
        notOutInNoticeStatusList.add(BaseOrderStatusEnum.INO_CANCEL.getCode());
        List inOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).notIn((Object)"order_status", (Collection)notOutInNoticeStatusList)).list();
        log.info("inOutNoticeOrderEos: {}", (Object)JSON.toJSONString((Object)inOutNoticeOrderEos));
        Map<String, List<InOutNoticeOrderEo>> outInOrderMap = inOutNoticeOrderEos.stream().collect(Collectors.groupingBy(InOutNoticeOrderEo::getOrderType));
        Map<String, List<InOutNoticeOrderDetailEo>> outInorderDetailMap = ((ExtQueryChainWrapper)this.inOutNoticeOrderDetailDomain.filter().in((Object)"document_no", (Collection)inOutNoticeOrderEos.stream().map(InOutNoticeOrderEo::getDocumentNo).collect(Collectors.toList()))).list().stream().collect(Collectors.groupingBy(InOutNoticeOrderDetailEo::getDocumentNo));
        log.info("outInorderDetailMap: {}", (Object)JSON.toJSONString(outInorderDetailMap));
        Map orderDetailEoMap = originalDetailList.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity(), (o, o1) -> o));
        String flag = "__";
        Map orderBatchDetailEoMap = originalDetailList.stream().collect(Collectors.toMap(t -> t.getId() + flag + t.getSkuCode() + flag + (dispatchOrderBatch ? t.getBatch() : ""), Function.identity(), (o, o1) -> o));
        log.info("\u8c03\u62e8\u56de\u5199\u539f\u59cb\u6279\u6b21\u660e\u7ec6orderBatchDetailEoMap:{}", (Object)JSONObject.toJSONString(orderBatchDetailEoMap));
        if (CollectionUtil.isNotEmpty((Collection)outInOrderMap.get("in"))) {
            List<InOutNoticeOrderEo> inNoticeOrderEos = outInOrderMap.get("in");
            Map<String, List<InOutResultOrderDetailEo>> inResultOrderDetailEoMap = this.fetchInResultMap(transferOrderNo, dispatchOrderBatch);
            log.info("\u67e5\u8be2\u51fa\u5165\u5e93\u7ed3\u679c\u8be6\u60c5inResultOrderDetailEoMap\uff1a{}", (Object)JSONObject.toJSONString(inResultOrderDetailEoMap));
            HashSet ids = new HashSet();
            List<TransferOrderDetailEo> newTransferDetails = inNoticeOrderEos.stream().flatMap(r -> ((List)outInorderDetailMap.get(r.getDocumentNo())).stream()).collect(Collectors.toMap(r -> r.getPreOrderItemId() + flag + r.getSkuCode() + flag + (dispatchOrderBatch ? r.getBatch() : "") + flag + r.getInventoryProperty(), Function.identity(), (o, o1) -> {
                o.setWaitQuantity(BigDecimalUtils.add((BigDecimal)o.getWaitQuantity(), (BigDecimal)o1.getWaitQuantity()));
                o.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
                o.setCancelQuantity(BigDecimalUtils.add((BigDecimal)o.getCancelQuantity(), (BigDecimal)o1.getCancelQuantity()));
                o.setPlanQuantity(BigDecimalUtils.add((BigDecimal)o.getPlanQuantity(), (BigDecimal)o1.getPlanQuantity()));
                return o;
            })).values().stream().map(r -> {
                TransferOrderDetailEo transferOrderDetailEo1 = (TransferOrderDetailEo)orderDetailEoMap.getOrDefault(r.getPreOrderItemId(), orderBatchDetailEoMap.get(r.getPreOrderItemId() + flag + r.getSkuCode() + flag + (dispatchOrderBatch ? r.getBatch() : "")));
                TransferOrderDetailEo transferOrderDetailEo = (TransferOrderDetailEo)BeanUtil.copyProperties((Object)transferOrderDetailEo1, TransferOrderDetailEo.class, (String[])new String[0]);
                if (!ids.add(transferOrderDetailEo.getId())) {
                    transferOrderDetailEo.setId(null);
                }
                BigDecimal ratio = ratioMap.getOrDefault(r.getSkuCode(), BigDecimal.ONE);
                BigDecimal toRatio = toRatioMap.getOrDefault(r.getSkuCode(), BigDecimal.ONE);
                transferOrderDetailEo.setExpireTime((Date)DataExtractUtils.ifNullElse((Object)transferOrderDetailEo1.getExpireTime(), (Object)r.getExpireTime()));
                transferOrderDetailEo.setProduceTime((Date)DataExtractUtils.ifNullElse((Object)transferOrderDetailEo1.getProduceTime(), (Object)r.getProduceTime()));
                transferOrderDetailEo.setBatch(r.getBatch());
                transferOrderDetailEo.setWaitInQuantity(UnitTransferUtils.pareSaleNum(r.getWaitQuantity(), ratio, toRatio));
                transferOrderDetailEo.setDoneOutQuantity(UnitTransferUtils.pareSaleNum(r.getPlanQuantity(), ratio, toRatio));
                BigDecimal doneQuantity = r.getDoneQuantity();
                List detailEos = (List)inResultOrderDetailEoMap.get(r.getPreOrderItemId() + flag + r.getSkuCode() + flag + (dispatchOrderBatch ? r.getBatch() : "") + flag + r.getInventoryProperty());
                if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                    doneQuantity = detailEos.stream().map(e -> e.getDoneQuantity()).reduce(BigDecimal.ZERO, BigDecimal::add);
                    Map<String, InOutResultOrderDetailEo> dispatcherStatusMap = this.getDispatcherStatusMap(detailEos);
                    InOutResultOrderDetailEo moreInOutResultOrderDetailEo = dispatcherStatusMap.get(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                    if (Objects.nonNull(moreInOutResultOrderDetailEo)) {
                        doneQuantity = doneQuantity.add(moreInOutResultOrderDetailEo.getDispatcherQuantity());
                        InOutResultOrderDetailEo lessInOutResultOrderDetailEo = dispatcherStatusMap.get(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                        doneQuantity = doneQuantity.add(Objects.nonNull(lessInOutResultOrderDetailEo) ? lessInOutResultOrderDetailEo.getDispatcherQuantity() : BigDecimal.ZERO);
                    }
                }
                transferOrderDetailEo.setDoneInQuantity(UnitTransferUtils.pareSaleNum(doneQuantity, ratio, toRatio));
                transferOrderDetailEo.setWaitOutQuantity(BigDecimal.ZERO);
                return transferOrderDetailEo;
            }).collect(Collectors.toList());
            newTransferDetails.forEach(item -> {
                TransferOrderDetailEo originalDetail = (TransferOrderDetailEo)orderBatchDetailEoMap.get(item.getId() + flag + item.getSkuCode() + flag + (dispatchOrderBatch ? item.getBatch() : ""));
                if (originalDetail != null) {
                    item.setQuantity(originalDetail.getQuantity());
                }
            });
            newTransferDetails.forEach(r -> {
                TransferOrderDetailEo cfr_ignored_0 = (TransferOrderDetailEo)orderDetailEoMap.remove(r.getId());
            });
            if (!orderDetailEoMap.isEmpty()) {
                newTransferDetails.addAll(orderDetailEoMap.values());
            }
            log.info("\u8c03\u62e8\u5355\u56de\u5199newTransferDetails:{}", (Object)JSONObject.toJSONString(newTransferDetails));
            this.deleteByTransferOrderNo(transferOrderNo);
            if (isEnd) {
                newTransferDetails.forEach(item -> {
                    List detailEos = (List)inResultOrderDetailEoMap.get(item.getSkuCode() + flag + (dispatchOrderBatch ? StringUtils.upperCase((String)item.getBatch()) : "") + flag + item.getInventoryProperty());
                    if (CollectionUtils.isNotEmpty((Collection)detailEos)) {
                        Map<String, InOutResultOrderDetailEo> dispatcherStatusMap = this.getDispatcherStatusMap(detailEos);
                        InOutResultOrderDetailEo moreInOutResultOrderDetailEo = dispatcherStatusMap.get(CsTransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                        InOutResultOrderDetailEo lessInOutResultOrderDetailEo = dispatcherStatusMap.get(CsTransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                        if (Objects.nonNull(moreInOutResultOrderDetailEo) && Objects.nonNull(lessInOutResultOrderDetailEo)) {
                            item.setDispatcherStatus(TransferDispatcherStatusEnum.DISPATCHER.getCode());
                            item.setDispatcherQuantity(moreInOutResultOrderDetailEo.getDispatcherQuantity());
                            item.setDispatcherLessQuantity(lessInOutResultOrderDetailEo.getDispatcherQuantity());
                            return;
                        }
                    }
                    if (item.getQuantity() != null && item.getDoneInQuantity() != null) {
                        if (item.getQuantity().compareTo(item.getDoneInQuantity()) > 0) {
                            item.setDispatcherStatus(TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                            item.setDispatcherQuantity(BigDecimal.ZERO);
                            item.setDispatcherLessQuantity(item.getDoneInQuantity().subtract(item.getQuantity()));
                        } else if (item.getQuantity().compareTo(item.getDoneInQuantity()) == 0) {
                            item.setDispatcherStatus(TransferDispatcherStatusEnum.NO_DISPATCHER.getCode());
                            item.setDispatcherQuantity(BigDecimal.ZERO);
                            item.setDispatcherLessQuantity(BigDecimal.ZERO);
                        } else if (item.getQuantity().compareTo(item.getDoneInQuantity()) < 0) {
                            item.setDispatcherStatus(TransferDispatcherStatusEnum.MORE_DISPATCHER.getCode());
                            item.setDispatcherQuantity(item.getDoneInQuantity().subtract(item.getQuantity()));
                            item.setDispatcherLessQuantity(BigDecimal.ZERO);
                        }
                    } else if (item.getQuantity() != null) {
                        item.setDispatcherStatus(TransferDispatcherStatusEnum.LESS_DISPATCHER.getCode());
                        item.setDispatcherQuantity(BigDecimal.ZERO);
                        item.setDispatcherLessQuantity(item.getQuantity());
                    }
                });
            }
            this.insertBatch(newTransferDetails);
        }
        return "";
    }

    private Map<String, InOutResultOrderDetailEo> getDispatcherStatusMap(List<InOutResultOrderDetailEo> detailEos) {
        Map<String, InOutResultOrderDetailEo> dispatcherStatusMap = detailEos.stream().collect(Collectors.toMap(r -> r.getDispatcherStatus(), Function.identity(), (o, o1) -> {
            InOutResultOrderDetailEo detailEo = new InOutResultOrderDetailEo();
            BeanUtil.copyProperties((Object)o, (Object)detailEo, (String[])new String[0]);
            detailEo.setWaitQuantity(BigDecimalUtils.add((BigDecimal)o.getWaitQuantity(), (BigDecimal)o1.getWaitQuantity()));
            detailEo.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
            detailEo.setCancelQuantity(BigDecimalUtils.add((BigDecimal)o.getCancelQuantity(), (BigDecimal)o1.getCancelQuantity()));
            detailEo.setPlanQuantity(BigDecimalUtils.add((BigDecimal)o.getPlanQuantity(), (BigDecimal)o1.getPlanQuantity()));
            detailEo.setDispatcherQuantity(BigDecimalUtils.add((BigDecimal)o.getDispatcherQuantity(), (BigDecimal)o1.getDispatcherQuantity()));
            return detailEo;
        }));
        return dispatcherStatusMap;
    }

    public Map<String, List<InOutResultOrderDetailEo>> fetchInResultMap(String transferOrderNo, boolean dispatchOrderBatch) {
        List inOutResultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)"in")).eq((Object)"order_status", (Object)"iro_done_in")).list();
        log.info("\u67e5\u8be2\u8c03\u62e8\u5355\u5bf9\u5e94\u5165\u5e93\u7ed3\u679c\u5355\u4fe1\u606f: {}", (Object)JSON.toJSONString((Object)inOutResultOrderEoList));
        if (CollectionUtil.isEmpty((Collection)inOutResultOrderEoList)) {
            return new HashMap<String, List<InOutResultOrderDetailEo>>();
        }
        Map<String, List<InOutResultOrderDetailEo>> outInResultOrderDetailMap = ((ExtQueryChainWrapper)this.inOutResultOrderDetailDomain.filter().in((Object)"document_no", (Collection)inOutResultOrderEoList.stream().map(InOutResultOrderEo::getDocumentNo).collect(Collectors.toList()))).list().stream().collect(Collectors.groupingBy(InOutResultOrderDetailEo::getDocumentNo));
        String flag = "__";
        return inOutResultOrderEoList.stream().flatMap(r -> ((List)outInResultOrderDetailMap.get(r.getDocumentNo())).stream()).collect(Collectors.groupingBy(r -> r.getPreOrderItemId() + flag + r.getSkuCode() + flag + (dispatchOrderBatch ? r.getBatch() : "") + flag + r.getInventoryProperty()));
    }

    @Override
    public void updateTransferOrderDetailDispatcher(TransferOrderDetailEo dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderDetailEo detailEo = new TransferOrderDetailEo();
        detailEo.setId(dto.getId());
        detailEo.setDispatcherQuantity(dto.getDispatcherQuantity());
        detailEo.setDispatcherLessQuantity(dto.getDispatcherLessQuantity());
        detailEo.setDispatcherStatus(dto.getDispatcherStatus());
        this.das.updateSelective((BaseEo)detailEo);
    }

    @Override
    public void updateTransferOrderDetailQuantity(List<ReceiveDeliveryResultOrderDetailEo> receiveDeliveryResultOrderDetailEoList, TransferOrderEo transferOrderEo) {
        Map<Long, List<ReceiveDeliveryResultOrderDetailEo>> resultOrderDetailMap = receiveDeliveryResultOrderDetailEoList.stream().collect(Collectors.groupingBy(e -> e.getPreOrderItemId()));
        List detailEoList = ((ExtQueryChainWrapper)this.das.filter().eq((Object)"transfer_order_no", (Object)transferOrderEo.getTransferOrderNo())).list();
        for (TransferOrderDetailEo detailEo : detailEoList) {
            if (resultOrderDetailMap.isEmpty() || Objects.isNull(resultOrderDetailMap.get(detailEo.getId()))) continue;
            List<ReceiveDeliveryResultOrderDetailEo> list = resultOrderDetailMap.get(detailEo.getId());
            BigDecimal doneOutQuantity = BigDecimal.ZERO;
            BigDecimal doneInQuantity = BigDecimal.ZERO;
            for (ReceiveDeliveryResultOrderDetailEo resultOrderDetailEo : list) {
                if (resultOrderDetailEo.getDocumentNo().contains("DS")) {
                    doneOutQuantity = BigDecimalUtils.add((BigDecimal)doneOutQuantity, (BigDecimal)resultOrderDetailEo.getDoneQuantity());
                    continue;
                }
                doneInQuantity = BigDecimalUtils.add((BigDecimal)doneInQuantity, (BigDecimal)resultOrderDetailEo.getDoneQuantity());
            }
            detailEo.setDoneInQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneInQuantity(), (BigDecimal)doneInQuantity));
            detailEo.setDoneOutQuantity(BigDecimalUtils.add((BigDecimal)detailEo.getDoneOutQuantity(), (BigDecimal)doneOutQuantity));
            BigDecimal waitInQuantity = BigDecimalUtils.eqZero((BigDecimal)detailEo.getWaitInQuantity()) != false ? detailEo.getQuantity() : detailEo.getWaitInQuantity();
            BigDecimal waitOutQuantity = BigDecimalUtils.eqZero((BigDecimal)detailEo.getWaitOutQuantity()) != false ? detailEo.getQuantity() : detailEo.getWaitOutQuantity();
            detailEo.setWaitInQuantity(BigDecimalUtils.subtract((BigDecimal)waitInQuantity, (BigDecimal)detailEo.getDoneInQuantity()));
            detailEo.setWaitOutQuantity(BigDecimalUtils.subtract((BigDecimal)waitOutQuantity, (BigDecimal)detailEo.getDoneOutQuantity()));
        }
        this.das.getMapper().updateBatchByIds(detailEoList);
    }

    @Override
    public void deleteByTransferOrderNos(List<String> orderNos) {
        this.das.deleteByTransferOrderNos(orderNos);
    }
}

