/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONArray;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.vo.BaseVo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.enums.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.constants.TransferOrderTypeEnum;
import com.yunxi.dg.base.center.inventory.dao.das.ITransferOrderDas;
import com.yunxi.dg.base.center.inventory.domain.entity.IInOutResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.IReceiveDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDetailDomain;
import com.yunxi.dg.base.center.inventory.domain.entity.ITransferOrderDomain;
import com.yunxi.dg.base.center.inventory.domain.utils.UnitTransferUtils;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderComboReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderDetailReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderKeyDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.transfer.TransferOrderSearchDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderPageDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.TransferOrderRespDto;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.TransferOrderEo;
import com.yunxi.dg.base.center.inventory.utils.AssertUtil;
import com.yunxi.dg.base.center.inventory.utils.DataExtractUtils;
import com.yunxi.dg.base.center.state.TransferOrderStatus;
import com.yunxi.dg.base.center.state.approval.TransferOrderApprovalState;
import com.yunxi.dg.base.center.state.delivery.TransferOrderDeliveryState;
import com.yunxi.dg.base.center.state.receive.TransferOrderReceiveState;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TransferOrderDomainImpl
extends BaseDomainImpl<TransferOrderEo>
implements ITransferOrderDomain {
    @Resource
    private ITransferOrderDas das;
    @Resource
    private ITransferOrderDetailDomain transferOrderDetailDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDomain receiveDeliveryResultOrderDomain;
    @Autowired
    private IInOutResultOrderDomain inOutResultOrderDomain;
    @Autowired
    private IReceiveDeliveryResultOrderDetailDomain receiveDeliveryResultOrderDetailDomain;
    @Autowired
    private IReceiveDeliveryNoticeOrderDomain receiveDeliveryNoticeOrderDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;

    public ICommonDas<TransferOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public void checkSelfParam(TransferOrderComboReqDto dto) {
        TransferOrderReqDto reqDto = dto.getTransferOrderReqDto();
        if (TransferOrderDomainImpl.containsChinese(dto.getTransferOrderReqDto().getType())) {
            Optional.ofNullable(TransferOrderTypeEnum.getEnumByLabel((String)dto.getTransferOrderReqDto().getType())).ifPresent(r -> dto.getTransferOrderReqDto().setType(r.getCode()));
        }
        if (Objects.nonNull(reqDto.getReturnInWarehouse()) && reqDto.getReturnInWarehouse() == 1) {
            AssertUtil.isTrue((boolean)StringUtils.isNotBlank((CharSequence)reqDto.getBorrowTransferOrderNo()), (String)"\u539f\u8c03\u51fa\u8c03\u62e8\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List detailList = dto.getDetailList();
        AssertUtil.isTrue((boolean)CollectionUtil.isNotEmpty((Collection)detailList), (String)"\u53c2\u6570\u9519\u8bef,\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
        for (TransferOrderDetailReqDto d : detailList) {
            AssertUtil.isTrue((d.getQuantity().compareTo(BigDecimal.ZERO) > 0 ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u91cf\u5fc5\u987b\u5927\u4e8e0");
            AssertUtil.isTrue((StringUtils.isNotBlank((CharSequence)d.getLongCode()) || StringUtils.isNotBlank((CharSequence)d.getSkuCode()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            d.setSkuCode((String)DataExtractUtils.ifNullElse((Object)d.getSkuCode(), (Object)d.getLongCode()));
        }
    }

    public static boolean containsChinese(String str) {
        return str.matches(".*[\u4e00-\u9fa5].*");
    }

    @Override
    public void isOrderCancelable(TransferOrderEo transferOrderEo) {
        boolean isCancelable = TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderReceiveState.WAITING_FOR_DELIVERY.getCode().equals(transferOrderEo.getDeliveryStatus());
        AssertUtils.isTrue((boolean)isCancelable, (String)"\u5f53\u524d\u8c03\u62e8\u5355\u6682\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c");
    }

    @Override
    public void isOrderCanCommit(TransferOrderEo transferOrderEo) {
        boolean isCanCommit = TransferOrderStatus.PENDING.code().equals(transferOrderEo.getOrderStatus()) || TransferOrderStatus.APPROVAL_REJECT.code().equals(transferOrderEo.getOrderStatus());
        AssertUtils.isTrue((boolean)isCanCommit, (String)"\u5f53\u524d\u8c03\u62e8\u5355\u6682\u4e0d\u5141\u8bb8\u6b64\u64cd\u4f5c");
    }

    @Override
    public TransferOrderRespDto queryByTransferOrderNo(String transferOrderNo) {
        TransferOrderEo condition = new TransferOrderEo();
        condition.setTransferOrderNo(transferOrderNo);
        condition.setDr(0);
        TransferOrderEo targetEo = (TransferOrderEo)this.das.selectOne((BaseEo)condition);
        AssertUtils.notNull((Object)targetEo, (String)"\u67e5\u8be2\u4e0d\u5230\u76ee\u6807\u8c03\u62e8\u5355");
        TransferOrderRespDto respDto = new TransferOrderRespDto();
        DtoHelper.eo2Dto((BaseEo)targetEo, (BaseVo)respDto);
        return respDto;
    }

    @Override
    public void canOrderBeCompleted(TransferOrderEo transferOrderEo) {
        this.checkHangup(transferOrderEo);
        boolean isAllShipped = TransferOrderDeliveryState.DELIVERED.getCode().equals(transferOrderEo.getShipmentStatus()) || TransferOrderDeliveryState.PARTIALLY_DELIVERED_CLOSED.getCode().equals(transferOrderEo.getShipmentStatus());
        AssertUtils.isTrue((boolean)isAllShipped, (String)"\u8c03\u62e8\u5355\u672a\u5168\u90e8\u53d1\u8d27\uff0c\u4e0d\u53ef\u5b8c\u7ed3");
        boolean isAllReceived = TransferOrderReceiveState.RECEIVED.getCode().equals(transferOrderEo.getDeliveryStatus());
        AssertUtils.isFalse((boolean)isAllReceived, (String)"\u8c03\u62e8\u5355\u5df2\u5168\u90e8\u6536\u8d27\uff0c\u4e0d\u53ef\u5b8c\u7ed3");
    }

    private void checkHangup(TransferOrderEo transferOrderEo) {
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.inOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderEo.getTransferOrderNo())).in((Object)"order_status", (Collection)Lists.newArrayList((Object[])new String[]{BaseOrderStatusEnum.IRO_HANG_UP.getCode(), BaseOrderStatusEnum.ORO_HANG_UP.getCode()}))).list();
        AssertUtils.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u5b58\u5728\u6302\u8d77\u5355\u636e, \u8bf7\u5148\u5904\u7406\u6302\u8d77\u5355\u636e");
    }

    @Override
    public void canOrderBeClosed(TransferOrderEo transferOrderEo) {
        this.checkHangup(transferOrderEo);
        boolean isPartiallyShipped = TransferOrderDeliveryState.PARTIALLY_DELIVERED.getCode().equals(transferOrderEo.getShipmentStatus());
        AssertUtils.isTrue((boolean)isPartiallyShipped, (String)"\u8c03\u62e8\u5355\u4e0d\u662f\u90e8\u5206\u53d1\u8d27\u72b6\u6001\uff0c\u4e0d\u53ef\u5173\u95ed");
    }

    @Override
    public Integer doClosedCheck(String transferOrderNo) {
        List orderEos = ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).list();
        if (CollectionUtils.isEmpty((Collection)orderEos)) {
            return 0;
        }
        Map inOutMap = orderEos.stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderEo::getOrderType, Collectors.mapping(ReceiveDeliveryResultOrderEo::getDocumentNo, Collectors.toList())));
        if (inOutMap.keySet().size() < 2) {
            return 0;
        }
        Map<String, BigDecimal> ratioMap = this.getRecordByCode(transferOrderNo).stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum(), (int)6), (o, o1) -> o));
        Map<String, List<ReceiveDeliveryResultOrderDetailEo>> detailMap = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", (Collection)orderEos.stream().map(ReceiveDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList()))).eq((Object)"relevance_no", (Object)transferOrderNo)).list().stream().collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getDocumentNo));
        List delivery = inOutMap.get("delivery");
        List receive = inOutMap.get("receive");
        Map<Long, BigDecimal> deliveryDetail = delivery.stream().flatMap(d -> ((List)detailMap.get(d)).stream()).collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getPreOrderItemId, Collectors.mapping(r -> BigDecimalUtils.divide((BigDecimal)r.getQuantity(), (BigDecimal)ratioMap.getOrDefault(r.getSkuCode(), BigDecimal.ONE), (int)6), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        Map<Long, BigDecimal> receiveDetail = receive.stream().flatMap(d -> ((List)detailMap.get(d)).stream()).collect(Collectors.groupingBy(ReceiveDeliveryResultOrderDetailEo::getPreOrderItemId, Collectors.mapping(r -> BigDecimalUtils.divide((BigDecimal)r.getQuantity(), (BigDecimal)ratioMap.getOrDefault(r.getSkuCode(), BigDecimal.ONE), (int)6), Collectors.reducing(BigDecimal.ZERO, BigDecimal::add))));
        if (receiveDetail.keySet().size() < deliveryDetail.keySet().size()) {
            return 0;
        }
        for (Map.Entry<Long, BigDecimal> longBigDecimalEntry : deliveryDetail.entrySet()) {
            if (receiveDetail.get(longBigDecimalEntry.getKey()).compareTo(longBigDecimalEntry.getValue()) >= 0) continue;
            return 0;
        }
        return 1;
    }

    @Override
    public void canOrderBeCanceled(TransferOrderEo transferOrderEo) {
        boolean isPending = TransferOrderStatus.PENDING.code().equals(transferOrderEo.getOrderStatus());
        boolean isApproval = TransferOrderApprovalState.PRIMARY_PENDING.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderApprovalState.PRIMARY_REJECTED.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderApprovalState.SECONDARY_REJECTED.getCode().equals(transferOrderEo.getApprovalStatus());
        boolean isWaitingForShip = TransferOrderDeliveryState.WAITING_FOR_DELIVERY.getCode().equals(transferOrderEo.getShipmentStatus());
        AssertUtils.isTrue((isPending || isApproval || isWaitingForShip ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355\u5df2\u53d1\u8d27\uff0c\u4e0d\u53ef\u53d6\u6d88");
    }

    @Override
    public TransferOrderEo selectByBizKey(TransferOrderKeyDto keyDto) {
        TransferOrderEo eo;
        if (StringUtils.isNotBlank((CharSequence)keyDto.getPreOrderNo()) && (eo = (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"pre_order_no", (Object)keyDto.getPreOrderNo())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"id")).last(" limit 1")).one()) != null) {
            return eo;
        }
        AssertUtils.isTrue((Objects.isNull(keyDto.getId()) || StringUtils.isBlank((CharSequence)keyDto.getTransferOrderNo()) ? 1 : 0) != 0, (String)"\u8c03\u62e8\u5355id\u6216\u5355\u53f7\uff0c\u5fc5\u586b\u5176\u4e00\u3002");
        if (Objects.nonNull(keyDto.getId())) {
            return (TransferOrderEo)this.das.selectByPrimaryKey(keyDto.getId());
        }
        return (TransferOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"transfer_order_no", (Object)keyDto.getTransferOrderNo())).eq((Object)"dr", (Object)0)).orderByDesc((Object)"id")).last(" limit 1")).one();
    }

    @Override
    public List<TransferOrderPageDto> selectPageList(TransferOrderSearchDto dto) {
        return this.das.selectPageList(dto);
    }

    @Override
    public boolean isAllShip(String transferOrderNo) {
        return this.hasAll(transferOrderNo, "delivery");
    }

    private boolean hasAll(String transferOrderNo, String delivery) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)delivery)).in((Object)"order_status", new Object[]{BaseOrderStatusEnum.DNO_TOTAL_DELIVERY.getCode(), BaseOrderStatusEnum.RNO_TOTAL_RECEIVE.getCode()})).count() > 0;
    }

    @Override
    public boolean isFinishShip(String transferOrderNo) {
        return this.isFinishShip(transferOrderNo, "delivery");
    }

    public boolean isFinishShip(String transferOrderNo, String delivery) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)delivery)).ne((Object)"order_status", (Object)BaseOrderStatusEnum.FINISH_OVER.getCode())).count() <= 0;
    }

    @Override
    public boolean isFinishReceive(String transferOrderNo) {
        return this.isFinishShip(transferOrderNo, "receive");
    }

    @Override
    public BigDecimal getResultOrderNumber(String transferOrderNo, String type) {
        List resultOrderEoList = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDomain.filter().eq((Object)"relevance_no", (Object)transferOrderNo)).eq((Object)"order_type", (Object)type)).list();
        List<OrderUnitConversionRecordEo> orderUnitConversionRecordEos = this.getRecordByCode(transferOrderNo);
        Map<String, BigDecimal> ratioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getToNum(), (BigDecimal)r.getNum()), (o, o1) -> o));
        Map<String, BigDecimal> toRatioMap = orderUnitConversionRecordEos.stream().collect(Collectors.toMap(OrderUnitConversionRecordEo::getSkuCode, r -> BigDecimalUtils.divide((BigDecimal)r.getNum(), (BigDecimal)r.getToNum()), (o, o1) -> o));
        return Optional.ofNullable(resultOrderEoList).filter(CollectionUtils::isNotEmpty).map(r -> {
            BigDecimal[] total = new BigDecimal[]{BigDecimal.ZERO};
            ((ExtQueryChainWrapper)this.receiveDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", (Collection)resultOrderEoList.stream().map(ReceiveDeliveryResultOrderEo::getDocumentNo).collect(Collectors.toList()))).list().forEach(d -> {
                BigDecimal ratio = (BigDecimal)ratioMap.get(d.getSkuCode());
                BigDecimal toRatio = (BigDecimal)toRatioMap.get(d.getSkuCode());
                total[0] = Objects.nonNull(ratio) ? total[0].add(UnitTransferUtils.pareSaleNum(d.getDoneQuantity(), ratio, toRatio)) : total[0].add(d.getDoneQuantity());
            });
            return total[0];
        }).orElse(BigDecimal.ZERO);
    }

    private List<OrderUnitConversionRecordEo> getRecordByCode(String transferOrderNo) {
        List unitConversionRecordEos = Optional.ofNullable(transferOrderNo).map(r -> ServiceContext.getContext().getAttachment("orderUnitCacheKey__" + r)).filter(StringUtils::isNotBlank).map(r -> JSONArray.parseArray((String)r, OrderUnitConversionRecordEo.class)).orElseGet(() -> ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().eq((Object)"document_code", (Object)transferOrderNo)).list());
        return unitConversionRecordEos;
    }

    @Override
    public boolean isAllReceive(String transferOrderNo) {
        return this.hasAll(transferOrderNo, "receive");
    }

    @Override
    public boolean isCanAudit(TransferOrderEo transferOrderEo) {
        return TransferOrderApprovalState.PRIMARY_PENDING.getCode().equals(transferOrderEo.getApprovalStatus()) || TransferOrderApprovalState.PRIMARY_APPROVED_PENDING_SECONDARY.getCode().equals(transferOrderEo.getApprovalStatus());
    }

    @Override
    public void param(TransferOrderSearchDto dto) {
    }

    @Override
    public void updateStatusById(Long id, String status, String remark) {
        TransferOrderEo transferOrderEo = new TransferOrderEo();
        transferOrderEo.setId(id);
        transferOrderEo.setOrderStatus(status);
        transferOrderEo.setRemark(remark);
        this.das.updateSelective((BaseEo)transferOrderEo);
    }

    @Override
    public void updateTransferOrderDispatcher(TransferOrderEo transferOrderEo) {
        AssertUtils.notNull((Object)transferOrderEo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        TransferOrderEo updateEo = new TransferOrderEo();
        updateEo.setId(transferOrderEo.getId());
        updateEo.setDispatcherStatus(transferOrderEo.getDispatcherStatus());
        updateEo.setDispatcherHandleStatus(transferOrderEo.getDispatcherHandleStatus());
        updateEo.setOverchargeQuantity(transferOrderEo.getOverchargeQuantity());
        updateEo.setReceivelessQuantity(transferOrderEo.getReceivelessQuantity());
        this.das.updateSelective((BaseEo)updateEo);
    }
}

