/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.inventory.dao.das.ILogicInventoryTotalDas;
import com.yunxi.dg.base.center.inventory.domain.entity.ILogicInventoryTotalDomain;
import com.yunxi.dg.base.center.inventory.dto.calc.CalcUpdateInventoryDto;
import com.yunxi.dg.base.center.inventory.dto.domain.LogicSupplyInventoryVo;
import com.yunxi.dg.base.center.inventory.eo.LogicInventoryTotalEo;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service
public class LogicInventoryTotalDomainImpl
extends BaseDomainImpl<LogicInventoryTotalEo>
implements ILogicInventoryTotalDomain {
    private static final Logger log = LoggerFactory.getLogger(LogicInventoryTotalDomainImpl.class);
    @Autowired
    ILogicInventoryTotalDas das;
    @Autowired
    private DataSource dataSource;
    @Autowired
    private ICacheService cacheService;
    @Autowired
    private PlatformTransactionManager transactionManager;

    public ICommonDas<LogicInventoryTotalEo> commonDas() {
        return this.das;
    }

    @Override
    public List<LogicInventoryTotalEo> queryByWarehouseCodesAndSkuCodes(List<String> warehouseCodes, List<String> skuCodes) {
        if (CollectionUtil.isEmpty(warehouseCodes)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).in(LogicInventoryTotalEo::getWarehouseCode, warehouseCodes)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryTotalEo::getSkuCode, skuCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public List<LogicInventoryTotalEo> queryByWarehouseCodeAndSkuCodes(String warehouseCode, List<String> skuCodes) {
        if (CollectionUtil.isEmpty(skuCodes) || StringUtils.isBlank((CharSequence)warehouseCode)) {
            return Lists.newArrayList();
        }
        return this.das.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(LogicInventoryTotalEo.class).eq(LogicInventoryTotalEo::getWarehouseCode, (Object)warehouseCode)).in(CollectionUtil.isNotEmpty(skuCodes), LogicInventoryTotalEo::getSkuCode, skuCodes)).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
    }

    @Override
    public void updateInventory(List<CalcUpdateInventoryDto> voList) {
        log.info("updateInventory-voList:{}", (Object)JSON.toJSONString(voList));
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        try {
            this.das.updateInventory(voList);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("logic total updateInventory exception:{}", (Object)JSON.toJSONString((Object)e));
            throw new WarehouseAbleException("logic total updateInventory exception...", new Object[0]);
        }
    }

    @Override
    public int batchIgnoreInsert(List<LogicInventoryTotalEo> eoList) {
        return this.das.batchIgnoreInsert(eoList);
    }

    @Override
    public List<LogicSupplyInventoryVo> queryLogicSupplyInventory(List<String> warehouseCodes, List<String> cargoCodes) {
        return this.das.queryLogicSupplyInventory(warehouseCodes, cargoCodes);
    }

    @Override
    public List<LogicInventoryTotalEo> queryByWarehouseCodesAndSkuCodes(List<String> warehouseCodes, List<String> skuCodes, List<String> inventoryPropertyList) {
        return this.das.queryLogicSupplyInventory(warehouseCodes, skuCodes, inventoryPropertyList);
    }

    @Override
    public List<LogicInventoryTotalEo> batchIgnoreInsertNew(List<LogicInventoryTotalEo> eoList) {
        log.info("\u8fdb\u5165\u521d\u59cb\u5316\u4fdd\u5b581:{}", (Object)JSONObject.toJSONString(eoList));
        Map inventoryEoMap = eoList.stream().collect(Collectors.toMap(this::getTotalKey, Function.identity(), (o, o1) -> o));
        List<LogicInventoryTotalEo> inventoryEos = inventoryEoMap.entrySet().stream().filter(r -> {
            String key = (String)r.getKey();
            if (this.cacheService.setIfAbsent(LogicInventoryTotalDomainImpl.getFilterCacheKey() + key, (Object)((LogicInventoryTotalEo)r.getValue()).getId()).booleanValue()) {
                this.cacheService.setCache(LogicInventoryTotalDomainImpl.getWaitProcessKey() + key, (Object)JSONObject.toJSONString(r.getValue()), 3600);
                return true;
            }
            return false;
        }).map(Map.Entry::getValue).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(inventoryEos)) {
            return inventoryEos;
        }
        log.info("\u8fdb\u5165\u521d\u59cb\u5316\u4fdd\u5b582:{}", (Object)JSONObject.toJSONString(eoList));
        TransactionTemplate transactionTemplate = new TransactionTemplate(this.transactionManager);
        transactionTemplate.setIsolationLevel(2);
        transactionTemplate.setPropagationBehavior(3);
        Integer execute = (Integer)transactionTemplate.execute(s -> {
            try {
                this.doBatchInsert(inventoryEos);
            }
            catch (Exception e) {
                return 0;
            }
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getWaitProcessKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
            return 1;
        });
        if (Objects.equals(0, execute)) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getFilterCacheKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
        }
        return inventoryEos;
    }

    private void doBatchInsert(List<LogicInventoryTotalEo> inventoryEos) {
        try {
            int i = this.das.insertBatch(inventoryEos);
            log.debug("\u5904\u7406\u6210\u529f\u6570\u91cf" + i);
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getWaitProcessKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
        }
        catch (Exception e) {
            inventoryEos.forEach(r -> this.cacheService.delCache(LogicInventoryTotalDomainImpl.getFilterCacheKey() + this.getTotalKey((LogicInventoryTotalEo)r)));
            log.error("\u5e93\u5b58\u884c\u521d\u59cb\u5316\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    @NotNull
    private String getTotalKey(LogicInventoryTotalEo r) {
        return String.join((CharSequence)"__", r.getWarehouseCode(), r.getSkuCode(), r.getInventoryProperty());
    }

    private int executeInsert(List<LogicInventoryTotalEo> eoList, Connection connection, StringBuilder sqlBuilder) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(sqlBuilder.toString());
        for (LogicInventoryTotalEo eo : eoList) {
            int index = 1;
            preparedStatement.setLong(index++, eo.getId());
            preparedStatement.setLong(index++, eo.getWarehouseId());
            preparedStatement.setString(index++, eo.getWarehouseCode());
            preparedStatement.setString(index++, eo.getWarehouseName());
            preparedStatement.setString(index++, eo.getInventoryProperty());
            preparedStatement.setString(index++, eo.getSkuCode());
            preparedStatement.setString(index++, eo.getSkuName());
            preparedStatement.setBigDecimal(index++, eo.getBalance());
            preparedStatement.setBigDecimal(index++, eo.getPreempt());
            preparedStatement.setBigDecimal(index++, eo.getAllocate());
            preparedStatement.setBigDecimal(index++, eo.getActivityAllocate());
            preparedStatement.setBigDecimal(index++, eo.getIntransit());
            preparedStatement.setBigDecimal(index++, eo.getTransfer());
            preparedStatement.setBigDecimal(index++, eo.getCompleted());
            preparedStatement.setBigDecimal(index++, eo.getFutureIn());
            preparedStatement.setBigDecimal(index++, eo.getFutureRetreat());
            preparedStatement.setBigDecimal(index++, eo.getAvailable());
            preparedStatement.setBigDecimal(index++, eo.getLockInventory());
            preparedStatement.setString(index++, eo.getRemark());
            preparedStatement.setString(index++, eo.getCreatePerson());
            preparedStatement.setString(index, eo.getUpdatePerson());
            preparedStatement.addBatch();
        }
        int[] ints = preparedStatement.executeBatch();
        return Arrays.stream(ints).reduce(0, Integer::sum);
    }

    @NotNull
    private static String getWaitProcessKey() {
        return "waitTotalInit:";
    }

    @NotNull
    private static String getFilterCacheKey() {
        return "batchTotalIgnoreInsertNew:";
    }
}

