/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.domain.utils;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.yunxi.dg.base.center.inventory.dao.mapper.OrderUnitConversionRecordMapper;
import com.yunxi.dg.base.center.inventory.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.OrderUnitConversionRecordDto;
import com.yunxi.dg.base.center.inventory.dto.unit.OrderUnitConverterDto;
import com.yunxi.dg.base.center.inventory.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Component;

@Component
public class UnitTransferUtils {
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private OrderUnitConversionRecordMapper orderUnitConversionRecordMapper;
    public static UnitTransferUtils self;
    public static final String ORDER_UNIT_CACHE_KEY = "orderUnitCacheKey";

    @PostConstruct
    private void init() {
        self = this;
        UnitTransferUtils.self.orderUnitConversionRecordDomain = this.orderUnitConversionRecordDomain;
        UnitTransferUtils.self.orderUnitConversionRecordMapper = this.orderUnitConversionRecordMapper;
    }

    public static BigDecimal pareSaleNum(BigDecimal quantity, BigDecimal ratio, BigDecimal toRatio) {
        return BigDecimalUtils.gt((BigDecimal)ratio, (BigDecimal)toRatio) != false ? BigDecimalUtils.divide((BigDecimal)quantity, (BigDecimal)ratio, (int)6) : BigDecimalUtils.multiply((BigDecimal)quantity, (BigDecimal)toRatio);
    }

    public static BigDecimal pareSaleNum(BigDecimal quantity, OrderUnitConversionRecordDto orderUnitConversionRecordDto, boolean toBase) {
        BigDecimal ratio = BeanUtil.isNotEmpty((Object)orderUnitConversionRecordDto, (String[])new String[0]) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getNum(), (BigDecimal)orderUnitConversionRecordDto.getToNum(), (int)6) : BigDecimal.ONE;
        BigDecimal toRatio = BeanUtil.isNotEmpty((Object)orderUnitConversionRecordDto, (String[])new String[0]) ? BigDecimalUtils.divide((BigDecimal)orderUnitConversionRecordDto.getToNum(), (BigDecimal)orderUnitConversionRecordDto.getNum(), (int)6) : BigDecimal.ONE;
        return toBase ? UnitTransferUtils.pareSaleNum(quantity, ratio, toRatio) : UnitTransferUtils.pareSaleNum(quantity, toRatio, ratio);
    }

    public static <T extends OrderUnitConverterDto> void unitConvertBySingleOrder(List<T> dtos, List<OrderUnitConversionRecordEo> unitConversionRecordEoList) {
        List documentCodeList = dtos.stream().map(OrderUnitConverterDto::getDocumentCode).collect(Collectors.toList());
        if (documentCodeList.isEmpty()) {
            return;
        }
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(UnitTransferUtils::getKey, Function.identity(), (o2, o1) -> o2));
        Map unitConversionBaseMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode(), Function.identity(), (o2, o1) -> o2));
        dtos.forEach(o -> {
            String key = UnitTransferUtils.getMatchKey(o);
            OrderUnitConversionRecordEo orDefault = (OrderUnitConversionRecordEo)unitConversionMap.getOrDefault(key, unitConversionBaseMap.get(key));
            if (Objects.nonNull(orDefault)) {
                UnitTransferUtils.conversOpt(o, orDefault);
                if (o.getConsumer() != null) {
                    o.getConsumer().accept(o);
                }
            }
        });
    }

    public static <T extends OrderUnitConverterDto> void unitConvertBatch(List<T> dtos) {
        List documentCodeList = dtos.stream().map(OrderUnitConverterDto::getDocumentCode).collect(Collectors.toList());
        if (documentCodeList.isEmpty()) {
            return;
        }
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)UnitTransferUtils.self.orderUnitConversionRecordDomain.filter().in((Object)"document_code", documentCodeList)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(UnitTransferUtils::getKey, Function.identity(), (o2, o1) -> o2));
        Map unitConversionBaseMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode(), Function.identity(), (o2, o1) -> o2));
        dtos.forEach(o -> {
            String key = UnitTransferUtils.getMatchKey(o);
            OrderUnitConversionRecordEo orDefault = (OrderUnitConversionRecordEo)unitConversionMap.getOrDefault(key, unitConversionBaseMap.get(key));
            if (Objects.nonNull(orDefault)) {
                UnitTransferUtils.conversOpt(o, orDefault);
                if (o.getConsumer() != null) {
                    o.getConsumer().accept(o);
                }
            }
        });
    }

    @NotNull
    private static <T extends OrderUnitConverterDto> String getMatchKey(T o) {
        return o.isBaseTo() ? o.getDocumentCode() + o.getSkuCode() : o.getDocumentCode() + o.getSkuCode() + o.getUnit();
    }

    private static void conversOpt(OrderUnitConverterDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        if (!dto.isConvedUnit()) {
            dto.setUnit(unitConversionEo.getUnit());
        }
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)unitConversionEo.getToNum(), (BigDecimal)unitConversionEo.getNum(), (int)6);
        BigDecimal toRate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : BigDecimalUtils.divide((BigDecimal)unitConversionEo.getNum(), (BigDecimal)unitConversionEo.getToNum(), (int)6);
        BigDecimal planQuantity = UnitTransferUtils.getParseQuantity(dto.getPlanQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal doneQuantity = UnitTransferUtils.getParseQuantity(dto.getDoneQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal waitQuantity = UnitTransferUtils.getParseQuantity(dto.getWaitQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal doneInQuantity = UnitTransferUtils.getParseQuantity(dto.getDoneInQuantity(), toRate, rate, dto.isBaseTo());
        BigDecimal quantity = UnitTransferUtils.getParseQuantity(dto.getQuantity(), toRate, rate, dto.isBaseTo());
        dto.setPlanQuantity(planQuantity);
        dto.setDoneQuantity(doneQuantity);
        dto.setWaitQuantity(waitQuantity);
        dto.setDoneInQuantity(doneInQuantity);
        dto.setQuantity(quantity);
    }

    @NotNull
    private static String getKey(OrderUnitConversionRecordEo o) {
        return o.getDocumentCode() + o.getSkuCode() + o.getUnit();
    }

    private static BigDecimal getParseQuantity(BigDecimal q, BigDecimal toRate, BigDecimal rate, boolean base) {
        return base ? UnitTransferUtils.pareSaleNum(q, rate, toRate) : UnitTransferUtils.pareSaleNum(q, toRate, rate);
    }
}

