/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.constants;

import com.yunxi.dg.base.commons.enums.IBaseEnum;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public enum TagTypeEnum implements IBaseEnum
{
    EXPIRY_DATE_TAG("EXPIRY_DATE_TAG", "\u6548\u671f\u6807\u7b7e"),
    QUALITY_INSPECTION_TAG("QUALITY_INSPECTION_TAG", "\u8d28\u68c0\u6807\u7b7e");

    private static final Map<String, TagTypeEnum> DOCUMENT_TYPE_HASHMAP;
    private String code;
    private String name;

    private TagTypeEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public static TagTypeEnum getByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return Arrays.asList(TagTypeEnum.values()).stream().filter(e -> e.getCode().equals(code)).findAny().orElse(null);
    }

    public static TagTypeEnum getTypeEnumByCode(String code) {
        return DOCUMENT_TYPE_HASHMAP.get(code);
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public IBaseEnum forEnum(String code) {
        return TagTypeEnum.getTypeEnumByCode(code);
    }

    public String forName(String code) {
        return TagTypeEnum.getTypeEnumByCode(code).getName();
    }

    static {
        DOCUMENT_TYPE_HASHMAP = new HashMap<String, TagTypeEnum>();
        for (TagTypeEnum typeEnum : TagTypeEnum.values()) {
            DOCUMENT_TYPE_HASHMAP.put(typeEnum.getCode(), typeEnum);
        }
    }
}

