/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc.baseorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.cube.utils.DateUtil;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.dict.dto.Schemas.DictDto;
import com.yunxi.dg.base.center.dict.proxy.query.IPcpDictQueryApiProxy;
import com.yunxi.dg.base.center.enums.CsRelevanceTableNameEnum;
import com.yunxi.dg.base.center.enums.DictEnum;
import com.yunxi.dg.base.center.enums.InspectionResultEnum;
import com.yunxi.dg.base.center.enums.LogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.domain.entity.IWaitInspectionRecordDomain;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InventoryBatchReqDto;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderDetailEo;
import com.yunxi.dg.base.center.inventory.eo.ReceiveDeliveryResultOrderEo;
import com.yunxi.dg.base.center.inventory.eo.WaitInspectionRecordEo;
import com.yunxi.dg.base.center.inventory.mqc.AbstractBaseCallBackConsumer;
import com.yunxi.dg.base.center.inventory.service.baseorder.constants.BaseOrderStatusEnum;
import com.yunxi.dg.base.center.inventory.service.baseorder.context.ReceiveDeliveryResultOrderContext;
import com.yunxi.dg.base.center.inventory.service.business.order.AbstractBusinessOrder;
import com.yunxi.dg.base.center.inventory.service.business.order.BusinessOrderStrategyFactory;
import com.yunxi.dg.base.center.inventory.service.entity.IInventoryBatchService;
import com.yunxi.dg.base.center.inventory.service.helper.data.ItemDataQueryHelperImpl;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@MQDesc(tag="inBack", msgType="publish", topic="YUNDT_CUBE_SINGLE_TOPIC")
@Component
public class TempInBackCallBackConsumer
extends AbstractBaseCallBackConsumer {
    private static final Logger log = LoggerFactory.getLogger(TempInBackCallBackConsumer.class);
    @Resource
    private BusinessOrderStrategyFactory businessOrderStrategyFactory;
    @Resource
    private IInventoryBatchService inventoryBatchService;
    @Resource
    private IWaitInspectionRecordDomain waitInspectionRecordDomain;
    @Resource
    private IPcpDictQueryApiProxy dictQueryApiProxy;
    @Resource
    private ItemDataQueryHelperImpl itemDataQueryHelper;

    @Override
    public String getFlag() {
        return "\u5165\u5e93\u56de\u4f20";
    }

    @Override
    @NotNull
    public MessageResponse doProcess(MessageVo messageVo) {
        log.info("\u57fa\u7840\u5355\u636e\u56de\u8c03\u6d88\u8d39\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        try {
            ReceiveDeliveryResultOrderContext source = (ReceiveDeliveryResultOrderContext)JSONObject.parseObject((String)((String)messageVo.getData()), ReceiveDeliveryResultOrderContext.class);
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e:{}", (Object)JSON.toJSONString((Object)source));
            AbstractBusinessOrder businessOrderStrategy = this.businessOrderStrategyFactory.createBusinessOrderStrategy(source.getRelevanceTableName());
            businessOrderStrategy.inBackEvent(source);
            this.updateInventoryBatchInspectionResult(source);
            this.saveWaitInspectionChangeRecord(source);
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)source));
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e\u5931\u8d25:{},{}", (Object)JSON.toJSONString((Object)messageVo), (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    private void saveWaitInspectionChangeRecord(ReceiveDeliveryResultOrderContext source) {
        ReceiveDeliveryResultOrderEo receiveResultOrderEo = source.getReceiveDeliveryResultOrderEo();
        if (!BaseOrderStatusEnum.RRO_RECEIVED.getCode().equals(receiveResultOrderEo.getOrderStatus())) {
            return;
        }
        DictDto dictDto = this.dictQueryApiProxy.querySameTableByGroupCodeAndCode(DictEnum.WAIT_INSPECTION_RECORD_TYPE.getGroupCode(), DictEnum.WAIT_INSPECTION_RECORD_TYPE.getCode());
        log.info("\u6839\u636e\u8d28\u68c0\u653e\u884c\u914d\u7f6ecode\u3010{}\u3011\u83b7\u53d6\u5b57\u5178\u8868\u4fe1\u606f\uff1a{}", (Object)DictEnum.WAIT_INSPECTION_RECORD_TYPE.getCode(), (Object)JSON.toJSONString((Object)dictDto));
        if (Objects.isNull(dictDto) || StringUtils.isBlank((CharSequence)dictDto.getValue())) {
            return;
        }
        List dictList = (List)JSON.parseObject((String)dictDto.getValue(), List.class);
        List newDictList = dictList.stream().filter(e -> e.getString("businessType").equals(receiveResultOrderEo.getDisplayBusinessType()) && e.getString("orderType").equals(receiveResultOrderEo.getJumpDocumentType())).collect(Collectors.toList());
        List detailEoList = source.getReceiveDeliveryResultOrderDetailEoList().stream().filter(e -> LogicWarehouseQualityEnum.WAIT_INSPECTION.getCode().equals(e.getInventoryProperty())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(newDictList) || CollectionUtils.isEmpty(detailEoList)) {
            return;
        }
        List skuCodeList = detailEoList.stream().map(ReceiveDeliveryResultOrderDetailEo::getSkuCode).distinct().collect(Collectors.toList());
        List itemSkuDgRespDtoList = Optional.ofNullable(this.itemDataQueryHelper.getByCodes(skuCodeList)).orElse(new ArrayList());
        Map<String, String> unitSkuCodeMap = itemSkuDgRespDtoList.stream().collect(Collectors.toMap(ItemSkuDto::getSkuCode, ItemSkuDto::getUnit, (o, o1) -> o));
        List recordEos = detailEoList.stream().map(e -> {
            WaitInspectionRecordEo recordEo = new WaitInspectionRecordEo();
            recordEo.setSkuCode(e.getSkuCode());
            recordEo.setSkuName(e.getSkuName());
            recordEo.setBatch(e.getBatch());
            recordEo.setQuantity(e.getDoneQuantity());
            recordEo.setWaitQuantity(e.getDoneQuantity());
            recordEo.setInventoryProperty(e.getInventoryProperty());
            recordEo.setUnit((String)unitSkuCodeMap.get(e.getSkuCode()));
            recordEo.setLogicWarehouseCode(receiveResultOrderEo.getReceiveLogicWarehouseCode());
            recordEo.setLogicWarehouseName(receiveResultOrderEo.getReceiveLogicWarehouseName());
            recordEo.setRelevanceNo(receiveResultOrderEo.getRelevanceNo());
            recordEo.setOrderType(receiveResultOrderEo.getJumpDocumentType());
            recordEo.setBusinessType(receiveResultOrderEo.getDisplayBusinessType());
            recordEo.setCreatePerson(receiveResultOrderEo.getCreatePerson());
            recordEo.setUpdatePerson(receiveResultOrderEo.getUpdatePerson());
            return recordEo;
        }).collect(Collectors.toList());
        this.waitInspectionRecordDomain.insertBatch(recordEos);
    }

    private void updateInventoryBatchInspectionResult(ReceiveDeliveryResultOrderContext source) {
        if (CsRelevanceTableNameEnum.PLAN_ORDER.equals((Object)source.getRelevanceTableName())) {
            return;
        }
        log.info("updateInventoryBatchInspectionResult");
        ArrayList skuCodeList = new ArrayList();
        ArrayList batchList = new ArrayList();
        List receiveResultOrderDetailEos = source.getReceiveDeliveryResultOrderDetailEoList().stream().filter(e -> LogicWarehouseQualityEnum.QUALIFIED.getCode().equals(e.getInventoryProperty())).peek(e -> {
            skuCodeList.add(e.getSkuCode());
            batchList.add(e.getBatch());
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(receiveResultOrderDetailEos)) {
            log.info("\u5165\u5e93\u5546\u54c1\u5e93\u5b58\u72b6\u6001\u975e\u6b63\u54c1\uff0c\u65e0\u9700\u65b0\u589e\u6279\u6b21\u6863\u6848");
            return;
        }
        InventoryBatchReqDto dto = new InventoryBatchReqDto();
        dto.setBatchList(batchList);
        dto.setSkuCodeList(skuCodeList);
        dto.setPageNum(Integer.valueOf(1));
        dto.setPageSize(Integer.valueOf(skuCodeList.size()));
        PageInfo pageInfo = this.inventoryBatchService.queryPage(dto);
        Map<Object, Object> inventoryBatchMap = new HashMap();
        if (Objects.nonNull(pageInfo) && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
            inventoryBatchMap = pageInfo.getList().stream().collect(Collectors.toMap(e -> e.getSkuCode() + InventoryConfig.getCommonSeparate() + e.getBatch(), Function.identity(), (k1, k2) -> k1));
        }
        ArrayList<InventoryBatchReqDto> dtos = new ArrayList<InventoryBatchReqDto>();
        for (ReceiveDeliveryResultOrderDetailEo receiveResultOrderDetailEo : receiveResultOrderDetailEos) {
            String key = receiveResultOrderDetailEo.getSkuCode() + InventoryConfig.getCommonSeparate() + receiveResultOrderDetailEo.getBatch();
            InventoryBatchDto inventoryBatchDto = (InventoryBatchDto)inventoryBatchMap.get(key);
            Date date = DateUtil.addMinutes((Date)new Date(), (int)-3);
            log.info("\u67e5\u8be2\u5230\u6279\u6b21\u6863\u6848\u4fe1\u606f\uff1a\u3010{}\u3011\uff0c\u83b7\u53d63\u5206\u949f\u524d\u7684\u65f6\u95f4\uff1a{}", (Object)JSON.toJSONString((Object)inventoryBatchDto), (Object)JSON.toJSONString((Object)date));
            if (Objects.nonNull(inventoryBatchDto) && (inventoryBatchDto.getCreateTime().before(date) || StringUtils.isNotEmpty((CharSequence)inventoryBatchDto.getInspectionResult()))) {
                log.info("\u8d28\u68c0\u62a5\u544a\u4e0d\u4e3a\u7a7a\uff0c\u4e14\u521b\u5efa\u65f6\u95f4\u5927\u4e8e3\u5206\u949f\u6216\u8d28\u68c0\u7ed3\u679c\u4e0d\u4e3a\u7a7a\uff0c\u4e0d\u66f4\u65b0\u8d28\u68c0\u7ed3\u679c\u4fe1\u606f");
                continue;
            }
            InventoryBatchReqDto inventoryBatchReqDto = new InventoryBatchReqDto();
            inventoryBatchReqDto.setSkuCode(receiveResultOrderDetailEo.getSkuCode());
            inventoryBatchReqDto.setBatch(receiveResultOrderDetailEo.getBatch());
            inventoryBatchReqDto.setInspectionResult(InspectionResultEnum.ELIGIBLE.getKey());
            dtos.add(inventoryBatchReqDto);
        }
        if (CollectionUtils.isNotEmpty(dtos)) {
            this.inventoryBatchService.save(dtos, Boolean.valueOf(false));
        }
    }
}

