/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc.advancedShipping;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.inventory.dto.entity.AdvancedShippingDto;
import com.yunxi.dg.base.center.inventory.service.business.order.AdvancedShippingOrderService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="NOTICE_ADVANCED_SHIPPING_TAG")
public class AdvancedShippingConsumer
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(AdvancedShippingConsumer.class);
    @Resource
    private AdvancedShippingOrderService advancedShippingOrderService;

    public MessageResponse process(String message) {
        log.info("advancedShippingConsumer \u6536\u5230\u9884\u53d1\u8d27\u6570\u636e\u7ec4\u88c5\u6d88\u606f: {}", (Object)message);
        try {
            AdvancedShippingDto shippingDto = (AdvancedShippingDto)JSONObject.parseObject((String)message, AdvancedShippingDto.class);
            String outNoticeOrderNo = shippingDto.getOutNoticeOrderNo();
            if (StrUtil.isBlank((CharSequence)outNoticeOrderNo)) {
                log.info("\u51fa\u5e93\u901a\u77e5\u5355\u53f7\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u5904\u7406");
                return MessageResponse.SUCCESS;
            }
            this.advancedShippingOrderService.orderSaleAdvancedShipping(shippingDto);
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.error("\u9884\u53d1\u8d27\u6570\u636e\u7ec4\u88c5\u6d88\u8d39\u5f02\u5e38", (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

