/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc.pda;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.inventory.context.InventoryConfig;
import com.yunxi.dg.base.center.inventory.mqc.AbstractBaseCallBackConsumer;
import com.yunxi.dg.base.center.inventory.pda.eo.LogisticsPrintReqTaskEo;
import com.yunxi.dg.base.center.inventory.service.pda.IDeliveryLogisticsService;
import com.yunxi.dg.base.center.pull.waybill.api.IWaybillApi;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="logisticsOrderPrint", msgType="publish")
public class LogisticsPrintProcess
extends AbstractBaseCallBackConsumer {
    private static final Logger log = LoggerFactory.getLogger(LogisticsPrintProcess.class);
    @Autowired
    private IWaybillApi waybillApi;
    @Resource
    private IDeliveryLogisticsService deliveryLogisticsService;

    @Override
    public String getFlag() {
        return "logisticsPrint";
    }

    @Override
    @NotNull
    public MessageResponse doProcess(MessageVo messageVo) {
        log.info("\u7535\u5b50\u9762\u5355\u6253\u5370\u6d88\u8d39\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        try {
            LogisticsPrintReqTaskEo logisticsPrintReqTaskEo = (LogisticsPrintReqTaskEo)JSONObject.parseObject((String)((String)messageVo.getData()), LogisticsPrintReqTaskEo.class);
            Long refRecordId = logisticsPrintReqTaskEo.getRefRecordId();
            InventoryConfig.executorNewTransaction(r -> {
                this.deliveryLogisticsService.executePrintAndWriteBack(refRecordId);
                return r;
            });
            log.info("\u7535\u5b50\u9762\u5355\u6253\u5370\u6d88\u8d39\u5b8c\u6210:{}", (Object)JSON.toJSONString((Object)logisticsPrintReqTaskEo));
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.info("\u7535\u5b50\u9762\u5355\u6253\u5370\u6d88\u8d39\u5931\u8d25:{},{}", (Object)JSON.toJSONString((Object)messageVo), (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }
}

