/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.mqc.share;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.enums.TransferGoodsStatusEnum;
import com.yunxi.dg.base.center.inventory.mqc.AbstractBaseCallBackConsumer;
import com.yunxi.dg.base.center.inventory.service.business.transfer.ITransferOrderService;
import com.yunxi.dg.base.center.message.TransferGoodsOrderDto;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@MQDesc(tag="transferGoodsOrderChange", msgType="publish")
@Component
public class TransferBorrowChangeConsumer
extends AbstractBaseCallBackConsumer {
    private static final Logger log = LoggerFactory.getLogger(TransferBorrowChangeConsumer.class);
    @Resource
    private ITransferOrderService transferOrderService;

    @Override
    public String getFlag() {
        return "\u501f\u8d27\u56de\u8c03";
    }

    @Override
    @NotNull
    public MessageResponse doProcess(MessageVo messageVo) {
        log.info(this.getFlag() + "\u6d88\u8d39\uff1a{}", (Object)JSONObject.toJSONString((Object)messageVo));
        String requestId = RequestId.createReqId();
        MDC.put((String)"yes.req.requestId", (String)requestId);
        try {
            TransferGoodsOrderDto source = (TransferGoodsOrderDto)JSONObject.parseObject((String)((String)messageVo.getData()), TransferGoodsOrderDto.class);
            log.info(this.getFlag() + "\u4e8b\u4ef6\u5904\u7406:{}", (Object)JSON.toJSONString((Object)source));
            this.process(source);
            log.info(this.getFlag() + "\u4e8b\u4ef6\u5904\u7406:{}", (Object)JSON.toJSONString((Object)source));
            return MessageResponse.SUCCESS;
        }
        catch (Exception e) {
            log.info("\u76d1\u542c\u4e8b\u52a1\u63d0\u4ea4\u4e8b\u4ef6\uff0c\u5904\u7406\u5165\u5e93\u56de\u4f20\u56de\u8c03\u4e1a\u52a1\u5355\u636e\u5931\u8d25:{},{}", (Object)JSON.toJSONString((Object)messageVo), (Object)e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return MessageResponse.ERROR;
        }
    }

    public void process(TransferGoodsOrderDto transferGoodsOrderDto) {
        TransferGoodsStatusEnum statusEnum = TransferGoodsStatusEnum.getByCode((String)transferGoodsOrderDto.getOrderStatus());
        if (statusEnum == null) {
            log.info("\u4f9b\u8d27\u56de\u4f20\u72b6\u6001\u4e0d\u5b58\u5728\uff0c\u4e0d\u5904\u7406\u3002\u3002");
            return;
        }
        this.transferOrderService.processBorrowGoods(transferGoodsOrderDto);
    }
}

