/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.other;

import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.api.other.IRelWarehouseShipmentApi;
import com.yunxi.dg.base.center.inventory.api.other.IRelWarehouseShipmentQueryApi;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentPageQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.RelWarehouseShipmentParamQueryDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentAddReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentGenerateReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.other.RelWarehouseShipmentUpdateReqDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentDetailRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentPageRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentParticularsRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.other.RelWarehouseShipmentRespDto;
import com.yunxi.dg.base.center.inventory.service.entity.IRelWarehouseShipmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/relWarehouseShipment"})
@Api(tags={"CsRelWarehouseShipmentRest"})
public class RelWarehouseShipmentController
implements IRelWarehouseShipmentApi,
IRelWarehouseShipmentQueryApi {
    private static Logger logger = LoggerFactory.getLogger(RelWarehouseShipmentController.class);
    @Resource
    private IRelWarehouseShipmentService relWarehouseShipmentService;

    @PostMapping(value={""}, produces={"application/json"})
    public RestResponse<Long> add(@Validated @RequestBody RelWarehouseShipmentAddReqDto addReqDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.add(addReqDto));
    }

    @PostMapping(value={"/{id}/update"}, produces={"application/json"})
    public RestResponse<Void> update(@PathVariable(value="id") Long id, @Validated @RequestBody RelWarehouseShipmentUpdateReqDto updateReqDto) {
        this.relWarehouseShipmentService.update(id, updateReqDto);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/{id}/delete"}, produces={"application/json"})
    public RestResponse<Void> delete(@PathVariable(value="id") Long id) {
        this.relWarehouseShipmentService.delete(id);
        return RestResponse.VOID;
    }

    @GetMapping(value={"/queryByPrimaryKey/{id}"}, produces={"application/json"})
    public RestResponse<RelWarehouseShipmentRespDto> queryByPrimaryKey(@PathVariable(value="id") Long id) {
        return new RestResponse((Object)this.relWarehouseShipmentService.selectByPrimaryKey(id));
    }

    @GetMapping(value={"/queryByWarehouseCode"}, produces={"application/json"})
    public RestResponse<RelWarehouseShipmentParticularsRespDto> queryByWarehouseCode(@RequestParam(value="warehouseCode") String warehouseCode) {
        return new RestResponse((Object)this.relWarehouseShipmentService.queryByWarehouseCode(warehouseCode));
    }

    @PostMapping(value={"/queryPage"}, produces={"application/json"})
    public RestResponse<PageInfo<RelWarehouseShipmentPageRespDto>> queryPage(@Validated @RequestBody RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.queryPage(relWarehouseShipmentPageQueryDto));
    }

    @PostMapping(value={"/queryRelInfoList"}, produces={"application/json"})
    public RestResponse<List<RelWarehouseShipmentPageRespDto>> queryRelInfoList(@Validated @RequestBody RelWarehouseShipmentPageQueryDto relWarehouseShipmentPageQueryDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.queryRelInfoList(relWarehouseShipmentPageQueryDto));
    }

    @PostMapping(value={"/queryByParam"}, produces={"application/json"})
    public RestResponse<List<RelWarehouseShipmentRespDto>> queryByParam(@Validated @RequestBody RelWarehouseShipmentParamQueryDto relWarehouseShipmentParamQueryDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.queryByParam(relWarehouseShipmentParamQueryDto));
    }

    @GetMapping(value={"/{warehouseCode}/queryHighestPriorityByWarehouseCode"}, produces={"application/json"})
    public RestResponse<RelWarehouseShipmentDetailRespDto> queryHighestPriorityByWarehouseCode(@PathVariable(value="warehouseCode") String warehouseCode) {
        return new RestResponse((Object)this.relWarehouseShipmentService.queryHighestPriorityByWarehouseCode(warehouseCode));
    }

    @PostMapping(value={"/generateRelInfo"}, produces={"application/json"})
    public RestResponse<Boolean> generateRelInfo(@Validated @RequestBody RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.generateRelInfo(relWarehouseShipmentGenerateReqDto));
    }

    @PostMapping(value={"/{warehouseCode}/deleteRelInfo"}, produces={"application/json"})
    public RestResponse<Void> deleteRelInfo(@PathVariable(value="warehouseCode") String warehouseCode) {
        this.relWarehouseShipmentService.deleteRelInfo(warehouseCode);
        return RestResponse.VOID;
    }

    @PostMapping(value={"/editRelInfo"}, produces={"application/json"})
    public RestResponse<Boolean> editRelInfo(@Validated @RequestBody RelWarehouseShipmentGenerateReqDto relWarehouseShipmentGenerateReqDto) {
        return new RestResponse((Object)this.relWarehouseShipmentService.editRelInfo(relWarehouseShipmentGenerateReqDto));
    }

    @PostMapping(value={"/importRelInfo"}, produces={"application/json"})
    @ApiOperation(value="\u5bfc\u5165\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f", notes="\u5bfc\u5165\u4ed3\u5e93\u7269\u6d41\u7ba1\u7406\u4fe1\u606f")
    public RestResponse<Integer> importRelInfo(@Validated @RequestBody List<RelWarehouseShipmentGenerateReqDto> relWarehouseShipmentGenerateReqDtos) {
        return new RestResponse((Object)this.relWarehouseShipmentService.importRelInfo(relWarehouseShipmentGenerateReqDtos));
    }
}

