/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.inventory.rest.pda;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.lock.api.ILockService;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.api.pda.IDeliveryLogisticsApi;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CallBackPrintReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CancelLogisticsOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.CreateShipOrderReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryInfoDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryInfoQueryDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryOrderInfoRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.DeliveryOrderUpdateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsDeliveryOrderRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsOrderCancelReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsOrderThirdTemplateReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsSubscriptionSearchReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.LogisticsTemplateRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.ShipOrderPrintReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.ShipOrderPrintRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WarehouseDeliveryReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WarehouseDeliveryRespDto;
import com.yunxi.dg.base.center.inventory.dto.entity.pda.WaybillSubscriptionInfoDto;
import com.yunxi.dg.base.center.inventory.dto.response.transfer.BatchOrderOperationMsgDto;
import com.yunxi.dg.base.center.inventory.service.pda.IDeliveryLogisticsService;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/deliveryLogistics"})
public class DeliveryLogisticsRest
implements IDeliveryLogisticsApi {
    @Resource
    private IDeliveryLogisticsService deliveryLogisticsService;
    @Resource
    private ILockService lockService;
    private static final String TABLENAME = "create_ship_order_table";

    public RestResponse<LogisticsDeliveryOrderRespDto> createShipOrder(@RequestBody CreateShipOrderReqDto reqDto) {
        RestResponse restResponse;
        block6: {
            Mutex mutex = null;
            try {
                String key = "create_ship_order_" + reqDto.getId();
                mutex = this.lockService.lock(TABLENAME, key, 10, 20, TimeUnit.SECONDS);
                if (null == mutex) {
                    throw new BizException("\u7cfb\u7edf\u7e41\u5fd9\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                }
                restResponse = new RestResponse((Object)this.deliveryLogisticsService.createShipOrder(reqDto));
                if (mutex == null) break block6;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    throw new BizException(e.getMessage());
                }
                catch (Throwable throwable) {
                    if (mutex != null) {
                        this.lockService.unlock(mutex);
                    }
                    throw throwable;
                }
            }
            this.lockService.unlock(mutex);
        }
        return restResponse;
    }

    public RestResponse<Void> retryPrintById(@RequestParam(value="id") Long id) {
        this.deliveryLogisticsService.executePrintAndWriteBack(id);
        return RestResponse.VOID;
    }

    public RestResponse<List<ShipOrderPrintRespDto>> shipOrderPrint(@RequestBody List<ShipOrderPrintReqDto> shipOrderPrintReqDtoList) {
        return new RestResponse((Object)this.deliveryLogisticsService.shipOrderPrint(shipOrderPrintReqDtoList));
    }

    public RestResponse<List<LogisticsDeliveryOrderRespDto>> batchCreateShipOrder(@RequestBody List<CreateShipOrderReqDto> reqDtoList) {
        return new RestResponse((Object)this.deliveryLogisticsService.batchCreateShipOrder(reqDtoList));
    }

    public RestResponse<List<LogisticsTemplateRespDto>> getTemplateList(@RequestBody LogisticsOrderThirdTemplateReqDto logisticsOrderCancelReqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.getTemplateList(logisticsOrderCancelReqDto));
    }

    public RestResponse<List<WaybillSubscriptionInfoDto>> subscriptionSearch(@RequestBody LogisticsSubscriptionSearchReqDto logisticsSubscriptionSearchReqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.subscriptionSearch(logisticsSubscriptionSearchReqDto));
    }

    public RestResponse<CancelLogisticsOrderRespDto> cancel(@RequestBody LogisticsOrderCancelReqDto logisticsOrderCancelReqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.cancel(logisticsOrderCancelReqDto));
    }

    public RestResponse<CancelLogisticsOrderRespDto> saleOrderCancel(@RequestParam(value="saleOrderNo") String saleOrderNo) {
        return new RestResponse((Object)this.deliveryLogisticsService.saleOrderCancel(saleOrderNo));
    }

    public RestResponse<Void> printCallback(@RequestBody List<CallBackPrintReqDto> callBackPrintReqDtoList) {
        this.deliveryLogisticsService.printCallback(callBackPrintReqDtoList);
        return RestResponse.VOID;
    }

    public RestResponse<List<WarehouseDeliveryRespDto>> warehouseDelivery(@RequestBody WarehouseDeliveryReqDto warehouseDeliveryReqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.warehouseDelivery(warehouseDeliveryReqDto));
    }

    public RestResponse<List<DeliveryOrderInfoRespDto>> queryDeliveryByParam(@RequestBody DeliveryInfoQueryDto deliveryInfoQueryDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.queryDeliveryByParam(deliveryInfoQueryDto));
    }

    public RestResponse<Void> updateDeliveryInfo(@RequestBody DeliveryInfoDto deliveryInfoDto) {
        this.deliveryLogisticsService.updateDeliveryInfo(deliveryInfoDto);
        return RestResponse.VOID;
    }

    public RestResponse<BatchOrderOperationMsgDto> updateLogisticsOrderStatus(@RequestBody DeliveryOrderUpdateReqDto reqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.updateLogisticsOrderStatus(reqDto));
    }

    public RestResponse<Void> printPickingOrderCallback(@RequestBody List<CallBackPrintReqDto> reqDto) {
        this.deliveryLogisticsService.printPickingOrderCallback(reqDto);
        return RestResponse.VOID;
    }

    public RestResponse<Void> batchUpdateDeliveryInfo(@RequestBody List<DeliveryInfoDto> reqDto) {
        this.deliveryLogisticsService.batchUpdateDeliveryInfo(reqDto);
        return new RestResponse();
    }

    public RestResponse<String> generatePickingOrderNo() {
        return new RestResponse((Object)this.deliveryLogisticsService.generatePickingOrderNo());
    }

    public RestResponse<BatchOrderOperationMsgDto> batchUpdateShippingCompany(@RequestBody List<DeliveryInfoDto> reqDto) {
        return new RestResponse((Object)this.deliveryLogisticsService.batchUpdateShippingCompany(reqDto));
    }
}

